# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.12.3
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cdbApi.api_client import ApiClient
from cdbApi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MachineDesignItemsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def clear_assigned_item(self, md_item_id, **kwargs):  # noqa: E501
        """Update assigned item in a machine design item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_assigned_item(md_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int md_item_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemDomainMachineDesign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clear_assigned_item_with_http_info(md_item_id, **kwargs)  # noqa: E501

    def clear_assigned_item_with_http_info(self, md_item_id, **kwargs):  # noqa: E501
        """Update assigned item in a machine design item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_assigned_item_with_http_info(md_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int md_item_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemDomainMachineDesign, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'md_item_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_assigned_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'md_item_id' is set
        if self.api_client.client_side_validation and ('md_item_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['md_item_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `md_item_id` when calling `clear_assigned_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'md_item_id' in local_var_params:
            path_params['mdItemId'] = local_var_params['md_item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/ClearAssignedItem/{mdItemId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemDomainMachineDesign',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_control_element(self, new_machine_placeholder_options, **kwargs):  # noqa: E501
        """Create machine control top level item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_control_element(new_machine_placeholder_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param NewMachinePlaceholderOptions new_machine_placeholder_options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemDomainMachineDesign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_control_element_with_http_info(new_machine_placeholder_options, **kwargs)  # noqa: E501

    def create_control_element_with_http_info(self, new_machine_placeholder_options, **kwargs):  # noqa: E501
        """Create machine control top level item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_control_element_with_http_info(new_machine_placeholder_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param NewMachinePlaceholderOptions new_machine_placeholder_options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemDomainMachineDesign, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'new_machine_placeholder_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_control_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'new_machine_placeholder_options' is set
        if self.api_client.client_side_validation and ('new_machine_placeholder_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['new_machine_placeholder_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `new_machine_placeholder_options` when calling `create_control_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_machine_placeholder_options' in local_var_params:
            body_params = local_var_params['new_machine_placeholder_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/createControlElement', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemDomainMachineDesign',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_control_relationship(self, new_control_relationship_information, **kwargs):  # noqa: E501
        """Create machine control relationship.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_control_relationship(new_control_relationship_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param NewControlRelationshipInformation new_control_relationship_information: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemElementRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_control_relationship_with_http_info(new_control_relationship_information, **kwargs)  # noqa: E501

    def create_control_relationship_with_http_info(self, new_control_relationship_information, **kwargs):  # noqa: E501
        """Create machine control relationship.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_control_relationship_with_http_info(new_control_relationship_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param NewControlRelationshipInformation new_control_relationship_information: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemElementRelationship, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'new_control_relationship_information'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_control_relationship" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'new_control_relationship_information' is set
        if self.api_client.client_side_validation and ('new_control_relationship_information' not in local_var_params or  # noqa: E501
                                                        local_var_params['new_control_relationship_information'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `new_control_relationship_information` when calling `create_control_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_control_relationship_information' in local_var_params:
            body_params = local_var_params['new_control_relationship_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/createControlRelationship', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemElementRelationship',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_placeholder(self, parent_md_id, new_machine_placeholder_options, **kwargs):  # noqa: E501
        """Create machine placeholder item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_placeholder(parent_md_id, new_machine_placeholder_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int parent_md_id: (required)
        :param NewMachinePlaceholderOptions new_machine_placeholder_options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemDomainMachineDesign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_placeholder_with_http_info(parent_md_id, new_machine_placeholder_options, **kwargs)  # noqa: E501

    def create_placeholder_with_http_info(self, parent_md_id, new_machine_placeholder_options, **kwargs):  # noqa: E501
        """Create machine placeholder item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_placeholder_with_http_info(parent_md_id, new_machine_placeholder_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int parent_md_id: (required)
        :param NewMachinePlaceholderOptions new_machine_placeholder_options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemDomainMachineDesign, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'parent_md_id',
            'new_machine_placeholder_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_placeholder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'parent_md_id' is set
        if self.api_client.client_side_validation and ('parent_md_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['parent_md_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `parent_md_id` when calling `create_placeholder`")  # noqa: E501
        # verify the required parameter 'new_machine_placeholder_options' is set
        if self.api_client.client_side_validation and ('new_machine_placeholder_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['new_machine_placeholder_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `new_machine_placeholder_options` when calling `create_placeholder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'parent_md_id' in local_var_params:
            path_params['parentMdId'] = local_var_params['parent_md_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_machine_placeholder_options' in local_var_params:
            body_params = local_var_params['new_machine_placeholder_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/createPlaceholder/{parentMdId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemDomainMachineDesign',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_detailed_md_search_results(self, search_text, **kwargs):  # noqa: E501
        """get_detailed_md_search_results  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_detailed_md_search_results(search_text, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str search_text: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ItemDomainMdSearchResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_detailed_md_search_results_with_http_info(search_text, **kwargs)  # noqa: E501

    def get_detailed_md_search_results_with_http_info(self, search_text, **kwargs):  # noqa: E501
        """get_detailed_md_search_results  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_detailed_md_search_results_with_http_info(search_text, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str search_text: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ItemDomainMdSearchResult], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'search_text'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_detailed_md_search_results" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'search_text' is set
        if self.api_client.client_side_validation and ('search_text' not in local_var_params or  # noqa: E501
                                                        local_var_params['search_text'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `search_text` when calling `get_detailed_md_search_results`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'search_text' in local_var_params:
            path_params['searchText'] = local_var_params['search_text']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/DetailedMachineDesignSearch/{searchText}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ItemDomainMdSearchResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hierarchy_id_list(self, item_domain_machine_design_id_list_request, **kwargs):  # noqa: E501
        """get_hierarchy_id_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hierarchy_id_list(item_domain_machine_design_id_list_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ItemDomainMachineDesignIdListRequest item_domain_machine_design_id_list_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_hierarchy_id_list_with_http_info(item_domain_machine_design_id_list_request, **kwargs)  # noqa: E501

    def get_hierarchy_id_list_with_http_info(self, item_domain_machine_design_id_list_request, **kwargs):  # noqa: E501
        """get_hierarchy_id_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hierarchy_id_list_with_http_info(item_domain_machine_design_id_list_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ItemDomainMachineDesignIdListRequest item_domain_machine_design_id_list_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[int], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'item_domain_machine_design_id_list_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hierarchy_id_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_domain_machine_design_id_list_request' is set
        if self.api_client.client_side_validation and ('item_domain_machine_design_id_list_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['item_domain_machine_design_id_list_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `item_domain_machine_design_id_list_request` when calling `get_hierarchy_id_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_domain_machine_design_id_list_request' in local_var_params:
            body_params = local_var_params['item_domain_machine_design_id_list_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/IdList', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[int]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_design_item_by_id(self, id, **kwargs):  # noqa: E501
        """get_machine_design_item_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_design_item_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemDomainMachineDesign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_machine_design_item_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def get_machine_design_item_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_machine_design_item_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_design_item_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemDomainMachineDesign, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_design_item_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_machine_design_item_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/ById/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemDomainMachineDesign',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_design_item_list(self, **kwargs):  # noqa: E501
        """get_machine_design_item_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_design_item_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ItemDomainMachineDesign]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_machine_design_item_list_with_http_info(**kwargs)  # noqa: E501

    def get_machine_design_item_list_with_http_info(self, **kwargs):  # noqa: E501
        """get_machine_design_item_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_design_item_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ItemDomainMachineDesign], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_design_item_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ItemDomainMachineDesign]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_design_items_by_name(self, name, **kwargs):  # noqa: E501
        """get_machine_design_items_by_name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_design_items_by_name(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ItemDomainMachineDesign]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_machine_design_items_by_name_with_http_info(name, **kwargs)  # noqa: E501

    def get_machine_design_items_by_name_with_http_info(self, name, **kwargs):  # noqa: E501
        """get_machine_design_items_by_name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_design_items_by_name_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ItemDomainMachineDesign], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_design_items_by_name" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `get_machine_design_items_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/ByName/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ItemDomainMachineDesign]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_design_items_by_name_pattern(self, name_pattern, **kwargs):  # noqa: E501
        """get_machine_design_items_by_name_pattern  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_design_items_by_name_pattern(name_pattern, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name_pattern: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ItemDomainMachineDesign]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_machine_design_items_by_name_pattern_with_http_info(name_pattern, **kwargs)  # noqa: E501

    def get_machine_design_items_by_name_pattern_with_http_info(self, name_pattern, **kwargs):  # noqa: E501
        """get_machine_design_items_by_name_pattern  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_design_items_by_name_pattern_with_http_info(name_pattern, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name_pattern: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ItemDomainMachineDesign], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name_pattern'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_design_items_by_name_pattern" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name_pattern' is set
        if self.api_client.client_side_validation and ('name_pattern' not in local_var_params or  # noqa: E501
                                                        local_var_params['name_pattern'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name_pattern` when calling `get_machine_design_items_by_name_pattern`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name_pattern' in local_var_params:
            path_params['namePattern'] = local_var_params['name_pattern']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/ByNamePattern/{namePattern}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ItemDomainMachineDesign]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_md_in_hierarchy_by_name(self, root, container, name, **kwargs):  # noqa: E501
        """get_md_in_hierarchy_by_name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_md_in_hierarchy_by_name(root, container, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str root: (required)
        :param str container: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ItemDomainMachineDesign]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_md_in_hierarchy_by_name_with_http_info(root, container, name, **kwargs)  # noqa: E501

    def get_md_in_hierarchy_by_name_with_http_info(self, root, container, name, **kwargs):  # noqa: E501
        """get_md_in_hierarchy_by_name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_md_in_hierarchy_by_name_with_http_info(root, container, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str root: (required)
        :param str container: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ItemDomainMachineDesign], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'root',
            'container',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_md_in_hierarchy_by_name" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'root' is set
        if self.api_client.client_side_validation and ('root' not in local_var_params or  # noqa: E501
                                                        local_var_params['root'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `root` when calling `get_md_in_hierarchy_by_name`")  # noqa: E501
        # verify the required parameter 'container' is set
        if self.api_client.client_side_validation and ('container' not in local_var_params or  # noqa: E501
                                                        local_var_params['container'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container` when calling `get_md_in_hierarchy_by_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `get_md_in_hierarchy_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'root' in local_var_params:
            path_params['root'] = local_var_params['root']  # noqa: E501
        if 'container' in local_var_params:
            path_params['container'] = local_var_params['container']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/ByHierarchy/{root}/{container}/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ItemDomainMachineDesign]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_machine(self, md_id, new_parent_id, **kwargs):  # noqa: E501
        """Move machine to a new parent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_machine(md_id, new_parent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int md_id: (required)
        :param int new_parent_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemElement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.move_machine_with_http_info(md_id, new_parent_id, **kwargs)  # noqa: E501

    def move_machine_with_http_info(self, md_id, new_parent_id, **kwargs):  # noqa: E501
        """Move machine to a new parent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_machine_with_http_info(md_id, new_parent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int md_id: (required)
        :param int new_parent_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemElement, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'md_id',
            'new_parent_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_machine" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'md_id' is set
        if self.api_client.client_side_validation and ('md_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['md_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `md_id` when calling `move_machine`")  # noqa: E501
        # verify the required parameter 'new_parent_id' is set
        if self.api_client.client_side_validation and ('new_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['new_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `new_parent_id` when calling `move_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'md_id' in local_var_params:
            path_params['mdId'] = local_var_params['md_id']  # noqa: E501
        if 'new_parent_id' in local_var_params:
            path_params['newParentId'] = local_var_params['new_parent_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/moveMachine/{mdId}/{newParentId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemElement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def promote_assembly_element_to_machine(self, promote_machine_element_information, **kwargs):  # noqa: E501
        """Create a machine design that represents an assembly element that is assigned to machine hierarchy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.promote_assembly_element_to_machine(promote_machine_element_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PromoteMachineElementInformation promote_machine_element_information: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemDomainMachineDesign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.promote_assembly_element_to_machine_with_http_info(promote_machine_element_information, **kwargs)  # noqa: E501

    def promote_assembly_element_to_machine_with_http_info(self, promote_machine_element_information, **kwargs):  # noqa: E501
        """Create a machine design that represents an assembly element that is assigned to machine hierarchy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.promote_assembly_element_to_machine_with_http_info(promote_machine_element_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PromoteMachineElementInformation promote_machine_element_information: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemDomainMachineDesign, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'promote_machine_element_information'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method promote_assembly_element_to_machine" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'promote_machine_element_information' is set
        if self.api_client.client_side_validation and ('promote_machine_element_information' not in local_var_params or  # noqa: E501
                                                        local_var_params['promote_machine_element_information'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `promote_machine_element_information` when calling `promote_assembly_element_to_machine`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'promote_machine_element_information' in local_var_params:
            body_params = local_var_params['promote_machine_element_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/PromoteMachineElement', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemDomainMachineDesign',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_assigned_item(self, update_machine_assigned_item_information, **kwargs):  # noqa: E501
        """Update assigned item in a machine design item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_assigned_item(update_machine_assigned_item_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateMachineAssignedItemInformation update_machine_assigned_item_information: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemDomainMachineDesign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_assigned_item_with_http_info(update_machine_assigned_item_information, **kwargs)  # noqa: E501

    def update_assigned_item_with_http_info(self, update_machine_assigned_item_information, **kwargs):  # noqa: E501
        """Update assigned item in a machine design item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_assigned_item_with_http_info(update_machine_assigned_item_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateMachineAssignedItemInformation update_machine_assigned_item_information: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemDomainMachineDesign, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'update_machine_assigned_item_information'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_assigned_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'update_machine_assigned_item_information' is set
        if self.api_client.client_side_validation and ('update_machine_assigned_item_information' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_machine_assigned_item_information'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_machine_assigned_item_information` when calling `update_assigned_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_machine_assigned_item_information' in local_var_params:
            body_params = local_var_params['update_machine_assigned_item_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/UpdateAssignedItem', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemDomainMachineDesign',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_assigned_item_deprecated(self, md_item_id, assigned_item_id, **kwargs):  # noqa: E501
        """Update assigned item in a machine design item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_assigned_item_deprecated(md_item_id, assigned_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int md_item_id: (required)
        :param int assigned_item_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemDomainMachineDesign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_assigned_item_deprecated_with_http_info(md_item_id, assigned_item_id, **kwargs)  # noqa: E501

    def update_assigned_item_deprecated_with_http_info(self, md_item_id, assigned_item_id, **kwargs):  # noqa: E501
        """Update assigned item in a machine design item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_assigned_item_deprecated_with_http_info(md_item_id, assigned_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int md_item_id: (required)
        :param int assigned_item_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemDomainMachineDesign, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'md_item_id',
            'assigned_item_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_assigned_item_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'md_item_id' is set
        if self.api_client.client_side_validation and ('md_item_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['md_item_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `md_item_id` when calling `update_assigned_item_deprecated`")  # noqa: E501
        # verify the required parameter 'assigned_item_id' is set
        if self.api_client.client_side_validation and ('assigned_item_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['assigned_item_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `assigned_item_id` when calling `update_assigned_item_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'md_item_id' in local_var_params:
            path_params['mdItemId'] = local_var_params['md_item_id']  # noqa: E501
        if 'assigned_item_id' in local_var_params:
            path_params['assignedItemId'] = local_var_params['assigned_item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/MachineDesignItems/UpdateAssignedItem/{mdItemId}/{assignedItemId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemDomainMachineDesign',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
