# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.12.3
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from cdbApi.configuration import Configuration


class EntityType(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'description': 'str',
        'allowed_entity_type_list': 'list[EntityType]',
        'entity_type_list1': 'list[EntityType]',
        'item_list': 'list[Item]',
        'property_type_list': 'list[PropertyType]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'allowed_entity_type_list': 'allowedEntityTypeList',
        'entity_type_list1': 'entityTypeList1',
        'item_list': 'itemList',
        'property_type_list': 'propertyTypeList'
    }

    def __init__(self, id=None, name=None, description=None, allowed_entity_type_list=None, entity_type_list1=None, item_list=None, property_type_list=None, local_vars_configuration=None):  # noqa: E501
        """EntityType - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._description = None
        self._allowed_entity_type_list = None
        self._entity_type_list1 = None
        self._item_list = None
        self._property_type_list = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        if description is not None:
            self.description = description
        if allowed_entity_type_list is not None:
            self.allowed_entity_type_list = allowed_entity_type_list
        if entity_type_list1 is not None:
            self.entity_type_list1 = entity_type_list1
        if item_list is not None:
            self.item_list = item_list
        if property_type_list is not None:
            self.property_type_list = property_type_list

    @property
    def id(self):
        """Gets the id of this EntityType.  # noqa: E501


        :return: The id of this EntityType.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EntityType.


        :param id: The id of this EntityType.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this EntityType.  # noqa: E501


        :return: The name of this EntityType.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EntityType.


        :param name: The name of this EntityType.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this EntityType.  # noqa: E501


        :return: The description of this EntityType.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this EntityType.


        :param description: The description of this EntityType.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 256):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def allowed_entity_type_list(self):
        """Gets the allowed_entity_type_list of this EntityType.  # noqa: E501


        :return: The allowed_entity_type_list of this EntityType.  # noqa: E501
        :rtype: list[EntityType]
        """
        return self._allowed_entity_type_list

    @allowed_entity_type_list.setter
    def allowed_entity_type_list(self, allowed_entity_type_list):
        """Sets the allowed_entity_type_list of this EntityType.


        :param allowed_entity_type_list: The allowed_entity_type_list of this EntityType.  # noqa: E501
        :type: list[EntityType]
        """

        self._allowed_entity_type_list = allowed_entity_type_list

    @property
    def entity_type_list1(self):
        """Gets the entity_type_list1 of this EntityType.  # noqa: E501


        :return: The entity_type_list1 of this EntityType.  # noqa: E501
        :rtype: list[EntityType]
        """
        return self._entity_type_list1

    @entity_type_list1.setter
    def entity_type_list1(self, entity_type_list1):
        """Sets the entity_type_list1 of this EntityType.


        :param entity_type_list1: The entity_type_list1 of this EntityType.  # noqa: E501
        :type: list[EntityType]
        """

        self._entity_type_list1 = entity_type_list1

    @property
    def item_list(self):
        """Gets the item_list of this EntityType.  # noqa: E501


        :return: The item_list of this EntityType.  # noqa: E501
        :rtype: list[Item]
        """
        return self._item_list

    @item_list.setter
    def item_list(self, item_list):
        """Sets the item_list of this EntityType.


        :param item_list: The item_list of this EntityType.  # noqa: E501
        :type: list[Item]
        """

        self._item_list = item_list

    @property
    def property_type_list(self):
        """Gets the property_type_list of this EntityType.  # noqa: E501


        :return: The property_type_list of this EntityType.  # noqa: E501
        :rtype: list[PropertyType]
        """
        return self._property_type_list

    @property_type_list.setter
    def property_type_list(self, property_type_list):
        """Sets the property_type_list of this EntityType.


        :param property_type_list: The property_type_list of this EntityType.  # noqa: E501
        :type: list[PropertyType]
        """

        self._property_type_list = property_type_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EntityType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EntityType):
            return True

        return self.to_dict() != other.to_dict()
