# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.12.3
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from cdbApi.configuration import Configuration


class ItemResource(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'value': 'str',
        'units': 'str',
        'description': 'str',
        'is_provided': 'bool',
        'is_used_required': 'bool',
        'is_used_optional': 'bool',
        'item': 'Item',
        'resource_type': 'ResourceType',
        'item_connector': 'ItemConnector'
    }

    attribute_map = {
        'id': 'id',
        'value': 'value',
        'units': 'units',
        'description': 'description',
        'is_provided': 'isProvided',
        'is_used_required': 'isUsedRequired',
        'is_used_optional': 'isUsedOptional',
        'item': 'item',
        'resource_type': 'resourceType',
        'item_connector': 'itemConnector'
    }

    def __init__(self, id=None, value=None, units=None, description=None, is_provided=None, is_used_required=None, is_used_optional=None, item=None, resource_type=None, item_connector=None, local_vars_configuration=None):  # noqa: E501
        """ItemResource - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._value = None
        self._units = None
        self._description = None
        self._is_provided = None
        self._is_used_required = None
        self._is_used_optional = None
        self._item = None
        self._resource_type = None
        self._item_connector = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if value is not None:
            self.value = value
        if units is not None:
            self.units = units
        if description is not None:
            self.description = description
        if is_provided is not None:
            self.is_provided = is_provided
        if is_used_required is not None:
            self.is_used_required = is_used_required
        if is_used_optional is not None:
            self.is_used_optional = is_used_optional
        if item is not None:
            self.item = item
        if resource_type is not None:
            self.resource_type = resource_type
        if item_connector is not None:
            self.item_connector = item_connector

    @property
    def id(self):
        """Gets the id of this ItemResource.  # noqa: E501


        :return: The id of this ItemResource.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ItemResource.


        :param id: The id of this ItemResource.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def value(self):
        """Gets the value of this ItemResource.  # noqa: E501


        :return: The value of this ItemResource.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this ItemResource.


        :param value: The value of this ItemResource.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                value is not None and len(value) > 64):
            raise ValueError("Invalid value for `value`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                value is not None and len(value) < 0):
            raise ValueError("Invalid value for `value`, length must be greater than or equal to `0`")  # noqa: E501

        self._value = value

    @property
    def units(self):
        """Gets the units of this ItemResource.  # noqa: E501


        :return: The units of this ItemResource.  # noqa: E501
        :rtype: str
        """
        return self._units

    @units.setter
    def units(self, units):
        """Sets the units of this ItemResource.


        :param units: The units of this ItemResource.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                units is not None and len(units) > 64):
            raise ValueError("Invalid value for `units`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                units is not None and len(units) < 0):
            raise ValueError("Invalid value for `units`, length must be greater than or equal to `0`")  # noqa: E501

        self._units = units

    @property
    def description(self):
        """Gets the description of this ItemResource.  # noqa: E501


        :return: The description of this ItemResource.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ItemResource.


        :param description: The description of this ItemResource.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 256):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def is_provided(self):
        """Gets the is_provided of this ItemResource.  # noqa: E501


        :return: The is_provided of this ItemResource.  # noqa: E501
        :rtype: bool
        """
        return self._is_provided

    @is_provided.setter
    def is_provided(self, is_provided):
        """Sets the is_provided of this ItemResource.


        :param is_provided: The is_provided of this ItemResource.  # noqa: E501
        :type: bool
        """

        self._is_provided = is_provided

    @property
    def is_used_required(self):
        """Gets the is_used_required of this ItemResource.  # noqa: E501


        :return: The is_used_required of this ItemResource.  # noqa: E501
        :rtype: bool
        """
        return self._is_used_required

    @is_used_required.setter
    def is_used_required(self, is_used_required):
        """Sets the is_used_required of this ItemResource.


        :param is_used_required: The is_used_required of this ItemResource.  # noqa: E501
        :type: bool
        """

        self._is_used_required = is_used_required

    @property
    def is_used_optional(self):
        """Gets the is_used_optional of this ItemResource.  # noqa: E501


        :return: The is_used_optional of this ItemResource.  # noqa: E501
        :rtype: bool
        """
        return self._is_used_optional

    @is_used_optional.setter
    def is_used_optional(self, is_used_optional):
        """Sets the is_used_optional of this ItemResource.


        :param is_used_optional: The is_used_optional of this ItemResource.  # noqa: E501
        :type: bool
        """

        self._is_used_optional = is_used_optional

    @property
    def item(self):
        """Gets the item of this ItemResource.  # noqa: E501


        :return: The item of this ItemResource.  # noqa: E501
        :rtype: Item
        """
        return self._item

    @item.setter
    def item(self, item):
        """Sets the item of this ItemResource.


        :param item: The item of this ItemResource.  # noqa: E501
        :type: Item
        """

        self._item = item

    @property
    def resource_type(self):
        """Gets the resource_type of this ItemResource.  # noqa: E501


        :return: The resource_type of this ItemResource.  # noqa: E501
        :rtype: ResourceType
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this ItemResource.


        :param resource_type: The resource_type of this ItemResource.  # noqa: E501
        :type: ResourceType
        """

        self._resource_type = resource_type

    @property
    def item_connector(self):
        """Gets the item_connector of this ItemResource.  # noqa: E501


        :return: The item_connector of this ItemResource.  # noqa: E501
        :rtype: ItemConnector
        """
        return self._item_connector

    @item_connector.setter
    def item_connector(self, item_connector):
        """Sets the item_connector of this ItemResource.


        :param item_connector: The item_connector of this ItemResource.  # noqa: E501
        :type: ItemConnector
        """

        self._item_connector = item_connector

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemResource):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ItemResource):
            return True

        return self.to_dict() != other.to_dict()
