# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.12.3
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from cdbApi.configuration import Configuration


class ResourceType(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'description': 'str',
        'handler_name': 'str',
        'default_value': 'str',
        'default_units': 'str',
        'resource_type_category': 'ResourceTypeCategory',
        'item_element_relationship_history_list': 'list[ItemElementRelationshipHistory]',
        'connector_list': 'list[Connector]',
        'item_resource_list': 'list[ItemResource]',
        'item_element_relationship_list': 'list[ItemElementRelationship]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'handler_name': 'handlerName',
        'default_value': 'defaultValue',
        'default_units': 'defaultUnits',
        'resource_type_category': 'resourceTypeCategory',
        'item_element_relationship_history_list': 'itemElementRelationshipHistoryList',
        'connector_list': 'connectorList',
        'item_resource_list': 'itemResourceList',
        'item_element_relationship_list': 'itemElementRelationshipList'
    }

    def __init__(self, id=None, name=None, description=None, handler_name=None, default_value=None, default_units=None, resource_type_category=None, item_element_relationship_history_list=None, connector_list=None, item_resource_list=None, item_element_relationship_list=None, local_vars_configuration=None):  # noqa: E501
        """ResourceType - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._description = None
        self._handler_name = None
        self._default_value = None
        self._default_units = None
        self._resource_type_category = None
        self._item_element_relationship_history_list = None
        self._connector_list = None
        self._item_resource_list = None
        self._item_element_relationship_list = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        if description is not None:
            self.description = description
        if handler_name is not None:
            self.handler_name = handler_name
        if default_value is not None:
            self.default_value = default_value
        if default_units is not None:
            self.default_units = default_units
        if resource_type_category is not None:
            self.resource_type_category = resource_type_category
        if item_element_relationship_history_list is not None:
            self.item_element_relationship_history_list = item_element_relationship_history_list
        if connector_list is not None:
            self.connector_list = connector_list
        if item_resource_list is not None:
            self.item_resource_list = item_resource_list
        if item_element_relationship_list is not None:
            self.item_element_relationship_list = item_element_relationship_list

    @property
    def id(self):
        """Gets the id of this ResourceType.  # noqa: E501


        :return: The id of this ResourceType.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ResourceType.


        :param id: The id of this ResourceType.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ResourceType.  # noqa: E501


        :return: The name of this ResourceType.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ResourceType.


        :param name: The name of this ResourceType.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this ResourceType.  # noqa: E501


        :return: The description of this ResourceType.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ResourceType.


        :param description: The description of this ResourceType.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 256):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def handler_name(self):
        """Gets the handler_name of this ResourceType.  # noqa: E501


        :return: The handler_name of this ResourceType.  # noqa: E501
        :rtype: str
        """
        return self._handler_name

    @handler_name.setter
    def handler_name(self, handler_name):
        """Sets the handler_name of this ResourceType.


        :param handler_name: The handler_name of this ResourceType.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                handler_name is not None and len(handler_name) > 64):
            raise ValueError("Invalid value for `handler_name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                handler_name is not None and len(handler_name) < 0):
            raise ValueError("Invalid value for `handler_name`, length must be greater than or equal to `0`")  # noqa: E501

        self._handler_name = handler_name

    @property
    def default_value(self):
        """Gets the default_value of this ResourceType.  # noqa: E501


        :return: The default_value of this ResourceType.  # noqa: E501
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """Sets the default_value of this ResourceType.


        :param default_value: The default_value of this ResourceType.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_value is not None and len(default_value) > 64):
            raise ValueError("Invalid value for `default_value`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                default_value is not None and len(default_value) < 0):
            raise ValueError("Invalid value for `default_value`, length must be greater than or equal to `0`")  # noqa: E501

        self._default_value = default_value

    @property
    def default_units(self):
        """Gets the default_units of this ResourceType.  # noqa: E501


        :return: The default_units of this ResourceType.  # noqa: E501
        :rtype: str
        """
        return self._default_units

    @default_units.setter
    def default_units(self, default_units):
        """Sets the default_units of this ResourceType.


        :param default_units: The default_units of this ResourceType.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_units is not None and len(default_units) > 32):
            raise ValueError("Invalid value for `default_units`, length must be less than or equal to `32`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                default_units is not None and len(default_units) < 0):
            raise ValueError("Invalid value for `default_units`, length must be greater than or equal to `0`")  # noqa: E501

        self._default_units = default_units

    @property
    def resource_type_category(self):
        """Gets the resource_type_category of this ResourceType.  # noqa: E501


        :return: The resource_type_category of this ResourceType.  # noqa: E501
        :rtype: ResourceTypeCategory
        """
        return self._resource_type_category

    @resource_type_category.setter
    def resource_type_category(self, resource_type_category):
        """Sets the resource_type_category of this ResourceType.


        :param resource_type_category: The resource_type_category of this ResourceType.  # noqa: E501
        :type: ResourceTypeCategory
        """

        self._resource_type_category = resource_type_category

    @property
    def item_element_relationship_history_list(self):
        """Gets the item_element_relationship_history_list of this ResourceType.  # noqa: E501


        :return: The item_element_relationship_history_list of this ResourceType.  # noqa: E501
        :rtype: list[ItemElementRelationshipHistory]
        """
        return self._item_element_relationship_history_list

    @item_element_relationship_history_list.setter
    def item_element_relationship_history_list(self, item_element_relationship_history_list):
        """Sets the item_element_relationship_history_list of this ResourceType.


        :param item_element_relationship_history_list: The item_element_relationship_history_list of this ResourceType.  # noqa: E501
        :type: list[ItemElementRelationshipHistory]
        """

        self._item_element_relationship_history_list = item_element_relationship_history_list

    @property
    def connector_list(self):
        """Gets the connector_list of this ResourceType.  # noqa: E501


        :return: The connector_list of this ResourceType.  # noqa: E501
        :rtype: list[Connector]
        """
        return self._connector_list

    @connector_list.setter
    def connector_list(self, connector_list):
        """Sets the connector_list of this ResourceType.


        :param connector_list: The connector_list of this ResourceType.  # noqa: E501
        :type: list[Connector]
        """

        self._connector_list = connector_list

    @property
    def item_resource_list(self):
        """Gets the item_resource_list of this ResourceType.  # noqa: E501


        :return: The item_resource_list of this ResourceType.  # noqa: E501
        :rtype: list[ItemResource]
        """
        return self._item_resource_list

    @item_resource_list.setter
    def item_resource_list(self, item_resource_list):
        """Sets the item_resource_list of this ResourceType.


        :param item_resource_list: The item_resource_list of this ResourceType.  # noqa: E501
        :type: list[ItemResource]
        """

        self._item_resource_list = item_resource_list

    @property
    def item_element_relationship_list(self):
        """Gets the item_element_relationship_list of this ResourceType.  # noqa: E501


        :return: The item_element_relationship_list of this ResourceType.  # noqa: E501
        :rtype: list[ItemElementRelationship]
        """
        return self._item_element_relationship_list

    @item_element_relationship_list.setter
    def item_element_relationship_list(self, item_element_relationship_list):
        """Sets the item_element_relationship_list of this ResourceType.


        :param item_element_relationship_list: The item_element_relationship_list of this ResourceType.  # noqa: E501
        :type: list[ItemElementRelationship]
        """

        self._item_element_relationship_list = item_element_relationship_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ResourceType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ResourceType):
            return True

        return self.to_dict() != other.to_dict()
