from setuptools import setup, find_packages

from block_snippets import get_version

setup(
    name='skip-django-block-snippets',
    version=get_version(),
    description="Django block snippets.",
    keywords='django, snippets',
    author='Lubos Matl',
    author_email='matllubos@gmail.com',
    url='https://github.com/skip-pay/django-block-snippets',
    license='BSD',
    package_dir={'block_snippets': 'block_snippets'},
    include_package_data=True,
    packages=find_packages(),
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: Czech',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Internet :: WWW/HTTP :: Site Management',
    ],
    install_requires=[
        'django>=1.10',
    ],
    zip_safe=False
)
