"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.create_label import CreateLabel
from swx_sdk.model.create_label_relation import CreateLabelRelation
from swx_sdk.model.create_label_response import CreateLabelResponse
from swx_sdk.model.label_delete_response import LabelDeleteResponse
from swx_sdk.model.label_list_element1 import LabelListElement1
from swx_sdk.model.label_list_element_relations import LabelListElementRelations
from swx_sdk.model.label_list_response import LabelListResponse
from swx_sdk.model.label_relation_element1 import LabelRelationElement1


class LabelApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_spaces_label(
            self,
            space,
            create_label,
            **kwargs
        ):
            """Create label  # noqa: E501

            Send a new label to the platform  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_spaces_label(space, create_label, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                create_label (CreateLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateLabelResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['create_label'] = \
                create_label
            return self.call_with_http_info(**kwargs)

        self.create_spaces_label = _Endpoint(
            settings={
                'response_type': (CreateLabelResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labels',
                'operation_id': 'create_spaces_label',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'create_label',
                ],
                'required': [
                    'space',
                    'create_label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'create_label':
                        (CreateLabel,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                    'create_label': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__create_spaces_label
        )

        def __create_spaces_labels_label_relation(
            self,
            space,
            label_id,
            create_label_relation,
            **kwargs
        ):
            """Create label relation  # noqa: E501

            Assign an existing label to an existing entity by id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_spaces_labels_label_relation(space, label_id, create_label_relation, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):
                create_label_relation (CreateLabelRelation):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelRelationElement1
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            kwargs['create_label_relation'] = \
                create_label_relation
            return self.call_with_http_info(**kwargs)

        self.create_spaces_labels_label_relation = _Endpoint(
            settings={
                'response_type': (LabelRelationElement1,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labels/{label-id}/relations',
                'operation_id': 'create_spaces_labels_label_relation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                    'create_label_relation',
                ],
                'required': [
                    'space',
                    'label_id',
                    'create_label_relation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                    'create_label_relation':
                        (CreateLabelRelation,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                    'create_label_relation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__create_spaces_labels_label_relation
        )

        def __delete_spaces_label(
            self,
            space,
            label_id,
            **kwargs
        ):
            """Delete Label  # noqa: E501

            Deletes an existing label by id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_spaces_label(space, label_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        self.delete_spaces_label = _Endpoint(
            settings={
                'response_type': (LabelDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labels/{label-id}',
                'operation_id': 'delete_spaces_label',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                ],
                'required': [
                    'space',
                    'label_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_spaces_label
        )

        def __delete_spaces_labels(
            self,
            space,
            label_id,
            entity_id,
            **kwargs
        ):
            """Delete Label relation  # noqa: E501

            Delete a Label assignation for an specific entity  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_spaces_labels(space, label_id, entity_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):
                entity_id (str): Removes label assigned to this entity_id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            kwargs['entity_id'] = \
                entity_id
            return self.call_with_http_info(**kwargs)

        self.delete_spaces_labels = _Endpoint(
            settings={
                'response_type': (LabelDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labels/{label-id}/relations',
                'operation_id': 'delete_spaces_labels',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                    'entity_id',
                ],
                'required': [
                    'space',
                    'label_id',
                    'entity_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                    'entity_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                    'entity_id': 'entity_id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                    'entity_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_spaces_labels
        )

        def __list_spaces_label(
            self,
            space,
            **kwargs
        ):
            """List Labels  # noqa: E501

            List of all the labels for an space  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_spaces_label(space, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):

            Keyword Args:
                mqtt (bool): filter by labels with mqtt enabled. [optional]
                entity_id (str): filter that shows labels of a certain entity. [optional]
                entity_type (str): filter that shows labels of a certain entity type. [optional]
                collection_name (str): filter that shows labels of a certain collection. **Only available for thing entities**. [optional]
                label_name (str): filter that shows labels by label_name. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            return self.call_with_http_info(**kwargs)

        self.list_spaces_label = _Endpoint(
            settings={
                'response_type': (LabelListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labels',
                'operation_id': 'list_spaces_label',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'mqtt',
                    'entity_id',
                    'entity_type',
                    'collection_name',
                    'label_name',
                ],
                'required': [
                    'space',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'mqtt':
                        (bool,),
                    'entity_id':
                        (str,),
                    'entity_type':
                        (str,),
                    'collection_name':
                        (str,),
                    'label_name':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'mqtt': 'mqtt',
                    'entity_id': 'entity_id',
                    'entity_type': 'entity_type',
                    'collection_name': 'collection_name',
                    'label_name': 'label_name',
                },
                'location_map': {
                    'space': 'path',
                    'mqtt': 'query',
                    'entity_id': 'query',
                    'entity_type': 'query',
                    'collection_name': 'query',
                    'label_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_spaces_label
        )

        def __show_spaces_label(
            self,
            space,
            label_id,
            **kwargs
        ):
            """Show Label  # noqa: E501

            Show an existing label by id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_spaces_label(space, label_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelListElement1
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        self.show_spaces_label = _Endpoint(
            settings={
                'response_type': (LabelListElement1,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labels/{label-id}',
                'operation_id': 'show_spaces_label',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                ],
                'required': [
                    'space',
                    'label_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_spaces_label
        )

        def __show_spaces_labels_label_items(
            self,
            space,
            label_id,
            **kwargs
        ):
            """Show Label Items  # noqa: E501

            Show an existing label by name and entities associated to it  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_spaces_labels_label_items(space, label_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):

            Keyword Args:
                entity_type (str): filter that shows only entities of a certain type. [optional]
                collection_name (str): filter that shows only entities from a certain collection. **Only available for thing entities**. [optional]
                entity_id (str): filter that shows only the entities that have this label. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelListElementRelations
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        self.show_spaces_labels_label_items = _Endpoint(
            settings={
                'response_type': (LabelListElementRelations,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labels/{label-id}/relations',
                'operation_id': 'show_spaces_labels_label_items',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                    'entity_type',
                    'collection_name',
                    'entity_id',
                ],
                'required': [
                    'space',
                    'label_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'entity_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('entity_type',): {

                        "THING": "thing",
                        "FUNCTION": "function",
                        "BUILD_CONFIG": "build_config",
                        "RESOURCE": "resource"
                    },
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                    'entity_type':
                        (str,),
                    'collection_name':
                        (str,),
                    'entity_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                    'entity_type': 'entity_type',
                    'collection_name': 'collection_name',
                    'entity_id': 'entity_id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                    'entity_type': 'query',
                    'collection_name': 'query',
                    'entity_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_spaces_labels_label_items
        )

        def __update_spaces_label(
            self,
            space,
            label_id,
            create_label,
            **kwargs
        ):
            """Update label  # noqa: E501

            Update an existing label  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_spaces_label(space, label_id, create_label, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):
                create_label (CreateLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateLabelResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            kwargs['create_label'] = \
                create_label
            return self.call_with_http_info(**kwargs)

        self.update_spaces_label = _Endpoint(
            settings={
                'response_type': (CreateLabelResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labels/{label-id}',
                'operation_id': 'update_spaces_label',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                    'create_label',
                ],
                'required': [
                    'space',
                    'label_id',
                    'create_label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                    'create_label':
                        (CreateLabel,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                    'create_label': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__update_spaces_label
        )
