import { CloudWatch } from 'aws-sdk';
export declare enum AlarmState {
    OK = "OK",
    ALARM = "ALARM",
    INSUFFICIENT_DATA = "INSUFFICIENT_DATA"
}
export interface IAlarmDetail {
    readonly alarmArn?: string;
    readonly state: string;
    readonly alarmDescription?: string;
    reason: string;
}
export interface AggregateAlarmState {
    readonly alarmDetails: IAlarmDetail[];
    readonly state: AlarmState;
    readonly summary: string;
}
/**
 * searchTerms: a list of terms to match in the alarm description
 */
export interface GetAlarmStateOptions {
    readonly searchTerms: string[];
}
export declare const getCloudwatchAlarms: (params?: CloudWatch.DescribeAlarmsInput | undefined) => Promise<IAlarmDetail[]>;
/**
 * Returns all alarms starting with the provided prefix in the state of ALARM. In addition,
 * any exceptions caught will be logged and converted into an alarm state of options.defaultState
 * with an associated reason.
 */
export declare const getAlarms: (searchTerms: string[]) => Promise<IAlarmDetail[]>;
/**
 * Calculate and return an aggregate alarm state across alarms returned from all
 * CloudWatch clients provided. If any client errors are thrown, the returned state
 * will be ALARM.
 *
 */
export declare const getAggregateAlarmState: (searchTerms: string[]) => Promise<AggregateAlarmState>;
