-- --------------------------------------------------------
-- Host:                         localhost
-- Server version:               10.1.10-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             9.1.0.4867
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dumping database structure for mariadb_climsoft_test_db_v4
CREATE DATABASE IF NOT EXISTS `mariadb_climsoft_test_db_v4` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `mariadb_climsoft_test_db_v4`;


-- Dumping structure for table mariadb_climsoft_test_db_v4.abc
CREATE TABLE IF NOT EXISTS `abc` (
  `No` int(11) NOT NULL,
  `Element_abbreviation` text NOT NULL,
  `Element_Name` text NOT NULL,
  `Element_Details` text NOT NULL,
  `Climsoft_Element` text NOT NULL,
  `Bufr_Element` text NOT NULL,
  `unit` text NOT NULL,
  `lower_limit` text NOT NULL,
  `upper_limit` text NOT NULL,
  `obsv` text NOT NULL,
  UNIQUE KEY `identification` (`No`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.abc: ~0 rows (approximately)
/*!40000 ALTER TABLE `abc` DISABLE KEYS */;
/*!40000 ALTER TABLE `abc` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.acquisitiontype
CREATE TABLE IF NOT EXISTS `acquisitiontype` (
  `code` int(11) NOT NULL DEFAULT '0',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.acquisitiontype: ~0 rows (approximately)
/*!40000 ALTER TABLE `acquisitiontype` DISABLE KEYS */;
/*!40000 ALTER TABLE `acquisitiontype` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws1
CREATE TABLE IF NOT EXISTS `aws1` (
  `No` int(11) NOT NULL,
  `Element_abbreviation` text NOT NULL,
  `Element_Name` text NOT NULL,
  `Element_Details` text NOT NULL,
  `Climsoft_Element` text NOT NULL,
  `Bufr_Element` text NOT NULL,
  `unit` text NOT NULL,
  `lower_limit` text NOT NULL,
  `upper_limit` text NOT NULL,
  `obsv` text NOT NULL,
  UNIQUE KEY `identification` (`No`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws1: ~0 rows (approximately)
/*!40000 ALTER TABLE `aws1` DISABLE KEYS */;
/*!40000 ALTER TABLE `aws1` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_basestation
CREATE TABLE IF NOT EXISTS `aws_basestation` (
  `ftpId` varchar(50) NOT NULL,
  `inputFolder` varchar(20) NOT NULL,
  `ftpMode` varchar(10) DEFAULT NULL,
  `userName` varchar(15) NOT NULL,
  `password` varchar(15) NOT NULL,
  PRIMARY KEY (`ftpId`),
  UNIQUE KEY `ftpId_UNIQUE` (`ftpId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_basestation: ~1 rows (approximately)
/*!40000 ALTER TABLE `aws_basestation` DISABLE KEYS */;
INSERT INTO `aws_basestation` (`ftpId`, `inputFolder`, `ftpMode`, `userName`, `password`) VALUES
	('', '', 'FTP', '', '');
/*!40000 ALTER TABLE `aws_basestation` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_elements
CREATE TABLE IF NOT EXISTS `aws_elements` (
  `aws_element` varchar(50) NOT NULL,
  `climsoft_element` varchar(50) NOT NULL,
  `element_description` varchar(50) NOT NULL,
  PRIMARY KEY (`aws_element`,`climsoft_element`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_elements: ~12 rows (approximately)
/*!40000 ALTER TABLE `aws_elements` DISABLE KEYS */;
INSERT INTO `aws_elements` (`aws_element`, `climsoft_element`, `element_description`) VALUES
	('Amb T Inst', '881', 'AWS Ambient temperature\r'),
	('DP', '885', 'AWS Dewpoint\r'),
	('Gnd T Inst', '900', 'AWS Soil temperature 30 cm\r'),
	('H Inst', '893', 'AWS Relative Humidity\r'),
	('Leaf', '899', 'AWS Leaf wetness\r'),
	('Pres Inst', '884', 'AWS Pressure Inst\r'),
	('Rain', '892', 'AWS Precip 15 minute total\r'),
	('Sun', '894', 'AWS Solar Radiation\r'),
	('Sun 15min', '888', 'AWS Sunshine Duration 15 min\r'),
	('WB', '901', 'AWS Wetbulb\r'),
	('Wnd Dir', '895', 'Wnd Direction mean\r'),
	('Wnd Spd', '897', 'AWS Wnd Speed mean\r');
/*!40000 ALTER TABLE `aws_elements` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_malawi1
CREATE TABLE IF NOT EXISTS `aws_malawi1` (
  `Cols` int(11) NOT NULL,
  `Element_abbreviation` varchar(50) DEFAULT NULL,
  `Element_Name` varchar(50) DEFAULT NULL,
  `Element_Details` varchar(50) DEFAULT NULL,
  `Climsoft_Element` varchar(6) DEFAULT NULL,
  `Bufr_Element` varchar(6) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `lower_limit` varchar(50) DEFAULT NULL,
  `upper_limit` varchar(50) DEFAULT NULL,
  `obsv` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`Cols`),
  KEY `Identification` (`Element_Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_malawi1: ~14 rows (approximately)
/*!40000 ALTER TABLE `aws_malawi1` DISABLE KEYS */;
INSERT INTO `aws_malawi1` (`Cols`, `Element_abbreviation`, `Element_Name`, `Element_Details`, `Climsoft_Element`, `Bufr_Element`, `unit`, `lower_limit`, `upper_limit`, `obsv`) VALUES
	(1, 'Date/time', 'Date', 'Date ddmmyy', NULL, NULL, NULL, NULL, NULL, '30/04/13'),
	(2, 'PRECIP', 'Rainfall', 'Rain cummulative', '892', '013011', 'mm', '0', NULL, ' 0'),
	(3, 'WDDR', 'WindDirection', 'Wind Direction', '895', '011001', 'deg', '0', '360', ' 145.066'),
	(4, 'WDSPD', 'WindSpeed', 'Wind Speed Average', '897', NULL, 'ms-1', NULL, NULL, ' 3.3802'),
	(5, 'WDGUSTSPD', 'WindSpeed', 'Wind Speed Average', '896', '11041', 'ms-1', NULL, NULL, ' 3.3802'),
	(6, 'CONDCTVTY', 'Conductivity', 'Electrical Conductivity', '1003', NULL, 'mS/cm', NULL, NULL, ' 145.066'),
	(7, 'VAPPRESS', 'VapourPress', 'Vapour Pressure', '916', NULL, 'kPa', NULL, NULL, ' 26.5028'),
	(8, 'TEMP', 'AirTemp', 'Air temperature', '881', '012103', 'dec', NULL, NULL, ' 26.5028'),
	(9, 'RH', 'RelativeHumidity', 'Relative Humidity', '893', '013003', '%', '0', '100', ' 66.6466'),
	(10, 'PRESS', 'Pressure', 'Pressure', '884', '010004', 'kPa', NULL, NULL, ' 957.366'),
	(11, 'SOLRD', 'SolarRadiation', 'Solar Radiation', '894', '014028', 'W/m^2', NULL, NULL, ' 406.52'),
	(12, 'WATRDPTH', 'WaterDepth', 'Water Depth', '1001', '', 'mm', NULL, NULL, ' 406.52'),
	(13, 'WATRTEMP', 'WaterTemp', 'Water Temperature', '1002', NULL, 'deg', NULL, NULL, ' 406.52'),
	(14, 'SOILMOIST', 'SoilMoisture', 'Soil Moisture', '915', NULL, 'm^3/m^3', NULL, NULL, ' 406.52');
/*!40000 ALTER TABLE `aws_malawi1` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_malawi12
CREATE TABLE IF NOT EXISTS `aws_malawi12` (
  `No` int(11) NOT NULL,
  `Element_abbreviation` text NOT NULL,
  `Element_Name` text NOT NULL,
  `Element_Details` text NOT NULL,
  `Climsoft_Element` text NOT NULL,
  `Bufr_Element` text NOT NULL,
  `unit` text NOT NULL,
  `lower_limit` text NOT NULL,
  `upper_limit` text NOT NULL,
  `obsv` text NOT NULL,
  UNIQUE KEY `identification` (`No`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_malawi12: ~0 rows (approximately)
/*!40000 ALTER TABLE `aws_malawi12` DISABLE KEYS */;
/*!40000 ALTER TABLE `aws_malawi12` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_mss
CREATE TABLE IF NOT EXISTS `aws_mss` (
  `ftpId` varchar(50) NOT NULL,
  `inputFolder` varchar(20) NOT NULL,
  `userName` varchar(15) NOT NULL,
  `ftpMode` varchar(10) DEFAULT NULL,
  `password` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`ftpId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_mss: ~1 rows (approximately)
/*!40000 ALTER TABLE `aws_mss` DISABLE KEYS */;
INSERT INTO `aws_mss` (`ftpId`, `inputFolder`, `userName`, `ftpMode`, `password`) VALUES
	('localhost', 'input', 'ftp', 'FTP', 'ftp');
/*!40000 ALTER TABLE `aws_mss` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_process_parameters
CREATE TABLE IF NOT EXISTS `aws_process_parameters` (
  `RetrieveInterval` int(11) NOT NULL DEFAULT '60',
  `HourOffset` int(11) NOT NULL DEFAULT '10',
  `RetrievePeriod` int(11) NOT NULL DEFAULT '1',
  `RetrieveTimeout` int(11) NOT NULL DEFAULT '20',
  `DelinputFile` tinyint(4) NOT NULL DEFAULT '1',
  `UTCDiff` tinyint(2) unsigned zerofill NOT NULL DEFAULT '00',
  PRIMARY KEY (`RetrieveInterval`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_process_parameters: ~1 rows (approximately)
/*!40000 ALTER TABLE `aws_process_parameters` DISABLE KEYS */;
INSERT INTO `aws_process_parameters` (`RetrieveInterval`, `HourOffset`, `RetrievePeriod`, `RetrieveTimeout`, `DelinputFile`, `UTCDiff`) VALUES
	(60, 10, 2, 10, 0, 00);
/*!40000 ALTER TABLE `aws_process_parameters` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_rwanda1
CREATE TABLE IF NOT EXISTS `aws_rwanda1` (
  `Cols` int(11) DEFAULT '0',
  `Element_abbreviation` varchar(50) DEFAULT NULL,
  `Element_Name` varchar(50) DEFAULT NULL,
  `Element_Details` varchar(50) DEFAULT NULL,
  `Climsoft_Element` varchar(6) DEFAULT NULL,
  `Bufr_Element` varchar(6) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `lower_limit` varchar(50) DEFAULT NULL,
  `upper_limit` varchar(50) DEFAULT NULL,
  `obsv` varchar(50) DEFAULT NULL,
  KEY `identification` (`Element_Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_rwanda1: ~152 rows (approximately)
/*!40000 ALTER TABLE `aws_rwanda1` DISABLE KEYS */;
INSERT INTO `aws_rwanda1` (`Cols`, `Element_abbreviation`, `Element_Name`, `Element_Details`, `Climsoft_Element`, `Bufr_Element`, `unit`, `lower_limit`, `upper_limit`, `obsv`) VALUES
	(13, 'AP_Ave', 'AP_Ave', NULL, '884', '010004', 'Hpa', NULL, NULL, NULL),
	(14, 'AP_Max', 'AP_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(12, 'AP_Min', 'AP_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(16, 'AP_Perc', 'AP_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(15, 'AP_StdDV', 'AP_StdDV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(8, 'AT_Ave', 'AT_Ave', NULL, '881', '012101', '°C', NULL, NULL, NULL),
	(9, 'AT_Max', 'AT_Max', NULL, '882', '012111', '°C', NULL, NULL, NULL),
	(7, 'AT_Min', 'AT_Min', NULL, '883', '012112', '°C', NULL, NULL, NULL),
	(11, 'AT_Perc', 'AT_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(10, 'AT_StdV', 'AT_StdV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(24, 'BAT_Inst', 'BAT_Inst', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(25, 'BAT_Perc', 'BAT_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(1, 'Date/time', 'Date/time', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(18, 'RAD_Ave', 'RAD_Ave', NULL, '894', '014028', 'J', NULL, NULL, NULL),
	(19, 'RAD_Max', 'RAD_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(17, 'RAD_Min', 'RAD_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(21, 'RAD_Perc', 'RAD_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(20, 'RAD_StdDV', 'RAD_StdDV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(23, 'RAIN_Perc', 'RAIN_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(22, 'RAIN_Tot', 'RAIN_Tot', NULL, '892', '013011', 'mm', NULL, NULL, NULL),
	(3, 'RH_Ave', 'RH_Ave', NULL, '893', '013003', '%', NULL, NULL, NULL),
	(4, 'RH_Max', 'RH_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(2, 'RH_Min', 'RH_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(6, 'RH_Perc', 'RH_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(5, 'RH_StdV', 'RH_StdV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(26, 'TX_Inst', 'TX_Inst', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(27, 'TX_Perc', 'TX_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(37, 'WDR_CalmPerc', 'WDR_CalmPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(38, 'WDR_Perc', 'WDR_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(33, 'WDR_PrevDir', 'WDR_PrevDir', NULL, '895', '011001', 'Deg', NULL, NULL, NULL),
	(34, 'WDR_RisDir', 'WDR_RisDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(35, 'WDR_RisVel', 'WDR_RisVel', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(36, 'WDR_StdDevDir', 'WDR_StdDevDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(29, 'WSD_Ave', 'WSD_Ave', NULL, '897', '011002', 'Knots', NULL, NULL, NULL),
	(30, 'WSD_Max', 'WSD_Max', NULL, '886', '011041', 'Knots', NULL, NULL, NULL),
	(28, 'WSD_Min', 'WSD_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(32, 'WSD_Perc', 'WSD_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(31, 'WSD_StdDev', 'WSD_StdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(13, 'AP_Ave', 'AP_Ave', NULL, '884', '010004', 'Hpa', NULL, NULL, NULL),
	(14, 'AP_Max', 'AP_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(12, 'AP_Min', 'AP_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(16, 'AP_Perc', 'AP_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(15, 'AP_StdDV', 'AP_StdDV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(8, 'AT_Ave', 'AT_Ave', NULL, '881', '012101', '°C', NULL, NULL, NULL),
	(9, 'AT_Max', 'AT_Max', NULL, '882', '012111', '°C', NULL, NULL, NULL),
	(7, 'AT_Min', 'AT_Min', NULL, '883', '012112', '°C', NULL, NULL, NULL),
	(11, 'AT_Perc', 'AT_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(10, 'AT_StdV', 'AT_StdV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(24, 'BAT_Inst', 'BAT_Inst', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(25, 'BAT_Perc', 'BAT_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(1, 'Date/time', 'Date/time', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(18, 'RAD_Ave', 'RAD_Ave', NULL, '894', '014028', 'J', NULL, NULL, NULL),
	(19, 'RAD_Max', 'RAD_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(17, 'RAD_Min', 'RAD_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(21, 'RAD_Perc', 'RAD_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(20, 'RAD_StdDV', 'RAD_StdDV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(23, 'RAIN_Perc', 'RAIN_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(22, 'RAIN_Tot', 'RAIN_Tot', NULL, '892', '013011', 'mm', NULL, NULL, NULL),
	(3, 'RH_Ave', 'RH_Ave', NULL, '893', '013003', '%', NULL, NULL, NULL),
	(4, 'RH_Max', 'RH_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(2, 'RH_Min', 'RH_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(6, 'RH_Perc', 'RH_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(5, 'RH_StdV', 'RH_StdV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(26, 'TX_Inst', 'TX_Inst', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(27, 'TX_Perc', 'TX_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(37, 'WDR_CalmPerc', 'WDR_CalmPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(38, 'WDR_Perc', 'WDR_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(33, 'WDR_PrevDir', 'WDR_PrevDir', NULL, '895', '011001', 'Deg', NULL, NULL, NULL),
	(34, 'WDR_RisDir', 'WDR_RisDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(35, 'WDR_RisVel', 'WDR_RisVel', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(36, 'WDR_StdDevDir', 'WDR_StdDevDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(29, 'WSD_Ave', 'WSD_Ave', NULL, '897', '011002', 'Knots', NULL, NULL, NULL),
	(30, 'WSD_Max', 'WSD_Max', NULL, '886', '011041', 'Knots', NULL, NULL, NULL),
	(28, 'WSD_Min', 'WSD_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(32, 'WSD_Perc', 'WSD_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(31, 'WSD_StdDev', 'WSD_StdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(13, 'AP_Ave', 'AP_Ave', NULL, '884', '010004', 'Hpa', NULL, NULL, NULL),
	(14, 'AP_Max', 'AP_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(12, 'AP_Min', 'AP_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(16, 'AP_Perc', 'AP_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(15, 'AP_StdDV', 'AP_StdDV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(8, 'AT_Ave', 'AT_Ave', NULL, '881', '012101', '°C', NULL, NULL, NULL),
	(9, 'AT_Max', 'AT_Max', NULL, '882', '012111', '°C', NULL, NULL, NULL),
	(7, 'AT_Min', 'AT_Min', NULL, '883', '012112', '°C', NULL, NULL, NULL),
	(11, 'AT_Perc', 'AT_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(10, 'AT_StdV', 'AT_StdV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(24, 'BAT_Inst', 'BAT_Inst', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(25, 'BAT_Perc', 'BAT_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(1, 'Date/time', 'Date/time', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(18, 'RAD_Ave', 'RAD_Ave', NULL, '894', '014028', 'J', NULL, NULL, NULL),
	(19, 'RAD_Max', 'RAD_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(17, 'RAD_Min', 'RAD_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(21, 'RAD_Perc', 'RAD_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(20, 'RAD_StdDV', 'RAD_StdDV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(23, 'RAIN_Perc', 'RAIN_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(22, 'RAIN_Tot', 'RAIN_Tot', NULL, '892', '013011', 'mm', NULL, NULL, NULL),
	(3, 'RH_Ave', 'RH_Ave', NULL, '893', '013003', '%', NULL, NULL, NULL),
	(4, 'RH_Max', 'RH_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(2, 'RH_Min', 'RH_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(6, 'RH_Perc', 'RH_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(5, 'RH_StdV', 'RH_StdV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(26, 'TX_Inst', 'TX_Inst', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(27, 'TX_Perc', 'TX_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(37, 'WDR_CalmPerc', 'WDR_CalmPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(38, 'WDR_Perc', 'WDR_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(33, 'WDR_PrevDir', 'WDR_PrevDir', NULL, '895', '011001', 'Deg', NULL, NULL, NULL),
	(34, 'WDR_RisDir', 'WDR_RisDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(35, 'WDR_RisVel', 'WDR_RisVel', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(36, 'WDR_StdDevDir', 'WDR_StdDevDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(29, 'WSD_Ave', 'WSD_Ave', NULL, '897', '011002', 'Knots', NULL, NULL, NULL),
	(30, 'WSD_Max', 'WSD_Max', NULL, '886', '011041', 'Knots', NULL, NULL, NULL),
	(28, 'WSD_Min', 'WSD_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(32, 'WSD_Perc', 'WSD_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(31, 'WSD_StdDev', 'WSD_StdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(13, 'AP_Ave', 'AP_Ave', NULL, '884', '010004', 'Hpa', NULL, NULL, NULL),
	(14, 'AP_Max', 'AP_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(12, 'AP_Min', 'AP_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(16, 'AP_Perc', 'AP_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(15, 'AP_StdDV', 'AP_StdDV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(8, 'AT_Ave', 'AT_Ave', NULL, '881', '012101', '°C', NULL, NULL, NULL),
	(9, 'AT_Max', 'AT_Max', NULL, '882', '012111', '°C', NULL, NULL, NULL),
	(7, 'AT_Min', 'AT_Min', NULL, '883', '012112', '°C', NULL, NULL, NULL),
	(11, 'AT_Perc', 'AT_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(10, 'AT_StdV', 'AT_StdV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(24, 'BAT_Inst', 'BAT_Inst', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(25, 'BAT_Perc', 'BAT_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(1, 'Date/time', 'Date/time', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(18, 'RAD_Ave', 'RAD_Ave', NULL, '894', '014028', 'J', NULL, NULL, NULL),
	(19, 'RAD_Max', 'RAD_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(17, 'RAD_Min', 'RAD_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(21, 'RAD_Perc', 'RAD_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(20, 'RAD_StdDV', 'RAD_StdDV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(23, 'RAIN_Perc', 'RAIN_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(22, 'RAIN_Tot', 'RAIN_Tot', NULL, '892', '013011', 'mm', NULL, NULL, NULL),
	(3, 'RH_Ave', 'RH_Ave', NULL, '893', '013003', '%', NULL, NULL, NULL),
	(4, 'RH_Max', 'RH_Max', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(2, 'RH_Min', 'RH_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(6, 'RH_Perc', 'RH_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(5, 'RH_StdV', 'RH_StdV', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(26, 'TX_Inst', 'TX_Inst', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(27, 'TX_Perc', 'TX_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(37, 'WDR_CalmPerc', 'WDR_CalmPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(38, 'WDR_Perc', 'WDR_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(33, 'WDR_PrevDir', 'WDR_PrevDir', NULL, '895', '011001', 'Deg', NULL, NULL, NULL),
	(34, 'WDR_RisDir', 'WDR_RisDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(35, 'WDR_RisVel', 'WDR_RisVel', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(36, 'WDR_StdDevDir', 'WDR_StdDevDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(29, 'WSD_Ave', 'WSD_Ave', NULL, '897', '011002', 'Knots', NULL, NULL, NULL),
	(30, 'WSD_Max', 'WSD_Max', NULL, '886', '011041', 'Knots', NULL, NULL, NULL),
	(28, 'WSD_Min', 'WSD_Min', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(32, 'WSD_Perc', 'WSD_Perc', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(31, 'WSD_StdDev', 'WSD_StdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
/*!40000 ALTER TABLE `aws_rwanda1` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_rwanda4
CREATE TABLE IF NOT EXISTS `aws_rwanda4` (
  `Cols` int(11) NOT NULL,
  `Element_Name` varchar(20) DEFAULT NULL,
  `Element_Abbreviation` varchar(20) DEFAULT NULL,
  `Element_Details` varchar(25) DEFAULT NULL,
  `Climsoft_Element` varchar(6) DEFAULT NULL,
  `Bufr_Element` varchar(6) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `lower_limit` varchar(10) DEFAULT NULL,
  `upper_limit` varchar(10) DEFAULT NULL,
  `obsv` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`Cols`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_rwanda4: ~48 rows (approximately)
/*!40000 ALTER TABLE `aws_rwanda4` DISABLE KEYS */;
INSERT INTO `aws_rwanda4` (`Cols`, `Element_Name`, `Element_Abbreviation`, `Element_Details`, `Climsoft_Element`, `Bufr_Element`, `unit`, `lower_limit`, `upper_limit`, `obsv`) VALUES
	(1, 'date/time', 'Date/time', 'Date and time', NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(2, 'RHMin', 'RHMIN', 'RELATIVE Humidity Minimum', NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(3, 'RHAve', 'RHAVG', 'RELATIVE Humidity Average', '893', '13003', '%', NULL, NULL, '10-22-2015'),
	(4, 'RHMax', 'RHMAX', 'RELATIVE Humidity Maximum', NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(5, 'StdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(6, 'RHValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(7, 'TempMin', 'TMIN', 'Minimum Temperature', '883', '12112', NULL, NULL, NULL, '10-22-2015'),
	(8, 'TempAve', 'TVG', 'Average Temperature', '881', '12101', '\'C', NULL, NULL, '10-22-2015'),
	(9, 'TempMax', 'TMAX', 'Maximum Temperature', '882', '12111', NULL, NULL, NULL, '10-22-2015'),
	(10, 'TempStdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(11, 'TempValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(12, 'PRESMin', 'PRESMIN', 'Minimum Pressure', NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(13, 'PRESAve', 'PRESAVG', 'Average Pressure', '884', '30200', 'hPa', NULL, NULL, '10-22-2015'),
	(14, 'PRESMax', 'PRESMAX', 'Maximum Pressure', NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(15, 'PRESStdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(16, 'PRESValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(17, 'RADMin', 'RADMIN', 'Global Radiation Minimum', NULL, NULL, 'W/m2', NULL, NULL, '10-22-2015'),
	(18, 'RADAve', 'RADAVG', 'Global Radiation Average', '894', '14028', 'W/m2', NULL, NULL, '10-22-2015'),
	(19, 'RADMax', 'RADMAX', 'Global Radiation Maximum', NULL, NULL, 'W/m2', NULL, NULL, '10-22-2015'),
	(20, 'RADStdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(21, 'RADValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(22, 'PRECTot', 'PRECTOT', 'Total Precipitation', '892', '13011', 'mm', NULL, NULL, '10-22-2015'),
	(23, 'PRECValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(24, 'PWInst', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(25, 'PWValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(26, 'TempInst', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(27, 'TempValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(28, 'WSPMin', 'WSPMIN', 'Minimum Wind speed', NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(29, 'WSPAve', 'WSPAVG', 'Average Wind speed', '897', '11002', 'm/s', NULL, NULL, '10-22-2015'),
	(30, 'WSPMax', 'WSMAX', 'Maximum Wind speed', NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(31, 'WSPStdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(32, 'WSPValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(33, 'WDPrevDir', 'WDPR', 'Wind Direction', '895', '11001', NULL, NULL, NULL, '10-22-2015'),
	(34, 'WDRisDir', 'WDR', NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(35, 'WDRisVel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(36, 'WDStdDevDir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(37, 'WDCalmPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(38, 'WDValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(39, 'TempSoilMin', 'TSMIN', 'Minimum Soil Temperature', NULL, NULL, '\'C', NULL, NULL, '10-22-2015'),
	(40, 'TempSoilAve', 'TSAVG', 'Average Soil Temperature', '900', '12130', '\'C', NULL, NULL, '10-22-2015'),
	(41, 'TempSoilMax', 'TSMAX', 'Maximum Soil Temperature', NULL, NULL, '\'C', NULL, NULL, '10-22-2015'),
	(42, 'TempSoliStdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(43, 'TempSoiValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(44, 'Temp10mMin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(45, 'Temp10mAve', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(46, 'Temp10mMax', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(47, 'Temp10mStdDev', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015'),
	(48, 'Temp10mValidDataPerc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '10-22-2015');
/*!40000 ALTER TABLE `aws_rwanda4` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_sasscal1
CREATE TABLE IF NOT EXISTS `aws_sasscal1` (
  `Cols` int(11) NOT NULL DEFAULT '0',
  `Element_Abbreviation` varchar(50) DEFAULT NULL,
  `Element_Name` varchar(50) DEFAULT NULL,
  `Element_Details` varchar(50) DEFAULT NULL,
  `Climsoft_Element` varchar(6) DEFAULT NULL,
  `Bufr_Element` varchar(6) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `lower_limit` varchar(50) DEFAULT NULL,
  `upper_limit` varchar(50) DEFAULT NULL,
  `obsv` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`Cols`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_sasscal1: ~12 rows (approximately)
/*!40000 ALTER TABLE `aws_sasscal1` DISABLE KEYS */;
INSERT INTO `aws_sasscal1` (`Cols`, `Element_Abbreviation`, `Element_Name`, `Element_Details`, `Climsoft_Element`, `Bufr_Element`, `unit`, `lower_limit`, `upper_limit`, `obsv`) VALUES
	(0, NULL, NULL, NULL, NULL, NULL, '11', NULL, NULL, NULL),
	(1, 'Station', 'Station', 'Station', NULL, NULL, NULL, NULL, NULL, 'Mahenene'),
	(2, 'Date/time', 'Date/time', 'Date/time', NULL, NULL, NULL, NULL, NULL, '20/03/2014 21:00:00'),
	(3, 'AT', 'Air_Temp', 'Air Temperature', '881', '012101', '\'C', NULL, NULL, '19.4'),
	(4, 'PRECIP', 'Precip', 'Precipitation', '892', '013011', 'mm', NULL, NULL, '0.0'),
	(5, 'WINDSPD', 'Wind_Speed', 'Wind Speed', '897', '011002', 'm/s', NULL, NULL, '1.2'),
	(6, 'WINDSPDX', 'Wind_Speed_Max', 'Wind Speed Maximum', '886', '011041', 'm/s', NULL, NULL, '2.2'),
	(7, 'WINDDIR', 'Wind_Direction', 'Wind Direction', '895', '011001', 'Deg', NULL, NULL, '169'),
	(8, 'RH', 'RH', 'Relative Humidity', '893', '013003', '%', NULL, NULL, '59.5'),
	(9, 'BPAR', 'BP_mbar_Avg', 'Pressure', '884', '010004', 'Hpa', NULL, NULL, '891'),
	(10, 'SOLRD', 'Solar_Rad', 'Solar Radiation', '894', '014028', 'MJ/s', NULL, NULL, '0.08'),
	(11, 'SUNHRS', 'Sun_Hrs', 'Sunshine Hours', '893', '013003', 'hrs', NULL, NULL, '0.0');
/*!40000 ALTER TABLE `aws_sasscal1` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_sites
CREATE TABLE IF NOT EXISTS `aws_sites` (
  `SiteID` varchar(20) NOT NULL,
  `SiteName` varchar(50) DEFAULT NULL,
  `InputFile` varchar(50) DEFAULT NULL,
  `FilePrefix` varchar(50) DEFAULT NULL,
  `chkPrefix` tinyint(1) DEFAULT '0',
  `DataStructure` varchar(50) DEFAULT NULL,
  `MissingDataFlag` varchar(10) DEFAULT NULL,
  `awsServerIP` varchar(50) DEFAULT NULL,
  `OperationalStatus` tinyint(1) unsigned zerofill NOT NULL DEFAULT '0',
  `GTSEncode` varchar(20) DEFAULT NULL,
  `GTSHeader` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`SiteID`),
  UNIQUE KEY `SiteID_UNIQUE` (`SiteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_sites: ~0 rows (approximately)
/*!40000 ALTER TABLE `aws_sites` DISABLE KEYS */;
/*!40000 ALTER TABLE `aws_sites` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_stations
CREATE TABLE IF NOT EXISTS `aws_stations` (
  `aws_id` varchar(50) NOT NULL,
  `national_id` varchar(50) NOT NULL,
  `station_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`aws_id`,`national_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_stations: ~0 rows (approximately)
/*!40000 ALTER TABLE `aws_stations` DISABLE KEYS */;
/*!40000 ALTER TABLE `aws_stations` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_structures
CREATE TABLE IF NOT EXISTS `aws_structures` (
  `strID` int(11) NOT NULL AUTO_INCREMENT,
  `strName` varchar(20) NOT NULL,
  `data_delimiter` varchar(10) NOT NULL,
  `hdrRows` int(11) NOT NULL,
  `txtQualifier` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`strName`),
  UNIQUE KEY `strID_UNIQUE` (`strID`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_structures: ~6 rows (approximately)
/*!40000 ALTER TABLE `aws_structures` DISABLE KEYS */;
INSERT INTO `aws_structures` (`strID`, `strName`, `data_delimiter`, `hdrRows`, `txtQualifier`) VALUES
	(11, 'aws_malawi1', 'tab', 3, '"'),
	(14, 'aws_rwanda4', 'tab', 3, NULL),
	(19, 'aws_sasscal1', 'comma', 1, '"'),
	(34, 'aws_tahmo', 'comma', 2, '"'),
	(5, 'aws_toa5_bw1', 'comma', 4, '"'),
	(18, 'aws_toa5_mg2', 'comma', 4, '');
/*!40000 ALTER TABLE `aws_structures` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_tahmo
CREATE TABLE IF NOT EXISTS `aws_tahmo` (
  `Cols` int(11) NOT NULL,
  `Element_abbreviation` varchar(50) DEFAULT NULL,
  `Element_Name` varchar(50) DEFAULT NULL,
  `Element_Details` varchar(50) DEFAULT NULL,
  `Climsoft_Element` varchar(6) DEFAULT NULL,
  `Bufr_Element` varchar(6) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `lower_limit` varchar(50) DEFAULT NULL,
  `upper_limit` varchar(50) DEFAULT NULL,
  `obsv` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`Cols`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_tahmo: ~14 rows (approximately)
/*!40000 ALTER TABLE `aws_tahmo` DISABLE KEYS */;
INSERT INTO `aws_tahmo` (`Cols`, `Element_abbreviation`, `Element_Name`, `Element_Details`, `Climsoft_Element`, `Bufr_Element`, `unit`, `lower_limit`, `upper_limit`, `obsv`) VALUES
	(1, 'Date/time', 'DateTime', 'Date and Time', NULL, NULL, NULL, NULL, NULL, '2016-08-02 08:50'),
	(2, 'PRECIP', 'Rainfall', 'Rain cummulative', '892', '013011', 'mm', '0', NULL, '0'),
	(3, 'WDDR', 'WindDirection', 'Wind Direction', '895', '011001', 'deg', '0', '360', '324'),
	(4, 'WDSPD', 'WindSpeed', 'Wind Speed Average', '897', '', 'm/s', NULL, NULL, '1.8'),
	(5, 'WDGUSTSPD', 'WindSpeed', 'Wind Speed Average', '886', '011041', 'm/s', NULL, NULL, '2.6'),
	(6, 'CONDCTVTY', 'Conductivity', 'Electrical Conductivity', '919', NULL, 'mS/cm', NULL, NULL, NULL),
	(7, 'VAPPRESS', 'VapourPress', 'Vapour Pressure', '916', NULL, 'kPa', NULL, NULL, '1.72'),
	(8, 'TEMP', 'AirTemp', 'Air temperature', '881', '012103', 'dec \'c', NULL, NULL, '26.5'),
	(9, 'RH', 'RelativeHumidity', 'Relative Humidity', '893', '013003', '0.01%', '0', '1', '0.5'),
	(10, 'PRESS', 'Pressure', 'Pressure', '884', '010004', 'kPa', NULL, NULL, NULL),
	(11, 'SOLRD', 'SolarRadiation', 'Solar Radiation', '894', '014028', 'W/m^2', NULL, NULL, '0'),
	(12, 'WATRDPTH', 'WaterDepth', 'Water Depth', '918', NULL, 'mm', NULL, NULL, '1467'),
	(13, 'WATRTEMP', 'WaterTemp', 'Water Temperature', '917', NULL, 'deg \'c', NULL, NULL, '21.5'),
	(14, 'SOILMOIST', 'SoilMoisture', 'Soil Moisture', '915', NULL, 'm^3/m^3', NULL, NULL, NULL);
/*!40000 ALTER TABLE `aws_tahmo` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_toa5_bw1
CREATE TABLE IF NOT EXISTS `aws_toa5_bw1` (
  `Cols` int(11) DEFAULT '0',
  `Element_Abbreviation` varchar(50) DEFAULT NULL,
  `Element_Name` varchar(50) DEFAULT NULL,
  `Element_Details` varchar(50) DEFAULT NULL,
  `Climsoft_Element` varchar(6) DEFAULT NULL,
  `Bufr_Element` varchar(6) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `lower_limit` varchar(50) DEFAULT NULL,
  `upper_limit` varchar(50) DEFAULT NULL,
  `obsv` varchar(50) DEFAULT NULL,
  UNIQUE KEY `identification` (`Element_Abbreviation`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_toa5_bw1: ~16 rows (approximately)
/*!40000 ALTER TABLE `aws_toa5_bw1` DISABLE KEYS */;
INSERT INTO `aws_toa5_bw1` (`Cols`, `Element_Abbreviation`, `Element_Name`, `Element_Details`, `Climsoft_Element`, `Bufr_Element`, `unit`, `lower_limit`, `upper_limit`, `obsv`) VALUES
	(1, 'Date/time', 'date/time', 'Datetime', NULL, NULL, NULL, NULL, NULL, NULL),
	(2, 'RECORD', 'record', 'Record number', NULL, NULL, NULL, NULL, NULL, NULL),
	(3, 'BATTV', 'BattV_Avg', 'Battery Power', NULL, NULL, NULL, NULL, NULL, NULL),
	(4, 'BATT24V', 'Batt24V_Avg', 'Daily Average Battery Power', NULL, NULL, NULL, NULL, NULL, NULL),
	(5, 'TRACKERWM', 'TrackerWM_Avg', 'Tracker', NULL, NULL, NULL, NULL, NULL, NULL),
	(6, 'SHADOWWM', 'ShadowWM_Avg', 'Shadow', NULL, NULL, NULL, NULL, NULL, NULL),
	(7, 'SUNWM', 'SunWM_Avg', 'Sloar Radiation', '894', '014028', 'W/m2', NULL, NULL, NULL),
	(8, 'WSV', 'WS_ms_S_WVT', 'Wind Speed Average', '897', '011002', 'Knots', NULL, NULL, NULL),
	(9, 'WINDDIRD', 'WindDir_D1_WVT', 'Wind Direction Average', '895', '011001', 'Deg', NULL, NULL, NULL),
	(10, 'WINDDIRS', 'WindDir_SD1_WVT', 'Wind Gust Direction', '887', NULL, NULL, NULL, NULL, NULL),
	(11, 'WSX', 'WS_ms_Max', 'Wind Gust Speed', '886', '011041', 'Knots', NULL, NULL, NULL),
	(12, 'AIRTC', 'AirTc_Avg', 'Air Temperature', '881', '012101', '°C', NULL, NULL, NULL),
	(13, 'RH', 'RH', 'Relative Humidity', '893', '013003', '%', NULL, NULL, NULL),
	(14, 'BPAR', 'BP_mbar_Avg', 'Pressure', '884', '010004', 'Hpa', NULL, NULL, NULL),
	(15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
/*!40000 ALTER TABLE `aws_toa5_bw1` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.aws_toa5_mg2
CREATE TABLE IF NOT EXISTS `aws_toa5_mg2` (
  `Cols` bigint(20) NOT NULL,
  `Element_Abbreviation` varchar(50) DEFAULT NULL,
  `Element_Name` varchar(50) DEFAULT NULL,
  `Element_Details` varchar(50) DEFAULT NULL,
  `Climsoft_Element` varchar(6) DEFAULT NULL,
  `Bufr_Element` varchar(6) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `lower_limit` varchar(50) DEFAULT NULL,
  `upper_limit` varchar(50) DEFAULT NULL,
  `obsv` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`Cols`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.aws_toa5_mg2: ~140 rows (approximately)
/*!40000 ALTER TABLE `aws_toa5_mg2` DISABLE KEYS */;
INSERT INTO `aws_toa5_mg2` (`Cols`, `Element_Abbreviation`, `Element_Name`, `Element_Details`, `Climsoft_Element`, `Bufr_Element`, `unit`, `lower_limit`, `upper_limit`, `obsv`) VALUES
	(1, 'Date/time', 'Date/time', 'Date and time', NULL, NULL, NULL, NULL, NULL, '01/12/2015 11:00'),
	(2, 'RECORD', 'RECORD', 'Record number', NULL, NULL, NULL, NULL, NULL, '348577'),
	(3, 'AirTemp_1m', 'AirTemp_1m', 'Air Temperature at 1 metre', '881', '012103', '\'C', NULL, NULL, '20.29727'),
	(4, 'AirTemp_1m_Err', 'AirTemp_1m_Err', 'Air Temperature at 1 metre error', NULL, NULL, NULL, NULL, NULL, '0'),
	(5, 'TEMP_MAX_24HR', 'TEMP_MAX_24HR', 'TEMP MAX for 24HR', '882', '012111', '\'C', NULL, NULL, '28.84937'),
	(6, 'TEMP_MAX_24HR_AT', 'TEMP_MAX_24HR_AT', 'TEMP MAX for 24HR Time', NULL, NULL, NULL, NULL, NULL, '30/11/2014 10:12'),
	(7, 'TEMP_MAX_24HR_Err', 'TEMP_MAX_24HR_Err', 'TEMP MAX for 24HR Error', NULL, NULL, NULL, NULL, NULL, '0'),
	(8, 'TEMP_MIN_24HR', 'TEMP_MIN_24HR', 'TEMP MIN for 24HR', '883', '012112', '\'C', NULL, NULL, '17.79975'),
	(9, 'TEMP_MIN_24HR_AT', 'TEMP_MIN_24HR_AT', 'TEMP MIN for 24HR Time', NULL, NULL, NULL, NULL, NULL, '30/11/2014 01:16'),
	(10, 'TEMP_MIN_24HR_Err', 'TEMP_MIN_24HR_Err', 'TEMP MIN for 24HR Error', NULL, NULL, NULL, NULL, NULL, '0'),
	(11, 'DB_1m', 'DB_1m', 'Dry bulb, 1 minute average', NULL, NULL, NULL, NULL, NULL, '20.29727'),
	(12, 'DB_1m_Err', 'DB_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(13, 'DB2_1m', 'DB2_1m', 'DB2_1m', NULL, NULL, NULL, NULL, NULL, NULL),
	(14, 'DB2_1m_Err', 'DB2_1m_Err', 'DB2_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(15, 'WB_1m', 'WB_1m', 'WB_1m', NULL, NULL, NULL, NULL, NULL, NULL),
	(16, 'WB_1m_Err', 'WB_1m_Err', 'WB_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(17, 'GRA_1m', 'GRA_1m', 'GRA_1m', NULL, NULL, NULL, NULL, NULL, NULL),
	(18, 'GRA_1m_Err', 'GRA_1m_Err', 'GRA_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(19, 'CON_1m', 'CON_1m', 'CON_1m', NULL, NULL, NULL, NULL, NULL, NULL),
	(20, 'CON_1m_Err', 'CON_1m_Err', 'CON_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(21, 'S10_1m', 'S10_1m', 'S10_1m', NULL, '012130', '\'C', NULL, '', NULL),
	(22, 'S10_1m_Err', 'S10_1m_Err', 'S10_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(23, 'S30_1m', 'S30_1m', 'S30_1m', NULL, NULL, NULL, NULL, NULL, NULL),
	(24, 'S30_1m_Err', 'S30_1m_Err', 'S30_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(25, 'S100_1m', 'S100_1m', 'S100_1m', NULL, NULL, NULL, NULL, NULL, NULL),
	(26, 'S100_1m_Err', 'S100_1m_Err', 'S100_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(27, 'RH_1m', 'RH_1m', 'Relative humidity, 1 min average', '893', '013003', '%', NULL, NULL, '85.4'),
	(28, 'RH_1m_Err', 'RH_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(29, 'RHT_1m', 'RHT_1m', 'Temperature from RH sensor', NULL, NULL, NULL, NULL, NULL, '19.9338'),
	(30, 'RHT_1m_Err', 'RHT_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(31, 'DewPT_WB_1m', 'DewPT_WB_1m', 'DewPT_WB_1m', NULL, NULL, NULL, NULL, NULL, NULL),
	(32, 'DewPT_WB_1m_Err', 'DewPT_WB_1m_Err', 'DewPT_WB_1m_Err', NULL, NULL, NULL, NULL, NULL, '1281'),
	(33, 'DewPT_RH_1m', 'DewPT_RH_1m', 'Dew-point (calculated from RH sensor) ', '885', '012103', '°C', NULL, NULL, '17.76225'),
	(34, 'DewPT_RH_1m_Err', 'DewPT_RH_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(35, 'RH_DBWB_1m', 'RH_DBWB_1m', 'RH_DBWB_1m', NULL, NULL, NULL, NULL, NULL, NULL),
	(36, 'RH_DBWB_1m_Err', 'RH_DBWB_1m_Err', 'RH_DBWB_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(37, 'WS_1m', 'WS_1m', 'Wind speed, 1 min average', NULL, NULL, 'Knots', NULL, NULL, '3.38'),
	(38, 'WS_1m_Err', 'WS_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(39, 'WD_1m', 'WD_1m', 'Wind direction, 1 min average', NULL, NULL, 'Degree', NULL, NULL, '54.84'),
	(40, 'WD_1m_Err', 'WD_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(41, 'WS_2m', 'WS_2m', 'Wind Speed at 2m', NULL, NULL, NULL, NULL, NULL, '3.738'),
	(42, 'WS_2m_Err', 'WS_2m_Err', 'Wind Speed at 2m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(43, 'WD_2m', 'WD_2m', 'Wind Direction at 2m', NULL, NULL, NULL, NULL, NULL, '60.15'),
	(44, 'WD_2m_Err', 'WD_2m_Err', 'Wind Direction at 2m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(45, 'WS_10m', 'WS_10m', 'Wind Speed at 10m', '897', '011002', 'Knots', NULL, NULL, '4.028'),
	(46, 'WS_10m_Err', 'WS_10m_Err', 'Wind Speed at 10m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(47, 'WD_10m', 'WD_10m', 'Wind Direction at 10m', '895', '011001', 'Degree', NULL, NULL, '56.13'),
	(48, 'WD_10m_Err', 'WD_10m_Err', 'Wind Direction at 10m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(49, 'MAXGust', 'MAXGust', 'Maximum wind gust speed', NULL, NULL, NULL, NULL, NULL, '4.167'),
	(50, 'MaxGust_TIME', 'MaxGust_TIME', 'Time of above', NULL, NULL, NULL, NULL, NULL, '30/11/2014 13:59'),
	(51, 'MaxGust_WD', 'MaxGust_WD', 'Maximum wind gust direction', NULL, NULL, 'Degree', NULL, NULL, '54.06'),
	(52, 'MAXGust_10m', 'MAXGust_10m', 'Maximum wind gust speed at 10m', '886', '011041', 'Knots', NULL, NULL, '6.3'),
	(53, 'MaxGust_TIME_10m', 'MaxGust_TIME_10m', 'MaxGust TIME at 10m', NULL, NULL, NULL, NULL, NULL, '30/11/2014 13:57'),
	(54, 'MaxGust_WD_10m', 'MaxGust_WD_10m', 'MaxGust direction at 10m', '887', '011043', 'Knots', NULL, NULL, '60.25'),
	(55, 'MAXGust_60m', 'MAXGust_60m', 'MaxGust speed at 60m', NULL, NULL, NULL, NULL, NULL, '15.08'),
	(56, 'MaxGust_TIME_60m', 'MaxGust_TIME_60m', 'MaxGust tIME at 60m', NULL, NULL, NULL, NULL, NULL, '30/11/2014 13:22'),
	(57, 'MaxGust_WD_60m', 'MaxGust_WD_60m', 'MaxGust direction at 60m', NULL, NULL, NULL, NULL, NULL, '284.9'),
	(58, 'MostBacked_2m', 'MostBacked_2m', 'MostBacked at 2m', NULL, NULL, NULL, NULL, NULL, '17.5'),
	(59, 'MostVeered_2m', 'MostVeered_2m', 'MostVeered at 2m', NULL, NULL, NULL, NULL, NULL, '110.4'),
	(60, 'MostBacked_10m', 'MostBacked_10m', 'Most backed direction over past 10 mins', NULL, NULL, 'Degree', NULL, NULL, '14'),
	(61, 'MostVeered_10m', 'MostVeered_10m', 'Most veered direction over past 10 mins', NULL, NULL, 'Degree', NULL, NULL, '110.4'),
	(62, 'MD_WS_10m', 'MD_WS_10m', 'MD WS 10m', NULL, NULL, NULL, NULL, NULL, NULL),
	(63, 'MD_WS_10m', 'MD_WS_10m', 'MD WS 10m', NULL, NULL, NULL, NULL, NULL, NULL),
	(64, 'MD_WS_10m_Err', 'MD_WS_10m_Err', 'MD WS 10m error', NULL, NULL, NULL, NULL, NULL, '257'),
	(65, 'MD_WD_10m_Err', 'MD_WD_10m_Err', 'MD WD 10m error', NULL, NULL, NULL, NULL, NULL, '257'),
	(66, 'MD_MAXGust_10m', 'MD_MAXGust_10m', 'MD MAXGust speed at 10m', NULL, NULL, NULL, NULL, NULL, NULL),
	(67, 'MD_MAXGust_WD_10m', 'MD_MAXGust_WD_10m', 'MD MAXGust direction at 10m', NULL, NULL, NULL, NULL, NULL, NULL),
	(68, 'MD_MAXGust_TIME_10m', 'MD_MAXGust_TIME_10m', 'MD MAXGust tIME at 10m', NULL, NULL, NULL, NULL, NULL, '13/12/1921 20:45'),
	(69, 'MD_MAXGust_10m_Err', 'MD_MAXGust_10m_Err', 'MD MAXGust 10m error', NULL, NULL, NULL, NULL, NULL, '257'),
	(70, 'MD_MAXGust_WD_10m_Err', 'MD_MAXGust_WD_10m_Err', 'MD MAXGust WD 10m error', NULL, NULL, NULL, NULL, NULL, '257'),
	(71, 'MD_MAXGust_TIME_10m_Err', 'MD_MAXGust_TIME_10m_Err', 'MD MAXGust TIME 10m error', NULL, NULL, NULL, NULL, NULL, '257'),
	(72, 'RAIN_mm_1m', 'RAIN_mm_1m', 'Total rain over 1 min', '892', '013011', 'mm', NULL, NULL, '0'),
	(73, 'RAIN_mm_1m_Err', 'RAIN_mm_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(74, 'RAIN_SINCE_0850', 'RAIN_SINCE_0850', 'RAIN SINCE 0850', NULL, NULL, NULL, NULL, NULL, '4'),
	(75, 'RAIN_SINCE_0850_Err', 'RAIN_SINCE_0850_Err', 'RAIN SINCE 0850_Err', NULL, NULL, NULL, NULL, NULL, '0'),
	(76, 'SNOW_1m', 'SNOW_1m', 'SNOW_1m', NULL, '013013', 'mm', NULL, NULL, '0'),
	(77, 'SNOW_1m_Err', 'SNOW_1m_Err', 'SNOW_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(78, 'CLOUD_1st_1m', 'CLOUD_1st_1m', 'CLOUD_1st_1m', NULL, NULL, NULL, NULL, NULL, '-2147483648'),
	(79, 'CLOUD_1st_1m_Err', 'CLOUD_1st_1m_Err', 'CLOUD_1st_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(80, 'CLOUD_2nd_1m', 'CLOUD_2nd_1m', 'CLOUD_2nd_1m', NULL, NULL, NULL, NULL, NULL, '-2147483648'),
	(81, 'CLOUD_2nd_1m_Err', 'CLOUD_2nd_1m_Err', 'CLOUD_2nd_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(82, 'CLOUD_3rd_1m', 'CLOUD_3rd_1m', 'CLOUD_3rd_1m', NULL, NULL, NULL, NULL, NULL, '-2147483648'),
	(83, 'CLOUD_3rd_1m_Err', 'CLOUD_3rd_1m_Err', 'CLOUD_3rd_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(84, 'CLOUD30s_1st_1m', 'CLOUD30s_1st_1m', 'CLOUD30s_1st_1m', NULL, NULL, NULL, NULL, NULL, '-2147483648'),
	(85, 'CLOUD30s_1st_1m_Err', 'CLOUD30s_1st_1m_Err', 'CLOUD30s_1st_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(86, 'CLOUD30s_2nd_1m', 'CLOUD30s_2nd_1m', 'CLOUD30s_2nd_1m', NULL, NULL, NULL, NULL, NULL, '-2147483648'),
	(87, 'CLOUD30s_2nd_1m_Err', 'CLOUD30s_2nd_1m_Err', 'CLOUD30s_2nd_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(88, 'CLOUD30s_3rd_1m', 'CLOUD30s_3rd_1m', 'CLOUD30s_3rd_1m', NULL, NULL, NULL, NULL, NULL, '-2147483648'),
	(89, 'CLOUD30s_3rd_1m_Err', 'CLOUD30s_3rd_1m_Err', 'CLOUD30s_3rd_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(90, 'CLOUD_VertVis_1m', 'CLOUD_VertVis_1m', 'CLOUD_VertVis_1m', NULL, NULL, NULL, NULL, NULL, '0'),
	(91, 'VIZ_1m', 'VIZ_1m', 'Visibility at 1m', NULL, '020001', 'm', NULL, NULL, '0'),
	(92, 'VIZ_1m_Err', 'VIZ_1m_Err', 'Visibility at 1m error', NULL, NULL, NULL, NULL, NULL, '1024'),
	(93, 'MD_VIZ_10m', 'MD_VIZ_10m', 'MD visibility at 10m', NULL, NULL, NULL, NULL, NULL, '0'),
	(94, 'MD_VIZ_10m_Err', 'MD_VIZ_10m_Err', 'MD visibility at 10m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(95, 'PW_Code_1m', 'PW_Code_1m', 'PW Code 1m', NULL, NULL, NULL, NULL, NULL, '0'),
	(96, 'BP_1m', 'BP_1m', 'Barometric Pressure, 1 min average', '884', '010004', 'HPa', NULL, NULL, '867.04'),
	(97, 'BP_1m_Err', 'BP_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(98, 'BP_QNH_1m', 'BP_QNH_1m', 'QNH, 1 min average', '891', '007004', 'HPa', NULL, NULL, '1014.939'),
	(99, 'BP_QNH_1m_Err', 'BP_QNH_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(100, 'BP_QFF_1m', 'BP_QFF_1m', 'QFF, 1 min average', '890', '010051', 'HPa', NULL, NULL, '1009.688'),
	(101, 'BP_QFF_1m_Err', 'BP_QFF_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(102, 'BP_QFE_1m', 'BP_QFE_1m', 'QFE, 1 min average', '889', NULL, 'HPa', NULL, NULL, '867.2416'),
	(103, 'BP_QFE_1m_Err', 'BP_QFE_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(104, 'BP_QNHinHg_1m', 'BP_QNHinHg_1m', 'QNH, inches of mercury, 1 min average', NULL, NULL, NULL, NULL, NULL, '29.96'),
	(105, 'BP_QNHinHg_1m_Err', 'BP_QNHinHg_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(106, 'BP_QFEinHg_1m', 'BP_QFEinHg_1m', 'QFE, inches of mercury, 1 min average', NULL, NULL, NULL, NULL, NULL, '25.6'),
	(107, 'BP_QFEinHg_1m_Err', 'BP_QFEinHg_1m_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(108, 'BP_Difference_3hr', 'BP_Difference_3hr', '3-hour pressure change', NULL, '010061', 'HPa', NULL, NULL, '-0.06750488'),
	(109, 'BP_Characteristic_3hr', 'BP_Characteristic_3hr', 'Pressure trend', NULL, '010063', 'HPa', NULL, NULL, '5'),
	(110, 'WET_1m', 'WET_1m', 'WET_1m', NULL, NULL, NULL, NULL, NULL, '0'),
	(111, 'WET_1m_Err', 'WET_1m_Err', 'WET_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(112, 'RAD_1m', 'RAD_1m', 'RAD_1m', NULL, '014028', 'Joules', NULL, NULL, '0'),
	(113, 'RAD_1m_Err', 'RAD_1m_Err', 'RAD_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(114, 'SUN_1m', 'SUN_1m', 'SUN_1m', NULL, '014031', 'Joules', NULL, NULL, '0'),
	(115, 'SUN_1m_Err', 'SUN_1m_Err', 'SUN_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(116, 'SunnySUN_1m', 'SunnySUN_1m', 'SunnySUN_1m', NULL, NULL, NULL, NULL, NULL, '0'),
	(117, 'SunnySUN_1m_Err', 'SunnySUN_1m_Err', 'SunnySUN_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(118, 'SunnyRAD_1m', 'SunnyRAD_1m', 'SunnyRAD_1m', NULL, NULL, NULL, NULL, NULL, '0'),
	(119, 'SunnyRAD_1m_Err', 'SunnyRAD_1m_Err', 'SunnyRAD_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(120, 'TEMP_MAX_24HR_AT_ERR', 'TEMP_MAX_24HR_AT_ERR', 'TEMP MAX for 24HR AT error', NULL, NULL, NULL, NULL, NULL, '0'),
	(121, 'TEMP_MIN_24HR_AT_ERR', 'TEMP_MIN_24HR_AT_ERR', 'TEMP MIN for 24HR AT error', NULL, NULL, NULL, NULL, NULL, '0'),
	(122, 'BP_Difference_3hr_Err', 'BP_Difference_3hr_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(123, 'BP_Characteristic_3hr_Err', 'BP_Characteristic_3hr_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(124, 'PW_Code_1m_Err', 'PW_Code_1m_Err', 'PW_Code_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(125, 'PW_Precipitation_1m', 'PW_Precipitation_1m', 'PW_Precipitation_1m', NULL, NULL, NULL, NULL, NULL, '0'),
	(126, 'PW_Precipitation_1m_Err', 'PW_Precipitation_1m_Err', 'PW_Precipitation_1m_Err', NULL, NULL, NULL, NULL, NULL, '1024'),
	(127, 'MAXGust_Err', 'MAXGust_Err', 'Binary Quality Flags', NULL, NULL, NULL, NULL, NULL, '0'),
	(128, 'MAXGust_10m_Err', 'MAXGust_10m_Err', 'MAXGust speed at 10m Err', NULL, NULL, NULL, NULL, NULL, '0'),
	(129, 'MAXGust_60m_Err', 'MAXGust_60m_Err', 'MAXGust speed at 60m_Err', NULL, NULL, NULL, NULL, NULL, '0'),
	(130, 'MaxGust_TIME_Err', 'MaxGust_TIME_Err', 'MaxGust TIME error', NULL, NULL, NULL, NULL, NULL, '0'),
	(131, 'MaxGust_TIME_10m_Err', 'MaxGust_TIME_10m_Err', 'MaxGust time at 10m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(132, 'MaxGust_TIME_60m_Err', 'MaxGust_TIME_60m_Err', 'MaxGust time at 60m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(133, 'MaxGust_WD_Err', 'MaxGust_WD_Err', 'MaxGust WD error', NULL, NULL, NULL, NULL, NULL, '0'),
	(134, 'MaxGust_WD_10m_Err', 'MaxGust_WD_10m_Err', 'MaxGust_WD_10m_Err', NULL, NULL, NULL, NULL, NULL, '0'),
	(135, 'MaxGust_WD_60m_Err', 'MaxGust_WD_60m_Err', 'MaxGust WD at 60m eror', NULL, NULL, NULL, NULL, NULL, '0'),
	(136, 'MostBacked_2m_Err', 'MostBacked_2m_Err', 'MostBacked at 2m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(137, 'MostBacked_10m_Err', 'MostBacked_10m_Err', 'MostBacked at 10m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(138, 'MostVeered_2m_Err', 'MostVeered_2m_Err', 'MostVeered at 2m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(139, 'MostVeered_10m_Err', 'MostVeered_10m_Err', 'MostVeered at 10m error', NULL, NULL, NULL, NULL, NULL, '0'),
	(140, 'CLOUD_VertVis_1m_Err', 'CLOUD_VertVis_1m_Err', 'CLOUD VertVis at 1m error', NULL, NULL, NULL, NULL, NULL, '1024');
/*!40000 ALTER TABLE `aws_toa5_mg2` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.bufr_crex_data
CREATE TABLE IF NOT EXISTS `bufr_crex_data` (
  `nos` int(11) DEFAULT '0',
  `Bufr_Template` varchar(50) DEFAULT NULL,
  `Crex_Template` varchar(50) DEFAULT NULL,
  `Sequence_Descriptor1` varchar(50) DEFAULT NULL,
  `Sequence_Descriptor0` varchar(50) DEFAULT NULL,
  `Bufr_Element` varchar(50) DEFAULT NULL,
  `Crex_Element` varchar(255) DEFAULT NULL,
  `Climsoft_Element` varchar(255) DEFAULT NULL,
  `Element_Name` varchar(255) DEFAULT NULL,
  `Crex_Unit` varchar(25) DEFAULT NULL,
  `Crex_Scale` varchar(25) NOT NULL,
  `Crex_DataWidth` varchar(25) NOT NULL,
  `Bufr_Unit` varchar(255) NOT NULL,
  `Bufr_Scale` varchar(25) NOT NULL DEFAULT '0',
  `Bufr_RefValue` varchar(50) DEFAULT '0',
  `Bufr_DataWidth_Bits` varchar(50) DEFAULT '0',
  `selected` tinyint(4) DEFAULT NULL,
  `Observation` varchar(255) DEFAULT NULL,
  `Crex_Data` varchar(30) DEFAULT NULL,
  `Bufr_Data` varchar(255) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.bufr_crex_data: ~308 rows (approximately)
/*!40000 ALTER TABLE `bufr_crex_data` DISABLE KEYS */;
INSERT INTO `bufr_crex_data` (`nos`, `Bufr_Template`, `Crex_Template`, `Sequence_Descriptor1`, `Sequence_Descriptor0`, `Bufr_Element`, `Crex_Element`, `Climsoft_Element`, `Element_Name`, `Crex_Unit`, `Crex_Scale`, `Crex_DataWidth`, `Bufr_Unit`, `Bufr_Scale`, `Bufr_RefValue`, `Bufr_DataWidth_Bits`, `selected`, `Observation`, `Crex_Data`, `Bufr_Data`) VALUES
	(1, '307081', 'D07081', 'D01090', 'D01004', '001001', 'B01001', 'station_WMO_bloc', 'WMO block number', 'Numeric', '0', '2', 'Numeric', '0', '0', '7', 1, '63', '', '0111111'),
	(2, NULL, NULL, '', '', '001002', 'B01002', 'station_WMO_number', 'WMO station number                                   ', 'Numeric', '0', '3', 'Numeric', '0', '0', '10', 1, '741', '', '1011100101'),
	(3, NULL, NULL, '', '', '001015', 'B01015', 'station_name', 'Station or site name', 'Character', '0', '20', 'CCITT IA5', '0', '0', '160', 1, 'DAGORETTI CORNER MET', '', '0100010001000001010001110100111101010010010001010101010001010100010010010010000001000011010011110101001001001110010001010101001000100000010011010100010101010100'),
	(4, NULL, NULL, '', '', '002001', 'B02001', 'station_qualifier', 'Type of station                                             ', 'Code table', '0', '1', 'Code table', '0', '0', '2', 1, '1', '', '01'),
	(5, NULL, NULL, '', 'D01011', '004001', 'B04001', 'datetime_year', 'Year', 'Year', '0', '4', 'Year', '0', '0', '12', 1, '2017', '', '011111100001'),
	(6, NULL, NULL, '', '', '004002', 'B04002', 'datetime_month', 'Month', 'Month', '0', '2', 'Month', '0', '0', '4', 1, '12', '', '1100'),
	(7, NULL, NULL, '', '', '004003', 'B04003', 'datetime_day', 'Day', 'Day', '0', '2', 'Day', '0', '0', '6', 1, '12', '', '001100'),
	(8, NULL, NULL, '', 'D01012', '004004', 'B04004', 'datetime_hour', 'Hour', 'Hour', '0', '2', 'Hour', '0', '0', '5', 1, '6', '', '00110'),
	(9, NULL, NULL, '', '', '004005', 'B04005', 'datetime_minute', 'Minute', 'Minute', '0', '2', 'Minute', '0', '0', '6', 1, '00', '', '000000'),
	(10, NULL, NULL, '', 'D01021', '005001', 'B05001', 'station_deglatitude', 'Latitude (high accuracy)', 'Degree', '5', '7', 'Degree', '5', '-9000000', '25', 1, '-1.3', '', '0100001110101100001110000'),
	(11, NULL, NULL, '', '', '006001', 'B06001', 'station_deglongitude', 'Longitude (high accuracy)', 'Degree', '5', '8', 'Degree', '5', '-18000000', '26', 1, '36.75', '', '01010010101011101111111000'),
	(12, NULL, NULL, '', 'B07030', '007030', 'B07030', 'station_elevation', 'Height of station ground above mean sea level', 'm', '1', '5', 'm', '1', '-4000', '17', 1, '1798', '', '00101010111011100'),
	(13, NULL, NULL, '', 'B07031', '007031', 'B07031', 'station_pressure_height', 'Height of barometer above mean sea level', 'm', '1', '5', 'm', '1', '-4000', '17', 1, '1.25', '', '00000111110101100'),
	(14, NULL, NULL, 'D02031', 'D02001', '010004', 'B10004', '106', 'Pressure', 'Pa', ' -1', '5', 'Pa', '-1', '0', '14', 1, '876100', '', '10001000111001'),
	(15, NULL, NULL, '', '', '010051', 'B10051', '107', 'Pressure reduced to mean sea level', 'Pa', '-1', '5', 'Pa', '-1', '0', '14', 1, '1073700', '', '10100111110001'),
	(16, NULL, NULL, '', '', '010061', 'B10061', '400', '3-hour pressure change', 'Pa', '-1', '4', 'Pa', '-1', '-500', '10', 1, '200', '', '1000001000'),
	(17, NULL, NULL, '', '', '010063', 'B10063', '814', 'Characteristic of pressure tendency', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '4', '', '0100'),
	(18, NULL, NULL, '', 'B10062', '010062', 'B10062', '399', '24-hour pressure change', 'Pa', '-1', '4', 'Pa', '-1', '-1000', '11', 1, '300', '', '01111101011'),
	(19, NULL, NULL, '', 'B07004', '007004', 'B07004', '301', 'Pressure (standard level) ', 'Pa', '-1', '5', 'Pa', '-1', '0', '14', 1, '85000', '', '10000100110100'),
	(20, NULL, NULL, '', 'B10009', '010009', 'B10009', '185', 'Geopotential height of the standard level', 'gpm', '0', '5', 'gpm', '0', '-1000', '17', 1, '1540', '', '00000100111101100'),
	(21, NULL, NULL, 'D02035', 'D02032', '007032', 'B07032', 'Temp_SH', 'Height of sensor above local ground (for temperature and humidity measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '1.25', '', '0000000001111101'),
	(22, NULL, NULL, '', '', '012101', 'B12101', '101', 'Temperature/Dry bulb (scale 2) at height and over period specified', '°C', '2', '4', 'K', '2', '0', '16', 1, '231', '', '0111001110111001'),
	(23, NULL, NULL, '', '', '012103', 'B12103', '103', 'Dew-point temperature (scale 2)', '°C', '2', '4', 'K', '2', '0', '16', 1, '190', '', '0111001000011111'),
	(24, NULL, NULL, '', '', '013003', 'B13003', '105', 'Relative humidity', '%', '0', '3', '%', '0', '0', '7', 1, '78', '', '1001110'),
	(25, NULL, NULL, '', 'D02033', '007032', 'B07032', 'Vis_SH', 'Height of sensor above local ground (for visibility measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '1.5', '', '0000000010010110'),
	(26, NULL, NULL, '', '', '020001', 'B20001', '110', 'Horizontal Visibility', 'm', '-1', '4', 'm', '-1', '0', '13', 1, '40000', '', '0000110010000'),
	(27, NULL, NULL, '', 'D02034', '007032', 'B07032', 'R24_SH', 'Height of sensor above local ground (for precipitation measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '0.25', '', '0000000000011001'),
	(28, NULL, NULL, '', '', '013023', 'B13023', '5', 'Total precipitation Past 24 Hrs', 'kg m-2', '1', '5', 'kg m-2', '1', '-1', '14', 1, '250', '', '00000011111011'),
	(29, NULL, NULL, '', 'B07032', '007032', 'B07032', 'Cancel_SH', 'Height of sensor above local ground (set to missing to cancel the previous table)', 'm', '2', '5', 'm', '2', '0', '16', 1, '', '', '1111111111111111'),
	(30, NULL, NULL, '', 'D02004', '020010', 'B20010', '114', 'Cloud cover (total)', '%', '0', '3', '%', '0', '0', '7', 1, '75', '', '1001011'),
	(31, NULL, NULL, '', '', '008002', 'B08002', '115', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '7', '', '000111'),
	(32, NULL, NULL, '', '', '020011', 'B20011', '168', 'Cloud amount (of low or middle clouds)', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '5', '', '0101'),
	(33, NULL, NULL, '', '', '020013', 'B20013', '192', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 1, '800', '', '00001111000'),
	(34, NULL, NULL, '', '', '020012', 'B20012', '169', 'Cloud type (low clouds CL)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '12', '', '001100'),
	(35, NULL, NULL, '', '', '020012', 'B20012', '170', 'Cloud type (low clouds CM)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '21', '', '010101'),
	(36, NULL, NULL, '', '', '020012', 'B20012', '171', 'Cloud type (low clouds CH)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '31', '', '011111'),
	(38, NULL, NULL, '', 'B31001', '031001', 'B31001', 'cloud_rep1', 'Delayed descriptor replication factor', 'Numeric', '0', '4', 'Numeric', '0', '0', '8', 1, '1', '', '00000001'),
	(39, NULL, NULL, '', 'D02005', '008002', 'B08002', '119', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '5', '', '000101'),
	(40, NULL, NULL, '', '', '020011', 'B20011', '116', 'Cloud amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '1', '', '0001'),
	(41, NULL, NULL, '', '', '020012', 'B20012', '117', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '8', '', '001000'),
	(42, NULL, NULL, '', '', '020013', 'B20013', '118', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 1, '1000', '', '00010001100'),
	(43, NULL, NULL, '', '', '008002', 'B08002', '123', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(44, NULL, NULL, '', '', '020011', 'B20011', '120', 'Cloud amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(45, NULL, NULL, '', '', '020012', 'B20012', '121', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(46, NULL, NULL, '', '', '020013', 'B20013', '122', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(47, NULL, NULL, '', '', '008002', 'B08002', '127', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(48, NULL, NULL, '', '', '020011', 'B20011', '124', 'Cloud amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(49, NULL, NULL, '', '', '020012', 'B20012', '125', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(50, NULL, NULL, '', '', '020013', 'B20013', '126', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(51, NULL, NULL, '', '', '008002', 'B08002', '131', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(52, NULL, NULL, '', '', '020011', 'B20011', '128', 'Cloud amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(53, NULL, NULL, '', '', '020012', 'B20012', '129', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(54, NULL, NULL, '', '', '020013', 'B20013', '130', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(56, NULL, NULL, NULL, 'B31001', '031001', 'B31001', 'cloud_rep2', 'Delayed descriptor replication factor', 'Numeric', '0', '4', 'Numeric', '0', '0', '8', 1, '0', '', '00000000'),
	(57, NULL, NULL, 'D02036', 'B08002', '008002', 'B08002', '611', 'Vertical Significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(58, NULL, NULL, '', 'B20011', '020011', 'B20011', '612', 'Clound amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(59, NULL, NULL, '', 'B20012', '020012', 'B20012', '613', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(60, NULL, NULL, '', 'B20014', '020014', 'B20014', '614', 'Height of top of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(61, NULL, NULL, '', 'B20017', '020017', 'B20017', '615', 'Cloud top description', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(62, NULL, NULL, '', 'B08002', '008002', 'B08002', '621', 'Vertical Significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(63, NULL, NULL, '', 'B20011', '020011', 'B20011', '622', 'Clound amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(64, NULL, NULL, '', 'B20012', '020012', 'B20012', '623', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(65, NULL, NULL, '', 'B20014', '020014', 'B20014', '624', 'Height of top of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(66, NULL, NULL, '', 'B20017', '020017', 'B20017', '625', 'Cloud top description', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(67, NULL, NULL, '', 'B08002', '008002', 'B08002', '631', 'Vertical Significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(68, NULL, NULL, '', 'B20011', '020011', 'B20011', '632', 'Clound amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(69, NULL, NULL, '', 'B20012', '020012', 'B20012', '633', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(70, NULL, NULL, '', 'B20014', '020014', 'B20014', '634', 'Height of top of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(71, NULL, NULL, '', 'B20017', '020017', 'B20017', '635', 'Cloud top description', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(72, NULL, NULL, '', 'B08002', '008002', 'B08002', '641', 'Vertical Significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(73, NULL, NULL, '', 'B20011', '020011', 'B20011', '642', 'Clound amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(74, NULL, NULL, '', 'B20012', '020012', 'B20012', '643', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(75, NULL, NULL, '', 'B20014', '020014', 'B20014', '644', 'Height of top of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(76, NULL, NULL, '', 'B20017', '020017', 'B20017', '645', 'Cloud top description', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(78, NULL, NULL, 'D02047', 'B08002', '008002', 'B08002', '651', 'Vertical Significance =7 (low cloud) =8 (middle cloud) =9 (high cloud)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(79, NULL, NULL, '', 'B20054', '020054', 'B20054', '652', 'True  direction from which clouds are moving', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(80, NULL, NULL, '', 'B08002', '008002', 'B08002', '653', 'Vertical Significance =7 (low cloud) =8 (middle cloud) =9 (high cloud)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(81, NULL, NULL, '', 'B20054', '020054', 'B20054', '654', 'True  direction from which clouds are moving', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(82, NULL, NULL, '', 'B08002', '008002', 'B08002', '655', 'Vertical Significance =7 (low cloud) =8 (middle cloud) =9 (high cloud)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(83, NULL, NULL, '', 'B20054', '020054', 'B20054', '656', 'True  direction from which clouds are moving', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(84, NULL, NULL, 'B08002', '', '008002', 'B08002', 'vert_sig_cancel', 'Vertical significance (set to missing to cancel the previous value)    ', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(85, NULL, NULL, 'D02048', 'B05021', '005021', 'B05021', '661', 'Bearing or azimuth', 'Degree true', '2', '5', 'Degree true', '2', '0', '16', 1, '', '', '1111111111111111'),
	(86, NULL, NULL, '', 'B07021', '007021', 'B07021', '662', 'Elevation angle ', 'Degree', '2', '5', 'Degree', '2', '-9000', '15', 1, '', '', '111111111111111'),
	(87, NULL, NULL, '', 'B20012', '020012', 'B20012', '663', 'Cloud type ', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(88, NULL, NULL, '', 'B05021', '005021', 'B05021', '664', 'Bearing or azimuth (set to missing to cancel the previous value) ', 'Degree true', '2', '5', 'Degree true', '2', '0', '16', 1, '', '', '1111111111111111'),
	(89, NULL, NULL, '', 'B07021', '007021', 'B07021', '665', 'Elevation angle (set to missing to cancel the previous value)', 'Degree', '2', '5', 'Degree', '2', '-9000', '15', 1, '', '', '111111111111111'),
	(90, NULL, NULL, 'D02037', 'B20062', '020062', 'B20062', '51', 'State of ground (with or without snow)', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '', '', '11111'),
	(91, NULL, NULL, '', 'B13013', '013013', 'B13013', '50', 'Total snow depth', 'm', '2', '5', 'm', '2', '-2', '16', 1, '9', '', '0000001110000110'),
	(92, NULL, NULL, '', 'B12113', '012113', 'B12113', '585', 'Ground minimum temperature past 12 hrs', '°C', '2', '4', 'K', '2', '0', '16', 1, '', '', '1111111111111111'),
	(93, NULL, NULL, 'B12122', '', '012122', 'B12122', '85', 'Ground minimum temperature of the preceeding night', '°C', '2', '4', 'K', '2', '0', '16', 1, '', '', '1111111111111111'),
	(94, NULL, NULL, 'B13056', '', '013056', 'B13056', '505', 'Character and Intensity of precipitation', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '2', '', '0010'),
	(95, NULL, NULL, 'B13057', '', '013057', 'B13057', '506', 'Time of beginning or end of precipitation', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(96, NULL, NULL, 'B20101', '', '020101', 'B20101', '701', 'Locust (Acridian) name', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(97, NULL, NULL, 'B20102', '', '020102', 'B20102', '702', 'Locust (Maturity) colour', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(98, NULL, NULL, 'B20103', '', '020103', 'B20103', '704', 'Stage of development of locusts', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(99, NULL, NULL, 'B20104', '', '020104', 'B20104', '705', 'Organization state of swam or band of locusts', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(100, NULL, NULL, 'B20105', '', '020105', 'B20105', '706', 'Size of swam or band of locusts and duration of passage of time', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(101, NULL, NULL, 'B20106', '', '020106', 'B20106', '707', 'Locust population density', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(102, NULL, NULL, 'B20107', '', '020107', 'B20107', '708', 'Direction of movements of locust swarm', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(103, NULL, NULL, 'B20108', '', '020108', 'B20108', '710', 'Extent of vegetation', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(104, NULL, NULL, 'D02043', 'D02038', '020003', 'B20003', '167', 'Present weather ', 'Code table', '0', '3', 'Code table', '0', '0', '9', 1, '5', '', '000000101'),
	(105, NULL, NULL, '', '', '004024', 'B04024', 'ww_TP', 'Time period in hours', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-6', '', '011111111010'),
	(106, NULL, NULL, '', '', '020004', 'B20004', '197', 'Past weather (1) ', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '3', '', '00011'),
	(107, NULL, NULL, '', '', '020005', 'B20005', '193', 'Past weather (2) ', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '3', '', '00011'),
	(109, NULL, NULL, '', 'D02039', '004024', 'B04024', 'SSS_TP', 'Time period in hours', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-24', '', '011111101000'),
	(110, NULL, NULL, '', '', '014031', 'B14031', '84', 'Total sunshine ', 'Minute', '0', '4', 'Minute', '0', '0', '11', 1, '3600', '', '00101101000'),
	(111, NULL, NULL, '', '', '004024', 'B04024', 'SS_TP', 'Time period or displacement in hours', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-1', '', '011111111111'),
	(112, NULL, NULL, '', '', '014031', 'B14031', '132', 'Total sunshine in minutes (2nd replication)', 'Minute', '0', '4', 'Minute', '0', '0', '11', 1, '30', '', '00000011110'),
	(113, NULL, NULL, '', 'D02040', '007032', 'B07032', 'RR_SH', 'Height of sensor above local ground (for precipiation measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '0.25', '', '0000000000011001'),
	(115, NULL, NULL, '', '', '004024', 'B04024', 'tR_TP', 'Time period in hours', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-3', '', '011111111101'),
	(116, NULL, NULL, '', '', '013011', 'B13011', '5', 'Total precipitation RRR', 'kg m-2', '1', '5', 'kg m-2', '1', '-1', '14', 1, '250', '', '00000011111011'),
	(117, NULL, NULL, '', '', '004024', 'B04024', 'tr_TP', 'Time period or displacement', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-3', '', '011111111101'),
	(118, NULL, NULL, '', '', '013011', 'B13011', '174', 'Total precipitation', 'kg m-2', '1', '5', 'kg m-2', '1', '-1', '14', 1, '10', '', '00000000001011'),
	(119, NULL, NULL, '', 'D02041', '007032', 'B07032', 'xt_SH', 'Height of sensor above local ground (for temperature measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '1.25', '', '0000000001111101'),
	(120, NULL, NULL, '', '', '004024', 'B04024', 'xt_TP', 'Time period or displacement                         ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-12', '', '011111110100'),
	(121, NULL, NULL, '', '', '004024', 'B04024', 'xt0_TP', 'Time period or displacement (see Notes 1 and 2)                      ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '0', '', '100000000000'),
	(122, NULL, NULL, '', '', '012111', 'B12111', '2', 'Maximum temperature (scale 2) at height and over period specified', '°C', '2', '4', 'K', '2', '0', '16', 1, '282', '', '0111010110110111'),
	(123, NULL, NULL, '', '', '004024', 'B04024', 'nt_TP', 'Time period or displacement                         ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-12', '', '011111110100'),
	(124, NULL, NULL, '', '', '004024', 'B04024', 'nt0_TP', 'Time period or displacement (see Notes 2)                      ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-0', '', '100000000000'),
	(125, NULL, NULL, '', '', '012112', 'B12112', '3', 'Minimum temperature (scale 2) at height and over period specified ', '°C', '2', '4', 'K', '2', '0', '16', 1, '176', '', '0111000110010011'),
	(126, NULL, NULL, '', 'D02042', '007032', 'B07032', 'w_SH', 'Height of sensor above local ground (for wind measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '10', '', '0000001111101000'),
	(127, NULL, NULL, '', '', '002002', 'B02002', 'w_I', 'Type of instrumentation for wind measurement', 'Flag table', '0', '2', 'Flag table', '0', '0', '4', 1, '04', '', '0100'),
	(128, NULL, NULL, '', '', '008021', 'B08021', 'w_TS', 'Time significance (= 2 (time averaged))', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '2', '', '00010'),
	(129, NULL, NULL, '', '', '004025', 'B04025', 'w_TP', 'Time period (= - 10 minutes, or number of minutes after a significant change of wind)', 'Minute', '0', '4', 'Minute', '0', '-2048', '12', 1, '-10', '', '011111110110'),
	(130, NULL, NULL, '', '', '011001', 'B11001', '112', 'Wind direction', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '105', '', '001101001'),
	(131, NULL, NULL, '', '', '011002', 'B11002', '111', 'Wind speed ', 'm s-1', '1', '4', 'm s-1', '1', '0', '12', 1, '4', '', '000000101000'),
	(132, NULL, NULL, '', '', '008021', 'B08021', 'w1_TS', 'Time significance (= missing value)', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '', '', '11111'),
	(134, NULL, NULL, '', '', '004025', 'B04025', 'w1_TP', 'Time period in minutes   ', 'Minute', '0', '4', 'Minute', '0', '-2048', '12', 1, '', '', '111111111111'),
	(135, NULL, NULL, '', '', '011043', 'B11043', '59', 'Maximum wind gust direction', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(136, NULL, NULL, '', '', '011041', 'B11041', '58', 'Maximum wind gust speed', 'm s-1', '1', '4', 'm s-1', '1', '0', '12', 1, '', '', '111111111111'),
	(137, NULL, NULL, '', '', '004025', 'B04025', 'w2_TP', 'Time period in minutes   ', 'Minute', '0', '4', 'Minute', '0', '-2048', '12', 1, '', '', '111111111111'),
	(138, NULL, NULL, '', '', '011043', 'B11043', '591', 'Maximum wind gust direction', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(139, NULL, NULL, '', '', '011041', 'B11041', '581', 'Maximum wind gust speed', 'm s-1', '1', '4', 'm s-1', '1', '0', '12', 1, '', '', '111111111111'),
	(140, NULL, NULL, '', 'B07032', '007032', 'B07032', 'evap_SH', 'Height of sensor above local ground (for evaporation measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '0.25', '', '0000000000011001'),
	(141, NULL, NULL, 'D02044', 'B04024', '004024', 'B04024', 'evap_TP', 'Time period in hours              =  - 24', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-24', '', '011111101000'),
	(142, NULL, NULL, '', 'B02004', '002004', 'B02004', 'evap_I', 'Type of instrument for evaporation or crop for evapotranspiration', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '01', '', '0001'),
	(143, NULL, NULL, '', 'B13033', '013033', 'B13033', '18', 'Evaporation /evapotranspiration', 'kg m-2', '1', '4', 'kg m-2', '1', '0', '10', 1, '50', '', '0000110010'),
	(145, NULL, NULL, 'D02045', 'B04024', '004024', 'B04024', 'rad1_TP', 'Time period or displacement', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-1', '', '011111111111'),
	(146, NULL, NULL, '', 'B14002', '014002', 'B14002', '536', 'Long-wave radiation, integrated over period specified ', 'J m-2', '-3', '4', 'J m-2', '-3', '-2048', '12', 1, '', '', '111111111111'),
	(147, NULL, NULL, '', 'B14004', '014004', 'B14004', '533', 'Short-wave radiation, integrated over period specified ', 'J m-2', '-3', '4', 'J m-2', '-3', '-2048', '12', 1, '', '', '111111111111'),
	(148, NULL, NULL, '', 'B14016', '014016', 'B14016', '46_1', 'Net radiation, integrated over period specified', 'J m-2', '-4', '5', 'J m-2', '-4', '-16384', '15', 1, '', '', '111111111111111'),
	(149, NULL, NULL, '', 'B14028', '014028', 'B14028', '133', 'Global solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(150, NULL, NULL, '', 'B14029', '014029', 'B14029', '97', 'Diffuse solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(151, NULL, NULL, '', 'B14030', '014030', 'B14030', '139', 'Direct solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(152, NULL, NULL, '', 'B04024', '004024', 'B04024', 'rad2_TP', 'Time period or displacement', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-24', '', '011111101000'),
	(153, NULL, NULL, '', 'B14002', '014002', 'B14002', '536_1', 'Long-wave radiation, integrated over period specified ', 'J m-2', '-3', '4', 'J m-2', '-3', '-2048', '12', 1, '', '', '111111111111'),
	(154, NULL, NULL, '', 'B14004', '014004', 'B14004', '533_1', 'Short-wave radiation, integrated over period specified ', 'J m-2', '-3', '4', 'J m-2', '-3', '-2048', '12', 1, '', '', '111111111111'),
	(155, NULL, NULL, '', 'B14016', '014016', 'B14016', '46', 'Net radiation, integrated over period specified', 'J m-2', '-4', '5', 'J m-2', '-4', '-16384', '15', 1, '262000000', '', '100101000111100'),
	(156, NULL, NULL, '', 'B14028', '014028', 'B14028', '133_1', 'Global solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(157, NULL, NULL, '', 'B14029', '014029', 'B14029', '97_1', 'Diffuse solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(158, NULL, NULL, '', 'B14030', '014030', 'B14030', '139_1', 'Direct solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(159, NULL, NULL, 'D02046', 'B04024', '004024', 'B04024', 'tempc_t', 'Time period or displacement                         ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-6', '', '011111111010'),
	(160, NULL, NULL, '', 'B04024', '004024', 'B04024', 'tempc1_t', 'Time period or displacement (see Note 3)       ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '', '', '111111111111'),
	(161, NULL, NULL, '', 'B12049', '012049', 'B12049', '94', 'Temperature change over period specified', '°C', '0', '2', 'K', '0', '-30', '6', 1, '', '', '111111'),
	(1, '307081', 'D07081', 'D01090', 'D01004', '001001', 'B01001', 'station_WMO_bloc', 'WMO block number', 'Numeric', '0', '2', 'Numeric', '0', '0', '7', 1, '63', '', '0111111'),
	(2, NULL, NULL, '', '', '001002', 'B01002', 'station_WMO_number', 'WMO station number                                   ', 'Numeric', '0', '3', 'Numeric', '0', '0', '10', 1, '741', '', '1011100101'),
	(3, NULL, NULL, '', '', '001015', 'B01015', 'station_name', 'Station or site name', 'Character', '0', '20', 'CCITT IA5', '0', '0', '160', 1, 'DAGORETTI CORNER MET', '', '0100010001000001010001110100111101010010010001010101010001010100010010010010000001000011010011110101001001001110010001010101001000100000010011010100010101010100'),
	(4, NULL, NULL, '', '', '002001', 'B02001', 'station_qualifier', 'Type of station                                             ', 'Code table', '0', '1', 'Code table', '0', '0', '2', 1, '1', '', '01'),
	(5, NULL, NULL, '', 'D01011', '004001', 'B04001', 'datetime_year', 'Year', 'Year', '0', '4', 'Year', '0', '0', '12', 1, '2017', '', '011111100001'),
	(6, NULL, NULL, '', '', '004002', 'B04002', 'datetime_month', 'Month', 'Month', '0', '2', 'Month', '0', '0', '4', 1, '12', '', '1100'),
	(7, NULL, NULL, '', '', '004003', 'B04003', 'datetime_day', 'Day', 'Day', '0', '2', 'Day', '0', '0', '6', 1, '12', '', '001100'),
	(8, NULL, NULL, '', 'D01012', '004004', 'B04004', 'datetime_hour', 'Hour', 'Hour', '0', '2', 'Hour', '0', '0', '5', 1, '6', '', '00110'),
	(9, NULL, NULL, '', '', '004005', 'B04005', 'datetime_minute', 'Minute', 'Minute', '0', '2', 'Minute', '0', '0', '6', 1, '00', '', '000000'),
	(10, NULL, NULL, '', 'D01021', '005001', 'B05001', 'station_deglatitude', 'Latitude (high accuracy)', 'Degree', '5', '7', 'Degree', '5', '-9000000', '25', 1, '-1.3', '', '0100001110101100001110000'),
	(11, NULL, NULL, '', '', '006001', 'B06001', 'station_deglongitude', 'Longitude (high accuracy)', 'Degree', '5', '8', 'Degree', '5', '-18000000', '26', 1, '36.75', '', '01010010101011101111111000'),
	(12, NULL, NULL, '', 'B07030', '007030', 'B07030', 'station_elevation', 'Height of station ground above mean sea level', 'm', '1', '5', 'm', '1', '-4000', '17', 1, '1798', '', '00101010111011100'),
	(13, NULL, NULL, '', 'B07031', '007031', 'B07031', 'station_pressure_height', 'Height of barometer above mean sea level', 'm', '1', '5', 'm', '1', '-4000', '17', 1, '1.25', '', '00000111110101100'),
	(14, NULL, NULL, 'D02031', 'D02001', '010004', 'B10004', '106', 'Pressure', 'Pa', ' -1', '5', 'Pa', '-1', '0', '14', 1, '876100', '', '10001000111001'),
	(15, NULL, NULL, '', '', '010051', 'B10051', '107', 'Pressure reduced to mean sea level', 'Pa', '-1', '5', 'Pa', '-1', '0', '14', 1, '1073700', '', '10100111110001'),
	(16, NULL, NULL, '', '', '010061', 'B10061', '400', '3-hour pressure change', 'Pa', '-1', '4', 'Pa', '-1', '-500', '10', 1, '200', '', '1000001000'),
	(17, NULL, NULL, '', '', '010063', 'B10063', '814', 'Characteristic of pressure tendency', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '4', '', '0100'),
	(18, NULL, NULL, '', 'B10062', '010062', 'B10062', '399', '24-hour pressure change', 'Pa', '-1', '4', 'Pa', '-1', '-1000', '11', 1, '300', '', '01111101011'),
	(19, NULL, NULL, '', 'B07004', '007004', 'B07004', '301', 'Pressure (standard level) ', 'Pa', '-1', '5', 'Pa', '-1', '0', '14', 1, '85000', '', '10000100110100'),
	(20, NULL, NULL, '', 'B10009', '010009', 'B10009', '185', 'Geopotential height of the standard level', 'gpm', '0', '5', 'gpm', '0', '-1000', '17', 1, '1540', '', '00000100111101100'),
	(21, NULL, NULL, 'D02035', 'D02032', '007032', 'B07032', 'Temp_SH', 'Height of sensor above local ground (for temperature and humidity measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '1.25', '', '0000000001111101'),
	(22, NULL, NULL, '', '', '012101', 'B12101', '101', 'Temperature/Dry bulb (scale 2) at height and over period specified', '°C', '2', '4', 'K', '2', '0', '16', 1, '231', '', '0111001110111001'),
	(23, NULL, NULL, '', '', '012103', 'B12103', '103', 'Dew-point temperature (scale 2)', '°C', '2', '4', 'K', '2', '0', '16', 1, '190', '', '0111001000011111'),
	(24, NULL, NULL, '', '', '013003', 'B13003', '105', 'Relative humidity', '%', '0', '3', '%', '0', '0', '7', 1, '78', '', '1001110'),
	(25, NULL, NULL, '', 'D02033', '007032', 'B07032', 'Vis_SH', 'Height of sensor above local ground (for visibility measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '1.5', '', '0000000010010110'),
	(26, NULL, NULL, '', '', '020001', 'B20001', '110', 'Horizontal Visibility', 'm', '-1', '4', 'm', '-1', '0', '13', 1, '40000', '', '0000110010000'),
	(27, NULL, NULL, '', 'D02034', '007032', 'B07032', 'R24_SH', 'Height of sensor above local ground (for precipitation measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '0.25', '', '0000000000011001'),
	(28, NULL, NULL, '', '', '013023', 'B13023', '5', 'Total precipitation Past 24 Hrs', 'kg m-2', '1', '5', 'kg m-2', '1', '-1', '14', 1, '250', '', '00000011111011'),
	(29, NULL, NULL, '', 'B07032', '007032', 'B07032', 'Cancel_SH', 'Height of sensor above local ground (set to missing to cancel the previous table)', 'm', '2', '5', 'm', '2', '0', '16', 1, '', '', '1111111111111111'),
	(30, NULL, NULL, '', 'D02004', '020010', 'B20010', '114', 'Cloud cover (total)', '%', '0', '3', '%', '0', '0', '7', 1, '75', '', '1001011'),
	(31, NULL, NULL, '', '', '008002', 'B08002', '115', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '7', '', '000111'),
	(32, NULL, NULL, '', '', '020011', 'B20011', '168', 'Cloud amount (of low or middle clouds)', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '5', '', '0101'),
	(33, NULL, NULL, '', '', '020013', 'B20013', '192', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 1, '800', '', '00001111000'),
	(34, NULL, NULL, '', '', '020012', 'B20012', '169', 'Cloud type (low clouds CL)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '12', '', '001100'),
	(35, NULL, NULL, '', '', '020012', 'B20012', '170', 'Cloud type (low clouds CM)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '21', '', '010101'),
	(36, NULL, NULL, '', '', '020012', 'B20012', '171', 'Cloud type (low clouds CH)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '31', '', '011111'),
	(38, NULL, NULL, '', 'B31001', '031001', 'B31001', 'cloud_rep1', 'Delayed descriptor replication factor', 'Numeric', '0', '4', 'Numeric', '0', '0', '8', 1, '1', '', '00000001'),
	(39, NULL, NULL, '', 'D02005', '008002', 'B08002', '119', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '5', '', '000101'),
	(40, NULL, NULL, '', '', '020011', 'B20011', '116', 'Cloud amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '1', '', '0001'),
	(41, NULL, NULL, '', '', '020012', 'B20012', '117', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '8', '', '001000'),
	(42, NULL, NULL, '', '', '020013', 'B20013', '118', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 1, '1000', '', '00010001100'),
	(43, NULL, NULL, '', '', '008002', 'B08002', '123', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(44, NULL, NULL, '', '', '020011', 'B20011', '120', 'Cloud amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(45, NULL, NULL, '', '', '020012', 'B20012', '121', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(46, NULL, NULL, '', '', '020013', 'B20013', '122', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(47, NULL, NULL, '', '', '008002', 'B08002', '127', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(48, NULL, NULL, '', '', '020011', 'B20011', '124', 'Cloud amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(49, NULL, NULL, '', '', '020012', 'B20012', '125', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(50, NULL, NULL, '', '', '020013', 'B20013', '126', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(51, NULL, NULL, '', '', '008002', 'B08002', '131', 'Vertical significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(52, NULL, NULL, '', '', '020011', 'B20011', '128', 'Cloud amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(53, NULL, NULL, '', '', '020012', 'B20012', '129', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(54, NULL, NULL, '', '', '020013', 'B20013', '130', 'Height of base of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(56, NULL, NULL, NULL, 'B31001', '031001', 'B31001', 'cloud_rep2', 'Delayed descriptor replication factor', 'Numeric', '0', '4', 'Numeric', '0', '0', '8', 1, '0', '', '00000000'),
	(57, NULL, NULL, 'D02036', 'B08002', '008002', 'B08002', '611', 'Vertical Significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(58, NULL, NULL, '', 'B20011', '020011', 'B20011', '612', 'Clound amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(59, NULL, NULL, '', 'B20012', '020012', 'B20012', '613', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(60, NULL, NULL, '', 'B20014', '020014', 'B20014', '614', 'Height of top of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(61, NULL, NULL, '', 'B20017', '020017', 'B20017', '615', 'Cloud top description', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(62, NULL, NULL, '', 'B08002', '008002', 'B08002', '621', 'Vertical Significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(63, NULL, NULL, '', 'B20011', '020011', 'B20011', '622', 'Clound amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(64, NULL, NULL, '', 'B20012', '020012', 'B20012', '623', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(65, NULL, NULL, '', 'B20014', '020014', 'B20014', '624', 'Height of top of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(66, NULL, NULL, '', 'B20017', '020017', 'B20017', '625', 'Cloud top description', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(67, NULL, NULL, '', 'B08002', '008002', 'B08002', '631', 'Vertical Significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(68, NULL, NULL, '', 'B20011', '020011', 'B20011', '632', 'Clound amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(69, NULL, NULL, '', 'B20012', '020012', 'B20012', '633', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(70, NULL, NULL, '', 'B20014', '020014', 'B20014', '634', 'Height of top of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(71, NULL, NULL, '', 'B20017', '020017', 'B20017', '635', 'Cloud top description', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(72, NULL, NULL, '', 'B08002', '008002', 'B08002', '641', 'Vertical Significance', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(73, NULL, NULL, '', 'B20011', '020011', 'B20011', '642', 'Clound amount', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(74, NULL, NULL, '', 'B20012', '020012', 'B20012', '643', 'Cloud type', 'Code table', '0', '2', 'Code table', '0', '0', '6', 0, '', '', '111111'),
	(75, NULL, NULL, '', 'B20014', '020014', 'B20014', '644', 'Height of top of cloud', 'm', '-1', '4', 'm', '-1', '-40', '11', 0, '', '', '11111111111'),
	(76, NULL, NULL, '', 'B20017', '020017', 'B20017', '645', 'Cloud top description', 'Code table', '0', '2', 'Code table', '0', '0', '4', 0, '', '', '1111'),
	(78, NULL, NULL, 'D02047', 'B08002', '008002', 'B08002', '651', 'Vertical Significance =7 (low cloud) =8 (middle cloud) =9 (high cloud)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(79, NULL, NULL, '', 'B20054', '020054', 'B20054', '652', 'True  direction from which clouds are moving', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(80, NULL, NULL, '', 'B08002', '008002', 'B08002', '653', 'Vertical Significance =7 (low cloud) =8 (middle cloud) =9 (high cloud)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(81, NULL, NULL, '', 'B20054', '020054', 'B20054', '654', 'True  direction from which clouds are moving', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(82, NULL, NULL, '', 'B08002', '008002', 'B08002', '655', 'Vertical Significance =7 (low cloud) =8 (middle cloud) =9 (high cloud)', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(83, NULL, NULL, '', 'B20054', '020054', 'B20054', '656', 'True  direction from which clouds are moving', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(84, NULL, NULL, 'B08002', '', '008002', 'B08002', 'vert_sig_cancel', 'Vertical significance (set to missing to cancel the previous value)    ', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(85, NULL, NULL, 'D02048', 'B05021', '005021', 'B05021', '661', 'Bearing or azimuth', 'Degree true', '2', '5', 'Degree true', '2', '0', '16', 1, '', '', '1111111111111111'),
	(86, NULL, NULL, '', 'B07021', '007021', 'B07021', '662', 'Elevation angle ', 'Degree', '2', '5', 'Degree', '2', '-9000', '15', 1, '', '', '111111111111111'),
	(87, NULL, NULL, '', 'B20012', '020012', 'B20012', '663', 'Cloud type ', 'Code table', '0', '2', 'Code table', '0', '0', '6', 1, '', '', '111111'),
	(88, NULL, NULL, '', 'B05021', '005021', 'B05021', '664', 'Bearing or azimuth (set to missing to cancel the previous value) ', 'Degree true', '2', '5', 'Degree true', '2', '0', '16', 1, '', '', '1111111111111111'),
	(89, NULL, NULL, '', 'B07021', '007021', 'B07021', '665', 'Elevation angle (set to missing to cancel the previous value)', 'Degree', '2', '5', 'Degree', '2', '-9000', '15', 1, '', '', '111111111111111'),
	(90, NULL, NULL, 'D02037', 'B20062', '020062', 'B20062', '51', 'State of ground (with or without snow)', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '', '', '11111'),
	(91, NULL, NULL, '', 'B13013', '013013', 'B13013', '50', 'Total snow depth', 'm', '2', '5', 'm', '2', '-2', '16', 1, '9', '', '0000001110000110'),
	(92, NULL, NULL, '', 'B12113', '012113', 'B12113', '585', 'Ground minimum temperature past 12 hrs', '°C', '2', '4', 'K', '2', '0', '16', 1, '', '', '1111111111111111'),
	(93, NULL, NULL, 'B12122', '', '012122', 'B12122', '85', 'Ground minimum temperature of the preceeding night', '°C', '2', '4', 'K', '2', '0', '16', 1, '', '', '1111111111111111'),
	(94, NULL, NULL, 'B13056', '', '013056', 'B13056', '505', 'Character and Intensity of precipitation', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '2', '', '0010'),
	(95, NULL, NULL, 'B13057', '', '013057', 'B13057', '506', 'Time of beginning or end of precipitation', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(96, NULL, NULL, 'B20101', '', '020101', 'B20101', '701', 'Locust (Acridian) name', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(97, NULL, NULL, 'B20102', '', '020102', 'B20102', '702', 'Locust (Maturity) colour', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(98, NULL, NULL, 'B20103', '', '020103', 'B20103', '704', 'Stage of development of locusts', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(99, NULL, NULL, 'B20104', '', '020104', 'B20104', '705', 'Organization state of swam or band of locusts', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(100, NULL, NULL, 'B20105', '', '020105', 'B20105', '706', 'Size of swam or band of locusts and duration of passage of time', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(101, NULL, NULL, 'B20106', '', '020106', 'B20106', '707', 'Locust population density', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(102, NULL, NULL, 'B20107', '', '020107', 'B20107', '708', 'Direction of movements of locust swarm', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(103, NULL, NULL, 'B20108', '', '020108', 'B20108', '710', 'Extent of vegetation', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '', '', '1111'),
	(104, NULL, NULL, 'D02043', 'D02038', '020003', 'B20003', '167', 'Present weather ', 'Code table', '0', '3', 'Code table', '0', '0', '9', 1, '5', '', '000000101'),
	(105, NULL, NULL, '', '', '004024', 'B04024', 'ww_TP', 'Time period in hours', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-6', '', '011111111010'),
	(106, NULL, NULL, '', '', '020004', 'B20004', '197', 'Past weather (1) ', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '3', '', '00011'),
	(107, NULL, NULL, '', '', '020005', 'B20005', '193', 'Past weather (2) ', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '3', '', '00011'),
	(109, NULL, NULL, '', 'D02039', '004024', 'B04024', 'SSS_TP', 'Time period in hours', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-24', '', '011111101000'),
	(110, NULL, NULL, '', '', '014031', 'B14031', '84', 'Total sunshine ', 'Minute', '0', '4', 'Minute', '0', '0', '11', 1, '3600', '', '00101101000'),
	(111, NULL, NULL, '', '', '004024', 'B04024', 'SS_TP', 'Time period or displacement in hours', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-1', '', '011111111111'),
	(112, NULL, NULL, '', '', '014031', 'B14031', '132', 'Total sunshine in minutes (2nd replication)', 'Minute', '0', '4', 'Minute', '0', '0', '11', 1, '30', '', '00000011110'),
	(113, NULL, NULL, '', 'D02040', '007032', 'B07032', 'RR_SH', 'Height of sensor above local ground (for precipiation measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '0.25', '', '0000000000011001'),
	(115, NULL, NULL, '', '', '004024', 'B04024', 'tR_TP', 'Time period in hours', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-3', '', '011111111101'),
	(116, NULL, NULL, '', '', '013011', 'B13011', '5', 'Total precipitation RRR', 'kg m-2', '1', '5', 'kg m-2', '1', '-1', '14', 1, '250', '', '00000011111011'),
	(117, NULL, NULL, '', '', '004024', 'B04024', 'tr_TP', 'Time period or displacement', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-3', '', '011111111101'),
	(118, NULL, NULL, '', '', '013011', 'B13011', '174', 'Total precipitation', 'kg m-2', '1', '5', 'kg m-2', '1', '-1', '14', 1, '10', '', '00000000001011'),
	(119, NULL, NULL, '', 'D02041', '007032', 'B07032', 'xt_SH', 'Height of sensor above local ground (for temperature measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '1.25', '', '0000000001111101'),
	(120, NULL, NULL, '', '', '004024', 'B04024', 'xt_TP', 'Time period or displacement                         ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-12', '', '011111110100'),
	(121, NULL, NULL, '', '', '004024', 'B04024', 'xt0_TP', 'Time period or displacement (see Notes 1 and 2)                      ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '0', '', '100000000000'),
	(122, NULL, NULL, '', '', '012111', 'B12111', '2', 'Maximum temperature (scale 2) at height and over period specified', '°C', '2', '4', 'K', '2', '0', '16', 1, '282', '', '0111010110110111'),
	(123, NULL, NULL, '', '', '004024', 'B04024', 'nt_TP', 'Time period or displacement                         ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-12', '', '011111110100'),
	(124, NULL, NULL, '', '', '004024', 'B04024', 'nt0_TP', 'Time period or displacement (see Notes 2)                      ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-0', '', '100000000000'),
	(125, NULL, NULL, '', '', '012112', 'B12112', '3', 'Minimum temperature (scale 2) at height and over period specified ', '°C', '2', '4', 'K', '2', '0', '16', 1, '176', '', '0111000110010011'),
	(126, NULL, NULL, '', 'D02042', '007032', 'B07032', 'w_SH', 'Height of sensor above local ground (for wind measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '10', '', '0000001111101000'),
	(127, NULL, NULL, '', '', '002002', 'B02002', 'w_I', 'Type of instrumentation for wind measurement', 'Flag table', '0', '2', 'Flag table', '0', '0', '4', 1, '04', '', '0100'),
	(128, NULL, NULL, '', '', '008021', 'B08021', 'w_TS', 'Time significance (= 2 (time averaged))', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '2', '', '00010'),
	(129, NULL, NULL, '', '', '004025', 'B04025', 'w_TP', 'Time period (= - 10 minutes, or number of minutes after a significant change of wind)', 'Minute', '0', '4', 'Minute', '0', '-2048', '12', 1, '-10', '', '011111110110'),
	(130, NULL, NULL, '', '', '011001', 'B11001', '112', 'Wind direction', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '105', '', '001101001'),
	(131, NULL, NULL, '', '', '011002', 'B11002', '111', 'Wind speed ', 'm s-1', '1', '4', 'm s-1', '1', '0', '12', 1, '4', '', '000000101000'),
	(132, NULL, NULL, '', '', '008021', 'B08021', 'w1_TS', 'Time significance (= missing value)', 'Code table', '0', '2', 'Code table', '0', '0', '5', 1, '', '', '11111'),
	(134, NULL, NULL, '', '', '004025', 'B04025', 'w1_TP', 'Time period in minutes   ', 'Minute', '0', '4', 'Minute', '0', '-2048', '12', 1, '', '', '111111111111'),
	(135, NULL, NULL, '', '', '011043', 'B11043', '59', 'Maximum wind gust direction', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(136, NULL, NULL, '', '', '011041', 'B11041', '58', 'Maximum wind gust speed', 'm s-1', '1', '4', 'm s-1', '1', '0', '12', 1, '', '', '111111111111'),
	(137, NULL, NULL, '', '', '004025', 'B04025', 'w2_TP', 'Time period in minutes   ', 'Minute', '0', '4', 'Minute', '0', '-2048', '12', 1, '', '', '111111111111'),
	(138, NULL, NULL, '', '', '011043', 'B11043', '591', 'Maximum wind gust direction', 'Degree true', '0', '3', 'Degree true', '0', '0', '9', 1, '', '', '111111111'),
	(139, NULL, NULL, '', '', '011041', 'B11041', '581', 'Maximum wind gust speed', 'm s-1', '1', '4', 'm s-1', '1', '0', '12', 1, '', '', '111111111111'),
	(140, NULL, NULL, '', 'B07032', '007032', 'B07032', 'evap_SH', 'Height of sensor above local ground (for evaporation measurement)', 'm', '2', '5', 'm', '2', '0', '16', 1, '0.25', '', '0000000000011001'),
	(141, NULL, NULL, 'D02044', 'B04024', '004024', 'B04024', 'evap_TP', 'Time period in hours              =  - 24', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-24', '', '011111101000'),
	(142, NULL, NULL, '', 'B02004', '002004', 'B02004', 'evap_I', 'Type of instrument for evaporation or crop for evapotranspiration', 'Code table', '0', '2', 'Code table', '0', '0', '4', 1, '01', '', '0001'),
	(143, NULL, NULL, '', 'B13033', '013033', 'B13033', '18', 'Evaporation /evapotranspiration', 'kg m-2', '1', '4', 'kg m-2', '1', '0', '10', 1, '50', '', '0000110010'),
	(145, NULL, NULL, 'D02045', 'B04024', '004024', 'B04024', 'rad1_TP', 'Time period or displacement', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-1', '', '011111111111'),
	(146, NULL, NULL, '', 'B14002', '014002', 'B14002', '536', 'Long-wave radiation, integrated over period specified ', 'J m-2', '-3', '4', 'J m-2', '-3', '-2048', '12', 1, '', '', '111111111111'),
	(147, NULL, NULL, '', 'B14004', '014004', 'B14004', '533', 'Short-wave radiation, integrated over period specified ', 'J m-2', '-3', '4', 'J m-2', '-3', '-2048', '12', 1, '', '', '111111111111'),
	(148, NULL, NULL, '', 'B14016', '014016', 'B14016', '46_1', 'Net radiation, integrated over period specified', 'J m-2', '-4', '5', 'J m-2', '-4', '-16384', '15', 1, '', '', '111111111111111'),
	(149, NULL, NULL, '', 'B14028', '014028', 'B14028', '133', 'Global solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(150, NULL, NULL, '', 'B14029', '014029', 'B14029', '97', 'Diffuse solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(151, NULL, NULL, '', 'B14030', '014030', 'B14030', '139', 'Direct solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(152, NULL, NULL, '', 'B04024', '004024', 'B04024', 'rad2_TP', 'Time period or displacement', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-24', '', '011111101000'),
	(153, NULL, NULL, '', 'B14002', '014002', 'B14002', '536_1', 'Long-wave radiation, integrated over period specified ', 'J m-2', '-3', '4', 'J m-2', '-3', '-2048', '12', 1, '', '', '111111111111'),
	(154, NULL, NULL, '', 'B14004', '014004', 'B14004', '533_1', 'Short-wave radiation, integrated over period specified ', 'J m-2', '-3', '4', 'J m-2', '-3', '-2048', '12', 1, '', '', '111111111111'),
	(155, NULL, NULL, '', 'B14016', '014016', 'B14016', '46', 'Net radiation, integrated over period specified', 'J m-2', '-4', '5', 'J m-2', '-4', '-16384', '15', 1, '262000000', '', '100101000111100'),
	(156, NULL, NULL, '', 'B14028', '014028', 'B14028', '133_1', 'Global solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(157, NULL, NULL, '', 'B14029', '014029', 'B14029', '97_1', 'Diffuse solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(158, NULL, NULL, '', 'B14030', '014030', 'B14030', '139_1', 'Direct solar radiation (high accuracy), integrated over period specified', 'J m-2', '-2', '5', 'J m-2', '-2', '0', '16', 1, '', '', '1111111111111111'),
	(159, NULL, NULL, 'D02046', 'B04024', '004024', 'B04024', 'tempc_t', 'Time period or displacement                         ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '-6', '', '011111111010'),
	(160, NULL, NULL, '', 'B04024', '004024', 'B04024', 'tempc1_t', 'Time period or displacement (see Note 3)       ', 'Hour', '0', '4', 'Hour', '0', '-2048', '12', 1, '', '', '111111111111'),
	(161, NULL, NULL, '', 'B12049', '012049', 'B12049', '94', 'Temperature change over period specified', '°C', '0', '2', 'K', '0', '-30', '6', 1, '', '', '111111');
/*!40000 ALTER TABLE `bufr_crex_data` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.bufr_crex_master
CREATE TABLE IF NOT EXISTS `bufr_crex_master` (
  `Bufr_FXY` varchar(6) NOT NULL,
  `Crex_Fxxyyy` varchar(255) NOT NULL,
  `ElementName` varchar(255) NOT NULL,
  `Bufr_Unit` varchar(255) NOT NULL,
  `Bufr_Scale` varchar(25) NOT NULL DEFAULT '0',
  `Bufr_RefValue` varchar(50) DEFAULT '0',
  `Bufr_DataWidth_Bits` varchar(50) DEFAULT '0',
  `Crex_Unit` varchar(25) DEFAULT NULL,
  `Crex_Scale` varchar(25) NOT NULL,
  `Crex_DataWidth` varchar(25) NOT NULL,
  `Observation` varchar(255) DEFAULT NULL,
  `Crex_Data` varchar(30) DEFAULT NULL,
  `Bufr_Data` varchar(255) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.bufr_crex_master: ~2,366 rows (approximately)
/*!40000 ALTER TABLE `bufr_crex_master` DISABLE KEYS */;
INSERT INTO `bufr_crex_master` (`Bufr_FXY`, `Crex_Fxxyyy`, `ElementName`, `Bufr_Unit`, `Bufr_Scale`, `Bufr_RefValue`, `Bufr_DataWidth_Bits`, `Crex_Unit`, `Crex_Scale`, `Crex_DataWidth`, `Observation`, `Crex_Data`, `Bufr_Data`) VALUES
	('000001', 'B00001', 'Table A: entry', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000002', 'B00002', 'Table A: data category description line 1', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('000003', 'B00003', 'Table A: data category description line 2', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('000004', 'B00004', 'BUFR/CREX Master table (see Note 2)', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000005', 'B00005', 'BUFR/CREX edition number', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000006', 'B00006', 'BUFR Master table Version number (see Note 3)', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000007', 'B00007', 'CREX Master table Version number (see Note 4)', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000008', 'B00008', 'BUFR Local table version number (see Note 5)', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000010', 'B00010', 'F descriptor to be added or defined', 'CCITT IA5', '0', '0', '8', 'Character', '0', '1', '', '', ''),
	('000011', 'B00011', 'X descriptor to be added or defined', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000012', 'B00012', 'Y descriptor to be added or defined', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000013', 'B00013', 'Element name line 1', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('000014', 'B00014', 'Element name line 2', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('000015', 'B00015', 'Units name', 'CCITT IA5', '0', '0', '192', 'Character', '0', '24', '', '', ''),
	('000016', 'B00016', 'Units scale sign', 'CCITT IA5', '0', '0', '8', 'Character', '0', '1', '', '', ''),
	('000017', 'B00017', 'Units scale', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000018', 'B00018', 'Units reference sign', 'CCITT IA5', '0', '0', '8', 'Character', '0', '1', '', '', ''),
	('000019', 'B00019', 'Units reference value', 'CCITT IA5', '0', '0', '80', 'Character', '0', '10', '', '', ''),
	('000020', 'B00020', 'Element data width', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000030', 'B00030', 'Descriptor defining sequence', 'CCITT IA5', '0', '0', '48', 'Character', '0', '6', '', '', ''),
	('001001', 'B01001', 'WMO block number', 'Numeric', '0', '0', '7', 'Numeric', '0', '2', '', '', ''),
	('001002', 'B01002', 'WMO station number', 'Numeric', '0', '0', '10', 'Numeric', '0', '3', '', '', ''),
	('001003', 'B01003', 'WMO Region number/geographical area', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('001004', 'B01004', 'WMO Region sub-area (see Note 9)', 'Numeric', '0', '0', '3', 'Numeric', '0', '1', '', '', ''),
	('001005', 'B01005', 'Buoy/platform identifier', 'Numeric', '0', '0', '17', 'Numeric', '0', '5', '', '', ''),
	('001006', 'B01006', 'Aircraft flight number', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001007', 'B01007', 'Satellite identifier', 'Code table', '0', '0', '10', 'Code table', '0', '4', '', '', ''),
	('001008', 'B01008', 'Aircraft registration number or other identification', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001009', 'B01009', 'Type of commercial aircraft', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001010', 'B01010', 'Stationary buoy platform identifier; e.g. C-MAN buoys', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001011', 'B01011', 'Ship or mobile land station identifier', 'CCITT IA5', '0', '0', '72', 'Character', '0', '9', '', '', ''),
	('001012', 'B01012', 'Direction of motion of moving observing platform*', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('001013', 'B01013', 'Speed of motion of moving observing platform??*', 'm s-1', '0', '0', '10', 'm s-1', '0', '3', '', '', ''),
	('001014', 'B01014', 'Platform drift speed (high precision)', 'm s-1', '2', '0', '10', 'm s-1', '2', '4', '', '', ''),
	('001015', 'B01015', 'Station or site name', 'CCITT IA5', '0', '0', '160', 'Character', '0', '20', '', '', ''),
	('001018', 'B01018', 'Short station or site name', 'CCITT IA5', '0', '0', '40', 'Character', '0', '5', '', '', ''),
	('001019', 'B01019', 'Long Station or site name', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('001020', 'B01020', 'WMO Region sub-area', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('001021', 'B01021', 'Synoptic feature identifier', 'Numeric', '0', '0', '14', 'Numeric', '0', '4', '', '', ''),
	('001022', 'B01022', 'Name of feature (see Note 11)', 'CCITT IA5', '0', '0', '224', 'Character', '0', '28', '', '', ''),
	('001023', 'B01023', 'Observation sequence number ', 'Numeric', '0', '0', '9', 'Numeric', '0', '3', '', '', ''),
	('001025', 'B01025', 'Storm identifier (see Note 1)', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('001026', 'B01026', 'WMO storm name*', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001027', 'B01027', 'WMO long storm name*', 'CCITT IA5', '0', '0', '80', 'Character', '0', '10', '', '', ''),
	('001030', 'B01030', 'Numerical model identifier (see Note 13)', 'CCITT IA5', '0', '0', '128', 'Character', '0', '16', '', '', ''),
	('001031', 'B01031', 'Identification of originating/generating centre (see Note 10)', 'Code table', '0', '0', '16', 'Code table', '0', '5', '', '', ''),
	('001032', 'B01032', 'Generating application', 'Code table defined by originating/generating centre (Notes 3 4 and 5)', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001033', 'B01033', 'Identification of originating/generating centre', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001034', 'B01034', 'Identification of originating/generating sub-centre', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001035', 'B01035', 'Originating Centre', 'Common Code Table C-11', '0', '0', '16', 'Common Code Table C-11', '0', '5', '', '', ''),
	('001036', 'B01036', 'Agency in charge of operating the Observing platform', 'Code table', '0', '0', '20', 'Code table', '0', '7', '', '', ''),
	('001037', 'B01037', 'SIGMET sequence identifier', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('001041', 'B01041', 'Absolute platform velocity – first component (see Note 6)', 'm s-1', '5', '-1073741824', '31', 'm s-1', '5', '10', '', '', ''),
	('001042', 'B01042', 'Absolute platform velocity – second component  (see Note 6)', 'm s-1', '5', '-1073741824', '31', 'm s-1', '5', '10', '', '', ''),
	('001043', 'B01043', 'Absolute platform velocity – third component  (see Note 6)', 'm s-1', '5', '-1073741824', '31', 'm s-1', '5', '10', '', '', ''),
	('001050', 'B01050', 'Platform transmitter ID number', 'Numeric', '0', '0', '17', 'Numeric', '0', '6', '', '', ''),
	('001051', 'B01051', 'Platform transmitter ID number', 'CCITT IA5', '0', '0', '96', 'Character', '0', '12', '', '', ''),
	('001060', 'B01060', 'Aircraft reporting point (Beacon identifier)', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001062', 'B01062', 'Short ICAO location indicator', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('001063', 'B01063', 'ICAO location indicator', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001064', 'B01064', 'Runway designator', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('001065', 'B01065', 'ICAO region identifier', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('001075', 'B01075', 'Tide station identification', 'CCITT IA5', '0', '0', '40', 'Character', '0', '5', '', '', ''),
	('001080', 'B01080', 'Ship line number according to SOOP', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('001081', 'B01081', 'Radiosonde serial number ', 'CCITT IA5', '0', '0', '160', 'Character', '0', '20', '', '', ''),
	('001082', 'B01082', 'Radiosonde ascension number (see Note 12)', 'Numeric', '0', '0', '14', 'Numeric', '0', '4', '', '', ''),
	('001083', 'B01083', 'Radiosonde release number (see Note 12)', 'Numeric', '0', '0', '3', 'Numeric', '0', '1', '', '', ''),
	('001085', 'B01085', 'Observing platform manufacturer\'s model', 'CCITT IA5', '0', '0', '160', 'Character', '0', '20', '', '', ''),
	('001086', 'B01086', 'Observing platform manufacturer\'s serial number', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('001087', 'B01087', 'WMO Marine observing platform extended identifier', 'Numeric', '0', '0', '23', 'Numeric', '0', '7', '', '', ''),
	('001090', 'B01090', 'Technique for making up initial perturbations', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001091', 'B01091', 'Ensemble member number ', 'Numeric', '0', '0', '10', 'Numeric', '0', '4', '', '', ''),
	('001092', 'B01092', 'Type of ensemble forecast', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001093', 'B01093', 'Balloon lot number', 'CCITT IA5', '0', '0', '96', 'Character', '0', '12', '', '', ''),
	('001094', 'B01094', 'WBAN Number', 'Numeric', '0', '0', '17', 'Numeric', '0', '5', '', '', ''),
	('001095', 'B01095', 'Observer identification', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('001096', 'B01096', 'Station acquisition ', 'CCITT IA5', '0', '0', '160', 'Character', '0', '20', '', '', ''),
	('002001', 'B02001', 'Type of station', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002002', 'B02002', 'Type of instrumentation for wind measurement', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('002003', 'B02003', 'Type of measuring equipment used', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002004', 'B02004', 'Type of instrumentation for evaporation measurement or type of crop for which evapotranspiration is reported', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002005', 'B02005', 'Precision of temperature observation', 'K', '2', '0', '7', 'K', '2', '3', '', '', ''),
	('002011', 'B02011', 'Radiosonde type', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('002012', 'B02012', 'Radiosonde computational method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002013', 'B02013', 'Solar and infrared radiation correction', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002014', 'B02014', 'Tracking technique/status of system used', 'Code table', '0', '0', '7', 'Code table', '0', '3', '', '', ''),
	('002015', 'B02015', 'Radiosonde completeness', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002016', 'B02016', 'Radiosonde configuration', 'Flag table', '0', '0', '5', 'Flag table', '0', '2', '', '', ''),
	('002019', 'B02019', 'Satellite instruments', 'Code table', '0', '0', '11', 'Code table', '0', '4', '', '', ''),
	('002020', 'B02020', 'Satellite classification', 'Code table', '0', '0', '9', 'Code table', '0', '3', '', '', ''),
	('002021', 'B02021', 'Satellite instrument data used in processing*', 'Flag table', '0', '0', '9', 'Flag table', '0', '3', '', '', ''),
	('002022', 'B02022', 'Satellite data-processing technique used', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('002023', 'B02023', 'Satellite derived wind computation method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002024', 'B02024', 'Integrated mean humidity computational method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002025', 'B02025', 'Satellite channel(s) used in computation', 'Flag table', '0', '0', '25', 'Flag table', '0', '9', '', '', ''),
	('002026', 'B02026', 'Cross track resolution', 'm', '2', '0', '12', 'm', '2', '4', '', '', ''),
	('002027', 'B02027', 'Along track resolution', 'm', '2', '0', '12', 'm', '2', '4', '', '', ''),
	('002028', 'B02028', 'Segment size at nadir in X direction', 'm', '0', '0', '18', 'm', '0', '6', '', '', ''),
	('002029', 'B02029', 'Segment size at nadir in Y direction', 'm', '0', '0', '18', 'm', '0', '6', '', '', ''),
	('002030', 'B02030', 'Method of current measurement', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002031', 'B02031', 'Duration and time of current measurement', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002032', 'B02032', 'Indicator for digitization', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002033', 'B02033', 'Method of salinity/depth measurement', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002034', 'B02034', 'Drogue type', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002035', 'B02035', 'Cable length', 'm', '0', '0', '9', 'm', '0', '3', '', '', ''),
	('002036', 'B02036', 'Buoy type', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002037', 'B02037', 'Method of tidal observation', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002038', 'B02038', 'Method of water temperature and/or salinity measurement', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002039', 'B02039', 'Method of wet-bulb temperature measurement', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002040', 'B02040', 'Method of removing velocity and motion of platform from current', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002041', 'B02041', 'Method for estimating reports related to synoptic features', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002042', 'B02042', 'Indicator for sea surface current speed', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002044', 'B02044', 'Indicator for method of calculating spectral wave data', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002045', 'B02045', 'Indicator for type of platform', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002046', 'B02046', 'Wave measurement instrumentation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002048', 'B02048', 'Satellite sensor indicator', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002049', 'B02049', 'Geostationary satellite data-processing technique used', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('002050', 'B02050', 'Geostationary sounder satellite channels used', 'Flag table', '0', '0', '20', 'Flag table', '0', '7', '', '', ''),
	('002051', 'B02051', 'Indicator to specify observing method for extreme temperatures', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002052', 'B02052', 'Geostationary imager satellite channels used', 'Flag table', '0', '0', '6', 'Flag table', '0', '2', '', '', ''),
	('002053', 'B02053', 'GOES-I/M brightness temperature characteristics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002054', 'B02054', 'GOES-I/M soundings parameter characteristics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002055', 'B02055', 'Geostationary soundings statistical parameters', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002056', 'B02056', 'Geostationary soundings accuracy statistics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002057', 'B02057', 'Origin of first guess information for GOES-I/M soundings', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002058', 'B02058', 'Valid times of first guess information for GOES-I/M soundings', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002059', 'B02059', 'Origin of analysis information for GOES-I/M soundings', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002060', 'B02060', 'Origin of surface information for GOES-I/M soundings', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002061', 'B02061', 'Aircraft navigational system', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002062', 'B02062', 'Type of aircraft data relay system', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002063', 'B02063', 'Aircraft roll angle', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('002064', 'B02064', 'Aircraft roll angle quality', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002065', 'B02065', 'ACARS ground receiving station', 'CCITT IA5', '0', '0', '40', 'Character', '0', '5', '', '', ''),
	('002066', 'B02066', 'Radiosonde ground receiving system', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002067', 'B02067', 'Radiosonde operating frequency', 'Hz', '-5', '0', '15', 'Hz', '-5', '5', '', '', ''),
	('002070', 'B02070', 'Original specification of latitude/longitude', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002080', 'B02080', 'Balloon manufacturer', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002081', 'B02081', 'Type of balloon', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002082', 'B02082', 'Weight of balloon', 'kg', '3', '0', '12', 'kg', '3', '4', '', '', ''),
	('002083', 'B02083', 'Type of balloon shelter', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002084', 'B02084', 'Type of gas used in balloon', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002085', 'B02085', 'Amount of gas used in balloon', 'kg', '3', '0', '13', 'kg', '3', '4', '', '', ''),
	('002086', 'B02086', 'Balloon flight train length', 'm', '1', '0', '10', 'm', '1', '4', '', '', ''),
	('002091', 'B02091', 'Entry sensor 4/20 mA', 'A', '4', '0', '10', 'A', '4', '3', '', '', ''),
	('002095', 'B02095', 'Type of pressure sensor', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002096', 'B02096', 'Type of temperature sensor', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002097', 'B02097', 'Type of humidity sensor', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002100', 'B02100', 'Radar constant*', 'dB', '1', '0', '12', 'dB', '1', '4', '', '', ''),
	('002101', 'B02101', 'Type of antenna', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002102', 'B02102', 'Antenna height above tower base', 'm', '0', '0', '8', 'm', '0', '3', '', '', ''),
	('002103', 'B02103', 'Radome', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('002104', 'B02104', 'Antenna polarisation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002105', 'B02105', 'Maximum antenna gain', 'dB', '0', '0', '6', 'dB', '0', '2', '', '', ''),
	('002106', 'B02106', '3-dB beamwidth', 'Degree', '1', '0', '6', 'Degree', '1', '2', '', '', ''),
	('002107', 'B02107', 'Sidelobe suppression', 'dB', '0', '0', '6', 'dB', '0', '2', '', '', ''),
	('002108', 'B02108', 'Crosspol discrimination (on axis)', 'dB', '0', '0', '6', 'dB', '0', '2', '', '', ''),
	('002109', 'B02109', 'Antenna speed (azimuth)', 'Degree s-1', '2', '0', '12', 'Degree s-1', '2', '4', '', '', ''),
	('002110', 'B02110', 'Antenna speed (elevation)', 'Degree s-1', '2', '0', '12', 'Degree s-1', '2', '4', '', '', ''),
	('002111', 'B02111', 'Radar incidence angle', 'Degree', '1', '0', '10', 'Degree', '1', '4', '', '', ''),
	('002112', 'B02112', 'Radar look angle', 'Degree', '1', '0', '12', 'Degree', '1', '4', '', '', ''),
	('002113', 'B02113', 'Number of azimuth looks', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('002114', 'B02114', 'Antenna effective surface area', 'm2', '0', '0', '15', 'm2', '0', '5', '', '', ''),
	('002115', 'B02115', 'Type of surface observing equipment', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002116', 'B02116', 'Percentage of 320 MHz band processed', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002117', 'B02117', 'Percentage of 80 MHz band processed', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002118', 'B02118', 'Percentage of 20 MHz band processed', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002119', 'B02119', 'RA-2 instrument operations', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002120', 'B02120', 'Ocean wave frequency', 'Hz', '3', '0', '10', 'Hz', '3', '4', '', '', ''),
	('002121', 'B02121', 'Mean frequency', 'Hz', '-8', '0', '7', 'Hz', '-8', '3', '', '', ''),
	('002122', 'B02122', 'Frequency agility range', 'Hz', '-6', '-128', '8', 'Hz', '-6', '3', '', '', ''),
	('002123', 'B02123', 'Peak power', 'W', '-4', '0', '7', 'W', '-4', '3', '', '', ''),
	('002124', 'B02124', 'Average power', 'W', '-1', '0', '7', 'W', '-1', '3', '', '', ''),
	('002125', 'B02125', 'Pulse repetition frequency', 'Hz', '-1', '0', '8', 'Hz', '-1', '3', '', '', ''),
	('002126', 'B02126', 'Pulse width', 's', '7', '0', '6', 's', '7', '2', '', '', ''),
	('002127', 'B02127', 'Receiver intermediate frequency', 'Hz', '-6', '0', '7', 'Hz', '-6', '3', '', '', ''),
	('002128', 'B02128', 'Intermediate frequency bandwidth', 'Hz', '-5', '0', '6', 'Hz', '-5', '2', '', '', ''),
	('002129', 'B02129', 'Minimum detectable signal', 'dB', '0', '-150', '5', 'dB', '0', '3', '', '', ''),
	('002130', 'B02130', 'Dynamic range', 'dB', '0', '0', '7', 'dB', '0', '3', '', '', ''),
	('002131', 'B02131', 'Sensitivity time control (STC)', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('002132', 'B02132', 'Azimuth pointing accuracy', 'Degree', '2', '0', '6', 'Degree', '2', '2', '', '', ''),
	('002133', 'B02133', 'Elevation pointing accuracy', 'Degree', '2', '0', '6', 'Degree', '2', '2', '', '', ''),
	('002134', 'B02134', 'Antenna beam azimuth', 'Degree', '2', '0', '16', 'Degree', '2', '5', '', '', ''),
	('002135', 'B02135', 'Antenna elevation', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('002136', 'B02136', 'Range processed by range attenuation correction', 'm', '-3', '0', '16', 'm', '-3', '5', '', '', ''),
	('002140', 'B02140', 'Satellite radar beam azimuth angle', 'Degree', '0', '0', '9', 'Degree', '0', '3', '', '', ''),
	('002141', 'B02141', 'Measurement type', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('002142', 'B02142', 'Ozone instrument serial number/ identification', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('002143', 'B02143', 'Ozone instrument type', 'Code table', '0', '0', '7', 'Code table', '0', '3', '', '', ''),
	('002144', 'B02144', 'Light source type for Brewer spectro photometer', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002145', 'B02145', 'Wave length setting for Dobson instruments', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002146', 'B02146', 'Source conditions for Dobson instruments', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002148', 'B02148', 'Data collection and/or location system', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002149', 'B02149', 'Type of data buoy', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002150', 'B02150', 'TOVS/ATOVS/AVHRR instrumentation channel number', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002151', 'B02151', 'Radiometer identifier', 'Code table', '0', '0', '11', 'Code table', '0', '4', '', '', ''),
	('002152', 'B02152', 'Satellite instrument used in data processing (see Note 6)', 'Flag table', '0', '0', '31', 'Flag table', '0', '10', '', '', ''),
	('002153', 'B02153', 'Satellite channel centre frequency', 'Hz', '-8', '0', '26', 'Hz', '-8', '8', '', '', ''),
	('002154', 'B02154', 'Satellite channel band width', 'Hz', '-8', '0', '26', 'Hz', '-8', '8', '', '', ''),
	('002156', 'B02156', 'Percentage of valid KU ocean retracker measurements', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002157', 'B02157', 'Percentage of valid S ocean retracker measurements', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002158', 'B02158', 'RA-2 instrument', 'Flag table', '0', '0', '9', 'Flag table', '0', '3', '', '', ''),
	('002159', 'B02159', 'MWR instrument', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('002160', 'B02160', 'Wave length of the radar', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002163', 'B02163', 'Height assignment method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002164', 'B02164', 'Tracer correlation method', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002166', 'B02166', 'Radiance type', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002167', 'B02167', 'Radiance computational method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002168', 'B02168', 'Hydrostatic pressure of lower end of cable (thermistor string)', 'Pa', '-3', '0', '16', 'kPa', '-3', '5', '', '', ''),
	('002169', 'B02169', 'Anemometer type', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002172', 'B02172', 'Product type for retrieved atmospheric gases', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('002173', 'B02173', 'Square of the off nadir angle (see Note 7)', 'Degree2', '4', '0', '10', 'Degree2', '4', '4', '', '', ''),
	('002174', 'B02174', 'Mean across track pixel number ', 'Numeric', '0', '0', '9', 'Numeric', '0', '3', '', '', ''),
	('002175', 'B02175', 'Method of precipitation measurement ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002176', 'B02176', 'Method of state of ground measurement ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002177', 'B02177', 'Method of snow depth measurement ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002178', 'B02178', 'Method of liquid content measurement of precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002179', 'B02179', 'Type of sky condition algorithm ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002180', 'B02180', 'Main present weather detecting system ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002181', 'B02181', 'Supplementary present weather sensor', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('002182', 'B02182', 'Visibility measurement system ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002183', 'B02183', 'Cloud detection system', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002184', 'B02184', 'Type of lightning detection sensor', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002185', 'B02185', 'Method of evaporation measurement', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002186', 'B02186', 'Capability to detect precipitation phenomena', 'Flag table', '0', '0', '30', 'Flag table', '0', '10', '', '', ''),
	('002187', 'B02187', 'Capability to detect other weather phenomena', 'Flag table', '0', '0', '18', 'Flag table', '0', '6', '', '', ''),
	('002188', 'B02188', 'Capability to detect obscuration', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('002189', 'B02189', 'Capability to discriminate lightning strikes', 'Flag table', '0', '0', '12', 'Flag table', '0', '4', '', '', ''),
	('002190', 'B02190', 'Lagrangian drifter submergence (% time submerged)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('004001', 'B04001', 'Year', 'Year', '0', '0', '12', 'Year', '0', '4', '', '', ''),
	('004002', 'B04002', 'Month', 'Month', '0', '0', '4', 'Month', '0', '2', '', '', ''),
	('004003', 'B04003', 'Day', 'Day', '0', '0', '6', 'Day', '0', '2', '', '', ''),
	('004004', 'B04004', 'Hour', 'Hour', '0', '0', '5', 'Hour', '0', '2', '', '', ''),
	('004005', 'B04005', 'Minute', 'Minute', '0', '0', '6', 'Minute', '0', '2', '', '', ''),
	('004006', 'B04006', 'Second', 'Second', '0', '0', '6', 'Second', '0', '2', '', '', ''),
	('004007', 'B04007', 'Seconds within a minute (microsecond accuracy)', 'Second', '6', '0', '26', 'Second', '6', '8', '', '', ''),
	('004011', 'B04011', 'Time increment', 'Year', '0', '-1024', '11', 'Year', '0', '4', '', '', ''),
	('004012', 'B04012', 'Time increment', 'Month', '0', '-1024', '11', 'Month', '0', '4', '', '', ''),
	('004013', 'B04013', 'Time increment', 'Day', '0', '-1024', '11', 'Day', '0', '4', '', '', ''),
	('004014', 'B04014', 'Time increment', 'Hour', '0', '-1024', '11', 'Hour', '0', '4', '', '', ''),
	('004015', 'B04015', 'Time increment', 'Minute', '0', '-2048', '12', 'Minute', '0', '4', '', '', ''),
	('004016', 'B04016', 'Time increment', 'Second', '0', '-4096', '13', 'Second', '0', '4', '', '', ''),
	('004017', 'B04017', 'Reference time period for accumulated or extreme data', 'Minute', '0', '-1440', '12', 'Minute', '0', '4', '', '', ''),
	('004021', 'B04021', 'Time period or displacement', 'Year', '0', '-1024', '11', 'Year', '0', '4', '', '', ''),
	('004022', 'B04022', 'Time period or displacement', 'Month', '0', '-1024', '11', 'Month', '0', '4', '', '', ''),
	('004023', 'B04023', 'Time period or displacement', 'Day', '0', '-1024', '11', 'Day', '0', '4', '', '', ''),
	('004024', 'B04024', 'Time period or displacement', 'Hour', '0', '-2048', '12', 'Hour', '0', '4', '', '', ''),
	('004025', 'B04025', 'Time period or displacement', 'Minute', '0', '-2048', '12', 'Minute', '0', '4', '', '', ''),
	('004026', 'B04026', 'Time period or displacement', 'Second', '0', '-4096', '13', 'Second', '0', '4', '', '', ''),
	('004031', 'B04031', 'Duration of time relating to following value', 'Hour', '0', '0', '8', 'Hour', '0', '3', '', '', ''),
	('004032', 'B04032', 'Duration of time relating to following value', 'Minute', '0', '0', '6', 'Minute', '0', '2', '', '', ''),
	('004041', 'B04041', 'Time difference UTC –LMT (see Note 6)', 'Minute', '0', '-1440', '12', 'Minute', '0', '4', '', '', ''),
	('004043', 'B04043', 'Day of the year', 'Day', '0', '0', '9', 'Day', '0', '3', '', '', ''),
	('004051', 'B04051', 'Principal time of daily reading of maximum temperature', 'Hour', '0', '0', '5', 'Hour ', '0', '2', '', '', ''),
	('004052', 'B04052', 'Principal time of daily reading of minimum temperature', 'Hour', '0', '0', '5', 'Hour ', '0', '2', '', '', ''),
	('004053', 'B04053', 'Number of days with precipitation equal to or more than 1 mm', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('004059', 'B04059', 'Times of observation used to compute the reported mean values', 'Flag table', '0', '0', '6', 'Flag table', '0', '2', '', '', ''),
	('004065', 'B04065', 'Short time increment', 'Minute', '0', '-128', '8', 'Minute', '0', '2', '', '', ''),
	('004073', 'B04073', 'Short time period or displacement', 'Day', '0', '-128', '8', 'Day', '0', '2', '', '', ''),
	('004074', 'B04074', 'Short time period or displacement', 'Hour', '0', '-128', '8', 'Hour', '0', '2', '', '', ''),
	('004075', 'B04075', 'Short time period or displacement', 'Minute', '0', '-128', '8', 'Minute', '0', '2', '', '', ''),
	('004080', 'B04080', 'Averaging period for following value', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('004086', 'B04086', 'Long time period or displacement', 'Second', '0', '-8192', '15', 'Second', '0', '5', '', '', ''),
	('005001', 'B05001', 'Latitude (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('005002', 'B05002', 'Latitude (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('005011', 'B05011', 'Latitude increment (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('005012', 'B05012', 'Latitude increment (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('005015', 'B05015', 'Latitude displacement (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('005016', 'B05016', 'Latitude displacement (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('005021', 'B05021', 'Bearing or azimuth', 'Degree true', '2', '0', '16', 'Degree true', '2', '5', '', '', ''),
	('005022', 'B05022', 'Solar azimuth', 'Degree true', '2', '0', '16', 'Degree true', '2', '5', '', '', ''),
	('005023', 'B05023', 'Sun to satellite azimuth difference', 'Degree', '1', '-1800', '12', 'Degree', '1', '4', '', '', ''),
	('005030', 'B05030', 'Direction (spectral)', 'Degree', '0', '0', '12', 'Degree', '0', '4', '', '', ''),
	('005031', 'B05031', 'Row number', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('005033', 'B05033', 'Pixel size on horizontal – 1', 'm', '-1', '0', '16', 'm', '-1', '5', '', '', ''),
	('005034', 'B05034', 'Along track row number', 'Numeric', '0', '0', '11', 'Numeric', '0', '4', '', '', ''),
	('005036', 'B05036', 'Ship transect number according to SOOP', 'Numeric', '0', '0', '7', 'Numeric', '0', '2', '', '', ''),
	('005040', 'B05040', 'Orbit number', 'Numeric', '0', '0', '24', 'Numeric', '0', '8', '', '', ''),
	('005041', 'B05041', 'Scan line number', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('005042', 'B05042', 'Channel number', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('005043', 'B05043', 'Field of view number', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('005044', 'B05044', 'Satellite cycle number', 'Numeric', '0', '0', '11', 'Numeric', '0', '4', '', '', ''),
	('005052', 'B05052', 'Channel number increment', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('005053', 'B05053', 'Field of view number increment', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('005060', 'B05060', 'Y angular position from centre of gravity', 'Degree', '6', '-8000000', '24', 'Degree', '6', '8', '', '', ''),
	('005061', 'B05061', 'Z angular position from centre of gravity', 'Degree', '6', '-8000000', '24', 'Degree', '6', '8', '', '', ''),
	('006001', 'B06001', 'Longitude (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('006002', 'B06002', 'Longitude (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('006011', 'B06011', 'Longitude increment (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('006012', 'B06012', 'Longitude increment (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('006015', 'B06015', 'Longitude displacement (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('006016', 'B06016', 'Longitude displacement (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('006021', 'B06021', 'Distance', 'm', '-1', '0', '13', 'm', '-1', '4', '', '', ''),
	('006030', 'B06030', 'Wave number (spectral)', 'rad m-1', '5', '0', '13', 'rad m-1', '5', '4', '', '', ''),
	('006031', 'B06031', 'Column number', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('006033', 'B06033', 'Pixel size on horizontal – 2', 'm', '-1', '0', '16', 'm', '-1', '5', '', '', ''),
	('006034', 'B06034', 'Cross-track cell number', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('006040', 'B06040', 'Radius of confidence', 'm', '0', '0', '13', 'm', '0', '4', '', '', ''),
	('007001', 'B07001', 'Height of station (see Note 1)', 'm', '0', '-400', '15', 'm', '0', '5', '', '', ''),
	('007002', 'B07002', 'Height or altitude', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('007003', 'B07003', 'Geopotential', 'm2 s-2', '-1', '-400', '17', 'm2 s-2', '-1', '6', '', '', ''),
	('007004', 'B07004', 'Pressure', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('007005', 'B07005', 'Height increment', 'm', '0', '-400', '12', 'm', '0', '4', '', '', ''),
	('007006', 'B07006', 'Height above station', 'm', '0', '0', '15', 'm', '0', '5', '', '', ''),
	('007007', 'B07007', 'Height', 'm', '0', '-1000', '17', 'm', '0', '6', '', '', ''),
	('007008', 'B07008', 'Geopotential', 'm2 s-2', '0', '-10000', '20', 'm2 s-2', '0', '7', '', '', ''),
	('007009', 'B07009', 'Geopotential height', 'gpm', '0', '-1000', '17', 'gpm', '0', '5', '', '', ''),
	('007010', 'B07010', 'Flight level', 'm', '0', '-1024', '16', 'ft', '0', '5', '', '', ''),
	('007021', 'B07021', 'Elevation (see Note 2)', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('007022', 'B07022', 'Solar elevation', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('007024', 'B07024', 'Satellite zenith angle', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('007025', 'B07025', 'Solar zenith angle', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('007026', 'B07026', 'Satellite zenith angle', 'Degree', '4', '-900000', '21', 'Degree', '4', '7', '', '', ''),
	('007030', 'B07030', 'Height of station ground above mean sea level (see Note 3)', 'm', '1', '-4000', '17', 'm', '1', '5', '', '', ''),
	('007031', 'B07031', 'Height of barometer above mean sea level (see Note 4)', 'm', '1', '-4000', '17', 'm', '1', '5', '', '', ''),
	('007032', 'B07032', 'Height of sensor above local ground (or deck of marine platform) (see Note 5)', 'm', '2', '0', '16', 'm', '2', '5', '', '', ''),
	('007033', 'B07033', 'Height of sensor above water surface (see Note 6)', 'm', '1', '0', '12', 'm', '1', '4', '', '', ''),
	('007040', 'B07040', 'Impact parameter (see Note 8)', 'm', '1', '62000000', '22', 'm', '1', '8', '', '', ''),
	('007061', 'B07061', 'Depth below land surface', 'm', '2', '0', '14', 'm', '2', '5', '', '', ''),
	('007062', 'B07062', 'Depth below sea/water surface', 'm', '1', '0', '17', 'm', '1', '6', '', '', ''),
	('007063', 'B07063', 'Depth below sea/water surface (cm)', 'm', '2', '0', '20', 'm', '2', '7', '', '', ''),
	('007064', 'B07064', 'Representative height of sensor above station (see Note 7)', 'm', '0', '0', '4', 'm', '0', '2', '', '', ''),
	('007065', 'B07065', 'Water pressure', 'Pa', '-3', '0', '17', 'Pa', '-3', '6', '', '', ''),
	('007070', 'B07070', 'Drogue depth', 'm', '0', '0', '10', 'm', '0', '4', '', '', ''),
	('008001', 'B08001', 'Vertical sounding significance', 'Flag table', '0', '0', '7', 'Flag table', '0', '3', '', '', ''),
	('008002', 'B08002', 'Vertical significance (surface observations)', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008003', 'B08003', 'Vertical significance (satellite observations)', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008004', 'B08004', 'Phase of aircraft flight', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('008005', 'B08005', 'Meteorological attribute significance', 'Code table', '0', '0', '4', 'Code table ', '0', '2', '', '', ''),
	('008006', 'B08006', 'Ozone vertical sounding significance', 'Flag table', '0', '0', '9', 'Flag table ', '0', '3', '', '', ''),
	('008007', 'B08007', 'Dimensional significance', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008008', 'B08008', 'Radiation vertical sounding significance', 'Flag table', '0', '0', '9', 'Flag table ', '0', '3', '', '', ''),
	('008009', 'B08009', 'Detailed phase of flight', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008010', 'B08010', 'Surface qualifier (temperature data)', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('008011', 'B08011', 'Meteorological feature', 'Code table', '0', '0', '6', 'Code table ', '0', '2', '', '', ''),
	('008012', 'B08012', 'Land/sea qualifier', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('008013', 'B08013', 'Day/night qualifier', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008014', 'B08014', 'Qualifier for runway visual range', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008016', 'B08016', 'Change qualifier of a trend-type forecast or an aerodrome forecast', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008017', 'B08017', 'Qualifier of the time when the forecast change is expected', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008018', 'B08018', 'SEAWINDS land/ice surface type', 'Flag table', '0', '0', '17', 'Flag table', '0', '6', '', '', ''),
	('008019', 'B08019', 'Qualifier for following Centre identifier', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008020', 'B08020', 'Total number of missing entities (with respect to accumulation or average)', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('008021', 'B08021', 'Time significance', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('008022', 'B08022', 'Total number (with respect to accumulation or average)', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('008023', 'B08023', 'First order statistics', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008024', 'B08024', 'Difference statistics', 'Code table', '0', '0', '6', 'Code table ', '0', '2', '', '', ''),
	('008025', 'B08025', 'Time difference qualifier (see Note 5)', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008029', 'B08029', 'Remotely sensed surface type', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('008030', 'B08030', 'Manual on Codes (Volume I.1 Section C) Code table from which data are derived', 'Numeric', '0', '0', '13', 'Numeric', '0', '4', '', '', ''),
	('008031', 'B08031', 'Data category CREX table A', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('008033', 'B08033', 'Method of derivation of percentage confidence', 'Code table', '0', '0', '7', 'Code table', '0', '3', '', '', ''),
	('008035', 'B08035', 'Type of monitoring exercise', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008036', 'B08036', 'Type of centre or station performing monitoring', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008040', 'B08040', 'Flight Level significance', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008041', 'B08041', 'Data significance', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('008042', 'B08042', 'Extended vertical sounding significance', 'Flag table', '0', '0', '18', 'Flag table', '0', '6', '', '', ''),
	('008049', 'B08049', 'Number of observations', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('008050', 'B08050', 'Qualifier for number of missing values in calculation of statistic', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008051', 'B08051', 'Qualifier for number of missing values in calculation of statistic', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('008052', 'B08052', 'Condition for which number of days of occurrence follows', 'Code table', '0', '0', '5', 'Code table ', '0', '2', '', '', ''),
	('008053', 'B08053', 'Day of occurrence qualifier', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008060', 'B08060', 'Sample scanning mode significance', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008065', 'B08065', 'Sun-glint indicator', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008066', 'B08066', 'Semi-transparency indicator', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008070', 'B08070', 'TOVS/ATOVS product qualifier', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008072', 'B08072', 'Pixel(s) type', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008074', 'B08074', 'Altimeter echo type', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008075', 'B08075', 'Ascending/Descending Orbit Qualifier', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008076', 'B08076', 'Type of band', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008079', 'B08079', 'Product status ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008080', 'B08080', 'Qualifier for GTSPP quality flag', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008081', 'B08081', 'Type of equipment', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008082', 'B08082', 'Modification of sensor height to another value', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008083', 'B08083', 'Nominal value indicator', 'Flag table', '0', '0', '15', 'Flag table', '0', '5', '', '', ''),
	('008085', 'B08085', 'Beam identifier', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('010001', 'B10001', 'Height of land surface', 'm', '0', '-400', '15', 'm', '0', '5', '', '', ''),
	('010002', 'B10002', 'Height', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('010003', 'B10003', 'Geopotential', 'm2 s-2', '-1', '-400', '17', 'm2 s-2', '-1', '6', '', '', ''),
	('010004', 'B10004', 'Pressure', 'Pa', '-1', '0', '14', 'Pa', ' -1', '5', '', '', ''),
	('010007', 'B10007', 'Height', 'm', '0', '-1000', '17', 'm', '0', '6', '', '', ''),
	('010008', 'B10008', 'Geopotential', 'm2 s-2', '0', '-10000', '20', 'm2 s-2', '0', '7', '', '', ''),
	('010009', 'B10009', 'Geopotential height', 'gpm', '0', '-1000', '17', 'gpm', '0', '5', '', '', ''),
	('010010', 'B10010', 'Minimum pressure reduced to mean sea level', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('010011', 'B10011', 'Maximum pressure reduced to mean sea level', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('010031', 'B10031', 'In direction of the North Pole distance from the Earth’s centre (see Note 2)', 'm', '2', '-1073741824', '31', 'm', '2', '10', '', '', ''),
	('010032', 'B10032', 'Satellite distance to Earth’s centre', 'm', '1', '0', '27', 'm', '1', '9', '', '', ''),
	('010033', 'B10033', 'Altitude (platform to Ellipsoid)', 'm', '1', '0', '27', 'm', '1', '9', '', '', ''),
	('010034', 'B10034', 'Earth radius', 'm', '1', '0', '27', 'm', '1', '9', '', '', ''),
	('010035', 'B10035', 'Earth’s local radius of curvature ', 'm', '1', '62000000', '22', 'm', '1', '8', '', '', ''),
	('010036', 'B10036', 'Geoid undulation (see Note 4)', 'm', '2', '-15000', '15', 'm', '2', '6', '', '', ''),
	('010040', 'B10040', 'Number of retrieved layers', 'Numeric', '0', '0', '10', 'Numeric', '0', '4', '', '', ''),
	('010050', 'B10050', 'Standard deviation altitude', 'm', '2', '0', '16', 'm', '2', '5', '', '', ''),
	('010051', 'B10051', 'Pressure reduced to mean sea level', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('010052', 'B10052', 'Altimeter setting (QNH)', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('010060', 'B10060', 'Pressure change', 'Pa', '-1', '-1024', '11', 'Pa', '-1', '4', '', '', ''),
	('010061', 'B10061', '3-hour pressure change', 'Pa', '-1', '-500', '10', 'Pa', '-1', '4', '', '', ''),
	('010062', 'B10062', '24-hour pressure change', 'Pa', '-1', '-1000', '11', 'Pa', '-1', '4', '', '', ''),
	('010063', 'B10063', 'Characteristic of pressure tendency', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('010064', 'B10064', 'SIGMET cruising level ', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('010070', 'B10070', 'Indicated aircraft altitude', 'm', '0', '-400', '16', 'm', '0', '5', '', '', ''),
	('010080', 'B10080', 'Viewing Zenith angle', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('010081', 'B10081', 'Altitude of COG above reference Ellipsoid', 'm', '3', '0', '31', 'm', '3', '10', '', '', ''),
	('010082', 'B10082', 'Instantaneous altitude rate', 'm s-1', '3', '-65536', '17', 'm s-1', '3', '6', '', '', ''),
	('010083', 'B10083', 'Squared off Nadir angle of the satellite from platform data', 'Degree2', '2', '0', '16', 'Degree2', '2', '5', '', '', ''),
	('010084', 'B10084', 'Squared off Nadir angle of the satellite from waveform data', 'Degree2', '2', '0', '16', 'Degree2', '2', '5', '', '', ''),
	('010085', 'B10085', 'Mean sea surface height', 'm', '3', '-131072', '18', 'm', '3', '6', '', '', ''),
	('010086', 'B10086', 'Geoid’s height', 'm', '3', '-131072', '18', 'm', '3', '6', '', '', ''),
	('010087', 'B10087', 'Ocean depth/land elevation', 'm', '1', '-131072', '18', 'm', '1', '6', '', '', ''),
	('010088', 'B10088', 'Total geocentric ocean tide height (solution 1)', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010089', 'B10089', 'Total geocentric ocean tide height (solution 2)', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010090', 'B10090', 'Long period  tide height ', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010091', 'B10091', 'Tidal loading height', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010092', 'B10092', 'Solid Earth tide height', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010093', 'B10093', 'Geocentric pole tide height ', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010095', 'B10095', 'Height of atmosphere used', 'm', '0', '0', '16', 'm', '0', '5', '', '', ''),
	('011001', 'B11001', 'Wind direction', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011002', 'B11002', 'Wind speed', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011003', 'B11003', 'u-component', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('011004', 'B11004', 'v-component', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('011005', 'B11005', 'w-component', 'Pa s-1', '1', '-512', '10', 'Pa s-1', '1', '4', '', '', ''),
	('011006', 'B11006', 'w-component', 'm s-1', '2', '-4096', '13', 'm s-1', '2', '4', '', '', ''),
	('011010', 'B11010', 'Wind direction associated with wind speed which follows', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011011', 'B11011', 'Wind direction at 10 m', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011012', 'B11012', 'Wind speed at 10 m', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011013', 'B11013', 'Wind direction at 5 m', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011014', 'B11014', 'Wind speed at 5 m', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011016', 'B11016', 'Extreme counterclockwise wind direction of a variable wind', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011017', 'B11017', 'Extreme clockwise wind direction of a variable wind', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011019', 'B11019', 'Steadiness of wind (see Note 6)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('011021', 'B11021', 'Relative vorticity', 's-1', '9', '-65536', '17', 's-1', '9', '6', '', '', ''),
	('011022', 'B11022', 'Divergence', 's-1', '9', '-65536', '17', 's-1', '9', '6', '', '', ''),
	('011023', 'B11023', 'Velocity potential', 'm2 s-1', '-2', '-65536', '17', 'm2 s-1', '-2', '6', '', '', ''),
	('011030', 'B11030', 'Extended degree of turbulence', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('011031', 'B11031', 'Degree of turbulence', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('011032', 'B11032', 'Height of base of turbulence', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('011033', 'B11033', 'Height of top of turbulence', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('011034', 'B11034', 'Vertical gust velocity', 'm s-1', '1', '-1024', '11', 'm s-1', '1', '4', '', '', ''),
	('011035', 'B11035', 'Vertical gust acceleration', 'm s-2', '2', '-8192', '14', 'm s-2', '2', '5', '', '', ''),
	('011036', 'B11036', 'Maximum derived equivalent vertical gust speed', 'm s-1', '1', '0', '10', 'm s-1', '1', '4', '', '', ''),
	('011037', 'B11037', 'Turbulence Index', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('011038', 'B11038', 'Time of occurrence of Peak Eddy Dissipation Rate', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('011039', 'B11039', 'Extended time of occurrence of peak  Eddy Dissipation Rate', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('011040', 'B11040', 'Maximum wind speed (mean wind)', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011041', 'B11041', 'Maximum wind gust speed', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011042', 'B11042', 'Maximum wind speed (10-min mean wind)', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011043', 'B11043', 'Maximum wind gust direction', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011044', 'B11044', 'Mean wind direction for surface – 1500 m (5000 feet)', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011045', 'B11045', 'Mean wind speed for surface – 1500 m (5000 feet)', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011046', 'B11046', 'Maximum instantaneous wind speed', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011047', 'B11047', 'Maximum instantaneous wind speed over 10 minutes', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011049', 'B11049', 'Standard deviation of wind direction', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011050', 'B11050', 'Standard deviation of horizontal wind speed', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011051', 'B11051', 'Standard deviation of vertical wind speed', 'm s-1', '1', '0', '8', 'm s-1', '1', '3', '', '', ''),
	('011052', 'B11052', 'Formal uncertainty in wind speed', 'm s-1', '2', '0', '13', 'm s-1', '2', '5', '', '', ''),
	('011053', 'B11053', 'Formal uncertainty in wind direction', 'Degree true', '2', '0', '15', 'Degree true', '2', '5', '', '', ''),
	('011054', 'B11054', 'Mean wind direction for 1500 m – 3000 m ', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011055', 'B11055', 'Mean wind speed for 1500 m  – 3000 m ', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011061', 'B11061', 'Absolute wind shear in 1 km layer below', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011062', 'B11062', 'Absolute wind shear in 1 km layer above', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011070', 'B11070', 'Designator of the runway affected by wind shear (including ALL)', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('011071', 'B11071', 'Turbulent vertical momentum flux', 'm2 s-2', '3', '-128', '14', 'm2 s-2', '3', '5', '', '', ''),
	('011072', 'B11072', 'Turbulent vertical buoyancy flux', 'K m s-1', '3', '-128', '11', 'K m s-1', '3', '4', '', '', ''),
	('011073', 'B11073', 'Turbulent kinetic energy', 'm2 s-2', '2', '-1024', '13', 'm2 s-2', '2', '4', '', '', ''),
	('011074', 'B11074', 'Dissipation energy', 'm2 s-2', '2', '-1024', '10', 'm2 s-2', '2', '4', '', '', ''),
	('011075', 'B11075', 'Mean turbulence intensity (eddy dissipation rate)', 'm2/3 s-1', '2', '0', '8', 'm2/3 s-1', '2', '3', '', '', ''),
	('011076', 'B11076', 'Peak turbulence intensity (eddy dissipation rate)', 'm2/3 s-1', '2', '0', '8', 'm2/3 s-1', '2', '3', '', '', ''),
	('011077', 'B11077', 'Reporting interval or averaging time for Eddy Dissipation Rate', 's', '0', '0', '12', 's', '0', '4', '', '', ''),
	('011081', 'B11081', 'Model wind direction at 10m', 'Degree true', '2', '0', '16', 'Degree true', '2', '5', '', '', ''),
	('011082', 'B11082', 'Model wind speed at 10m', 'm s-1', '2', '0', '14', 'm s-1', '2', '4', '', '', ''),
	('011095', 'B11095', 'U component of the model wind vector', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('011096', 'B11096', 'V component of the model wind vector', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('012001', 'B12001', 'Temperature/dry-bulb temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012002', 'B12002', 'Wet-bulb temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012003', 'B12003', 'Dew-point temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012004', 'B12004', 'Dry-bulb temperature at 2 m', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012005', 'B12005', 'Wet-bulb temperature at 2 m', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012006', 'B12006', 'Dew-point temperature at 2 m', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012007', 'B12007', 'Virtual temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012011', 'B12011', 'Maximum temperature at height and over period specified', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012012', 'B12012', 'Minimum temperature at height and over period specified', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012013', 'B12013', 'Ground minimum temperature past 12 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012014', 'B12014', 'Maximum temperature at 2 m past 12 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012015', 'B12015', 'Minimum temperature at 2 m past 12 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012016', 'B12016', 'Maximum temperature at 2 m past 24 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012017', 'B12017', 'Minimum temperature at 2 m past 24 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012021', 'B12021', 'Maximum temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012022', 'B12022', 'Minimum temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012030', 'B12030', 'Soil temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012049', 'B12049', 'Temperature change over specified period ', 'K', '0', '-30', '6', '°C', '0', '2', '', '', ''),
	('012051', 'B12051', 'Standard deviation temperature', 'K', '1', '0', '10', '°C', '1', '3', '', '', ''),
	('012052', 'B12052', 'Highest daily mean temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012053', 'B12053', 'Lowest daily mean temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012061', 'B12061', 'Skin temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012062', 'B12062', 'Equivalent black body temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012063', 'B12063', 'Brightness temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012064', 'B12064', 'Instrument temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('012065', 'B12065', 'Standard deviation brightness temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('012070', 'B12070', 'Warm load temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012071', 'B12071', 'Coldest cluster temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('012072', 'B12072', 'Radiance', 'W m-2 sr-1', '6', '0', '31', 'W m-2 sr-1', '6', '9', '', '', ''),
	('012075', 'B12075', 'Spectral radiance', 'W m-3 sr-1', '-3', '0', '16', 'W m-3 sr-1', '-3', '5', '', '', ''),
	('012076', 'B12076', 'Radiance (see Note 2)', 'W m-2 sr-1', '3', '0', '16', 'W m-2 sr-1', '3', '5', '', '', ''),
	('012101', 'B12101', 'Temperature/dry-bulb temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012102', 'B12102', 'Wet-bulb temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012103', 'B12103', 'Dew-point temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012104', 'B12104', 'Dry-bulb temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012105', 'B12105', 'Web-bulb temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012106', 'B12106', 'Dew-point temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012107', 'B12107', 'Virtual temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012111', 'B12111', 'Maximum temperature at height and over period specified', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012112', 'B12112', 'Minimum temperature at height and over period specified', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012113', 'B12113', 'Ground minimum temperature past 12 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012114', 'B12114', 'Maximum temperature at 2m past 12 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012115', 'B12115', 'Minimum temperature at 2m past 12 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012116', 'B12116', 'Maximum temperature at 2m past 24 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012117', 'B12117', 'Minimum temperature at 2m past 24 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012118', 'B12118', 'Maximum temperature at height specified past 24 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012119', 'B12119', 'Minimum  temperature at height specified past 24 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012121', 'B12121', 'Ground minimum temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012122', 'B12122', 'Ground minimum temperature of the preceding night', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012130', 'B12130', 'Soil temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012151', 'B12151', 'Standard deviation of daily mean temperature', 'K', '2', '0', '12', '°C', '2', '4', '', '', ''),
	('012152', 'B12152', 'Highest daily mean temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012153', 'B12153', 'Lowest daily mean temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012161', 'B12161', 'Skin temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012162', 'B12162', 'Equivalent black body temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012163', 'B12163', 'Brightness temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012164', 'B12164', 'Instrument temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012171', 'B12171', 'Coldest cluster temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012180', 'B12180', 'Averaged 12 micron BT for all clear pixels at Nadir', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012181', 'B12181', 'Averaged 11 micron BT for all clear pixels at Nadir', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012182', 'B12182', 'Averaged 3.7 micron BT for all clear pixels at Nadir', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012183', 'B12183', 'Averaged 12 micron BT for all clear pixels forward view', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012184', 'B12184', 'Averaged 11 micron BT for all clear pixels forward view', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012185', 'B12185', 'Averaged 3.7 micron BT for all clear pixels forward view', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012186', 'B12186', 'Mean Nadir sea surface temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012187', 'B12187', 'Mean dual view sea surface temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012188', 'B12188', 'Interpolated 23.8 GHz brightness T from MWR', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012189', 'B12189', 'Interpolated 36.5 GHz brightness T from MWR', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('013001', 'B13001', 'Specific humidity', 'kg kg-1', '5', '0', '14', 'kg kg-1', '5', '5', '', '', ''),
	('013002', 'B13002', 'Mixing ratio', 'kg kg-1', '5', '0', '14', 'kg kg-1', '5', '5', '', '', ''),
	('013003', 'B13003', 'Relative humidity', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('013004', 'B13004', 'Vapour pressure', 'Pa', '-1', '0', '10', 'Pa', '-1', '4', '', '', ''),
	('013005', 'B13005', 'Vapour density', 'kg m-3', '3', '0', '7', 'kg m-3', '3', '3', '', '', ''),
	('013006', 'B13006', 'Mixing heights', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('013007', 'B13007', 'Minimum relative humidity', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('013008', 'B13008', 'Maximum relative humidity', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('013009', 'B13009', 'Relative humidity (see Note 6)', '%', '1', '-1000', '12', '%', '1', '4', '', '', ''),
	('013011', 'B13011', 'Total precipitation/total water equivalent', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013012', 'B13012', 'Depth of fresh snow', 'm', '2', '-2', '12', 'm', '2', '4', '', '', ''),
	('013013', 'B13013', 'Total snow depth', 'm', '2', '-2', '16', 'm', '2', '5', '', '', ''),
	('013014', 'B13014', 'Rainfall/water equivalent of snow (averaged rate)', 'kg m-2 s-1', '4', '0', '12', 'kg m-2 s-1', '4', '4', '', '', ''),
	('013015', 'B13015', 'Snowfall  (averaged rate)', 'm s-1', '7', '0', '12', 'm s-1', '7', '4', '', '', ''),
	('013016', 'B13016', 'Precipitable water', 'kg m-2', '0', '0', '7', 'kg m-2', '0', '3', '', '', ''),
	('013019', 'B13019', 'Total precipitation past 1 hour', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '4', '', '', ''),
	('013020', 'B13020', 'Total precipitation past 3 hours', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013021', 'B13021', 'Total precipitation past 6 hours', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013022', 'B13022', 'Total precipitation past 12 hours', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013023', 'B13023', 'Total precipitation past 24 hours', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013031', 'B13031', 'Evapotranspiration', 'kg m-2', '0', '0', '7', 'kg m-2', '0', '3', '', '', ''),
	('013032', 'B13032', 'Evaporation/evapotranspiration (see Note 5)', 'kg m-2', '1', '0', '8', 'kg m-2', '1', '3', '', '', ''),
	('013033', 'B13033', 'Evaporation/evapotranspiration', 'kg m-2', '1', '0', '10', 'kg m-2', '1', '4', '', '', ''),
	('013038', 'B13038', 'Superadiabatic indicator', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('013039', 'B13039', 'Terrain type (ice/snow)', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('013040', 'B13040', 'Surface flag', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013041', 'B13041', 'Pasquill-Gifford stability category', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013042', 'B13042', 'Parcel lifted index (to 500 hPa) (see Notes 3 and 4)', 'K', '0', '-20', '6', 'K', '0', '2', '', '', ''),
	('013043', 'B13043', 'Best lifted index (to 500 hPa) (see Note 3 and 4)', 'K', '0', '-20', '6', 'K', '0', '2', '', '', ''),
	('013044', 'B13044', 'K index', 'K', '0', '-30', '8', 'K', '0', '3', '', '', ''),
	('013045', 'B13045', 'KO index', 'K', '0', '-30', '8', 'K', '0', '3', '', '', ''),
	('013046', 'B13046', 'Maximum buoyancy', 'K', '0', '-30', '8', 'K', '0', '3', '', '', ''),
	('013047', 'B13047', 'Modified Showalter stability index (see Note 7)', 'K', '0', '-60', '6', '°C', '0', '2', '', '', ''),
	('013051', 'B13051', 'Frequency group precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013052', 'B13052', 'Highest daily amount of precipitation', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013055', 'B13055', 'Intensity of precipitation', 'kg m-2 s-1', '4', '0', '8', 'mm h-1 ', '4', '4', '', '', ''),
	('013056', 'B13056', 'Character and intensity of precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013057', 'B13057', 'Time of beginning or end of precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013058', 'B13058', 'Size of precipitating element', 'm', '4', '0', '7', 'mm', '4', '3', '', '', ''),
	('013059', 'B13059', 'Number of flashes (thunderstorm)', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('013060', 'B13060', 'Total accumulated precipitation', 'kg m-2', '1', '-1', '17', 'kg m-2', '1', '5', '', '', ''),
	('013071', 'B13071', 'Upstream water level', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('013072', 'B13072', 'Downstream water level', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('013073', 'B13073', 'Maximum water level', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('013080', 'B13080', 'Water pH', 'pH unit', '1', '0', '10', 'pH unit', '1', '3', '', '', ''),
	('013081', 'B13081', 'Water conductivity', 'Siemens m-1', '3', '0', '14', 'Siemens m-1', '3', '4', '', '', ''),
	('013082', 'B13082', 'Water temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('013083', 'B13083', 'Dissolved oxygen', 'kg m-3', '6', '0', '15', 'kg m-3', '6', '5', '', '', ''),
	('013084', 'B13084', 'Turbidity', 'Lumen', '0', '0', '14', 'Lumen', '0', '4', '', '', ''),
	('013085', 'B13085', 'Oxydation Reduction Potential (ORP)', 'V', '3', '0', '14', 'V', '3', '4', '', '', ''),
	('013090', 'B13090', 'Radiometer water vapour content', 'kg m-2', '1', '0', '10', 'kg m-2', '1', '4', '', '', ''),
	('013091', 'B13091', 'Radiometer liquid content', 'kg m-2', '2', '0', '8', 'kg m-2', '2', '3', '', '', ''),
	('013093', 'B13093', 'Cloud optical thickness', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('013095', 'B13095', 'Total column water vapour', 'kg m-2', '4', '0', '19', 'kg m-2', '4', '6', '', '', ''),
	('013096', 'B13096', 'MWR water vapour content', 'kg m-2', '2', '0', '14', 'kg m-2', '2', '5', '', '', ''),
	('013097', 'B13097', 'MWR liquid water content', 'kg m-2', '2', '0', '14', 'kg m-2', '2', '5', '', '', ''),
	('013098', 'B13098', 'Integrated water vapour density', 'kg m-2', '8', '0', '30', 'kg m-2', '8', '10', '', '', ''),
	('014001', 'B14001', 'Long-wave radiation integrated over 24 hours', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014002', 'B14002', 'Long-wave radiation integrated over period specified', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014003', 'B14003', 'Short-wave radiation integrated over 24 hours', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014004', 'B14004', 'Short-wave radiation integrated over period specified', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014011', 'B14011', 'Net long-wave radiation integrated over 24 hours', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014012', 'B14012', 'Net long-wave radiation integrated over period specified', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014013', 'B14013', 'Net short-wave radiation integrated over 24 hours', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014014', 'B14014', 'Net short-wave radiation integrated over period specified', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014015', 'B14015', 'Net radiation integrated over 24 hours', 'J m-2', '-4', '-16384', '15', 'J m-2', '-4', '5', '', '', ''),
	('014016', 'B14016', 'Net radiation integrated over period specified', 'J m-2', '-4', '-16384', '15', 'J m-2', '-4', '5', '', '', ''),
	('014017', 'B14017', 'Instantaneous long-wave radiation ', 'W m-2', '-3', '-2048', '12', 'W m-2', '-3', '4', '', '', ''),
	('014018', 'B14018', 'Instantaneous short-wave radiation', 'W m-2', '-3', '-2048', '12', 'W m-2', '-3', '4', '', '', ''),
	('014019', 'B14019', 'Surface albedo', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('014020', 'B14020', 'Global solar radiation integrated over 24 hours', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014021', 'B14021', 'Global solar radiation integrated over period specified', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014022', 'B14022', 'Diffuse solar radiation integrated over 24 hours', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014023', 'B14023', 'Diffuse solar radiation integrated over period specified', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014024', 'B14024', 'Direct solar radiation integrated over 24 hours', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014025', 'B14025', 'Direct solar radiation integrated over period specified', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014026', 'B14026', 'Albedo at the top of clouds', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('014027', 'B14027', 'Albedo', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('014028', 'B14028', 'Global solar radiation (high accuracy) integrated over period specified', 'J m-2', '-2', '0', '16', 'J m-2', '-2', '5', '', '', ''),
	('014029', 'B14029', 'Diffuse solar radiation (high accuracy) integrated over period specified', 'J m-2', '-2', '0', '16', 'J m-2', '-2', '5', '', '', ''),
	('014030', 'B14030', 'Direct solar radiation (high accuracy) integrated over period specified', 'J m-2', '-2', '0', '16', 'J m-2', '-2', '5', '', '', ''),
	('014031', 'B14031', 'Total sunshine', 'Minute', '0', '0', '11', 'Minute', '0', '4', '', '', ''),
	('014032', 'B14032', 'Total sunshine', 'Hour', '0', '0', '10', 'Hour', '0', '4', '', '', ''),
	('014033', 'B14033', 'Total sunshine', '%', '0', '0', '9', '%', '0', '3', '', '', ''),
	('014034', 'B14034', 'Sunshine over period specified', 'Minute', '0', '0', '11', 'Minute', '0', '4', '', '', ''),
	('014042', 'B14042', 'Bi-directional reflectance', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('014045', 'B14045', 'Channel radiance (see Note 4)', 'W m-2 sr-1 cm-1', '0', '0', '11', 'W m-2 sr-1 cm-1', '0', '4', '', '', ''),
	('014046', 'B14046', 'Scaled IASI radiance (see Note 6)', 'W m-2 sr-1 m-1', '0', '-5000', '16', 'W m-2 sr-1 m-1', '0', '5', '', '', ''),
	('014047', 'B14047', 'Scaled mean AVHRR radiance', 'W m-2 sr-1 m-1', '0', '0', '31', 'W m-2 sr-1 m-1', '0', '10', '', '', ''),
	('014048', 'B14048', 'Scaled standard deviation AVHRR radiance', 'W m-2 sr-1 m-1', '0', '0', '31', 'W m-2 sr-1 m-1', '0', '10', '', '', ''),
	('014050', 'B14050', 'Emissivity (see Note 5)', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('014051', 'B14051', 'Direct solar radiation integrated over last hour', 'J m-2', '-3', '0', '14', 'J m-2', '-3', '4', '', '', ''),
	('014055', 'B14055', 'Solar activity index', 'Numeric', '0', '-32768', '16', 'Numeric', '0', '5', '', '', ''),
	('015001', 'B15001', 'Total ozone', 'DU', '0', '0', '10', 'DU', '0', '4', '', '', ''),
	('015002', 'B15002', 'Air mass (slant path at 22 km)', 'Numeric', '2', '0', '10', 'Numeric', '2', '3', '', '', ''),
	('015003', 'B15003', 'Measured ozone partial pressure (sounding) (see Note 1)', 'Pascal', '4', '0', '9', 'nbar', '4', '3', '', '', ''),
	('015004', 'B15004', 'Ozone sounding correction factor (see Note 2)', 'Numeric', '3', '0', '11', 'Numeric', '3', '4', '', '', ''),
	('015005', 'B15005', 'Ozone p (see Note 3)', 'DU', '0', '0', '10', 'DU', '0', '3', '', '', ''),
	('015011', 'B15011', 'Log 10 of integrated electron density', 'log (1/m2)', '3', '14000', '13', 'log (m-2)', '3', '4', '', '', ''),
	('015015', 'B15015', 'Maximum image spectral component before normalization', 'Numeric', '0', '0', '31', 'Numeric', '0', '10', '', '', ''),
	('015020', 'B15020', 'Integrated ozone density', 'kg m-2', '8', '0', '21', 'kg m-2', '8', '7', '', '', ''),
	('015025', 'B15025', 'Type of pollutant', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('015026', 'B15026', 'Concentration of pollutant (mol mol-1)', 'mol mol-1', '9', '0', '9', 'mol mol-1', '9', '3', '', '', ''),
	('015027', 'B15027', 'Concentration of pollutant (kg m-3)', 'kg m-3', '9', '0', '10', 'kg m-3', '9', '4', '', '', ''),
	('015031', 'B15031', 'Atmospheric path delay in satellite signal', 'm', '4', '10000', '15', 'm', '4', '5', '', '', ''),
	('015032', 'B15032', 'Estimated error in atmospheric path delay', 'm', '4', '0', '10', 'm', '4', '4', '', '', ''),
	('015033', 'B15033', 'Difference in path delays for limb views at extremes of scan', 'm', '5', '-10000', '15', 'm', '5', '5', '', '', ''),
	('015034', 'B15034', 'Estimated error in path delay difference', 'm', '5', '0', '14', 'm', '5', '5', '', '', ''),
	('015035', 'B15035', 'Component of zenith path delay due to water vapour', 'm', '4', '0', '14', 'm', '4', '5', '', '', ''),
	('015036', 'B15036', 'Atmospheric refractivity (see Note 5)', 'N-units', '3', '0', '19', 'N-units', '3', '6', '', '', ''),
	('015037', 'B15037', 'Bending angle', 'Radians', '8', '-100000', '23', 'Radians', '8', '7', '', '', ''),
	('019001', 'B19001', 'Type of synoptic feature', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('019002', 'B19002', 'Effective radius of feature', 'm', '-2', '0', '12', 'm', '-2', '4', '', '', ''),
	('019003', 'B19003', 'Wind speed threshold', 'm s-1', '0', '0', '8', 'm s-1', '0', '3', '', '', ''),
	('019004', 'B19004', 'Effective radius with respect to wind speeds above threshold', 'm', '-2', '0', '12', 'm', '-2', '4', '', '', ''),
	('019005', 'B19005', 'Direction of motion of feature', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('019006', 'B19006', 'Speed of motion of feature', 'm s-1', '2', '0', '14', 'm s-1', '2', '5', '', '', ''),
	('019007', 'B19007', 'Effective radius of feature', 'm', '-3', '0', '12', 'm', '-3', '4', '', '', ''),
	('019008', 'B19008', 'Vertical extent of circulation', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019009', 'B19009', 'Effective radius with respect to wind speeds above threshold (large storms)', 'm', '-3', '0', '12', 'm', '-3', '4', '', '', ''),
	('019010', 'B19010', 'Method for tracking the centre of synoptic feature', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019100', 'B19100', 'Time interval to calculate the movement of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019101', 'B19101', 'Accuracy of the position of the centre of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019102', 'B19102', 'Shape and definition of the eye of the tropical cyclone', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019103', 'B19103', 'Diameter of major axis of the eye of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019104', 'B19104', 'Change in character of the eye during the 30 minutes ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019105', 'B19105', 'Distance between the end of spiral band and the centre ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019106', 'B19106', 'Identification number of tropical cyclone', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('019107', 'B19107', 'Time interval over which the movement of the tropical cyclone has been calculated', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019108', 'B19108', 'Accuracy of geographical position of the tropical cyclone', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019109', 'B19109', 'Mean diameter of the overcast cloud of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019110', 'B19110', 'Apparent 24-hour change in intensity of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019111', 'B19111', 'Current Intensity (CI) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019112', 'B19112', 'Data Tropical (DT) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019113', 'B19113', 'Cloud pattern type of the DT-number', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019114', 'B19114', 'Model Expected Tropical (MET) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019115', 'B19115', 'Trend of the past 24-hour change (+: Developed -: Weakened)', 'Numeric', '1', '-30', '6', 'Numeric', '1', '2', '', '', ''),
	('019116', 'B19116', 'Pattern Tropical (PT) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019117', 'B19117', 'Cloud picture type of the PT-number', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019118', 'B19118', 'Final Tropical (T) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019119', 'B19119', 'Type of the final T-number', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019150', 'B19150', 'Typhoon International Common Number (Typhoon Committee)', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('020001', 'B20001', 'Horizontal visibility', 'm', '-1', '0', '13', 'm', '-1', '4', '', '', ''),
	('020002', 'B20002', 'Vertical visibility', 'm', '-1', '0', '7', 'm', '-1', '3', '', '', ''),
	('020003', 'B20003', 'Present weather (see Note 1)', 'Code table', '0', '0', '9', 'Code table', '0', '3', '', '', ''),
	('020004', 'B20004', 'Past weather (1) (see Note 2)', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020005', 'B20005', 'Past weather (2) (see Note 2)', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020008', 'B20008', 'Cloud distribution for aviation', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020009', 'B20009', 'General Weather Indicator (TAF/METAR)', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020010', 'B20010', 'Cloud cover (total) (see Note 5)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020011', 'B20011', 'Cloud amount', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020012', 'B20012', 'Cloud type', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('020013', 'B20013', 'Height of base of cloud', 'm', '-1', '-40', '11', 'm', '-1', '4', '', '', ''),
	('020014', 'B20014', 'Height of top of cloud', 'm', '-1', '-40', '11', 'm', '-1', '4', '', '', ''),
	('020015', 'B20015', 'Pressure at base of cloud', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('020016', 'B20016', 'Pressure at top of cloud', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('020017', 'B20017', 'Cloud top description', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020018', 'B20018', 'Tendency of runway visual range', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('020019', 'B20019', 'Significant present or forecast weather', 'CCITT IA5', '0', '0', '72', 'Character', '0', '9', '', '', ''),
	('020020', 'B20020', 'Significant recent weather phenomena', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('020021', 'B20021', 'Type of precipitation', 'Flag table', '0', '0', '30', 'Flag table', '0', '10', '', '', ''),
	('020022', 'B20022', 'Character of precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020023', 'B20023', 'Other weather phenomena', 'Flag table', '0', '0', '18', 'Flag table', '0', '6', '', '', ''),
	('020024', 'B20024', 'Intensity of phenomena', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('020025', 'B20025', 'Obscuration', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('020026', 'B20026', 'Character of obscuration', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020027', 'B20027', 'Phenomena occurrence', 'Flag table', '0', '0', '9', 'Flag table', '0', '3', '', '', ''),
	('020028', 'B20028', 'Expected change in intensity', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('020029', 'B20029', 'Rain flag', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('020031', 'B20031', 'Ice deposit (thickness)', 'm', '2', '0', '7', 'm', '2', '3', '', '', ''),
	('020032', 'B20032', 'Rate of ice accretion', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('020033', 'B20033', 'Cause of ice accretion', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('020034', 'B20034', 'Sea ice concentration', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020035', 'B20035', 'Amount and type of ice', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020036', 'B20036', 'Ice situation', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020037', 'B20037', 'Ice development', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020038', 'B20038', 'Bearing of ice edge (see Note 3)', 'Degree true', '0', '0', '12', 'Degree true', '0', '3', '', '', ''),
	('020040', 'B20040', 'Evolution of drift snow', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020041', 'B20041', 'Airframe icing', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020042', 'B20042', 'Airframe icing present', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('020043', 'B20043', 'Peak liquid water content', 'kg m-3', '4', '0', '7', 'kg m-3', '4', '2', '', '', ''),
	('020044', 'B20044', 'Average liquid water content', 'kg m-3', '4', '0', '7', 'kg m-3', '4', '2', '', '', ''),
	('020045', 'B20045', 'Supercooled large droplet (SLD) conditions', 'Code table', '0', '0', '2', 'Code table', '0', '2', '', '', ''),
	('020048', 'B20048', 'Evolution of feature', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020050', 'B20050', 'Cloud index', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('020051', 'B20051', 'Amount of low clouds', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020052', 'B20052', 'Amount of middle clouds', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020053', 'B20053', 'Amount of high clouds', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020054', 'B20054', 'True direction from which a phenomenon or clouds are moving', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('020055', 'B20055', 'State of sky in the tropics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020056', 'B20056', 'Cloud phase', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('020061', 'B20061', 'Runway visual range (RVR)', 'm', '0', '0', '12', 'm', '0', '4', '', '', ''),
	('020062', 'B20062', 'State of the ground (with or without snow)', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020063', 'B20063', 'Special phenomena', 'Code table', '0', '0', '10', 'Code table', '0', '4', '', '', ''),
	('020065', 'B20065', 'Snow cover (see Note 4)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020066', 'B20066', 'Maximum diameter of hailstones', 'm', '3', '0', '8', 'm', '3', '3', '', '', ''),
	('020067', 'B20067', 'Diameter of deposit', 'm', '3', '0', '9', 'm', '3', '3', '', '', ''),
	('020070', 'B20070', 'Minimum number of atmospherics', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('020071', 'B20071', 'Accuracy of fix and rate of atmospherics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020081', 'B20081', 'Cloud amount in segment', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020082', 'B20082', 'Amount segment cloud free', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020083', 'B20083', 'Amount of segment covered by scene', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020090', 'B20090', 'Special clouds', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020095', 'B20095', 'Ice probability', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('020096', 'B20096', 'Ice age ("A" parameter)', 'dB', '2', '-4096', '13', 'dB', '2', '4', '', '', ''),
	('020101', 'B20101', 'Locust (acridian) name', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020102', 'B20102', 'Locust (maturity) color', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020103', 'B20103', 'Stage of development of locusts', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020104', 'B20104', 'Organization state of swarm or band of locusts', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020105', 'B20105', 'Size of swarm or band of locusts and duration of passage of swarm', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020106', 'B20106', 'Locust population density', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020107', 'B20107', 'Direction of movements of locust swarm', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020108', 'B20108', 'Extent of vegetation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('021001', 'B21001', 'Horizontal reflectivity', 'dB', '0', '-64', '7', 'dB', '0', '3', '', '', ''),
	('021002', 'B21002', 'Vertical reflectivity', 'dB', '0', '-64', '7', 'dB', '0', '3', '', '', ''),
	('021003', 'B21003', 'Differential reflectivity', 'dB', '1', '-5', '7', 'dB', '1', '3', '', '', ''),
	('021005', 'B21005', 'Linear depolarisation ratio ', 'dB', '0', '-65', '6', 'dB', '0', '2', '', '', ''),
	('021006', 'B21006', 'Circular depolarisation ratio ', 'dB', '0', '-65', '6', 'dB', '0', '2', '', '', ''),
	('021011', 'B21011', 'Doppler mean velocity in X-direction', 'm s-1', '0', '-128', '8', 'm s-1', '0', '3', '', '', ''),
	('021012', 'B21012', 'Doppler mean velocity in Y-direction', 'm s-1', '0', '-128', '8', 'm s-1', '0', '3', '', '', ''),
	('021013', 'B21013', 'Doppler mean velocity in Z-direction', 'm s-1', '0', '-128', '8', 'm s-1', '0', '3', '', '', ''),
	('021014', 'B21014', 'Doppler mean velocity (radial)', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('021017', 'B21017', 'Doppler velocity spectral width', 'm s-1', '1', '0', '8', 'm s-1', '1', '3', '', '', ''),
	('021021', 'B21021', 'Echo tops ', 'm', '-3', '0', '4', 'm', '-3', '2', '', '', ''),
	('021030', 'B21030', 'Signal to noise ratio', 'dB', '0', '-32', '8', 'dB', '0', '3', '', '', ''),
	('021031', 'B21031', 'Vertically integrated liquid-water content', 'kg m-2', '0', '0', '7', 'kg m-2', '0', '3', '', '', ''),
	('021036', 'B21036', 'Radar rainfall intensity ', 'm s-1', '7', '0', '12', 'm s-1', '7', '4', '', '', ''),
	('021041', 'B21041', 'Bright-band height ', 'm', '-2', '0', '8', 'm', '-2', '3', '', '', ''),
	('021051', 'B21051', 'Signal power above 1 mW', 'dB', '0', '-256', '8', 'dB', '0', '3', '', '', ''),
	('021062', 'B21062', 'Backscatter', 'dB', '2', '-5000', '13', 'dB', '2', '4', '', '', ''),
	('021063', 'B21063', 'Radiometric resolution (noise value)', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('021064', 'B21064', 'Clutter noise estimate', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('021065', 'B21065', 'Missing packet counter', 'Numeric', '0', '-127', '8', 'Numeric', '0', '3', '', '', ''),
	('021066', 'B21066', 'Wave scatterometer product confidence data', 'Flag table', '0', '0', '12', 'Flag table', '0', '4', '', '', ''),
	('021067', 'B21067', 'Wind product confidence data', 'Flag table', '0', '0', '13', 'Flag table', '0', '5', '', '', ''),
	('021068', 'B21068', 'Radar altimeter product confidence data', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('021069', 'B21069', 'SST product confidence data', 'Flag table', '0', '0', '10', 'Flag table', '0', '4', '', '', ''),
	('021070', 'B21070', 'SST product confidence data (SADIST-2)', 'Flag table', '0', '0', '23', 'Flag table', '0', '6', '', '', ''),
	('021071', 'B21071', 'Peakiness', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('021072', 'B21072', 'Satellite altimeter calibration status', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('021073', 'B21073', 'Satelllite altimeter instrument mode', 'Flag table', '0', '0', '9', 'Flag table', '0', '3', '', '', ''),
	('021075', 'B21075', 'Image spectrum intensity', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('021076', 'B21076', 'Representation of intensities', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('021077', 'B21077', 'Altitude correction (ionosphere)', 'm', '3', '0', '14', 'm', '3', '5', '', '', ''),
	('021078', 'B21078', 'Altitude correction (dry troposphere)', 'm', '3', '0', '9', 'm', '3', '3', '', '', ''),
	('021079', 'B21079', 'Altitude correction (wet troposphere)', 'm', '3', '2000', '10', 'm', '3', '4', '', '', ''),
	('021080', 'B21080', 'Altitude correction (calibration constant)', 'm', '3', '0', '11', 'm', '3', '4', '', '', ''),
	('021081', 'B21081', 'Open loop correction (height-time loop)', 'm', '3', '0', '10', 'm', '3', '4', '', '', ''),
	('021082', 'B21082', 'Open loop correction (auto gain control)', 'dB', '3', '-3000', '14', 'dB', '3', '5', '', '', ''),
	('021083', 'B21083', 'Warm target calibration', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('021084', 'B21084', 'Cold target calibration', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('021085', 'B21085', 'ATSR sea surface temperature across- track band number', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('021086', 'B21086', 'Number of pixels in Nadir only average', 'Numeric', '0', '0', '9', 'Numeric', '0', '3', '', '', ''),
	('021087', 'B21087', 'Number of pixels in dual view average', 'Numeric', '0', '0', '9', 'Numeric', '0', '3', '', '', ''),
	('021088', 'B21088', 'Wet backscatter', 'dB', '2', '-5000', '13', 'dB', '2', '4', '', '', ''),
	('021091', 'B21091', 'Radar signal Doppler spectrum 0th moment', 'dB', '0', '-100', '8', 'dB', '0', '3', '', '', ''),
	('021092', 'B21092', 'RASS signal Doppler spectrum 0th moment referring to RASS signal', 'dB', '0', '-100', '8', 'dB', '0', '3', '', '', ''),
	('021093', 'B21093', 'Ku band peakiness', 'Numeric', '3', '0', '16', 'Numeric', '3', '5', '', '', ''),
	('021094', 'B21094', 'S band peakiness', 'Numeric', '3', '0', '16', 'Numeric', '3', '5', '', '', ''),
	('021101', 'B21101', 'Number of vector ambiguities', 'Numeric', '0', '0', '3', 'Numeric', '0', '1', '', '', ''),
	('021102', 'B21102', 'Index of selected wind vector', 'Numeric', '0', '0', '3', 'Numeric', '0', '1', '', '', ''),
	('021103', 'B21103', 'Total number of sigma-0 measurements', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('021104', 'B21104', 'Likelihood computed for solution', 'Numeric', '3', '-30000', '15', 'Numeric', '3', '5', '', '', ''),
	('021105', 'B21105', 'Normalized radar cross-section', 'dB', '2', '-10000', '14', 'dB', '2', '5', '', '', ''),
	('021106', 'B21106', 'Kp variance coefficient (Alpha)', 'Numeric', '3', '0', '14', 'Numeric', '3', '5', '', '', ''),
	('021107', 'B21107', 'Kp variance coefficient (Beta)', 'Numeric', '8', '0', '16', 'Numeric', '8', '5', '', '', ''),
	('021109', 'B21109', 'SEAWINDS wind vector cell quality', 'Flag table', '0', '0', '17', 'Flag table', '0', '6', '', '', ''),
	('021110', 'B21110', 'Number of inner-beam Sigma-0 (forward of satellite)', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('021111', 'B21111', 'Number of outer-beam Sigma-0 (forward of satellite)', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('021112', 'B21112', 'Number of inner-beam Sigma-0 (aft of satellite)', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('021113', 'B21113', 'Number of outer-beam Sigma-0 (aft of satellite)', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('021114', 'B21114', 'Kp variance coefficent (Gamma)', 'dB', '3', '-140000', '18', 'dB', '3', '6', '', '', ''),
	('021115', 'B21115', 'SEAWINDS sigma-0 quality', 'Flag table', '0', '0', '17', 'Flag table', '0', '6', '', '', ''),
	('021116', 'B21116', 'SEAWINDS sigma-0 mode', 'Flag table', '0', '0', '17', 'Flag table', '0', '6', '', '', ''),
	('021117', 'B21117', 'Sigma-0 variance quality control', 'Numeric', '2', '0', '16', 'Numeric', '2', '5', '', '', ''),
	('021118', 'B21118', 'Attenuation correction on sigma-0', 'dB', '2', '-10000', '14', 'dB', '2', '5', '', '', ''),
	('021119', 'B21119', 'Wind scatterometer geophysical model function', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('021120', 'B21120', 'Probability of rain', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021121', 'B21121', 'SEAWINDS NOF* rain index', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('021122', 'B21122', 'Attenuation correction of sigma-0 (from tB)', 'dB', '2', '-10000', '14', 'dB', '2', '5', '', '', ''),
	('021123', 'B21123', 'SEAWINDS normalized radar cross section', 'dB', '2', '-30000', '15', 'dB', '2', '5', '', '', ''),
	('021128', 'B21128', 'Number of valid points per second used to derive previous parameters', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('021130', 'B21130', 'Spectrum total energy', 'Numeric', '6', '0', '28', 'Numeric', '6', '9', '', '', ''),
	('021131', 'B21131', 'Spectrum max energy', 'Numeric', '6', '0', '28', 'Numeric', '6', '9', '', '', ''),
	('021132', 'B21132', 'Direction of spectrum max on higher resolution grid', 'Degree', '3', '0', '19', 'Degree', '3', '6', '', '', ''),
	('021133', 'B21133', 'Wave-length of spectrum max on higher resolution grid', 'm', '3', '0', '29', 'm', '3', '9', '', '', ''),
	('021134', 'B21134', 'Range resolution of cress covariance spectrum', 'Rad m-1', '3', '0', '19', 'Rad m-1', '3', '6', '', '', ''),
	('021135', 'B21135', 'Real part of cross spectra polar grid number of bins', 'Numeric', '3', '-524288', '20', 'Numeric', '3', '7', '', '', ''),
	('021136', 'B21136', 'Imaginary part of cross spectra polar grid number of bins', 'Numeric', '3', '-524288', '20', 'Numeric', '3', '7', '', '', ''),
	('021137', 'B21137', 'KU band corrected ocean backscatter coefficient', 'dB', '2', '-32768', '16', 'dB', '2', '5', '', '', ''),
	('021138', 'B21138', 'Std KU band corrected ocean backscatter coefficient', 'dB', '2', '-32768', '16', 'dB', '2', '5', '', '', ''),
	('021139', 'B21139', 'KU band net instrumental correction for ACG', 'dB', '2', '-2048', '12', 'dB', '2', '4', '', '', ''),
	('021140', 'B21140', 'S band corrected ocean backscatter coefficient', 'dB', '2', '-32768', '16', 'dB', '2', '5', '', '', ''),
	('021141', 'B21141', 'Std S band corrected ocean backscatter coefficient', 'dB', '2', '-32768', '16', 'dB', '2', '5', '', '', ''),
	('021142', 'B21142', 'S band net instrumental correction for ACG', 'dB', '2', '-1024', '11', 'dB', '2', '4', '', '', ''),
	('021143', 'B21143', 'KU band rain attenuation', 'dB', '2', '-1073741824', '31', 'dB', '2', '10', '', '', ''),
	('021144', 'B21144', 'Altimeter rain flag', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('021150', 'B21150', 'Beam collocation', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('021151', 'B21151', 'Estimated error in sigma-0 at 40 deg. incidence angle', 'dB', '2', '0', '9', 'dB', '2', '3', '', '', ''),
	('021152', 'B21152', 'Slope at 40 deg. incidence angle', 'dB Deg-1', '2', '-80', '7', 'dB Deg-1', '2', '2', '', '', ''),
	('021153', 'B21153', 'Estimated error in slope at 40 deg. incidence angle', 'dB Deg-1', '2', '-40', '6', 'dB Deg-1', '2', '2', '', '', ''),
	('021154', 'B21154', 'Soil moisture sensitivity', 'dB', '2', '0', '12', 'dB', '2', '4', '', '', ''),
	('021155', 'B21155', 'Wind vector cell quality', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('021156', 'B21156', 'Backscatter distance', 'Numeric', '1', '-4096', '13', 'Numeric', '1', '4', '', '', ''),
	('021157', 'B21157', 'Loss per unit length of atmosphere used', 'dB m-1', '10', '0', '22', 'dB m-1', '10', '7', '', '', ''),
	('021158', 'B21158', 'ASCAT kp estimate quality', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('021159', 'B21159', 'ASCAT sigma-0 usability', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('021160', 'B21160', 'ASCAT use of synthetic data', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021161', 'B21161', 'ASCAT synthetic data quality', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021162', 'B21162', 'ASCAT satellite orbit and attitude quality', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021163', 'B21163', 'ASCAT solar array reflection contamination', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021164', 'B21164', 'ASCAT telemetry presence and quality', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021165', 'B21165', 'ASCAT extrapolated reference function presence', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021166', 'B21166', 'ASCAT land fraction', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('022001', 'B22001', 'Direction of waves ', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022002', 'B22002', 'Direction of wind waves ', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022003', 'B22003', 'Direction of swell waves ', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022004', 'B22004', 'Direction of current (see Note 7)', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022005', 'B22005', 'Direction of sea surface current', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022011', 'B22011', 'Period of waves ', 's', '0', '0', '6', 's', '0', '2', '', '', ''),
	('022012', 'B22012', 'Period of wind waves ', 's', '0', '0', '6', 's', '0', '2', '', '', ''),
	('022013', 'B22013', 'Period of swell waves ', 's', '0', '0', '6', 's', '0', '2', '', '', ''),
	('022021', 'B22021', 'Height of waves ', 'm', '1', '0', '10', 'm', '1', '4', '', '', ''),
	('022022', 'B22022', 'Height of wind waves ', 'm', '1', '0', '10', 'm', '1', '4', '', '', ''),
	('022023', 'B22023', 'Height of swell waves ', 'm', '1', '0', '10', 'm', '1', '4', '', '', ''),
	('022025', 'B22025', 'Standard deviation wave height', 'm', '2', '0', '10', 'm', '2', '4', '', '', ''),
	('022026', 'B22026', 'Standard deviation of significant wave height', 'm', '2', '0', '10', 'm', '2', '4', '', '', ''),
	('022031', 'B22031', 'Speed of current ', 'm s-1', '2', '0', '13', 'm s-1', '2', '4', '', '', ''),
	('022032', 'B22032', 'Speed of sea surface current', 'm s-1', '2', '0', '13', 'm s-1', '2', '4', '', '', ''),
	('022035', 'B22035', 'Tidal elevation with respect to local chart datum', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('022036', 'B22036', 'Meteorological residual tidal elevation (surge or offset)', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('022037', 'B22037', 'Tidal elevation with respect to national land datum', 'm', '3', '-10000', '15', 'm', '3', '5', '', '', ''),
	('022038', 'B22038', 'Tidal elevation with respect to local chart datum', 'm', '3', '-10000', '15', 'm', '3', '5', '', '', ''),
	('022039', 'B22039', 'Meteorological residual tidal elevation (surge or offset) (see Note 4)', 'm', '3', '-5000', '13', 'm', '3', '4', '', '', ''),
	('022040', 'B22040', 'Meteorological residual tidal elevation (surge or offset) (see Note 4)', 'm', '3', '-5000', '14', 'm', '3', '5', '', '', ''),
	('022041', 'B22041', 'Sea-surface temperature (15-day running mean)', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('022042', 'B22042', 'Sea/water temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('022043', 'B22043', 'Sea/water temperature', 'K', '2', '0', '15', 'K', '2', '5', '', '', ''),
	('022044', 'B22044', 'Sound velocity ', 'm s-1', '1', '0', '14', 'm s-1', '1', '5', '', '', ''),
	('022045', 'B22045', 'Sea/water temperature', 'K', '3', '0', '19', 'K', '3', '6', '', '', ''),
	('022049', 'B22049', 'Sea surface temperature', 'K', '2', '0', '15', 'K', '2', '5', '', '', ''),
	('022050', 'B22050', 'Standard deviation sea-surface temperature', 'K', '2', '0', '8', 'K', '2', '3', '', '', ''),
	('022055', 'B22055', 'Float cycle number', 'Numeric', '0', '0', '10', 'Numeric', '0', '3', '', '', ''),
	('022056', 'B22056', 'Direction of profile', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('022059', 'B22059', 'Sea surface salinity', 'Part per thousand', '2', '0', '14', 'Part per thousand', '2', '5', '', '', ''),
	('022060', 'B22060', 'Lagrangian drifter drogue status', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('022061', 'B22061', 'State of the sea ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('022062', 'B22062', 'Salinity', 'Part per thousand', '2', '0', '14', 'Part per thousand', '2', '5', '', '', ''),
	('022063', 'B22063', 'Total water depth ', 'm', '0', '0', '14', 'm', '0', '5', '', '', ''),
	('022064', 'B22064', 'Salinity', 'Part per thousand', '3', '0', '17', 'Part per thousand', '3', '6', '', '', ''),
	('022065', 'B22065', 'Water pressure', 'Pa', '-3', '0', '17', 'Pa', '-3', '6', '', '', ''),
	('022066', 'B22066', 'Water conductivity', 'S m-1', '6', '0', '26', 'S m-1', '6', '8', '', '', ''),
	('022067', 'B22067', 'Instrument type for water temperature profile measurement', 'Code table', '0', '0', '10', 'Code table', '0', '4', '', '', ''),
	('022068', 'B22068', 'Water temperature profile recorder types', 'Code table', '0', '0', '7', 'Code table', '0', '3', '', '', ''),
	('022069', 'B22069', 'Spectral wave density', 'm2 Hz-1', '3', '0', '22', 'm2 Hz-1', '3', '7', '', '', ''),
	('022070', 'B22070', 'Significant wave height', 'm', '2', '0', '13', 'm', '2', '4', '', '', ''),
	('022071', 'B22071', 'Spectral peak wave period', 's', '1', '0', '9', 's', '1', '3', '', '', ''),
	('022072', 'B22072', 'Spectral peak wave length', 'm', '0', '0', '13', 'm', '0', '4', '', '', ''),
	('022073', 'B22073', 'Maximum wave height', 'm', '2', '0', '13', 'm', '2', '4', '', '', ''),
	('022074', 'B22074', 'Average wave period', 's', '1', '0', '9', 's', '1', '3', '', '', ''),
	('022075', 'B22075', 'Average wave length', 'm', '0', '0', '13', 'm', '0', '4', '', '', ''),
	('022076', 'B22076', 'Direction from which dominant waves are coming', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022077', 'B22077', 'Directional spread of dominant wave', 'Degree', '0', '0', '9', 'Degree', '0', '3', '', '', ''),
	('022078', 'B22078', 'Duration of wave record', 's', '0', '0', '12', 's', '0', '4', '', '', ''),
	('022079', 'B22079', 'Length of wave record', 'm', '0', '0', '16', 'm', '0', '5', '', '', ''),
	('022080', 'B22080', 'Waveband central frequency', 'Hz', '3', '0', '10', 'Hz', '3', '4', '', '', ''),
	('022081', 'B22081', 'Waveband central wave number', 'm-1', '5', '0', '13', 'm-1', '5', '4', '', '', ''),
	('022082', 'B22082', 'Maximum non-directional spectral wave density', 'm2 s', '2', '0', '20', 'm2 s', '2', '7', '', '', ''),
	('022083', 'B22083', 'Maximum non-directional spectral wave number', 'm3', '2', '0', '20', 'm3', '2', '7', '', '', ''),
	('022084', 'B22084', 'Band containing maximum non- directional spectral wave density', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('022085', 'B22085', 'Spectral wave density ratio', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('022086', 'B22086', 'Mean direction from which waves are coming', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022087', 'B22087', 'Principal direction from which waves are coming', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022088', 'B22088', 'First normalized polar coordinate from Fourier coefficients', 'Numeric', '2', '0', '7', 'Numeric', '2', '3', '', '', ''),
	('022089', 'B22089', 'Second normalized polar coordinate from Fourier coefficients', 'Numeric', '2', '0', '7', 'Numeric', '2', '3', '', '', ''),
	('022090', 'B22090', 'Non-directional spectral estimate by wave frequency', 'm2 s', '2', '0', '20', 'm2 s', '2', '7', '', '', ''),
	('022091', 'B22091', 'Non-directional spectral estimate by wave number', 'm3', '2', '0', '20', 'm3', '2', '7', '', '', ''),
	('022092', 'B22092', 'Directional spectral estimate by wave frequency', 'm2 rad-1 s', '2', '0', '20', 'm2 rad-1 s', '2', '7', '', '', ''),
	('022093', 'B22093', 'Directional spectral estimate by wave number', 'm4', '2', '0', '20', 'm4', '2', '7', '', '', ''),
	('022094', 'B22094', 'Total number of wave bands', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('022095', 'B22095', 'Directional spread of individual waves', 'Degree', '0', '0', '8', 'Degree', '0', '3', '', '', ''),
	('022096', 'B22096', 'Spectral band width', 's-1', '3', '0', '4', 's-1', '3', '2', '', '', ''),
	('022097', 'B22097', 'Mean wavelength > 731 m of image spectrum at low wave numbers', 'm', '0', '0', '14', 'm', '0', '5', '', '', ''),
	('022098', 'B22098', 'Wavelength spread (wavelength > 731 m) at low wave numbers', 'm', '0', '0', '14', 'm', '0', '5', '', '', ''),
	('022099', 'B22099', 'Mean direction at low wave numbers (wavelength > 731 m)', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022100', 'B22100', 'Direction spread at low wave numbers (wavelength > 731 m)', 'Degree', '0', '0', '9', 'Degree', '0', '3', '', '', ''),
	('022101', 'B22101', 'Total energy (wavelength > 731m) at low wave numbers', 'Numeric', '0', '0', '31', 'Numeric', '0', '10', '', '', ''),
	('022120', 'B22120', 'Tide station automated water level check', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('022121', 'B22121', 'Tide station manual water level check', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('022122', 'B22122', 'Tide station automated meteorological data check', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('022123', 'B22123', 'Tide station manual meteorological data check', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('022141', 'B22141', 'Sea-surface temperature (15-day running mean)', 'K', '2', '0', '15', 'K', '2', '5', '', '', ''),
	('022150', 'B22150', 'Number of 18 Hz valid points for KU band', 'Numeric', '0', '0', '10', 'Numeric', '0', '4', '', '', ''),
	('022151', 'B22151', 'KU band ocean range', 'm', '3', '0', '31', 'm', '3', '10', '', '', ''),
	('022152', 'B22152', 'STD of 18 Hz KU band ocean range', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022153', 'B22153', 'Number of 18 Hz valid points for S band', 'Numeric', '0', '0', '10', 'Numeric', '0', '4', '', '', ''),
	('022154', 'B22154', 'S band ocean range', 'm', '3', '0', '31', 'm', '3', '10', '', '', ''),
	('022155', 'B22155', 'STD of 18 Hz S band ocean range', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022156', 'B22156', 'KU band significant wave height', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022157', 'B22157', 'STD 18Hz KU band significant wave height', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022158', 'B22158', 'S band significant wave height', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022159', 'B22159', 'STD 18Hz S band significant wave height', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022160', 'B22160', 'Normalized inverse wave age', 'Numeric', '6', '0', '21', 'Numeric', '6', '7', '', '', ''),
	('022161', 'B22161', 'Wave spectra', 'm4', '4', '0', '27', 'm4', '4', '9', '', '', ''),
	('023001', 'B23001', 'Accident early notification — article applicable', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023002', 'B23002', 'Activity or facility involved in incident', 'Code table', '0', '0', '5', 'Code table ', '0', '2', '', '', ''),
	('023003', 'B23003', 'Type of release ', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023004', 'B23004', 'Countermeasures taken near border', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023005', 'B23005', 'Cause of incident ', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023006', 'B23006', 'Incident situation ', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023007', 'B23007', 'Characteristics of release', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023008', 'B23008', 'State of current release ', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023009', 'B23009', 'State of expected release ', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023016', 'B23016', 'Possibility of significant chemical toxic health effect', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023017', 'B23017', 'Flow discharge of major recipient', 'm3 s-1', '6', '0', '20', 'm3 s-1', '6', '7', '', '', ''),
	('023018', 'B23018', 'Release behaviour over time', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023019', 'B23019', 'Actual release height', 'm', '0', '-15000', '17', 'm ', '0', '6', '', '', ''),
	('023021', 'B23021', 'Effective release height', 'm', '0', '-15000', '17', 'm ', '0', '6', '', '', ''),
	('023022', 'B23022', 'Distance of release point or site of incident', 'm', '0', '0', '24', 'm ', '0', '8', '', '', ''),
	('023023', 'B23023', 'Main transport speed in the atmosphere', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('023024', 'B23024', 'Main transport speed in water', 'm s-1', '2', '0', '13', 'm s-1', '2', '4', '', '', ''),
	('023025', 'B23025', 'Main transport speed in ground water', 'm s-1', '2', '0', '13', 'm s-1', '2', '4', '', '', ''),
	('023027', 'B23027', 'Main transport direction in the atmosphere', 'Degree true ', '0', '0', '9', 'Degree true ', '0', '3', '', '', ''),
	('023028', 'B23028', 'Main transport direction in water', 'Degree true ', '0', '0', '9', 'Degree true ', '0', '3', '', '', ''),
	('023029', 'B23029', 'Main transport direction in ground water', 'Degree true ', '0', '0', '9', 'Degree true ', '0', '3', '', '', ''),
	('023031', 'B23031', 'Possibility that plume will encounter precipitation in State in which incident occurred', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023032', 'B23032', 'Plume will encounter change in wind direction and/or speed flag', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('024001', 'B24001', 'Estimate of amount of radioactivity released up to specified time', 'Bq*', '-11', '0', '28', 'Bq* ', '-11', '9', '', '', ''),
	('024002', 'B24002', 'Estimated maximum potential release', 'Bq', '-11', '0', '28', 'Bq ', '-11', '9', '', '', ''),
	('024003', 'B24003', 'Composition of release', 'Code table', '0', '0', '5', 'Code table ', '0', '2', '', '', ''),
	('024004', 'B24004', 'Element name', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('024005', 'B24005', 'Isotope mass', 'Numeric', '0', '0', '9', 'Numeric ', '0', '3', '', '', ''),
	('024011', 'B24011', 'Dose', 'mSv*/**', '2', '0', '32', 'mSv*/**', '2', '10', '', '', ''),
	('024012', 'B24012', 'Trajectory dose (defined location and expected time of arrival)', 'mSv', '2', '0', '32', 'mSv', '2', '10', '', '', ''),
	('024013', 'B24013', 'Gamma dose in air along the main transport path (defined location and time period)', 'mSv', '2', '0', '32', 'mSv ', '2', '10', '', '', ''),
	('024021', 'B24021', 'Air concentration (of named isotope type including gross beta)', 'Bq m-3', '2', '0', '32', 'Bq m-3', '2', '10', '', '', ''),
	('024022', 'B24022', 'Concentration in precipitation (of names isotope type)', 'Bq l-1', '2', '0', '32', 'Bq l-1', '2', '10', '', '', ''),
	('024023', 'B24023', 'Pulse rate of beta radiation', 's-1', '1', '0', '14', 's-1', '1', '4', '', '', ''),
	('024024', 'B24024', 'Pulse rate of gamma radiation', 's-1', '1', '0', '14', 's-1', '1', '4', '', '', ''),
	('025001', 'B25001', 'Range-gate length', 'm', '-1', '0', '6', 'm', '-1', '2', '', '', ''),
	('025002', 'B25002', 'Number of gates averaged', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('025003', 'B25003', 'Number of integrated pulses', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025004', 'B25004', 'Echo processing', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025005', 'B25005', 'Echo integration', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025006', 'B25006', 'Z to R conversion', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('025007', 'B25007', 'Z to R conversion factor', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('025008', 'B25008', 'Z to R conversion exponent', 'Numeric', '2', '0', '9', 'Numeric', '2', '3', '', '', ''),
	('025009', 'B25009', 'Calibration method (see Note 3)', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('025010', 'B25010', 'Clutter treatment', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('025011', 'B25011', 'Ground occultation correction (screening)', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025012', 'B25012', 'Range attenuation correction', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025013', 'B25013', 'Bright-band correction', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('025014', 'B25014', 'Azimuth clutter cut-off (see Note 1)', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('025015', 'B25015', 'Radome attenuation correction', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('025016', 'B25016', 'Clear-air attenuation correction', 'dB m-1', '5', '0', '6', 'dB m-1', '5', '2', '', '', ''),
	('025017', 'B25017', 'Precipitation attenuation correction', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('025018', 'B25018', 'A to Z law for attenuation factor', 'Numeric', '7', '0', '6', 'Numeric', '7', '2', '', '', ''),
	('025019', 'B25019', 'A to Z law for attenuation exponent', 'Numeric', '2', '0', '7', 'Numeric', '2', '3', '', '', ''),
	('025020', 'B25020', 'Mean speed estimation', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025021', 'B25021', 'Wind computation enhancement', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('025025', 'B25025', 'Battery voltage', 'V', '1', '0', '9', 'V', '1', '3', '', '', ''),
	('025026', 'B25026', 'Battery voltage (large range)', 'V', '1', '0', '12', 'V', '1', '4', '', '', ''),
	('025028', 'B25028', 'Operator or manufacturer defined parameter', 'Numeric', '1', '-16384', '15', 'Numeric', '1', '5', '', '', ''),
	('025029', 'B25029', 'Calibration method', 'Flag table', '0', '0', '6', 'Flag table', '0', '2', '', '', ''),
	('025030', 'B25030', 'Running mean sea-surface temperature usage', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025032', 'B25032', 'Wind profiler mode information (see Note 2)', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025033', 'B25033', 'Wind profiler submode information (see Note 2)', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025034', 'B25034', 'Wind profiler quality control test results (see Note 2)', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('025036', 'B25036', 'Atmospherics location method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('025040', 'B25040', 'CO2 wind product derivation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('025041', 'B25041', 'Moving platform direction reporting method', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025042', 'B25042', 'Moving platform speed reporting method', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025043', 'B25043', 'Wave sampling interval (time)', 's', '4', '0', '15', 's', '4', '5', '', '', ''),
	('025044', 'B25044', 'Wave sampling interval (space)', 'm', '2', '0', '14', 'm', '2', '5', '', '', ''),
	('025045', 'B25045', 'HIRS channel combination', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('025046', 'B25046', 'MSU channel combination', 'Flag table', '0', '0', '5', 'Flag table', '0', '2', '', '', ''),
	('025047', 'B25047', 'SSU channel combination', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('025048', 'B25048', 'AMSU-A channel combination', 'Flag table', '0', '0', '16', 'Flag table', '0', '6', '', '', ''),
	('025049', 'B25049', 'AMSU-B channel combination', 'Flag table', '0', '0', '6', 'Flag table', '0', '2', '', '', ''),
	('025050', 'B25050', 'Principal component score', 'Numeric', '4', '-131072', '18', 'Numeric', '4', '6', '', '', ''),
	('025051', 'B25051', 'AVHRR channel combination', 'Flag table', '0', '0', '7', 'Flag table', '0', '3', '', '', ''),
	('025052', 'B25052', 'Log-10 of principal components normalized fit to data', 'Numeric', '4', '0', '15', 'Numeric', '4', '5', '', '', ''),
	('025053', 'B25053', 'Observation quality', 'Flag table', '0', '0', '12', 'Flag table', '0', '4', '', '', ''),
	('025054', 'B25054', 'SSMIS Subframe ID nember', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('025055', 'B25055', 'Multiplexer housekeeping', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('025060', 'B25060', 'Software identification (see Note 2)', 'Numeric', '0', '0', '14', 'Numeric', '0', '5', '', '', ''),
	('025061', 'B25061', 'Software identification and version number', 'CCITT IA5', '0', '0', '96', 'Character', '0', '12', '', '', ''),
	('025062', 'B25062', 'Database identification', 'Numeric', '0', '0', '14', 'Numeric', '0', '5', '', '', ''),
	('025065', 'B25065', 'Orientation correction (azimuth)', 'Degree', '2', '-1000', '11', 'Degree', '2', '4', '', '', ''),
	('025066', 'B25066', 'Orientation correction (elevation)', 'Degree', '2', '-1000', '11', 'Degree', '2', '4', '', '', ''),
	('025067', 'B25067', 'Radiosonde release point pressure correction', 'Pa', '0', '-8000', '14', 'Pa', '0', '4', '', '', ''),
	('025068', 'B25068', 'Number of archive recomputes', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('025069', 'B25069', 'Flight level pressure corrections', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('025070', 'B25070', 'Major frame count', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('025071', 'B25071', 'Frame count', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('025075', 'B25075', 'Satellite antenna corrections version number', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('025076', 'B25076', 'Log–10 of (Temperature-radiance central wavenumber) for ATOVS', 'log m-1', '8', '0', '30', 'log m-1', '8', '10', '', '', ''),
	('025077', 'B25077', 'Bandwidth correction coefficient 1 for ATOVS', 'Numeric', '5', '-100000', '18', 'Numeric', '5', '7', '', '', ''),
	('025078', 'B25078', 'Bandwidth correction coefficient 2 for ATOVS', 'Numeric', '5', '0', '17', 'Numeric', '5', '6', '', '', ''),
	('025079', 'B25079', 'Albedo-radiance solar filtered irradiance for ATOVS', 'W m-2', '4', '0', '24', 'W m-2', '4', '8', '', '', ''),
	('025080', 'B25080', 'Albedo-radiance equivalent filter width for ATOVS', 'm', '10', '0', '14', 'm', '10', '5', '', '', ''),
	('025085', 'B25085', 'Fraction of clear pixels in HIRS FOV', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('025086', 'B25086', 'Depth correction indicator', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025091', 'B25091', 'Structure constant of the refraction index (Cn2)', 'dB', '3', '-18192', '13', 'dB', '3', '5', '', '', ''),
	('025092', 'B25092', 'Acoustic propagation velocity', 'm s-1', '2', '28000', '14', 'm s-1', '2', '5', '', '', ''),
	('025093', 'B25093', 'RASS computation correction', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('025095', 'B25095', 'Altimeter state flag', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('025096', 'B25096', 'Radiometer state flag', 'Flag table', '0', '0', '5', 'Flag table', '0', '2', '', '', ''),
	('025097', 'B25097', 'Three dimensional error estimate of the navigator orbit', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('025100', 'B25100', 'XBT/XCTD fall rate equation coefficient a', 'Numeric', '5', '0', '20', 'Numeric', '5', '6', '', '', ''),
	('025101', 'B25101', 'XBT/XCTD fall rate equation coefficient b', 'Numeric', '5', '-500000', '21', 'Numeric', '5', '6', '', '', ''),
	('025102', 'B25102', 'Number of missing lines excluding data gaps', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025103', 'B25103', 'Number of directional bins', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025104', 'B25104', 'Number of wave-length bins', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025105', 'B25105', 'First directional bin', 'Degree', '3', '0', '19', 'Degree', '3', '6', '', '', ''),
	('025106', 'B25106', 'Directional bin step', 'Degree', '3', '0', '19', 'Degree', '3', '6', '', '', ''),
	('025107', 'B25107', 'First wave-length bin', 'm', '3', '0', '29', 'm', '3', '9', '', '', ''),
	('025108', 'B25108', 'Last wave-length bin', 'm', '3', '0', '29', 'm', '3', '9', '', '', ''),
	('025110', 'B25110', 'Image processing summary', 'Flag table', '0', '0', '10', 'Flag table', '0', '4', '', '', ''),
	('025111', 'B25111', 'Number of input data gaps', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025120', 'B25120', 'RA2-L2-processing flag', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025121', 'B25121', 'RA2-L2-processing quality', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('025122', 'B25122', 'Hardware configuration for RF', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025123', 'B25123', 'Hardware configuration for HPA', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025124', 'B25124', 'MWR L2 Processing flag', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025125', 'B25125', 'MWR L2-processing quality', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('025126', 'B25126', 'Model dry tropospheric correction', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025127', 'B25127', 'Inverted barometer correction', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025128', 'B25128', 'Model wet tropospheric correction', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025129', 'B25129', 'MWR derived wet tropospheric correction', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025130', 'B25130', 'RA2 ionospheric correction on KU band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025131', 'B25131', 'Ionospheric correction from Doris on KU band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025132', 'B25132', 'Ionospheric correction from model on KU band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025133', 'B25133', 'Sea state bias correction on KU band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025134', 'B25134', 'RA2 ionospheric correction on S band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025135', 'B25135', 'Ionospheric correction from Doris on S band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025136', 'B25136', 'Ionospheric correction from model on S band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025137', 'B25137', 'Sea state bias correction on S band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025138', 'B25138', 'Average signal to noise ration', 'Numeric', '0', '-2048', '12', 'Numeric', '0', '4', '', '', ''),
	('025140', 'B25140', 'Start channel', 'Numeric', '0', '0', '14', 'Numeric', '0', '5', '', '', ''),
	('025141', 'B25141', 'End channel', 'Numeric', '0', '0', '14', 'Numeric', '0', '5', '', '', ''),
	('025142', 'B25142', 'Channel scale factor', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('025150', 'B25150', 'Method of tropical cyclone intensity analysis using satellite data', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('026001', 'B26001', 'Principal time of daily reading in UTC of maximum temperature', 'Hour', '1', '0', '12', 'Hour', '1', '3', '', '', ''),
	('026002', 'B26002', 'Principal time of daily reading in UTC of minimum temperature', 'Hour', '1', '0', '12', 'Hour', '1', '3', '', '', ''),
	('026003', 'B26003', 'Time difference', 'Minute', '0', '-1440', '12', 'Minute', '0', '4', '', '', ''),
	('026010', 'B26010', 'Hours included', 'Flag table', '0', '0', '26', 'Flag table', '0', '9', '', '', ''),
	('027001', 'B27001', 'Latitude (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('027002', 'B27002', 'Latitude (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('027003', 'B27003', 'Alternate latitude (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('027004', 'B27004', 'Alternate latitude (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('027020', 'B27020', 'Satellite location counter', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('027021', 'B27021', 'Satellite sublocation dimension', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('027031', 'B27031', 'In direction of 0 degrees longitude distance from the Earth’s centre', 'm', '2', '-1073741824', '31', 'm', '2', '10', '', '', ''),
	('027080', 'B27080', 'Viewing Azimuth angle', 'Degree true', '2', '0', '16', 'Degree true', '2', '5', '', '', ''),
	('028001', 'B28001', 'Longitude (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('028002', 'B28002', 'Longitude (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('028003', 'B28003', 'Alternate longitude (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('028004', 'B28004', 'Alternate longitude (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('028031', 'B28031', 'In direction 90 degrees East distance from the Earth’s centre', 'm', '2', '-1073741824', '31', 'm', '2', '10', '', '', ''),
	('029001', 'B29001', 'Projection type', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('029002', 'B29002', 'Co-ordinate grid type', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('030001', 'B30001', 'Pixel value (4 bits)', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('030002', 'B30002', 'Pixel value (8 bits)', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('030004', 'B30004', 'Pixel value (16 bits)', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('030021', 'B30021', 'Number of pixels per row', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('030022', 'B30022', 'Number of pixels per column', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('030031', 'B30031', 'Picture type', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('030032', 'B30032', 'Combination with other data', 'Flag table', '0', '0', '16', 'Flag table', '0', '6', '', '', ''),
	('031000', 'B31000', 'Short delayed descriptor replication factor', 'Numeric', '0', '0', '1', 'Numeric', '0', '4', '', '', ''),
	('031001', 'B31001', 'Delayed descriptor replication factor', 'Numeric', '0', '0', '8', 'Numeric', '0', '4', '', '', ''),
	('031002', 'B31002', 'Extended delayed descriptor replication factor', 'Numeric', '0', '0', '16', 'Numeric', '0', '4', '', '', ''),
	('031011', 'B31011', 'Delayed descriptor and data repetition factor', 'Numeric', '0', '0', '8', 'Numeric', '0', '4', '', '', ''),
	('031012', 'B31012', 'Extended delayed descriptor and data repetition factor', 'Numeric', '0', '0', '16', 'Numeric', '0', '4', '', '', ''),
	('031021', 'B31021', 'Associated field significance', 'Code table', '0', '0', '6', 'Code table', '', '', '', '', ''),
	('031031', 'B31031', 'Data present indicator', 'Flag table', '0', '0', '1', 'Flag table', '', '', '', '', ''),
	('033001', 'B33001', 'Reserved', '', '', '', '', '', '', '', '', '', ''),
	('033002', 'B33002', 'Quality information', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033003', 'B33003', 'Quality information', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033004', 'B33004', 'Reserved', '', '', '', '', '', '', '', '', '', ''),
	('033005', 'B33005', 'Quality information (AWS data)', 'Flag table', '0', '0', '30', 'Flag table', '0', '10', '', '', ''),
	('033006', 'B33006', 'Internal measurement status information (AWS)', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033007', 'B33007', 'Per cent confidence', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033015', 'B33015', 'Data quality check indicator', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('033020', 'B33020', 'Quality control indication of following value', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033021', 'B33021', 'Quality of following value', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033022', 'B33022', 'Quality of buoy satellite transmission', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033023', 'B33023', 'Quality of buoy location', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033024', 'B33024', 'Station elevation quality mark (for mobile stations)', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('033025', 'B33025', 'ACARS interpolated values', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033026', 'B33026', 'Moisture quality', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('033027', 'B33027', 'Location quality class (range of radius of 66 % confidence)', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033030', 'B33030', 'Scan line status flags for ATOVS', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('033031', 'B33031', 'Scan line quality flags for ATOVS', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('033032', 'B33032', 'Channel quality flags for ATOVS', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('033033', 'B33033', 'Field of view quality flags for ATOVS', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('033035', 'B33035', 'Manual/automatic quality control', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('033036', 'B33036', 'Nominal confidence threshold', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033037', 'B33037', 'Wind correlation error', 'Flag table', '0', '0', '20', 'Flag table', '0', '7', '', '', ''),
	('033038', 'B33038', 'Quality flags for ground-based GNSS data', 'Flag table', '0', '0', '10', 'Flag table', '0', '4', '', '', ''),
	('033039', 'B33039', 'Quality flags for Radio Occultation data', 'Flag table', '0', '0', '16', 'Flag table', '0', '6', '', '', ''),
	('033040', 'B33040', 'Confidence interval', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033041', 'B33041', 'Attribute of following value', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033042', 'B33042', 'Type of limit represented by following value', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033043', 'B33043', 'AST confidence', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('033044', 'B33044', 'ASAR quality information', 'Flag table', '0', '0', '15', 'Flag table', '0', '5', '', '', ''),
	('033045', 'B33045', 'Probability of following event (see Notes 1 and 3)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033046', 'B33046', 'Conditional probability of following event with respect to specified conditioning event (see Notes 1 2 and 3)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033047', 'B33047', 'Measurement confidence data', 'Flag table', '0', '0', '31', 'Flag table', '0', '11', '', '', ''),
	('033048', 'B33048', 'Confidence measure of SAR inversion', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033049', 'B33049', 'Confidence measure of wind retrieval', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033050', 'B33050', 'Global GTSPP quality flag', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('033052', 'B33052', 'S band ocean retracking quality', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('033053', 'B33053', 'KU band ocean retracking quality', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('033060', 'B33060', 'GqisFlagQual - individual IASI-System quality flag', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033061', 'B33061', 'GqisQualIndex - indicator for instrument noise performance (contributions from spectral and radiometric)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033062', 'B33062', 'GqisQualIndexLoc - indicator for geometric quality index', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033063', 'B33063', 'GqisQualIndexRad - indicator for instrument noise performance (contributions from radiometric calibration)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033064', 'B33064', 'GqisQualIndexSpect - indicator for instrument noise performance (contributions from spectral calibration)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033065', 'B33065', 'GqisSysTecSondQual - output of system TEC (Technical Expertise Centre) quality function', 'Numeric', '0', '0', '24', 'Numeric', '0', '8', '', '', ''),
	('035000', 'B35000', 'FM and regional code number', 'Code table', '0', '0', '10', 'Code table', '0', '3', '', '', ''),
	('035001', 'B35001', 'Time-frame for monitoring', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('035011', 'B35011', 'Number of reports actually received', 'Numeric', '0', '0', '14', 'Numeric', '0', '4', '', '', ''),
	('035021', 'B35021', 'Bulletin being monitored (TTAAii)', 'CCITT IA5', '0', '0', '48', 'Character', '0', '6', '', '', ''),
	('035022', 'B35022', 'Bulletin being monitored (YYGGgg)', 'CCITT IA5', '0', '0', '48', 'Character', '0', '6', '', '', ''),
	('035023', 'B35023', 'Bulletin being monitored (CCCC)', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('035024', 'B35024', 'Bulletin being monitored (BBB)', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('035030', 'B35030', 'Discrepancies in the availability of expected data', 'Code table', '0', '0', '4', 'Code table', '0', '1', '', '', ''),
	('035031', 'B35031', 'Qualifier on monitoring results', 'Code table', '0', '0', '7', 'Code table', '0', '2', '', '', ''),
	('035032', 'B35032', 'Cause of missing data', 'Code table', '0', '0', '4', 'Code table', '0', '1', '', '', ''),
	('035033', 'B35033', 'Observation and collection deficiencies', 'Code table', '0', '0', '7', 'Code table', '0', '2', '', '', ''),
	('035034', 'B35034', 'Statistical trends for availability of data (during the survey period(s))', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('035035', 'B35035', 'Reason for termination', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('040001', 'B40001', 'Surface soil moisture (ms)', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040002', 'B40002', 'Estimated error in surface soil moisture', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040003', 'B40003', 'Mean surface soil moisture ', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('040004', 'B40004', 'Rain fall detection', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('040005', 'B40005', 'Soil moisture correction flag', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('040006', 'B40006', 'Soil moisture processing flag', 'Flag table', '0', '0', '16', 'Flag table', '0', '6', '', '', ''),
	('040007', 'B40007', 'Soil moisture quality', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040008', 'B40008', 'Frozen land surface fraction', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040009', 'B40009', 'Inundation and wetland fraction', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040010', 'B40010', 'Topographic complexity', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('099999', 'B99999', 'Notes to Code and Flag Tables', '', '', '', '', '', '', '', '', '', ''),
	('000001', 'B00001', 'Table A: entry', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000002', 'B00002', 'Table A: data category description line 1', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('000003', 'B00003', 'Table A: data category description line 2', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('000004', 'B00004', 'BUFR/CREX Master table (see Note 2)', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000005', 'B00005', 'BUFR/CREX edition number', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000006', 'B00006', 'BUFR Master table Version number (see Note 3)', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000007', 'B00007', 'CREX Master table Version number (see Note 4)', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000008', 'B00008', 'BUFR Local table version number (see Note 5)', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000010', 'B00010', 'F descriptor to be added or defined', 'CCITT IA5', '0', '0', '8', 'Character', '0', '1', '', '', ''),
	('000011', 'B00011', 'X descriptor to be added or defined', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('000012', 'B00012', 'Y descriptor to be added or defined', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000013', 'B00013', 'Element name line 1', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('000014', 'B00014', 'Element name line 2', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('000015', 'B00015', 'Units name', 'CCITT IA5', '0', '0', '192', 'Character', '0', '24', '', '', ''),
	('000016', 'B00016', 'Units scale sign', 'CCITT IA5', '0', '0', '8', 'Character', '0', '1', '', '', ''),
	('000017', 'B00017', 'Units scale', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000018', 'B00018', 'Units reference sign', 'CCITT IA5', '0', '0', '8', 'Character', '0', '1', '', '', ''),
	('000019', 'B00019', 'Units reference value', 'CCITT IA5', '0', '0', '80', 'Character', '0', '10', '', '', ''),
	('000020', 'B00020', 'Element data width', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('000030', 'B00030', 'Descriptor defining sequence', 'CCITT IA5', '0', '0', '48', 'Character', '0', '6', '', '', ''),
	('001001', 'B01001', 'WMO block number', 'Numeric', '0', '0', '7', 'Numeric', '0', '2', '', '', ''),
	('001002', 'B01002', 'WMO station number', 'Numeric', '0', '0', '10', 'Numeric', '0', '3', '', '', ''),
	('001003', 'B01003', 'WMO Region number/geographical area', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('001004', 'B01004', 'WMO Region sub-area (see Note 9)', 'Numeric', '0', '0', '3', 'Numeric', '0', '1', '', '', ''),
	('001005', 'B01005', 'Buoy/platform identifier', 'Numeric', '0', '0', '17', 'Numeric', '0', '5', '', '', ''),
	('001006', 'B01006', 'Aircraft flight number', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001007', 'B01007', 'Satellite identifier', 'Code table', '0', '0', '10', 'Code table', '0', '4', '', '', ''),
	('001008', 'B01008', 'Aircraft registration number or other identification', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001009', 'B01009', 'Type of commercial aircraft', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001010', 'B01010', 'Stationary buoy platform identifier; e.g. C-MAN buoys', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001011', 'B01011', 'Ship or mobile land station identifier', 'CCITT IA5', '0', '0', '72', 'Character', '0', '9', '', '', ''),
	('001012', 'B01012', 'Direction of motion of moving observing platform*', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('001013', 'B01013', 'Speed of motion of moving observing platform??*', 'm s-1', '0', '0', '10', 'm s-1', '0', '3', '', '', ''),
	('001014', 'B01014', 'Platform drift speed (high precision)', 'm s-1', '2', '0', '10', 'm s-1', '2', '4', '', '', ''),
	('001015', 'B01015', 'Station or site name', 'CCITT IA5', '0', '0', '160', 'Character', '0', '20', '', '', ''),
	('001018', 'B01018', 'Short station or site name', 'CCITT IA5', '0', '0', '40', 'Character', '0', '5', '', '', ''),
	('001019', 'B01019', 'Long Station or site name', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('001020', 'B01020', 'WMO Region sub-area', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('001021', 'B01021', 'Synoptic feature identifier', 'Numeric', '0', '0', '14', 'Numeric', '0', '4', '', '', ''),
	('001022', 'B01022', 'Name of feature (see Note 11)', 'CCITT IA5', '0', '0', '224', 'Character', '0', '28', '', '', ''),
	('001023', 'B01023', 'Observation sequence number ', 'Numeric', '0', '0', '9', 'Numeric', '0', '3', '', '', ''),
	('001025', 'B01025', 'Storm identifier (see Note 1)', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('001026', 'B01026', 'WMO storm name*', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001027', 'B01027', 'WMO long storm name*', 'CCITT IA5', '0', '0', '80', 'Character', '0', '10', '', '', ''),
	('001030', 'B01030', 'Numerical model identifier (see Note 13)', 'CCITT IA5', '0', '0', '128', 'Character', '0', '16', '', '', ''),
	('001031', 'B01031', 'Identification of originating/generating centre (see Note 10)', 'Code table', '0', '0', '16', 'Code table', '0', '5', '', '', ''),
	('001032', 'B01032', 'Generating application', 'Code table defined by originating/generating centre (Notes 3 4 and 5)', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001033', 'B01033', 'Identification of originating/generating centre', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001034', 'B01034', 'Identification of originating/generating sub-centre', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001035', 'B01035', 'Originating Centre', 'Common Code Table C-11', '0', '0', '16', 'Common Code Table C-11', '0', '5', '', '', ''),
	('001036', 'B01036', 'Agency in charge of operating the Observing platform', 'Code table', '0', '0', '20', 'Code table', '0', '7', '', '', ''),
	('001037', 'B01037', 'SIGMET sequence identifier', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('001041', 'B01041', 'Absolute platform velocity – first component (see Note 6)', 'm s-1', '5', '-1073741824', '31', 'm s-1', '5', '10', '', '', ''),
	('001042', 'B01042', 'Absolute platform velocity – second component  (see Note 6)', 'm s-1', '5', '-1073741824', '31', 'm s-1', '5', '10', '', '', ''),
	('001043', 'B01043', 'Absolute platform velocity – third component  (see Note 6)', 'm s-1', '5', '-1073741824', '31', 'm s-1', '5', '10', '', '', ''),
	('001050', 'B01050', 'Platform transmitter ID number', 'Numeric', '0', '0', '17', 'Numeric', '0', '6', '', '', ''),
	('001051', 'B01051', 'Platform transmitter ID number', 'CCITT IA5', '0', '0', '96', 'Character', '0', '12', '', '', ''),
	('001060', 'B01060', 'Aircraft reporting point (Beacon identifier)', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001062', 'B01062', 'Short ICAO location indicator', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('001063', 'B01063', 'ICAO location indicator', 'CCITT IA5', '0', '0', '64', 'Character', '0', '8', '', '', ''),
	('001064', 'B01064', 'Runway designator', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('001065', 'B01065', 'ICAO region identifier', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('001075', 'B01075', 'Tide station identification', 'CCITT IA5', '0', '0', '40', 'Character', '0', '5', '', '', ''),
	('001080', 'B01080', 'Ship line number according to SOOP', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('001081', 'B01081', 'Radiosonde serial number ', 'CCITT IA5', '0', '0', '160', 'Character', '0', '20', '', '', ''),
	('001082', 'B01082', 'Radiosonde ascension number (see Note 12)', 'Numeric', '0', '0', '14', 'Numeric', '0', '4', '', '', ''),
	('001083', 'B01083', 'Radiosonde release number (see Note 12)', 'Numeric', '0', '0', '3', 'Numeric', '0', '1', '', '', ''),
	('001085', 'B01085', 'Observing platform manufacturer\'s model', 'CCITT IA5', '0', '0', '160', 'Character', '0', '20', '', '', ''),
	('001086', 'B01086', 'Observing platform manufacturer\'s serial number', 'CCITT IA5', '0', '0', '256', 'Character', '0', '32', '', '', ''),
	('001087', 'B01087', 'WMO Marine observing platform extended identifier', 'Numeric', '0', '0', '23', 'Numeric', '0', '7', '', '', ''),
	('001090', 'B01090', 'Technique for making up initial perturbations', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001091', 'B01091', 'Ensemble member number ', 'Numeric', '0', '0', '10', 'Numeric', '0', '4', '', '', ''),
	('001092', 'B01092', 'Type of ensemble forecast', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('001093', 'B01093', 'Balloon lot number', 'CCITT IA5', '0', '0', '96', 'Character', '0', '12', '', '', ''),
	('001094', 'B01094', 'WBAN Number', 'Numeric', '0', '0', '17', 'Numeric', '0', '5', '', '', ''),
	('001095', 'B01095', 'Observer identification', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('001096', 'B01096', 'Station acquisition ', 'CCITT IA5', '0', '0', '160', 'Character', '0', '20', '', '', ''),
	('002001', 'B02001', 'Type of station', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002002', 'B02002', 'Type of instrumentation for wind measurement', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('002003', 'B02003', 'Type of measuring equipment used', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002004', 'B02004', 'Type of instrumentation for evaporation measurement or type of crop for which evapotranspiration is reported', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002005', 'B02005', 'Precision of temperature observation', 'K', '2', '0', '7', 'K', '2', '3', '', '', ''),
	('002011', 'B02011', 'Radiosonde type', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('002012', 'B02012', 'Radiosonde computational method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002013', 'B02013', 'Solar and infrared radiation correction', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002014', 'B02014', 'Tracking technique/status of system used', 'Code table', '0', '0', '7', 'Code table', '0', '3', '', '', ''),
	('002015', 'B02015', 'Radiosonde completeness', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002016', 'B02016', 'Radiosonde configuration', 'Flag table', '0', '0', '5', 'Flag table', '0', '2', '', '', ''),
	('002019', 'B02019', 'Satellite instruments', 'Code table', '0', '0', '11', 'Code table', '0', '4', '', '', ''),
	('002020', 'B02020', 'Satellite classification', 'Code table', '0', '0', '9', 'Code table', '0', '3', '', '', ''),
	('002021', 'B02021', 'Satellite instrument data used in processing*', 'Flag table', '0', '0', '9', 'Flag table', '0', '3', '', '', ''),
	('002022', 'B02022', 'Satellite data-processing technique used', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('002023', 'B02023', 'Satellite derived wind computation method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002024', 'B02024', 'Integrated mean humidity computational method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002025', 'B02025', 'Satellite channel(s) used in computation', 'Flag table', '0', '0', '25', 'Flag table', '0', '9', '', '', ''),
	('002026', 'B02026', 'Cross track resolution', 'm', '2', '0', '12', 'm', '2', '4', '', '', ''),
	('002027', 'B02027', 'Along track resolution', 'm', '2', '0', '12', 'm', '2', '4', '', '', ''),
	('002028', 'B02028', 'Segment size at nadir in X direction', 'm', '0', '0', '18', 'm', '0', '6', '', '', ''),
	('002029', 'B02029', 'Segment size at nadir in Y direction', 'm', '0', '0', '18', 'm', '0', '6', '', '', ''),
	('002030', 'B02030', 'Method of current measurement', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002031', 'B02031', 'Duration and time of current measurement', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002032', 'B02032', 'Indicator for digitization', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002033', 'B02033', 'Method of salinity/depth measurement', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002034', 'B02034', 'Drogue type', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002035', 'B02035', 'Cable length', 'm', '0', '0', '9', 'm', '0', '3', '', '', ''),
	('002036', 'B02036', 'Buoy type', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002037', 'B02037', 'Method of tidal observation', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002038', 'B02038', 'Method of water temperature and/or salinity measurement', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002039', 'B02039', 'Method of wet-bulb temperature measurement', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002040', 'B02040', 'Method of removing velocity and motion of platform from current', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002041', 'B02041', 'Method for estimating reports related to synoptic features', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002042', 'B02042', 'Indicator for sea surface current speed', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002044', 'B02044', 'Indicator for method of calculating spectral wave data', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002045', 'B02045', 'Indicator for type of platform', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002046', 'B02046', 'Wave measurement instrumentation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002048', 'B02048', 'Satellite sensor indicator', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002049', 'B02049', 'Geostationary satellite data-processing technique used', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('002050', 'B02050', 'Geostationary sounder satellite channels used', 'Flag table', '0', '0', '20', 'Flag table', '0', '7', '', '', ''),
	('002051', 'B02051', 'Indicator to specify observing method for extreme temperatures', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002052', 'B02052', 'Geostationary imager satellite channels used', 'Flag table', '0', '0', '6', 'Flag table', '0', '2', '', '', ''),
	('002053', 'B02053', 'GOES-I/M brightness temperature characteristics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002054', 'B02054', 'GOES-I/M soundings parameter characteristics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002055', 'B02055', 'Geostationary soundings statistical parameters', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002056', 'B02056', 'Geostationary soundings accuracy statistics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002057', 'B02057', 'Origin of first guess information for GOES-I/M soundings', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002058', 'B02058', 'Valid times of first guess information for GOES-I/M soundings', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002059', 'B02059', 'Origin of analysis information for GOES-I/M soundings', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002060', 'B02060', 'Origin of surface information for GOES-I/M soundings', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002061', 'B02061', 'Aircraft navigational system', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002062', 'B02062', 'Type of aircraft data relay system', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002063', 'B02063', 'Aircraft roll angle', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('002064', 'B02064', 'Aircraft roll angle quality', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('002065', 'B02065', 'ACARS ground receiving station', 'CCITT IA5', '0', '0', '40', 'Character', '0', '5', '', '', ''),
	('002066', 'B02066', 'Radiosonde ground receiving system', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002067', 'B02067', 'Radiosonde operating frequency', 'Hz', '-5', '0', '15', 'Hz', '-5', '5', '', '', ''),
	('002070', 'B02070', 'Original specification of latitude/longitude', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002080', 'B02080', 'Balloon manufacturer', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002081', 'B02081', 'Type of balloon', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002082', 'B02082', 'Weight of balloon', 'kg', '3', '0', '12', 'kg', '3', '4', '', '', ''),
	('002083', 'B02083', 'Type of balloon shelter', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002084', 'B02084', 'Type of gas used in balloon', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002085', 'B02085', 'Amount of gas used in balloon', 'kg', '3', '0', '13', 'kg', '3', '4', '', '', ''),
	('002086', 'B02086', 'Balloon flight train length', 'm', '1', '0', '10', 'm', '1', '4', '', '', ''),
	('002091', 'B02091', 'Entry sensor 4/20 mA', 'A', '4', '0', '10', 'A', '4', '3', '', '', ''),
	('002095', 'B02095', 'Type of pressure sensor', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002096', 'B02096', 'Type of temperature sensor', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002097', 'B02097', 'Type of humidity sensor', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002100', 'B02100', 'Radar constant*', 'dB', '1', '0', '12', 'dB', '1', '4', '', '', ''),
	('002101', 'B02101', 'Type of antenna', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002102', 'B02102', 'Antenna height above tower base', 'm', '0', '0', '8', 'm', '0', '3', '', '', ''),
	('002103', 'B02103', 'Radome', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('002104', 'B02104', 'Antenna polarisation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002105', 'B02105', 'Maximum antenna gain', 'dB', '0', '0', '6', 'dB', '0', '2', '', '', ''),
	('002106', 'B02106', '3-dB beamwidth', 'Degree', '1', '0', '6', 'Degree', '1', '2', '', '', ''),
	('002107', 'B02107', 'Sidelobe suppression', 'dB', '0', '0', '6', 'dB', '0', '2', '', '', ''),
	('002108', 'B02108', 'Crosspol discrimination (on axis)', 'dB', '0', '0', '6', 'dB', '0', '2', '', '', ''),
	('002109', 'B02109', 'Antenna speed (azimuth)', 'Degree s-1', '2', '0', '12', 'Degree s-1', '2', '4', '', '', ''),
	('002110', 'B02110', 'Antenna speed (elevation)', 'Degree s-1', '2', '0', '12', 'Degree s-1', '2', '4', '', '', ''),
	('002111', 'B02111', 'Radar incidence angle', 'Degree', '1', '0', '10', 'Degree', '1', '4', '', '', ''),
	('002112', 'B02112', 'Radar look angle', 'Degree', '1', '0', '12', 'Degree', '1', '4', '', '', ''),
	('002113', 'B02113', 'Number of azimuth looks', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('002114', 'B02114', 'Antenna effective surface area', 'm2', '0', '0', '15', 'm2', '0', '5', '', '', ''),
	('002115', 'B02115', 'Type of surface observing equipment', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002116', 'B02116', 'Percentage of 320 MHz band processed', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002117', 'B02117', 'Percentage of 80 MHz band processed', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002118', 'B02118', 'Percentage of 20 MHz band processed', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002119', 'B02119', 'RA-2 instrument operations', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002120', 'B02120', 'Ocean wave frequency', 'Hz', '3', '0', '10', 'Hz', '3', '4', '', '', ''),
	('002121', 'B02121', 'Mean frequency', 'Hz', '-8', '0', '7', 'Hz', '-8', '3', '', '', ''),
	('002122', 'B02122', 'Frequency agility range', 'Hz', '-6', '-128', '8', 'Hz', '-6', '3', '', '', ''),
	('002123', 'B02123', 'Peak power', 'W', '-4', '0', '7', 'W', '-4', '3', '', '', ''),
	('002124', 'B02124', 'Average power', 'W', '-1', '0', '7', 'W', '-1', '3', '', '', ''),
	('002125', 'B02125', 'Pulse repetition frequency', 'Hz', '-1', '0', '8', 'Hz', '-1', '3', '', '', ''),
	('002126', 'B02126', 'Pulse width', 's', '7', '0', '6', 's', '7', '2', '', '', ''),
	('002127', 'B02127', 'Receiver intermediate frequency', 'Hz', '-6', '0', '7', 'Hz', '-6', '3', '', '', ''),
	('002128', 'B02128', 'Intermediate frequency bandwidth', 'Hz', '-5', '0', '6', 'Hz', '-5', '2', '', '', ''),
	('002129', 'B02129', 'Minimum detectable signal', 'dB', '0', '-150', '5', 'dB', '0', '3', '', '', ''),
	('002130', 'B02130', 'Dynamic range', 'dB', '0', '0', '7', 'dB', '0', '3', '', '', ''),
	('002131', 'B02131', 'Sensitivity time control (STC)', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('002132', 'B02132', 'Azimuth pointing accuracy', 'Degree', '2', '0', '6', 'Degree', '2', '2', '', '', ''),
	('002133', 'B02133', 'Elevation pointing accuracy', 'Degree', '2', '0', '6', 'Degree', '2', '2', '', '', ''),
	('002134', 'B02134', 'Antenna beam azimuth', 'Degree', '2', '0', '16', 'Degree', '2', '5', '', '', ''),
	('002135', 'B02135', 'Antenna elevation', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('002136', 'B02136', 'Range processed by range attenuation correction', 'm', '-3', '0', '16', 'm', '-3', '5', '', '', ''),
	('002140', 'B02140', 'Satellite radar beam azimuth angle', 'Degree', '0', '0', '9', 'Degree', '0', '3', '', '', ''),
	('002141', 'B02141', 'Measurement type', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('002142', 'B02142', 'Ozone instrument serial number/ identification', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('002143', 'B02143', 'Ozone instrument type', 'Code table', '0', '0', '7', 'Code table', '0', '3', '', '', ''),
	('002144', 'B02144', 'Light source type for Brewer spectro photometer', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002145', 'B02145', 'Wave length setting for Dobson instruments', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002146', 'B02146', 'Source conditions for Dobson instruments', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002148', 'B02148', 'Data collection and/or location system', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('002149', 'B02149', 'Type of data buoy', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002150', 'B02150', 'TOVS/ATOVS/AVHRR instrumentation channel number', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('002151', 'B02151', 'Radiometer identifier', 'Code table', '0', '0', '11', 'Code table', '0', '4', '', '', ''),
	('002152', 'B02152', 'Satellite instrument used in data processing (see Note 6)', 'Flag table', '0', '0', '31', 'Flag table', '0', '10', '', '', ''),
	('002153', 'B02153', 'Satellite channel centre frequency', 'Hz', '-8', '0', '26', 'Hz', '-8', '8', '', '', ''),
	('002154', 'B02154', 'Satellite channel band width', 'Hz', '-8', '0', '26', 'Hz', '-8', '8', '', '', ''),
	('002156', 'B02156', 'Percentage of valid KU ocean retracker measurements', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002157', 'B02157', 'Percentage of valid S ocean retracker measurements', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('002158', 'B02158', 'RA-2 instrument', 'Flag table', '0', '0', '9', 'Flag table', '0', '3', '', '', ''),
	('002159', 'B02159', 'MWR instrument', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('002160', 'B02160', 'Wave length of the radar', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002163', 'B02163', 'Height assignment method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002164', 'B02164', 'Tracer correlation method', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('002166', 'B02166', 'Radiance type', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002167', 'B02167', 'Radiance computational method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002168', 'B02168', 'Hydrostatic pressure of lower end of cable (thermistor string)', 'Pa', '-3', '0', '16', 'kPa', '-3', '5', '', '', ''),
	('002169', 'B02169', 'Anemometer type', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002172', 'B02172', 'Product type for retrieved atmospheric gases', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('002173', 'B02173', 'Square of the off nadir angle (see Note 7)', 'Degree2', '4', '0', '10', 'Degree2', '4', '4', '', '', ''),
	('002174', 'B02174', 'Mean across track pixel number ', 'Numeric', '0', '0', '9', 'Numeric', '0', '3', '', '', ''),
	('002175', 'B02175', 'Method of precipitation measurement ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002176', 'B02176', 'Method of state of ground measurement ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002177', 'B02177', 'Method of snow depth measurement ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002178', 'B02178', 'Method of liquid content measurement of precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002179', 'B02179', 'Type of sky condition algorithm ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002180', 'B02180', 'Main present weather detecting system ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002181', 'B02181', 'Supplementary present weather sensor', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('002182', 'B02182', 'Visibility measurement system ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002183', 'B02183', 'Cloud detection system', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002184', 'B02184', 'Type of lightning detection sensor', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002185', 'B02185', 'Method of evaporation measurement', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('002186', 'B02186', 'Capability to detect precipitation phenomena', 'Flag table', '0', '0', '30', 'Flag table', '0', '10', '', '', ''),
	('002187', 'B02187', 'Capability to detect other weather phenomena', 'Flag table', '0', '0', '18', 'Flag table', '0', '6', '', '', ''),
	('002188', 'B02188', 'Capability to detect obscuration', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('002189', 'B02189', 'Capability to discriminate lightning strikes', 'Flag table', '0', '0', '12', 'Flag table', '0', '4', '', '', ''),
	('002190', 'B02190', 'Lagrangian drifter submergence (% time submerged)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('004001', 'B04001', 'Year', 'Year', '0', '0', '12', 'Year', '0', '4', '', '', ''),
	('004002', 'B04002', 'Month', 'Month', '0', '0', '4', 'Month', '0', '2', '', '', ''),
	('004003', 'B04003', 'Day', 'Day', '0', '0', '6', 'Day', '0', '2', '', '', ''),
	('004004', 'B04004', 'Hour', 'Hour', '0', '0', '5', 'Hour', '0', '2', '', '', ''),
	('004005', 'B04005', 'Minute', 'Minute', '0', '0', '6', 'Minute', '0', '2', '', '', ''),
	('004006', 'B04006', 'Second', 'Second', '0', '0', '6', 'Second', '0', '2', '', '', ''),
	('004007', 'B04007', 'Seconds within a minute (microsecond accuracy)', 'Second', '6', '0', '26', 'Second', '6', '8', '', '', ''),
	('004011', 'B04011', 'Time increment', 'Year', '0', '-1024', '11', 'Year', '0', '4', '', '', ''),
	('004012', 'B04012', 'Time increment', 'Month', '0', '-1024', '11', 'Month', '0', '4', '', '', ''),
	('004013', 'B04013', 'Time increment', 'Day', '0', '-1024', '11', 'Day', '0', '4', '', '', ''),
	('004014', 'B04014', 'Time increment', 'Hour', '0', '-1024', '11', 'Hour', '0', '4', '', '', ''),
	('004015', 'B04015', 'Time increment', 'Minute', '0', '-2048', '12', 'Minute', '0', '4', '', '', ''),
	('004016', 'B04016', 'Time increment', 'Second', '0', '-4096', '13', 'Second', '0', '4', '', '', ''),
	('004017', 'B04017', 'Reference time period for accumulated or extreme data', 'Minute', '0', '-1440', '12', 'Minute', '0', '4', '', '', ''),
	('004021', 'B04021', 'Time period or displacement', 'Year', '0', '-1024', '11', 'Year', '0', '4', '', '', ''),
	('004022', 'B04022', 'Time period or displacement', 'Month', '0', '-1024', '11', 'Month', '0', '4', '', '', ''),
	('004023', 'B04023', 'Time period or displacement', 'Day', '0', '-1024', '11', 'Day', '0', '4', '', '', ''),
	('004024', 'B04024', 'Time period or displacement', 'Hour', '0', '-2048', '12', 'Hour', '0', '4', '', '', ''),
	('004025', 'B04025', 'Time period or displacement', 'Minute', '0', '-2048', '12', 'Minute', '0', '4', '', '', ''),
	('004026', 'B04026', 'Time period or displacement', 'Second', '0', '-4096', '13', 'Second', '0', '4', '', '', ''),
	('004031', 'B04031', 'Duration of time relating to following value', 'Hour', '0', '0', '8', 'Hour', '0', '3', '', '', ''),
	('004032', 'B04032', 'Duration of time relating to following value', 'Minute', '0', '0', '6', 'Minute', '0', '2', '', '', ''),
	('004041', 'B04041', 'Time difference UTC –LMT (see Note 6)', 'Minute', '0', '-1440', '12', 'Minute', '0', '4', '', '', ''),
	('004043', 'B04043', 'Day of the year', 'Day', '0', '0', '9', 'Day', '0', '3', '', '', ''),
	('004051', 'B04051', 'Principal time of daily reading of maximum temperature', 'Hour', '0', '0', '5', 'Hour ', '0', '2', '', '', ''),
	('004052', 'B04052', 'Principal time of daily reading of minimum temperature', 'Hour', '0', '0', '5', 'Hour ', '0', '2', '', '', ''),
	('004053', 'B04053', 'Number of days with precipitation equal to or more than 1 mm', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('004059', 'B04059', 'Times of observation used to compute the reported mean values', 'Flag table', '0', '0', '6', 'Flag table', '0', '2', '', '', ''),
	('004065', 'B04065', 'Short time increment', 'Minute', '0', '-128', '8', 'Minute', '0', '2', '', '', ''),
	('004073', 'B04073', 'Short time period or displacement', 'Day', '0', '-128', '8', 'Day', '0', '2', '', '', ''),
	('004074', 'B04074', 'Short time period or displacement', 'Hour', '0', '-128', '8', 'Hour', '0', '2', '', '', ''),
	('004075', 'B04075', 'Short time period or displacement', 'Minute', '0', '-128', '8', 'Minute', '0', '2', '', '', ''),
	('004080', 'B04080', 'Averaging period for following value', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('004086', 'B04086', 'Long time period or displacement', 'Second', '0', '-8192', '15', 'Second', '0', '5', '', '', ''),
	('005001', 'B05001', 'Latitude (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('005002', 'B05002', 'Latitude (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('005011', 'B05011', 'Latitude increment (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('005012', 'B05012', 'Latitude increment (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('005015', 'B05015', 'Latitude displacement (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('005016', 'B05016', 'Latitude displacement (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('005021', 'B05021', 'Bearing or azimuth', 'Degree true', '2', '0', '16', 'Degree true', '2', '5', '', '', ''),
	('005022', 'B05022', 'Solar azimuth', 'Degree true', '2', '0', '16', 'Degree true', '2', '5', '', '', ''),
	('005023', 'B05023', 'Sun to satellite azimuth difference', 'Degree', '1', '-1800', '12', 'Degree', '1', '4', '', '', ''),
	('005030', 'B05030', 'Direction (spectral)', 'Degree', '0', '0', '12', 'Degree', '0', '4', '', '', ''),
	('005031', 'B05031', 'Row number', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('005033', 'B05033', 'Pixel size on horizontal – 1', 'm', '-1', '0', '16', 'm', '-1', '5', '', '', ''),
	('005034', 'B05034', 'Along track row number', 'Numeric', '0', '0', '11', 'Numeric', '0', '4', '', '', ''),
	('005036', 'B05036', 'Ship transect number according to SOOP', 'Numeric', '0', '0', '7', 'Numeric', '0', '2', '', '', ''),
	('005040', 'B05040', 'Orbit number', 'Numeric', '0', '0', '24', 'Numeric', '0', '8', '', '', ''),
	('005041', 'B05041', 'Scan line number', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('005042', 'B05042', 'Channel number', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('005043', 'B05043', 'Field of view number', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('005044', 'B05044', 'Satellite cycle number', 'Numeric', '0', '0', '11', 'Numeric', '0', '4', '', '', ''),
	('005052', 'B05052', 'Channel number increment', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('005053', 'B05053', 'Field of view number increment', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('005060', 'B05060', 'Y angular position from centre of gravity', 'Degree', '6', '-8000000', '24', 'Degree', '6', '8', '', '', ''),
	('005061', 'B05061', 'Z angular position from centre of gravity', 'Degree', '6', '-8000000', '24', 'Degree', '6', '8', '', '', ''),
	('006001', 'B06001', 'Longitude (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('006002', 'B06002', 'Longitude (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('006011', 'B06011', 'Longitude increment (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('006012', 'B06012', 'Longitude increment (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('006015', 'B06015', 'Longitude displacement (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('006016', 'B06016', 'Longitude displacement (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('006021', 'B06021', 'Distance', 'm', '-1', '0', '13', 'm', '-1', '4', '', '', ''),
	('006030', 'B06030', 'Wave number (spectral)', 'rad m-1', '5', '0', '13', 'rad m-1', '5', '4', '', '', ''),
	('006031', 'B06031', 'Column number', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('006033', 'B06033', 'Pixel size on horizontal – 2', 'm', '-1', '0', '16', 'm', '-1', '5', '', '', ''),
	('006034', 'B06034', 'Cross-track cell number', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('006040', 'B06040', 'Radius of confidence', 'm', '0', '0', '13', 'm', '0', '4', '', '', ''),
	('007001', 'B07001', 'Height of station (see Note 1)', 'm', '0', '-400', '15', 'm', '0', '5', '', '', ''),
	('007002', 'B07002', 'Height or altitude', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('007003', 'B07003', 'Geopotential', 'm2 s-2', '-1', '-400', '17', 'm2 s-2', '-1', '6', '', '', ''),
	('007004', 'B07004', 'Pressure', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('007005', 'B07005', 'Height increment', 'm', '0', '-400', '12', 'm', '0', '4', '', '', ''),
	('007006', 'B07006', 'Height above station', 'm', '0', '0', '15', 'm', '0', '5', '', '', ''),
	('007007', 'B07007', 'Height', 'm', '0', '-1000', '17', 'm', '0', '6', '', '', ''),
	('007008', 'B07008', 'Geopotential', 'm2 s-2', '0', '-10000', '20', 'm2 s-2', '0', '7', '', '', ''),
	('007009', 'B07009', 'Geopotential height', 'gpm', '0', '-1000', '17', 'gpm', '0', '5', '', '', ''),
	('007010', 'B07010', 'Flight level', 'm', '0', '-1024', '16', 'ft', '0', '5', '', '', ''),
	('007021', 'B07021', 'Elevation (see Note 2)', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('007022', 'B07022', 'Solar elevation', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('007024', 'B07024', 'Satellite zenith angle', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('007025', 'B07025', 'Solar zenith angle', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('007026', 'B07026', 'Satellite zenith angle', 'Degree', '4', '-900000', '21', 'Degree', '4', '7', '', '', ''),
	('007030', 'B07030', 'Height of station ground above mean sea level (see Note 3)', 'm', '1', '-4000', '17', 'm', '1', '5', '', '', ''),
	('007031', 'B07031', 'Height of barometer above mean sea level (see Note 4)', 'm', '1', '-4000', '17', 'm', '1', '5', '', '', ''),
	('007032', 'B07032', 'Height of sensor above local ground (or deck of marine platform) (see Note 5)', 'm', '2', '0', '16', 'm', '2', '5', '', '', ''),
	('007033', 'B07033', 'Height of sensor above water surface (see Note 6)', 'm', '1', '0', '12', 'm', '1', '4', '', '', ''),
	('007040', 'B07040', 'Impact parameter (see Note 8)', 'm', '1', '62000000', '22', 'm', '1', '8', '', '', ''),
	('007061', 'B07061', 'Depth below land surface', 'm', '2', '0', '14', 'm', '2', '5', '', '', ''),
	('007062', 'B07062', 'Depth below sea/water surface', 'm', '1', '0', '17', 'm', '1', '6', '', '', ''),
	('007063', 'B07063', 'Depth below sea/water surface (cm)', 'm', '2', '0', '20', 'm', '2', '7', '', '', ''),
	('007064', 'B07064', 'Representative height of sensor above station (see Note 7)', 'm', '0', '0', '4', 'm', '0', '2', '', '', ''),
	('007065', 'B07065', 'Water pressure', 'Pa', '-3', '0', '17', 'Pa', '-3', '6', '', '', ''),
	('007070', 'B07070', 'Drogue depth', 'm', '0', '0', '10', 'm', '0', '4', '', '', ''),
	('008001', 'B08001', 'Vertical sounding significance', 'Flag table', '0', '0', '7', 'Flag table', '0', '3', '', '', ''),
	('008002', 'B08002', 'Vertical significance (surface observations)', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008003', 'B08003', 'Vertical significance (satellite observations)', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008004', 'B08004', 'Phase of aircraft flight', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('008005', 'B08005', 'Meteorological attribute significance', 'Code table', '0', '0', '4', 'Code table ', '0', '2', '', '', ''),
	('008006', 'B08006', 'Ozone vertical sounding significance', 'Flag table', '0', '0', '9', 'Flag table ', '0', '3', '', '', ''),
	('008007', 'B08007', 'Dimensional significance', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008008', 'B08008', 'Radiation vertical sounding significance', 'Flag table', '0', '0', '9', 'Flag table ', '0', '3', '', '', ''),
	('008009', 'B08009', 'Detailed phase of flight', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008010', 'B08010', 'Surface qualifier (temperature data)', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('008011', 'B08011', 'Meteorological feature', 'Code table', '0', '0', '6', 'Code table ', '0', '2', '', '', ''),
	('008012', 'B08012', 'Land/sea qualifier', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('008013', 'B08013', 'Day/night qualifier', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008014', 'B08014', 'Qualifier for runway visual range', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008016', 'B08016', 'Change qualifier of a trend-type forecast or an aerodrome forecast', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008017', 'B08017', 'Qualifier of the time when the forecast change is expected', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008018', 'B08018', 'SEAWINDS land/ice surface type', 'Flag table', '0', '0', '17', 'Flag table', '0', '6', '', '', ''),
	('008019', 'B08019', 'Qualifier for following Centre identifier', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008020', 'B08020', 'Total number of missing entities (with respect to accumulation or average)', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('008021', 'B08021', 'Time significance', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('008022', 'B08022', 'Total number (with respect to accumulation or average)', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('008023', 'B08023', 'First order statistics', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008024', 'B08024', 'Difference statistics', 'Code table', '0', '0', '6', 'Code table ', '0', '2', '', '', ''),
	('008025', 'B08025', 'Time difference qualifier (see Note 5)', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008029', 'B08029', 'Remotely sensed surface type', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('008030', 'B08030', 'Manual on Codes (Volume I.1 Section C) Code table from which data are derived', 'Numeric', '0', '0', '13', 'Numeric', '0', '4', '', '', ''),
	('008031', 'B08031', 'Data category CREX table A', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('008033', 'B08033', 'Method of derivation of percentage confidence', 'Code table', '0', '0', '7', 'Code table', '0', '3', '', '', ''),
	('008035', 'B08035', 'Type of monitoring exercise', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008036', 'B08036', 'Type of centre or station performing monitoring', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008040', 'B08040', 'Flight Level significance', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008041', 'B08041', 'Data significance', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('008042', 'B08042', 'Extended vertical sounding significance', 'Flag table', '0', '0', '18', 'Flag table', '0', '6', '', '', ''),
	('008049', 'B08049', 'Number of observations', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('008050', 'B08050', 'Qualifier for number of missing values in calculation of statistic', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008051', 'B08051', 'Qualifier for number of missing values in calculation of statistic', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('008052', 'B08052', 'Condition for which number of days of occurrence follows', 'Code table', '0', '0', '5', 'Code table ', '0', '2', '', '', ''),
	('008053', 'B08053', 'Day of occurrence qualifier', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008060', 'B08060', 'Sample scanning mode significance', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008065', 'B08065', 'Sun-glint indicator', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008066', 'B08066', 'Semi-transparency indicator', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008070', 'B08070', 'TOVS/ATOVS product qualifier', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008072', 'B08072', 'Pixel(s) type', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008074', 'B08074', 'Altimeter echo type', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008075', 'B08075', 'Ascending/Descending Orbit Qualifier', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('008076', 'B08076', 'Type of band', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008079', 'B08079', 'Product status ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('008080', 'B08080', 'Qualifier for GTSPP quality flag', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008081', 'B08081', 'Type of equipment', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('008082', 'B08082', 'Modification of sensor height to another value', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('008083', 'B08083', 'Nominal value indicator', 'Flag table', '0', '0', '15', 'Flag table', '0', '5', '', '', ''),
	('008085', 'B08085', 'Beam identifier', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('010001', 'B10001', 'Height of land surface', 'm', '0', '-400', '15', 'm', '0', '5', '', '', ''),
	('010002', 'B10002', 'Height', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('010003', 'B10003', 'Geopotential', 'm2 s-2', '-1', '-400', '17', 'm2 s-2', '-1', '6', '', '', ''),
	('010004', 'B10004', 'Pressure', 'Pa', '-1', '0', '14', 'Pa', ' -1', '5', '', '', ''),
	('010007', 'B10007', 'Height', 'm', '0', '-1000', '17', 'm', '0', '6', '', '', ''),
	('010008', 'B10008', 'Geopotential', 'm2 s-2', '0', '-10000', '20', 'm2 s-2', '0', '7', '', '', ''),
	('010009', 'B10009', 'Geopotential height', 'gpm', '0', '-1000', '17', 'gpm', '0', '5', '', '', ''),
	('010010', 'B10010', 'Minimum pressure reduced to mean sea level', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('010011', 'B10011', 'Maximum pressure reduced to mean sea level', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('010031', 'B10031', 'In direction of the North Pole distance from the Earth’s centre (see Note 2)', 'm', '2', '-1073741824', '31', 'm', '2', '10', '', '', ''),
	('010032', 'B10032', 'Satellite distance to Earth’s centre', 'm', '1', '0', '27', 'm', '1', '9', '', '', ''),
	('010033', 'B10033', 'Altitude (platform to Ellipsoid)', 'm', '1', '0', '27', 'm', '1', '9', '', '', ''),
	('010034', 'B10034', 'Earth radius', 'm', '1', '0', '27', 'm', '1', '9', '', '', ''),
	('010035', 'B10035', 'Earth’s local radius of curvature ', 'm', '1', '62000000', '22', 'm', '1', '8', '', '', ''),
	('010036', 'B10036', 'Geoid undulation (see Note 4)', 'm', '2', '-15000', '15', 'm', '2', '6', '', '', ''),
	('010040', 'B10040', 'Number of retrieved layers', 'Numeric', '0', '0', '10', 'Numeric', '0', '4', '', '', ''),
	('010050', 'B10050', 'Standard deviation altitude', 'm', '2', '0', '16', 'm', '2', '5', '', '', ''),
	('010051', 'B10051', 'Pressure reduced to mean sea level', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('010052', 'B10052', 'Altimeter setting (QNH)', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('010060', 'B10060', 'Pressure change', 'Pa', '-1', '-1024', '11', 'Pa', '-1', '4', '', '', ''),
	('010061', 'B10061', '3-hour pressure change', 'Pa', '-1', '-500', '10', 'Pa', '-1', '4', '', '', ''),
	('010062', 'B10062', '24-hour pressure change', 'Pa', '-1', '-1000', '11', 'Pa', '-1', '4', '', '', ''),
	('010063', 'B10063', 'Characteristic of pressure tendency', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('010064', 'B10064', 'SIGMET cruising level ', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('010070', 'B10070', 'Indicated aircraft altitude', 'm', '0', '-400', '16', 'm', '0', '5', '', '', ''),
	('010080', 'B10080', 'Viewing Zenith angle', 'Degree', '2', '-9000', '15', 'Degree', '2', '5', '', '', ''),
	('010081', 'B10081', 'Altitude of COG above reference Ellipsoid', 'm', '3', '0', '31', 'm', '3', '10', '', '', ''),
	('010082', 'B10082', 'Instantaneous altitude rate', 'm s-1', '3', '-65536', '17', 'm s-1', '3', '6', '', '', ''),
	('010083', 'B10083', 'Squared off Nadir angle of the satellite from platform data', 'Degree2', '2', '0', '16', 'Degree2', '2', '5', '', '', ''),
	('010084', 'B10084', 'Squared off Nadir angle of the satellite from waveform data', 'Degree2', '2', '0', '16', 'Degree2', '2', '5', '', '', ''),
	('010085', 'B10085', 'Mean sea surface height', 'm', '3', '-131072', '18', 'm', '3', '6', '', '', ''),
	('010086', 'B10086', 'Geoid’s height', 'm', '3', '-131072', '18', 'm', '3', '6', '', '', ''),
	('010087', 'B10087', 'Ocean depth/land elevation', 'm', '1', '-131072', '18', 'm', '1', '6', '', '', ''),
	('010088', 'B10088', 'Total geocentric ocean tide height (solution 1)', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010089', 'B10089', 'Total geocentric ocean tide height (solution 2)', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010090', 'B10090', 'Long period  tide height ', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010091', 'B10091', 'Tidal loading height', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010092', 'B10092', 'Solid Earth tide height', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010093', 'B10093', 'Geocentric pole tide height ', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('010095', 'B10095', 'Height of atmosphere used', 'm', '0', '0', '16', 'm', '0', '5', '', '', ''),
	('011001', 'B11001', 'Wind direction', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011002', 'B11002', 'Wind speed', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011003', 'B11003', 'u-component', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('011004', 'B11004', 'v-component', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('011005', 'B11005', 'w-component', 'Pa s-1', '1', '-512', '10', 'Pa s-1', '1', '4', '', '', ''),
	('011006', 'B11006', 'w-component', 'm s-1', '2', '-4096', '13', 'm s-1', '2', '4', '', '', ''),
	('011010', 'B11010', 'Wind direction associated with wind speed which follows', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011011', 'B11011', 'Wind direction at 10 m', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011012', 'B11012', 'Wind speed at 10 m', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011013', 'B11013', 'Wind direction at 5 m', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011014', 'B11014', 'Wind speed at 5 m', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011016', 'B11016', 'Extreme counterclockwise wind direction of a variable wind', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011017', 'B11017', 'Extreme clockwise wind direction of a variable wind', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011019', 'B11019', 'Steadiness of wind (see Note 6)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('011021', 'B11021', 'Relative vorticity', 's-1', '9', '-65536', '17', 's-1', '9', '6', '', '', ''),
	('011022', 'B11022', 'Divergence', 's-1', '9', '-65536', '17', 's-1', '9', '6', '', '', ''),
	('011023', 'B11023', 'Velocity potential', 'm2 s-1', '-2', '-65536', '17', 'm2 s-1', '-2', '6', '', '', ''),
	('011030', 'B11030', 'Extended degree of turbulence', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('011031', 'B11031', 'Degree of turbulence', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('011032', 'B11032', 'Height of base of turbulence', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('011033', 'B11033', 'Height of top of turbulence', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('011034', 'B11034', 'Vertical gust velocity', 'm s-1', '1', '-1024', '11', 'm s-1', '1', '4', '', '', ''),
	('011035', 'B11035', 'Vertical gust acceleration', 'm s-2', '2', '-8192', '14', 'm s-2', '2', '5', '', '', ''),
	('011036', 'B11036', 'Maximum derived equivalent vertical gust speed', 'm s-1', '1', '0', '10', 'm s-1', '1', '4', '', '', ''),
	('011037', 'B11037', 'Turbulence Index', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('011038', 'B11038', 'Time of occurrence of Peak Eddy Dissipation Rate', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('011039', 'B11039', 'Extended time of occurrence of peak  Eddy Dissipation Rate', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('011040', 'B11040', 'Maximum wind speed (mean wind)', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011041', 'B11041', 'Maximum wind gust speed', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011042', 'B11042', 'Maximum wind speed (10-min mean wind)', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011043', 'B11043', 'Maximum wind gust direction', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011044', 'B11044', 'Mean wind direction for surface – 1500 m (5000 feet)', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011045', 'B11045', 'Mean wind speed for surface – 1500 m (5000 feet)', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011046', 'B11046', 'Maximum instantaneous wind speed', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011047', 'B11047', 'Maximum instantaneous wind speed over 10 minutes', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011049', 'B11049', 'Standard deviation of wind direction', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011050', 'B11050', 'Standard deviation of horizontal wind speed', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011051', 'B11051', 'Standard deviation of vertical wind speed', 'm s-1', '1', '0', '8', 'm s-1', '1', '3', '', '', ''),
	('011052', 'B11052', 'Formal uncertainty in wind speed', 'm s-1', '2', '0', '13', 'm s-1', '2', '5', '', '', ''),
	('011053', 'B11053', 'Formal uncertainty in wind direction', 'Degree true', '2', '0', '15', 'Degree true', '2', '5', '', '', ''),
	('011054', 'B11054', 'Mean wind direction for 1500 m – 3000 m ', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('011055', 'B11055', 'Mean wind speed for 1500 m  – 3000 m ', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011061', 'B11061', 'Absolute wind shear in 1 km layer below', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011062', 'B11062', 'Absolute wind shear in 1 km layer above', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('011070', 'B11070', 'Designator of the runway affected by wind shear (including ALL)', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('011071', 'B11071', 'Turbulent vertical momentum flux', 'm2 s-2', '3', '-128', '14', 'm2 s-2', '3', '5', '', '', ''),
	('011072', 'B11072', 'Turbulent vertical buoyancy flux', 'K m s-1', '3', '-128', '11', 'K m s-1', '3', '4', '', '', ''),
	('011073', 'B11073', 'Turbulent kinetic energy', 'm2 s-2', '2', '-1024', '13', 'm2 s-2', '2', '4', '', '', ''),
	('011074', 'B11074', 'Dissipation energy', 'm2 s-2', '2', '-1024', '10', 'm2 s-2', '2', '4', '', '', ''),
	('011075', 'B11075', 'Mean turbulence intensity (eddy dissipation rate)', 'm2/3 s-1', '2', '0', '8', 'm2/3 s-1', '2', '3', '', '', ''),
	('011076', 'B11076', 'Peak turbulence intensity (eddy dissipation rate)', 'm2/3 s-1', '2', '0', '8', 'm2/3 s-1', '2', '3', '', '', ''),
	('011077', 'B11077', 'Reporting interval or averaging time for Eddy Dissipation Rate', 's', '0', '0', '12', 's', '0', '4', '', '', ''),
	('011081', 'B11081', 'Model wind direction at 10m', 'Degree true', '2', '0', '16', 'Degree true', '2', '5', '', '', ''),
	('011082', 'B11082', 'Model wind speed at 10m', 'm s-1', '2', '0', '14', 'm s-1', '2', '4', '', '', ''),
	('011095', 'B11095', 'U component of the model wind vector', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('011096', 'B11096', 'V component of the model wind vector', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('012001', 'B12001', 'Temperature/dry-bulb temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012002', 'B12002', 'Wet-bulb temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012003', 'B12003', 'Dew-point temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012004', 'B12004', 'Dry-bulb temperature at 2 m', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012005', 'B12005', 'Wet-bulb temperature at 2 m', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012006', 'B12006', 'Dew-point temperature at 2 m', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012007', 'B12007', 'Virtual temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012011', 'B12011', 'Maximum temperature at height and over period specified', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012012', 'B12012', 'Minimum temperature at height and over period specified', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012013', 'B12013', 'Ground minimum temperature past 12 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012014', 'B12014', 'Maximum temperature at 2 m past 12 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012015', 'B12015', 'Minimum temperature at 2 m past 12 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012016', 'B12016', 'Maximum temperature at 2 m past 24 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012017', 'B12017', 'Minimum temperature at 2 m past 24 hours', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012021', 'B12021', 'Maximum temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012022', 'B12022', 'Minimum temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012030', 'B12030', 'Soil temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012049', 'B12049', 'Temperature change over specified period ', 'K', '0', '-30', '6', '°C', '0', '2', '', '', ''),
	('012051', 'B12051', 'Standard deviation temperature', 'K', '1', '0', '10', '°C', '1', '3', '', '', ''),
	('012052', 'B12052', 'Highest daily mean temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012053', 'B12053', 'Lowest daily mean temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012061', 'B12061', 'Skin temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012062', 'B12062', 'Equivalent black body temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012063', 'B12063', 'Brightness temperature', 'K', '1', '0', '12', '°C', '1', '3', '', '', ''),
	('012064', 'B12064', 'Instrument temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('012065', 'B12065', 'Standard deviation brightness temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('012070', 'B12070', 'Warm load temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012071', 'B12071', 'Coldest cluster temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('012072', 'B12072', 'Radiance', 'W m-2 sr-1', '6', '0', '31', 'W m-2 sr-1', '6', '9', '', '', ''),
	('012075', 'B12075', 'Spectral radiance', 'W m-3 sr-1', '-3', '0', '16', 'W m-3 sr-1', '-3', '5', '', '', ''),
	('012076', 'B12076', 'Radiance (see Note 2)', 'W m-2 sr-1', '3', '0', '16', 'W m-2 sr-1', '3', '5', '', '', ''),
	('012101', 'B12101', 'Temperature/dry-bulb temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012102', 'B12102', 'Wet-bulb temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012103', 'B12103', 'Dew-point temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012104', 'B12104', 'Dry-bulb temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012105', 'B12105', 'Web-bulb temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012106', 'B12106', 'Dew-point temperature at 2m', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012107', 'B12107', 'Virtual temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012111', 'B12111', 'Maximum temperature at height and over period specified', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012112', 'B12112', 'Minimum temperature at height and over period specified', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012113', 'B12113', 'Ground minimum temperature past 12 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012114', 'B12114', 'Maximum temperature at 2m past 12 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012115', 'B12115', 'Minimum temperature at 2m past 12 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012116', 'B12116', 'Maximum temperature at 2m past 24 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012117', 'B12117', 'Minimum temperature at 2m past 24 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012118', 'B12118', 'Maximum temperature at height specified past 24 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012119', 'B12119', 'Minimum  temperature at height specified past 24 hours', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012121', 'B12121', 'Ground minimum temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012122', 'B12122', 'Ground minimum temperature of the preceding night', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012130', 'B12130', 'Soil temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012151', 'B12151', 'Standard deviation of daily mean temperature', 'K', '2', '0', '12', '°C', '2', '4', '', '', ''),
	('012152', 'B12152', 'Highest daily mean temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012153', 'B12153', 'Lowest daily mean temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012161', 'B12161', 'Skin temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012162', 'B12162', 'Equivalent black body temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012163', 'B12163', 'Brightness temperature', 'K', '2', '0', '16', '°C', '2', '4', '', '', ''),
	('012164', 'B12164', 'Instrument temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012171', 'B12171', 'Coldest cluster temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012180', 'B12180', 'Averaged 12 micron BT for all clear pixels at Nadir', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012181', 'B12181', 'Averaged 11 micron BT for all clear pixels at Nadir', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012182', 'B12182', 'Averaged 3.7 micron BT for all clear pixels at Nadir', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012183', 'B12183', 'Averaged 12 micron BT for all clear pixels forward view', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012184', 'B12184', 'Averaged 11 micron BT for all clear pixels forward view', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012185', 'B12185', 'Averaged 3.7 micron BT for all clear pixels forward view', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012186', 'B12186', 'Mean Nadir sea surface temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012187', 'B12187', 'Mean dual view sea surface temperature', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012188', 'B12188', 'Interpolated 23.8 GHz brightness T from MWR', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('012189', 'B12189', 'Interpolated 36.5 GHz brightness T from MWR', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('013001', 'B13001', 'Specific humidity', 'kg kg-1', '5', '0', '14', 'kg kg-1', '5', '5', '', '', ''),
	('013002', 'B13002', 'Mixing ratio', 'kg kg-1', '5', '0', '14', 'kg kg-1', '5', '5', '', '', ''),
	('013003', 'B13003', 'Relative humidity', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('013004', 'B13004', 'Vapour pressure', 'Pa', '-1', '0', '10', 'Pa', '-1', '4', '', '', ''),
	('013005', 'B13005', 'Vapour density', 'kg m-3', '3', '0', '7', 'kg m-3', '3', '3', '', '', ''),
	('013006', 'B13006', 'Mixing heights', 'm', '-1', '-40', '16', 'm', '-1', '5', '', '', ''),
	('013007', 'B13007', 'Minimum relative humidity', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('013008', 'B13008', 'Maximum relative humidity', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('013009', 'B13009', 'Relative humidity (see Note 6)', '%', '1', '-1000', '12', '%', '1', '4', '', '', ''),
	('013011', 'B13011', 'Total precipitation/total water equivalent', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013012', 'B13012', 'Depth of fresh snow', 'm', '2', '-2', '12', 'm', '2', '4', '', '', ''),
	('013013', 'B13013', 'Total snow depth', 'm', '2', '-2', '16', 'm', '2', '5', '', '', ''),
	('013014', 'B13014', 'Rainfall/water equivalent of snow (averaged rate)', 'kg m-2 s-1', '4', '0', '12', 'kg m-2 s-1', '4', '4', '', '', ''),
	('013015', 'B13015', 'Snowfall  (averaged rate)', 'm s-1', '7', '0', '12', 'm s-1', '7', '4', '', '', ''),
	('013016', 'B13016', 'Precipitable water', 'kg m-2', '0', '0', '7', 'kg m-2', '0', '3', '', '', ''),
	('013019', 'B13019', 'Total precipitation past 1 hour', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '4', '', '', ''),
	('013020', 'B13020', 'Total precipitation past 3 hours', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013021', 'B13021', 'Total precipitation past 6 hours', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013022', 'B13022', 'Total precipitation past 12 hours', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013023', 'B13023', 'Total precipitation past 24 hours', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013031', 'B13031', 'Evapotranspiration', 'kg m-2', '0', '0', '7', 'kg m-2', '0', '3', '', '', ''),
	('013032', 'B13032', 'Evaporation/evapotranspiration (see Note 5)', 'kg m-2', '1', '0', '8', 'kg m-2', '1', '3', '', '', ''),
	('013033', 'B13033', 'Evaporation/evapotranspiration', 'kg m-2', '1', '0', '10', 'kg m-2', '1', '4', '', '', ''),
	('013038', 'B13038', 'Superadiabatic indicator', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('013039', 'B13039', 'Terrain type (ice/snow)', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('013040', 'B13040', 'Surface flag', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013041', 'B13041', 'Pasquill-Gifford stability category', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013042', 'B13042', 'Parcel lifted index (to 500 hPa) (see Notes 3 and 4)', 'K', '0', '-20', '6', 'K', '0', '2', '', '', ''),
	('013043', 'B13043', 'Best lifted index (to 500 hPa) (see Note 3 and 4)', 'K', '0', '-20', '6', 'K', '0', '2', '', '', ''),
	('013044', 'B13044', 'K index', 'K', '0', '-30', '8', 'K', '0', '3', '', '', ''),
	('013045', 'B13045', 'KO index', 'K', '0', '-30', '8', 'K', '0', '3', '', '', ''),
	('013046', 'B13046', 'Maximum buoyancy', 'K', '0', '-30', '8', 'K', '0', '3', '', '', ''),
	('013047', 'B13047', 'Modified Showalter stability index (see Note 7)', 'K', '0', '-60', '6', '°C', '0', '2', '', '', ''),
	('013051', 'B13051', 'Frequency group precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013052', 'B13052', 'Highest daily amount of precipitation', 'kg m-2', '1', '-1', '14', 'kg m-2', '1', '5', '', '', ''),
	('013055', 'B13055', 'Intensity of precipitation', 'kg m-2 s-1', '4', '0', '8', 'mm h-1 ', '4', '4', '', '', ''),
	('013056', 'B13056', 'Character and intensity of precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013057', 'B13057', 'Time of beginning or end of precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('013058', 'B13058', 'Size of precipitating element', 'm', '4', '0', '7', 'mm', '4', '3', '', '', ''),
	('013059', 'B13059', 'Number of flashes (thunderstorm)', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('013060', 'B13060', 'Total accumulated precipitation', 'kg m-2', '1', '-1', '17', 'kg m-2', '1', '5', '', '', ''),
	('013071', 'B13071', 'Upstream water level', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('013072', 'B13072', 'Downstream water level', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('013073', 'B13073', 'Maximum water level', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('013080', 'B13080', 'Water pH', 'pH unit', '1', '0', '10', 'pH unit', '1', '3', '', '', ''),
	('013081', 'B13081', 'Water conductivity', 'Siemens m-1', '3', '0', '14', 'Siemens m-1', '3', '4', '', '', ''),
	('013082', 'B13082', 'Water temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('013083', 'B13083', 'Dissolved oxygen', 'kg m-3', '6', '0', '15', 'kg m-3', '6', '5', '', '', ''),
	('013084', 'B13084', 'Turbidity', 'Lumen', '0', '0', '14', 'Lumen', '0', '4', '', '', ''),
	('013085', 'B13085', 'Oxydation Reduction Potential (ORP)', 'V', '3', '0', '14', 'V', '3', '4', '', '', ''),
	('013090', 'B13090', 'Radiometer water vapour content', 'kg m-2', '1', '0', '10', 'kg m-2', '1', '4', '', '', ''),
	('013091', 'B13091', 'Radiometer liquid content', 'kg m-2', '2', '0', '8', 'kg m-2', '2', '3', '', '', ''),
	('013093', 'B13093', 'Cloud optical thickness', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('013095', 'B13095', 'Total column water vapour', 'kg m-2', '4', '0', '19', 'kg m-2', '4', '6', '', '', ''),
	('013096', 'B13096', 'MWR water vapour content', 'kg m-2', '2', '0', '14', 'kg m-2', '2', '5', '', '', ''),
	('013097', 'B13097', 'MWR liquid water content', 'kg m-2', '2', '0', '14', 'kg m-2', '2', '5', '', '', ''),
	('013098', 'B13098', 'Integrated water vapour density', 'kg m-2', '8', '0', '30', 'kg m-2', '8', '10', '', '', ''),
	('014001', 'B14001', 'Long-wave radiation integrated over 24 hours', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014002', 'B14002', 'Long-wave radiation integrated over period specified', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014003', 'B14003', 'Short-wave radiation integrated over 24 hours', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014004', 'B14004', 'Short-wave radiation integrated over period specified', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014011', 'B14011', 'Net long-wave radiation integrated over 24 hours', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014012', 'B14012', 'Net long-wave radiation integrated over period specified', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014013', 'B14013', 'Net short-wave radiation integrated over 24 hours', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014014', 'B14014', 'Net short-wave radiation integrated over period specified', 'J m-2', '-3', '-2048', '12', 'J m-2', '-3', '4', '', '', ''),
	('014015', 'B14015', 'Net radiation integrated over 24 hours', 'J m-2', '-4', '-16384', '15', 'J m-2', '-4', '5', '', '', ''),
	('014016', 'B14016', 'Net radiation integrated over period specified', 'J m-2', '-4', '-16384', '15', 'J m-2', '-4', '5', '', '', ''),
	('014017', 'B14017', 'Instantaneous long-wave radiation ', 'W m-2', '-3', '-2048', '12', 'W m-2', '-3', '4', '', '', ''),
	('014018', 'B14018', 'Instantaneous short-wave radiation', 'W m-2', '-3', '-2048', '12', 'W m-2', '-3', '4', '', '', ''),
	('014019', 'B14019', 'Surface albedo', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('014020', 'B14020', 'Global solar radiation integrated over 24 hours', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014021', 'B14021', 'Global solar radiation integrated over period specified', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014022', 'B14022', 'Diffuse solar radiation integrated over 24 hours', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014023', 'B14023', 'Diffuse solar radiation integrated over period specified', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014024', 'B14024', 'Direct solar radiation integrated over 24 hours', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014025', 'B14025', 'Direct solar radiation integrated over period specified', 'J m-2', '-4', '0', '15', 'J m-2', '-4', '5', '', '', ''),
	('014026', 'B14026', 'Albedo at the top of clouds', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('014027', 'B14027', 'Albedo', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('014028', 'B14028', 'Global solar radiation (high accuracy) integrated over period specified', 'J m-2', '-2', '0', '16', 'J m-2', '-2', '5', '', '', ''),
	('014029', 'B14029', 'Diffuse solar radiation (high accuracy) integrated over period specified', 'J m-2', '-2', '0', '16', 'J m-2', '-2', '5', '', '', ''),
	('014030', 'B14030', 'Direct solar radiation (high accuracy) integrated over period specified', 'J m-2', '-2', '0', '16', 'J m-2', '-2', '5', '', '', ''),
	('014031', 'B14031', 'Total sunshine', 'Minute', '0', '0', '11', 'Minute', '0', '4', '', '', ''),
	('014032', 'B14032', 'Total sunshine', 'Hour', '0', '0', '10', 'Hour', '0', '4', '', '', ''),
	('014033', 'B14033', 'Total sunshine', '%', '0', '0', '9', '%', '0', '3', '', '', ''),
	('014034', 'B14034', 'Sunshine over period specified', 'Minute', '0', '0', '11', 'Minute', '0', '4', '', '', ''),
	('014042', 'B14042', 'Bi-directional reflectance', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('014045', 'B14045', 'Channel radiance (see Note 4)', 'W m-2 sr-1 cm-1', '0', '0', '11', 'W m-2 sr-1 cm-1', '0', '4', '', '', ''),
	('014046', 'B14046', 'Scaled IASI radiance (see Note 6)', 'W m-2 sr-1 m-1', '0', '-5000', '16', 'W m-2 sr-1 m-1', '0', '5', '', '', ''),
	('014047', 'B14047', 'Scaled mean AVHRR radiance', 'W m-2 sr-1 m-1', '0', '0', '31', 'W m-2 sr-1 m-1', '0', '10', '', '', ''),
	('014048', 'B14048', 'Scaled standard deviation AVHRR radiance', 'W m-2 sr-1 m-1', '0', '0', '31', 'W m-2 sr-1 m-1', '0', '10', '', '', ''),
	('014050', 'B14050', 'Emissivity (see Note 5)', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('014051', 'B14051', 'Direct solar radiation integrated over last hour', 'J m-2', '-3', '0', '14', 'J m-2', '-3', '4', '', '', ''),
	('014055', 'B14055', 'Solar activity index', 'Numeric', '0', '-32768', '16', 'Numeric', '0', '5', '', '', ''),
	('015001', 'B15001', 'Total ozone', 'DU', '0', '0', '10', 'DU', '0', '4', '', '', ''),
	('015002', 'B15002', 'Air mass (slant path at 22 km)', 'Numeric', '2', '0', '10', 'Numeric', '2', '3', '', '', ''),
	('015003', 'B15003', 'Measured ozone partial pressure (sounding) (see Note 1)', 'Pascal', '4', '0', '9', 'nbar', '4', '3', '', '', ''),
	('015004', 'B15004', 'Ozone sounding correction factor (see Note 2)', 'Numeric', '3', '0', '11', 'Numeric', '3', '4', '', '', ''),
	('015005', 'B15005', 'Ozone p (see Note 3)', 'DU', '0', '0', '10', 'DU', '0', '3', '', '', ''),
	('015011', 'B15011', 'Log 10 of integrated electron density', 'log (1/m2)', '3', '14000', '13', 'log (m-2)', '3', '4', '', '', ''),
	('015015', 'B15015', 'Maximum image spectral component before normalization', 'Numeric', '0', '0', '31', 'Numeric', '0', '10', '', '', ''),
	('015020', 'B15020', 'Integrated ozone density', 'kg m-2', '8', '0', '21', 'kg m-2', '8', '7', '', '', ''),
	('015025', 'B15025', 'Type of pollutant', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('015026', 'B15026', 'Concentration of pollutant (mol mol-1)', 'mol mol-1', '9', '0', '9', 'mol mol-1', '9', '3', '', '', ''),
	('015027', 'B15027', 'Concentration of pollutant (kg m-3)', 'kg m-3', '9', '0', '10', 'kg m-3', '9', '4', '', '', ''),
	('015031', 'B15031', 'Atmospheric path delay in satellite signal', 'm', '4', '10000', '15', 'm', '4', '5', '', '', ''),
	('015032', 'B15032', 'Estimated error in atmospheric path delay', 'm', '4', '0', '10', 'm', '4', '4', '', '', ''),
	('015033', 'B15033', 'Difference in path delays for limb views at extremes of scan', 'm', '5', '-10000', '15', 'm', '5', '5', '', '', ''),
	('015034', 'B15034', 'Estimated error in path delay difference', 'm', '5', '0', '14', 'm', '5', '5', '', '', ''),
	('015035', 'B15035', 'Component of zenith path delay due to water vapour', 'm', '4', '0', '14', 'm', '4', '5', '', '', ''),
	('015036', 'B15036', 'Atmospheric refractivity (see Note 5)', 'N-units', '3', '0', '19', 'N-units', '3', '6', '', '', ''),
	('015037', 'B15037', 'Bending angle', 'Radians', '8', '-100000', '23', 'Radians', '8', '7', '', '', ''),
	('019001', 'B19001', 'Type of synoptic feature', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('019002', 'B19002', 'Effective radius of feature', 'm', '-2', '0', '12', 'm', '-2', '4', '', '', ''),
	('019003', 'B19003', 'Wind speed threshold', 'm s-1', '0', '0', '8', 'm s-1', '0', '3', '', '', ''),
	('019004', 'B19004', 'Effective radius with respect to wind speeds above threshold', 'm', '-2', '0', '12', 'm', '-2', '4', '', '', ''),
	('019005', 'B19005', 'Direction of motion of feature', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('019006', 'B19006', 'Speed of motion of feature', 'm s-1', '2', '0', '14', 'm s-1', '2', '5', '', '', ''),
	('019007', 'B19007', 'Effective radius of feature', 'm', '-3', '0', '12', 'm', '-3', '4', '', '', ''),
	('019008', 'B19008', 'Vertical extent of circulation', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019009', 'B19009', 'Effective radius with respect to wind speeds above threshold (large storms)', 'm', '-3', '0', '12', 'm', '-3', '4', '', '', ''),
	('019010', 'B19010', 'Method for tracking the centre of synoptic feature', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019100', 'B19100', 'Time interval to calculate the movement of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019101', 'B19101', 'Accuracy of the position of the centre of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019102', 'B19102', 'Shape and definition of the eye of the tropical cyclone', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019103', 'B19103', 'Diameter of major axis of the eye of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019104', 'B19104', 'Change in character of the eye during the 30 minutes ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019105', 'B19105', 'Distance between the end of spiral band and the centre ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019106', 'B19106', 'Identification number of tropical cyclone', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('019107', 'B19107', 'Time interval over which the movement of the tropical cyclone has been calculated', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019108', 'B19108', 'Accuracy of geographical position of the tropical cyclone', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019109', 'B19109', 'Mean diameter of the overcast cloud of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019110', 'B19110', 'Apparent 24-hour change in intensity of the tropical cyclone', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019111', 'B19111', 'Current Intensity (CI) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019112', 'B19112', 'Data Tropical (DT) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019113', 'B19113', 'Cloud pattern type of the DT-number', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('019114', 'B19114', 'Model Expected Tropical (MET) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019115', 'B19115', 'Trend of the past 24-hour change (+: Developed -: Weakened)', 'Numeric', '1', '-30', '6', 'Numeric', '1', '2', '', '', ''),
	('019116', 'B19116', 'Pattern Tropical (PT) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019117', 'B19117', 'Cloud picture type of the PT-number', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019118', 'B19118', 'Final Tropical (T) number of the tropical cyclone', 'Numeric', '1', '0', '7', 'Numeric', '1', '3', '', '', ''),
	('019119', 'B19119', 'Type of the final T-number', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('019150', 'B19150', 'Typhoon International Common Number (Typhoon Committee)', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('020001', 'B20001', 'Horizontal visibility', 'm', '-1', '0', '13', 'm', '-1', '4', '', '', ''),
	('020002', 'B20002', 'Vertical visibility', 'm', '-1', '0', '7', 'm', '-1', '3', '', '', ''),
	('020003', 'B20003', 'Present weather (see Note 1)', 'Code table', '0', '0', '9', 'Code table', '0', '3', '', '', ''),
	('020004', 'B20004', 'Past weather (1) (see Note 2)', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020005', 'B20005', 'Past weather (2) (see Note 2)', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020008', 'B20008', 'Cloud distribution for aviation', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020009', 'B20009', 'General Weather Indicator (TAF/METAR)', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020010', 'B20010', 'Cloud cover (total) (see Note 5)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020011', 'B20011', 'Cloud amount', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020012', 'B20012', 'Cloud type', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('020013', 'B20013', 'Height of base of cloud', 'm', '-1', '-40', '11', 'm', '-1', '4', '', '', ''),
	('020014', 'B20014', 'Height of top of cloud', 'm', '-1', '-40', '11', 'm', '-1', '4', '', '', ''),
	('020015', 'B20015', 'Pressure at base of cloud', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('020016', 'B20016', 'Pressure at top of cloud', 'Pa', '-1', '0', '14', 'Pa', '-1', '5', '', '', ''),
	('020017', 'B20017', 'Cloud top description', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020018', 'B20018', 'Tendency of runway visual range', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('020019', 'B20019', 'Significant present or forecast weather', 'CCITT IA5', '0', '0', '72', 'Character', '0', '9', '', '', ''),
	('020020', 'B20020', 'Significant recent weather phenomena', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('020021', 'B20021', 'Type of precipitation', 'Flag table', '0', '0', '30', 'Flag table', '0', '10', '', '', ''),
	('020022', 'B20022', 'Character of precipitation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020023', 'B20023', 'Other weather phenomena', 'Flag table', '0', '0', '18', 'Flag table', '0', '6', '', '', ''),
	('020024', 'B20024', 'Intensity of phenomena', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('020025', 'B20025', 'Obscuration', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('020026', 'B20026', 'Character of obscuration', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020027', 'B20027', 'Phenomena occurrence', 'Flag table', '0', '0', '9', 'Flag table', '0', '3', '', '', ''),
	('020028', 'B20028', 'Expected change in intensity', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('020029', 'B20029', 'Rain flag', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('020031', 'B20031', 'Ice deposit (thickness)', 'm', '2', '0', '7', 'm', '2', '3', '', '', ''),
	('020032', 'B20032', 'Rate of ice accretion', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('020033', 'B20033', 'Cause of ice accretion', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('020034', 'B20034', 'Sea ice concentration', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020035', 'B20035', 'Amount and type of ice', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020036', 'B20036', 'Ice situation', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020037', 'B20037', 'Ice development', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020038', 'B20038', 'Bearing of ice edge (see Note 3)', 'Degree true', '0', '0', '12', 'Degree true', '0', '3', '', '', ''),
	('020040', 'B20040', 'Evolution of drift snow', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020041', 'B20041', 'Airframe icing', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020042', 'B20042', 'Airframe icing present', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('020043', 'B20043', 'Peak liquid water content', 'kg m-3', '4', '0', '7', 'kg m-3', '4', '2', '', '', ''),
	('020044', 'B20044', 'Average liquid water content', 'kg m-3', '4', '0', '7', 'kg m-3', '4', '2', '', '', ''),
	('020045', 'B20045', 'Supercooled large droplet (SLD) conditions', 'Code table', '0', '0', '2', 'Code table', '0', '2', '', '', ''),
	('020048', 'B20048', 'Evolution of feature', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020050', 'B20050', 'Cloud index', 'Code table', '0', '0', '8', 'Code table', '0', '3', '', '', ''),
	('020051', 'B20051', 'Amount of low clouds', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020052', 'B20052', 'Amount of middle clouds', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020053', 'B20053', 'Amount of high clouds', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020054', 'B20054', 'True direction from which a phenomenon or clouds are moving', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('020055', 'B20055', 'State of sky in the tropics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020056', 'B20056', 'Cloud phase', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('020061', 'B20061', 'Runway visual range (RVR)', 'm', '0', '0', '12', 'm', '0', '4', '', '', ''),
	('020062', 'B20062', 'State of the ground (with or without snow)', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('020063', 'B20063', 'Special phenomena', 'Code table', '0', '0', '10', 'Code table', '0', '4', '', '', ''),
	('020065', 'B20065', 'Snow cover (see Note 4)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020066', 'B20066', 'Maximum diameter of hailstones', 'm', '3', '0', '8', 'm', '3', '3', '', '', ''),
	('020067', 'B20067', 'Diameter of deposit', 'm', '3', '0', '9', 'm', '3', '3', '', '', ''),
	('020070', 'B20070', 'Minimum number of atmospherics', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('020071', 'B20071', 'Accuracy of fix and rate of atmospherics', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020081', 'B20081', 'Cloud amount in segment', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020082', 'B20082', 'Amount segment cloud free', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020083', 'B20083', 'Amount of segment covered by scene', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('020090', 'B20090', 'Special clouds', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020095', 'B20095', 'Ice probability', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('020096', 'B20096', 'Ice age ("A" parameter)', 'dB', '2', '-4096', '13', 'dB', '2', '4', '', '', ''),
	('020101', 'B20101', 'Locust (acridian) name', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020102', 'B20102', 'Locust (maturity) color', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020103', 'B20103', 'Stage of development of locusts', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020104', 'B20104', 'Organization state of swarm or band of locusts', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020105', 'B20105', 'Size of swarm or band of locusts and duration of passage of swarm', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020106', 'B20106', 'Locust population density', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020107', 'B20107', 'Direction of movements of locust swarm', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('020108', 'B20108', 'Extent of vegetation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('021001', 'B21001', 'Horizontal reflectivity', 'dB', '0', '-64', '7', 'dB', '0', '3', '', '', ''),
	('021002', 'B21002', 'Vertical reflectivity', 'dB', '0', '-64', '7', 'dB', '0', '3', '', '', ''),
	('021003', 'B21003', 'Differential reflectivity', 'dB', '1', '-5', '7', 'dB', '1', '3', '', '', ''),
	('021005', 'B21005', 'Linear depolarisation ratio ', 'dB', '0', '-65', '6', 'dB', '0', '2', '', '', ''),
	('021006', 'B21006', 'Circular depolarisation ratio ', 'dB', '0', '-65', '6', 'dB', '0', '2', '', '', ''),
	('021011', 'B21011', 'Doppler mean velocity in X-direction', 'm s-1', '0', '-128', '8', 'm s-1', '0', '3', '', '', ''),
	('021012', 'B21012', 'Doppler mean velocity in Y-direction', 'm s-1', '0', '-128', '8', 'm s-1', '0', '3', '', '', ''),
	('021013', 'B21013', 'Doppler mean velocity in Z-direction', 'm s-1', '0', '-128', '8', 'm s-1', '0', '3', '', '', ''),
	('021014', 'B21014', 'Doppler mean velocity (radial)', 'm s-1', '1', '-4096', '13', 'm s-1', '1', '4', '', '', ''),
	('021017', 'B21017', 'Doppler velocity spectral width', 'm s-1', '1', '0', '8', 'm s-1', '1', '3', '', '', ''),
	('021021', 'B21021', 'Echo tops ', 'm', '-3', '0', '4', 'm', '-3', '2', '', '', ''),
	('021030', 'B21030', 'Signal to noise ratio', 'dB', '0', '-32', '8', 'dB', '0', '3', '', '', ''),
	('021031', 'B21031', 'Vertically integrated liquid-water content', 'kg m-2', '0', '0', '7', 'kg m-2', '0', '3', '', '', ''),
	('021036', 'B21036', 'Radar rainfall intensity ', 'm s-1', '7', '0', '12', 'm s-1', '7', '4', '', '', ''),
	('021041', 'B21041', 'Bright-band height ', 'm', '-2', '0', '8', 'm', '-2', '3', '', '', ''),
	('021051', 'B21051', 'Signal power above 1 mW', 'dB', '0', '-256', '8', 'dB', '0', '3', '', '', ''),
	('021062', 'B21062', 'Backscatter', 'dB', '2', '-5000', '13', 'dB', '2', '4', '', '', ''),
	('021063', 'B21063', 'Radiometric resolution (noise value)', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('021064', 'B21064', 'Clutter noise estimate', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('021065', 'B21065', 'Missing packet counter', 'Numeric', '0', '-127', '8', 'Numeric', '0', '3', '', '', ''),
	('021066', 'B21066', 'Wave scatterometer product confidence data', 'Flag table', '0', '0', '12', 'Flag table', '0', '4', '', '', ''),
	('021067', 'B21067', 'Wind product confidence data', 'Flag table', '0', '0', '13', 'Flag table', '0', '5', '', '', ''),
	('021068', 'B21068', 'Radar altimeter product confidence data', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('021069', 'B21069', 'SST product confidence data', 'Flag table', '0', '0', '10', 'Flag table', '0', '4', '', '', ''),
	('021070', 'B21070', 'SST product confidence data (SADIST-2)', 'Flag table', '0', '0', '23', 'Flag table', '0', '6', '', '', ''),
	('021071', 'B21071', 'Peakiness', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('021072', 'B21072', 'Satellite altimeter calibration status', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('021073', 'B21073', 'Satelllite altimeter instrument mode', 'Flag table', '0', '0', '9', 'Flag table', '0', '3', '', '', ''),
	('021075', 'B21075', 'Image spectrum intensity', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('021076', 'B21076', 'Representation of intensities', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('021077', 'B21077', 'Altitude correction (ionosphere)', 'm', '3', '0', '14', 'm', '3', '5', '', '', ''),
	('021078', 'B21078', 'Altitude correction (dry troposphere)', 'm', '3', '0', '9', 'm', '3', '3', '', '', ''),
	('021079', 'B21079', 'Altitude correction (wet troposphere)', 'm', '3', '2000', '10', 'm', '3', '4', '', '', ''),
	('021080', 'B21080', 'Altitude correction (calibration constant)', 'm', '3', '0', '11', 'm', '3', '4', '', '', ''),
	('021081', 'B21081', 'Open loop correction (height-time loop)', 'm', '3', '0', '10', 'm', '3', '4', '', '', ''),
	('021082', 'B21082', 'Open loop correction (auto gain control)', 'dB', '3', '-3000', '14', 'dB', '3', '5', '', '', ''),
	('021083', 'B21083', 'Warm target calibration', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('021084', 'B21084', 'Cold target calibration', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('021085', 'B21085', 'ATSR sea surface temperature across- track band number', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('021086', 'B21086', 'Number of pixels in Nadir only average', 'Numeric', '0', '0', '9', 'Numeric', '0', '3', '', '', ''),
	('021087', 'B21087', 'Number of pixels in dual view average', 'Numeric', '0', '0', '9', 'Numeric', '0', '3', '', '', ''),
	('021088', 'B21088', 'Wet backscatter', 'dB', '2', '-5000', '13', 'dB', '2', '4', '', '', ''),
	('021091', 'B21091', 'Radar signal Doppler spectrum 0th moment', 'dB', '0', '-100', '8', 'dB', '0', '3', '', '', ''),
	('021092', 'B21092', 'RASS signal Doppler spectrum 0th moment referring to RASS signal', 'dB', '0', '-100', '8', 'dB', '0', '3', '', '', ''),
	('021093', 'B21093', 'Ku band peakiness', 'Numeric', '3', '0', '16', 'Numeric', '3', '5', '', '', ''),
	('021094', 'B21094', 'S band peakiness', 'Numeric', '3', '0', '16', 'Numeric', '3', '5', '', '', ''),
	('021101', 'B21101', 'Number of vector ambiguities', 'Numeric', '0', '0', '3', 'Numeric', '0', '1', '', '', ''),
	('021102', 'B21102', 'Index of selected wind vector', 'Numeric', '0', '0', '3', 'Numeric', '0', '1', '', '', ''),
	('021103', 'B21103', 'Total number of sigma-0 measurements', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('021104', 'B21104', 'Likelihood computed for solution', 'Numeric', '3', '-30000', '15', 'Numeric', '3', '5', '', '', ''),
	('021105', 'B21105', 'Normalized radar cross-section', 'dB', '2', '-10000', '14', 'dB', '2', '5', '', '', ''),
	('021106', 'B21106', 'Kp variance coefficient (Alpha)', 'Numeric', '3', '0', '14', 'Numeric', '3', '5', '', '', ''),
	('021107', 'B21107', 'Kp variance coefficient (Beta)', 'Numeric', '8', '0', '16', 'Numeric', '8', '5', '', '', ''),
	('021109', 'B21109', 'SEAWINDS wind vector cell quality', 'Flag table', '0', '0', '17', 'Flag table', '0', '6', '', '', ''),
	('021110', 'B21110', 'Number of inner-beam Sigma-0 (forward of satellite)', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('021111', 'B21111', 'Number of outer-beam Sigma-0 (forward of satellite)', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('021112', 'B21112', 'Number of inner-beam Sigma-0 (aft of satellite)', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('021113', 'B21113', 'Number of outer-beam Sigma-0 (aft of satellite)', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('021114', 'B21114', 'Kp variance coefficent (Gamma)', 'dB', '3', '-140000', '18', 'dB', '3', '6', '', '', ''),
	('021115', 'B21115', 'SEAWINDS sigma-0 quality', 'Flag table', '0', '0', '17', 'Flag table', '0', '6', '', '', ''),
	('021116', 'B21116', 'SEAWINDS sigma-0 mode', 'Flag table', '0', '0', '17', 'Flag table', '0', '6', '', '', ''),
	('021117', 'B21117', 'Sigma-0 variance quality control', 'Numeric', '2', '0', '16', 'Numeric', '2', '5', '', '', ''),
	('021118', 'B21118', 'Attenuation correction on sigma-0', 'dB', '2', '-10000', '14', 'dB', '2', '5', '', '', ''),
	('021119', 'B21119', 'Wind scatterometer geophysical model function', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('021120', 'B21120', 'Probability of rain', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021121', 'B21121', 'SEAWINDS NOF* rain index', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('021122', 'B21122', 'Attenuation correction of sigma-0 (from tB)', 'dB', '2', '-10000', '14', 'dB', '2', '5', '', '', ''),
	('021123', 'B21123', 'SEAWINDS normalized radar cross section', 'dB', '2', '-30000', '15', 'dB', '2', '5', '', '', ''),
	('021128', 'B21128', 'Number of valid points per second used to derive previous parameters', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('021130', 'B21130', 'Spectrum total energy', 'Numeric', '6', '0', '28', 'Numeric', '6', '9', '', '', ''),
	('021131', 'B21131', 'Spectrum max energy', 'Numeric', '6', '0', '28', 'Numeric', '6', '9', '', '', ''),
	('021132', 'B21132', 'Direction of spectrum max on higher resolution grid', 'Degree', '3', '0', '19', 'Degree', '3', '6', '', '', ''),
	('021133', 'B21133', 'Wave-length of spectrum max on higher resolution grid', 'm', '3', '0', '29', 'm', '3', '9', '', '', ''),
	('021134', 'B21134', 'Range resolution of cress covariance spectrum', 'Rad m-1', '3', '0', '19', 'Rad m-1', '3', '6', '', '', ''),
	('021135', 'B21135', 'Real part of cross spectra polar grid number of bins', 'Numeric', '3', '-524288', '20', 'Numeric', '3', '7', '', '', ''),
	('021136', 'B21136', 'Imaginary part of cross spectra polar grid number of bins', 'Numeric', '3', '-524288', '20', 'Numeric', '3', '7', '', '', ''),
	('021137', 'B21137', 'KU band corrected ocean backscatter coefficient', 'dB', '2', '-32768', '16', 'dB', '2', '5', '', '', ''),
	('021138', 'B21138', 'Std KU band corrected ocean backscatter coefficient', 'dB', '2', '-32768', '16', 'dB', '2', '5', '', '', ''),
	('021139', 'B21139', 'KU band net instrumental correction for ACG', 'dB', '2', '-2048', '12', 'dB', '2', '4', '', '', ''),
	('021140', 'B21140', 'S band corrected ocean backscatter coefficient', 'dB', '2', '-32768', '16', 'dB', '2', '5', '', '', ''),
	('021141', 'B21141', 'Std S band corrected ocean backscatter coefficient', 'dB', '2', '-32768', '16', 'dB', '2', '5', '', '', ''),
	('021142', 'B21142', 'S band net instrumental correction for ACG', 'dB', '2', '-1024', '11', 'dB', '2', '4', '', '', ''),
	('021143', 'B21143', 'KU band rain attenuation', 'dB', '2', '-1073741824', '31', 'dB', '2', '10', '', '', ''),
	('021144', 'B21144', 'Altimeter rain flag', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('021150', 'B21150', 'Beam collocation', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('021151', 'B21151', 'Estimated error in sigma-0 at 40 deg. incidence angle', 'dB', '2', '0', '9', 'dB', '2', '3', '', '', ''),
	('021152', 'B21152', 'Slope at 40 deg. incidence angle', 'dB Deg-1', '2', '-80', '7', 'dB Deg-1', '2', '2', '', '', ''),
	('021153', 'B21153', 'Estimated error in slope at 40 deg. incidence angle', 'dB Deg-1', '2', '-40', '6', 'dB Deg-1', '2', '2', '', '', ''),
	('021154', 'B21154', 'Soil moisture sensitivity', 'dB', '2', '0', '12', 'dB', '2', '4', '', '', ''),
	('021155', 'B21155', 'Wind vector cell quality', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('021156', 'B21156', 'Backscatter distance', 'Numeric', '1', '-4096', '13', 'Numeric', '1', '4', '', '', ''),
	('021157', 'B21157', 'Loss per unit length of atmosphere used', 'dB m-1', '10', '0', '22', 'dB m-1', '10', '7', '', '', ''),
	('021158', 'B21158', 'ASCAT kp estimate quality', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('021159', 'B21159', 'ASCAT sigma-0 usability', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('021160', 'B21160', 'ASCAT use of synthetic data', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021161', 'B21161', 'ASCAT synthetic data quality', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021162', 'B21162', 'ASCAT satellite orbit and attitude quality', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021163', 'B21163', 'ASCAT solar array reflection contamination', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021164', 'B21164', 'ASCAT telemetry presence and quality', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021165', 'B21165', 'ASCAT extrapolated reference function presence', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('021166', 'B21166', 'ASCAT land fraction', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('022001', 'B22001', 'Direction of waves ', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022002', 'B22002', 'Direction of wind waves ', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022003', 'B22003', 'Direction of swell waves ', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022004', 'B22004', 'Direction of current (see Note 7)', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022005', 'B22005', 'Direction of sea surface current', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022011', 'B22011', 'Period of waves ', 's', '0', '0', '6', 's', '0', '2', '', '', ''),
	('022012', 'B22012', 'Period of wind waves ', 's', '0', '0', '6', 's', '0', '2', '', '', ''),
	('022013', 'B22013', 'Period of swell waves ', 's', '0', '0', '6', 's', '0', '2', '', '', ''),
	('022021', 'B22021', 'Height of waves ', 'm', '1', '0', '10', 'm', '1', '4', '', '', ''),
	('022022', 'B22022', 'Height of wind waves ', 'm', '1', '0', '10', 'm', '1', '4', '', '', ''),
	('022023', 'B22023', 'Height of swell waves ', 'm', '1', '0', '10', 'm', '1', '4', '', '', ''),
	('022025', 'B22025', 'Standard deviation wave height', 'm', '2', '0', '10', 'm', '2', '4', '', '', ''),
	('022026', 'B22026', 'Standard deviation of significant wave height', 'm', '2', '0', '10', 'm', '2', '4', '', '', ''),
	('022031', 'B22031', 'Speed of current ', 'm s-1', '2', '0', '13', 'm s-1', '2', '4', '', '', ''),
	('022032', 'B22032', 'Speed of sea surface current', 'm s-1', '2', '0', '13', 'm s-1', '2', '4', '', '', ''),
	('022035', 'B22035', 'Tidal elevation with respect to local chart datum', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('022036', 'B22036', 'Meteorological residual tidal elevation (surge or offset)', 'm', '2', '0', '14', 'm', '2', '4', '', '', ''),
	('022037', 'B22037', 'Tidal elevation with respect to national land datum', 'm', '3', '-10000', '15', 'm', '3', '5', '', '', ''),
	('022038', 'B22038', 'Tidal elevation with respect to local chart datum', 'm', '3', '-10000', '15', 'm', '3', '5', '', '', ''),
	('022039', 'B22039', 'Meteorological residual tidal elevation (surge or offset) (see Note 4)', 'm', '3', '-5000', '13', 'm', '3', '4', '', '', ''),
	('022040', 'B22040', 'Meteorological residual tidal elevation (surge or offset) (see Note 4)', 'm', '3', '-5000', '14', 'm', '3', '5', '', '', ''),
	('022041', 'B22041', 'Sea-surface temperature (15-day running mean)', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('022042', 'B22042', 'Sea/water temperature', 'K', '1', '0', '12', 'K', '1', '4', '', '', ''),
	('022043', 'B22043', 'Sea/water temperature', 'K', '2', '0', '15', 'K', '2', '5', '', '', ''),
	('022044', 'B22044', 'Sound velocity ', 'm s-1', '1', '0', '14', 'm s-1', '1', '5', '', '', ''),
	('022045', 'B22045', 'Sea/water temperature', 'K', '3', '0', '19', 'K', '3', '6', '', '', ''),
	('022049', 'B22049', 'Sea surface temperature', 'K', '2', '0', '15', 'K', '2', '5', '', '', ''),
	('022050', 'B22050', 'Standard deviation sea-surface temperature', 'K', '2', '0', '8', 'K', '2', '3', '', '', ''),
	('022055', 'B22055', 'Float cycle number', 'Numeric', '0', '0', '10', 'Numeric', '0', '3', '', '', ''),
	('022056', 'B22056', 'Direction of profile', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('022059', 'B22059', 'Sea surface salinity', 'Part per thousand', '2', '0', '14', 'Part per thousand', '2', '5', '', '', ''),
	('022060', 'B22060', 'Lagrangian drifter drogue status', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('022061', 'B22061', 'State of the sea ', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('022062', 'B22062', 'Salinity', 'Part per thousand', '2', '0', '14', 'Part per thousand', '2', '5', '', '', ''),
	('022063', 'B22063', 'Total water depth ', 'm', '0', '0', '14', 'm', '0', '5', '', '', ''),
	('022064', 'B22064', 'Salinity', 'Part per thousand', '3', '0', '17', 'Part per thousand', '3', '6', '', '', ''),
	('022065', 'B22065', 'Water pressure', 'Pa', '-3', '0', '17', 'Pa', '-3', '6', '', '', ''),
	('022066', 'B22066', 'Water conductivity', 'S m-1', '6', '0', '26', 'S m-1', '6', '8', '', '', ''),
	('022067', 'B22067', 'Instrument type for water temperature profile measurement', 'Code table', '0', '0', '10', 'Code table', '0', '4', '', '', ''),
	('022068', 'B22068', 'Water temperature profile recorder types', 'Code table', '0', '0', '7', 'Code table', '0', '3', '', '', ''),
	('022069', 'B22069', 'Spectral wave density', 'm2 Hz-1', '3', '0', '22', 'm2 Hz-1', '3', '7', '', '', ''),
	('022070', 'B22070', 'Significant wave height', 'm', '2', '0', '13', 'm', '2', '4', '', '', ''),
	('022071', 'B22071', 'Spectral peak wave period', 's', '1', '0', '9', 's', '1', '3', '', '', ''),
	('022072', 'B22072', 'Spectral peak wave length', 'm', '0', '0', '13', 'm', '0', '4', '', '', ''),
	('022073', 'B22073', 'Maximum wave height', 'm', '2', '0', '13', 'm', '2', '4', '', '', ''),
	('022074', 'B22074', 'Average wave period', 's', '1', '0', '9', 's', '1', '3', '', '', ''),
	('022075', 'B22075', 'Average wave length', 'm', '0', '0', '13', 'm', '0', '4', '', '', ''),
	('022076', 'B22076', 'Direction from which dominant waves are coming', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022077', 'B22077', 'Directional spread of dominant wave', 'Degree', '0', '0', '9', 'Degree', '0', '3', '', '', ''),
	('022078', 'B22078', 'Duration of wave record', 's', '0', '0', '12', 's', '0', '4', '', '', ''),
	('022079', 'B22079', 'Length of wave record', 'm', '0', '0', '16', 'm', '0', '5', '', '', ''),
	('022080', 'B22080', 'Waveband central frequency', 'Hz', '3', '0', '10', 'Hz', '3', '4', '', '', ''),
	('022081', 'B22081', 'Waveband central wave number', 'm-1', '5', '0', '13', 'm-1', '5', '4', '', '', ''),
	('022082', 'B22082', 'Maximum non-directional spectral wave density', 'm2 s', '2', '0', '20', 'm2 s', '2', '7', '', '', ''),
	('022083', 'B22083', 'Maximum non-directional spectral wave number', 'm3', '2', '0', '20', 'm3', '2', '7', '', '', ''),
	('022084', 'B22084', 'Band containing maximum non- directional spectral wave density', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('022085', 'B22085', 'Spectral wave density ratio', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('022086', 'B22086', 'Mean direction from which waves are coming', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022087', 'B22087', 'Principal direction from which waves are coming', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022088', 'B22088', 'First normalized polar coordinate from Fourier coefficients', 'Numeric', '2', '0', '7', 'Numeric', '2', '3', '', '', ''),
	('022089', 'B22089', 'Second normalized polar coordinate from Fourier coefficients', 'Numeric', '2', '0', '7', 'Numeric', '2', '3', '', '', ''),
	('022090', 'B22090', 'Non-directional spectral estimate by wave frequency', 'm2 s', '2', '0', '20', 'm2 s', '2', '7', '', '', ''),
	('022091', 'B22091', 'Non-directional spectral estimate by wave number', 'm3', '2', '0', '20', 'm3', '2', '7', '', '', ''),
	('022092', 'B22092', 'Directional spectral estimate by wave frequency', 'm2 rad-1 s', '2', '0', '20', 'm2 rad-1 s', '2', '7', '', '', ''),
	('022093', 'B22093', 'Directional spectral estimate by wave number', 'm4', '2', '0', '20', 'm4', '2', '7', '', '', ''),
	('022094', 'B22094', 'Total number of wave bands', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('022095', 'B22095', 'Directional spread of individual waves', 'Degree', '0', '0', '8', 'Degree', '0', '3', '', '', ''),
	('022096', 'B22096', 'Spectral band width', 's-1', '3', '0', '4', 's-1', '3', '2', '', '', ''),
	('022097', 'B22097', 'Mean wavelength > 731 m of image spectrum at low wave numbers', 'm', '0', '0', '14', 'm', '0', '5', '', '', ''),
	('022098', 'B22098', 'Wavelength spread (wavelength > 731 m) at low wave numbers', 'm', '0', '0', '14', 'm', '0', '5', '', '', ''),
	('022099', 'B22099', 'Mean direction at low wave numbers (wavelength > 731 m)', 'Degree true', '0', '0', '9', 'Degree true', '0', '3', '', '', ''),
	('022100', 'B22100', 'Direction spread at low wave numbers (wavelength > 731 m)', 'Degree', '0', '0', '9', 'Degree', '0', '3', '', '', ''),
	('022101', 'B22101', 'Total energy (wavelength > 731m) at low wave numbers', 'Numeric', '0', '0', '31', 'Numeric', '0', '10', '', '', ''),
	('022120', 'B22120', 'Tide station automated water level check', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('022121', 'B22121', 'Tide station manual water level check', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('022122', 'B22122', 'Tide station automated meteorological data check', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('022123', 'B22123', 'Tide station manual meteorological data check', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('022141', 'B22141', 'Sea-surface temperature (15-day running mean)', 'K', '2', '0', '15', 'K', '2', '5', '', '', ''),
	('022150', 'B22150', 'Number of 18 Hz valid points for KU band', 'Numeric', '0', '0', '10', 'Numeric', '0', '4', '', '', ''),
	('022151', 'B22151', 'KU band ocean range', 'm', '3', '0', '31', 'm', '3', '10', '', '', ''),
	('022152', 'B22152', 'STD of 18 Hz KU band ocean range', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022153', 'B22153', 'Number of 18 Hz valid points for S band', 'Numeric', '0', '0', '10', 'Numeric', '0', '4', '', '', ''),
	('022154', 'B22154', 'S band ocean range', 'm', '3', '0', '31', 'm', '3', '10', '', '', ''),
	('022155', 'B22155', 'STD of 18 Hz S band ocean range', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022156', 'B22156', 'KU band significant wave height', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022157', 'B22157', 'STD 18Hz KU band significant wave height', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022158', 'B22158', 'S band significant wave height', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022159', 'B22159', 'STD 18Hz S band significant wave height', 'm', '3', '0', '16', 'm', '3', '5', '', '', ''),
	('022160', 'B22160', 'Normalized inverse wave age', 'Numeric', '6', '0', '21', 'Numeric', '6', '7', '', '', ''),
	('022161', 'B22161', 'Wave spectra', 'm4', '4', '0', '27', 'm4', '4', '9', '', '', ''),
	('023001', 'B23001', 'Accident early notification — article applicable', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023002', 'B23002', 'Activity or facility involved in incident', 'Code table', '0', '0', '5', 'Code table ', '0', '2', '', '', ''),
	('023003', 'B23003', 'Type of release ', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023004', 'B23004', 'Countermeasures taken near border', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023005', 'B23005', 'Cause of incident ', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023006', 'B23006', 'Incident situation ', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023007', 'B23007', 'Characteristics of release', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023008', 'B23008', 'State of current release ', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023009', 'B23009', 'State of expected release ', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023016', 'B23016', 'Possibility of significant chemical toxic health effect', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023017', 'B23017', 'Flow discharge of major recipient', 'm3 s-1', '6', '0', '20', 'm3 s-1', '6', '7', '', '', ''),
	('023018', 'B23018', 'Release behaviour over time', 'Code table', '0', '0', '3', 'Code table ', '0', '1', '', '', ''),
	('023019', 'B23019', 'Actual release height', 'm', '0', '-15000', '17', 'm ', '0', '6', '', '', ''),
	('023021', 'B23021', 'Effective release height', 'm', '0', '-15000', '17', 'm ', '0', '6', '', '', ''),
	('023022', 'B23022', 'Distance of release point or site of incident', 'm', '0', '0', '24', 'm ', '0', '8', '', '', ''),
	('023023', 'B23023', 'Main transport speed in the atmosphere', 'm s-1', '1', '0', '12', 'm s-1', '1', '4', '', '', ''),
	('023024', 'B23024', 'Main transport speed in water', 'm s-1', '2', '0', '13', 'm s-1', '2', '4', '', '', ''),
	('023025', 'B23025', 'Main transport speed in ground water', 'm s-1', '2', '0', '13', 'm s-1', '2', '4', '', '', ''),
	('023027', 'B23027', 'Main transport direction in the atmosphere', 'Degree true ', '0', '0', '9', 'Degree true ', '0', '3', '', '', ''),
	('023028', 'B23028', 'Main transport direction in water', 'Degree true ', '0', '0', '9', 'Degree true ', '0', '3', '', '', ''),
	('023029', 'B23029', 'Main transport direction in ground water', 'Degree true ', '0', '0', '9', 'Degree true ', '0', '3', '', '', ''),
	('023031', 'B23031', 'Possibility that plume will encounter precipitation in State in which incident occurred', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('023032', 'B23032', 'Plume will encounter change in wind direction and/or speed flag', 'Code table', '0', '0', '2', 'Code table ', '0', '1', '', '', ''),
	('024001', 'B24001', 'Estimate of amount of radioactivity released up to specified time', 'Bq*', '-11', '0', '28', 'Bq* ', '-11', '9', '', '', ''),
	('024002', 'B24002', 'Estimated maximum potential release', 'Bq', '-11', '0', '28', 'Bq ', '-11', '9', '', '', ''),
	('024003', 'B24003', 'Composition of release', 'Code table', '0', '0', '5', 'Code table ', '0', '2', '', '', ''),
	('024004', 'B24004', 'Element name', 'CCITT IA5', '0', '0', '16', 'Character', '0', '2', '', '', ''),
	('024005', 'B24005', 'Isotope mass', 'Numeric', '0', '0', '9', 'Numeric ', '0', '3', '', '', ''),
	('024011', 'B24011', 'Dose', 'mSv*/**', '2', '0', '32', 'mSv*/**', '2', '10', '', '', ''),
	('024012', 'B24012', 'Trajectory dose (defined location and expected time of arrival)', 'mSv', '2', '0', '32', 'mSv', '2', '10', '', '', ''),
	('024013', 'B24013', 'Gamma dose in air along the main transport path (defined location and time period)', 'mSv', '2', '0', '32', 'mSv ', '2', '10', '', '', ''),
	('024021', 'B24021', 'Air concentration (of named isotope type including gross beta)', 'Bq m-3', '2', '0', '32', 'Bq m-3', '2', '10', '', '', ''),
	('024022', 'B24022', 'Concentration in precipitation (of names isotope type)', 'Bq l-1', '2', '0', '32', 'Bq l-1', '2', '10', '', '', ''),
	('024023', 'B24023', 'Pulse rate of beta radiation', 's-1', '1', '0', '14', 's-1', '1', '4', '', '', ''),
	('024024', 'B24024', 'Pulse rate of gamma radiation', 's-1', '1', '0', '14', 's-1', '1', '4', '', '', ''),
	('025001', 'B25001', 'Range-gate length', 'm', '-1', '0', '6', 'm', '-1', '2', '', '', ''),
	('025002', 'B25002', 'Number of gates averaged', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('025003', 'B25003', 'Number of integrated pulses', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025004', 'B25004', 'Echo processing', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025005', 'B25005', 'Echo integration', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025006', 'B25006', 'Z to R conversion', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('025007', 'B25007', 'Z to R conversion factor', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('025008', 'B25008', 'Z to R conversion exponent', 'Numeric', '2', '0', '9', 'Numeric', '2', '3', '', '', ''),
	('025009', 'B25009', 'Calibration method (see Note 3)', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('025010', 'B25010', 'Clutter treatment', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('025011', 'B25011', 'Ground occultation correction (screening)', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025012', 'B25012', 'Range attenuation correction', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025013', 'B25013', 'Bright-band correction', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('025014', 'B25014', 'Azimuth clutter cut-off (see Note 1)', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('025015', 'B25015', 'Radome attenuation correction', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('025016', 'B25016', 'Clear-air attenuation correction', 'dB m-1', '5', '0', '6', 'dB m-1', '5', '2', '', '', ''),
	('025017', 'B25017', 'Precipitation attenuation correction', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('025018', 'B25018', 'A to Z law for attenuation factor', 'Numeric', '7', '0', '6', 'Numeric', '7', '2', '', '', ''),
	('025019', 'B25019', 'A to Z law for attenuation exponent', 'Numeric', '2', '0', '7', 'Numeric', '2', '3', '', '', ''),
	('025020', 'B25020', 'Mean speed estimation', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025021', 'B25021', 'Wind computation enhancement', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('025025', 'B25025', 'Battery voltage', 'V', '1', '0', '9', 'V', '1', '3', '', '', ''),
	('025026', 'B25026', 'Battery voltage (large range)', 'V', '1', '0', '12', 'V', '1', '4', '', '', ''),
	('025028', 'B25028', 'Operator or manufacturer defined parameter', 'Numeric', '1', '-16384', '15', 'Numeric', '1', '5', '', '', ''),
	('025029', 'B25029', 'Calibration method', 'Flag table', '0', '0', '6', 'Flag table', '0', '2', '', '', ''),
	('025030', 'B25030', 'Running mean sea-surface temperature usage', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025032', 'B25032', 'Wind profiler mode information (see Note 2)', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025033', 'B25033', 'Wind profiler submode information (see Note 2)', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025034', 'B25034', 'Wind profiler quality control test results (see Note 2)', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('025036', 'B25036', 'Atmospherics location method', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('025040', 'B25040', 'CO2 wind product derivation', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('025041', 'B25041', 'Moving platform direction reporting method', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025042', 'B25042', 'Moving platform speed reporting method', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025043', 'B25043', 'Wave sampling interval (time)', 's', '4', '0', '15', 's', '4', '5', '', '', ''),
	('025044', 'B25044', 'Wave sampling interval (space)', 'm', '2', '0', '14', 'm', '2', '5', '', '', ''),
	('025045', 'B25045', 'HIRS channel combination', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('025046', 'B25046', 'MSU channel combination', 'Flag table', '0', '0', '5', 'Flag table', '0', '2', '', '', ''),
	('025047', 'B25047', 'SSU channel combination', 'Flag table', '0', '0', '4', 'Flag table', '0', '2', '', '', ''),
	('025048', 'B25048', 'AMSU-A channel combination', 'Flag table', '0', '0', '16', 'Flag table', '0', '6', '', '', ''),
	('025049', 'B25049', 'AMSU-B channel combination', 'Flag table', '0', '0', '6', 'Flag table', '0', '2', '', '', ''),
	('025050', 'B25050', 'Principal component score', 'Numeric', '4', '-131072', '18', 'Numeric', '4', '6', '', '', ''),
	('025051', 'B25051', 'AVHRR channel combination', 'Flag table', '0', '0', '7', 'Flag table', '0', '3', '', '', ''),
	('025052', 'B25052', 'Log-10 of principal components normalized fit to data', 'Numeric', '4', '0', '15', 'Numeric', '4', '5', '', '', ''),
	('025053', 'B25053', 'Observation quality', 'Flag table', '0', '0', '12', 'Flag table', '0', '4', '', '', ''),
	('025054', 'B25054', 'SSMIS Subframe ID nember', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('025055', 'B25055', 'Multiplexer housekeeping', 'K', '2', '0', '16', 'K', '2', '5', '', '', ''),
	('025060', 'B25060', 'Software identification (see Note 2)', 'Numeric', '0', '0', '14', 'Numeric', '0', '5', '', '', ''),
	('025061', 'B25061', 'Software identification and version number', 'CCITT IA5', '0', '0', '96', 'Character', '0', '12', '', '', ''),
	('025062', 'B25062', 'Database identification', 'Numeric', '0', '0', '14', 'Numeric', '0', '5', '', '', ''),
	('025065', 'B25065', 'Orientation correction (azimuth)', 'Degree', '2', '-1000', '11', 'Degree', '2', '4', '', '', ''),
	('025066', 'B25066', 'Orientation correction (elevation)', 'Degree', '2', '-1000', '11', 'Degree', '2', '4', '', '', ''),
	('025067', 'B25067', 'Radiosonde release point pressure correction', 'Pa', '0', '-8000', '14', 'Pa', '0', '4', '', '', ''),
	('025068', 'B25068', 'Number of archive recomputes', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('025069', 'B25069', 'Flight level pressure corrections', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('025070', 'B25070', 'Major frame count', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('025071', 'B25071', 'Frame count', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('025075', 'B25075', 'Satellite antenna corrections version number', 'Numeric', '0', '0', '5', 'Numeric', '0', '2', '', '', ''),
	('025076', 'B25076', 'Log–10 of (Temperature-radiance central wavenumber) for ATOVS', 'log m-1', '8', '0', '30', 'log m-1', '8', '10', '', '', ''),
	('025077', 'B25077', 'Bandwidth correction coefficient 1 for ATOVS', 'Numeric', '5', '-100000', '18', 'Numeric', '5', '7', '', '', ''),
	('025078', 'B25078', 'Bandwidth correction coefficient 2 for ATOVS', 'Numeric', '5', '0', '17', 'Numeric', '5', '6', '', '', ''),
	('025079', 'B25079', 'Albedo-radiance solar filtered irradiance for ATOVS', 'W m-2', '4', '0', '24', 'W m-2', '4', '8', '', '', ''),
	('025080', 'B25080', 'Albedo-radiance equivalent filter width for ATOVS', 'm', '10', '0', '14', 'm', '10', '5', '', '', ''),
	('025085', 'B25085', 'Fraction of clear pixels in HIRS FOV', 'Numeric', '0', '0', '7', 'Numeric', '0', '3', '', '', ''),
	('025086', 'B25086', 'Depth correction indicator', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025091', 'B25091', 'Structure constant of the refraction index (Cn2)', 'dB', '3', '-18192', '13', 'dB', '3', '5', '', '', ''),
	('025092', 'B25092', 'Acoustic propagation velocity', 'm s-1', '2', '28000', '14', 'm s-1', '2', '5', '', '', ''),
	('025093', 'B25093', 'RASS computation correction', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('025095', 'B25095', 'Altimeter state flag', 'Flag table', '0', '0', '2', 'Flag table', '0', '1', '', '', ''),
	('025096', 'B25096', 'Radiometer state flag', 'Flag table', '0', '0', '5', 'Flag table', '0', '2', '', '', ''),
	('025097', 'B25097', 'Three dimensional error estimate of the navigator orbit', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('025100', 'B25100', 'XBT/XCTD fall rate equation coefficient a', 'Numeric', '5', '0', '20', 'Numeric', '5', '6', '', '', ''),
	('025101', 'B25101', 'XBT/XCTD fall rate equation coefficient b', 'Numeric', '5', '-500000', '21', 'Numeric', '5', '6', '', '', ''),
	('025102', 'B25102', 'Number of missing lines excluding data gaps', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025103', 'B25103', 'Number of directional bins', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025104', 'B25104', 'Number of wave-length bins', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025105', 'B25105', 'First directional bin', 'Degree', '3', '0', '19', 'Degree', '3', '6', '', '', ''),
	('025106', 'B25106', 'Directional bin step', 'Degree', '3', '0', '19', 'Degree', '3', '6', '', '', ''),
	('025107', 'B25107', 'First wave-length bin', 'm', '3', '0', '29', 'm', '3', '9', '', '', ''),
	('025108', 'B25108', 'Last wave-length bin', 'm', '3', '0', '29', 'm', '3', '9', '', '', ''),
	('025110', 'B25110', 'Image processing summary', 'Flag table', '0', '0', '10', 'Flag table', '0', '4', '', '', ''),
	('025111', 'B25111', 'Number of input data gaps', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('025120', 'B25120', 'RA2-L2-processing flag', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025121', 'B25121', 'RA2-L2-processing quality', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('025122', 'B25122', 'Hardware configuration for RF', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025123', 'B25123', 'Hardware configuration for HPA', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025124', 'B25124', 'MWR L2 Processing flag', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('025125', 'B25125', 'MWR L2-processing quality', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('025126', 'B25126', 'Model dry tropospheric correction', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025127', 'B25127', 'Inverted barometer correction', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025128', 'B25128', 'Model wet tropospheric correction', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025129', 'B25129', 'MWR derived wet tropospheric correction', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025130', 'B25130', 'RA2 ionospheric correction on KU band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025131', 'B25131', 'Ionospheric correction from Doris on KU band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025132', 'B25132', 'Ionospheric correction from model on KU band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025133', 'B25133', 'Sea state bias correction on KU band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025134', 'B25134', 'RA2 ionospheric correction on S band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025135', 'B25135', 'Ionospheric correction from Doris on S band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025136', 'B25136', 'Ionospheric correction from model on S band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025137', 'B25137', 'Sea state bias correction on S band', 'm', '3', '-32768', '16', 'm', '3', '5', '', '', ''),
	('025138', 'B25138', 'Average signal to noise ration', 'Numeric', '0', '-2048', '12', 'Numeric', '0', '4', '', '', ''),
	('025140', 'B25140', 'Start channel', 'Numeric', '0', '0', '14', 'Numeric', '0', '5', '', '', ''),
	('025141', 'B25141', 'End channel', 'Numeric', '0', '0', '14', 'Numeric', '0', '5', '', '', ''),
	('025142', 'B25142', 'Channel scale factor', 'Numeric', '0', '0', '6', 'Numeric', '0', '2', '', '', ''),
	('025150', 'B25150', 'Method of tropical cyclone intensity analysis using satellite data', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('026001', 'B26001', 'Principal time of daily reading in UTC of maximum temperature', 'Hour', '1', '0', '12', 'Hour', '1', '3', '', '', ''),
	('026002', 'B26002', 'Principal time of daily reading in UTC of minimum temperature', 'Hour', '1', '0', '12', 'Hour', '1', '3', '', '', ''),
	('026003', 'B26003', 'Time difference', 'Minute', '0', '-1440', '12', 'Minute', '0', '4', '', '', ''),
	('026010', 'B26010', 'Hours included', 'Flag table', '0', '0', '26', 'Flag table', '0', '9', '', '', ''),
	('027001', 'B27001', 'Latitude (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('027002', 'B27002', 'Latitude (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('027003', 'B27003', 'Alternate latitude (coarse accuracy)', 'Degree', '2', '-9000', '15', 'Degree', '2', '4', '', '', ''),
	('027004', 'B27004', 'Alternate latitude (high accuracy)', 'Degree', '5', '-9000000', '25', 'Degree', '5', '7', '', '', ''),
	('027020', 'B27020', 'Satellite location counter', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('027021', 'B27021', 'Satellite sublocation dimension', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('027031', 'B27031', 'In direction of 0 degrees longitude distance from the Earth’s centre', 'm', '2', '-1073741824', '31', 'm', '2', '10', '', '', ''),
	('027080', 'B27080', 'Viewing Azimuth angle', 'Degree true', '2', '0', '16', 'Degree true', '2', '5', '', '', ''),
	('028001', 'B28001', 'Longitude (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('028002', 'B28002', 'Longitude (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('028003', 'B28003', 'Alternate longitude (coarse accuracy)', 'Degree', '2', '-18000', '16', 'Degree', '2', '5', '', '', ''),
	('028004', 'B28004', 'Alternate longitude (high accuracy)', 'Degree', '5', '-18000000', '26', 'Degree', '5', '8', '', '', ''),
	('028031', 'B28031', 'In direction 90 degrees East distance from the Earth’s centre', 'm', '2', '-1073741824', '31', 'm', '2', '10', '', '', ''),
	('029001', 'B29001', 'Projection type', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('029002', 'B29002', 'Co-ordinate grid type', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('030001', 'B30001', 'Pixel value (4 bits)', 'Numeric', '0', '0', '4', 'Numeric', '0', '2', '', '', ''),
	('030002', 'B30002', 'Pixel value (8 bits)', 'Numeric', '0', '0', '8', 'Numeric', '0', '3', '', '', ''),
	('030004', 'B30004', 'Pixel value (16 bits)', 'Numeric', '0', '0', '16', 'Numeric', '0', '5', '', '', ''),
	('030021', 'B30021', 'Number of pixels per row', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('030022', 'B30022', 'Number of pixels per column', 'Numeric', '0', '0', '12', 'Numeric', '0', '4', '', '', ''),
	('030031', 'B30031', 'Picture type', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('030032', 'B30032', 'Combination with other data', 'Flag table', '0', '0', '16', 'Flag table', '0', '6', '', '', ''),
	('031000', 'B31000', 'Short delayed descriptor replication factor', 'Numeric', '0', '0', '1', 'Numeric', '0', '4', '', '', ''),
	('031001', 'B31001', 'Delayed descriptor replication factor', 'Numeric', '0', '0', '8', 'Numeric', '0', '4', '', '', ''),
	('031002', 'B31002', 'Extended delayed descriptor replication factor', 'Numeric', '0', '0', '16', 'Numeric', '0', '4', '', '', ''),
	('031011', 'B31011', 'Delayed descriptor and data repetition factor', 'Numeric', '0', '0', '8', 'Numeric', '0', '4', '', '', ''),
	('031012', 'B31012', 'Extended delayed descriptor and data repetition factor', 'Numeric', '0', '0', '16', 'Numeric', '0', '4', '', '', ''),
	('031021', 'B31021', 'Associated field significance', 'Code table', '0', '0', '6', 'Code table', '', '', '', '', ''),
	('031031', 'B31031', 'Data present indicator', 'Flag table', '0', '0', '1', 'Flag table', '', '', '', '', ''),
	('033001', 'B33001', 'Reserved', '', '', '', '', '', '', '', '', '', ''),
	('033002', 'B33002', 'Quality information', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033003', 'B33003', 'Quality information', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033004', 'B33004', 'Reserved', '', '', '', '', '', '', '', '', '', ''),
	('033005', 'B33005', 'Quality information (AWS data)', 'Flag table', '0', '0', '30', 'Flag table', '0', '10', '', '', ''),
	('033006', 'B33006', 'Internal measurement status information (AWS)', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033007', 'B33007', 'Per cent confidence', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033015', 'B33015', 'Data quality check indicator', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('033020', 'B33020', 'Quality control indication of following value', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033021', 'B33021', 'Quality of following value', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033022', 'B33022', 'Quality of buoy satellite transmission', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033023', 'B33023', 'Quality of buoy location', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033024', 'B33024', 'Station elevation quality mark (for mobile stations)', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('033025', 'B33025', 'ACARS interpolated values', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033026', 'B33026', 'Moisture quality', 'Code table', '0', '0', '6', 'Code table', '0', '2', '', '', ''),
	('033027', 'B33027', 'Location quality class (range of radius of 66 % confidence)', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033030', 'B33030', 'Scan line status flags for ATOVS', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('033031', 'B33031', 'Scan line quality flags for ATOVS', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('033032', 'B33032', 'Channel quality flags for ATOVS', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('033033', 'B33033', 'Field of view quality flags for ATOVS', 'Flag table', '0', '0', '24', 'Flag table', '0', '8', '', '', ''),
	('033035', 'B33035', 'Manual/automatic quality control', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('033036', 'B33036', 'Nominal confidence threshold', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033037', 'B33037', 'Wind correlation error', 'Flag table', '0', '0', '20', 'Flag table', '0', '7', '', '', ''),
	('033038', 'B33038', 'Quality flags for ground-based GNSS data', 'Flag table', '0', '0', '10', 'Flag table', '0', '4', '', '', ''),
	('033039', 'B33039', 'Quality flags for Radio Occultation data', 'Flag table', '0', '0', '16', 'Flag table', '0', '6', '', '', ''),
	('033040', 'B33040', 'Confidence interval', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033041', 'B33041', 'Attribute of following value', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033042', 'B33042', 'Type of limit represented by following value', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('033043', 'B33043', 'AST confidence', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('033044', 'B33044', 'ASAR quality information', 'Flag table', '0', '0', '15', 'Flag table', '0', '5', '', '', ''),
	('033045', 'B33045', 'Probability of following event (see Notes 1 and 3)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033046', 'B33046', 'Conditional probability of following event with respect to specified conditioning event (see Notes 1 2 and 3)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033047', 'B33047', 'Measurement confidence data', 'Flag table', '0', '0', '31', 'Flag table', '0', '11', '', '', ''),
	('033048', 'B33048', 'Confidence measure of SAR inversion', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033049', 'B33049', 'Confidence measure of wind retrieval', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033050', 'B33050', 'Global GTSPP quality flag', 'Code table', '0', '0', '4', 'Code table', '0', '2', '', '', ''),
	('033052', 'B33052', 'S band ocean retracking quality', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('033053', 'B33053', 'KU band ocean retracking quality', 'Flag table', '0', '0', '21', 'Flag table', '0', '7', '', '', ''),
	('033060', 'B33060', 'GqisFlagQual - individual IASI-System quality flag', 'Code table', '0', '0', '2', 'Code table', '0', '1', '', '', ''),
	('033061', 'B33061', 'GqisQualIndex - indicator for instrument noise performance (contributions from spectral and radiometric)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033062', 'B33062', 'GqisQualIndexLoc - indicator for geometric quality index', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033063', 'B33063', 'GqisQualIndexRad - indicator for instrument noise performance (contributions from radiometric calibration)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033064', 'B33064', 'GqisQualIndexSpect - indicator for instrument noise performance (contributions from spectral calibration)', '%', '0', '0', '7', '%', '0', '3', '', '', ''),
	('033065', 'B33065', 'GqisSysTecSondQual - output of system TEC (Technical Expertise Centre) quality function', 'Numeric', '0', '0', '24', 'Numeric', '0', '8', '', '', ''),
	('035000', 'B35000', 'FM and regional code number', 'Code table', '0', '0', '10', 'Code table', '0', '3', '', '', ''),
	('035001', 'B35001', 'Time-frame for monitoring', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('035011', 'B35011', 'Number of reports actually received', 'Numeric', '0', '0', '14', 'Numeric', '0', '4', '', '', ''),
	('035021', 'B35021', 'Bulletin being monitored (TTAAii)', 'CCITT IA5', '0', '0', '48', 'Character', '0', '6', '', '', ''),
	('035022', 'B35022', 'Bulletin being monitored (YYGGgg)', 'CCITT IA5', '0', '0', '48', 'Character', '0', '6', '', '', ''),
	('035023', 'B35023', 'Bulletin being monitored (CCCC)', 'CCITT IA5', '0', '0', '32', 'Character', '0', '4', '', '', ''),
	('035024', 'B35024', 'Bulletin being monitored (BBB)', 'CCITT IA5', '0', '0', '24', 'Character', '0', '3', '', '', ''),
	('035030', 'B35030', 'Discrepancies in the availability of expected data', 'Code table', '0', '0', '4', 'Code table', '0', '1', '', '', ''),
	('035031', 'B35031', 'Qualifier on monitoring results', 'Code table', '0', '0', '7', 'Code table', '0', '2', '', '', ''),
	('035032', 'B35032', 'Cause of missing data', 'Code table', '0', '0', '4', 'Code table', '0', '1', '', '', ''),
	('035033', 'B35033', 'Observation and collection deficiencies', 'Code table', '0', '0', '7', 'Code table', '0', '2', '', '', ''),
	('035034', 'B35034', 'Statistical trends for availability of data (during the survey period(s))', 'Code table', '0', '0', '3', 'Code table', '0', '1', '', '', ''),
	('035035', 'B35035', 'Reason for termination', 'Code table', '0', '0', '5', 'Code table', '0', '2', '', '', ''),
	('040001', 'B40001', 'Surface soil moisture (ms)', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040002', 'B40002', 'Estimated error in surface soil moisture', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040003', 'B40003', 'Mean surface soil moisture ', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('040004', 'B40004', 'Rain fall detection', 'Numeric', '3', '0', '10', 'Numeric', '3', '4', '', '', ''),
	('040005', 'B40005', 'Soil moisture correction flag', 'Flag table', '0', '0', '8', 'Flag table', '0', '3', '', '', ''),
	('040006', 'B40006', 'Soil moisture processing flag', 'Flag table', '0', '0', '16', 'Flag table', '0', '6', '', '', ''),
	('040007', 'B40007', 'Soil moisture quality', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040008', 'B40008', 'Frozen land surface fraction', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040009', 'B40009', 'Inundation and wetland fraction', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('040010', 'B40010', 'Topographic complexity', '%', '1', '0', '10', '%', '1', '4', '', '', ''),
	('099999', 'B99999', 'Notes to Code and Flag Tables', '', '', '', '', '', '', '', '', '', '');
/*!40000 ALTER TABLE `bufr_crex_master` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.bufr_indicators
CREATE TABLE IF NOT EXISTS `bufr_indicators` (
  `Tmplate` varchar(50) NOT NULL DEFAULT '0',
  `Msg_Header` varchar(50) DEFAULT '0',
  `BUFR_Edition` varchar(10) DEFAULT '0',
  `Originating_Centre` varchar(10) DEFAULT '0',
  `Originating_SubCentre` varchar(10) DEFAULT '0',
  `Update_Sequence` varchar(10) DEFAULT '0',
  `Optional_Section` varchar(10) DEFAULT '0',
  `Data_Category` varchar(10) DEFAULT '0',
  `Intenational_Data_SubCategory` varchar(10) DEFAULT '0',
  `Local_Data_SubCategory` varchar(10) DEFAULT '0',
  `Master_table` varchar(10) DEFAULT '0',
  `Local_Table` varchar(10) DEFAULT '0',
  PRIMARY KEY (`Tmplate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.bufr_indicators: ~7 rows (approximately)
/*!40000 ALTER TABLE `bufr_indicators` DISABLE KEYS */;
INSERT INTO `bufr_indicators` (`Tmplate`, `Msg_Header`, `BUFR_Edition`, `Originating_Centre`, `Originating_SubCentre`, `Update_Sequence`, `Optional_Section`, `Data_Category`, `Intenational_Data_SubCategory`, `Local_Data_SubCategory`, `Master_table`, `Local_Table`) VALUES
	('TM_307080', 'ISNH40 HKNC', '04', '00014', '0', '0', '0', '0', '0', '0', '13', '0'),
	('TM_307081', 'ISNH40 HKNC', '04', '00014', '0', '0', '0', '0', '0', '0', '13', '0'),
	('TM_307082', 'ISNH40 HKNC', '04', '00014', '0', '0', '0', '0', '0', '0', '13', '0'),
	('TM_307083', 'ISNH40 HKNC', '04', '00014', '0', '0', '0', '0', '0', '0', '13', '0'),
	('TM_307084', 'ISNH40 HKNC', '04', '00014', '0', '0', '0', '0', '0', '0', '13', '0'),
	('TM_307086', 'ISNH40 HKNC', '04', '00014', '0', '0', '0', '0', '0', '0', '13', '0'),
	('TM_307091', 'ISNH01 HKNC', '04', '00014', '0', '0', '0', '0', '0', '0', '13', '0');
/*!40000 ALTER TABLE `bufr_indicators` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.ccitt
CREATE TABLE IF NOT EXISTS `ccitt` (
  `Characters` varchar(25) DEFAULT NULL,
  `MostSignificant` int(11) DEFAULT NULL,
  `LeastSignificant` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.ccitt: ~256 rows (approximately)
/*!40000 ALTER TABLE `ccitt` DISABLE KEYS */;
INSERT INTO `ccitt` (`Characters`, `MostSignificant`, `LeastSignificant`) VALUES
	('NUL', 0, 0),
	('DLE', 1, 0),
	('SP', 2, 0),
	('0', 3, 0),
	('@', 4, 0),
	('P', 5, 0),
	('`', 6, 0),
	('p', 7, 0),
	('SOH', 0, 1),
	('DC1', 1, 1),
	('!', 2, 1),
	('1', 3, 1),
	('A', 4, 1),
	('Q', 5, 1),
	('a', 6, 1),
	('q', 7, 1),
	('STX', 0, 2),
	('DC2', 1, 2),
	('“', 2, 2),
	('2', 3, 2),
	('B', 4, 2),
	('R', 5, 2),
	('b', 6, 2),
	('r', 7, 2),
	('ETX', 0, 3),
	('DC3', 1, 3),
	('#', 2, 3),
	('3', 3, 3),
	('C', 4, 3),
	('S', 5, 3),
	('c', 6, 3),
	('s', 7, 3),
	('EOT', 0, 4),
	('DC4', 1, 4),
	('$', 2, 4),
	('4', 3, 4),
	('D', 4, 4),
	('T', 5, 4),
	('d', 6, 4),
	('t', 7, 4),
	('ENQ', 0, 5),
	('NAK', 1, 5),
	('%', 2, 5),
	('5', 3, 5),
	('E', 4, 5),
	('U', 5, 5),
	('e', 6, 5),
	('u', 7, 5),
	('ACK', 0, 6),
	('SYN', 1, 6),
	('&', 2, 6),
	('6', 3, 6),
	('F', 4, 6),
	('V', 5, 6),
	('f', 6, 6),
	('v', 7, 6),
	('BEL', 0, 7),
	('ETB', 1, 7),
	('‘', 2, 7),
	('7', 3, 7),
	('G', 4, 7),
	('W', 5, 7),
	('g', 6, 7),
	('w', 7, 7),
	('BS', 0, 8),
	('CAN', 1, 8),
	('(', 2, 8),
	('8', 3, 8),
	('H', 4, 8),
	('X', 5, 8),
	('h', 6, 8),
	('x', 7, 8),
	('HT', 0, 9),
	('EM', 1, 9),
	(')', 2, 9),
	('9', 3, 9),
	('I', 4, 9),
	('Y', 5, 9),
	('i', 6, 9),
	('y', 7, 9),
	('LF', 0, 10),
	('SUB', 1, 10),
	('*', 2, 10),
	(':', 3, 10),
	('J', 4, 10),
	('Z', 5, 10),
	('j', 6, 10),
	('z', 7, 10),
	('VT', 0, 11),
	('ESC', 1, 11),
	('+', 2, 11),
	(';', 3, 11),
	('K', 4, 11),
	('[', 5, 11),
	('k', 6, 11),
	('{', 7, 11),
	('FF', 0, 12),
	('FS', 1, 12),
	(',', 2, 12),
	('<', 3, 12),
	('L', 4, 12),
	('\\', 5, 12),
	('l', 6, 12),
	('¦', 7, 12),
	('CR', 0, 13),
	('GS', 1, 13),
	('-', 2, 13),
	('=', 3, 13),
	('M', 4, 13),
	(']', 5, 13),
	('m', 6, 13),
	('}', 7, 13),
	('SO', 0, 14),
	('RS', 1, 14),
	('.', 2, 14),
	('>', 3, 14),
	('N', 4, 14),
	('^', 5, 14),
	('n', 6, 14),
	('~', 7, 14),
	('SI', 0, 15),
	('US', 1, 15),
	('/', 2, 15),
	('?', 3, 15),
	('O', 4, 15),
	('_', 5, 15),
	('o', 6, 15),
	('DEL', 7, 15),
	('NUL', 0, 0),
	('DLE', 1, 0),
	('SP', 2, 0),
	('0', 3, 0),
	('@', 4, 0),
	('P', 5, 0),
	('`', 6, 0),
	('p', 7, 0),
	('SOH', 0, 1),
	('DC1', 1, 1),
	('!', 2, 1),
	('1', 3, 1),
	('A', 4, 1),
	('Q', 5, 1),
	('a', 6, 1),
	('q', 7, 1),
	('STX', 0, 2),
	('DC2', 1, 2),
	('“', 2, 2),
	('2', 3, 2),
	('B', 4, 2),
	('R', 5, 2),
	('b', 6, 2),
	('r', 7, 2),
	('ETX', 0, 3),
	('DC3', 1, 3),
	('#', 2, 3),
	('3', 3, 3),
	('C', 4, 3),
	('S', 5, 3),
	('c', 6, 3),
	('s', 7, 3),
	('EOT', 0, 4),
	('DC4', 1, 4),
	('$', 2, 4),
	('4', 3, 4),
	('D', 4, 4),
	('T', 5, 4),
	('d', 6, 4),
	('t', 7, 4),
	('ENQ', 0, 5),
	('NAK', 1, 5),
	('%', 2, 5),
	('5', 3, 5),
	('E', 4, 5),
	('U', 5, 5),
	('e', 6, 5),
	('u', 7, 5),
	('ACK', 0, 6),
	('SYN', 1, 6),
	('&', 2, 6),
	('6', 3, 6),
	('F', 4, 6),
	('V', 5, 6),
	('f', 6, 6),
	('v', 7, 6),
	('BEL', 0, 7),
	('ETB', 1, 7),
	('‘', 2, 7),
	('7', 3, 7),
	('G', 4, 7),
	('W', 5, 7),
	('g', 6, 7),
	('w', 7, 7),
	('BS', 0, 8),
	('CAN', 1, 8),
	('(', 2, 8),
	('8', 3, 8),
	('H', 4, 8),
	('X', 5, 8),
	('h', 6, 8),
	('x', 7, 8),
	('HT', 0, 9),
	('EM', 1, 9),
	(')', 2, 9),
	('9', 3, 9),
	('I', 4, 9),
	('Y', 5, 9),
	('i', 6, 9),
	('y', 7, 9),
	('LF', 0, 10),
	('SUB', 1, 10),
	('*', 2, 10),
	(':', 3, 10),
	('J', 4, 10),
	('Z', 5, 10),
	('j', 6, 10),
	('z', 7, 10),
	('VT', 0, 11),
	('ESC', 1, 11),
	('+', 2, 11),
	(';', 3, 11),
	('K', 4, 11),
	('[', 5, 11),
	('k', 6, 11),
	('{', 7, 11),
	('FF', 0, 12),
	('FS', 1, 12),
	(',', 2, 12),
	('<', 3, 12),
	('L', 4, 12),
	('\\', 5, 12),
	('l', 6, 12),
	('¦', 7, 12),
	('CR', 0, 13),
	('GS', 1, 13),
	('-', 2, 13),
	('=', 3, 13),
	('M', 4, 13),
	(']', 5, 13),
	('m', 6, 13),
	('}', 7, 13),
	('SO', 0, 14),
	('RS', 1, 14),
	('.', 2, 14),
	('>', 3, 14),
	('N', 4, 14),
	('^', 5, 14),
	('n', 6, 14),
	('~', 7, 14),
	('SI', 0, 15),
	('US', 1, 15),
	('/', 2, 15),
	('?', 3, 15),
	('O', 4, 15),
	('_', 5, 15),
	('o', 6, 15),
	('DEL', 7, 15);
/*!40000 ALTER TABLE `ccitt` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.climsoftusers
CREATE TABLE IF NOT EXISTS `climsoftusers` (
  `userName` varchar(50) NOT NULL,
  `userRole` varchar(50) NOT NULL,
  PRIMARY KEY (`userName`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.climsoftusers: ~0 rows (approximately)
/*!40000 ALTER TABLE `climsoftusers` DISABLE KEYS */;
/*!40000 ALTER TABLE `climsoftusers` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.code_flag
CREATE TABLE IF NOT EXISTS `code_flag` (
  `FXY` varchar(255) NOT NULL,
  `Fxyyy` varchar(50) DEFAULT NULL,
  `Description` varchar(255) DEFAULT NULL,
  `Bufr_DataWidth_Bits` int(11) DEFAULT NULL,
  `Crex_DataWidth` varchar(25) DEFAULT NULL,
  `Bufr_Unit` varchar(255) DEFAULT NULL,
  `Bufr_Value` varchar(50) DEFAULT NULL,
  `Crex_Value` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`FXY`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.code_flag: ~39 rows (approximately)
/*!40000 ALTER TABLE `code_flag` DISABLE KEYS */;
INSERT INTO `code_flag` (`FXY`, `Fxyyy`, `Description`, `Bufr_DataWidth_Bits`, `Crex_DataWidth`, `Bufr_Unit`, `Bufr_Value`, `Crex_Value`) VALUES
	('001101', 'B01101', 'State identifier', 10, '3', 'Code table', '128', NULL),
	('002001', 'B02001', 'Type of station', 2, '1', 'Code table', '0', NULL),
	('002038', 'B02038', 'Method of sea surface temperature measurement', 4, '2', 'Code table', '15', NULL),
	('002175', 'B02175', 'Method of precipitation measurement ', 4, '2', 'Code table', '1', NULL),
	('002176', 'B02176', 'Method of state of ground measurement ', 4, '2', 'Code table', '14', NULL),
	('002177', 'B02177', 'Method of snow depth measurement ', 4, '2', 'Code table', '15', NULL),
	('002178', 'B02178', 'Method of liquid content measurement of precipitation', 4, '2', 'Code table', '4', NULL),
	('002179', 'B02179', 'Type of sky condition algorithm ', 4, '2', 'Code table', '3', NULL),
	('002180', 'B02180', 'Main present weather detecting system ', 4, '2', 'Code table', '14', NULL),
	('002181', 'B02181', 'Supplementary present weather sensor', 21, '7', 'Flag table', NULL, NULL),
	('002182', 'B02182', 'Visibility measurement system ', 4, '2', 'Code table', '14', NULL),
	('002183', 'B02183', 'Cloud detection system', 4, '2', 'Code table', '14', NULL),
	('002184', 'B02184', 'Type of lightning detection sensor', 4, '2', 'Code table', '14', NULL),
	('002185', 'B02185', 'Method of evaporation measurement', 4, '2', 'Code table', '14', NULL),
	('002186', 'B02186', 'Capability to detect precipitation phenomena', 30, '10', 'Flag table', '111111111111111111111110000000', NULL),
	('002187', 'B02187', 'Capability to detect other weather phenomena', 18, '6', 'Flag table', NULL, NULL),
	('002188', 'B02188', 'Capability to detect obscuration', 21, '7', 'Flag table', NULL, NULL),
	('002189', 'B02189', 'Capability to discriminate lightning strikes', 12, '4', 'Flag table', NULL, NULL),
	('008002', 'B08002', 'Vertical significance (surface observations)', 6, '2', 'Code table', '62', NULL),
	('008010', 'B08010', 'Surface qualifier (temperature data)', 5, '2', 'Code table', '3', NULL),
	('008021', 'B08021', 'Time significance (= 2 (time averaged))', 5, '2', 'Code table', '2', NULL),
	('008023', 'B08023', 'First order statistics', 6, '2', 'Code table', '63', NULL),
	('010063', 'B10063', 'Characteristic of pressure tendency', 4, '2', 'Code table', '15', NULL),
	('020003', 'B20003', 'Present weather', 9, '3', 'Code table', NULL, NULL),
	('020004', 'B20004', 'Past weather (1) ', 5, '2', 'Code table', NULL, NULL),
	('020005', 'B20005', 'Past weather (2)', 5, '2', 'Code table', NULL, NULL),
	('020011', 'B20011', 'Cloud amount', 4, '2', 'Code table', NULL, NULL),
	('020012', 'B20012', 'Cloud type', 6, '2', 'Code table', NULL, NULL),
	('020021', 'B20021', 'Type of precipitation', 30, '10', 'Flag table', NULL, NULL),
	('020022', 'B20022', 'Character of precipitation', 4, '2', 'Code table', NULL, NULL),
	('020023', 'B20023', 'Other weather phenomena', 18, '6', 'Flag table', NULL, NULL),
	('020024', 'B20024', 'Intensity of phenomena', 3, '1', 'Code table', NULL, NULL),
	('020025', 'B20025', 'Obscuration', 21, '7', 'Flag table', NULL, NULL),
	('020026', 'B20026', 'Character of obscuration', 4, '2', 'Code table', '15', NULL),
	('020032', 'B20032', 'Rate of ice accretion', 3, '1', 'Code table', '7', NULL),
	('020062', 'B20062', 'State of the ground (with or without snow)', 5, '2', 'Code table', '32', NULL),
	('033005', 'B33005', 'Quality information (AWS data)', 30, '10', 'Flag table', NULL, NULL),
	('033006', 'B33006', 'Internal measurement status information (AWS)', 3, '1', 'Code table', '0', NULL),
	('033041', 'B33041', 'Attribute of following value', 2, '1', 'Code table', '3', NULL);
/*!40000 ALTER TABLE `code_flag` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.data_forms
CREATE TABLE IF NOT EXISTS `data_forms` (
  `id` bigint(20) NOT NULL DEFAULT '0',
  `order_num` bigint(20) DEFAULT '0',
  `table_name` varchar(255) DEFAULT NULL,
  `form_name` varchar(250) NOT NULL,
  `description` text,
  `selected` tinyint(4) DEFAULT NULL,
  `val_start_position` bigint(20) DEFAULT '0',
  `val_end_position` bigint(20) DEFAULT '0',
  `elem_code_location` varchar(255) DEFAULT NULL,
  `sequencer` varchar(50) DEFAULT NULL,
  `entry_mode` tinyint(2) unsigned zerofill NOT NULL DEFAULT '00',
  PRIMARY KEY (`form_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.data_forms: ~17 rows (approximately)
/*!40000 ALTER TABLE `data_forms` DISABLE KEYS */;
INSERT INTO `data_forms` (`id`, `order_num`, `table_name`, `form_name`, `description`, `selected`, `val_start_position`, `val_end_position`, `elem_code_location`, `sequencer`, `entry_mode`) VALUES
	(63032, 21, 'form_synoptic_2_ra1', 'formSynoptic2RA1', 'Synoptic data for input into TDCF form for RA1', 1, 5, 53, 'Vertical', 'seq_month_day_synoptime', 00),
	(63027, 14, 'form_agro1', 'form_agro1', 'Kenya Agromet data', 1, 4, 37, 'Horizontal', 'seq_month_day', 00),
	(61139, 20, 'form_bmet26', 'form_bmet26', 'Botswana Hourly Data for several elements for 24 hours(BMET26)', 0, 5, 34, 'Horizontal', 'seq_month_day_time', 00),
	(63031, 19, 'form_climat', 'form_climat', 'Data for monthly CLIMAT report', 0, 4, 16, 'Horizontal', 'seq_month_day', 00),
	(61000, 3, 'form_daily1', 'form_daily1', 'Data for some elements for one day', 0, 5, 19, 'Horizontal', 'seq_month_day_form_daily1', 00),
	(61001, 2, 'form_daily2', 'form_daily2', 'Daily data for the whole month', 1, 5, 35, 'Vertical', 'seq_element_form_daily2', 00),
	(61002, 1, 'form_hourly', 'form_hourly', 'Hourly data', 1, 5, 28, 'Vertical', 'seq_form_hourly', 00),
	(63021, 15, 'form_hourlywind', 'form_hourlywind', 'Hourly wind data', 1, 4, 27, 'Horizontal', 'seq_month_day_form_hourlywind', 00),
	(63030, 18, 'form_monthly', 'form_monthly', 'Monthly data', 1, 3, 14, 'Vertical', 'seq_year', 00),
	(61003, 4, 'form_synoptic1', 'form_synoptic1', 'Synoptic data for one hour for one element for the whole month', 0, 5, 35, 'Vertical', 'seq_synoptime_element', 00),
	(61004, 5, 'form_synoptic2', 'form_synoptic2', 'Synoptic data for many elements for one  observation time', 0, 5, 37, 'Horizontal', 'seq_month_day_synoptime', 00),
	(63029, 17, 'form_synoptic2_caribbean', 'form_synoptic2_caribbean', 'Caribbean synoptic data for many elements for one  observation time', 0, 5, 37, 'Horizontal', 'seq_month_day_hour', 00),
	(61043, 19, 'form_synoptic2_TDCF', 'form_synoptic2_TDCF', 'Synoptic data for many elements for one  observation time - TDCF', 0, 5, 52, 'Horizontal', 'seq_month_day_synoptime', 00),
	(61005, 6, 'form_synoptic3', 'form_synoptic3', 'Synoptic data for all hours for one element', 0, 5, 12, 'Vertical', 'seq_form_synopt3', 00),
	(63028, 16, 'form_temp0', 'form_temp0', 'Uganda temperature data', 0, 4, 11, 'Horizontal', 'seq_month_day', 00),
	(61006, 7, 'form_upperair1', 'form_upperair1', 'Upper air data for several elements for one day', 0, 6, 17, 'Vertical', 'seq_month_day_synoptime_level', 00),
	(61007, 8, 'form_upperair2', 'form_upperair2', 'Upper air data for one element and one level for the whole month', 0, 6, 36, 'Vertical', 'seq_level_upperair_element', 00);
/*!40000 ALTER TABLE `data_forms` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.faultresolution
CREATE TABLE IF NOT EXISTS `faultresolution` (
  `resolvedDatetime` varchar(50) DEFAULT NULL,
  `resolvedBy` varchar(255) DEFAULT NULL,
  `associatedWith` bigint(20) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  UNIQUE KEY `solution` (`resolvedDatetime`,`associatedWith`),
  KEY `FK_mysql_climsoft_db_v4_instrumentFaultReport_faultResolution` (`associatedWith`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_instrumentFaultReport_faultResolution` FOREIGN KEY (`associatedWith`) REFERENCES `instrumentfaultreport` (`reportId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.faultresolution: ~0 rows (approximately)
/*!40000 ALTER TABLE `faultresolution` DISABLE KEYS */;
/*!40000 ALTER TABLE `faultresolution` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.featuregeographicalposition
CREATE TABLE IF NOT EXISTS `featuregeographicalposition` (
  `belongsTo` varchar(255) NOT NULL,
  `observedOn` varchar(50) DEFAULT NULL,
  `latitude` double(11,6) DEFAULT NULL,
  `longitude` double(11,6) DEFAULT NULL,
  UNIQUE KEY `FK_mysql_climsoft_db_v4_synopfeatureFeatureGeographicalPosition` (`belongsTo`,`observedOn`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_synopfeatureFeatureGeographicalPosition` FOREIGN KEY (`belongsTo`) REFERENCES `synopfeature` (`abbreviation`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.featuregeographicalposition: ~0 rows (approximately)
/*!40000 ALTER TABLE `featuregeographicalposition` DISABLE KEYS */;
/*!40000 ALTER TABLE `featuregeographicalposition` ENABLE KEYS */;


-- Dumping structure for procedure mariadb_climsoft_test_db_v4.find_gaps
DELIMITER //
CREATE DEFINER=`root`@`localhost` PROCEDURE `find_gaps`(IN Stn VARCHAR(255),IN Elm INT(11),IN Opening_Date DATE,IN Closing_Date DATE)
BEGIN
DECLARE Next_Date DATE;
IF Opening_Date <= Closing_Date THEN
 SET Next_Date  = Opening_Date;
 WHILE Next_Date < Closing_Date DO
    SELECT COUNT(*) INTO @FOUND
  FROM observationfinal
  WHERE recordedfrom=Stn
  AND describedby=Elm
  AND DATE(obsDatetime)=Next_Date;

  IF @FOUND <1 THEN
   INSERT INTO gaps VALUES (Stn,Elm,Next_Date);
   Commit;
  END IF;
 SET Next_Date = DATE_ADD(Next_Date, INTERVAL 1 DAY);
 END WHILE;
END IF;
END//
DELIMITER ;


-- Dumping structure for table mariadb_climsoft_test_db_v4.flags
CREATE TABLE IF NOT EXISTS `flags` (
  `characterSymbol` varchar(255) NOT NULL DEFAULT '',
  `numSymbol` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`characterSymbol`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.flags: ~5 rows (approximately)
/*!40000 ALTER TABLE `flags` DISABLE KEYS */;
INSERT INTO `flags` (`characterSymbol`, `numSymbol`, `description`) VALUES
	('D', 3, 'Dubious or Suspect Data'),
	('E', 2, 'Estimated Value'),
	('G', 4, 'Generated or Calculated Data'),
	('M', 0, 'Missing Data'),
	('T', 1, 'Trace Rainfall');
/*!40000 ALTER TABLE `flags` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.flagtable
CREATE TABLE IF NOT EXISTS `flagtable` (
  `Bufr_Descriptor` varchar(6) NOT NULL,
  `Crex_Descriptor` varchar(6) DEFAULT NULL,
  `Details` varchar(255) DEFAULT NULL,
  `Widths` int(11) DEFAULT '0',
  `Missing` int(11) DEFAULT '0',
  PRIMARY KEY (`Bufr_Descriptor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.flagtable: ~27 rows (approximately)
/*!40000 ALTER TABLE `flagtable` DISABLE KEYS */;
INSERT INTO `flagtable` (`Bufr_Descriptor`, `Crex_Descriptor`, `Details`, `Widths`, `Missing`) VALUES
	('002001', 'B02001', 'Type of station', 1, 3),
	('002003', 'B02003', 'Type of measuring equipment used', 2, 15),
	('002004', 'B02004', 'Type of instrumentation for evaporation measurement or type of crop for which evapotranspiration is reported', 2, 15),
	('002011', 'B02011', 'Radiosonde type', 3, 255),
	('002013', 'B02013', 'Solar and infrared radiation correction', 2, 15),
	('002014', 'B02014', 'Tracking technique/status of system used', 3, 127),
	('008002', 'B08002', 'Vertical significance (surface observations)', 2, 63),
	('008021', 'B08021', 'Time significance', 2, 31),
	('010063', 'B10063', 'Characteristic of pressure tendency', 2, 15),
	('013056', 'B13056', 'Character and intensity of precipitation', 2, 15),
	('013057', 'B13057', 'Time of beginning or end of precipitation', 2, 15),
	('020003', 'B20003', 'Present weather (see Note 1)', 3, 511),
	('020004', 'B20004', 'Past weather (1) (see Note 2)', 2, 31),
	('020005', 'B20005', 'Past weather (2) (see Note 2)', 2, 31),
	('020011', 'B20011', 'Cloud amount', 2, 15),
	('020012', 'B20012', 'Cloud type', 2, 63),
	('020017', 'B20017', 'Cloud top description', 2, 15),
	('020062', 'B20062', 'State of the ground (with or without snow)', 2, 31),
	('020101', 'B20101', 'Locust (acridian) name', 2, 15),
	('020102', 'B20102', 'Locust (maturity) color', 2, 15),
	('020103', 'B20103', 'Stage of development of locusts', 2, 15),
	('020104', 'B20104', 'Organization state of swarm or band of locusts', 2, 15),
	('020105', 'B20105', 'Size of swarm or band of locusts and duration of passage of swarm', 2, 15),
	('020106', 'B20106', 'Locust population density', 2, 15),
	('020107', 'B20107', 'Direction of movements of locust swarm', 2, 15),
	('020108', 'B20108', 'Extent of vegetation', 2, 15),
	('033024', 'B33024', 'Station elevation quality mark (for mobile stations)', 2, 15);
/*!40000 ALTER TABLE `flagtable` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.form_agro1
CREATE TABLE IF NOT EXISTS `form_agro1` (
  `stationId` varchar(50) NOT NULL DEFAULT '',
  `yyyy` int(11) NOT NULL,
  `mm` int(11) NOT NULL,
  `dd` int(11) NOT NULL,
  `Val_Elem101` varchar(6) DEFAULT NULL,
  `Val_Elem102` varchar(6) DEFAULT NULL,
  `Val_Elem103` varchar(6) DEFAULT NULL,
  `Val_Elem105` varchar(6) DEFAULT NULL,
  `Val_Elem002` varchar(6) DEFAULT NULL,
  `Val_Elem003` varchar(6) DEFAULT NULL,
  `Val_Elem099` varchar(6) DEFAULT NULL,
  `Val_Elem072` varchar(6) DEFAULT NULL,
  `Val_Elem073` varchar(6) DEFAULT NULL,
  `Val_Elem074` varchar(6) DEFAULT NULL,
  `Val_Elem554` varchar(6) DEFAULT NULL,
  `Val_Elem075` varchar(6) DEFAULT NULL,
  `Val_Elem076` varchar(6) DEFAULT NULL,
  `Val_Elem561` varchar(6) DEFAULT NULL,
  `Val_Elem562` varchar(6) DEFAULT NULL,
  `Val_Elem563` varchar(6) DEFAULT NULL,
  `Val_Elem513` varchar(6) DEFAULT NULL,
  `Val_Elem005` varchar(6) DEFAULT NULL,
  `Val_Elem504` varchar(6) DEFAULT NULL,
  `Val_Elem532` varchar(6) DEFAULT NULL,
  `Val_Elem137` varchar(6) DEFAULT NULL,
  `Val_Elem018` varchar(6) DEFAULT NULL,
  `Val_Elem518` varchar(6) DEFAULT NULL,
  `Val_Elem511` varchar(6) DEFAULT NULL,
  `Val_Elem512` varchar(6) DEFAULT NULL,
  `Val_Elem503` varchar(6) DEFAULT NULL,
  `Val_Elem515` varchar(6) DEFAULT NULL,
  `Val_Elem564` varchar(6) DEFAULT NULL,
  `Val_Elem565` varchar(6) DEFAULT NULL,
  `Val_Elem566` varchar(6) DEFAULT NULL,
  `Val_Elem531` varchar(6) DEFAULT NULL,
  `Val_Elem530` varchar(6) DEFAULT NULL,
  `Val_Elem541` varchar(6) DEFAULT NULL,
  `Val_Elem542` varchar(6) DEFAULT NULL,
  `Flag101` varchar(1) DEFAULT NULL,
  `Flag102` varchar(1) DEFAULT NULL,
  `Flag103` varchar(1) DEFAULT NULL,
  `Flag105` varchar(1) DEFAULT NULL,
  `Flag002` varchar(1) DEFAULT NULL,
  `Flag003` varchar(1) DEFAULT NULL,
  `Flag099` varchar(1) DEFAULT NULL,
  `Flag072` varchar(1) DEFAULT NULL,
  `Flag073` varchar(1) DEFAULT NULL,
  `Flag074` varchar(1) DEFAULT NULL,
  `Flag554` varchar(1) DEFAULT NULL,
  `Flag075` varchar(1) DEFAULT NULL,
  `Flag076` varchar(1) DEFAULT NULL,
  `Flag561` varchar(1) DEFAULT NULL,
  `Flag562` varchar(1) DEFAULT NULL,
  `Flag563` varchar(1) DEFAULT NULL,
  `Flag513` varchar(1) DEFAULT NULL,
  `Flag005` varchar(1) DEFAULT NULL,
  `Flag504` varchar(1) DEFAULT NULL,
  `Flag532` varchar(1) DEFAULT NULL,
  `Flag137` varchar(1) DEFAULT NULL,
  `Flag018` varchar(1) DEFAULT NULL,
  `Flag518` varchar(1) DEFAULT NULL,
  `Flag511` varchar(1) DEFAULT NULL,
  `Flag512` varchar(1) DEFAULT NULL,
  `Flag503` varchar(1) DEFAULT NULL,
  `Flag515` varchar(1) DEFAULT NULL,
  `Flag564` varchar(1) DEFAULT NULL,
  `Flag565` varchar(1) DEFAULT NULL,
  `Flag566` varchar(1) DEFAULT NULL,
  `Flag531` varchar(1) DEFAULT NULL,
  `Flag530` varchar(1) DEFAULT NULL,
  `Flag541` varchar(1) DEFAULT NULL,
  `Flag542` varchar(1) DEFAULT NULL,
  `signature` varchar(45) DEFAULT NULL,
  `entryDatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`stationId`,`yyyy`,`mm`,`dd`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.form_agro1: ~0 rows (approximately)
/*!40000 ALTER TABLE `form_agro1` DISABLE KEYS */;
/*!40000 ALTER TABLE `form_agro1` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.form_daily2
CREATE TABLE IF NOT EXISTS `form_daily2` (
  `stationId` varchar(50) NOT NULL,
  `elementId` int(11) NOT NULL,
  `yyyy` int(11) NOT NULL,
  `mm` int(11) NOT NULL,
  `hh` int(11) NOT NULL,
  `day01` varchar(45) DEFAULT NULL,
  `day02` varchar(45) DEFAULT NULL,
  `day03` varchar(45) DEFAULT NULL,
  `day04` varchar(45) DEFAULT NULL,
  `day05` varchar(45) DEFAULT NULL,
  `day06` varchar(45) DEFAULT NULL,
  `day07` varchar(45) DEFAULT NULL,
  `day08` varchar(45) DEFAULT NULL,
  `day09` varchar(45) DEFAULT NULL,
  `day10` varchar(45) DEFAULT NULL,
  `day11` varchar(45) DEFAULT NULL,
  `day12` varchar(45) DEFAULT NULL,
  `day13` varchar(45) DEFAULT NULL,
  `day14` varchar(45) DEFAULT NULL,
  `day15` varchar(45) DEFAULT NULL,
  `day16` varchar(45) DEFAULT NULL,
  `day17` varchar(45) DEFAULT NULL,
  `day18` varchar(45) DEFAULT NULL,
  `day19` varchar(45) DEFAULT NULL,
  `day20` varchar(45) DEFAULT NULL,
  `day21` varchar(45) DEFAULT NULL,
  `day22` varchar(45) DEFAULT NULL,
  `day23` varchar(45) DEFAULT NULL,
  `day24` varchar(45) DEFAULT NULL,
  `day25` varchar(45) DEFAULT NULL,
  `day26` varchar(45) DEFAULT NULL,
  `day27` varchar(45) DEFAULT NULL,
  `day28` varchar(45) DEFAULT NULL,
  `day29` varchar(45) DEFAULT NULL,
  `day30` varchar(45) DEFAULT NULL,
  `day31` varchar(45) DEFAULT NULL,
  `flag01` varchar(1) DEFAULT NULL,
  `flag02` varchar(1) DEFAULT NULL,
  `flag03` varchar(1) DEFAULT NULL,
  `flag04` varchar(1) DEFAULT NULL,
  `flag05` varchar(1) DEFAULT NULL,
  `flag06` varchar(1) DEFAULT NULL,
  `flag07` varchar(1) DEFAULT NULL,
  `flag08` varchar(1) DEFAULT NULL,
  `flag09` varchar(1) DEFAULT NULL,
  `flag10` varchar(1) DEFAULT NULL,
  `flag11` varchar(1) DEFAULT NULL,
  `flag12` varchar(1) DEFAULT NULL,
  `flag13` varchar(1) DEFAULT NULL,
  `flag14` varchar(1) DEFAULT NULL,
  `flag15` varchar(1) DEFAULT NULL,
  `flag16` varchar(1) DEFAULT NULL,
  `flag17` varchar(1) DEFAULT NULL,
  `flag18` varchar(1) DEFAULT NULL,
  `flag19` varchar(1) DEFAULT NULL,
  `flag20` varchar(1) DEFAULT NULL,
  `flag21` varchar(1) DEFAULT NULL,
  `flag22` varchar(1) DEFAULT NULL,
  `flag23` varchar(1) DEFAULT NULL,
  `flag24` varchar(1) DEFAULT NULL,
  `flag25` varchar(1) DEFAULT NULL,
  `flag26` varchar(1) DEFAULT NULL,
  `flag27` varchar(1) DEFAULT NULL,
  `flag28` varchar(1) DEFAULT NULL,
  `flag29` varchar(1) DEFAULT NULL,
  `flag30` varchar(1) DEFAULT NULL,
  `flag31` varchar(1) DEFAULT NULL,
  `period01` varchar(45) DEFAULT NULL,
  `period02` varchar(45) DEFAULT NULL,
  `period03` varchar(45) DEFAULT NULL,
  `period04` varchar(45) DEFAULT NULL,
  `period05` varchar(45) DEFAULT NULL,
  `period06` varchar(45) DEFAULT NULL,
  `period07` varchar(45) DEFAULT NULL,
  `period08` varchar(45) DEFAULT NULL,
  `period09` varchar(45) DEFAULT NULL,
  `period10` varchar(45) DEFAULT NULL,
  `period11` varchar(45) DEFAULT NULL,
  `period12` varchar(45) DEFAULT NULL,
  `period13` varchar(45) DEFAULT NULL,
  `period14` varchar(45) DEFAULT NULL,
  `period15` varchar(45) DEFAULT NULL,
  `period16` varchar(45) DEFAULT NULL,
  `period17` varchar(45) DEFAULT NULL,
  `period18` varchar(45) DEFAULT NULL,
  `period19` varchar(45) DEFAULT NULL,
  `period20` varchar(45) DEFAULT NULL,
  `period21` varchar(45) DEFAULT NULL,
  `period22` varchar(45) DEFAULT NULL,
  `period23` varchar(45) DEFAULT NULL,
  `period24` varchar(45) DEFAULT NULL,
  `period25` varchar(45) DEFAULT NULL,
  `period26` varchar(45) DEFAULT NULL,
  `period27` varchar(45) DEFAULT NULL,
  `period28` varchar(45) DEFAULT NULL,
  `period29` varchar(45) DEFAULT NULL,
  `period30` varchar(45) DEFAULT NULL,
  `period31` varchar(45) DEFAULT NULL,
  `total` varchar(45) DEFAULT NULL,
  `signature` varchar(45) DEFAULT NULL,
  `entryDatetime` datetime DEFAULT NULL,
  `temperatureUnits` varchar(45) DEFAULT NULL,
  `precipUnits` varchar(45) DEFAULT NULL,
  `cloudHeightUnits` varchar(45) DEFAULT NULL,
  `visUnits` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`stationId`,`elementId`,`yyyy`,`mm`,`hh`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.form_daily2: ~0 rows (approximately)
/*!40000 ALTER TABLE `form_daily2` DISABLE KEYS */;
/*!40000 ALTER TABLE `form_daily2` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.form_hourly
CREATE TABLE IF NOT EXISTS `form_hourly` (
  `stationId` varchar(50) NOT NULL,
  `elementId` int(11) NOT NULL,
  `yyyy` int(11) NOT NULL,
  `mm` int(11) NOT NULL,
  `dd` int(11) NOT NULL,
  `hh_00` varchar(50) DEFAULT NULL,
  `hh_01` varchar(50) DEFAULT NULL,
  `hh_02` varchar(50) DEFAULT NULL,
  `hh_03` varchar(50) DEFAULT NULL,
  `hh_04` varchar(50) DEFAULT NULL,
  `hh_05` varchar(50) DEFAULT NULL,
  `hh_06` varchar(50) DEFAULT NULL,
  `hh_07` varchar(50) DEFAULT NULL,
  `hh_08` varchar(50) DEFAULT NULL,
  `hh_09` varchar(50) DEFAULT NULL,
  `hh_10` varchar(50) DEFAULT NULL,
  `hh_11` varchar(50) DEFAULT NULL,
  `hh_12` varchar(50) DEFAULT NULL,
  `hh_13` varchar(50) DEFAULT NULL,
  `hh_14` varchar(50) DEFAULT NULL,
  `hh_15` varchar(50) DEFAULT NULL,
  `hh_16` varchar(50) DEFAULT NULL,
  `hh_17` varchar(50) DEFAULT NULL,
  `hh_18` varchar(50) DEFAULT NULL,
  `hh_19` varchar(50) DEFAULT NULL,
  `hh_20` varchar(50) DEFAULT NULL,
  `hh_21` varchar(50) DEFAULT NULL,
  `hh_22` varchar(50) DEFAULT NULL,
  `hh_23` varchar(50) DEFAULT NULL,
  `flag00` varchar(50) DEFAULT NULL,
  `flag01` varchar(50) DEFAULT NULL,
  `flag02` varchar(50) DEFAULT NULL,
  `flag03` varchar(50) DEFAULT NULL,
  `flag04` varchar(50) DEFAULT NULL,
  `flag05` varchar(50) DEFAULT NULL,
  `flag06` varchar(50) DEFAULT NULL,
  `flag07` varchar(50) DEFAULT NULL,
  `flag08` varchar(50) DEFAULT NULL,
  `flag09` varchar(50) DEFAULT NULL,
  `flag10` varchar(50) DEFAULT NULL,
  `flag11` varchar(50) DEFAULT NULL,
  `flag12` varchar(50) DEFAULT NULL,
  `flag13` varchar(50) DEFAULT NULL,
  `flag14` varchar(50) DEFAULT NULL,
  `flag15` varchar(50) DEFAULT NULL,
  `flag16` varchar(50) DEFAULT NULL,
  `flag17` varchar(50) DEFAULT NULL,
  `flag18` varchar(50) DEFAULT NULL,
  `flag19` varchar(50) DEFAULT NULL,
  `flag20` varchar(50) DEFAULT NULL,
  `flag21` varchar(50) DEFAULT NULL,
  `flag22` varchar(50) DEFAULT NULL,
  `flag23` varchar(50) DEFAULT NULL,
  `total` varchar(50) DEFAULT NULL,
  `signature` varchar(50) DEFAULT NULL,
  `entryDatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`stationId`,`elementId`,`yyyy`,`mm`,`dd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.form_hourly: ~0 rows (approximately)
/*!40000 ALTER TABLE `form_hourly` DISABLE KEYS */;
/*!40000 ALTER TABLE `form_hourly` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.form_hourlywind
CREATE TABLE IF NOT EXISTS `form_hourlywind` (
  `stationId` varchar(255) NOT NULL,
  `yyyy` int(11) NOT NULL,
  `mm` int(11) NOT NULL,
  `dd` int(11) NOT NULL,
  `elem_112_00` varchar(255) DEFAULT NULL,
  `elem_112_01` varchar(255) DEFAULT NULL,
  `elem_112_02` varchar(255) DEFAULT NULL,
  `elem_112_03` varchar(255) DEFAULT NULL,
  `elem_112_04` varchar(255) DEFAULT NULL,
  `elem_112_05` varchar(255) DEFAULT NULL,
  `elem_112_06` varchar(255) DEFAULT NULL,
  `elem_112_07` varchar(255) DEFAULT NULL,
  `elem_112_08` varchar(255) DEFAULT NULL,
  `elem_112_09` varchar(255) DEFAULT NULL,
  `elem_112_10` varchar(255) DEFAULT NULL,
  `elem_112_11` varchar(255) DEFAULT NULL,
  `elem_112_12` varchar(255) DEFAULT NULL,
  `elem_112_13` varchar(255) DEFAULT NULL,
  `elem_112_14` varchar(255) DEFAULT NULL,
  `elem_112_15` varchar(255) DEFAULT NULL,
  `elem_112_16` varchar(255) DEFAULT NULL,
  `elem_112_17` varchar(255) DEFAULT NULL,
  `elem_112_18` varchar(255) DEFAULT NULL,
  `elem_112_19` varchar(255) DEFAULT NULL,
  `elem_112_20` varchar(255) DEFAULT NULL,
  `elem_112_21` varchar(255) DEFAULT NULL,
  `elem_112_22` varchar(255) DEFAULT NULL,
  `elem_112_23` varchar(255) DEFAULT NULL,
  `ddflag00` varchar(255) DEFAULT NULL,
  `ddflag01` varchar(255) DEFAULT NULL,
  `ddflag02` varchar(255) DEFAULT NULL,
  `ddflag03` varchar(255) DEFAULT NULL,
  `ddflag04` varchar(255) DEFAULT NULL,
  `ddflag05` varchar(255) DEFAULT NULL,
  `ddflag06` varchar(255) DEFAULT NULL,
  `ddflag07` varchar(255) DEFAULT NULL,
  `ddflag08` varchar(255) DEFAULT NULL,
  `ddflag09` varchar(255) DEFAULT NULL,
  `ddflag10` varchar(255) DEFAULT NULL,
  `ddflag11` varchar(255) DEFAULT NULL,
  `ddflag12` varchar(255) DEFAULT NULL,
  `ddflag13` varchar(255) DEFAULT NULL,
  `ddflag14` varchar(255) DEFAULT NULL,
  `ddflag15` varchar(255) DEFAULT NULL,
  `ddflag16` varchar(255) DEFAULT NULL,
  `ddflag17` varchar(255) DEFAULT NULL,
  `ddflag18` varchar(255) DEFAULT NULL,
  `ddflag19` varchar(255) DEFAULT NULL,
  `ddflag20` varchar(255) DEFAULT NULL,
  `ddflag21` varchar(255) DEFAULT NULL,
  `ddflag22` varchar(255) DEFAULT NULL,
  `ddflag23` varchar(255) DEFAULT NULL,
  `elem_111_00` varchar(255) DEFAULT NULL,
  `elem_111_01` varchar(255) DEFAULT NULL,
  `elem_111_02` varchar(255) DEFAULT NULL,
  `elem_111_03` varchar(255) DEFAULT NULL,
  `elem_111_04` varchar(255) DEFAULT NULL,
  `elem_111_05` varchar(255) DEFAULT NULL,
  `elem_111_06` varchar(255) DEFAULT NULL,
  `elem_111_07` varchar(255) DEFAULT NULL,
  `elem_111_08` varchar(255) DEFAULT NULL,
  `elem_111_09` varchar(255) DEFAULT NULL,
  `elem_111_10` varchar(255) DEFAULT NULL,
  `elem_111_11` varchar(255) DEFAULT NULL,
  `elem_111_12` varchar(255) DEFAULT NULL,
  `elem_111_13` varchar(255) DEFAULT NULL,
  `elem_111_14` varchar(255) DEFAULT NULL,
  `elem_111_15` varchar(255) DEFAULT NULL,
  `elem_111_16` varchar(255) DEFAULT NULL,
  `elem_111_17` varchar(255) DEFAULT NULL,
  `elem_111_18` varchar(255) DEFAULT NULL,
  `elem_111_19` varchar(255) DEFAULT NULL,
  `elem_111_20` varchar(255) DEFAULT NULL,
  `elem_111_21` varchar(255) DEFAULT NULL,
  `elem_111_22` varchar(255) DEFAULT NULL,
  `elem_111_23` varchar(255) DEFAULT NULL,
  `total` varchar(50) DEFAULT NULL,
  `signature` varchar(50) DEFAULT NULL,
  `entryDatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`stationId`,`yyyy`,`mm`,`dd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.form_hourlywind: ~0 rows (approximately)
/*!40000 ALTER TABLE `form_hourlywind` DISABLE KEYS */;
/*!40000 ALTER TABLE `form_hourlywind` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.form_hourly_time_selection
CREATE TABLE IF NOT EXISTS `form_hourly_time_selection` (
  `hh` int(11) NOT NULL,
  `hh_selection` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`hh`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.form_hourly_time_selection: ~24 rows (approximately)
/*!40000 ALTER TABLE `form_hourly_time_selection` DISABLE KEYS */;
INSERT INTO `form_hourly_time_selection` (`hh`, `hh_selection`) VALUES
	(0, 0),
	(1, 0),
	(2, 0),
	(3, 1),
	(4, 0),
	(5, 0),
	(6, 1),
	(7, 0),
	(8, 0),
	(9, 1),
	(10, 0),
	(11, 0),
	(12, 1),
	(13, 0),
	(14, 0),
	(15, 1),
	(16, 0),
	(17, 0),
	(18, 1),
	(19, 0),
	(20, 0),
	(21, 1),
	(22, 0),
	(23, 0);
/*!40000 ALTER TABLE `form_hourly_time_selection` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.form_monthly
CREATE TABLE IF NOT EXISTS `form_monthly` (
  `stationId` varchar(255) NOT NULL,
  `elementId` int(11) NOT NULL,
  `yyyy` int(11) NOT NULL,
  `mm_01` varchar(255) DEFAULT NULL,
  `mm_02` varchar(255) DEFAULT NULL,
  `mm_03` varchar(255) DEFAULT NULL,
  `mm_04` varchar(255) NOT NULL,
  `mm_05` varchar(255) DEFAULT NULL,
  `mm_06` varchar(255) DEFAULT NULL,
  `mm_07` varchar(255) DEFAULT NULL,
  `mm_08` varchar(255) DEFAULT NULL,
  `mm_09` varchar(255) DEFAULT NULL,
  `mm_10` varchar(255) DEFAULT NULL,
  `mm_11` varchar(255) DEFAULT NULL,
  `mm_12` varchar(255) DEFAULT NULL,
  `flag01` varchar(255) DEFAULT NULL,
  `flag02` varchar(255) DEFAULT NULL,
  `flag03` varchar(255) DEFAULT NULL,
  `flag04` varchar(255) DEFAULT NULL,
  `flag05` varchar(255) DEFAULT NULL,
  `flag06` varchar(255) DEFAULT NULL,
  `flag07` varchar(255) DEFAULT NULL,
  `flag08` varchar(255) DEFAULT NULL,
  `flag09` varchar(255) DEFAULT NULL,
  `flag10` varchar(255) DEFAULT NULL,
  `flag11` varchar(255) DEFAULT NULL,
  `flag12` varchar(255) DEFAULT NULL,
  `period01` varchar(255) DEFAULT NULL,
  `period02` varchar(255) DEFAULT NULL,
  `period03` varchar(255) DEFAULT NULL,
  `period04` varchar(255) DEFAULT NULL,
  `period05` varchar(255) DEFAULT NULL,
  `period06` varchar(255) DEFAULT NULL,
  `period07` varchar(255) DEFAULT NULL,
  `period08` varchar(255) DEFAULT NULL,
  `period09` varchar(255) DEFAULT NULL,
  `period10` varchar(255) DEFAULT NULL,
  `period11` varchar(255) DEFAULT NULL,
  `period12` varchar(255) DEFAULT NULL,
  `signature` varchar(50) DEFAULT NULL,
  `entryDatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`stationId`,`elementId`,`yyyy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.form_monthly: ~1 rows (approximately)
/*!40000 ALTER TABLE `form_monthly` DISABLE KEYS */;
INSERT INTO `form_monthly` (`stationId`, `elementId`, `yyyy`, `mm_01`, `mm_02`, `mm_03`, `mm_04`, `mm_05`, `mm_06`, `mm_07`, `mm_08`, `mm_09`, `mm_10`, `mm_11`, `mm_12`, `flag01`, `flag02`, `flag03`, `flag04`, `flag05`, `flag06`, `flag07`, `flag08`, `flag09`, `flag10`, `flag11`, `flag12`, `period01`, `period02`, `period03`, `period04`, `period05`, `period06`, `period07`, `period08`, `period09`, `period10`, `period11`, `period12`, `signature`, `entryDatetime`) VALUES
	('67755030', 2, 2018, '312', '', '', '', '', '', '', '', '', '', '321', '', '', 'M', 'M', 'M', 'M', 'M', 'M', 'M', 'M', 'M', '', 'M', '31', '28', '31', '30', '31', '30', '31', '31', '30', '31', '30', '31', 'root', '2018-09-20 16:36:54');
/*!40000 ALTER TABLE `form_monthly` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.form_synoptic2_tdcf
CREATE TABLE IF NOT EXISTS `form_synoptic2_tdcf` (
  `stationId` varchar(10) NOT NULL,
  `yyyy` bigint(20) NOT NULL,
  `mm` bigint(20) NOT NULL,
  `dd` bigint(20) NOT NULL,
  `hh` varchar(5) NOT NULL,
  `106` varchar(6) DEFAULT NULL,
  `107` varchar(6) DEFAULT NULL,
  `399` varchar(5) DEFAULT NULL,
  `301` varchar(8) DEFAULT NULL,
  `185` varchar(6) DEFAULT NULL,
  `101` varchar(5) DEFAULT NULL,
  `103` varchar(5) DEFAULT NULL,
  `105` varchar(50) DEFAULT NULL,
  `110` varchar(5) DEFAULT NULL,
  `114` varchar(5) DEFAULT NULL,
  `115` varchar(5) DEFAULT NULL,
  `168` varchar(5) DEFAULT NULL,
  `192` varchar(5) DEFAULT NULL,
  `169` varchar(5) DEFAULT NULL,
  `170` varchar(5) DEFAULT NULL,
  `171` varchar(5) DEFAULT NULL,
  `119` varchar(5) DEFAULT NULL,
  `116` varchar(5) DEFAULT NULL,
  `117` varchar(5) DEFAULT NULL,
  `118` varchar(5) DEFAULT NULL,
  `123` varchar(5) DEFAULT NULL,
  `120` varchar(5) DEFAULT NULL,
  `121` varchar(5) DEFAULT NULL,
  `122` varchar(5) DEFAULT NULL,
  `127` varchar(5) DEFAULT NULL,
  `124` varchar(5) DEFAULT NULL,
  `125` varchar(5) DEFAULT NULL,
  `126` varchar(5) DEFAULT NULL,
  `131` varchar(5) DEFAULT NULL,
  `128` varchar(5) DEFAULT NULL,
  `129` varchar(5) DEFAULT NULL,
  `130` varchar(5) DEFAULT NULL,
  `167` varchar(5) DEFAULT NULL,
  `197` varchar(50) DEFAULT NULL,
  `193` varchar(5) DEFAULT NULL,
  `18` varchar(6) DEFAULT NULL,
  `532` varchar(6) DEFAULT NULL,
  `132` varchar(6) DEFAULT NULL,
  `5` varchar(6) DEFAULT NULL,
  `174` varchar(50) DEFAULT NULL,
  `3` varchar(5) DEFAULT NULL,
  `2` varchar(5) DEFAULT NULL,
  `112` varchar(5) DEFAULT NULL,
  `111` varchar(5) DEFAULT NULL,
  `85` varchar(50) DEFAULT NULL,
  `flag1` varchar(1) DEFAULT NULL,
  `flag2` varchar(1) DEFAULT NULL,
  `flag3` varchar(1) DEFAULT NULL,
  `flag4` varchar(1) DEFAULT NULL,
  `flag5` varchar(1) DEFAULT NULL,
  `flag6` varchar(1) DEFAULT NULL,
  `flag7` varchar(1) DEFAULT NULL,
  `flag8` varchar(1) DEFAULT NULL,
  `flag9` varchar(1) DEFAULT NULL,
  `flag10` varchar(1) DEFAULT NULL,
  `flag11` varchar(1) DEFAULT NULL,
  `flag12` varchar(1) DEFAULT NULL,
  `flag13` varchar(1) DEFAULT NULL,
  `flag14` varchar(1) DEFAULT NULL,
  `flag15` varchar(1) DEFAULT NULL,
  `flag16` varchar(1) DEFAULT NULL,
  `flag17` varchar(1) DEFAULT NULL,
  `flag18` varchar(1) DEFAULT NULL,
  `flag19` varchar(1) DEFAULT NULL,
  `flag20` varchar(1) DEFAULT NULL,
  `flag21` varchar(1) DEFAULT NULL,
  `flag22` varchar(1) DEFAULT NULL,
  `flag23` varchar(1) DEFAULT NULL,
  `flag24` varchar(1) DEFAULT NULL,
  `flag25` varchar(1) DEFAULT NULL,
  `flag26` varchar(1) DEFAULT NULL,
  `flag27` varchar(1) DEFAULT NULL,
  `flag28` varchar(1) DEFAULT NULL,
  `flag29` varchar(1) DEFAULT NULL,
  `flag30` varchar(1) DEFAULT NULL,
  `flag31` varchar(1) DEFAULT NULL,
  `flag32` varchar(1) DEFAULT NULL,
  `flag33` varchar(1) DEFAULT NULL,
  `flag34` varchar(1) DEFAULT NULL,
  `flag35` varchar(1) DEFAULT NULL,
  `flag36` varchar(1) DEFAULT NULL,
  `flag37` varchar(1) DEFAULT NULL,
  `flag38` varchar(1) DEFAULT NULL,
  `flag39` varchar(1) DEFAULT NULL,
  `flag40` varchar(1) DEFAULT NULL,
  `flag41` varchar(1) DEFAULT NULL,
  `flag42` varchar(1) DEFAULT NULL,
  `flag43` varchar(1) DEFAULT NULL,
  `flag44` varchar(1) DEFAULT NULL,
  `flag45` varchar(1) DEFAULT NULL,
  `signature` varchar(50) DEFAULT NULL,
  `entryDatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`stationId`,`yyyy`,`mm`,`dd`,`hh`),
  UNIQUE KEY `Identification` (`stationId`,`yyyy`,`mm`,`dd`,`hh`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.form_synoptic2_tdcf: ~0 rows (approximately)
/*!40000 ALTER TABLE `form_synoptic2_tdcf` DISABLE KEYS */;
/*!40000 ALTER TABLE `form_synoptic2_tdcf` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.form_synoptic_2_ra1
CREATE TABLE IF NOT EXISTS `form_synoptic_2_ra1` (
  `stationId` varchar(50) NOT NULL DEFAULT '',
  `yyyy` int(11) NOT NULL,
  `mm` int(11) NOT NULL,
  `dd` int(11) NOT NULL,
  `hh` int(11) NOT NULL,
  `Val_Elem106` varchar(6) DEFAULT NULL,
  `Val_Elem107` varchar(6) DEFAULT NULL,
  `Val_Elem400` varchar(6) DEFAULT NULL,
  `Val_Elem814` varchar(6) DEFAULT NULL,
  `Val_Elem399` varchar(6) DEFAULT NULL,
  `Val_Elem301` varchar(6) DEFAULT NULL,
  `Val_Elem185` varchar(6) DEFAULT NULL,
  `Val_Elem101` varchar(6) DEFAULT NULL,
  `Val_Elem102` varchar(6) DEFAULT NULL,
  `Val_Elem103` varchar(6) DEFAULT NULL,
  `Val_Elem105` varchar(6) DEFAULT NULL,
  `Val_Elem192` varchar(6) DEFAULT NULL,
  `Val_Elem110` varchar(6) DEFAULT NULL,
  `Val_Elem114` varchar(6) DEFAULT NULL,
  `Val_Elem112` varchar(6) DEFAULT NULL,
  `Val_Elem111` varchar(6) DEFAULT NULL,
  `Val_Elem167` varchar(6) DEFAULT NULL,
  `Val_Elem197` varchar(6) DEFAULT NULL,
  `Val_Elem193` varchar(6) DEFAULT NULL,
  `Val_Elem115` varchar(6) DEFAULT NULL,
  `Val_Elem168` varchar(6) DEFAULT NULL,
  `Val_Elem169` varchar(6) DEFAULT NULL,
  `Val_Elem170` varchar(6) DEFAULT NULL,
  `Val_Elem171` varchar(6) DEFAULT NULL,
  `Val_Elem119` varchar(6) DEFAULT NULL,
  `Val_Elem116` varchar(6) DEFAULT NULL,
  `Val_Elem117` varchar(6) DEFAULT NULL,
  `Val_Elem118` varchar(6) DEFAULT NULL,
  `Val_Elem123` varchar(6) DEFAULT NULL,
  `Val_Elem120` varchar(6) DEFAULT NULL,
  `Val_Elem121` varchar(6) DEFAULT NULL,
  `Val_Elem122` varchar(6) DEFAULT NULL,
  `Val_Elem127` varchar(6) DEFAULT NULL,
  `Val_Elem124` varchar(6) DEFAULT NULL,
  `Val_Elem125` varchar(6) DEFAULT NULL,
  `Val_Elem126` varchar(6) DEFAULT NULL,
  `Val_Elem131` varchar(6) DEFAULT NULL,
  `Val_Elem128` varchar(6) DEFAULT NULL,
  `Val_Elem129` varchar(6) DEFAULT NULL,
  `Val_Elem130` varchar(6) DEFAULT NULL,
  `Val_Elem002` varchar(6) DEFAULT NULL,
  `Val_Elem003` varchar(6) DEFAULT NULL,
  `Val_Elem099` varchar(6) DEFAULT NULL,
  `Val_Elem018` varchar(6) DEFAULT NULL,
  `Val_Elem084` varchar(6) DEFAULT NULL,
  `Val_Elem132` varchar(6) DEFAULT NULL,
  `Val_Elem005` varchar(6) DEFAULT NULL,
  `Val_Elem174` varchar(6) DEFAULT NULL,
  `Val_Elem046` varchar(6) DEFAULT NULL,
  `Flag106` varchar(1) DEFAULT NULL,
  `Flag107` varchar(1) DEFAULT NULL,
  `Flag400` varchar(1) DEFAULT NULL,
  `Flag814` varchar(1) DEFAULT NULL,
  `Flag399` varchar(1) DEFAULT NULL,
  `Flag301` varchar(1) DEFAULT NULL,
  `Flag185` varchar(1) DEFAULT NULL,
  `Flag101` varchar(1) DEFAULT NULL,
  `Flag102` varchar(1) DEFAULT NULL,
  `Flag103` varchar(1) DEFAULT NULL,
  `Flag105` varchar(1) DEFAULT NULL,
  `Flag192` varchar(1) DEFAULT NULL,
  `Flag110` varchar(1) DEFAULT NULL,
  `Flag114` varchar(1) DEFAULT NULL,
  `Flag112` varchar(1) DEFAULT NULL,
  `Flag111` varchar(1) DEFAULT NULL,
  `Flag167` varchar(1) DEFAULT NULL,
  `Flag197` varchar(1) DEFAULT NULL,
  `Flag193` varchar(1) DEFAULT NULL,
  `Flag115` varchar(1) DEFAULT NULL,
  `Flag168` varchar(1) DEFAULT NULL,
  `Flag169` varchar(1) DEFAULT NULL,
  `Flag170` varchar(1) DEFAULT NULL,
  `Flag171` varchar(1) DEFAULT NULL,
  `Flag119` varchar(1) DEFAULT NULL,
  `Flag116` varchar(1) DEFAULT NULL,
  `Flag117` varchar(1) DEFAULT NULL,
  `Flag118` varchar(1) DEFAULT NULL,
  `Flag123` varchar(1) DEFAULT NULL,
  `Flag120` varchar(1) DEFAULT NULL,
  `Flag121` varchar(1) DEFAULT NULL,
  `Flag122` varchar(1) DEFAULT NULL,
  `Flag127` varchar(1) DEFAULT NULL,
  `Flag124` varchar(1) DEFAULT NULL,
  `Flag125` varchar(1) DEFAULT NULL,
  `Flag126` varchar(1) DEFAULT NULL,
  `Flag131` varchar(1) DEFAULT NULL,
  `Flag128` varchar(1) DEFAULT NULL,
  `Flag129` varchar(1) DEFAULT NULL,
  `Flag130` varchar(1) DEFAULT NULL,
  `Flag002` varchar(1) DEFAULT NULL,
  `Flag003` varchar(1) DEFAULT NULL,
  `Flag099` varchar(1) DEFAULT NULL,
  `Flag018` varchar(1) DEFAULT NULL,
  `Flag084` varchar(1) DEFAULT NULL,
  `Flag132` varchar(1) DEFAULT NULL,
  `Flag005` varchar(1) DEFAULT NULL,
  `Flag174` varchar(1) DEFAULT NULL,
  `Flag046` varchar(1) DEFAULT NULL,
  `signature` varchar(45) DEFAULT NULL,
  `entryDatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`stationId`,`yyyy`,`mm`,`dd`,`hh`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table mariadb_climsoft_test_db_v4.form_synoptic_2_ra1: ~0 rows (approximately)
/*!40000 ALTER TABLE `form_synoptic_2_ra1` DISABLE KEYS */;
/*!40000 ALTER TABLE `form_synoptic_2_ra1` ENABLE KEYS */;


-- Dumping structure for procedure mariadb_climsoft_test_db_v4.gather_stats
DELIMITER //
CREATE DEFINER=`root`@`localhost` PROCEDURE `gather_stats`(
	IN `Stn` VARCHAR(255),
	IN `Elm` INT(11),
	IN `Opening_Date` DATETIME,
	IN `Closing_Date` DATETIME
)
BEGIN
IF Opening_Date < Closing_Date THEN
INSERT INTO missing_stats
SELECT recordedfrom,describedby,datediff(Closing_Date,Opening_Date)-COUNT(*) AS missing,Closing_Date,Opening_Date 
FROM observationfinal
WHERE recordedfrom = Stn
AND obsdatetime >= Opening_Date
AND obsdatetime <= Closing_Date
AND describedby = Elm
GROUP by recordedfrom,describedby;
END IF;
END//
DELIMITER ;


-- Dumping structure for table mariadb_climsoft_test_db_v4.instrument
CREATE TABLE IF NOT EXISTS `instrument` (
  `instrumentName` varchar(255) DEFAULT NULL,
  `instrumentId` varchar(255) NOT NULL,
  `serialNumber` varchar(255) DEFAULT NULL,
  `abbreviation` varchar(255) DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `manufacturer` varchar(255) DEFAULT NULL,
  `instrumentUncertainty` float(11,6) DEFAULT NULL,
  `installationDatetime` varchar(50) DEFAULT NULL,
  `deinstallationDatetime` varchar(50) DEFAULT NULL,
  `height` varchar(255) DEFAULT NULL,
  `instrumentPicture` char(255) DEFAULT NULL,
  `installedAt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`instrumentId`),
  KEY `code` (`instrumentId`),
  KEY `FK_mysql_climsoft_db_v4_instrument` (`installedAt`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_instrument` FOREIGN KEY (`installedAt`) REFERENCES `station` (`stationId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.instrument: ~0 rows (approximately)
/*!40000 ALTER TABLE `instrument` DISABLE KEYS */;
/*!40000 ALTER TABLE `instrument` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.instrumentfaultreport
CREATE TABLE IF NOT EXISTS `instrumentfaultreport` (
  `refersTo` varchar(255) DEFAULT NULL,
  `reportId` bigint(20) NOT NULL,
  `reportDatetime` varchar(50) DEFAULT NULL,
  `faultDescription` varchar(255) DEFAULT NULL,
  `reportedBy` varchar(255) DEFAULT NULL,
  `receivedDatetime` varchar(50) DEFAULT NULL,
  `receivedBy` varchar(255) DEFAULT NULL,
  `reportedFrom` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`reportId`),
  UNIQUE KEY `instrument_report` (`refersTo`,`reportDatetime`,`reportedFrom`),
  KEY `report_id` (`reportId`),
  KEY `FK_mysql_climsoft_db_v4_station_instrumentFaultReport` (`reportedFrom`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_instrument_instrumentFaultReport` FOREIGN KEY (`refersTo`) REFERENCES `instrument` (`instrumentId`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_station_instrumentFaultReport` FOREIGN KEY (`reportedFrom`) REFERENCES `station` (`stationId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.instrumentfaultreport: ~0 rows (approximately)
/*!40000 ALTER TABLE `instrumentfaultreport` DISABLE KEYS */;
/*!40000 ALTER TABLE `instrumentfaultreport` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.instrumentinspection
CREATE TABLE IF NOT EXISTS `instrumentinspection` (
  `performedOn` varchar(255) DEFAULT NULL,
  `inspectionDatetime` varchar(50) DEFAULT NULL,
  `performedBy` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `performedAt` varchar(255) DEFAULT NULL,
  UNIQUE KEY `inspection` (`performedOn`,`inspectionDatetime`),
  KEY `FK_mysql_climsoft_db_v4_station_instrumentInspection` (`performedAt`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_instrument_instrumentInspection` FOREIGN KEY (`performedOn`) REFERENCES `instrument` (`instrumentId`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_station_instrumentInspection` FOREIGN KEY (`performedAt`) REFERENCES `station` (`stationId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.instrumentinspection: ~0 rows (approximately)
/*!40000 ALTER TABLE `instrumentinspection` DISABLE KEYS */;
/*!40000 ALTER TABLE `instrumentinspection` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.language_translation
CREATE TABLE IF NOT EXISTS `language_translation` (
  `tagID` varchar(50) NOT NULL,
  `en` varchar(100) DEFAULT NULL,
  `fr` varchar(100) DEFAULT NULL,
  `de` varchar(100) DEFAULT NULL,
  `pt` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`tagID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.language_translation: ~9 rows (approximately)
/*!40000 ALTER TABLE `language_translation` DISABLE KEYS */;
INSERT INTO `language_translation` (`tagID`, `en`, `fr`, `de`, `pt`) VALUES
	('1', 'English', 'français', 'Deutsche', 'Português'),
	('btnBrowse', 'Browse', 'Parcourir', 'Blättern', 'Viagem'),
	('btnCancel', 'Cancel', 'Annuler', 'Stornieren', 'Cancelar'),
	('btnHelp', 'Help', 'Aide', 'Hilfe', 'Socorro'),
	('btnOk', 'OK', 'OK', 'OK', 'OK'),
	('lblDataFile', 'Data File', 'Fichier de données', 'Datendatei', 'Arquivo de dados'),
	('lblSchemaFile', 'Schema File', 'Fichier de schéma', 'Schemadatei', 'arquivo de esquema'),
	('msgNotYetImplemented', 'Documentation on this topic not yet available !', 'La documentation sur ce sujet ne sont pas encore disponibles!', 'Dokumentation zu diesem Thema noch nicht verfügbar!', 'Documentação sobre este tópico ainda não está disponível!'),
	('titleFormImportCSV', 'Import CLICOM Daily from CSV', 'Importer CLICOM Tous les jours de CSV', 'Import CLICOM Täglich von CSV', 'Import CLICOM Diárias a partir de CSV');
/*!40000 ALTER TABLE `language_translation` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.missing_stats
CREATE TABLE IF NOT EXISTS `missing_stats` (
  `STN_ID` varchar(255) NOT NULL,
  `ELEM` bigint(20) NOT NULL,
  `MISSING` bigint(20) DEFAULT NULL,
  `Closing_Date` date NOT NULL,
  `Opening_Date` date NOT NULL,
  PRIMARY KEY (`STN_ID`,`ELEM`,`Closing_Date`,`Opening_Date`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.missing_stats: ~0 rows (approximately)
/*!40000 ALTER TABLE `missing_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `missing_stats` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.obselement
CREATE TABLE IF NOT EXISTS `obselement` (
  `elementId` bigint(20) NOT NULL DEFAULT '0',
  `abbreviation` varchar(255) DEFAULT NULL,
  `elementName` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `elementScale` decimal(8,2) DEFAULT NULL,
  `upperLimit` varchar(255) DEFAULT NULL,
  `lowerLimit` varchar(255) DEFAULT NULL,
  `units` varchar(255) DEFAULT NULL,
  `elementtype` varchar(50) DEFAULT NULL,
  `qcTotalRequired` int(11) DEFAULT '0',
  `selected` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`elementId`),
  KEY `elementCode` (`elementId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.obselement: ~424 rows (approximately)
/*!40000 ALTER TABLE `obselement` DISABLE KEYS */;
INSERT INTO `obselement` (`elementId`, `abbreviation`, `elementName`, `description`, `elementScale`, `upperLimit`, `lowerLimit`, `units`, `elementtype`, `qcTotalRequired`, `selected`) VALUES
	(2, 'TMPMAX', 'Temp  Daily Max', 'Temperature  daily maximum', 0.10, '460.00', '130.00', 'Degrees C', 'daily\r', 0, 1),
	(3, 'TMPMIN', 'Temp  Daily Min', 'Temperature  daily minimum', 0.10, '200.00', '50.00', 'Degrees C', 'daily\r', 0, 1),
	(4, 'TMPMN', 'Temp  Daily Mean', 'Temperature  daily mean', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(5, 'PRECIP', 'Precip  Daily', 'Precipitation  daily total', 0.10, '3000.00', '0.00', 'Millimeters', 'daily\r', 1, 1),
	(6, 'PRMX5', 'PRCP  Max 5 min', 'Precip  greatest amount in 5 minutes', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(7, 'PRMX10', 'PRCP  Max 10 min', 'Precip  greatest amount in 10 minutes', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(8, 'PRMX15', 'PRCP  Max 15 min', 'Precip  greatest amount in 15 minutes', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(9, 'PRMX30', 'PRCP  Max 30 min', 'Precip  greatest amount in 30 minutes', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(10, 'PRMX60', 'PRCP  Max 60 min', 'Precip  greatest amount in 60 minutes', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(11, 'PRMX2H', 'PRCP  Max 2 hours', 'Precip  greatest amount in 2 hours', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(12, 'DPTMAX', 'Temp  Dew Point Max', 'Temperature  dew point  daily maximum', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(13, 'DPTMIN', 'Temp  Dew Point Min', 'Temperature  dew point  daily minimum', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(14, 'DPTMN', 'Temp  Dew Point Mean', 'Temperature  dew point  daily mean', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(15, 'RHMAX', 'RH  Daily Max', 'Relative humidity  daily maximum', 1.00, '100.00', '0.00', 'Percent', 'daily\r', 0, 0),
	(16, 'RHMIN', 'RH  Daily Min', 'Relative humidity  daily minimum', 1.00, '100.00', '0.00', 'Percent', 'daily\r', 0, 0),
	(17, 'RHMEAN', 'RH  Daily Mean', 'Relative humidity  daily mean', 1.00, '100.00', '0.00', 'Percent', 'daily\r', 0, 0),
	(18, 'EVAPPN1', 'Evap  Pan1 Daily', 'Evaporation  pan1  daily total', 0.10, '250.00', '0.00', 'Millimeters', 'daily\r', 0, 1),
	(19, 'EVAPLK', 'Evap  Lake Daily', 'Evaporation  lake  daily total', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(20, 'MXTPAN', 'Temp  Evap Pan Max', 'Temperature  evaporation pan  daily maximum', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(21, 'MNTPAN', 'Temp  Evap Pan Min', 'Temperature  evaporation pan  daily minimum', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(22, 'MTPAN', 'Temp  Evap Pan Dly Mean', 'Temperature  evaporation pan  daily mean', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(23, 'HTDD1', 'HTNG Degree Days Base1', 'Heating degree days - Base 1', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(24, 'HTDD2', 'HTNG Degree Days Base2', 'Heating degree days - Base 2', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(25, 'CDD1', 'CLNG Degree Base1', 'Cooling degree days - Base 1', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(26, 'CDD2', 'CLNG Degree Base2', 'Cooling degree days - Base 2', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(27, 'GDD1', 'GRNG Degree Days Base1', 'Growing degree days - Base 1', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(28, 'GDD2', 'GRNG Degree Days Base2', 'Growing degree days - Base 2', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(29, 'DYRAIN', 'Day with Rain', 'Day with rainfall', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(30, 'DYTHND', 'Day with Thunder', 'Day with thunderstorms', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(31, 'DYHAIL', 'Day with Hail', 'Day with hail', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(32, 'DYFOG', 'Day with Fog', 'Day with fog', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(33, 'DYSAND', 'Day with Dust', 'Day with blowing sand or dust', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(34, 'DYSMOK', 'Day with Smoke', 'Day with smoke or thick haze', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(35, 'DYSNOW', 'Day with Snow', 'Day with snow', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(36, 'DYBSNW', 'Day with Blw Snow', 'Day with blowing snow', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(37, 'DYWND1', 'Day with Wind 10ms', 'Day with wind greater than 10 meters/sec', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(38, 'DYWND5', 'Day with Wind 15ms', 'Day with wind greater than 15 meters/sec', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(39, 'DYGLAZ', 'Day with Glaze', 'Day with glaze(freezing rain)', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(40, 'DYGDRZ', 'Day with Drizzle', 'Day with drizzle', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(41, 'DYICEP', 'Day with Ice Plt', 'Day with ice pellets', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(42, 'DYTORN', 'Day with Tornado', 'Day with tornado', 1.00, '', '', 'Unitless', 'daily\r', 0, 0),
	(43, 'SKYSUN', 'Sky Cover Avg Sun Set', 'Sky cover  average daily sunrise to sunset', 1.00, '9.00', '0.00', 'Tenths', 'daily\r', 0, 0),
	(44, 'SKYMID', 'Sky Cover Avg Midnight', 'Sky cover  daily average midnight to midnight', 1.00, '', '', 'Tenths', 'daily\r', 0, 0),
	(45, 'SUNSHI', 'Percent Possible Sunshine Dly', 'Percent of possible sunshine  daily', 1.00, '100.00', '0.00', 'Percent', 'daily\r', 0, 0),
	(46, 'INSOL', 'Insolation Daily', 'Insolation  daily total on a horizontal surface', 0.10, '394.00', '0.00', 'Megajoules/M**2', 'daily\r', 0, 0),
	(47, 'PRESST', 'Press Stn Avg', 'Pressure  station  daily avergage', 0.10, '', '', 'Hectopascals', 'daily\r', 0, 0),
	(48, 'PRESSL', 'Press Sea Level Avg', 'Pressure  reduced to sea level  daily average', 0.10, '', '', 'Hectopascals', 'daily\r', 0, 0),
	(49, 'SNOW', 'Snowfall  Daily', 'Snowfall  daily total', 1.00, '', '', 'Centimeters', 'daily\r', 0, 0),
	(50, 'SNWDEP', 'Snow Depth  Daily', 'Snow  depth on the ground at observation time', 1.00, '', '', 'Centimeters', 'daily\r', 0, 0),
	(51, 'SNWWEQ', 'Snow Depth water equivalent', 'Snow  water equivalent of snow on the ground at observation', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(52, 'TOPFGL', 'Frozen Ground Top', 'Frozen ground layer  depth of the top', 1.00, '', '', 'Centimeters', 'daily\r', 0, 0),
	(53, 'BOTFGL', 'Frozen Ground Bottom', 'Frozen ground layer  Depth of the bottom', 1.00, '', '', 'Centimeters', 'daily\r', 0, 0),
	(54, 'THKFGL', 'Frozen Ground Thickness', 'Frozen ground layer  thickness', 1.00, '', '', 'Centimeters', 'daily\r', 0, 0),
	(55, 'ICE', 'Ice Thickness', 'Ice on water  thickness', 0.10, '', '', 'Millimeters', 'daily\r', 0, 0),
	(56, 'WNDSPD', 'Wind Spd Avg Dly', 'Wind speed  daily average', 0.00, '100.00', '0.00', 'Meters/Second', 'daily\r', 0, 0),
	(57, 'WNDMIL', 'Wind Spd  Avg Dly Cup ', 'Wind speed daily average Cup Anemometer', 1.00, '15.00', '0.00', 'Kilometers', 'daily\r', 0, 0),
	(58, 'PKGUST', 'Wind Gust Max Spd', 'Wind gust  speed  daily maximum', 1.00, '', '', 'Meters/Second', 'daily\r', 0, 0),
	(59, 'PKGSTD', 'Wind Gust  Dir', 'Wind gust  direction of the daily maximum', 1.00, '', '', 'Tens of Degrees', 'daily\r', 0, 0),
	(60, 'WNDMX1', 'Wnd Spd Dly Max 1minute', 'Wind  1 minute  speed  daily maximum', 1.00, '', '', 'Meters/Second', 'daily\r', 0, 0),
	(61, 'WNDMXD', 'Wnd Dir Dly  Max 1minute', 'Wind  1 minute  direction of the daily maximum', 1.00, '', '', 'Tens of Degrees', 'daily\r', 0, 0),
	(62, 'SOILX1', 'Temp  Soil05 Dly Max', 'Temperature  soil  daily maximum at 5 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(63, 'SOILN1', 'Temp  Soil05 Dly Min', 'Temperature  soil  daily minimum at 5 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(64, 'SOILX2', 'Temp  Soil10 Dly Max', 'Temperature  soil  daily maximum at 10 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(65, 'SOILN2', 'Temp  Soil10 Dly Min', 'Temperature  soil  daily minimum at 10 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(66, 'SOILX3', 'Temp  Soil20 Dly Max', 'Temperature  soil  daily maximum at 20 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(67, 'SOILN3', 'Temp  Soil20 Dly Min', 'Temperature  soil  daily minimum at 20 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(68, 'SOILX4', 'Temp  Soil50 Dly Max', 'Temperature  soil  daily maximum at 50 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(69, 'SOILN4', 'Temp  Soil50 Dly Min', 'Temperature  soil  daily minimum at 50 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(70, 'SOILX5', 'Temp  soil100 Dly Max', 'Temperature  soil  daily maximum at 100 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(71, 'SOILN5', 'Temp  Soil100 Dly Min', 'Temperature  soil  daily minimum at 100 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(72, 'TTS005', 'TT Sol 5cm quot', 'TT sol 5cm quot', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(73, 'TTS010', 'TT sol 10cm quot', 'TT sol 10cm quot', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(74, 'TTS020', 'TT sol 20cm quot', 'TT sol 20cm quot', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(75, 'SOIL50', 'Temp  Soil50 Dly', 'Temperature  soil  daily at 50 cm', 0.10, '440.00', '-50.00', 'Degrees C', 'daily\r', 0, 0),
	(76, 'SOIL1M', 'Temp  Soil100 Dly', 'Temperature  soil  daily at 100 cm', 0.10, '440.00', '100.00', 'Degrees C', 'daily\r', 0, 0),
	(77, 'SOIL6', 'Temp  Soil150 Dly', 'Temperature  soil  daily at 150 cm', 0.10, '440.00', '-50.00', 'Degrees C', 'daily\r', 0, 0),
	(78, 'SOIL7', 'Temp  Soil200 Dly', 'Temperature  soil  daily at 200 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(79, 'SOIL8', 'Temp  Soil300 Dly', 'Temperature  soil  daily at 300 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(80, 'MXSOIL', 'Temp Soil Dly Max', 'Temperature  soil  daily maximum', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(81, 'MNSOIL', 'Temp Soil Dly Min', 'Temperature  soil  daily minimum', 0.10, '350.00', '-100.00', 'Degrees C', 'daily\r', 0, 0),
	(82, 'DSOIL', 'Temp  Soil Dly', 'Temperature  soil  daily', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(83, 'STRMFL', 'Stream Flow Dly Mean', 'Stream flow  Daily mean', 1.00, '', '', 'Meters**3/Second', 'daily\r', 0, 0),
	(84, 'SUNSHN', 'Sunshine  Daily Tot', 'Sunshine  Daily total amount', 0.10, '135.00', '0.00', 'Minutes', 'daily\r', 0, 0),
	(85, 'GRSMIN', 'Grasss Min  Temp 06Z', 'Grass Minimum Temperature at 06Z', 0.10, '360.00', '-100.00', 'Degrees C', 'daily\r', 0, 0),
	(86, 'LLDD', 'Lightning  Direction Dly', 'Lightning  direction daily', 1.00, '', '', 'coded', 'daily\r', 0, 0),
	(87, 'HHHD', 'Hail  Size  Daily', 'Hail  size  daily(updated)', 1.00, '', '', 'coded', 'daily\r', 0, 0),
	(91, '24hVPD', '24 Hr Mean VPD', 'Mean Vapour Pressure Deficit over 24 hours', 0.10, '', '', 'Hectopascals', 'daily\r', 0, 0),
	(92, '24hWB', '24 Hr Mean Wet Bulb Temp', 'Mean Wetbulb temperature over 24 hours', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(93, 'PSTWX', '24 Hr Past Wx', '24 Hour past weather', 1.00, '9.00', '0.00', 'Coded', 'daily\r', 0, 0),
	(94, 'MXMNDIFF', '24 Hr Temp Range', '24 Hr Temperature range', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(95, 'PrInTi', 'Precip Intensity Time', 'Number of minutes for the classified amounts of rain', 1.00, '', '', 'Minutes', 'daily\r', 0, 0),
	(96, 'JardIn', 'Precip Intensity Jardi', 'Jardi Rainfall Intensity', 1.00, '', '', 'Millimeters', 'daily\r', 0, 0),
	(97, 'DifRad', 'Diff Radiation', 'Diffuse Radiation measured by Moll-Kipp Solarimeter', 0.10, '', '', 'Megajoules/M**2', 'daily\r', 0, 0),
	(98, 'WINDTOT20', 'Wind Totalizer  18Z', 'Wind Totalizer at 18Z', 0.10, '999999.00', '0.00', 'Km', 'daily\r', 0, 0),
	(99, 'WINDRUN08', 'Wind Totalizer  06Z', 'Wind Totalizer at 06Z', 0.10, '999999.00', '0.00', 'Km', 'daily\r', 0, 0),
	(101, 'TEMPDB', 'Temp  Dry Bulb', 'Temperature  dry bulb', 0.10, '400.00', '130.00', 'Degrees C', 'hourly\r', 0, 1),
	(102, 'TEMPWB', 'Temp  Wet Bulb', 'Temperature  wet bulb', 0.10, '400.00', '120.00', 'Degrees C', 'hourly\r', 0, 1),
	(103, 'TEMPDP', 'Temp  Dew Point', 'Temperature  dew point', 0.10, '400.00', '80.00', 'Degrees C', 'hourly\r', 0, 1),
	(104, 'PRECIP', 'Precip  Hourly Total', 'Precipitation  total hourly', 0.10, '1000.00', '0.00', 'Millimeters', 'hourly\r', 0, 0),
	(105, 'RELHUM', 'Relative Humidty 06Z', 'Relative humidity at 06Z', 1.00, '100.00', '0.00', 'Percent', 'hourly\r', 0, 1),
	(106, 'PRESST', 'Pressure  Station', 'Pressure  station', 0.10, '155050.00', '7000.00', 'Hectopascals', 'hourly\r', 0, 1),
	(107, 'PRESSL', 'Pressure  Sea Level', 'Pressure  sea level', 0.10, '1505050.00', '8000.00', 'Hectopascals', 'hourly\r', 0, 1),
	(108, 'ALTMTR', 'Altimeter Setting', 'Altimeter setting', 0.10, '', '', 'Millibars', 'hourly\r', 0, 0),
	(109, 'CEIL', 'Ceiling', 'Ceiling', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(110, 'VISBY', 'Visibility Hor', 'Visibility  horizontal', 0.10, '40000.00', '0.00', 'Coded', 'hourly\r', 0, 0),
	(111, 'WNDSPD', 'Wind Speed in Knots', 'Wind speed in Knots', 1.00, '30.00', '0.00', 'Knots', 'hourly\r', 0, 1),
	(112, 'WNDDIR', 'Wind Direction', 'Wind direction', 0.10, '36.00', '0.00', 'Degrees C', 'hourly\r', 0, 1),
	(113, 'WNDMIL', 'Wind Mileage Hly', 'Wind mileage  hourly', 1.00, '', '', 'Kilometers', 'hourly\r', 0, 0),
	(114, 'CLDTOT', 'Cloud Cover  total', 'Cloud cover  total', 1.00, '8.00', '0.00', 'Octas', 'hourly\r', 0, 0),
	(115, 'CLDOPC', 'Cloud Opacty tot', 'Cloud opacity  total', 1.00, '', '', 'Octas', 'hourly\r', 0, 0),
	(116, 'CLDAM1', 'Cloud Amt  Lvl 1', 'Cloud  amount of the lowest layer', 1.00, '8.00', '0.00', 'Octas', 'hourly\r', 0, 0),
	(117, 'TYPCO1', 'Cloud Type  Low', 'Cloud  type Low', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(118, 'CLDHT1', 'Cloud Height  Lvl 1', 'Cloud  height of the lowest layer', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(119, 'CLDOP1', 'Cloud Opacity  Lvl1', 'Cloud  opacity of the lowest layer', 1.00, '', '', 'Octas', 'hourly\r', 0, 0),
	(120, 'CLDAM2', 'Cloud Amt  Lvl 2', 'Cloud  amount of the second layer', 1.00, '8.00', '0.00', 'Octas', 'hourly\r', 0, 0),
	(121, 'CLDTY2', 'Cloud Type  Lvl 2', 'Cloud  type of the second layer', 1.00, '9.00', '0.00', 'Coded', 'hourly\r', 0, 0),
	(122, 'CLDHT2', 'Cloud Height  Lvl 2', 'Cloud  height of the second layer', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(123, 'CLDOP2', 'Cloud Opacity  lvl2', 'Cloud  opacity of the second layer', 1.00, '', '', 'Octas', 'hourly\r', 0, 0),
	(124, 'CLDAM3', 'Cloud Amt  Lvl 3', 'Cloud  amount of the third layer', 1.00, '8.00', '0.00', 'Octas', 'hourly\r', 0, 0),
	(125, 'CLDTY3', 'Cloud Type  Lvl 3', 'Cloud  type of the third layer', 1.00, '9.00', '0.00', 'Coded', 'hourly\r', 0, 0),
	(126, 'CLDHT3', 'Cloud Height  Lvl 3', 'Cloud  height of the third layer', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(127, 'CLDOP3', 'Cloud Opacity  Lvl3', 'Cloud  opacity of the third layer', 1.00, '', '', 'Octas', 'hourly\r', 0, 0),
	(128, 'CLDAM4', 'Cloud Amt  Lvl 4', 'Cloud  amount of the fourth layer', 1.00, '', '', 'Octas', 'hourly\r', 0, 0),
	(129, 'CLDTY4', 'Cloud Type  Lvl 4', 'Cloud  type of the fourth layer', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(130, 'CLDHT4', 'Cloud Height  Lvl 4', 'Cloud  height of the fourth layer', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(131, 'CLDAP4', 'Cloud Opacity  Lvl4', 'Cloud  opacity of the fourth layer', 1.00, '', '', 'Octas', 'hourly\r', 0, 0),
	(132, 'SUN', 'Sunshine Hly Tot', 'Sunshine  total hourly', 1.00, '', '', 'Minutes', 'hourly\r', 0, 0),
	(133, 'RADGLS', 'Radiation Global', 'Radiation  global solar', 0.10, '', '', 'Megajoules/M**2', 'hourly\r', 0, 0),
	(134, 'RADSKY', 'Radiation  Sky', 'Radiation  sky', 0.10, '', '', 'Megajoules/M**2', 'hourly\r', 0, 0),
	(135, 'RADRES', 'Radiation  Reflected', 'Radiation  reflected solar', 0.10, '', '', 'Megajoules/M**2', 'hourly\r', 0, 0),
	(136, 'RADNAW', 'Radiation  Net All Wave', 'Radiation  net all wave', 0.10, '', '', 'Megajoules/M**2', 'hourly\r', 0, 0),
	(137, 'RADDWN', 'Radiation  Totol Down', 'Radiation  total downward', 0.01, '', '', 'Megajoules/M**2', 'hourly\r', 0, 0),
	(138, 'RADUP', 'Radiation  Total Up', 'Radiation  total upward', 0.10, '', '', 'Megajoules/M**2', 'hourly\r', 0, 0),
	(139, 'RADDSL', 'Radiation Direct', 'Radiation  direct solar', 0.10, '', '', 'Megajoules/M**2', 'hourly\r', 0, 0),
	(140, 'TORN', 'Weather-Tornado', 'Weather  tornado  1=Tornado  2=Funnel', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(141, 'THUNDR', 'Weather-Thunder', 'Weather  thunderstorms', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(142, 'RAIN', 'Weather-Rain', 'Weather  rain', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(143, 'RNSHW', 'Weather-Showers', 'Weather  rain showers', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(144, 'DRZZL', 'Weather-Drizzle', 'Weather  drizzle', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(145, 'FRZRN', 'Weather-Frz Rain', 'Weather  freezing rain', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(146, 'FRZDRZ', 'Weather-Frz Driz', 'Weather  freezing drizzle', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(147, 'SNOW', 'Weather-Snow', 'Weather  snow', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(148, 'SNWSHW', 'Weather-Snow-Shwr', 'Weather  snow showers', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(149, 'SNWGRN', 'Weather-Snow-Grn', 'Weather  snow grains', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(150, 'ICE', 'Weather-Ice-Crys', 'Weather  ice crystals', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(151, 'ICEPLT', 'Weather-Ice-Pell', 'Weather  ice pellets', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(152, 'HAIL', 'Weather-Hail', 'Weather  hail', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(153, 'FOG', 'Weather-Fog', 'Weather  fog', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(154, 'ICEFOG', 'Weather-Ice Fog', 'Weather  ice fog', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(155, 'SMOKE', 'Weather-Smoke', 'Weather  smoke', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(156, 'HAZE', 'Weather-Haze', 'Weather  haze', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(157, 'BLWSNW', 'Weather-Blw-Snow', 'Weather  blowing snow', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(158, 'BLWSND', 'Weather-Blw-Sand', 'Weather  blowing sand', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(159, 'BLWDST', 'Weather-Blw-Dust', 'Weather  blowing dust', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(160, 'SQUALL', 'Weather-Squall', 'Weather  squall', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(161, 'RAINSQ', 'Weather-Rain Sq', 'Weather  rain squall', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(162, 'SNOWSQ', 'Weather-Snow Sq', 'Weather  snow squall', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(163, 'SNOWPL', 'Weather-Snow pel', 'Weather  snow pellets', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(164, 'GRDFOG', 'Weather-Grnd fog', 'Weather  ground fog', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(165, 'GLAZE', 'Weather-Glaze', 'Weather  glaze', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(166, 'VAPPSR', 'Vapor Pressure', 'Vapor Pressure', 0.10, '', '', 'Hectopascals', 'hourly\r', 0, 0),
	(167, 'PRSWX', 'Present Weather', 'Present Weather (WMO Synoptic Code)', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(168, 'CLD-1', 'Cloud Amt Type Height Lvl1', 'Cloud  amount type height level 1 (WMO code)', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(169, 'CLD-2', 'Cloud Amt Type Height Lvl2', 'Cloud  amount type height level 2 (WMO code)', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(170, 'CLD-3', 'Cloud Amt Type Height Lvl3', 'Cloud  amount type height level 3 (WMO code)', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(171, 'CLD-4', 'Cloud Amt Type Height Lvl4', 'Cloud  amount type height level 4 (WMO code)', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(172, 'MIXRAT', 'Mixing Ratio', 'Mixing ratio', 1.00, '', '', 'Grams/KG', 'hourly\r', 0, 0),
	(173, '15PRCP', 'Precip  Tot 15 Min', 'Precipitation  total 15 minute', 0.10, '', '', 'Millimeters', 'hourly\r', 0, 0),
	(174, '3HPRCP', 'Precip  Tot 3 Hours', 'Precipitation  total 3 hourly', 0.10, '1000.00', '0.00', 'Millimeters', 'hourly\r', 0, 0),
	(175, 'TMP005', 'Temp  Soil05 Hly', 'Temperature  soil  hourly at 5 cm', 0.10, '', '', 'Degrees C', 'hourly\r', 0, 0),
	(176, 'TMP010', 'Temp  Soil10 Hly', 'Temperature  soil  hourly at 10 cm', 0.10, '', '', 'Degrees C', 'hourly\r', 0, 0),
	(177, 'TMP020', 'Temp  Soil20 Hly', 'Temperature  soil  hourly at 20 cm', 0.10, '', '', 'Degrees C', 'hourly\r', 0, 0),
	(178, 'TMP030', 'Temp  Soil30 Hly', 'Temperature  soil  hourly at 30 cm', 0.10, '', '', 'Degrees C', 'hourly\r', 0, 0),
	(179, 'TMP060', 'Temp  Soil60 Hly', 'Temperature  soil  hourly at 60 cm', 0.10, '', '', 'Degrees C', 'hourly\r', 0, 0),
	(180, 'TMP120', 'Temp  Soil120 Hly', 'Temperature  soil  hourly at 120 cm', 0.10, '', '', 'Degrees C', 'hourly\r', 0, 0),
	(181, 'WINDSPDAVG', 'Wind  Spd  Avg Hly', 'Wind speed  hourly average', 0.10, '', '', 'Knots', 'hourly\r', 0, 0),
	(182, 'TMP200', 'Temp  Soil200 Hly', 'Temperature  soil  hourly at 200 cm', 0.10, '', '', 'Degrees C', 'hourly\r', 0, 0),
	(183, 'THMGRF', 'Temp  THMGRF Hly', 'Temperature of Thermograph', 0.10, '', '', 'Degrees C', 'hourly\r', 0, 0),
	(184, 'RHHYGR', 'RH  Hygrograph Hly', 'Relative humidity hygrograph', 1.00, '100.00', '0.00', 'Percent', 'hourly\r', 0, 0),
	(185, 'PREGPM', 'Pressure  GPM', 'Reduced Pressure  Geopotential Metres', 1.00, '', '', 'Hectopascals', 'hourly\r', 0, 0),
	(186, 'PREQNH', 'Pressure  QNH', 'Reduced Pressure  QNH', 1.00, '', '', 'Hectopascals', 'hourly\r', 0, 0),
	(187, 'WINTOT', 'Wind Mileage Total', 'Wind mileage  Total', 1.00, '', '', 'Kilometers', 'hourly\r', 0, 0),
	(190, 'CLDTY1', 'Cloud Type  Lvl 1', 'Cloud  type of the lowest layer', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(191, 'LCLOUD', 'Lowest Cloud', 'Amount of all CsubL or if no CsubL  amount of CsubM', 1.00, '', '', 'Octas', 'hourly\r', 0, 0),
	(192, 'LCHGHT', 'Cloud Height Lowest Lvl', 'Cloud  height of the lowest layer', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(193, 'MCTYPE', 'Cloud  Medium Lvl  Type', 'Cloud  Medium Level Type', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(194, 'MCAMNT', 'Cloud medium Lvl Amnt', 'Cloud  Medium Level Amount', 1.00, '', '', 'Coded', 'hourly\r', 0, 0),
	(195, 'HCTYPE', 'Cloud  High Lvl Type', 'Cloud High Level Type', 1.00, '', '', 'Code', 'hourly\r', 0, 0),
	(196, 'HCAMNT', 'Cloud Amnt  High Lvl', 'Cloud Amount  High Level', 1.00, '8.00', '0.00', 'Octas', 'hourly\r', 0, 0),
	(197, 'MAXVIS', 'Visibility Max', 'Visibility  Maximum (00-89)', 1.00, '', '', 'Km', 'hourly\r', 0, 0),
	(198, 'MINVIS', 'Visibility  Min', 'Visibility  Minimum (00-89)', 1.00, '', '', 'Km', 'hourly\r', 0, 0),
	(199, 'MXTWNK', 'Twinkies  Max Dly', 'Twinkies  maximum daily ingestion rate  by running kilometer', 1.00, '', '', 'KM/Hour', 'hourly\r', 0, 0),
	(201, 'MNMXTM', 'Temp  Mean Max Dly', 'Temperature  monthly mean maximum daily', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(202, 'MNMNTM', 'Temp  Mean Min Dly', 'Temperature  monthly mean minimum daily', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(203, 'MNTMP', 'Temp Mean Mly', 'Temperature  monthly mean', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(204, 'XMXTMP', 'Temp Extreme Max', 'Temperature  extreme maximum monthly temperature', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(205, 'DMXTMP', 'Date of Extreme  Max', 'Date of the extreme maximum temperature', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(206, 'XMNTMP', 'Temp Extreme Min', 'Temperature  extreme minimum monthly temperature', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(207, 'DMNTMP', 'Date of Extreme Min', 'Date of the extreme minimum temperature', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(208, 'TOTPRC', 'Precip Total Mly', 'Precipitation  total monthly', 0.10, '', '', 'Millimeters', 'monthly\r', 0, 0),
	(209, 'TOTSNW', 'Snow  Total Mly', 'Snowfall  total monthly', 1.00, '', '', 'Centimeters', 'monthly\r', 0, 0),
	(210, 'MXPRCP', 'Precip  Max in the Month', 'Precipitation  greatest daily in the month', 0.10, '', '', 'Millimeters', 'monthly\r', 0, 0),
	(211, 'DMXPRC', 'Date of Max Precip', 'Date of the greatest daily precipitation', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(212, 'MXSNOW', 'Snowfall Max Dly', 'Snowfall  greatest daily in the month', 1.00, '', '', 'Centimeters', 'monthly\r', 0, 0),
	(213, 'DMXSNW', 'Date of Max Snow', 'Date of the greatest daily snowfall', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(214, 'EVAPPN', 'Evap  Pan  Mly', 'Evaporation  pan  total monthly', 0.10, '', '', 'Millimeters', 'monthly\r', 0, 0),
	(215, 'EVAPLK', 'Evap  Lake  Mly', 'Evaporation  lake  total monthly', 0.10, '', '', 'Millimeters', 'monthly\r', 0, 0),
	(216, 'MMXPAN', 'Temp  Evap Pan Mly Mean Max', 'Temperature  evap pan  monthly mean maximum daily', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(217, 'MMNPAN', 'Temp  Evap Pan Mly Mean Min', 'Temperature  evap pan  monthly mean minimum daily', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(218, 'MNPAN', 'Temp  Evap Pan Mly Mean  ', 'Temperature  evap pan  monthly mean', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(219, 'XMXPAN', 'Temp  Evap Pan Extreme Mly Max', 'Temperature  evap pan  extreme monthly maximum', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(220, 'DMXPAN', 'Date of Extreme Max Pan', 'Date of extreme max daily temp of evap pan', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(221, 'XMNPAN', 'Temp Evap  Pan Extreme Mly Min', 'Temperature  evap pan  extreme monthly minimum', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(222, 'DMNPAN', 'Date of Extreme Min Pan', 'Date of extreme min daily temp of evap pan', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(223, 'HDD1', 'HTNG Degree Days Tot Mly Base1', 'Heating degree days  total monthly - Base1', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(224, 'HDD2', 'HTNG Degree Days Total Mly Base2', 'Heating degree days  total monthly - Base2', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(225, 'CDD1', 'CLNG Degree Tot Mly Base1', 'Cooling degree days  total monthly - Base1', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(226, 'CDD2', 'CLNG Degree Tot Mly Base2', 'Cooling degree days  total monthly - Base2', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(227, 'GDD1', 'GRNG Degree Days Tot Mly Base1', 'Growing degree days  total monthly - Base1', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(228, 'GDD2', 'GRNG Degree Days Tot Mly Base2', 'Growing degree days  total monthly - Base2', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(229, 'DYRAIN', 'Days with Rain', 'Days  number with rainfall', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(230, 'DYTHND', 'Days with Thunder', 'Days  number with thunderstorms', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(231, 'DYHAIL', 'Days with Hail', 'Days  number with hail', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(232, 'DYFOG', 'Days with Fog', 'Days  number with fog', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(233, 'DYSAND', 'Days with Dust', 'Days  number with blowing sand or dust', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(234, 'DYSMOK', 'Days with Smoke', 'Days  number with smoke or thick haze', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(235, 'DYSNOW', 'Days with Snow', 'Days  number with snow', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(236, 'DYBSNW', 'Days with Blw snow ', 'Days  number with blowing snow', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(237, 'DYWND1', 'Days wth wind > 10', 'Days  number with wind greater than 10 m/sec', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(238, 'DYWND5', 'Days wth wind >15', 'Days  number with wind greater than 15 m/sec', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(239, 'DYGLAZ', 'Days with Glaze', 'Days  number with glaze(freezing rain)', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(240, 'DYTML1', 'Days temp < 1', 'Days  number with temp less than base 1', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(241, 'DYTML2', 'Days temp < 2', 'Days  number with temp less than base 2', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(242, 'DYTML3', 'Days temp < 3', 'Days  number with temp less than base 3', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(243, 'DYTMG1', 'Days temp > 1', 'Days  number with temp greater than base 1', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(244, 'DYTMG2', 'Days temp > 2', 'Days  number with temp greater than base 2', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(245, 'DYTMG3', 'Days temp > 3', 'Days  number with temp greater than base 3', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(246, 'DYPRG1', 'Days precip > 1', 'Days  number with precip greater than base 1', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(247, 'DYPRG2', 'Days precip > 2', 'Days  number with precip greater than base 2', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(248, 'DYPRG3', 'Days precip > 3', 'Days  number with precip greater than base 3', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(249, 'MNMXDP', 'Temp Dew Point Mean Max Mly', 'Temperature  dew point  mean maximum monthly', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(250, 'MNMNDP', 'Temp Dew Point Mean Min Mly', 'Temperature  dew point  mean minimum monthly', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(251, 'MNDP', 'Temp Dew Point Mean Mly', 'Temperature  dew point  mean monthly', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(252, 'EXMXDP', 'Temp  Dew Point Max Mly ', 'Temperature  dew point  extreme monthly maximum', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(253, 'DXMXDP', 'Date Extreme Mx  Dew Point Mly', 'Date of extreme maximum monthly dewpoint', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(254, 'EXMNDP', 'Temp  Dew Point Mly Min', 'Temperature  dew point  extreme monthly minimum', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(255, 'DXMNDP', 'Date Extreme  Min Dew Point  Mly', 'Date of extreme minimum monthly dewpoint', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(256, 'MNMXRH', 'RH  Mean Max', 'Relative humidity  mean maximum monthly', 1.00, '100.00', '0.00', 'Percent', 'monthly\r', 0, 0),
	(257, 'MNMNRH', 'RH  Mean Min', 'Relative humidity  mean minimum monthly', 1.00, '100.00', '0.00', 'Percent', 'monthly\r', 0, 0),
	(258, 'MNRH', 'RH  Mean Mly', 'Relative humidity  mean monthly', 1.00, '100.00', '0.00', 'Percent', 'monthly\r', 0, 0),
	(259, 'EXMXRH', 'RH  Extreme Max Mly', 'Relative humidity  extreme monthly maximum', 1.00, '100.00', '0.00', 'Percent', 'monthly\r', 0, 0),
	(260, 'DXMXRH', 'Date Extreme Mx RH', 'Date of extreme maximum monthly relative humidity', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(261, 'EXMNRH', 'RH  Extreme Min Mly', 'Relative humidity  extreme monthly minimum', 1.00, '100.00', '0.00', 'Percent', 'monthly\r', 0, 0),
	(262, 'DXMNRH', 'Date Extreme Min RH Mly', 'Date of extreme minimum monthly relative  humidity', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(263, 'EVAPMX', 'Evap  Max Dly', 'Evaporation  greatest daily in the month', 0.10, '', '', 'Millimeters', 'monthly\r', 0, 0),
	(264, 'DMXEVP', 'Date of Max Evap', 'Date of the greatest daily evaporation in the month', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(265, 'MYTORN', 'Days with tornado', 'Days  number with tornado', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(266, 'MYICEP', 'Days with Ice Plt', 'Days with ice pellets', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(267, 'MYGDRZ', 'Days with Drizzle', 'Days with drizzle', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(268, 'MLYSUN', 'Sunshine  Mly Tot', 'Sunshine  Monthly total', 0.10, '', '', 'Hours', 'Monthly', 0, 0),
	(269, 'MSOIL8', 'Temp  Soil300 Mean Mly', 'Temperature  soil  monthly mean at 300 cm', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(270, 'MSOIL7', 'Temp  Soil200 Mean Mly', 'Temperature  soil  monthly mean at 200 cm', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(271, 'MSOIL6', 'Temp  soil150 Mean Mly', 'Temperature  soil  monthly mean at 150 cm', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(272, 'MSOL1M', 'Temp  soil100 Mean Mly', 'Temperature  soil  monthly mean at 100 cm', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(273, 'MSOL50', 'Temp  soil50 Mean  Mly', 'Temperature  soil  monthly mean at 50 cm', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(274, 'MSOL20', 'Temp  soil20 Mean Mly', 'Temperature  soil  monthly mean at 20 cm', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(275, 'MSOL10', 'Temp  soil10 Mean Mly', 'Temperature  soil  monthly mean at 10 cm', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(276, 'MSOL05', 'Temp  soil05 Mean Mly', 'Temperature  soil  monthly mean at 5 cm', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(281, '24hVPD', '24 Hr Mean Mly VPD ', 'Mean monthly 24 hour Vapour Pressure Deficit', 0.10, '', '', 'Hectopascals', 'monthly\r', 0, 0),
	(286, 'GMnMMn', 'GrMin Mly Mean', 'Ground Minimum monthly mean', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(287, 'AbGMnM', 'Extreme GrMinAbs', 'Extreme Gr Minimum (Absolute)', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(288, 'DEGRMN', 'Day of Ext Gr Min', 'Day of Extreme (Absolute) Ground Minimum', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(289, 'DHGRMN', 'Days of Highest Gr Min', 'Day of Highest Ground Minimum', 1.00, '', '', 'Unitless', 'monthly\r', 0, 0),
	(290, 'HTGRMN', 'Highest Ground Min', 'Highest Ground Minimum', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(294, 'CLMDly', 'Cloud Mean Dly', 'Mean Daily Cloud amount for the month', 0.10, '', '', 'Octas', 'monthly\r', 0, 0),
	(295, 'RadMnD', 'Rad Mean Dly', 'Daily Mean Total radiation for the month', 0.10, '', '', 'Megajoules/M**2', 'monthly\r', 0, 0),
	(296, 'WETBMO', 'Temp WetBulb Mly', 'Mean wet bulb temperature for the month', 0.10, '', '', 'Degrees C', 'monthly\r', 0, 0),
	(297, 'WiSpMo', 'Wind Speed Mly', 'Mean wind speed in the month  cup counter or anemog', 0.10, '', '', 'Knots', 'monthly\r', 0, 0),
	(298, 'VPDMnM', 'Mean Monthly VPD', 'Mean monthly VPD', 0.10, '', '', 'Hectopascals', 'monthly\r', 0, 0),
	(299, 'PreSta', 'Pressure Station Mean Mly', 'Monthly mean station level pressure', 0.10, '', '', 'Hectopascals', 'monthly\r', 0, 0),
	(301, 'PRESS', 'Pressure Level', 'Pressure level', 1.00, '', '', 'Hectopascals', 'monthly\r', 0, 0),
	(302, 'HEIGHT', 'Height of Pressure Level', 'Height of pressure level', 1.00, '2000.00', '0.00', 'Meters', 'monthly\r', 0, 0),
	(303, 'TEMPDB', 'Temp at Press Lvl', 'Temperature at pressure level', 0.10, '500.00', '-600.00', 'Degrees C', 'monthly\r', 0, 0),
	(304, 'DPTDEP', 'Dew Point Depress at Press Lvl', 'Dew point depression at pressure level', 0.10, '200.00', '0.00', 'Degrees C', 'monthly\r', 0, 0),
	(305, 'WNDDIR', 'Wind Dir at Press Lvl', 'Wind direction at pressure level', 1.00, '360.00', '0.00', 'Degrees C', 'monthly\r', 0, 0),
	(306, 'WNDSPD', 'Wind Spd at Pressure Lvl', 'Wind speed at pressure level', 1.00, '300.00', '0.00', 'Knots', 'monthly\r', 0, 0),
	(399, 'PRESSTEND', 'Press Tendancy  24 Hly', 'Pressure Tendancy  24 hly', 0.10, '100.00', '-100.00', 'Hectopascals', 'Monthly', 0, 0),
	(400, '3HRPPPCHANGE', '3 Hr Pressure Change', 'Three hour pressure change', 0.10, '', '', 'Hecto Pascal', 'hourly', 0, 0),
	(401, 'MNMXTM', '10 Days Temp  Mean Max Dly', 'Temperature  10 day mean maximum daily', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(402, 'MNMNTM', '10 Days Temp  Mean Min Dly', 'Temperature  10 day mean minimum daily', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(403, 'MNTMP', '10 Days Temp Mean Dly', 'Temperature  10 day mean', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(404, 'XMXTMP', '10 Days Temp Extreme Max', 'Temperature  extreme maximum 10 day ', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(405, 'DMXTMP', 'Date of Extreme Temp Max 10 Days', 'Date of the extreme maximum 10 day temperature', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(406, 'XMNTMP', '10 Days Temp Extreme Min', 'Temperature  extreme minimum 10 day', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(407, 'DMNTMP', 'Date of Extreme Temp Min 10 Days', 'Date of the extreme minimum 10 day temperature', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(408, 'TOTPRC', 'Precip Total 10 Days', 'Precipitation  total 10 day', 0.10, '', '', 'Millimeters', 'dekadal\r', 0, 0),
	(409, 'TOTSNW', 'Snow  Total 10 Days', 'Snowfall  total 10 day', 1.00, '', '', 'Centimeters', 'dekadal\r', 0, 0),
	(410, 'MXPRCP', 'Precip  Max Dly 10 Days', 'Precipitation  greatest daily in the 10 day period', 0.10, '', '', 'Millimeters', 'dekadal\r', 0, 0),
	(411, 'DMXPRC', 'Date of Max Precip 10 Days', 'Date of the greatest daily precipitation in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(412, 'MXSNOW', 'Snowfall Max Dly 10 Days', 'Snowfall  greatest daily in the 10 day period', 1.00, '', '', 'Centimeters', 'dekadal\r', 0, 0),
	(413, 'DMXSNW', 'Date of Max Dly Snow 10 Days', 'Date of the greatest daily snowfall in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(414, 'EVAPPN', 'Evap  Pan  Tot  10 Days', 'Evaporation  pan  total 10 day', 0.10, '', '', 'Millimeters', 'dekadal\r', 0, 0),
	(415, 'EVAPLK', 'Evap  Lake  Tot 10 Days', 'Evaporation  lake  total 10 day', 0.10, '', '', 'Millimeters', 'dekadal\r', 0, 0),
	(416, 'MMXPAN', 'Temp  Evap Pan Mean Max Dly 10 Days', 'Temperature  evap pan  10 day mean maximum daily', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(417, 'MMNPAN', 'Temp  Evap Pan Mean Min Dly 10 Days', 'Temperature  evap pan  10 day mean minimum daily', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(418, 'MNPAN', 'Temp  Evap Pan  Mean 10 Days', 'Temperature  evap pan  10 day mean', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(419, 'XMXPAN', 'Temp  Evap Pan Ext Max 10 Days', 'Temperature  evap pan  extreme 10 day maximum', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(420, 'DMXPAN', 'Date of Extreme Max Evap Pan 10 Days', 'Date of extreme max 10 day temp of evap pan', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(421, 'XMNPAN', 'Temp  Evap Pan Extreme Min 10 Days', 'Temperature  evap pan  extreme 10 day minimum', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(422, 'DMNPAN', 'Date of Extreme  Evap Pan Min In 10 Days', 'Date of extreme min 10 day temp of evap pan', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(423, 'HDD1', 'HTNG Degree Days Tot 10 Days Base1', 'Heating degree days  total 10 day - Base1', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(424, 'HDD2', 'HTNG Degree Days Tot 10 Days Base2', 'Heating degree days  total 10 day - Base2', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(425, 'CDD1', 'CLNG Degree Tot 10 Days Base1', 'Cooling degree days  total 10 day - Base1', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(426, 'CDD2', 'CLNG Degree Tot 10 Days Base2', 'Cooling degree days  total 10 day - Base2', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(427, 'GDD1', 'GRWG Degree Days Tot 10 Days Base1', 'Growing degree days  total 10 day - Base1', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(428, 'GDD2', 'GRWG Degree Days Tot 10 Days Base2', 'Growing degree days  total 10 day - Base2', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(429, 'DYRAIN', 'Days with Rain In 10 Days', 'Days  number with rainfall in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(430, 'DYTHND', 'Days with Thunder In 10 Days', 'Days  number with thunderstorms in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(431, 'DYHAIL', 'Days with Hail in 10 Days', 'Days  number with hail in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(432, 'DYFOG', 'Days with Fog In 10 Days', 'Days  number with fog in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(433, 'DYSAND', 'Days with Dust In 10 Days', 'Days  number with blowing sand or dust in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(434, 'DYSMOK', 'Days with Smoke In 10 Days', 'Days  number with smoke or thick haze in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(435, 'DYSNOW', 'Days with Snow In 10 Days', 'Days  number with snow in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(436, 'DYBSNW', 'Days with Blow snow In 10 Days', 'Days  number with blowing snow in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(437, 'DYWND1', 'Days wth wind >10 In 10 Days', 'Days  number with wind greater than 10 m/sec in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(438, 'DYWND5', 'Days wth wind >15 In 10 Days', 'Days  number with wind greater than 15 m/sec in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(439, 'DYGLAZ', 'Days with Glaze In 10 Days', 'Days  number with glaze (freezing rain) in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(440, 'DYTML1', 'Days with Temp < 1 In 10 Days', 'Days  number with temp less than base 1 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(441, 'DYTML2', 'Days with Temp < 2 In 10 Days', 'Days  number with temp less than base 2 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(442, 'DYTML3', 'Days  with Temp < 3 In 10 Days', 'Days  number with temp less than base 3 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(443, 'DYTMG1', 'Days with Temp > 1 In 10 Days', 'Days  number with temp greater than base 1 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(444, 'DYTMG2', 'Days with Temp > 2 In 10 Days', 'Days  number with temp greater than base 2 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(445, 'DYTMG3', 'Days with Temp > 3 In 10 Days', 'Days  number with temp greater than base 3 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(446, 'DYPRG1', 'Days with Precip > 1 In 10 Days', 'Days  number with precip greater than base 1 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(447, 'DYPRG2', 'Days with Precip > 2 In 10 Days', 'Days  number with precip greater than base 2 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(448, 'DYPRG3', 'Days with Precip > 3 In 10 Days', 'Days  number with precip greater than base 3 in 10 days', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(449, 'MNMXDP', 'Temp  Dew Point Mean Max 10 Days', 'Temperature  dew point  mean maximum 10 day', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(450, 'MNMNDP', 'Temp  Dew Point Mean Min 10 Days', 'Temperature  dew point  mean minimum 10 day', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(451, 'MNDP', 'Temp  Dew Point Mean 10 Days', 'Temperature  dew point  mean 10 day', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(452, 'EXMXDP', 'Temp   Dew Point Extreme Max In 10 Days', 'Temperature  dew point  extreme 10 day maximum', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(453, 'DXMXDP', 'Date Extreme Max  Dew Point In 10 Days', 'Date of extreme maximum 10 day dewpoint', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(454, 'EXMNDP', 'Temp   Dew Point Extreme Min In 10 Days', 'Temperature  dew point  extreme 10 day minimum', 0.10, '', '', 'Degrees C', 'dekadal\r', 0, 0),
	(455, 'DXMNDP', 'Date Extreme Min  Dew Point In 10 Days', 'Date of extreme minimum 10 day dewpoint', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(456, 'MNMXRH', 'RH  Mean Max 10 Days', 'Relative humidity  mean maximum 10 day', 1.00, '100.00', '0.00', 'Percent', 'dekadal\r', 0, 0),
	(457, 'MNMNRH', 'RH  Mean Min 10 Days', 'Relative humidity  mean minimum 10 day', 1.00, '100.00', '0.00', 'Percent', 'dekadal\r', 0, 0),
	(458, 'MNRH', 'RH  Mean 10 Days', 'Relative humidity  mean 10 day', 1.00, '100.00', '0.00', 'Percent', 'dekadal\r', 0, 0),
	(459, 'EXMXRH', 'RH  Extreme Max 10 Days', 'Relative humidity  extreme 10 day maximum', 1.00, '100.00', '0.00', 'Percent', 'dekadal\r', 0, 0),
	(460, 'DXMXRH', 'Date Extreme RH Max in 10 Days', 'Date of extreme maximum 10 day relative humidity', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(461, 'EXMNRH', 'RH  Extreme Min 10 Days', 'Relative humidity  extreme 10 day minimum', 1.00, '100.00', '0.00', 'Percent', 'dekadal\r', 0, 0),
	(462, 'DXMNRH', 'Date Extreme RH Min in 10 Days', 'Date of extreme minimum 10 day relative humidity', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(463, 'EVAPMX', 'Evap  Max Dly In 10 Days', 'Evaporation  greatest daily in the 10 day period', 0.10, '', '', 'Millimeters', 'dekadal\r', 0, 0),
	(464, 'DMXEVP', 'Date of Max evap Dly In 10 Days', 'Date of the greatest daily evaporation in the 10 day period', 1.00, '', '', 'Unitless', 'dekadal\r', 0, 0),
	(477, 'EVAPPICHE', 'Evap Piche  Daily', 'Evaporation  Piche  daily', 0.10, '90.00', '0.00', 'Millimetres', 'daily\r', 0, 0),
	(478, 'GPM', 'GPM  Dly Avg', 'Geopotential height  daily average', 0.10, '', '', 'metres', 'daily\r', 0, 0),
	(500, 'PRECIP', 'Precip Dly  coded Synop', 'Precip daily  coded for synop', 1.00, '', '', 'Millimetres', 'synop\r', 0, 0),
	(503, 'TEMPDP12', 'Temp  Dew Point 12Z', 'Temperature  dew point at 12Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(504, 'PRECIPDR', 'Precip  Hours', 'Precipitation  total hours', 0.10, '', '', 'Hours', 'daily\r', 0, 0),
	(511, 'TEMPDB12', 'Temp  Dry Bulb 12Z', 'Temperature  dry bulb at 12 Z', 0.10, '460.00', '0.00', 'Degrees C', 'daily\r', 0, 0),
	(512, 'TEMPWB12', 'Temp  Wet bulb 12Z', 'Temperature  wet bulb at 12Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(513, 'WNDRN', 'Wind Mileage Dly', 'Wind mileage  daily', 1.00, '', '', 'Kilometers', 'daily\r', 0, 0),
	(515, 'RELHUM12', 'Relative Humidty 12Z', 'Relative humidity at 12Z', 1.00, '100.00', '0.00', 'Percent', 'daily\r', 0, 0),
	(518, 'EVAPPN2', 'Evap  Pan2 Daily', 'Evaporation  pan2  daily total', 0.10, '229.00', '0.00', 'Millimeters', 'daily\r', 0, 0),
	(530, 'TMPMNRST', 'Temp  Daily Min Reset', 'Temperature  daily minimum reset', 0.10, '400.00', '-70.00', 'Degrees C', 'daily\r', 0, 0),
	(531, 'TMPMXRST', 'Temp  Daily Max Reset', 'Temperature  daily maximum reset', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(532, 'SUNHRS', 'Sunshine  Hours', 'Sunshine  total hours', 0.10, '130.00', '0.00', 'Hours', 'daily\r', 0, 0),
	(541, 'SOILMST005', 'Soil  Moisture Daily05', 'Soil  Moisture daily at 5 cm', 0.10, '3610.00', '0.00', 'Millimeters', 'daily\r', 0, 0),
	(542, 'SOILMST100', 'Soil  Moisture Daily100', 'Soil  Moisture daily at 100 cm', 0.10, '500.00', '0.00', 'Millimeters', 'daily\r', 0, 0),
	(554, 'SOILT0530', 'Temp  Soil20  05Z', 'Temperature  soil  20 cm at 05Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(561, 'SOILT0905', 'Temp  Soil05 09Z', 'Temperature  soil  5 cm at 09Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(562, 'SOILT0910', 'Temp  soil10 09Z', 'Temperature  soil  10 cm at 09Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(563, 'SOILT0920', 'Temp  soil20 09Z', 'Temperature  soil  20 cm at 09Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(564, 'SOILT1305', 'Temp  soil05 13Z', 'Temperature  soil  5 cm at 13Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(565, 'SOILT1310', 'Temp  soil10 13Z', 'Temperature  soil  10 cm at 13Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(566, 'SOILT1320', 'Temp  soil20 13Z', 'Temperature  soil  20 cm at 13Z', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(600, 'OBSHGHT', 'Height  Observing Instrument', 'Observing instrument height above station elevation', 0.01, '', '', 'Metres', '\r', 0, 0),
	(806, 'RH06', 'RH  Daily 06Z', 'Relative Humidity  daily 06Z', 1.00, '100.00', '0.00', 'Percent', 'daily\r', 0, 0),
	(807, 'RH12', 'RH  Daily 12Z', 'Relative Humidity  daily 12Z', 1.00, '100.00', '0.00', 'Percent', 'daily\r', 0, 0),
	(810, 'TMPI06', 'Temp  Min 06Z', 'Temperature  minimum at 06Z', 0.10, '350.00', '-100.00', 'Degrees C', 'daily\r', 0, 0),
	(811, 'TMPI12', 'Temp  Min 12Z', 'Temperature  minimum at 12Z', 0.10, '350.00', '-100.00', 'Degrees C', 'daily\r', 0, 0),
	(812, 'A-PANB', 'Evap A_Pan Before', 'Evaporation  A_pan before', 1.00, '50.00', '0.00', 'milliliters', 'daily\r', 0, 0),
	(813, 'A-PANA', 'Evap A_Pan After', 'Evaporation  A_pan after', 1.00, '100.00', '0.00', 'milliliters', 'daily\r', 0, 0),
	(814, '3HRpppChar', '3Hr Pressure Characteristic', 'Three hour pressure characteristic', 1.00, '', '', 'Unitless', 'hourly', 0, 0),
	(850, '850GPM', '850Hp-GMP', 'Height of the 850 Hectopascal level in Geopotential Metres', 1.00, '2000.00', '1000.00', 'Meters', 'hourly\r', 0, 0),
	(851, 'PstWx', 'Past Weather W2', 'Past Weather W2 (WMO Synoptic Code)', 1.00, '', '', 'Unitless', 'hourly\r', 0, 0),
	(852, 'VPDHly', 'Vap Press Deficit', 'Hourly Vapour Pressure Deficit', 0.10, '', '', 'Hectopascals', 'hourly\r', 0, 0),
	(853, 'SOIL05', 'Temp  Soil05 Dly', 'Temperature  soil  daily at 5 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(854, 'SOIL10', 'Temp  Soil10 Dly', 'Temperature  soil  daily at 10 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(855, 'SOIL20', 'Temp  Soil20 Dly', 'Temperature  soil  daily at 20 cm', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(881, 'AWSTEMP', 'AWS  Air Temp', 'AWS  Air Temperature', 0.10, '21.80', '12.20', 'Deg Celcius', 'hourly\r', 0, 0),
	(882, 'AWSTMAX', 'AWS  Max Temp', 'AWS  Maximum Temperature', 0.10, '', '', 'Deg Celcius', 'hourly\r', 0, 0),
	(883, 'AWSTMIN', 'AWS  Min Temp', 'AWS  Minimum Temperature', 0.10, '', '', 'Deg Celcius', 'hourly\r', 0, 0),
	(884, 'AWSBARO', 'AWS  Baro Press', 'AWS  Barometric Pressure', 0.10, '', '', 'Millibars', 'hourly\r', 0, 0),
	(885, 'AWSDP', 'AWS  Dew Point Temp', 'AWS  Dew Point Temperature', 0.10, '', '', 'Celcius', 'hourly\r', 0, 0),
	(886, 'AWSGUSTSPD', 'AWS  GUST Speed', 'AWS  Wind Gust Speed', 0.10, '', '', ' m/s', 'hourly\r', 0, 0),
	(887, 'AWsGUSTDIR', 'AWS  GUST Direction', 'AWS  Wind Gust Direction', 0.10, '', '', 'Degrees', 'hourly\r', 0, 0),
	(888, 'AWSHRSSUN', 'AWS  Sun Hours', 'AWS  Sunshine Hours', 0.10, '', '', 'Hours', 'hourly\r', 0, 0),
	(889, 'AWSQFE', 'AWS  Station Pressure', 'AWS  Station Level Pressure', 0.10, '', '', 'Millibars', 'hourly\r', 0, 0),
	(890, 'AWSQFF', 'AWS  Actual Sea Lvl Pressure', 'AWS  Actual Sea Level Pressure', 0.10, '', '', 'Millibars', 'hourly\r', 0, 0),
	(891, 'AWSQNH', 'AWS  Std Sea Levl Pressure', 'AWS  Standard Sea Level Pressure', 0.10, '', '', 'Millibars', 'hourly\r', 0, 0),
	(892, 'AWSPRECIP', 'AWS Precip Cum', 'AWS  Precipitation Cumulative', 0.10, '', '', 'Millimetres', 'hourly\r', 0, 0),
	(893, 'AWSRH', 'AWS  RH', 'AWS  Relative Humidity', 0.10, '', '', 'Percentage', 'hourly\r', 0, 0),
	(894, 'AWSSOLRAD', 'AWS  Sol Rad', 'AWS  Solar Radiation', 0.10, '', '', 'Megajoules/M**2', 'hourly\r', 0, 0),
	(895, 'AWSWDA', 'AWS  Wind Dir Avg', 'AWS  Wind Direction Average', 1.00, '', '', 'Degrees', 'hourly\r', 0, 0),
	(896, 'AWSWDI', 'AWS  Wind Dir Inst', 'AWS  Wind Direction Instantaneous', 1.00, '', '', 'Degrees', 'hourly\r', 0, 0),
	(897, 'AWSWSA', 'AWS  Wind Spd Avg', 'AWS  Wind Speed Average', 0.10, '', '', 'Knots', 'hourly\r', 0, 0),
	(898, 'AWSWSI', 'AWS  Wind Spd Inst', 'AWS  Wind Speed Instantaneous', 0.10, '', '', 'Knots', 'hourly\r', 0, 0),
	(899, 'LEAFWET', 'Leaf Wetness', 'Leaf Wetness', 0.10, '', '', 'Min', 'hourly\r', 0, 0),
	(900, 'Eto', 'Evapotranspiration', 'Evapotranspiration', 0.10, '', '', 'Millimetres', 'hourly\r', 0, 0),
	(901, 'AWSTMPMN', 'AWS  Temp Dry Bulb Daily Mean', 'AWS  drybulb daily mean', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(902, 'AWSDPMN', 'AWS  Temp Dew Point Daily Mean', 'AWS  dewpoint daily mean', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(903, 'AWSSUNTOT', 'AWS  Sunshine Daily Total', 'AWS  sunshine daily total', 0.10, '', '', 'Hours', 'daily\r', 0, 0),
	(904, 'AWSPRESSMN', 'AWS  Mean Station Pressure', 'AWS  mean station pressure', 0.10, '', '', 'hPa', 'daily\r', 0, 0),
	(905, 'AWSMSLPMN', 'AWS  Daily Mean Station Pressure', 'AWS  daily mean station pressure', 0.10, '', '', 'hPa', 'daily\r', 0, 0),
	(907, 'AWSRHMN', 'AWS  RH Daily Mean', 'AWS  RH daily mean', 0.10, '', '', 'Perc', 'daily\r', 0, 0),
	(908, 'AWSRADMN', 'AWS  Solar Rad  Daily Total', 'AWS  solar rad  daily total', 0.10, '', '', 'Megajoules/M**2', 'daily\r', 0, 0),
	(909, 'AWSWSPDMN', 'AWS  Wind Spd Daily Avg', 'AWS  wind spd daily ave', 0.10, '', '', 'Knots', 'daily\r', 0, 0),
	(910, 'AWSTMAX', 'AWS  Temp Max Daily', 'AWS  Tmax daily', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(911, 'AWSTMIN', 'AWS  Temp Min Daily', 'AWS  Tmin daily', 0.10, '', '', 'Degrees C', 'daily\r', 0, 0),
	(912, 'AWSPRECIPT', 'AWS  Daily Precip Total', 'AWS  daily precip total', 0.10, '', '', 'millimetres', 'daily\r', 0, 0),
	(915, 'SOILMOIST', 'Soil Moisture', 'Soil Moisture', 0.10, '', '', 'm3/m3', 'AWS', 0, 0),
	(916, 'VAPPRESS', 'AWS Vapour Pressure ', 'Vapour Pressure', 0.10, '', '', 'Kpa', 'AWS', 0, 0),
	(917, 'WATRTEMP', 'Water Temperature', 'Water Temperature', 0.10, '', '', 'deg ceilcius', 'AWS', 0, 0),
	(918, 'WATRDPTH', 'Water Depth', 'Water Depth', 0.10, '', '', 'mm', 'AWS', 0, 0),
	(919, 'CONDCTVTY', 'Conductivity', 'Electrical Conductivity', 0.10, '', '', 'ms/cm', 'AWS', 0, 0);
/*!40000 ALTER TABLE `obselement` ENABLE KEYS */;


-- Dumping structure for table mariadb_climsoft_test_db_v4.observationfinal
CREATE TABLE IF NOT EXISTS `observationfinal` (
  `recordedFrom` varchar(255) NOT NULL,
  `describedBy` bigint(20) DEFAULT NULL,
  `obsDatetime` datetime DEFAULT NULL,
  `obsLevel` varchar(255) DEFAULT 'surface',
  `obsValue` decimal(8,2) DEFAULT NULL,
  `flag` varchar(255) DEFAULT 'N',
  `period` int(11) DEFAULT NULL,
  `qcStatus` int(11) DEFAULT '0',
  `qcTypeLog` text,
  `acquisitionType` int(11) DEFAULT '0',
  `dataForm` varchar(255) DEFAULT NULL,
  `capturedBy` varchar(255) DEFAULT NULL,
  `mark` tinyint(4) DEFAULT NULL,
  `temperatureUnits` varchar(255) DEFAULT NULL,
  `precipitationUnits` varchar(255) DEFAULT NULL,
  `cloudHeightUnits` varchar(255) DEFAULT NULL,
  `visUnits` varchar(255) DEFAULT NULL,
  `dataSourceTimeZone` int(11) DEFAULT '0',
  UNIQUE KEY `obsFinalIdentification` (`recordedFrom`,`describedBy`,`obsDatetime`),
  KEY `obsElementObservationInitial` (`describedBy`),
  KEY `stationObservationInitial` (`recordedFrom`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_obselement_observationFinal` FOREIGN KEY (`describedBy`) REFERENCES `obselement` (`elementId`),
  CONSTRAINT `FK_mysql_climsoft_db_v4_station_observationFinal` FOREIGN KEY (`recordedFrom`) REFERENCES `station` (`stationId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table mariadb_climsoft_test_db_v4.observationfinal: ~73,275 rows (approximately)
/*!40000 ALTER TABLE `observationfinal` DISABLE KEYS */;
INSERT INTO `observationfinal` (`recordedFrom`, `describedBy`, `obsDatetime`, `obsLevel`, `obsValue`, `flag`, `period`, `qcStatus`, `qcTypeLog`, `acquisitionType`, `dataForm`, `capturedBy`, `mark`, `temperatureUnits`, `precipitationUnits`, `cloudHeightUnits`, `visUnits`, `dataSourceTimeZone`) VALUES
	('67774010', 4, '2000-01-19 06:00:00', 'surface', 18.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-20 06:00:00', 'surface', 18.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-21 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-22 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-23 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-24 06:00:00', 'surface', 21.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-25 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-26 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-27 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-28 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-29 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-30 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-01-31 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-01 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-02 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-03 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-04 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-05 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-06 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-07 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-08 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-09 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-10 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-11 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-12 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-13 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-14 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-15 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-16 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-17 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-18 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-19 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-20 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-21 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-22 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-23 06:00:00', 'surface', 18.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-24 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-25 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-26 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-27 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-28 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-02-29 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-01 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-02 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-03 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-04 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-05 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-06 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-07 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-08 06:00:00', 'surface', 20.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-09 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-10 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-11 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-12 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-13 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-14 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-15 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-16 06:00:00', 'surface', 19.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-17 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-18 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-19 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-20 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-21 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-22 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-23 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-24 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-25 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-26 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-27 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-28 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-29 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-30 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-03-31 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-01 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-02 06:00:00', 'surface', 19.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-03 06:00:00', 'surface', 20.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-04 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-05 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-06 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-07 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-08 06:00:00', 'surface', 18.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-09 06:00:00', 'surface', 18.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-10 06:00:00', 'surface', 18.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-11 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-12 06:00:00', 'surface', 17.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-13 06:00:00', 'surface', 19.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-14 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-15 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-16 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-17 06:00:00', 'surface', 18.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-18 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-19 06:00:00', 'surface', 19.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-20 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-21 06:00:00', 'surface', 18.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-22 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-23 06:00:00', 'surface', 18.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-24 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-25 06:00:00', 'surface', 18.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-26 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-27 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-28 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-29 06:00:00', 'surface', 17.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-04-30 06:00:00', 'surface', 16.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-01 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-02 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-03 06:00:00', 'surface', 18.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-04 06:00:00', 'surface', 19.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-05 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-06 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-07 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-08 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-09 06:00:00', 'surface', 16.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-10 06:00:00', 'surface', 15.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-11 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-12 06:00:00', 'surface', 13.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-13 06:00:00', 'surface', 11.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-14 06:00:00', 'surface', 13.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-15 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-16 06:00:00', 'surface', 15.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-17 06:00:00', 'surface', 14.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-18 06:00:00', 'surface', 14.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-19 06:00:00', 'surface', 14.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-20 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-21 06:00:00', 'surface', 17.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-22 06:00:00', 'surface', 14.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-23 06:00:00', 'surface', 14.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-24 06:00:00', 'surface', 15.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-25 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-26 06:00:00', 'surface', 15.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-29 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-30 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-05-31 06:00:00', 'surface', 15.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-01 06:00:00', 'surface', 16.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-02 06:00:00', 'surface', 13.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-03 06:00:00', 'surface', 13.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-04 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-05 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-06 06:00:00', 'surface', 14.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-07 06:00:00', 'surface', 14.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-08 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-09 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-10 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-11 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-12 06:00:00', 'surface', 13.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-13 06:00:00', 'surface', 13.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-14 06:00:00', 'surface', 13.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-15 06:00:00', 'surface', 13.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-16 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-17 06:00:00', 'surface', 14.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-18 06:00:00', 'surface', 16.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-19 06:00:00', 'surface', 15.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-20 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-21 06:00:00', 'surface', 13.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-22 06:00:00', 'surface', 14.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-23 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-24 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-25 06:00:00', 'surface', 15.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-26 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 4, '2000-06-27 06:00:00', 'surface', 14.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-02 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-03 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-04 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-05 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-06 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-07 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-08 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-09 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-10 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-11 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-12 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-13 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-14 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-15 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-16 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-17 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-18 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-19 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-20 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-21 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-22 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-23 06:00:00', 'surface', 0.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-24 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-25 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-26 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-27 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-28 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-29 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-30 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-05-31 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-01 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-02 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-03 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-04 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-05 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-06 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-07 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-08 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-09 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-10 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-11 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-12 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-13 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-14 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-15 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-16 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-17 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-18 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-19 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-20 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-21 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-22 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-23 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-24 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-25 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-26 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-27 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-28 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-29 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-06-30 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-01 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-02 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-03 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-04 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-05 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-06 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-07 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-08 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-09 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-10 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-11 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-12 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-13 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-14 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-15 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-16 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-17 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-18 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-19 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-20 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-21 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-22 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-23 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-24 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-25 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-26 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-27 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-28 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-29 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-30 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-07-31 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-01 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-02 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-03 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-04 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-05 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-06 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-07 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-08 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-09 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-10 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-11 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-12 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-13 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-14 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 5, '1990-08-15 06:00:00', 'surface', 0.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-01 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-02 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-03 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-04 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-05 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-06 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-07 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-08 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-09 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-10 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-11 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-12 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-13 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-14 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-15 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-16 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-17 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-18 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-19 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-20 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-21 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-22 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-23 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-24 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-25 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-26 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-27 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-28 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-29 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-30 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-01-31 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-01 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-02 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-03 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-04 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-05 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-06 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-07 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-08 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-09 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-10 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-11 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-12 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-13 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-14 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-15 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-16 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-17 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-18 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-19 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-20 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-21 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-22 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-23 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-24 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-25 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-26 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-27 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-02-28 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-01 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-02 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-03 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-04 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-05 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-06 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-07 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-08 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-09 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-10 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-11 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-12 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-13 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-14 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-15 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-16 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-17 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-18 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-19 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-20 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-21 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-22 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-23 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-24 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-25 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-26 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-27 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-28 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-29 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-30 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-03-31 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-01 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-02 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-03 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-04 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-05 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-06 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-07 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-08 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-09 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-10 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-11 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-12 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-13 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-14 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-15 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-16 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-17 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-18 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-19 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-20 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-21 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-22 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-23 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-24 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-25 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-26 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-27 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-28 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-29 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-04-30 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-01 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-02 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-03 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-04 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-05 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-06 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-07 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-08 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-09 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-10 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-11 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-12 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-13 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-14 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-15 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-16 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-17 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-18 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-19 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-20 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-21 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-23 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-24 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-25 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-26 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-27 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-28 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-29 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-30 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-05-31 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-01 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-02 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-03 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-04 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-05 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-06 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-07 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-08 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-09 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-10 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-11 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-12 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-13 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-14 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-15 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-16 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-17 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-18 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-19 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-20 06:00:00', 'surface', 15.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-21 06:00:00', 'surface', 16.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-22 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-23 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-24 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-25 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-26 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-27 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-28 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-29 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-06-30 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-01 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-02 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-03 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-04 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-05 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-06 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-07 06:00:00', 'surface', 18.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-08 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-09 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-10 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-11 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-12 06:00:00', 'surface', 19.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-13 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-14 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-15 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-16 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-17 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-18 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-19 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-20 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-21 06:00:00', 'surface', 15.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-22 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-23 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-24 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-25 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-26 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-27 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-28 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-29 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-30 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-07-31 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-01 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-02 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-03 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-04 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-05 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-06 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-07 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-08 06:00:00', 'surface', 17.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-09 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-10 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-11 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-12 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-13 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-14 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-15 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-16 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-17 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-18 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-19 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-20 06:00:00', 'surface', 17.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-21 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-22 06:00:00', 'surface', 17.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-23 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-24 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-25 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-26 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-27 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-28 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-29 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-30 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-08-31 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-01 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-02 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-03 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-04 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-05 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-06 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-07 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-08 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-09 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-10 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-11 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-12 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-13 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-14 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-15 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-16 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-17 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-18 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-19 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-20 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-21 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-22 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-23 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-24 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-25 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-26 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-27 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-28 06:00:00', 'surface', 29.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-29 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-09-30 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-01 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-02 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-03 06:00:00', 'surface', 30.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-04 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-05 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-06 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-07 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-08 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-09 06:00:00', 'surface', 33.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-10 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-11 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-12 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-13 06:00:00', 'surface', 31.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-14 06:00:00', 'surface', 32.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-15 06:00:00', 'surface', 33.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-16 06:00:00', 'surface', 33.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-17 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-18 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-19 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-20 06:00:00', 'surface', 30.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-21 06:00:00', 'surface', 32.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-22 06:00:00', 'surface', 33.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-23 06:00:00', 'surface', 32.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-24 06:00:00', 'surface', 33.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-25 06:00:00', 'surface', 33.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-26 06:00:00', 'surface', 31.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-27 06:00:00', 'surface', 33.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-28 06:00:00', 'surface', 33.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-29 06:00:00', 'surface', 33.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-30 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-10-31 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-01 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-02 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-03 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-04 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-05 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-06 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-07 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-08 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-09 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-10 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-11 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-12 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-13 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-14 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-15 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-16 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-17 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-18 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-19 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-20 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-21 06:00:00', 'surface', 30.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-22 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-23 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-24 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-25 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-26 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-27 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-28 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-29 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-11-30 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-01 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-02 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-03 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-04 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-05 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-06 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-07 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-08 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-09 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-10 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-11 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-12 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-13 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-14 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-15 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-16 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-17 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-18 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-19 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-20 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-21 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-22 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-23 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-24 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-25 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-26 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-27 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-28 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-29 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-30 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1961-12-31 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-01 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-02 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-03 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-04 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-05 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-06 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-07 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-08 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-09 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-10 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-11 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-12 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-13 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-14 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-15 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-16 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-17 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-18 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-19 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-20 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-21 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-22 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-23 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-24 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-25 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-26 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-27 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-28 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-29 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-30 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-01-31 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-01 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-02 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-03 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-04 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-05 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-06 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-07 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-08 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-09 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-10 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-11 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-12 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-13 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-14 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-15 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-16 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-17 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-18 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-19 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-20 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-21 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-22 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-23 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-24 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-25 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-26 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-27 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-02-28 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-01 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-02 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-03 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-04 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-05 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-06 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-07 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-08 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-09 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-10 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-11 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-12 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-13 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-14 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-15 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-16 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-17 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-18 06:00:00', 'surface', 19.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-19 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-20 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-21 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-22 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-23 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-24 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-25 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-26 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-27 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-28 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-29 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-30 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-03-31 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-01 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-02 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-03 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-04 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-05 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-06 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-07 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-08 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-09 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-10 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-11 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-12 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-13 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-14 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-15 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-16 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-17 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-18 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-19 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-20 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-21 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-22 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-23 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-24 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-25 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-26 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-27 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-28 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-29 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-04-30 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-01 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-02 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-03 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-04 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-05 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-06 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-07 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-08 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-09 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-10 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-11 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-12 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-13 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-14 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-15 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-16 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-17 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-18 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-19 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-20 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-21 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-22 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-23 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-24 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-25 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-26 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-27 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-28 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-29 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-30 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-05-31 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-01 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-02 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-03 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-04 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-05 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-06 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-07 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-08 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-09 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-10 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-11 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-12 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-13 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-14 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-15 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-16 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-17 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-18 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-19 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-20 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-21 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-22 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-23 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-24 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-25 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-26 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-27 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-28 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-29 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-06-30 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-01 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-02 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-03 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-04 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-05 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-06 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-07 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-08 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-09 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-10 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-11 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-12 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-13 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-14 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-15 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-16 06:00:00', 'surface', 20.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-17 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-18 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-19 06:00:00', 'surface', 17.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-20 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-21 06:00:00', 'surface', 16.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-22 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-23 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-24 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-25 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-26 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-27 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-28 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-29 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-30 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-07-31 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-01 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-02 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-03 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-04 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-05 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-06 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-07 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-08 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-09 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-10 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-11 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-12 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-13 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-14 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-15 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-16 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-17 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-18 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-19 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-20 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-21 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-23 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-24 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-25 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-26 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-27 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-28 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-29 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-30 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-08-31 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-01 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-02 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-03 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-04 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-05 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-06 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-07 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-08 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-09 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-10 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-11 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-12 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-13 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-14 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-15 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-16 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-17 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-18 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-19 06:00:00', 'surface', 29.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-20 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-21 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-22 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-23 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-24 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-25 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-26 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-27 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-28 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-29 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-09-30 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-01 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-02 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-03 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-04 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-05 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-06 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-07 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-08 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-09 06:00:00', 'surface', 32.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-10 06:00:00', 'surface', 33.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-11 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-12 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-13 06:00:00', 'surface', 31.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-14 06:00:00', 'surface', 32.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-15 06:00:00', 'surface', 33.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-16 06:00:00', 'surface', 32.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-17 06:00:00', 'surface', 33.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-18 06:00:00', 'surface', 34.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-19 06:00:00', 'surface', 32.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-20 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-21 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-23 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-24 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-25 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-26 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-27 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-28 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-29 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-30 06:00:00', 'surface', 32.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-10-31 06:00:00', 'surface', 32.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-01 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-02 06:00:00', 'surface', 31.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-03 06:00:00', 'surface', 32.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-04 06:00:00', 'surface', 32.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-05 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-06 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-07 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-08 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-09 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-10 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-11 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-12 06:00:00', 'surface', 31.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-13 06:00:00', 'surface', 32.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-14 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-15 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-16 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-17 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-18 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-19 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-20 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-21 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-22 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-23 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-24 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-25 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-26 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-27 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-28 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-29 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-11-30 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-01 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-02 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-03 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-04 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-05 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-06 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-07 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-08 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-09 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-10 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-11 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-12 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-13 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-14 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-15 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-16 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-17 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-18 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-19 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-20 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-21 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-22 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-23 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-24 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-25 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-26 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-27 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-28 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-29 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-30 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1962-12-31 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-01 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-02 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-03 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-04 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-05 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-06 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-07 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-08 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-09 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-10 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-11 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-12 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-13 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-14 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-15 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-16 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-17 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-18 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-19 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-20 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-21 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-23 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-24 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-25 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-26 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-27 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-28 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-29 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-30 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-01-31 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-01 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-02 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-03 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-04 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-05 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-06 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-07 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-08 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-09 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-10 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-11 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-12 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-13 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-14 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-15 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-16 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-17 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-18 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-19 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-20 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-21 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-22 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-23 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-24 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-25 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-26 06:00:00', 'surface', 18.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-27 06:00:00', 'surface', 17.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-02-28 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-01 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-02 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-03 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-04 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-05 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-06 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-07 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-08 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-09 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-10 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-11 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-12 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-13 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-14 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-15 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-16 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-17 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-18 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-19 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-20 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-21 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-22 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-23 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-24 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-25 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-26 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-27 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-28 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-29 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-30 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-03-31 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-01 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-02 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-03 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-04 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-05 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-06 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-07 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-08 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-09 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-10 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-11 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-12 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-13 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-14 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-15 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-16 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-17 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-18 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-19 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-20 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-21 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-22 06:00:00', 'surface', 17.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-23 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-24 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-25 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-26 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-27 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-28 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-29 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-04-30 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-01 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-02 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-03 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-04 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-05 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-06 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-07 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-08 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-09 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-10 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-11 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-12 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-13 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-14 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-15 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-16 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-17 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-18 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-19 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-20 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-21 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-22 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-23 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-24 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-25 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-26 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-27 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-28 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-29 06:00:00', 'surface', 19.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-30 06:00:00', 'surface', 18.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-05-31 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-01 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-02 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-03 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-04 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-05 06:00:00', 'surface', 18.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-06 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-07 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-08 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-09 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-10 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-11 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-12 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-13 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-14 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-15 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-16 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-17 06:00:00', 'surface', 18.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-18 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-19 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-20 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-21 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-22 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-23 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-24 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-25 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-26 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-27 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-28 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-29 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-06-30 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-01 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-02 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-03 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-04 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-05 06:00:00', 'surface', 19.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-06 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-07 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-08 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-09 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-10 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-11 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-12 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-13 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-14 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-15 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-16 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-17 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-18 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-19 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-20 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-21 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-22 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-23 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-24 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-25 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-26 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-27 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-28 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-29 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-30 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-07-31 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-01 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-02 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-03 06:00:00', 'surface', 19.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-04 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-05 06:00:00', 'surface', 17.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-06 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-07 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-08 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-09 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-10 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-11 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-12 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-13 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-14 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-15 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-16 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-17 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-18 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-19 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-20 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-21 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-22 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-23 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-24 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-25 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-26 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-27 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-28 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-29 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-30 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-08-31 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-01 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-02 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-03 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-04 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-05 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-06 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-07 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-08 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-09 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-10 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-11 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-12 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-13 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-14 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-15 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-16 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-17 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-18 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-19 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-20 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-21 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-22 06:00:00', 'surface', 30.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-23 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-24 06:00:00', 'surface', 31.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-25 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-26 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-27 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-28 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-29 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-09-30 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-01 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-02 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-03 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-04 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-05 06:00:00', 'surface', 31.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-06 06:00:00', 'surface', 33.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-07 06:00:00', 'surface', 32.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-08 06:00:00', 'surface', 31.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-09 06:00:00', 'surface', 31.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-10 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-11 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-12 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-13 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-14 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-15 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-16 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-17 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-18 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-19 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-20 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-21 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-22 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-23 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-24 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-25 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-26 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-27 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-28 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-29 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-30 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-10-31 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-01 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-02 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-03 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-04 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-05 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-06 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-07 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-08 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-09 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-10 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-11 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-12 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-13 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-14 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-15 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-16 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-17 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-18 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-19 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-20 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-21 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-22 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-23 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-24 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-25 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-26 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-27 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-28 06:00:00', 'surface', 31.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-29 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-11-30 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-01 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-02 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-03 06:00:00', 'surface', 16.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-04 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-05 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-06 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-07 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-08 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-09 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-10 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-11 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-12 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-13 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-14 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-15 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-16 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-17 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-18 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-19 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-20 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-21 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-22 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-23 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-24 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-25 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-26 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-27 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-28 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-29 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-30 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1963-12-31 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-01 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-02 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-03 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-04 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-05 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-06 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-07 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-08 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-09 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-10 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-11 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-12 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-13 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-14 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-15 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-16 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-17 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-18 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-19 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-20 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-21 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-22 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-23 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-24 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-25 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-26 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-27 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-28 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-29 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-30 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-01-31 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-01 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-02 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-03 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-04 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-05 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-06 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-07 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-08 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-09 06:00:00', 'surface', 29.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-10 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-11 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-12 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-13 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-14 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-15 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-16 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-17 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-18 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-19 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-20 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-21 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-22 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-23 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-24 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-25 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-26 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-27 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-28 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-02-29 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-01 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-02 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-03 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-04 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-05 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-06 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-07 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-08 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-09 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-10 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-11 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-12 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-13 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-14 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-15 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-16 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-17 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-18 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-19 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-20 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-21 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-22 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-23 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-24 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-25 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-26 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-27 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-28 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-29 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-30 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-03-31 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-01 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-02 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-03 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-04 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-05 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-06 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-07 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-08 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-09 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-10 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-11 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-12 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-13 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-14 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-15 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-16 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-17 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-18 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-19 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-20 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-21 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-22 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-23 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-24 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-25 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-26 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-27 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-28 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-29 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-04-30 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-01 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-02 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-03 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-02 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-03 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-04 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-05 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-06 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-07 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-08 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-09 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-10 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-11 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-12 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-13 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-14 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-15 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-16 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-17 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-18 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-19 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-20 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-21 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-22 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-23 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-24 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-25 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-26 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-27 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-28 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-29 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-30 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-31 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-01 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-02 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-03 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-04 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-05 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-06 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-07 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-08 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-09 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-10 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-11 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-12 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-13 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-14 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-15 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-16 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-17 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-18 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-19 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-20 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-21 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-22 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-23 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-24 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-25 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-26 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-27 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-28 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-29 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-30 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-01-31 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-01 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-02 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-03 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-04 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-05 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-06 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-07 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-08 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-09 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-10 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-11 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-12 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-13 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-14 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-15 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-16 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-17 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-18 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-19 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-20 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-21 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-22 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-23 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-24 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-25 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-26 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-27 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-02-28 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-01 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-02 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-03 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-04 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-05 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-06 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-07 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-08 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-09 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-10 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-11 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-12 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-13 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-14 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-15 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-16 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-17 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-18 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-19 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-20 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-21 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-22 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-23 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-24 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-25 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-26 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-27 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-28 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-29 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-30 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-03-31 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-01 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-02 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-03 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-04 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-05 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-06 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-07 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-08 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-09 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-10 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-11 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-12 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-13 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-14 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-15 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-16 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-17 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-18 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-19 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-20 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-21 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-22 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-23 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-24 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-25 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-26 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-27 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-28 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-29 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-04-30 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-01 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-02 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-03 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-04 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-05 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-06 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-07 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-08 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-09 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-04 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-05 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-06 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-07 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-08 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-09 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-10 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-11 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-12 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-13 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-14 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-15 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-16 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-17 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-18 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-19 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-20 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-21 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-22 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-23 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-24 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-25 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-26 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-27 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-28 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-29 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-30 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-05-31 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-01 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-02 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-03 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-04 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-05 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-06 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-07 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-08 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-09 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-10 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-11 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-12 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-13 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-14 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-15 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-16 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-17 06:00:00', 'surface', 19.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-18 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-19 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-20 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-21 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-22 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-23 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-24 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-25 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-26 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-27 06:00:00', 'surface', 17.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-28 06:00:00', 'surface', 20.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-29 06:00:00', 'surface', 17.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-06-30 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-01 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-02 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-03 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-04 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-05 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-06 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-07 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-08 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-09 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-10 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-11 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-12 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-13 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-14 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-15 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-16 06:00:00', 'surface', 19.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-17 06:00:00', 'surface', 17.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-18 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-19 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-20 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-21 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-22 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-23 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-24 06:00:00', 'surface', 20.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-25 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-26 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-27 06:00:00', 'surface', 19.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-28 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-29 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-30 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-07-31 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-01 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-02 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-03 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-04 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-05 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-06 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-07 06:00:00', 'surface', 17.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-08 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-09 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-10 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-11 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-12 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-13 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-14 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-15 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-16 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-17 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-18 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-19 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-20 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-21 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-22 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-23 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-24 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-25 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-26 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-27 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-28 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-29 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-30 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-08-31 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-01 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-02 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-03 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-04 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-05 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-06 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-07 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-08 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-09 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-10 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-11 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-12 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-13 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-14 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-15 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-16 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-17 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-18 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-19 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-20 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-21 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-22 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-23 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-24 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-25 06:00:00', 'surface', 31.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-26 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-27 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-28 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-29 06:00:00', 'surface', 30.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-09-30 06:00:00', 'surface', 29.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-01 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-02 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-03 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-04 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-05 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-06 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-07 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-08 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-09 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-10 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-11 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-12 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-13 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-14 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-15 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-16 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-17 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-18 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-19 06:00:00', 'surface', 30.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-20 06:00:00', 'surface', 31.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-21 06:00:00', 'surface', 32.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-22 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-23 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-24 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-25 06:00:00', 'surface', 32.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-26 06:00:00', 'surface', 32.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-27 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-28 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-29 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-30 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-10-31 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-01 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-02 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-03 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-04 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-05 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-06 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-07 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-08 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-09 06:00:00', 'surface', 32.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-10 06:00:00', 'surface', 32.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-11 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-12 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-13 06:00:00', 'surface', 31.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-14 06:00:00', 'surface', 31.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-15 06:00:00', 'surface', 31.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-16 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-17 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-18 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-19 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-20 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-21 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-22 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-23 06:00:00', 'surface', 17.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-24 06:00:00', 'surface', 16.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-25 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-26 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-27 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-28 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-29 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-11-30 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1964-12-01 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-10 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-11 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-12 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-13 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-14 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-15 06:00:00', 'surface', 21.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-16 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-17 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-18 06:00:00', 'surface', 19.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-19 06:00:00', 'surface', 19.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-20 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-21 06:00:00', 'surface', 21.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-22 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-23 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-24 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-25 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-26 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-27 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-28 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-29 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-30 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-05-31 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-01 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-02 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-03 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-04 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-05 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-06 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-07 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-08 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-09 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-10 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-11 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-12 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-13 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-14 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-15 06:00:00', 'surface', 21.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-16 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-17 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-18 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-19 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-20 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-21 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-22 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-23 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-24 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-25 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-26 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-27 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-28 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-29 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-06-30 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-01 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-02 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-03 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-04 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-05 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-06 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-07 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-08 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-09 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-10 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-11 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-12 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-13 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-14 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-15 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-16 06:00:00', 'surface', 17.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-17 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-18 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-19 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-20 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-21 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-22 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-23 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-24 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-25 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-26 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-27 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-28 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-29 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-30 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-07-31 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-01 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-02 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-03 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-04 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-05 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-06 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-07 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-08 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-09 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-10 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-11 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-12 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-13 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-14 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-15 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-16 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-17 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-18 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-19 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-20 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-21 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-22 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-23 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-24 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-25 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-26 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-27 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-28 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-29 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-30 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-08-31 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-01 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-02 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-03 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-04 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-05 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-06 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-07 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-08 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-09 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-10 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-11 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-12 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-13 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-14 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-15 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-16 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-17 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-18 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-19 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-20 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-21 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-22 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-23 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-24 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-25 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-26 06:00:00', 'surface', 13.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-27 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-28 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-29 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-09-30 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-01 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-02 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-03 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-04 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-05 06:00:00', 'surface', 19.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-06 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-07 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-08 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-09 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-10 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-11 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-12 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-13 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-14 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-15 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-16 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-17 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-18 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-19 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-20 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-21 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-22 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-23 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-24 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-25 06:00:00', 'surface', 30.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-26 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-27 06:00:00', 'surface', 30.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-28 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-29 06:00:00', 'surface', 30.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-30 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-10-31 06:00:00', 'surface', 31.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-01 06:00:00', 'surface', 31.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-02 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-03 06:00:00', 'surface', 31.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-04 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-05 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-06 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-07 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-08 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-09 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-10 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-11 06:00:00', 'surface', 30.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-12 06:00:00', 'surface', 31.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-13 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-14 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-15 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-16 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-17 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-18 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-19 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-20 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-21 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-22 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-23 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-24 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-25 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-26 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-27 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-28 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-29 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-11-30 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-01 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-02 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-03 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-04 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-05 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-06 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-07 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-08 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-09 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-10 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-11 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-12 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-13 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-14 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-15 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-16 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-17 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-18 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-19 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-20 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-21 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-23 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-24 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-25 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-26 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-27 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-28 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-29 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-30 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1965-12-31 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-01 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-02 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-03 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-04 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-05 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-06 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-07 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-08 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-09 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-10 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-11 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-12 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-13 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-14 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-15 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-16 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-17 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-18 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-19 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-20 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-21 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-22 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-23 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-24 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-25 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-26 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-27 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-28 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-29 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-30 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-01-31 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-01 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-02 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-03 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-04 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-05 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-06 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-07 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-08 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-09 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-10 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-11 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-12 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-13 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-14 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-15 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-16 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-17 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-18 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-19 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-20 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-21 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-22 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-23 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-24 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-25 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-26 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-27 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-02-28 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-01 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-02 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-03 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-04 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-05 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-06 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-07 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-08 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-09 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-10 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-11 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-12 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-13 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-14 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-15 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-16 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-17 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-18 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-19 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-20 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-21 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-22 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-23 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-24 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-25 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-26 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-27 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-28 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-29 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-30 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-03-31 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-01 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-02 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-03 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-04 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-05 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-06 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-07 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-08 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-09 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-10 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-11 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-12 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-13 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-14 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-15 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-16 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-17 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-18 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-19 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-20 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-21 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-22 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-23 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-24 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-25 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-26 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-27 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-28 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-29 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-04-30 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-01 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-02 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-03 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-04 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-05 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-06 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-07 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-08 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-09 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-10 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-11 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-12 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-13 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-14 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-15 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-16 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-17 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-18 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-19 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-20 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-21 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-22 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-23 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-24 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-25 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-26 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-27 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-28 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-29 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-30 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-05-31 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-01 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-02 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-03 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-04 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-05 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-06 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-07 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-08 06:00:00', 'surface', 19.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-09 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-10 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-11 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-12 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-13 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-14 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-15 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-16 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-17 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-18 06:00:00', 'surface', 20.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-19 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-20 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-21 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-22 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-23 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-24 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-25 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-26 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-27 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-28 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-29 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-06-30 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-01 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-02 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-03 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-04 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-05 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-06 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-07 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-08 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-09 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-10 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-11 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-12 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-13 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-14 06:00:00', 'surface', 21.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-15 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-16 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-17 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-18 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-19 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-20 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-21 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-22 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-23 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-24 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-25 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-26 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-27 06:00:00', 'surface', 17.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-28 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-29 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-30 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-07-31 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-01 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-02 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-03 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-04 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-05 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-06 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-07 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-08 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-09 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-10 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-11 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-12 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-13 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-14 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-15 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-16 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-17 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-18 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-19 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-20 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-21 06:00:00', 'surface', 17.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-22 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-23 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-24 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-25 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-26 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-27 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-28 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-29 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-30 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-08-31 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-01 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-02 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-03 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-04 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-05 06:00:00', 'surface', 29.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-06 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-07 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-08 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-09 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-10 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-11 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-12 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-13 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-14 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-15 06:00:00', 'surface', 30.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-16 06:00:00', 'surface', 30.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-17 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-18 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-19 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-20 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-21 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-22 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-23 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-24 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-25 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-26 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-27 06:00:00', 'surface', 31.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-28 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-29 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-09-30 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-01 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-02 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-03 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-04 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-05 06:00:00', 'surface', 31.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-06 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-07 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-08 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-09 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-10 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-11 06:00:00', 'surface', 32.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-12 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-13 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-14 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-15 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-16 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-17 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-18 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-19 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-20 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-21 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-22 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-23 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-24 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-25 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-26 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-27 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-28 06:00:00', 'surface', 31.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-29 06:00:00', 'surface', 32.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-30 06:00:00', 'surface', 32.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-10-31 06:00:00', 'surface', 32.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-01 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-02 06:00:00', 'surface', 31.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-03 06:00:00', 'surface', 32.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-04 06:00:00', 'surface', 31.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-05 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-06 06:00:00', 'surface', 30.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-07 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-08 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-09 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-10 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-11 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-12 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-13 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-14 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-15 06:00:00', 'surface', 31.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-16 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-17 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-18 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-19 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-20 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-21 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-22 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-23 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-24 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-25 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-26 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-27 06:00:00', 'surface', 30.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-28 06:00:00', 'surface', 31.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-29 06:00:00', 'surface', 32.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-11-30 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-01 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-02 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-03 06:00:00', 'surface', 31.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-04 06:00:00', 'surface', 32.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-05 06:00:00', 'surface', 32.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-06 06:00:00', 'surface', 30.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-07 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-08 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-09 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-10 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-11 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-12 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-13 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-04 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-05 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-06 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-07 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-08 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-09 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-10 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-11 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-12 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-13 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-14 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-15 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-16 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-17 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-18 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-19 06:00:00', 'surface', 17.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-20 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-21 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-22 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-23 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-24 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-25 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-26 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-27 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-28 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-29 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-30 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-01 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-02 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-03 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-04 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-05 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-06 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-07 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-08 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-09 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-10 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-11 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-12 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-13 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-14 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-15 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-16 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-17 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-18 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-19 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-20 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-21 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-22 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-23 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-24 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-25 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-26 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-27 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-28 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-29 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-30 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-05-31 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-01 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-02 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-03 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-04 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-05 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-06 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-07 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-08 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-09 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-10 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-11 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-12 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-13 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-14 06:00:00', 'surface', 17.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-15 06:00:00', 'surface', 18.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-16 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-17 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-18 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-19 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-20 06:00:00', 'surface', 20.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-21 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-22 06:00:00', 'surface', 19.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-23 06:00:00', 'surface', 19.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-24 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-25 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-26 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-27 06:00:00', 'surface', 20.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-28 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-29 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-06-30 06:00:00', 'surface', 19.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-01 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-02 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-03 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-04 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-05 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-06 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-07 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-08 06:00:00', 'surface', 20.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-09 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-10 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-11 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-12 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-13 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-14 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-15 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-16 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-17 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-18 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-19 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-20 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-21 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-22 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-23 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-24 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-25 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-26 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-27 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-28 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-29 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-30 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-07-31 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-01 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-02 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-03 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-04 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-05 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-06 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-07 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-08 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-09 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-10 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-11 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-12 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-13 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-14 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-15 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-16 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-17 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-18 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-19 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-20 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-21 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-22 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-23 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-24 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-25 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-26 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-27 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-28 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-29 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-30 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-08-31 06:00:00', 'surface', 29.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-01 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-02 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-03 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-04 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-05 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-06 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-07 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-08 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-09 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-10 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-11 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-12 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-13 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-14 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-15 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-16 06:00:00', 'surface', 29.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-17 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-18 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-19 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-20 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-21 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-22 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-23 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-24 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-25 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-26 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-27 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-28 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-29 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-09-30 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-01 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-02 06:00:00', 'surface', 30.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-03 06:00:00', 'surface', 33.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-04 06:00:00', 'surface', 33.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-05 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-06 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-07 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-08 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-09 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-10 06:00:00', 'surface', 31.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-11 06:00:00', 'surface', 32.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-12 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-13 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-14 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-15 06:00:00', 'surface', 31.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-16 06:00:00', 'surface', 33.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-17 06:00:00', 'surface', 34.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-18 06:00:00', 'surface', 33.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-19 06:00:00', 'surface', 32.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-20 06:00:00', 'surface', 32.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-21 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-22 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-23 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-24 06:00:00', 'surface', 32.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-25 06:00:00', 'surface', 32.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-26 06:00:00', 'surface', 32.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-27 06:00:00', 'surface', 33.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-28 06:00:00', 'surface', 33.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-29 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-30 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-10-31 06:00:00', 'surface', 31.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-01 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-02 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-03 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-04 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-05 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-06 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-07 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-08 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-09 06:00:00', 'surface', 32.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-10 06:00:00', 'surface', 32.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-11 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-12 06:00:00', 'surface', 13.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-13 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-14 06:00:00', 'surface', 17.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-15 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-16 06:00:00', 'surface', 19.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-17 06:00:00', 'surface', 16.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-18 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-19 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-20 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-21 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-23 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-24 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-25 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-26 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-27 06:00:00', 'surface', 20.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-28 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-29 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-11-30 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-01 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-02 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-03 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-04 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-05 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-06 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-07 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-08 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-09 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-10 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-11 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-12 06:00:00', 'surface', 20.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-13 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-14 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-15 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-16 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-17 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-18 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-19 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-20 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-21 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-22 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-23 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-24 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-14 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-15 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-16 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-17 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-18 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-19 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-20 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-21 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-22 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-23 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-24 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-25 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-26 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-27 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-28 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-29 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-30 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1966-12-31 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-01 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-02 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-03 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-04 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-05 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-06 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-07 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-08 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-09 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-10 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-11 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-12 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-13 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-14 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-15 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-16 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-17 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-18 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-19 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-20 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-21 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-22 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-23 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-24 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-25 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-26 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-27 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-28 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-29 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-30 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-01-31 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-01 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-02 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-03 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-04 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-05 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-06 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-07 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-08 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-09 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-10 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-11 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-12 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-13 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-14 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-15 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-16 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-17 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-18 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-19 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-20 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-21 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-22 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-23 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-24 06:00:00', 'surface', 19.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-25 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-26 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-27 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-02-28 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-01 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-02 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-03 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-04 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-05 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-06 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-07 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-08 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-09 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-10 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-11 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-12 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-13 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-14 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-15 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-16 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-17 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-18 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-19 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-20 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-21 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-22 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-23 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-24 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-25 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-26 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-27 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-28 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-29 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-30 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-03-31 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-01 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-02 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-03 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-04 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-05 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-06 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-07 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-08 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-09 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-10 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-11 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-12 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-13 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-14 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-15 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-16 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-17 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-18 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-19 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-20 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-21 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-22 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-23 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-24 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-25 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-26 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-27 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-28 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-29 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-04-30 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-01 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-02 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-03 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-04 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-05 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-06 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-07 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-08 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-09 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-10 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-11 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-12 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-13 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-14 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-15 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-16 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-17 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-18 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-19 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-20 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-21 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-22 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-23 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-24 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-25 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-26 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-27 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-28 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-29 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-30 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-05-31 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-01 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-02 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-03 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-04 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-05 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-06 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-07 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-08 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-09 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-10 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-11 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-12 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-13 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-14 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-15 06:00:00', 'surface', 17.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-16 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-17 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-18 06:00:00', 'surface', 20.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-19 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-20 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-21 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-22 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-23 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-24 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-25 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-26 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-27 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-28 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-29 06:00:00', 'surface', 17.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-06-30 06:00:00', 'surface', 17.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-01 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-02 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-03 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-04 06:00:00', 'surface', 17.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-05 06:00:00', 'surface', 15.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-06 06:00:00', 'surface', 18.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-07 06:00:00', 'surface', 20.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-08 06:00:00', 'surface', 16.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-09 06:00:00', 'surface', 14.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-10 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-11 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-12 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-13 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-14 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-15 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-16 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-17 06:00:00', 'surface', 18.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-18 06:00:00', 'surface', 19.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-19 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-20 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-21 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-22 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-23 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-24 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-25 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-26 06:00:00', 'surface', 20.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-27 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-28 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-29 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-30 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-07-31 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-01 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-02 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-03 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-04 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-05 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-06 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-07 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-08 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-09 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-10 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-11 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-12 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-13 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-14 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-15 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-16 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-17 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-18 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-19 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-20 06:00:00', 'surface', 15.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-21 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-22 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-23 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-24 06:00:00', 'surface', 22.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-25 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-26 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-27 06:00:00', 'surface', 19.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-28 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-29 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-30 06:00:00', 'surface', 19.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-08-31 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-01 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-02 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-03 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-04 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-05 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-06 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-07 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-08 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-09 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-10 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-11 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-12 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-13 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-14 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-15 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-16 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-17 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-18 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-19 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-20 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-21 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-22 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-23 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-24 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-25 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-26 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-27 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-28 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-29 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-09-30 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-01 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-02 06:00:00', 'surface', 32.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-03 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-04 06:00:00', 'surface', 30.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-05 06:00:00', 'surface', 32.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-06 06:00:00', 'surface', 32.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-07 06:00:00', 'surface', 31.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-08 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-09 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-10 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-11 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-12 06:00:00', 'surface', 29.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-13 06:00:00', 'surface', 29.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-14 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-15 06:00:00', 'surface', 29.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-16 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-17 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-18 06:00:00', 'surface', 29.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-19 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-20 06:00:00', 'surface', 30.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-21 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-22 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-23 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-24 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-25 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-26 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-27 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-28 06:00:00', 'surface', 19.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-29 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-30 06:00:00', 'surface', 20.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-10-31 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-01 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-02 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-03 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-04 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-05 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-06 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-07 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-08 06:00:00', 'surface', 31.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-09 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-10 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-11 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-12 06:00:00', 'surface', 30.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-13 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-14 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-15 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-16 06:00:00', 'surface', 31.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-17 06:00:00', 'surface', 33.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-18 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-19 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-20 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-21 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-23 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-24 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-25 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-26 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-27 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-28 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-29 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-11-30 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-01 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-02 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-03 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-04 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-05 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-06 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-07 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-08 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-09 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-10 06:00:00', 'surface', 30.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-11 06:00:00', 'surface', 30.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-12 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-13 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-14 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-15 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-16 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-17 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-18 06:00:00', 'surface', 29.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-19 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-20 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-21 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-22 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-23 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-24 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-25 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-26 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-27 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-28 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-29 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-30 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1967-12-31 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-01 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-02 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-03 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-04 06:00:00', 'surface', 30.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-05 06:00:00', 'surface', 32.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-06 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-07 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-08 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-09 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-10 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-11 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-12 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-13 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-14 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-15 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-16 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-17 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-18 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-19 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-20 06:00:00', 'surface', 29.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-21 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-22 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-23 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-24 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-25 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-26 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-27 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-28 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-29 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-30 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-01-31 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-01 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-02 06:00:00', 'surface', 20.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-03 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-04 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-05 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-06 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-07 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-08 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-09 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-10 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-11 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-12 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-13 06:00:00', 'surface', 24.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-14 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-15 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-16 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-17 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-18 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-19 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-20 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-21 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-22 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-23 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-24 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-25 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-26 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-27 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-28 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-02-29 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-01 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-02 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-03 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-04 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-05 06:00:00', 'surface', 29.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-06 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-07 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-08 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-09 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-10 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-11 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-12 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-13 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-14 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-15 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-16 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-17 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-18 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-19 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-20 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-21 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-23 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-24 06:00:00', 'surface', 28.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-25 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-26 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-27 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-28 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-29 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-30 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-03-31 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-01 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-02 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-04-03 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-25 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-26 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-27 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-28 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-29 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-30 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1968-12-31 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-01 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-02 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-03 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-04 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-05 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-06 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-07 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-08 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-09 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-10 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-11 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-12 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-13 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-14 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-15 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-16 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-17 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-18 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-19 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-20 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-21 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-22 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-23 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-24 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-25 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-26 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-27 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-28 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-29 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-30 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-01-31 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-01 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-02 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-03 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-04 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-05 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-06 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-07 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-08 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-09 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-10 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-11 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-12 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-13 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-14 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-15 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-09-28 06:00:00', 'surface', 14.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-09-29 06:00:00', 'surface', 14.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-09-30 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-01 06:00:00', 'surface', 10.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-02 06:00:00', 'surface', 11.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-03 06:00:00', 'surface', 12.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-04 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-05 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-06 06:00:00', 'surface', 11.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-07 06:00:00', 'surface', 10.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-08 06:00:00', 'surface', 14.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-09 06:00:00', 'surface', 16.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-10 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-11 06:00:00', 'surface', 12.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-12 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-13 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-14 06:00:00', 'surface', 17.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-15 06:00:00', 'surface', 17.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-16 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-17 06:00:00', 'surface', 13.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-18 06:00:00', 'surface', 12.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-19 06:00:00', 'surface', 11.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-20 06:00:00', 'surface', 10.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-21 06:00:00', 'surface', 12.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-22 06:00:00', 'surface', 17.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-23 06:00:00', 'surface', 14.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-24 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-25 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-26 06:00:00', 'surface', 16.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-27 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-28 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-29 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-30 06:00:00', 'surface', 17.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-10-31 06:00:00', 'surface', 13.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-01 06:00:00', 'surface', 12.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-02 06:00:00', 'surface', 12.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-03 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-04 06:00:00', 'surface', 16.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-05 06:00:00', 'surface', 17.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-06 06:00:00', 'surface', 14.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-07 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-08 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-09 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-10 06:00:00', 'surface', 15.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-11 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-12 06:00:00', 'surface', 13.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-13 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-14 06:00:00', 'surface', 13.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-15 06:00:00', 'surface', 17.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-16 06:00:00', 'surface', 12.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-17 06:00:00', 'surface', 11.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-18 06:00:00', 'surface', 14.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-19 06:00:00', 'surface', 13.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-20 06:00:00', 'surface', 14.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-21 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-22 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-23 06:00:00', 'surface', 18.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-24 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-25 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-26 06:00:00', 'surface', 15.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-27 06:00:00', 'surface', 13.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-28 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-29 06:00:00', 'surface', 16.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-11-30 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-01 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-02 06:00:00', 'surface', 17.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-03 06:00:00', 'surface', 13.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-04 06:00:00', 'surface', 14.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-05 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-06 06:00:00', 'surface', 16.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-07 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-08 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-09 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-10 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-11 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-12 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-13 06:00:00', 'surface', 16.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-14 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-15 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-16 06:00:00', 'surface', 14.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-17 06:00:00', 'surface', 15.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-18 06:00:00', 'surface', 13.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-19 06:00:00', 'surface', 14.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-20 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-21 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-22 06:00:00', 'surface', 19.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-23 06:00:00', 'surface', 14.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-24 06:00:00', 'surface', 16.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-25 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-26 06:00:00', 'surface', 17.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-27 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-28 06:00:00', 'surface', 14.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-29 06:00:00', 'surface', 14.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-30 06:00:00', 'surface', 11.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1961-12-31 06:00:00', 'surface', 11.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-01 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-02 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-03 06:00:00', 'surface', 13.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-04 06:00:00', 'surface', 12.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-05 06:00:00', 'surface', 14.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-06 06:00:00', 'surface', 15.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-07 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-08 06:00:00', 'surface', 17.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-09 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-10 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-11 06:00:00', 'surface', 16.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-12 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-13 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-14 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-15 06:00:00', 'surface', 15.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-16 06:00:00', 'surface', 17.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-17 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-18 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-19 06:00:00', 'surface', 17.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-20 06:00:00', 'surface', 16.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-21 06:00:00', 'surface', 16.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-22 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-23 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-24 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-25 06:00:00', 'surface', 15.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-26 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-27 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-28 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-29 06:00:00', 'surface', 14.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-30 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-01-31 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-01 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-02 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-03 06:00:00', 'surface', 16.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-04 06:00:00', 'surface', 17.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-05 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-06 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-07 06:00:00', 'surface', 16.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-08 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-09 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-10 06:00:00', 'surface', 16.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-11 06:00:00', 'surface', 18.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-12 06:00:00', 'surface', 16.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-13 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-14 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-15 06:00:00', 'surface', 16.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-16 06:00:00', 'surface', 15.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-17 06:00:00', 'surface', 16.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-18 06:00:00', 'surface', 17.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-19 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-20 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-21 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-22 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-23 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-24 06:00:00', 'surface', 13.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-25 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-26 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-27 06:00:00', 'surface', 14.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-02-28 06:00:00', 'surface', 14.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-01 06:00:00', 'surface', 12.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-02 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-03 06:00:00', 'surface', 10.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-04 06:00:00', 'surface', 11.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-05 06:00:00', 'surface', 10.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-06 06:00:00', 'surface', 14.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-07 06:00:00', 'surface', 12.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-08 06:00:00', 'surface', 13.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-09 06:00:00', 'surface', 13.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-10 06:00:00', 'surface', 13.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-11 06:00:00', 'surface', 13.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-12 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-13 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-14 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-15 06:00:00', 'surface', 13.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-16 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-17 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-18 06:00:00', 'surface', 14.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-19 06:00:00', 'surface', 15.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-20 06:00:00', 'surface', 14.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-21 06:00:00', 'surface', 14.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-22 06:00:00', 'surface', 13.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-23 06:00:00', 'surface', 14.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-24 06:00:00', 'surface', 14.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-25 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-26 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-27 06:00:00', 'surface', 14.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-28 06:00:00', 'surface', 11.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-29 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-30 06:00:00', 'surface', 14.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-03-31 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-01 06:00:00', 'surface', 13.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-02 06:00:00', 'surface', 15.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-03 06:00:00', 'surface', 13.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-04 06:00:00', 'surface', 13.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-05 06:00:00', 'surface', 12.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-06 06:00:00', 'surface', 14.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-07 06:00:00', 'surface', 11.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-08 06:00:00', 'surface', 13.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-09 06:00:00', 'surface', 14.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-10 06:00:00', 'surface', 14.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-11 06:00:00', 'surface', 12.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-12 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-13 06:00:00', 'surface', 16.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-14 06:00:00', 'surface', 14.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-15 06:00:00', 'surface', 15.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-16 06:00:00', 'surface', 13.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-17 06:00:00', 'surface', 12.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-18 06:00:00', 'surface', 10.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-19 06:00:00', 'surface', 10.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-20 06:00:00', 'surface', 12.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-21 06:00:00', 'surface', 11.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-22 06:00:00', 'surface', 9.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-23 06:00:00', 'surface', 13.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-24 06:00:00', 'surface', 12.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-25 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-26 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-27 06:00:00', 'surface', 15.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-28 06:00:00', 'surface', 13.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-29 06:00:00', 'surface', 11.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-04-30 06:00:00', 'surface', 7.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-01 06:00:00', 'surface', 6.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-02 06:00:00', 'surface', 8.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-03 06:00:00', 'surface', 7.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-04 06:00:00', 'surface', 7.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-05 06:00:00', 'surface', 7.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-06 06:00:00', 'surface', 9.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-07 06:00:00', 'surface', 8.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-08 06:00:00', 'surface', 8.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-09 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-10 06:00:00', 'surface', 7.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-11 06:00:00', 'surface', 7.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-12 06:00:00', 'surface', 7.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-13 06:00:00', 'surface', 6.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-14 06:00:00', 'surface', 8.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-15 06:00:00', 'surface', 9.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-16 06:00:00', 'surface', 6.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-17 06:00:00', 'surface', 10.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-18 06:00:00', 'surface', 7.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-19 06:00:00', 'surface', 8.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-20 06:00:00', 'surface', 6.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-21 06:00:00', 'surface', 3.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-22 06:00:00', 'surface', 7.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-23 06:00:00', 'surface', 8.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-24 06:00:00', 'surface', 8.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-25 06:00:00', 'surface', 10.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-26 06:00:00', 'surface', 6.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-27 06:00:00', 'surface', 5.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-28 06:00:00', 'surface', 6.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-29 06:00:00', 'surface', 8.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-30 06:00:00', 'surface', 5.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-05-31 06:00:00', 'surface', 6.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-01 06:00:00', 'surface', 7.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-02 06:00:00', 'surface', 6.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-03 06:00:00', 'surface', 5.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-04 06:00:00', 'surface', 4.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-05 06:00:00', 'surface', 3.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-06 06:00:00', 'surface', 7.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-07 06:00:00', 'surface', 7.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-08 06:00:00', 'surface', 7.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-09 06:00:00', 'surface', 8.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-10 06:00:00', 'surface', 8.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-11 06:00:00', 'surface', 8.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-12 06:00:00', 'surface', 10.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-13 06:00:00', 'surface', 7.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-14 06:00:00', 'surface', 8.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-15 06:00:00', 'surface', 7.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-16 06:00:00', 'surface', 8.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-17 06:00:00', 'surface', 9.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-18 06:00:00', 'surface', 8.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-19 06:00:00', 'surface', 8.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-20 06:00:00', 'surface', 7.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-21 06:00:00', 'surface', 6.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-22 06:00:00', 'surface', 7.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-23 06:00:00', 'surface', 6.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-24 06:00:00', 'surface', 5.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-25 06:00:00', 'surface', 6.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-26 06:00:00', 'surface', 5.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-27 06:00:00', 'surface', 5.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-28 06:00:00', 'surface', 7.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-29 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-06-30 06:00:00', 'surface', 7.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-01 06:00:00', 'surface', 7.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-02 06:00:00', 'surface', 4.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-03 06:00:00', 'surface', 5.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-04 06:00:00', 'surface', 4.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-05 06:00:00', 'surface', 6.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-06 06:00:00', 'surface', 7.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-07 06:00:00', 'surface', 9.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-08 06:00:00', 'surface', 8.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-09 06:00:00', 'surface', 9.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-10 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-11 06:00:00', 'surface', 5.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-12 06:00:00', 'surface', 8.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-13 06:00:00', 'surface', 7.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-14 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-15 06:00:00', 'surface', 8.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-16 06:00:00', 'surface', 6.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-17 06:00:00', 'surface', 4.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-18 06:00:00', 'surface', 7.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-19 06:00:00', 'surface', 11.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-20 06:00:00', 'surface', 6.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-21 06:00:00', 'surface', 7.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-22 06:00:00', 'surface', 10.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-23 06:00:00', 'surface', 5.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-24 06:00:00', 'surface', 6.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-25 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-26 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-27 06:00:00', 'surface', 8.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-28 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-29 06:00:00', 'surface', 7.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-30 06:00:00', 'surface', 6.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-07-31 06:00:00', 'surface', 6.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-01 06:00:00', 'surface', 7.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-02 06:00:00', 'surface', 5.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-03 06:00:00', 'surface', 8.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-04 06:00:00', 'surface', 9.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-05 06:00:00', 'surface', 10.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-06 06:00:00', 'surface', 11.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-07 06:00:00', 'surface', 10.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-08 06:00:00', 'surface', 5.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-09 06:00:00', 'surface', 6.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-10 06:00:00', 'surface', 8.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-11 06:00:00', 'surface', 9.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-12 06:00:00', 'surface', 9.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-13 06:00:00', 'surface', 8.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-14 06:00:00', 'surface', 9.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-15 06:00:00', 'surface', 7.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-16 06:00:00', 'surface', 6.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-17 06:00:00', 'surface', 8.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-18 06:00:00', 'surface', 6.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-19 06:00:00', 'surface', 8.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-20 06:00:00', 'surface', 12.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-21 06:00:00', 'surface', 11.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-22 06:00:00', 'surface', 15.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-23 06:00:00', 'surface', 11.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-24 06:00:00', 'surface', 10.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-25 06:00:00', 'surface', 10.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-26 06:00:00', 'surface', 11.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-27 06:00:00', 'surface', 12.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-28 06:00:00', 'surface', 11.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-29 06:00:00', 'surface', 4.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-30 06:00:00', 'surface', 5.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-08-31 06:00:00', 'surface', 9.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-01 06:00:00', 'surface', 9.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-02 06:00:00', 'surface', 8.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-03 06:00:00', 'surface', 4.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-04 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-05 06:00:00', 'surface', 9.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-06 06:00:00', 'surface', 10.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-07 06:00:00', 'surface', 9.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-08 06:00:00', 'surface', 10.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-09 06:00:00', 'surface', 11.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-10 06:00:00', 'surface', 13.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-11 06:00:00', 'surface', 13.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-12 06:00:00', 'surface', 9.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-13 06:00:00', 'surface', 12.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-14 06:00:00', 'surface', 13.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-15 06:00:00', 'surface', 13.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-16 06:00:00', 'surface', 9.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-17 06:00:00', 'surface', 4.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-18 06:00:00', 'surface', 8.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-19 06:00:00', 'surface', 10.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-20 06:00:00', 'surface', 10.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-21 06:00:00', 'surface', 9.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-22 06:00:00', 'surface', 9.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-23 06:00:00', 'surface', 7.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-24 06:00:00', 'surface', 12.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-25 06:00:00', 'surface', 9.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-26 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-27 06:00:00', 'surface', 17.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-28 06:00:00', 'surface', 16.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-29 06:00:00', 'surface', 14.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-09-30 06:00:00', 'surface', 13.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-10-01 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-10-02 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 3, '1962-10-03 06:00:00', 'surface', 15.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-16 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-17 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-18 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-19 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-20 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-21 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-22 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-23 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-24 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-25 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-26 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-27 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-02-28 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-01 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-02 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-03 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-04 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-05 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-06 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-07 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-08 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-09 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-10 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-11 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-12 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-13 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-14 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-15 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-16 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-17 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-18 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-19 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-20 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-21 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-22 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-23 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-24 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-25 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-26 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-27 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-28 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-29 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-30 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-03-31 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-01 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-02 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-03 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-04 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-05 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-06 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-07 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-08 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-09 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-10 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-11 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-12 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-13 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-14 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-15 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-16 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-17 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-18 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-19 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-20 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-21 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-22 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-23 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-24 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-25 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-26 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-27 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-28 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-29 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-04-30 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-01 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-02 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-03 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-04 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-05 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-06 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-07 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-08 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-09 06:00:00', 'surface', 22.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-10 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-11 06:00:00', 'surface', 20.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-12 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-13 06:00:00', 'surface', 17.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-14 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-15 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-16 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-17 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-18 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-19 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-20 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-21 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-22 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-23 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-24 06:00:00', 'surface', 23.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-25 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-26 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-27 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-28 06:00:00', 'surface', 21.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-29 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-30 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-05-31 06:00:00', 'surface', 22.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-01 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-02 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-03 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-04 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-05 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-06 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-07 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-08 06:00:00', 'surface', 19.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-09 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-10 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-11 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-12 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-13 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-14 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-15 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-16 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-17 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-18 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-19 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-20 06:00:00', 'surface', 21.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-21 06:00:00', 'surface', 17.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-22 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-23 06:00:00', 'surface', 18.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-24 06:00:00', 'surface', 16.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-25 06:00:00', 'surface', 18.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-26 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-27 06:00:00', 'surface', 21.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-28 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-29 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-06-30 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-01 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-02 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-03 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-04 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-05 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-06 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-07 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-08 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-09 06:00:00', 'surface', 20.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-10 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-11 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-12 06:00:00', 'surface', 21.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-13 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-14 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-15 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-16 06:00:00', 'surface', 21.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-17 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-18 06:00:00', 'surface', 23.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-19 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-20 06:00:00', 'surface', 16.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-21 06:00:00', 'surface', 16.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-22 06:00:00', 'surface', 21.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-23 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-24 06:00:00', 'surface', 20.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-25 06:00:00', 'surface', 19.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-26 06:00:00', 'surface', 18.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-27 06:00:00', 'surface', 18.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-28 06:00:00', 'surface', 18.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-29 06:00:00', 'surface', 19.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-30 06:00:00', 'surface', 22.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-07-31 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-01 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-02 06:00:00', 'surface', 23.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-03 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-04 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-05 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-06 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-07 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-08 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-09 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-10 06:00:00', 'surface', 22.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-11 06:00:00', 'surface', 19.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-12 06:00:00', 'surface', 20.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-13 06:00:00', 'surface', 21.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-14 06:00:00', 'surface', 22.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-15 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-16 06:00:00', 'surface', 20.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-17 06:00:00', 'surface', 22.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-18 06:00:00', 'surface', 20.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-19 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-20 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-21 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-22 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-23 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-24 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-25 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-26 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-27 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-28 06:00:00', 'surface', 25.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-29 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-30 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-08-31 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-01 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-02 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-03 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-04 06:00:00', 'surface', 29.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-05 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-06 06:00:00', 'surface', 23.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-07 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-08 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-09 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-10 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-11 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-12 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-13 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-14 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-15 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-16 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-17 06:00:00', 'surface', 25.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-18 06:00:00', 'surface', 26.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-19 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-20 06:00:00', 'surface', 24.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-21 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-22 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-23 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-24 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-25 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-26 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-27 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-28 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-29 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-09-30 06:00:00', 'surface', 30.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-01 06:00:00', 'surface', 29.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-02 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-03 06:00:00', 'surface', 31.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-04 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-05 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-06 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-07 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-08 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-09 06:00:00', 'surface', 30.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-10 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-11 06:00:00', 'surface', 31.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-12 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-13 06:00:00', 'surface', 31.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-14 06:00:00', 'surface', 30.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-15 06:00:00', 'surface', 30.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-16 06:00:00', 'surface', 31.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-17 06:00:00', 'surface', 31.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-18 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-19 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-20 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-21 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-22 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-23 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-24 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-25 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-26 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-27 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-28 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-29 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-30 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-10-31 06:00:00', 'surface', 19.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-01 06:00:00', 'surface', 23.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-02 06:00:00', 'surface', 25.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-03 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-04 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-05 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-06 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-07 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-08 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-09 06:00:00', 'surface', 29.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-10 06:00:00', 'surface', 29.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-11 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-12 06:00:00', 'surface', 22.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-13 06:00:00', 'surface', 23.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-14 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-15 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-16 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-17 06:00:00', 'surface', 29.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-18 06:00:00', 'surface', 31.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-19 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-20 06:00:00', 'surface', 31.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-21 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-22 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-23 06:00:00', 'surface', 30.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-24 06:00:00', 'surface', 30.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-25 06:00:00', 'surface', 31.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-26 06:00:00', 'surface', 33.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-27 06:00:00', 'surface', 33.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-28 06:00:00', 'surface', 33.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-29 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-11-30 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-01 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-02 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-03 06:00:00', 'surface', 23.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-04 06:00:00', 'surface', 24.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-05 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-06 06:00:00', 'surface', 24.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-07 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-08 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-09 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-10 06:00:00', 'surface', 25.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-11 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-12 06:00:00', 'surface', 24.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-13 06:00:00', 'surface', 24.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-14 06:00:00', 'surface', 24.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-15 06:00:00', 'surface', 22.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-16 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-17 06:00:00', 'surface', 23.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-18 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-19 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-20 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-21 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-22 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-23 06:00:00', 'surface', 21.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-24 06:00:00', 'surface', 24.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-25 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-26 06:00:00', 'surface', 20.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-27 06:00:00', 'surface', 25.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-28 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-29 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-30 06:00:00', 'surface', 25.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1969-12-31 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-01 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-02 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-03 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-04 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-05 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-06 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-07 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-08 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-09 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-10 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-11 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-12 06:00:00', 'surface', 29.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-13 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-14 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-15 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-16 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-17 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-18 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-19 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-20 06:00:00', 'surface', 22.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-21 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-22 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-23 06:00:00', 'surface', 27.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-24 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-25 06:00:00', 'surface', 26.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-26 06:00:00', 'surface', 27.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-27 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-28 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-29 06:00:00', 'surface', 27.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-30 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-01-31 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-01 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-02 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-03 06:00:00', 'surface', 19.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-04 06:00:00', 'surface', 23.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-05 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-06 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-07 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-08 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-09 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-10 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-11 06:00:00', 'surface', 27.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-12 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-13 06:00:00', 'surface', 26.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-14 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-15 06:00:00', 'surface', 27.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-16 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-17 06:00:00', 'surface', 24.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-18 06:00:00', 'surface', 24.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-19 06:00:00', 'surface', 26.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-20 06:00:00', 'surface', 27.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-21 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-22 06:00:00', 'surface', 27.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-23 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-24 06:00:00', 'surface', 28.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-25 06:00:00', 'surface', 29.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-26 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-27 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-02-28 06:00:00', 'surface', 29.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-01 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-02 06:00:00', 'surface', 31.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-03 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-04 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-05 06:00:00', 'surface', 30.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-06 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-07 06:00:00', 'surface', 28.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-08 06:00:00', 'surface', 26.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-09 06:00:00', 'surface', 28.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-10 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-11 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-12 06:00:00', 'surface', 25.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-13 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-14 06:00:00', 'surface', 23.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-15 06:00:00', 'surface', 26.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-16 06:00:00', 'surface', 25.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-17 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-18 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-19 06:00:00', 'surface', 28.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-20 06:00:00', 'surface', 28.30, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-21 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-22 06:00:00', 'surface', 29.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-23 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-24 06:00:00', 'surface', 27.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-25 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-26 06:00:00', 'surface', 26.00, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-27 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-28 06:00:00', 'surface', 28.80, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-29 06:00:00', 'surface', 25.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-30 06:00:00', 'surface', 25.50, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-03-31 06:00:00', 'surface', 26.10, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-01 06:00:00', 'surface', 28.60, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-02 06:00:00', 'surface', 26.90, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-03 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-04 06:00:00', 'surface', 27.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-05 06:00:00', 'surface', 27.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-06 06:00:00', 'surface', 28.40, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-07 06:00:00', 'surface', 28.20, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-08 06:00:00', 'surface', 26.70, '', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
	('67774010', 2, '1970-04-09 06:00:00', 'surface', 25.10, '', NU