ALTER TABLE DEPLOYMENT ADD (
  CONSTRAINT FK_D_EQUIPMENT
  FOREIGN KEY (EQUIPMENT_ID)
  REFERENCES EQUIPMENT (EQUIPMENT_ID)
  ENABLE VALIDATE);

ALTER TABLE DEPLOYMENT ADD (
  CONSTRAINT FK_D_STATION
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE DEPLOYMENT_DETAIL ADD (
  CONSTRAINT FK_DD_DEPLOYMENT
  FOREIGN KEY (DEPLOYMENT_ID)
  REFERENCES DEPLOYMENT (DEPLOYMENT_ID)
  ENABLE VALIDATE);


ALTER TABLE EQPT_CALIB_COEFF ADD (
  CONSTRAINT FK_EQUIPMENT_CALIBRATION
  FOREIGN KEY (EQPT_CALIB_ID)
  REFERENCES EQUIPMENT_CALIBRATION (EQPT_CALIB_ID)
  ENABLE VALIDATE);


ALTER TABLE EQUIPMENT_CALIBRATION ADD (
  CONSTRAINT FK_EC_CALIB_CHECK_EQUIP
  FOREIGN KEY (CHECK_EQUIPMENT_ID)
  REFERENCES EQUIPMENT (EQUIPMENT_ID)
  ENABLE VALIDATE);

ALTER TABLE EQUIPMENT_CALIBRATION ADD (
  CONSTRAINT FK_EC_EQUIPMENT
  FOREIGN KEY (EQUIPMENT_ID)
  REFERENCES EQUIPMENT (EQUIPMENT_ID)
  ENABLE VALIDATE);


ALTER TABLE INSPECTION ADD (
  CONSTRAINT FK_I_STATION
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE INSPECTION_DETAIL ADD (
  CONSTRAINT FK_ID_DEPLOYMENT
  FOREIGN KEY (DEPLOYMENT_ID)
  REFERENCES DEPLOYMENT (DEPLOYMENT_ID)
  ENABLE VALIDATE);

ALTER TABLE INSPECTION_DETAIL ADD (
  CONSTRAINT FK_ID_INSPECTION
  FOREIGN KEY (INSPECTION_ID)
  REFERENCES INSPECTION (INSPECTION_ID)
  ENABLE VALIDATE);


ALTER TABLE OBSERVING_SCHEDULE ADD (
  CONSTRAINT FK_STN_RPT_ELEM_ID
  FOREIGN KEY (STN_RPT_ELEM_ID)
  REFERENCES STATION_REPORT_ELEMENT (STN_RPT_ELEM_ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);


ALTER TABLE OBSERVING_SYSTEM_INSTALLATION ADD (
  CONSTRAINT FK_OSI_STATION
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE SRC_CAPABILITY ADD (
  CONSTRAINT C_SRCCAP_SRC_FK
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE SRC_CAPABILITY_NODATA ADD (
  CONSTRAINT C_SCND_SRC_FK
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE STATION_AUTHORITY_HISTORY ADD (
  CONSTRAINT FK_SAH_AUTH_HIST_SRC_ID
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE STATION_GEOGRAPHY ADD (
  CONSTRAINT FK_SG_SOURCE
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE STATION_HISTORY ADD (
  CONSTRAINT FK_SEH_STATION
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE STATION_INVENTORY_STATUS ADD (
  CONSTRAINT FK_SIS_STATION
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE STATION_OBSERVER ADD (
  CONSTRAINT FK_SO_STATION
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE STATION_ROLE ADD (
  CONSTRAINT FK_SR_STATION
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);


ALTER TABLE STATION_STATUS ADD (
  CONSTRAINT FK_SS_STATION
  FOREIGN KEY (SRC_ID)
  REFERENCES SOURCE (SRC_ID)
  ENABLE VALIDATE);
