/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */
BEGIN TRANSACTION;
/* Drop Tables */

DROP TABLE IF EXISTS "Logentry" CASCADE
;

/* Create Tables */

CREATE TABLE "Logentry"
(
	"Author" varchar NULL,	-- Author of the log entry.
	"Datetime" varchar NULL,	-- Date and time of the event being logged
	"Description" varchar NULL,	-- Description of the log entry
	"Documentationurl" varchar NULL,	-- Link to additional documents, photos etc. about the event being logged.
	"LogentryID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Logentry" ADD CONSTRAINT "PK_Logentry"
	PRIMARY KEY ("LogentryID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Logentry"
	IS 'At the abstract level a log entry contains the time, author and descriptions of the activity or event being logged. This class is specialized further to provide more specific log entry types where needed. '
;

COMMENT ON COLUMN "Logentry"."Author"
	IS 'Author of the log entry.'
;

COMMENT ON COLUMN "Logentry"."Datetime"
	IS 'Date and time of the event being logged'
;

COMMENT ON COLUMN "Logentry"."Description"
	IS 'Description of the log entry'
;

COMMENT ON COLUMN "Logentry"."Documentationurl"
	IS 'Link to additional documents, photos etc. about the event being logged.'
;
/* Drop Tables */

DROP TABLE IF EXISTS "Abstractenvironmentalmonitoringfacility" CASCADE
;

/* Create Tables */

CREATE TABLE "Abstractenvironmentalmonitoringfacility"
(
	"Description" varchar NULL,	-- 4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. 
	"Extension" varchar NULL,	-- This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks. However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. 
	"Geospatiallocation" varchar NULL,	-- 3-07 Position in space defining the location of the environmental monitoring station/platform at the time of observation.  5-12 Geospatial location of instrument/sensor
	"Onlineresource" varchar NULL,	-- An online resource containing additional information about the facility or equipment
	"Responsibleparty" varchar NULL,	-- The organisation responsible.
	"AbstractenvironmentalmonitoringfacilityID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Abstractenvironmentalmonitoringfacility" ADD CONSTRAINT "PK_Abstractenvironmentalmonitoringfacility"
	PRIMARY KEY ("AbstractenvironmentalmonitoringfacilityID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Abstractenvironmentalmonitoringfacility"
	IS 'An abstract class for environmental monitoring facilities. An environmental monitoring facility may be a station, a platform (moving or stationary), or it may be a sensor or an instrument. WIGOS defines two concrete specialisations: ObservingFacility (to represent stations/platforms) and Equipment (to represent sensors/instruments). NOTE: The WIGOS specialisations of AbstractEnvironmentalMonitoringFacility (ObservingFacility, Equipment) can both be mapped conceptually to the INSPIRE EF EnvironmentalMonitoringFacility.'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Description"
	IS '4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. '
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Extension"
	IS 'This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks.
However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. '
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Geospatiallocation"
	IS '3-07 Position in space defining the location of the environmental monitoring station/platform at the time of observation.

5-12 Geospatial location of instrument/sensor'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Onlineresource"
	IS 'An online resource containing additional information about the facility or equipment'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Responsibleparty"
	IS 'The organisation responsible.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Altitude-or-depth" CASCADE
;

/* Create Tables */

CREATE TABLE "Altitude-or-depth"
(
	"Altitude-or-depthID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Altitude-or-depth" ADD CONSTRAINT "PK_Altitude-or-depth"
	PRIMARY KEY ("Altitude-or-depthID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Altitude-or-depth"
	IS 'The value for altitudeOrDepth, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/AltitudeOrDepth.

This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Altitudeordepthtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Altitudeordepthtype"
(
	"AltitudeordepthtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Altitudeordepthtype" ADD CONSTRAINT "PK_Altitudeordepthtype"
	PRIMARY KEY ("AltitudeordepthtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Altitudeordepthtype"
	IS 'Codelist for altitude/depth classifications'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Application-area" CASCADE
;

/* Create Tables */

CREATE TABLE "Application-area"
(
	"Application-areaID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Application-area" ADD CONSTRAINT "PK_Application-area"
	PRIMARY KEY ("Application-areaID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Application-area"
	IS 'The value(s) for applicationArea shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ApplicationArea.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Applicationareatype" CASCADE
;

/* Create Tables */

CREATE TABLE "Applicationareatype"
(
	"ApplicationareatypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Applicationareatype" ADD CONSTRAINT "PK_Applicationareatype"
	PRIMARY KEY ("ApplicationareatypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Applicationareatype"
	IS 'Application Area codelist

note to group:
14 application areas in WMO Core Metadata profile
Also comparable list in WIGOS - to review.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Attribution" CASCADE
;

/* Create Tables */

CREATE TABLE "Attribution"
(
	"Originator" varchar NULL,	-- Identifies the individual and/or organization at the origin of the resource. This is typically the owner of the ressource, e.g., a data set.
	"Originatorurl" varchar NULL,
	"Source" varchar NULL,
	"Title" varchar NULL,	-- The title of the attributed work.
	"AttributionID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Attribution" ADD CONSTRAINT "PK_Attribution"
	PRIMARY KEY ("AttributionID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON COLUMN "Attribution"."Originator"
	IS 'Identifies the individual and/or organization at the origin of the resource. This is typically the owner of the ressource, e.g., a data set.'
;

COMMENT ON COLUMN "Attribution"."Title"
	IS 'The title of the attributed work.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Climate-zone" CASCADE
;

/* Create Tables */

CREATE TABLE "Climate-zone"
(
	"Climate-zoneID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Climate-zone" ADD CONSTRAINT "PK_Climate-zone"
	PRIMARY KEY ("Climate-zoneID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Climate-zone"
	IS 'The value for climateZone shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ClimateZone.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Climatezone" CASCADE
;

/* Create Tables */

CREATE TABLE "Climatezone"
(
	"Climatezone" varchar NULL,	-- 4-07 type of climate zone at the facility. From the ClimateZoneType codelist.
	"Validperiod" varchar NULL,	-- The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.
	"ClimatezoneID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Climatezone" ADD CONSTRAINT "PK_Climatezone"
	PRIMARY KEY ("ClimatezoneID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Climatezone"
	IS 'A ClimateZone is a climateZone specification accompanied by a timestamp indicating the time from which that climateZone is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple climateZone which are valid over different consecutive periods of time. If only a single climateZone is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Climatezone"."Climatezone"
	IS '4-07 type of climate zone at the facility. From the ClimateZoneType codelist.'
;

COMMENT ON COLUMN "Climatezone"."Validperiod"
	IS 'The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Climatezonetype" CASCADE
;

/* Create Tables */

CREATE TABLE "Climatezonetype"
(
	"ClimatezonetypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Climatezonetype" ADD CONSTRAINT "PK_Climatezonetype"
	PRIMARY KEY ("ClimatezonetypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Climatezonetype"
	IS '4-07 Climate Zone '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Communication-method" CASCADE
;

/* Create Tables */

CREATE TABLE "Communication-method"
(
	"Communication-methodID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Communication-method" ADD CONSTRAINT "PK_Communication-method"
	PRIMARY KEY ("Communication-methodID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Communication-method"
	IS 'The value for communicationMethod, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/DataCommunicationMethod.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Controlchecklocationtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Controlchecklocationtype"
(
	"ControlchecklocationtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Controlchecklocationtype" ADD CONSTRAINT "PK_Controlchecklocationtype"
	PRIMARY KEY ("ControlchecklocationtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Controlchecklocationtype"
	IS '5-08  - Types of location used in control checks'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Controlcheckreport" CASCADE
;

/* Create Tables */

CREATE TABLE "Controlcheckreport"
(
	"Alternateuri" varchar NULL,	-- 5-08 Alternatively the summary of the control check may be provided via a URI that resolves to a document containing this information.
	"Checklocation" varchar NULL,	-- 5-08 Location of sensor when check was performed (e.g. in-situ, offsite etc.) From codelist ControlCheckLocationType.
	"Controlcheckresult" varchar NULL,	-- 5-08 Result of the control check, from InstrumentControlResultType codelist
	"Periodofvalidity" varchar NULL,	-- 5-08 period of validity of the control check (e.g. 4 years)
	"Standardname" varchar NULL,	-- 5-08 Nameof the Standard used.
	"Standardserialnumber" varchar NULL,	-- 5-08 Serial Number of the standard used.
	"Standardtype" varchar NULL,	-- 5-08 Type of the Standard used. From the StandardType code list.
	"Withinverificationlimit" varchar NULL,	-- 5-08 Was the instrument found to be within verification limits (True if yes, False if no)
	"ControlcheckreportID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Controlcheckreport" ADD CONSTRAINT "PK_Controlcheckreport"
	PRIMARY KEY ("ControlcheckreportID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Controlcheckreport" ADD CONSTRAINT "FK_ControlCheckReport_LogEntry"
	FOREIGN KEY ("ControlcheckreportID") REFERENCES "Logentry" ("LogentryID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Controlcheckreport"
	IS 'A ControlCheckReport describes a calibration type event. E.g. instrument was re-calibrated.'
;

COMMENT ON COLUMN "Controlcheckreport"."Alternateuri"
	IS '5-08 Alternatively the summary of the control check may be provided via a URI that resolves to a document containing this information.'
;

COMMENT ON COLUMN "Controlcheckreport"."Checklocation"
	IS '5-08 Location of sensor when check was performed (e.g. in-situ, offsite etc.) From codelist ControlCheckLocationType.'
;

COMMENT ON COLUMN "Controlcheckreport"."Controlcheckresult"
	IS '5-08 Result of the control check, from InstrumentControlResultType codelist'
;

COMMENT ON COLUMN "Controlcheckreport"."Periodofvalidity"
	IS '5-08 period of validity of the control check (e.g. 4 years)'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardname"
	IS '5-08 Nameof the Standard used.'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardserialnumber"
	IS '5-08 Serial Number of the standard used.'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardtype"
	IS '5-08 Type of the Standard used. From the StandardType code list.'
;

COMMENT ON COLUMN "Controlcheckreport"."Withinverificationlimit"
	IS '5-08 Was the instrument found to be within verification limits (True if yes, False if no)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Controlstandardtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Controlstandardtype"
(
	"ControlstandardtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Controlstandardtype" ADD CONSTRAINT "PK_Controlstandardtype"
	PRIMARY KEY ("ControlstandardtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Controlstandardtype"
	IS '5-08 Codelist for types of Control Standards'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Coordinatereferencesystemtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Coordinatereferencesystemtype"
(
	"CoordinatereferencesystemtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Coordinatereferencesystemtype" ADD CONSTRAINT "PK_Coordinatereferencesystemtype"
	PRIMARY KEY ("CoordinatereferencesystemtypeID")
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Coordinatesreferencesystemtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Coordinatesreferencesystemtype"
(
	"CoordinatesreferencesystemtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Coordinatesreferencesystemtype" ADD CONSTRAINT "PK_Coordinatesreferencesystemtype"
	PRIMARY KEY ("CoordinatesreferencesystemtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Coordinatesreferencesystemtype"
	IS 'Coordinate reference system codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Datacommunicationmethodtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Datacommunicationmethodtype"
(
	"DatacommunicationmethodtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Datacommunicationmethodtype" ADD CONSTRAINT "PK_Datacommunicationmethodtype"
	PRIMARY KEY ("DatacommunicationmethodtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Datacommunicationmethodtype"
	IS 'Data Communication method'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Data-format" CASCADE
;

/* Create Tables */

CREATE TABLE "Data-format"
(
	"Data-formatID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Data-format" ADD CONSTRAINT "PK_Data-format"
	PRIMARY KEY ("Data-formatID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Data-format"
	IS 'The value for dataFormat, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/DataFormat.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Dataformattype" CASCADE
;

/* Create Tables */

CREATE TABLE "Dataformattype"
(
	"DataformattypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Dataformattype" ADD CONSTRAINT "PK_Dataformattype"
	PRIMARY KEY ("DataformattypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Dataformattype"
	IS 'Data format codelist'
;
/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Deployment" CASCADE
;

/* Create Tables */

CREATE TABLE "Deployment"
(
	"Deployment" varchar NULL,
	"DeploymentID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Deployment" ADD CONSTRAINT "PK_Deployment"
	PRIMARY KEY ("DeploymentID")
;
/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Datageneration" CASCADE
;

/* Create Tables */

CREATE TABLE "Datageneration"
(
	"Validperiod" varchar NULL,	-- The period of time for which this processing arrangement was/is in place. (Note: this time period must fall within the time period specified in the Deployment).
	"DatagenerationID" varchar NOT NULL,
	"DeploymentID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Datageneration" ADD CONSTRAINT "PK_Datageneration"
	PRIMARY KEY ("DatagenerationID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Datageneration" ADD CONSTRAINT "FK_DataGeneration_dataGeneration"
	FOREIGN KEY ("DeploymentID") REFERENCES "Deployment" ("DeploymentID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON COLUMN "Datageneration"."Validperiod"
	IS 'The period of time for which this processing arrangement was/is in place. (Note: this time period must fall within the time period specified in the Deployment).'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Datapolicy" CASCADE
;

/* Create Tables */

CREATE TABLE "Datapolicy"
(
	"Attribution" varchar NULL,	-- Describes the attribution details pertinent to dataPolicy
	"Datapolicy" varchar NULL,	-- 9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.
	"DatapolicyID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Datapolicy" ADD CONSTRAINT "PK_Datapolicy"
	PRIMARY KEY ("DatapolicyID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON COLUMN "Datapolicy"."Attribution"
	IS 'Describes the attribution details pertinent to dataPolicy'
;

COMMENT ON COLUMN "Datapolicy"."Datapolicy"
	IS '9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Datapolicytype" CASCADE
;

/* Create Tables */

CREATE TABLE "Datapolicytype"
(
	"DatapolicytypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Datapolicytype" ADD CONSTRAINT "PK_Datapolicytype"
	PRIMARY KEY ("DatapolicytypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Datapolicytype"
	IS 'Data Policy / use constraints codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Data-use-constraints" CASCADE
;

/* Create Tables */

CREATE TABLE "Data-use-constraints"
(
	"Data-use-constraintsID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Data-use-constraints" ADD CONSTRAINT "PK_Data-use-constraints"
	PRIMARY KEY ("Data-use-constraintsID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Data-use-constraints"
	IS 'The value for dataUseConstraints, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/DataPolicy.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Deployment-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Deployment-valid"
(
	"Deployment-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Deployment-valid" ADD CONSTRAINT "PK_Deployment-valid"
	PRIMARY KEY ("Deployment-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Deployment-valid"
	IS 'XML encodings of Deployment shall conform to the XML form for Deployment specified in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Description" CASCADE
;

/* Create Tables */

CREATE TABLE "Description"
(
	"Description" varchar NULL,	-- 4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. 
	"Validperiod" varchar NULL,	-- Specifies at least the begin date of the indicated description. If omitted, the dateEstablished of the facility or deployedEquipment.validPeriod will be assumed.
	"DescriptionID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Description" ADD CONSTRAINT "PK_Description"
	PRIMARY KEY ("DescriptionID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Description"
	IS 'A Description is a description accompanied by a timestamp indicating the time from which that description is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple descriptions which are valid over different periods of time.'
;

COMMENT ON COLUMN "Description"."Description"
	IS '4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. '
;

COMMENT ON COLUMN "Description"."Validperiod"
	IS 'Specifies at least the begin date of the indicated description. If omitted, the dateEstablished of the facility or deployedEquipment.validPeriod will be assumed.'
;

/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipment" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipment"
(
	"Equipment" varchar NULL,
	"EquipmentID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipment" ADD CONSTRAINT "PK_Equipment"
	PRIMARY KEY ("EquipmentID")
;
/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "EquipmentEquipment" CASCADE
;

/* Create Tables */

CREATE TABLE "EquipmentEquipment"
(
	"subEquipment" varchar NULL,
	"EquipmentID" varchar NULL
)
;

/* Create Foreign Key Constraints */

ALTER TABLE "EquipmentEquipment" ADD CONSTRAINT "FK_EquipmentEquipment_subEquipment"
	FOREIGN KEY ("subEquipment") REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "EquipmentEquipment" ADD CONSTRAINT "FK_EquipmentEquipment_Equipment"
	FOREIGN KEY ("EquipmentID") REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipment-log-entries-control-location" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipment-log-entries-control-location"
(
	"Equipment-log-entries-control-locationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipment-log-entries-control-location" ADD CONSTRAINT "PK_Equipment-log-entries-control-location"
	PRIMARY KEY ("Equipment-log-entries-control-locationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Equipment-log-entries-control-location"
	IS 'Where a log entry is a ControlCheckReport, the value of checkLocation shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ControlLocation. '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipment-log-entries-control-result" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipment-log-entries-control-result"
(
	"Equipment-log-entries-control-resultID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipment-log-entries-control-result" ADD CONSTRAINT "PK_Equipment-log-entries-control-result"
	PRIMARY KEY ("Equipment-log-entries-control-resultID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Equipment-log-entries-control-result"
	IS 'http://def.wmo.int/wmdr/2017/req/equipment/equipment-log-entries-control-result
Where a log entry is a ControlCheckReport, the value of controlCheckResult shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ControlResult. '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipment-log-entries-control-standard" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipment-log-entries-control-standard"
(
	"Equipment-log-entries-control-standardID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipment-log-entries-control-standard" ADD CONSTRAINT "PK_Equipment-log-entries-control-standard"
	PRIMARY KEY ("Equipment-log-entries-control-standardID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Equipment-log-entries-control-standard"
	IS 'Where a log entry is a ControlCheckReport, the value of standardType shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ControlStandardType. '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipment-log-entries" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipment-log-entries"
(
	"Equipment-log-entriesID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipment-log-entries" ADD CONSTRAINT "PK_Equipment-log-entries"
	PRIMARY KEY ("Equipment-log-entriesID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Equipment-log-entries"
	IS 'Log entries in a EquipmentLog shall describe control checks or maintenance of the Equipment and shall conform to the XML forms for ControlCheckReport or MaintenanceReport in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipment-log" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipment-log"
(
	"Equipment-log" varchar NULL,
	"Equipment-logID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipment-log" ADD CONSTRAINT "PK_Equipment-log"
	PRIMARY KEY ("Equipment-logID")
;

/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Log" CASCADE
;

/* Create Tables */

CREATE TABLE "Log"
(
	"Logentry" varchar NULL,	-- An entry in a Log.
	"LogID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Log" ADD CONSTRAINT "PK_Log"
	PRIMARY KEY ("LogID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Log"
	IS 'At the abstract level a log is simply a record of log entries. The requirements for a log may depend on the type of log it is therefore specialized logs exist for specific types of log (such as ControlCheckReports, MaintenanceReports and EventReports).'
;

COMMENT ON COLUMN "Log"."Logentry"
	IS 'An entry in a Log. '
;
/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipmentlog" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipmentlog"
(
	"EquipmentlogID" varchar NOT NULL,
	equipment varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipmentlog" ADD CONSTRAINT "PK_Equipmentlog"
	PRIMARY KEY ("EquipmentlogID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Equipmentlog" ADD CONSTRAINT "FK_EquipmentLog_equipmentLog"
	FOREIGN KEY (equipment) REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Equipmentlog" ADD CONSTRAINT "FK_EquipmentLog_Log"
	FOREIGN KEY ("EquipmentlogID") REFERENCES "Log" ("LogID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Equipmentlog"
	IS '5-13 The EquipmentLog is used to capture notable events and extra information about the equipment used to obtain the observations, such as actual maintenance performed on the instrument.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipment-log-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipment-log-valid"
(
	"Equipment-log-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipment-log-valid" ADD CONSTRAINT "PK_Equipment-log-valid"
	PRIMARY KEY ("Equipment-log-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Equipment-log-valid"
	IS 'XML encodings of EquipmentLog shall conform to the XML form for EquipmentLog specified in the WMDR XML Schema.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Equipment-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Equipment-valid"
(
	"Equipment-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Equipment-valid" ADD CONSTRAINT "PK_Equipment-valid"
	PRIMARY KEY ("Equipment-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Equipment-valid"
	IS 'XML encodings of Equipment shall conform to the XML form for Equipment specified in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Eventreport" CASCADE
;

/* Create Tables */

CREATE TABLE "Eventreport"
(
	"Typeofevent" varchar NULL,	-- The type of event, taken from the EventType codelist (e.g. tree removal, storm damage etc).
	"Validperiod" varchar NULL,
	"EventreportID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Eventreport" ADD CONSTRAINT "PK_Eventreport"
	PRIMARY KEY ("EventreportID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Eventreport" ADD CONSTRAINT "FK_EventReport_LogEntry"
	FOREIGN KEY ("EventreportID") REFERENCES "Logentry" ("LogentryID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON COLUMN "Eventreport"."Typeofevent"
	IS 'The type of event, taken from the EventType codelist (e.g. tree removal, storm damage etc).'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Eventtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Eventtype"
(
	"EventtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Eventtype" ADD CONSTRAINT "PK_Eventtype"
	PRIMARY KEY ("EventtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Eventtype"
	IS 'Codelist for events at station/platform'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Exposure" CASCADE
;

/* Create Tables */

CREATE TABLE "Exposure"
(
	"ExposureID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Exposure" ADD CONSTRAINT "PK_Exposure"
	PRIMARY KEY ("ExposureID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Exposure"
	IS 'The value for exposure, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/Exposure.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Exposuretype" CASCADE
;

/* Create Tables */

CREATE TABLE "Exposuretype"
(
	"ExposuretypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Exposuretype" ADD CONSTRAINT "PK_Exposuretype"
	PRIMARY KEY ("ExposuretypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Exposuretype"
	IS 'Codelist for exposure of instrument'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Facility-log-entries-event-type" CASCADE
;

/* Create Tables */

CREATE TABLE "Facility-log-entries-event-type"
(
	"Facility-log-entries-event-typeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Facility-log-entries-event-type" ADD CONSTRAINT "PK_Facility-log-entries-event-type"
	PRIMARY KEY ("Facility-log-entries-event-typeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Facility-log-entries-event-type"
	IS 'The value for typeOfEvent in a EventReport shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/EventAtFacility.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Facility-log-entries" CASCADE
;

/* Create Tables */

CREATE TABLE "Facility-log-entries"
(
	"Facility-log-entriesID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Facility-log-entries" ADD CONSTRAINT "PK_Facility-log-entries"
	PRIMARY KEY ("Facility-log-entriesID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Facility-log-entries"
	IS 'Log entries in a FacilityLog shall describe events at the facility and shall conform to the XML form for EventReport in the WMDR XML Schema. '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Facility-log" CASCADE
;

/* Create Tables */

CREATE TABLE "Facility-log"
(
	"Facility-log" varchar NULL,
	"Facility-logID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Facility-log" ADD CONSTRAINT "PK_Facility-log"
	PRIMARY KEY ("Facility-logID")
;

/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observingfacility" CASCADE
;

/* Create Tables */

CREATE TABLE "Observingfacility"
(
	"Climatezone" varchar NULL,	-- 4-07 type of climate zone at the facility. From the ClimateZoneType codelist.
	"Dateclosed" varchar NULL,
	"Dateestablished" varchar NULL,
	"Facilitytype" varchar NULL,	-- 3-04 The type of the observing facility from the MonitoringFacilityType codelist.
	"Population" varchar NULL,
	"Programaffiliation" varchar NULL,	-- 2-02 The global, regional or national programme(s)/network(s) that the ObservingFacility is associated with. programAffiliation also enables the specification of a program-specific identifier of the ObservingFacility, an alias name,  the validPeriod of the programAffiliation, as well as the reportingStatus of an ObservingFacility under the respective program.
	"Surfacecover" varchar NULL,	-- 4-01 The (bio)physical cover on the earth's surface in the vicinity of the observations from the LandCoverType codelist .  NOTE: Only applies for surface-based (fixed) observing facilities.
	"Surfaceroughness" varchar NULL,	-- 4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.
	"Territory" varchar NULL,	-- 3-02 The territory the observing facility is located in, from the TerritoryType codelist.
	"Timezone" varchar NULL,	-- Time zone the observing facility is located in, from the timeZoneTypeType codelist.
	"Topographybathymetry" varchar NULL,	-- 4-03 Topography or bathymetry characterizes the shape or configuration of a geographical feature, represented on a map by contour lines. It is implemented as a timestamped composite of four elements.
	"Wmoregion" varchar NULL,	-- 3-01 The WMO region the observing facility is located in, from the WMORegionType codelist.
	"ObservingfacilityID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observingfacility" ADD CONSTRAINT "PK_Observingfacility"
	PRIMARY KEY ("ObservingfacilityID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Observingfacility" ADD CONSTRAINT "FK_ObservingFacility_AbstractEnvironmentalMonitoringFacility"
	FOREIGN KEY ("ObservingfacilityID") REFERENCES "Abstractenvironmentalmonitoringfacility" ("AbstractenvironmentalmonitoringfacilityID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observingfacility"
	IS '[WMDS Category 3] An observing facility (station/platform) can be anything that supports making observations, e.g., a fixed station, moving equipment or a remote sensing platform. In abstract terms, an observing facility groups a near colocation of observing equipment managed by a single entity or several entities.'
;

COMMENT ON COLUMN "Observingfacility"."Climatezone"
	IS '4-07 type of climate zone at the facility. From the ClimateZoneType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Facilitytype"
	IS '3-04 The type of the observing facility from the MonitoringFacilityType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Programaffiliation"
	IS '2-02 The global, regional or national programme(s)/network(s) that the ObservingFacility is associated with. programAffiliation also enables the specification of a program-specific identifier of the ObservingFacility, an alias name,  the validPeriod of the programAffiliation, as well as the reportingStatus of an ObservingFacility under the respective program.'
;

COMMENT ON COLUMN "Observingfacility"."Surfacecover"
	IS '4-01 The (bio)physical cover on the earth''s surface in the vicinity of the observations from the LandCoverType codelist .
NOTE: Only applies for surface-based (fixed) observing facilities.'
;

COMMENT ON COLUMN "Observingfacility"."Surfaceroughness"
	IS '4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Territory"
	IS '3-02 The territory the observing facility is located in, from the TerritoryType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Timezone"
	IS 'Time zone the observing facility is located in, from the timeZoneTypeType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Topographybathymetry"
	IS '4-03 Topography or bathymetry characterizes the shape or configuration of a geographical feature, represented on a map by contour lines. It is implemented as a timestamped composite of four elements.'
;

COMMENT ON COLUMN "Observingfacility"."Wmoregion"
	IS '3-01 The WMO region the observing facility is located in, from the WMORegionType codelist.'
;

/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Facilitylog" CASCADE
;

/* Create Tables */

CREATE TABLE "Facilitylog"
(
	"FacilitylogID" varchar NOT NULL,
	facility varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Facilitylog" ADD CONSTRAINT "PK_Facilitylog"
	PRIMARY KEY ("FacilitylogID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Facilitylog" ADD CONSTRAINT "FK_FacilityLog_Log"
	FOREIGN KEY ("FacilitylogID") REFERENCES "Log" ("LogID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Facilitylog" ADD CONSTRAINT "FK_FacilityLog_facilityLog"
	FOREIGN KEY (facility) REFERENCES "Observingfacility" ("ObservingfacilityID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Facilitylog"
	IS '4-04 The FacilityLog is used to capture notable events and extra information about the observing facility or its surroundings. '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Facility-log-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Facility-log-valid"
(
	"Facility-log-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Facility-log-valid" ADD CONSTRAINT "PK_Facility-log-valid"
	PRIMARY KEY ("Facility-log-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Facility-log-valid"
	IS 'XML encodings of FacilityLog shall conform to the XML form for FacilityLog specified in the WMDR XML Schema.'
;

/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Facilityset" CASCADE
;

/* Create Tables */

CREATE TABLE "Facilityset"
(
	"FacilitysetID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Facilityset" ADD CONSTRAINT "PK_Facilityset"
	PRIMARY KEY ("FacilitysetID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Facilityset"
	IS 'A set of associated ObservingFacilities. Association (grouping) criteria can vary and maybe program/network specific. Examples: In GAW, some Global stations consist of several distinct observing facilities; The NASA A-Train may be considered a FacilitySet comprised of several individual satellites.'
;

/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "FacilitySetObservingFacility" CASCADE
;

/* Create Tables */

CREATE TABLE "FacilitySetObservingFacility"
(
	facility varchar NULL,
	"facilitySet" varchar NULL
)
;

/* Create Foreign Key Constraints */

ALTER TABLE "FacilitySetObservingFacility" ADD CONSTRAINT "FK_FacilitySetObservingFacility_facility"
	FOREIGN KEY (facility) REFERENCES "Observingfacility" ("ObservingfacilityID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "FacilitySetObservingFacility" ADD CONSTRAINT "FK_FacilitySetObservingFacility_facilitySet"
	FOREIGN KEY ("facilitySet") REFERENCES "Facilityset" ("FacilitysetID") ON DELETE No Action ON UPDATE No Action
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Facility-type" CASCADE
;

/* Create Tables */

CREATE TABLE "Facility-type"
(
	"Facility-typeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Facility-type" ADD CONSTRAINT "PK_Facility-type"
	PRIMARY KEY ("Facility-typeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Facility-type"
	IS 'The value for facilityType, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/FacilityType.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Facility-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Facility-valid"
(
	"Facility-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Facility-valid" ADD CONSTRAINT "PK_Facility-valid"
	PRIMARY KEY ("Facility-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Facility-valid"
	IS 'XML encodings of ObservingFacility shall conform to the XML form for ObservingFacility specified in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Frequencies" CASCADE
;

/* Create Tables */

CREATE TABLE "Frequencies"
(
	"Bandwidth" varchar NULL,	-- The difference of the highest and the lowest frequency, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz
	"Channel" varchar NULL,	-- A name describing the frequency used
	"Frequency" varchar NULL,	-- The nominal frequency used, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz
	"Frequencyuse" varchar NULL,	-- expected values are: Transmit, Receive, TransmitReceive
	"Polarization" varchar NULL,
	"Purposeoffrequencyuse" varchar NULL,	-- expected values are: observation, telecomms
	"Transmissionmode" varchar NULL,	-- expected values are: pulsed, continuous use conditional on frequencyUse = Transmit
	"FrequenciesID" varchar NOT NULL,
	"EquipmentID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Frequencies" ADD CONSTRAINT "PK_Frequencies"
	PRIMARY KEY ("FrequenciesID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Frequencies" ADD CONSTRAINT "FK_Frequencies_Equipment"
	FOREIGN KEY ("EquipmentID") REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON COLUMN "Frequencies"."Bandwidth"
	IS 'The difference of the highest and the lowest frequency, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz'
;

COMMENT ON COLUMN "Frequencies"."Channel"
	IS 'A name describing the frequency used'
;

COMMENT ON COLUMN "Frequencies"."Frequency"
	IS 'The nominal frequency used, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz'
;

COMMENT ON COLUMN "Frequencies"."Frequencyuse"
	IS 'expected values are: Transmit, Receive, TransmitReceive'
;

COMMENT ON COLUMN "Frequencies"."Purposeoffrequencyuse"
	IS 'expected values are: observation, telecomms'
;

COMMENT ON COLUMN "Frequencies"."Transmissionmode"
	IS 'expected values are: pulsed, continuous
use conditional on frequencyUse = Transmit'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Frequencyusetype" CASCADE
;

/* Create Tables */

CREATE TABLE "Frequencyusetype"
(
	"FrequencyusetypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Frequencyusetype" ADD CONSTRAINT "PK_Frequencyusetype"
	PRIMARY KEY ("FrequencyusetypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Frequencyusetype"
	IS '5-03 Instrument specifications. This is a proxy for several more specific elements, her used for FeatureType "Frequencies". Frequency use type (transmit, receive, telecoms)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Geopositioning-method" CASCADE
;

/* Create Tables */

CREATE TABLE "Geopositioning-method"
(
	"Geopositioning-methodID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Geopositioning-method" ADD CONSTRAINT "PK_Geopositioning-method"
	PRIMARY KEY ("Geopositioning-methodID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Geopositioning-method"
	IS 'The value for geopositioningMethod, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/GeopoistioningMethod.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Geopositioningmethodtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Geopositioningmethodtype"
(
	"GeopositioningmethodtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Geopositioningmethodtype" ADD CONSTRAINT "PK_Geopositioningmethodtype"
	PRIMARY KEY ("GeopositioningmethodtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Geopositioningmethodtype"
	IS 'Geopositiong Method / Coordinate Source codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Geospatiallocation" CASCADE
;

/* Create Tables */

CREATE TABLE "Geospatiallocation"
(
	"Coordinatereferencesystem" varchar NULL,
	"Geolocation" varchar NULL,	-- 3-07 Representative or conventional geospatial location of observing facility, the reference location. This will always be a point location, but this location can change with time.  5-12 Geospatial location of instrument or observing equipment, typically the location of the sensing element or sample inlet. This will always be a point location, but this location can change with time. 
	"Geopositioningmethod" varchar NULL,	-- Element describes the method used to establish the specified geoLocation. [Codelist 11-01]
	"Validperiod" varchar NULL,	-- The time period for which this geoLocation is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next geoLocation on record.
	"GeospatiallocationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Geospatiallocation" ADD CONSTRAINT "PK_Geospatiallocation"
	PRIMARY KEY ("GeospatiallocationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Geospatiallocation"
	IS 'A GeospatialLocation is a geospatial location accompanied by a timestamp indicating the time from which that location is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple locations which are valid over different periods of time.'
;

COMMENT ON COLUMN "Geospatiallocation"."Geolocation"
	IS '3-07 Representative or conventional geospatial location of observing facility, the reference location. This will always be a point location, but this location can change with time.

5-12 Geospatial location of instrument or observing equipment, typically the location of the sensing element or sample inlet. This will always be a point location, but this location can change with time. '
;

COMMENT ON COLUMN "Geospatiallocation"."Geopositioningmethod"
	IS 'Element describes the method used to establish the specified geoLocation. [Codelist 11-01]'
;

COMMENT ON COLUMN "Geospatiallocation"."Validperiod"
	IS 'The time period for which this geoLocation is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next geoLocation on record.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Header" CASCADE
;

/* Create Tables */

CREATE TABLE "Header"
(
	"Filedatetime" varchar NULL,	-- Date and time this file was last updated.
	"Recordowner" varchar NULL,	-- The organisation responsible for the metadata.
	"Version" varchar NULL,
	"HeaderID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Header" ADD CONSTRAINT "PK_Header"
	PRIMARY KEY ("HeaderID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Header"
	IS 'Header contains header information about a WIGOSMetadataRecord. This is metadata about the record used to facilitate transport or ingestion into a system such as OSCAR.'
;

COMMENT ON COLUMN "Header"."Filedatetime"
	IS 'Date and time this file was last updated.'
;

COMMENT ON COLUMN "Header"."Recordowner"
	IS 'The organisation responsible for the metadata.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Instrumentcontrolresulttype" CASCADE
;

/* Create Tables */

CREATE TABLE "Instrumentcontrolresulttype"
(
	"InstrumentcontrolresulttypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Instrumentcontrolresulttype" ADD CONSTRAINT "PK_Instrumentcontrolresulttype"
	PRIMARY KEY ("InstrumentcontrolresulttypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Instrumentcontrolresulttype"
	IS 'Result of an instrument control check'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Instrumentcontrolscheduletype" CASCADE
;

/* Create Tables */

CREATE TABLE "Instrumentcontrolscheduletype"
(
	"InstrumentcontrolscheduletypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Instrumentcontrolscheduletype" ADD CONSTRAINT "PK_Instrumentcontrolscheduletype"
	PRIMARY KEY ("InstrumentcontrolscheduletypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Instrumentcontrolscheduletype"
	IS '5-07 Instrument control schedule'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Instrument-operating-status" CASCADE
;

/* Create Tables */

CREATE TABLE "Instrument-operating-status"
(
	"Instrument-operating-statusID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Instrument-operating-status" ADD CONSTRAINT "PK_Instrument-operating-status"
	PRIMARY KEY ("Instrument-operating-statusID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Instrument-operating-status"
	IS 'The value for instrumentOperatingStatus shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/InstrumentOperatingStatus.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Instrumentoperatingstatus" CASCADE
;

/* Create Tables */

CREATE TABLE "Instrumentoperatingstatus"
(
	"Instrumentoperatingstatus" varchar NULL,
	"Validperiod" varchar NULL,	-- The time period for which the specified instrumentOperatingStatus is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next instrumentOperatingStatus on record. If only one instrumentOperatingStatus is specified for an equipment, the time stamp is optional.
	"InstrumentoperatingstatusID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Instrumentoperatingstatus" ADD CONSTRAINT "PK_Instrumentoperatingstatus"
	PRIMARY KEY ("InstrumentoperatingstatusID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON COLUMN "Instrumentoperatingstatus"."Validperiod"
	IS 'The time period for which the specified instrumentOperatingStatus is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next instrumentOperatingStatus on record. If only one instrumentOperatingStatus is specified for an equipment, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Instrumentoperatingstatustype" CASCADE
;

/* Create Tables */

CREATE TABLE "Instrumentoperatingstatustype"
(
	"InstrumentoperatingstatustypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Instrumentoperatingstatustype" ADD CONSTRAINT "PK_Instrumentoperatingstatustype"
	PRIMARY KEY ("InstrumentoperatingstatustypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Instrumentoperatingstatustype"
	IS '5-04 Instrument operating status'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Level-of-data" CASCADE
;

/* Create Tables */

CREATE TABLE "Level-of-data"
(
	"Level-of-dataID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Level-of-data" ADD CONSTRAINT "PK_Level-of-data"
	PRIMARY KEY ("Level-of-dataID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Level-of-data"
	IS 'The value for levelOfData, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/LevelOfData.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Levelofdatatype" CASCADE
;

/* Create Tables */

CREATE TABLE "Levelofdatatype"
(
	"LevelofdatatypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Levelofdatatype" ADD CONSTRAINT "PK_Levelofdatatype"
	PRIMARY KEY ("LevelofdatatypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Levelofdatatype"
	IS 'Level of data codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Localreferencesurfacetype" CASCADE
;

/* Create Tables */

CREATE TABLE "Localreferencesurfacetype"
(
	"LocalreferencesurfacetypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Localreferencesurfacetype" ADD CONSTRAINT "PK_Localreferencesurfacetype"
	PRIMARY KEY ("LocalreferencesurfacetypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Localreferencesurfacetype"
	IS '5-05 Local Reference Surface type.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Local-topography" CASCADE
;

/* Create Tables */

CREATE TABLE "Local-topography"
(
	"Local-topographyID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Local-topography" ADD CONSTRAINT "PK_Local-topography"
	PRIMARY KEY ("Local-topographyID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Local-topography"
	IS 'The value for localTopography, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/LocalTopography.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Localtopographytype" CASCADE
;

/* Create Tables */

CREATE TABLE "Localtopographytype"
(
	"LocaltopographytypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Localtopographytype" ADD CONSTRAINT "PK_Localtopographytype"
	PRIMARY KEY ("LocaltopographytypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Localtopographytype"
	IS 'Local topography codelist (based on Speight 2009)'
;
/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Maintenancereport" CASCADE
;

/* Create Tables */

CREATE TABLE "Maintenancereport"
(
	"Maintenanceparty" varchar NULL,	-- 5-11 Details of who performed the maintenance (individual or organisation).
	"MaintenancereportID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Maintenancereport" ADD CONSTRAINT "PK_Maintenancereport"
	PRIMARY KEY ("MaintenancereportID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Maintenancereport" ADD CONSTRAINT "FK_MaintenanceReport_LogEntry"
	FOREIGN KEY ("MaintenancereportID") REFERENCES "Logentry" ("LogentryID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Maintenancereport"
	IS '5-13 Description of maintenance (actual) performed on instrument.'
;

COMMENT ON COLUMN "Maintenancereport"."Maintenanceparty"
	IS '5-11 Details of who performed the maintenance (individual or organisation).'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Measurementunittype" CASCADE
;

/* Create Tables */

CREATE TABLE "Measurementunittype"
(
	"MeasurementunittypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Measurementunittype" ADD CONSTRAINT "PK_Measurementunittype"
	PRIMARY KEY ("MeasurementunittypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Measurementunittype"
	IS 'Codelist for Measurement Unit [according to common code table C-6 (WMO, 2013)]'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Metadata-record" CASCADE
;

/* Create Tables */

CREATE TABLE "Metadata-record"
(
	"Metadata-record" varchar NULL,
	"Metadata-recordID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Metadata-record" ADD CONSTRAINT "PK_Metadata-record"
	PRIMARY KEY ("Metadata-recordID")
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observation-feature-of-interest" CASCADE
;

/* Create Tables */

CREATE TABLE "Observation-feature-of-interest"
(
	"Observation-feature-of-interestID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observation-feature-of-interest" ADD CONSTRAINT "PK_Observation-feature-of-interest"
	PRIMARY KEY ("Observation-feature-of-interestID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observation-feature-of-interest"
	IS 'XML encodings of OM_Observation in WIGOS shall use O&M Spatial Sampling Features to describe the om:featureOfInterest as a feature with geometry describing the geometric location or range of the observations.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observation-observed-property" CASCADE
;

/* Create Tables */

CREATE TABLE "Observation-observed-property"
(
	"Observation-observed-propertyID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observation-observed-property" ADD CONSTRAINT "PK_Observation-observed-property"
	PRIMARY KEY ("Observation-observed-propertyID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observation-observed-property"
	IS 'The value for om:observedProperty (observed variable) shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ObservedVariable'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observation-process" CASCADE
;

/* Create Tables */

CREATE TABLE "Observation-process"
(
	"Observation-processID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observation-process" ADD CONSTRAINT "PK_Observation-process"
	PRIMARY KEY ("Observation-processID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observation-process"
	IS 'XML encodings of OM_Observation in WIGOS shall use the WIGOS Process type to describe the om:procedure.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observation-result" CASCADE
;

/* Create Tables */

CREATE TABLE "Observation-result"
(
	"Observation-resultID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observation-result" ADD CONSTRAINT "PK_Observation-result"
	PRIMARY KEY ("Observation-resultID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observation-result"
	IS 'XML encodings of OM_Observation in WIGOS shall use the WIGOS ResultSet type to describe the om:result.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observation" CASCADE
;

/* Create Tables */

CREATE TABLE "Observation"
(
	"Observation-segment" varchar NULL,
	"ObservationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observation" ADD CONSTRAINT "PK_Observation"
	PRIMARY KEY ("ObservationID")
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observation-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Observation-valid"
(
	"Observation-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observation-valid" ADD CONSTRAINT "PK_Observation-valid"
	PRIMARY KEY ("Observation-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observation-valid"
	IS 'XML encodings of OM_Observation shall conform to the XML form for OM_Observation specified in ISO 19156 O&M XML schema. '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observedvariabletype" CASCADE
;

/* Create Tables */

CREATE TABLE "Observedvariabletype"
(
	"ObservedvariabletypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observedvariabletype" ADD CONSTRAINT "PK_Observedvariabletype"
	PRIMARY KEY ("ObservedvariabletypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observedvariabletype"
	IS 'Observed variable - measurand'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observingcapability" CASCADE
;

/* Create Tables */

CREATE TABLE "Observingcapability"
(
	"Observation" varchar NULL,
	"Programaffiliation" varchar NULL,
	"ObservingcapabilityID" varchar NOT NULL,
	facility varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observingcapability" ADD CONSTRAINT "PK_Observingcapability"
	PRIMARY KEY ("ObservingcapabilityID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Observingcapability" ADD CONSTRAINT "FK_ObservingCapability_facility"
	FOREIGN KEY (facility) REFERENCES "Observingfacility" ("ObservingfacilityID") ON DELETE No Action ON UPDATE No Action
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observing-facility" CASCADE
;

/* Create Tables */

CREATE TABLE "Observing-facility"
(
	"Observing-facility" varchar NULL,
	"Observing-facilityID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observing-facility" ADD CONSTRAINT "PK_Observing-facility"
	PRIMARY KEY ("Observing-facilityID")
;
/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observingfacilitytype" CASCADE
;

/* Create Tables */

CREATE TABLE "Observingfacilitytype"
(
	"ObservingfacilitytypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observingfacilitytype" ADD CONSTRAINT "PK_Observingfacilitytype"
	PRIMARY KEY ("ObservingfacilitytypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observingfacilitytype"
	IS 'Codelist for classifications of Observing Facilities (Stations, Platforms)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observing-method" CASCADE
;

/* Create Tables */

CREATE TABLE "Observing-method"
(
	"Observing-methodID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observing-method" ADD CONSTRAINT "PK_Observing-method"
	PRIMARY KEY ("Observing-methodID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observing-method"
	IS 'The value(s) for observingMethod shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ObservingMethod.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Observingmethodtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Observingmethodtype"
(
	"ObservingmethodtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Observingmethodtype" ADD CONSTRAINT "PK_Observingmethodtype"
	PRIMARY KEY ("ObservingmethodtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Observingmethodtype"
	IS '5-02 Measurement/observing method type'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Polarizationtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Polarizationtype"
(
	"PolarizationtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Polarizationtype" ADD CONSTRAINT "PK_Polarizationtype"
	PRIMARY KEY ("PolarizationtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Polarizationtype"
	IS '5-03 Instrument specifications. This is a proxy for several more specific elements, her used for FeatureType "Frequencies". Polarization type (LHCP, RHCP, linear, LHCD&RHCP, single, dual)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Population" CASCADE
;

/* Create Tables */

CREATE TABLE "Population"
(
	"Population10km" varchar NULL,	-- Population in a 10 km radius around the observing facility, specified in 1000s.
	"Population50km" varchar NULL,	-- Population in a 50 km radius around the observing facility, specified in 1000s.
	"Validperiod" varchar NULL,	-- The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.
	"PopulationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Population" ADD CONSTRAINT "PK_Population"
	PRIMARY KEY ("PopulationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Population"
	IS 'A Population is a population specification accompanied by a timestamp indicating the time from which that population is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple population specifications which are valid over different consecutive periods of time. If only a single population is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Population"."Population10km"
	IS 'Population in a 10 km radius around the observing facility, specified in 1000s.'
;

COMMENT ON COLUMN "Population"."Population50km"
	IS 'Population in a 50 km radius around the observing facility, specified in 1000s.'
;

COMMENT ON COLUMN "Population"."Validperiod"
	IS 'The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Processing" CASCADE
;

/* Create Tables */

CREATE TABLE "Processing"
(
	"Aggregationperiod" varchar NULL,	-- 7-09 Time period over which individual samples/observations are aggregated
	"Dataprocessing" varchar NULL,	-- 7-01 A description of the data processing used to generate observations including, if relevant, algorithms used to derive the result.
	"Processingcentre" varchar NULL,	-- 7-02 Center at which the observation is processed. Although this is a free text string, it is expected that in practice this value should be from a controlled list of known centers.
	"Softwaredetails" varchar NULL,	-- 7-05 Name and version of the software or processor used to derive the values
	"Softwareurl" varchar NULL,	-- 7-05 URL for the software or processor used to derive the values
	"ProcessingID" varchar NOT NULL,
	"DatagenerationID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Processing" ADD CONSTRAINT "PK_Processing"
	PRIMARY KEY ("ProcessingID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Processing" ADD CONSTRAINT "FK_Processing_processing"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Processing"
	IS '[WMDS Category 7] Details of the processing procedures including analysis and post-processing.'
;

COMMENT ON COLUMN "Processing"."Aggregationperiod"
	IS '7-09 Time period over which individual samples/observations are aggregated'
;

COMMENT ON COLUMN "Processing"."Dataprocessing"
	IS '7-01 A description of the data processing used to generate observations including, if relevant, algorithms used to derive the result.'
;

COMMENT ON COLUMN "Processing"."Processingcentre"
	IS '7-02 Center at which the observation is processed. Although this is a free text string, it is expected that in practice this value should be from a controlled list of known centers.'
;

COMMENT ON COLUMN "Processing"."Softwaredetails"
	IS '7-05 Name and version of the software or processor used to derive the values'
;

COMMENT ON COLUMN "Processing"."Softwareurl"
	IS '7-05 URL for the software or processor used to derive the values'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Processing-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Processing-valid"
(
	"Processing-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Processing-valid" ADD CONSTRAINT "PK_Processing-valid"
	PRIMARY KEY ("Processing-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Processing-valid"
	IS 'XML encodings of Processing shall conform to the XML form for Processing specified in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Process" CASCADE
;

/* Create Tables */

CREATE TABLE "Process"
(
	"Extension" varchar NULL,	-- This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks. However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. 
	"ProcessID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Process" ADD CONSTRAINT "PK_Process"
	PRIMARY KEY ("ProcessID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Process"
	IS 'Details of the process used in the observation'
;

COMMENT ON COLUMN "Process"."Extension"
	IS 'This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks.
However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Process-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Process-valid"
(
	"Process-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Process-valid" ADD CONSTRAINT "PK_Process-valid"
	PRIMARY KEY ("Process-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Process-valid"
	IS 'XML encodings of Process shall conform to the XML form for Process specified in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Program-affiliation" CASCADE
;

/* Create Tables */

CREATE TABLE "Program-affiliation"
(
	"Program-affiliationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Program-affiliation" ADD CONSTRAINT "PK_Program-affiliation"
	PRIMARY KEY ("Program-affiliationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Program-affiliation"
	IS 'The value(s) for programAffiliation shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ProgramAffiliation.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Programaffiliation" CASCADE
;

/* Create Tables */

CREATE TABLE "Programaffiliation"
(
	"Programaffiliation" varchar NULL,
	"Programspecificfacilityid" varchar NULL,
	"Reportingstatus" varchar NULL,
	"ProgramaffiliationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Programaffiliation" ADD CONSTRAINT "PK_Programaffiliation"
	PRIMARY KEY ("ProgramaffiliationID")
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Programornetworkaffiliationtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Programornetworkaffiliationtype"
(
	"ProgramornetworkaffiliationtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Programornetworkaffiliationtype" ADD CONSTRAINT "PK_Programornetworkaffiliationtype"
	PRIMARY KEY ("ProgramornetworkaffiliationtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Programornetworkaffiliationtype"
	IS 'Codelist of Programme or Network Affiliations'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Purposeoffrequencyusetype" CASCADE
;

/* Create Tables */

CREATE TABLE "Purposeoffrequencyusetype"
(
	"PurposeoffrequencyusetypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Purposeoffrequencyusetype" ADD CONSTRAINT "PK_Purposeoffrequencyusetype"
	PRIMARY KEY ("PurposeoffrequencyusetypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Purposeoffrequencyusetype"
	IS '5-03 Instrument specifications. This is a proxy for several more specific elements, here used for Type "PurposeOfFrequencyUseType". PurposeOfFrequencyUseType uses values (observation, telecomms)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Qualityflagtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Qualityflagtype"
(
	"QualityflagtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Qualityflagtype" ADD CONSTRAINT "PK_Qualityflagtype"
	PRIMARY KEY ("QualityflagtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Qualityflagtype"
	IS 'Quality Flag codelist. '
;
/*
Initial PosgtreSQL DDL for WIGOS Metadata Representation ([WMDR](https://github.com/wmo-im/wmdr))
*/
/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Record-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Record-valid"
(
	"Record-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Record-valid" ADD CONSTRAINT "PK_Record-valid"
	PRIMARY KEY ("Record-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Record-valid"
	IS 'XML encodings of WIGOSMetadataRecord shall conform to the XML form for WIGOSMetadataRecord specified in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Reference-time" CASCADE
;

/* Create Tables */

CREATE TABLE "Reference-time"
(
	"Reference-timeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Reference-time" ADD CONSTRAINT "PK_Reference-time"
	PRIMARY KEY ("Reference-timeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Reference-time"
	IS 'The value for referenceTime, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ReferenceTime.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Referencetimetype" CASCADE
;

/* Create Tables */

CREATE TABLE "Referencetimetype"
(
	"ReferencetimetypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Referencetimetype" ADD CONSTRAINT "PK_Referencetimetype"
	PRIMARY KEY ("ReferencetimetypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Referencetimetype"
	IS '710 Reference time codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Relative-elevation" CASCADE
;

/* Create Tables */

CREATE TABLE "Relative-elevation"
(
	"Relative-elevationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Relative-elevation" ADD CONSTRAINT "PK_Relative-elevation"
	PRIMARY KEY ("Relative-elevationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Relative-elevation"
	IS 'The value for relativeElevation, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/RelativeElevation.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Relativeelevationtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Relativeelevationtype"
(
	"RelativeelevationtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Relativeelevationtype" ADD CONSTRAINT "PK_Relativeelevationtype"
	PRIMARY KEY ("RelativeelevationtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Relativeelevationtype"
	IS 'Relative elevation codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Reporting" CASCADE
;

/* Create Tables */

CREATE TABLE "Reporting"
(
	"Dataformat" varchar NULL,	-- 7-07 Description of the format in which the observed variable is primarily being provided, from the DataFormatType codelist. 
	"Dataformatversion" varchar NULL,	-- 7-08 Version of the data format.
	"Datapolicy" varchar NULL,	-- 9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.
	"Internationalexchange" varchar NULL,
	"Levelofdata" varchar NULL,	-- 7-06 Level of data processing
	"Numberofobservationsinreportinginterval" varchar NULL,	-- Specifies how many aggregated observations are reported on average in each temporal reporting interval. For full temporal coverage, the number of observations reported = temporal reporting interval / aggregation period.
	"Numericalresolution" varchar NULL,	-- 7-12 Numerical resolution is a measure of the detail to which a numerical quantity is expressed. This is synonymous to numerical precision of the reporting, but can be different than the numerical precision of the observed value.
	"Officialstatus" varchar NULL,	-- 5-14 Official status of observation.
	"Referencedatum" varchar NULL,	-- 7-11 Reference datum used to convert observed quantity to reported quantity
	"Referencetimesource" varchar NULL,	-- 7-10 Time reference used for observations.
	"Spatialreportinginterval" varchar NULL,	-- 7-03 Spatial interval over which the observed variable is reported. Note that this is expressed as length, without geo-referencing. 
	"Temporalreportinginterval" varchar NULL,	-- 7-03 Time interval over which the observed variable is reported. Note that this is a temporal distance, e.g., (every) 1 hour. 
	"Timeliness" varchar NULL,	-- 7-13 Timeliness of reporting is the typical time taken between completion of the observation and when it becomes available to users.
	"Timestampmeaning" varchar NULL,	-- 7-03 Meaning of the time stamp in the temporalReportingInterval taken from the TimeStampMeaning codelist.
	"Uom" varchar NULL,	-- 1-02 Measurement Unit (unit of measure)
	"ReportingID" varchar NOT NULL,
	"DatagenerationID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Reporting" ADD CONSTRAINT "PK_Reporting"
	PRIMARY KEY ("ReportingID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Reporting" ADD CONSTRAINT "FK_Reporting_reporting"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Reporting"
	IS '[WMDS Category 7] Details of the reporting procedures.'
;

COMMENT ON COLUMN "Reporting"."Dataformat"
	IS '7-07 Description of the format in which the observed variable is primarily being provided, from the DataFormatType codelist. '
;

COMMENT ON COLUMN "Reporting"."Dataformatversion"
	IS '7-08 Version of the data format.'
;

COMMENT ON COLUMN "Reporting"."Datapolicy"
	IS '9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.'
;

COMMENT ON COLUMN "Reporting"."Levelofdata"
	IS '7-06 Level of data processing'
;

COMMENT ON COLUMN "Reporting"."Numberofobservationsinreportinginterval"
	IS 'Specifies how many aggregated observations are reported on average in each temporal reporting interval. For full temporal coverage, the number of observations reported = temporal reporting interval / aggregation period.'
;

COMMENT ON COLUMN "Reporting"."Numericalresolution"
	IS '7-12 Numerical resolution is a measure of the detail to which a numerical quantity is expressed. This is synonymous to numerical precision of the reporting, but can be different than the numerical precision of the observed value.'
;

COMMENT ON COLUMN "Reporting"."Officialstatus"
	IS '5-14 Official status of observation.'
;

COMMENT ON COLUMN "Reporting"."Referencedatum"
	IS '7-11 Reference datum used to convert observed quantity to reported quantity'
;

COMMENT ON COLUMN "Reporting"."Referencetimesource"
	IS '7-10 Time reference used for observations.'
;

COMMENT ON COLUMN "Reporting"."Spatialreportinginterval"
	IS '7-03 Spatial interval over which the observed variable is reported. Note that this is expressed as length, without geo-referencing. '
;

COMMENT ON COLUMN "Reporting"."Temporalreportinginterval"
	IS '7-03 Time interval over which the observed variable is reported. Note that this is a temporal distance, e.g., (every) 1 hour. '
;

COMMENT ON COLUMN "Reporting"."Timeliness"
	IS '7-13 Timeliness of reporting is the typical time taken between completion of the observation and when it becomes available to users.'
;

COMMENT ON COLUMN "Reporting"."Timestampmeaning"
	IS '7-03 Meaning of the time stamp in the temporalReportingInterval taken from the TimeStampMeaning codelist.'
;

COMMENT ON COLUMN "Reporting"."Uom"
	IS '1-02 Measurement Unit (unit of measure)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Reporting-status" CASCADE
;

/* Create Tables */

CREATE TABLE "Reporting-status"
(
	"Reporting-statusID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Reporting-status" ADD CONSTRAINT "PK_Reporting-status"
	PRIMARY KEY ("Reporting-statusID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Reporting-status"
	IS 'The value for reportingStatus shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ReportingStatus.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Reportingstatus" CASCADE
;

/* Create Tables */

CREATE TABLE "Reportingstatus"
(
	"Reportingstatus" varchar NULL,	-- 3-09 Declared reporting status of an observing facility [under a certain network/program affiliation]. 
	"Validperiod" varchar NULL,	-- The time period for which the specified reporting status is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one reporting status is specified for an observing facility, the time stamp is optional.
	"ReportingstatusID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Reportingstatus" ADD CONSTRAINT "PK_Reportingstatus"
	PRIMARY KEY ("ReportingstatusID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Reportingstatus"
	IS 'A ReportingStatus is a reporting / operational status of an observing facility accompanied by a timestamp indicating the time from which that status is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple reporting statuses which are valid over different consecutive periods of time. If only a single reporting status is specified, the timestamp is optional and is inferred from the dateEstablished.'
;

COMMENT ON COLUMN "Reportingstatus"."Reportingstatus"
	IS '3-09 Declared reporting status of an observing facility [under a certain network/program affiliation]. '
;

COMMENT ON COLUMN "Reportingstatus"."Validperiod"
	IS 'The time period for which the specified reporting status is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one reporting status is specified for an observing facility, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Reportingstatustype" CASCADE
;

/* Create Tables */

CREATE TABLE "Reportingstatustype"
(
	"ReportingstatustypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Reportingstatustype" ADD CONSTRAINT "PK_Reportingstatustype"
	PRIMARY KEY ("ReportingstatustypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Reportingstatustype"
	IS 'Station reporting status'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Reporting-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Reporting-valid"
(
	"Reporting-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Reporting-valid" ADD CONSTRAINT "PK_Reporting-valid"
	PRIMARY KEY ("Reporting-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Reporting-valid"
	IS 'XML encodings of Reporting shall conform to the XML form for Reporting specified in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Representativeness" CASCADE
;

/* Create Tables */

CREATE TABLE "Representativeness"
(
	"RepresentativenessID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Representativeness" ADD CONSTRAINT "PK_Representativeness"
	PRIMARY KEY ("RepresentativenessID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Representativeness"
	IS 'The value for representativeness, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/Representativeness


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Representativenesstype" CASCADE
;

/* Create Tables */

CREATE TABLE "Representativenesstype"
(
	"RepresentativenesstypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Representativenesstype" ADD CONSTRAINT "PK_Representativenesstype"
	PRIMARY KEY ("RepresentativenesstypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Representativenesstype"
	IS 'Representativeness codelist.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Responsibleparty" CASCADE
;

/* Create Tables */

CREATE TABLE "Responsibleparty"
(
	"Responsibleparty" varchar NULL,	-- 10-01 Party (organization or individual) responsible for the observing facility or equipment.
	"Validperiod" varchar NULL,	-- The time period for which this responsibleParty is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next responsibleParty on record.
	"ResponsiblepartyID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Responsibleparty" ADD CONSTRAINT "PK_Responsibleparty"
	PRIMARY KEY ("ResponsiblepartyID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Responsibleparty"
	IS 'A ResponsibleParty is an individual or organization accompanied by a timestamp indicating the time from which that responsibleParty is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple responsibleParty which are valid over different periods of time.'
;

COMMENT ON COLUMN "Responsibleparty"."Responsibleparty"
	IS '10-01 Party (organization or individual) responsible for the observing facility or equipment.'
;

COMMENT ON COLUMN "Responsibleparty"."Validperiod"
	IS 'The time period for which this responsibleParty is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next responsibleParty on record.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Resultset" CASCADE
;

/* Create Tables */

CREATE TABLE "Resultset"
(
	"Distributioninfo" varchar NULL,	-- The distributionInfo provides information about how to source the data, described using MD_Distribution from ISO 19115.
	"ResultsetID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Resultset" ADD CONSTRAINT "PK_Resultset"
	PRIMARY KEY ("ResultsetID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Resultset"
	IS 'The ResultSet contains distribution information for the observation result(s). This may contain direct links to the data or to services or websites where the data can be sourced. Each MD_Distribution shall use CI_OnlineResource to point to URLs where data can be found. In order to distinguish the different URLs in a ResultSet. the description property of each MD_Distribution shall be used do describe what the URL resolves to (near real time data, archive etc.)'
;

COMMENT ON COLUMN "Resultset"."Distributioninfo"
	IS 'The distributionInfo provides information about how to source the data, described using MD_Distribution from ISO 19115.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Sampletreatmenttype" CASCADE
;

/* Create Tables */

CREATE TABLE "Sampletreatmenttype"
(
	"SampletreatmenttypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Sampletreatmenttype" ADD CONSTRAINT "PK_Sampletreatmenttype"
	PRIMARY KEY ("SampletreatmenttypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Sampletreatmenttype"
	IS 'Sample Treatment codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Samplingproceduretype" CASCADE
;

/* Create Tables */

CREATE TABLE "Samplingproceduretype"
(
	"SamplingproceduretypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Samplingproceduretype" ADD CONSTRAINT "PK_Samplingproceduretype"
	PRIMARY KEY ("SamplingproceduretypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Samplingproceduretype"
	IS 'Sampling Procedure codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Sampling" CASCADE
;

/* Create Tables */

CREATE TABLE "Sampling"
(
	"Sampling" varchar NULL,
	"SamplingID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Sampling" ADD CONSTRAINT "PK_Sampling"
	PRIMARY KEY ("SamplingID")
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Sampling-strategy" CASCADE
;

/* Create Tables */

CREATE TABLE "Sampling-strategy"
(
	"Sampling-strategyID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Sampling-strategy" ADD CONSTRAINT "PK_Sampling-strategy"
	PRIMARY KEY ("Sampling-strategyID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Sampling-strategy"
	IS 'The value for samplingStrategy, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdsSamplingStrategy.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Samplingstrategytype" CASCADE
;

/* Create Tables */

CREATE TABLE "Samplingstrategytype"
(
	"SamplingstrategytypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Samplingstrategytype" ADD CONSTRAINT "PK_Samplingstrategytype"
	PRIMARY KEY ("SamplingstrategytypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Samplingstrategytype"
	IS 'Sampling Strategy codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Sampling-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Sampling-valid"
(
	"Sampling-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Sampling-valid" ADD CONSTRAINT "PK_Sampling-valid"
	PRIMARY KEY ("Sampling-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Sampling-valid"
	IS 'XML encodings of Sampling shall conform to the XML form for Sampling specified in the WMDR XML Schema.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Schedule" CASCADE
;

/* Create Tables */

CREATE TABLE "Schedule"
(
	"Diurnalbasetime" varchar NULL,
	"Endhour" varchar NULL,	-- End hour of schedule (0 to 23)
	"Endminute" varchar NULL,	-- End minute of schedule (0 to 59)
	"Endmonth" varchar NULL,	-- End month of schedule (January = 1, December = 12)
	"Endweekday" varchar NULL,	-- End day of schedule (Monday = 1, Sunday = 7)
	"Starthour" varchar NULL,	-- Start hour of schedule (0 to 23)
	"Startminute" varchar NULL,	-- Start minute of schedule (0 to 59)
	"Startmonth" varchar NULL,	-- Start month of schedule (January = 1, December = 12)
	"Startweekday" varchar NULL,	-- Start day of schedule (Monday = 1, Sunday = 7)
	"ScheduleID" varchar NOT NULL,
	"DatagenerationID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Schedule" ADD CONSTRAINT "PK_Schedule"
	PRIMARY KEY ("ScheduleID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Schedule" ADD CONSTRAINT "FK_Schedule_schedule"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Schedule"
	IS '6-08 Description of the schedule of observation. Note: Schedules are defined in terms of months covered, weekdays covered, hours and minutes covered during each day. A complete definition of a schedule requires specification of the temporalReportingInterval, and may require the specification of diurnalBaseTime.'
;

COMMENT ON COLUMN "Schedule"."Endhour"
	IS 'End hour of schedule (0 to 23)'
;

COMMENT ON COLUMN "Schedule"."Endminute"
	IS 'End minute of schedule (0 to 59)'
;

COMMENT ON COLUMN "Schedule"."Endmonth"
	IS 'End month of schedule (January = 1, December = 12)'
;

COMMENT ON COLUMN "Schedule"."Endweekday"
	IS 'End day of schedule (Monday = 1, Sunday = 7)'
;

COMMENT ON COLUMN "Schedule"."Starthour"
	IS 'Start hour of schedule (0 to 23)'
;

COMMENT ON COLUMN "Schedule"."Startminute"
	IS 'Start minute of schedule (0 to 59)'
;

COMMENT ON COLUMN "Schedule"."Startmonth"
	IS 'Start month of schedule (January = 1, December = 12)'
;

COMMENT ON COLUMN "Schedule"."Startweekday"
	IS 'Start day of schedule (Monday = 1, Sunday = 7)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Source-of-observation" CASCADE
;

/* Create Tables */

CREATE TABLE "Source-of-observation"
(
	"Source-of-observationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Source-of-observation" ADD CONSTRAINT "PK_Source-of-observation"
	PRIMARY KEY ("Source-of-observationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Source-of-observation"
	IS 'The value(s) for sourceOfObservation shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/SourceOfObservation.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Sourceofobservationtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Sourceofobservationtype"
(
	"SourceofobservationtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Sourceofobservationtype" ADD CONSTRAINT "PK_Sourceofobservationtype"
	PRIMARY KEY ("SourceofobservationtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Sourceofobservationtype"
	IS '5-01 Source of observations in dataset (e.g. manual, automatic, visual)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surface-cover-classification" CASCADE
;

/* Create Tables */

CREATE TABLE "Surface-cover-classification"
(
	"Surface-cover-classificationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surface-cover-classification" ADD CONSTRAINT "PK_Surface-cover-classification"
	PRIMARY KEY ("Surface-cover-classificationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surface-cover-classification"
	IS 'The value for surfaceCoverClassification shall be taken from one of the SurfaceCoverClassificationType codelists at http://codes.wmo.int.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surfacecoverclassificationtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Surfacecoverclassificationtype"
(
	"SurfacecoverclassificationtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surfacecoverclassificationtype" ADD CONSTRAINT "PK_Surfacecoverclassificationtype"
	PRIMARY KEY ("SurfacecoverclassificationtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surfacecoverclassificationtype"
	IS 'Surface Cover Classification Type'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surface-cover" CASCADE
;

/* Create Tables */

CREATE TABLE "Surface-cover"
(
	"Surface-coverID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surface-cover" ADD CONSTRAINT "PK_Surface-cover"
	PRIMARY KEY ("Surface-coverID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surface-cover"
	IS 'The value for surfaceCover, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/SurfaceCover.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surfacecover" CASCADE
;

/* Create Tables */

CREATE TABLE "Surfacecover"
(
	"Surfacecover" varchar NULL,	-- 4-01 The (bio)physical cover on the earth's surface in the vicinity of the observations from the LandCoverType codelist .  NOTE: Only applies for surface-based (fixed) observing facilities.
	"Surfacecoverclassification" varchar NULL,	-- 4-02 Reference to a surface cover classification type from the SurfaceCoverClassificationType codelist. NOTE: only if 4-01 is specified
	"Validperiod" varchar NULL,	-- The time period for which the specified surfaceCover is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceCover on record. If only one surfaceCover is specified for an observing facility, the time stamp is optional.
	"SurfacecoverID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surfacecover" ADD CONSTRAINT "PK_Surfacecover"
	PRIMARY KEY ("SurfacecoverID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surfacecover"
	IS 'A SurfaceCover is a climate zone accompanied by a timestamp indicating the time from which that surface cover class is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple surface cover classes which are valid over different consecutive periods of time. If only a single surface cover class is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Surfacecover"."Surfacecover"
	IS '4-01 The (bio)physical cover on the earth''s surface in the vicinity of the observations from the LandCoverType codelist . 
NOTE: Only applies for surface-based (fixed) observing facilities.'
;

COMMENT ON COLUMN "Surfacecover"."Surfacecoverclassification"
	IS '4-02 Reference to a surface cover classification type from the SurfaceCoverClassificationType codelist. NOTE: only if 4-01 is specified'
;

COMMENT ON COLUMN "Surfacecover"."Validperiod"
	IS 'The time period for which the specified surfaceCover is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceCover on record. If only one surfaceCover is specified for an observing facility, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surfacecovertype" CASCADE
;

/* Create Tables */

CREATE TABLE "Surfacecovertype"
(
	"SurfacecovertypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surfacecovertype" ADD CONSTRAINT "PK_Surfacecovertype"
	PRIMARY KEY ("SurfacecovertypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surfacecovertype"
	IS 'Surface cover types'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surface-roughness" CASCADE
;

/* Create Tables */

CREATE TABLE "Surface-roughness"
(
	"Surface-roughnessID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surface-roughness" ADD CONSTRAINT "PK_Surface-roughness"
	PRIMARY KEY ("Surface-roughnessID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surface-roughness"
	IS 'The value for surfaceRoughness shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/SurfaceRoughnessDavenport.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surfaceroughness" CASCADE
;

/* Create Tables */

CREATE TABLE "Surfaceroughness"
(
	"Surfaceroughness" varchar NULL,	-- 4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.
	"Validperiod" varchar NULL,	-- The time period for which the specified surfaceRoughness is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceRoughness on record. If only one surfaceRoughness is specified for an observing facility, the time stamp is optional.
	"SurfaceroughnessID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surfaceroughness" ADD CONSTRAINT "PK_Surfaceroughness"
	PRIMARY KEY ("SurfaceroughnessID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surfaceroughness"
	IS 'A SurfaceRoughness is a specification of surfaceRoughness accompanied by a timestamp indicating the time from which that surfaceRoughness is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple surfaceRoughness specifications which are valid over different consecutive periods of time. If only a single surfaceRoughness is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Surfaceroughness"."Surfaceroughness"
	IS '4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.'
;

COMMENT ON COLUMN "Surfaceroughness"."Validperiod"
	IS 'The time period for which the specified surfaceRoughness is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceRoughness on record. If only one surfaceRoughness is specified for an observing facility, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surfaceroughnesstype" CASCADE
;

/* Create Tables */

CREATE TABLE "Surfaceroughnesstype"
(
	"SurfaceroughnesstypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surfaceroughnesstype" ADD CONSTRAINT "PK_Surfaceroughnesstype"
	PRIMARY KEY ("SurfaceroughnesstypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surfaceroughnesstype"
	IS '4-06'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Territory-name" CASCADE
;

/* Create Tables */

CREATE TABLE "Territory-name"
(
	"Territory-nameID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Territory-name" ADD CONSTRAINT "PK_Territory-name"
	PRIMARY KEY ("Territory-nameID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Territory-name"
	IS 'The value for territoryName shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/TerritoryName.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Territory" CASCADE
;

/* Create Tables */

CREATE TABLE "Territory"
(
	"Territoryname" varchar NULL,	-- 3-02 The territory the observing facility is located in, from the TerritoryType codelist.
	"Validperiod" varchar NULL,	-- The time period for which the specified territory is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one territory is specified for an observing facility, the time stamp is optional.
	"TerritoryID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Territory" ADD CONSTRAINT "PK_Territory"
	PRIMARY KEY ("TerritoryID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Territory"
	IS 'A Territory is a territory specification accompanied by a timestamp indicating the time from which that territory is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple territories which are valid over different consecutive periods of time. If only a single territory is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Territory"."Territoryname"
	IS '3-02 The territory the observing facility is located in, from the TerritoryType codelist.'
;

COMMENT ON COLUMN "Territory"."Validperiod"
	IS 'The time period for which the specified territory is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one territory is specified for an observing facility, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Territorytype" CASCADE
;

/* Create Tables */

CREATE TABLE "Territorytype"
(
	"TerritorytypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Territorytype" ADD CONSTRAINT "PK_Territorytype"
	PRIMARY KEY ("TerritorytypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Territorytype"
	IS 'WMO Territories (territory of origin of the data)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Time-encoding" CASCADE
;

/* Create Tables */

CREATE TABLE "Time-encoding"
(
	"Time-encoding" varchar NULL,
	"Time-encodingID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Time-encoding" ADD CONSTRAINT "PK_Time-encoding"
	PRIMARY KEY ("Time-encodingID")
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Time-stamp-meaning" CASCADE
;

/* Create Tables */

CREATE TABLE "Time-stamp-meaning"
(
	"Time-stamp-meaningID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Time-stamp-meaning" ADD CONSTRAINT "PK_Time-stamp-meaning"
	PRIMARY KEY ("Time-stamp-meaningID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Time-stamp-meaning"
	IS 'The value for temporalReportingTimeStampMeaning, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/TimeStampMeaning.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Timestampmeaningtype" CASCADE
;

/* Create Tables */

CREATE TABLE "Timestampmeaningtype"
(
	"TimestampmeaningtypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Timestampmeaningtype" ADD CONSTRAINT "PK_Timestampmeaningtype"
	PRIMARY KEY ("TimestampmeaningtypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Timestampmeaningtype"
	IS 'Time stamp meaning codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Time-zone-explicit" CASCADE
;

/* Create Tables */

CREATE TABLE "Time-zone-explicit"
(
	"Time-zone-explicitID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Time-zone-explicit" ADD CONSTRAINT "PK_Time-zone-explicit"
	PRIMARY KEY ("Time-zone-explicitID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Time-zone-explicit"
	IS 'All times shall be encoded using ISO 8601 time format. A time-zone designator must be supplied for all times. If the time is given as UTC then the time zone designator is ''Z'' e.g.

2016-12-25T12:00Z

For times given in a local (non UTC) time the time zone designator shall be expressed as an offset from UTC using plus or minus offsets.

For example, the following date times are all the same moment in time:

2016-12-25T10:00Z (10am, timezone is  UTC)

2016-12-25T14:00+04:00  (2pm, timezone is UTC + 4 hours)

2016-12-25T06:00-04:00   (6am, timezone is UTC -4 hours)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Timezone" CASCADE
;

/* Create Tables */

CREATE TABLE "Timezone"
(
	"Timezone" varchar NULL,	-- Time zone of the observing facility
	"Validperiod" varchar NULL,	-- The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.
	"TimezoneID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Timezone" ADD CONSTRAINT "PK_Timezone"
	PRIMARY KEY ("TimezoneID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Timezone"
	IS 'A TmeZone is a timeZone specification accompanied by a timestamp indicating the time from which that timeZone is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple timeZone specifications which are valid over different consecutive periods of time. If only a single timeZone is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Timezone"."Timezone"
	IS 'Time zone of the observing facility'
;

COMMENT ON COLUMN "Timezone"."Validperiod"
	IS 'The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Timezonetype" CASCADE
;

/* Create Tables */

CREATE TABLE "Timezonetype"
(
	"TimezonetypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Timezonetype" ADD CONSTRAINT "PK_Timezonetype"
	PRIMARY KEY ("TimezonetypeID")
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Topographic-context" CASCADE
;

/* Create Tables */

CREATE TABLE "Topographic-context"
(
	"Topographic-contextID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Topographic-context" ADD CONSTRAINT "PK_Topographic-context"
	PRIMARY KEY ("Topographic-contextID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Topographic-context"
	IS 'The value for topographicContext, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/TopographicContext.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Topographiccontexttype" CASCADE
;

/* Create Tables */

CREATE TABLE "Topographiccontexttype"
(
	"TopographiccontexttypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Topographiccontexttype" ADD CONSTRAINT "PK_Topographiccontexttype"
	PRIMARY KEY ("TopographiccontexttypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Topographiccontexttype"
	IS 'Topographic Context codelist (based on Hammond 1954)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Topographybathymetry" CASCADE
;

/* Create Tables */

CREATE TABLE "Topographybathymetry"
(
	"Altitudeordepth" varchar NULL,	-- 4-03 The altitude/depth with respect to mean sea level from the AltitudeOrDepthTypeCodelist
	"Localtopography" varchar NULL,	-- 4-03 The local topography from the LocalTopographyType codelist
	"Relativeelevation" varchar NULL,	-- 4-03 The relative elevation from the RelativeElevationType codelist
	"Topographiccontext" varchar NULL,	-- 4-03 The topographic context from the TopographicContextType codelist
	"Validperiod" varchar NULL,	-- The time period for which the specified topographyBathymetry is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next topographyBathymetry on record. If only one topographyBathymetry is specified for an observing facility, the time stamp is optional.
	"TopographybathymetryID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Topographybathymetry" ADD CONSTRAINT "PK_Topographybathymetry"
	PRIMARY KEY ("TopographybathymetryID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Topographybathymetry"
	IS 'A TopographyBathymetry is a specification of topography / bathymetry accompanied by a timestamp indicating the time from which that topographyBathymetry specification is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple topographyBathymetry specifications which are valid over different consecutive periods of time. If only a single topographyBathymetry is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Topographybathymetry"."Altitudeordepth"
	IS '4-03 The altitude/depth with respect to mean sea level from the AltitudeOrDepthTypeCodelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Localtopography"
	IS '4-03 The local topography from the LocalTopographyType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Relativeelevation"
	IS '4-03 The relative elevation from the RelativeElevationType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Topographiccontext"
	IS '4-03 The topographic context from the TopographicContextType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Validperiod"
	IS 'The time period for which the specified topographyBathymetry is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next topographyBathymetry on record. If only one topographyBathymetry is specified for an observing facility, the time stamp is optional.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Traceabilitytype" CASCADE
;

/* Create Tables */

CREATE TABLE "Traceabilitytype"
(
	"TraceabilitytypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Traceabilitytype" ADD CONSTRAINT "PK_Traceabilitytype"
	PRIMARY KEY ("TraceabilitytypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Traceabilitytype"
	IS 'Traceability codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Transmissionmodetype" CASCADE
;

/* Create Tables */

CREATE TABLE "Transmissionmodetype"
(
	"TransmissionmodetypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Transmissionmodetype" ADD CONSTRAINT "PK_Transmissionmodetype"
	PRIMARY KEY ("TransmissionmodetypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Transmissionmodetype"
	IS '5-03 Instrument specifications. This is a proxy for several more specific elements, her used for Type "TransmissionModeType". TransmissionModeType uses values (pulsed, continuous-wave)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Uncertaintyevalproctype" CASCADE
;

/* Create Tables */

CREATE TABLE "Uncertaintyevalproctype"
(
	"UncertaintyevalproctypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Uncertaintyevalproctype" ADD CONSTRAINT "PK_Uncertaintyevalproctype"
	PRIMARY KEY ("UncertaintyevalproctypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Uncertaintyevalproctype"
	IS 'Uncertainty evaluation procedure codelist'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Unique-observed-variable" CASCADE
;

/* Create Tables */

CREATE TABLE "Unique-observed-variable"
(
	"Unique-observed-variableID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Unique-observed-variable" ADD CONSTRAINT "PK_Unique-observed-variable"
	PRIMARY KEY ("Unique-observed-variableID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Unique-observed-variable"
	IS 'Each OM_Observation should describe the observation of a different observed variable (e.g. humidity, air temperature) from a station/facility. '
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Unit-of-measure" CASCADE
;

/* Create Tables */

CREATE TABLE "Unit-of-measure"
(
	"Unit-of-measureID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Unit-of-measure" ADD CONSTRAINT "PK_Unit-of-measure"
	PRIMARY KEY ("Unit-of-measureID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Unit-of-measure"
	IS 'The value for uom, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/Unit.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Valid-local-references" CASCADE
;

/* Create Tables */

CREATE TABLE "Valid-local-references"
(
	"Valid-local-referencesID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Valid-local-references" ADD CONSTRAINT "PK_Valid-local-references"
	PRIMARY KEY ("Valid-local-referencesID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Valid-local-references"
	IS 'Where xlink:href is used to refer to a local object (using the #id notation) there must be a corresponding object with gml:id equal to "id" in the same XML document.

Where xlink:href is used to make a reference to a non-local object, e.g. using a WIGOS identifier or a link to a term in a codelist then this is not applicable.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Well-formed" CASCADE
;

/* Create Tables */

CREATE TABLE "Well-formed"
(
	"Well-formedID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Well-formed" ADD CONSTRAINT "PK_Well-formed"
	PRIMARY KEY ("Well-formedID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Well-formed"
	IS 'XML encodings of WMDR shall be well formed XML documents (syntactically correct). A well-formed XML document conforms to the XML specification. (https://www.w3.org/TR/REC-xml/ )'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Wigosmetadatarecord" CASCADE
;

/* Create Tables */

CREATE TABLE "Wigosmetadatarecord"
(
	"Deployment" varchar NULL,	-- A Deployment instance in this record. Note that Deployments may also be encoded inline with the OM_Observation (as part of the Process).
	"Equipment" varchar NULL,	-- An Equipment instance in this metadata record.
	"Equipmentlog" varchar NULL,	-- An EquipmentLog instance in this metadata record. Note that an EquipmentLog may also be encoded inline with the Equipment instance.
	"Extension" varchar NULL,	-- This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks. However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. 
	"Facility" varchar NULL,	-- An ObservingFacility instance in this metadata record.
	"Facilitylog" varchar NULL,	-- A FacilityLog instance in this metadata record. Note that an FacilityLog may also be encoded inline with the ObservingFacility instance.
	"Facilityset" varchar NULL,	-- A FacilitySet instance in this metadata record. The FacilitySet will simply consist of links to ObservingFacilities belonging to the set.
	"Headerinformation" varchar NULL,	-- A header section must be included with every WIGOS MetadataRecord.
	"Observation" varchar NULL,
	"WigosmetadatarecordID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Wigosmetadatarecord" ADD CONSTRAINT "PK_Wigosmetadatarecord"
	PRIMARY KEY ("WigosmetadatarecordID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Wigosmetadatarecord"
	IS 'The WIGOSMetadataRecord is a container for WIGOS information for the purposes of packaging the information for delivery to, or transfer between, systems.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Deployment"
	IS 'A Deployment instance in this record. Note that Deployments may also be encoded inline with the OM_Observation (as part of the Process).'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Equipment"
	IS 'An Equipment instance in this metadata record.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Equipmentlog"
	IS 'An EquipmentLog instance in this metadata record. Note that an EquipmentLog may also be encoded inline with the Equipment instance.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Extension"
	IS 'This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks.
However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. '
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Facility"
	IS 'An ObservingFacility instance in this metadata record.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Facilitylog"
	IS 'A FacilityLog instance in this metadata record. Note that an FacilityLog may also be encoded inline with the ObservingFacility instance.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Facilityset"
	IS 'A FacilitySet instance in this metadata record. The FacilitySet will simply consist of links to ObservingFacilities belonging to the set.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Headerinformation"
	IS 'A header section must be included with every WIGOS MetadataRecord.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Wmo-region" CASCADE
;

/* Create Tables */

CREATE TABLE "Wmo-region"
(
	"Wmo-regionID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Wmo-region" ADD CONSTRAINT "PK_Wmo-region"
	PRIMARY KEY ("Wmo-regionID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Wmo-region"
	IS 'The value for wmoRegion shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/WMORegion.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Wmoregiontype" CASCADE
;

/* Create Tables */

CREATE TABLE "Wmoregiontype"
(
	"WmoregiontypeID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Wmoregiontype" ADD CONSTRAINT "PK_Wmoregiontype"
	PRIMARY KEY ("WmoregiontypeID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Wmoregiontype"
	IS 'WMO Regions (region of origin of data)'
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Xml-rules" CASCADE
;

/* Create Tables */

CREATE TABLE "Xml-rules"
(
	"Xml-rules" varchar NULL,
	"Xml-rulesID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Xml-rules" ADD CONSTRAINT "PK_Xml-rules"
	PRIMARY KEY ("Xml-rulesID")
;/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Xsd-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Xsd-valid"
(
	"Xsd-validID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Xsd-valid" ADD CONSTRAINT "PK_Xsd-valid"
	PRIMARY KEY ("Xsd-validID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Xsd-valid"
	IS 'XML encodings of WMDR shall validate against the WMDR XML Schema (xsd).'
;

END TRANSACTION;
