/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Abstractenvironmentalmonitoringfacility" CASCADE
;

/* Create Tables */

CREATE TABLE "Abstractenvironmentalmonitoringfacility"
(
	"Description" varchar NULL,	-- 4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. 
	"Extension" varchar NULL,	-- This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks. However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. 
	"Geospatiallocation" varchar NULL,	-- 3-07 Position in space defining the location of the environmental monitoring station/platform at the time of observation.  5-12 Geospatial location of instrument/sensor
	"Onlineresource" varchar NULL,	-- An online resource containing additional information about the facility or equipment
	"Responsibleparty" varchar NULL,	-- The organisation responsible.
	"AbstractenvironmentalmonitoringfacilityID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Abstractenvironmentalmonitoringfacility" ADD CONSTRAINT "PK_Abstractenvironmentalmonitoringfacility"
	PRIMARY KEY ("AbstractenvironmentalmonitoringfacilityID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Abstractenvironmentalmonitoringfacility"
	IS 'An abstract class for environmental monitoring facilities. An environmental monitoring facility may be a station, a platform (moving or stationary), or it may be a sensor or an instrument. WIGOS defines two concrete specialisations: ObservingFacility (to represent stations/platforms) and Equipment (to represent sensors/instruments). NOTE: The WIGOS specialisations of AbstractEnvironmentalMonitoringFacility (ObservingFacility, Equipment) can both be mapped conceptually to the INSPIRE EF EnvironmentalMonitoringFacility.'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Description"
	IS '4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. '
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Extension"
	IS 'This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks.
However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. '
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Geospatiallocation"
	IS '3-07 Position in space defining the location of the environmental monitoring station/platform at the time of observation.

5-12 Geospatial location of instrument/sensor'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Onlineresource"
	IS 'An online resource containing additional information about the facility or equipment'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Responsibleparty"
	IS 'The organisation responsible.'
;