/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Climatezone" CASCADE
;

/* Create Tables */

CREATE TABLE "Climatezone"
(
	"Climatezone" varchar NULL,	-- 4-07 type of climate zone at the facility. From the ClimateZoneType codelist.
	"Validperiod" varchar NULL,	-- The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.
	"ClimatezoneID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Climatezone" ADD CONSTRAINT "PK_Climatezone"
	PRIMARY KEY ("ClimatezoneID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Climatezone"
	IS 'A ClimateZone is a climateZone specification accompanied by a timestamp indicating the time from which that climateZone is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple climateZone which are valid over different consecutive periods of time. If only a single climateZone is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Climatezone"."Climatezone"
	IS '4-07 type of climate zone at the facility. From the ClimateZoneType codelist.'
;

COMMENT ON COLUMN "Climatezone"."Validperiod"
	IS 'The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.'
;