/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Controlcheckreport" CASCADE
;

/* Create Tables */

CREATE TABLE "Controlcheckreport"
(
	"Alternateuri" varchar NULL,	-- 5-08 Alternatively the summary of the control check may be provided via a URI that resolves to a document containing this information.
	"Checklocation" varchar NULL,	-- 5-08 Location of sensor when check was performed (e.g. in-situ, offsite etc.) From codelist ControlCheckLocationType.
	"Controlcheckresult" varchar NULL,	-- 5-08 Result of the control check, from InstrumentControlResultType codelist
	"Periodofvalidity" varchar NULL,	-- 5-08 period of validity of the control check (e.g. 4 years)
	"Standardname" varchar NULL,	-- 5-08 Nameof the Standard used.
	"Standardserialnumber" varchar NULL,	-- 5-08 Serial Number of the standard used.
	"Standardtype" varchar NULL,	-- 5-08 Type of the Standard used. From the StandardType code list.
	"Withinverificationlimit" varchar NULL,	-- 5-08 Was the instrument found to be within verification limits (True if yes, False if no)
	"ControlcheckreportID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Controlcheckreport" ADD CONSTRAINT "PK_Controlcheckreport"
	PRIMARY KEY ("ControlcheckreportID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Controlcheckreport" ADD CONSTRAINT "FK_ControlCheckReport_LogEntry"
	FOREIGN KEY ("ControlcheckreportID") REFERENCES "Logentry" ("LogentryID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Controlcheckreport"
	IS 'A ControlCheckReport describes a calibration type event. E.g. instrument was re-calibrated.'
;

COMMENT ON COLUMN "Controlcheckreport"."Alternateuri"
	IS '5-08 Alternatively the summary of the control check may be provided via a URI that resolves to a document containing this information.'
;

COMMENT ON COLUMN "Controlcheckreport"."Checklocation"
	IS '5-08 Location of sensor when check was performed (e.g. in-situ, offsite etc.) From codelist ControlCheckLocationType.'
;

COMMENT ON COLUMN "Controlcheckreport"."Controlcheckresult"
	IS '5-08 Result of the control check, from InstrumentControlResultType codelist'
;

COMMENT ON COLUMN "Controlcheckreport"."Periodofvalidity"
	IS '5-08 period of validity of the control check (e.g. 4 years)'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardname"
	IS '5-08 Nameof the Standard used.'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardserialnumber"
	IS '5-08 Serial Number of the standard used.'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardtype"
	IS '5-08 Type of the Standard used. From the StandardType code list.'
;

COMMENT ON COLUMN "Controlcheckreport"."Withinverificationlimit"
	IS '5-08 Was the instrument found to be within verification limits (True if yes, False if no)'
;