/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Frequencies" CASCADE
;

/* Create Tables */

CREATE TABLE "Frequencies"
(
	"Bandwidth" varchar NULL,	-- The difference of the highest and the lowest frequency, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz
	"Channel" varchar NULL,	-- A name describing the frequency used
	"Frequency" varchar NULL,	-- The nominal frequency used, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz
	"Frequencyuse" varchar NULL,	-- expected values are: Transmit, Receive, TransmitReceive
	"Polarization" varchar NULL,
	"Purposeoffrequencyuse" varchar NULL,	-- expected values are: observation, telecomms
	"Transmissionmode" varchar NULL,	-- expected values are: pulsed, continuous use conditional on frequencyUse = Transmit
	"FrequenciesID" varchar NOT NULL,
	"EquipmentID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Frequencies" ADD CONSTRAINT "PK_Frequencies"
	PRIMARY KEY ("FrequenciesID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Frequencies" ADD CONSTRAINT "FK_Frequencies_Equipment"
	FOREIGN KEY ("EquipmentID") REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON COLUMN "Frequencies"."Bandwidth"
	IS 'The difference of the highest and the lowest frequency, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz'
;

COMMENT ON COLUMN "Frequencies"."Channel"
	IS 'A name describing the frequency used'
;

COMMENT ON COLUMN "Frequencies"."Frequency"
	IS 'The nominal frequency used, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz'
;

COMMENT ON COLUMN "Frequencies"."Frequencyuse"
	IS 'expected values are: Transmit, Receive, TransmitReceive'
;

COMMENT ON COLUMN "Frequencies"."Purposeoffrequencyuse"
	IS 'expected values are: observation, telecomms'
;

COMMENT ON COLUMN "Frequencies"."Transmissionmode"
	IS 'expected values are: pulsed, continuous
use conditional on frequencyUse = Transmit'
;