/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:56 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Geospatiallocation" CASCADE
;

/* Create Tables */

CREATE TABLE "Geospatiallocation"
(
	"Coordinatereferencesystem" varchar NULL,
	"Geolocation" varchar NULL,	-- 3-07 Representative or conventional geospatial location of observing facility, the reference location. This will always be a point location, but this location can change with time.  5-12 Geospatial location of instrument or observing equipment, typically the location of the sensing element or sample inlet. This will always be a point location, but this location can change with time. 
	"Geopositioningmethod" varchar NULL,	-- Element describes the method used to establish the specified geoLocation. [Codelist 11-01]
	"Validperiod" varchar NULL,	-- The time period for which this geoLocation is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next geoLocation on record.
	"GeospatiallocationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Geospatiallocation" ADD CONSTRAINT "PK_Geospatiallocation"
	PRIMARY KEY ("GeospatiallocationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Geospatiallocation"
	IS 'A GeospatialLocation is a geospatial location accompanied by a timestamp indicating the time from which that location is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple locations which are valid over different periods of time.'
;

COMMENT ON COLUMN "Geospatiallocation"."Geolocation"
	IS '3-07 Representative or conventional geospatial location of observing facility, the reference location. This will always be a point location, but this location can change with time.

5-12 Geospatial location of instrument or observing equipment, typically the location of the sensing element or sample inlet. This will always be a point location, but this location can change with time. '
;

COMMENT ON COLUMN "Geospatiallocation"."Geopositioningmethod"
	IS 'Element describes the method used to establish the specified geoLocation. [Codelist 11-01]'
;

COMMENT ON COLUMN "Geospatiallocation"."Validperiod"
	IS 'The time period for which this geoLocation is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next geoLocation on record.'
;