/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Population" CASCADE
;

/* Create Tables */

CREATE TABLE "Population"
(
	"Population10km" varchar NULL,	-- Population in a 10 km radius around the observing facility, specified in 1000s.
	"Population50km" varchar NULL,	-- Population in a 50 km radius around the observing facility, specified in 1000s.
	"Validperiod" varchar NULL,	-- The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.
	"PopulationID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Population" ADD CONSTRAINT "PK_Population"
	PRIMARY KEY ("PopulationID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Population"
	IS 'A Population is a population specification accompanied by a timestamp indicating the time from which that population is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple population specifications which are valid over different consecutive periods of time. If only a single population is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Population"."Population10km"
	IS 'Population in a 10 km radius around the observing facility, specified in 1000s.'
;

COMMENT ON COLUMN "Population"."Population50km"
	IS 'Population in a 50 km radius around the observing facility, specified in 1000s.'
;

COMMENT ON COLUMN "Population"."Validperiod"
	IS 'The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.'
;