/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Reporting" CASCADE
;

/* Create Tables */

CREATE TABLE "Reporting"
(
	"Dataformat" varchar NULL,	-- 7-07 Description of the format in which the observed variable is primarily being provided, from the DataFormatType codelist. 
	"Dataformatversion" varchar NULL,	-- 7-08 Version of the data format.
	"Datapolicy" varchar NULL,	-- 9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.
	"Internationalexchange" varchar NULL,
	"Levelofdata" varchar NULL,	-- 7-06 Level of data processing
	"Numberofobservationsinreportinginterval" varchar NULL,	-- Specifies how many aggregated observations are reported on average in each temporal reporting interval. For full temporal coverage, the number of observations reported = temporal reporting interval / aggregation period.
	"Numericalresolution" varchar NULL,	-- 7-12 Numerical resolution is a measure of the detail to which a numerical quantity is expressed. This is synonymous to numerical precision of the reporting, but can be different than the numerical precision of the observed value.
	"Officialstatus" varchar NULL,	-- 5-14 Official status of observation.
	"Referencedatum" varchar NULL,	-- 7-11 Reference datum used to convert observed quantity to reported quantity
	"Referencetimesource" varchar NULL,	-- 7-10 Time reference used for observations.
	"Spatialreportinginterval" varchar NULL,	-- 7-03 Spatial interval over which the observed variable is reported. Note that this is expressed as length, without geo-referencing. 
	"Temporalreportinginterval" varchar NULL,	-- 7-03 Time interval over which the observed variable is reported. Note that this is a temporal distance, e.g., (every) 1 hour. 
	"Timeliness" varchar NULL,	-- 7-13 Timeliness of reporting is the typical time taken between completion of the observation and when it becomes available to users.
	"Timestampmeaning" varchar NULL,	-- 7-03 Meaning of the time stamp in the temporalReportingInterval taken from the TimeStampMeaning codelist.
	"Uom" varchar NULL,	-- 1-02 Measurement Unit (unit of measure)
	"ReportingID" varchar NOT NULL,
	"DatagenerationID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Reporting" ADD CONSTRAINT "PK_Reporting"
	PRIMARY KEY ("ReportingID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Reporting" ADD CONSTRAINT "FK_Reporting_reporting"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Reporting"
	IS '[WMDS Category 7] Details of the reporting procedures.'
;

COMMENT ON COLUMN "Reporting"."Dataformat"
	IS '7-07 Description of the format in which the observed variable is primarily being provided, from the DataFormatType codelist. '
;

COMMENT ON COLUMN "Reporting"."Dataformatversion"
	IS '7-08 Version of the data format.'
;

COMMENT ON COLUMN "Reporting"."Datapolicy"
	IS '9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.'
;

COMMENT ON COLUMN "Reporting"."Levelofdata"
	IS '7-06 Level of data processing'
;

COMMENT ON COLUMN "Reporting"."Numberofobservationsinreportinginterval"
	IS 'Specifies how many aggregated observations are reported on average in each temporal reporting interval. For full temporal coverage, the number of observations reported = temporal reporting interval / aggregation period.'
;

COMMENT ON COLUMN "Reporting"."Numericalresolution"
	IS '7-12 Numerical resolution is a measure of the detail to which a numerical quantity is expressed. This is synonymous to numerical precision of the reporting, but can be different than the numerical precision of the observed value.'
;

COMMENT ON COLUMN "Reporting"."Officialstatus"
	IS '5-14 Official status of observation.'
;

COMMENT ON COLUMN "Reporting"."Referencedatum"
	IS '7-11 Reference datum used to convert observed quantity to reported quantity'
;

COMMENT ON COLUMN "Reporting"."Referencetimesource"
	IS '7-10 Time reference used for observations.'
;

COMMENT ON COLUMN "Reporting"."Spatialreportinginterval"
	IS '7-03 Spatial interval over which the observed variable is reported. Note that this is expressed as length, without geo-referencing. '
;

COMMENT ON COLUMN "Reporting"."Temporalreportinginterval"
	IS '7-03 Time interval over which the observed variable is reported. Note that this is a temporal distance, e.g., (every) 1 hour. '
;

COMMENT ON COLUMN "Reporting"."Timeliness"
	IS '7-13 Timeliness of reporting is the typical time taken between completion of the observation and when it becomes available to users.'
;

COMMENT ON COLUMN "Reporting"."Timestampmeaning"
	IS '7-03 Meaning of the time stamp in the temporalReportingInterval taken from the TimeStampMeaning codelist.'
;

COMMENT ON COLUMN "Reporting"."Uom"
	IS '1-02 Measurement Unit (unit of measure)'
;