/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Schedule" CASCADE
;

/* Create Tables */

CREATE TABLE "Schedule"
(
	"Diurnalbasetime" varchar NULL,
	"Endhour" varchar NULL,	-- End hour of schedule (0 to 23)
	"Endminute" varchar NULL,	-- End minute of schedule (0 to 59)
	"Endmonth" varchar NULL,	-- End month of schedule (January = 1, December = 12)
	"Endweekday" varchar NULL,	-- End day of schedule (Monday = 1, Sunday = 7)
	"Starthour" varchar NULL,	-- Start hour of schedule (0 to 23)
	"Startminute" varchar NULL,	-- Start minute of schedule (0 to 59)
	"Startmonth" varchar NULL,	-- Start month of schedule (January = 1, December = 12)
	"Startweekday" varchar NULL,	-- Start day of schedule (Monday = 1, Sunday = 7)
	"ScheduleID" varchar NOT NULL,
	"DatagenerationID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Schedule" ADD CONSTRAINT "PK_Schedule"
	PRIMARY KEY ("ScheduleID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Schedule" ADD CONSTRAINT "FK_Schedule_schedule"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Schedule"
	IS '6-08 Description of the schedule of observation. Note: Schedules are defined in terms of months covered, weekdays covered, hours and minutes covered during each day. A complete definition of a schedule requires specification of the temporalReportingInterval, and may require the specification of diurnalBaseTime.'
;

COMMENT ON COLUMN "Schedule"."Endhour"
	IS 'End hour of schedule (0 to 23)'
;

COMMENT ON COLUMN "Schedule"."Endminute"
	IS 'End minute of schedule (0 to 59)'
;

COMMENT ON COLUMN "Schedule"."Endmonth"
	IS 'End month of schedule (January = 1, December = 12)'
;

COMMENT ON COLUMN "Schedule"."Endweekday"
	IS 'End day of schedule (Monday = 1, Sunday = 7)'
;

COMMENT ON COLUMN "Schedule"."Starthour"
	IS 'Start hour of schedule (0 to 23)'
;

COMMENT ON COLUMN "Schedule"."Startminute"
	IS 'Start minute of schedule (0 to 59)'
;

COMMENT ON COLUMN "Schedule"."Startmonth"
	IS 'Start month of schedule (January = 1, December = 12)'
;

COMMENT ON COLUMN "Schedule"."Startweekday"
	IS 'Start day of schedule (Monday = 1, Sunday = 7)'
;