/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Territory" CASCADE
;

/* Create Tables */

CREATE TABLE "Territory"
(
	"Territoryname" varchar NULL,	-- 3-02 The territory the observing facility is located in, from the TerritoryType codelist.
	"Validperiod" varchar NULL,	-- The time period for which the specified territory is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one territory is specified for an observing facility, the time stamp is optional.
	"TerritoryID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Territory" ADD CONSTRAINT "PK_Territory"
	PRIMARY KEY ("TerritoryID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Territory"
	IS 'A Territory is a territory specification accompanied by a timestamp indicating the time from which that territory is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple territories which are valid over different consecutive periods of time. If only a single territory is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Territory"."Territoryname"
	IS '3-02 The territory the observing facility is located in, from the TerritoryType codelist.'
;

COMMENT ON COLUMN "Territory"."Validperiod"
	IS 'The time period for which the specified territory is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one territory is specified for an observing facility, the time stamp is optional.'
;