/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Time-zone-explicit" CASCADE
;

/* Create Tables */

CREATE TABLE "Time-zone-explicit"
(
	"Time-zone-explicitID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Time-zone-explicit" ADD CONSTRAINT "PK_Time-zone-explicit"
	PRIMARY KEY ("Time-zone-explicitID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Time-zone-explicit"
	IS 'All times shall be encoded using ISO 8601 time format. A time-zone designator must be supplied for all times. If the time is given as UTC then the time zone designator is ''Z'' e.g.

2016-12-25T12:00Z

For times given in a local (non UTC) time the time zone designator shall be expressed as an offset from UTC using plus or minus offsets.

For example, the following date times are all the same moment in time:

2016-12-25T10:00Z (10am, timezone is  UTC)

2016-12-25T14:00+04:00  (2pm, timezone is UTC + 4 hours)

2016-12-25T06:00-04:00   (6am, timezone is UTC -4 hours)'
;