/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Topographybathymetry" CASCADE
;

/* Create Tables */

CREATE TABLE "Topographybathymetry"
(
	"Altitudeordepth" varchar NULL,	-- 4-03 The altitude/depth with respect to mean sea level from the AltitudeOrDepthTypeCodelist
	"Localtopography" varchar NULL,	-- 4-03 The local topography from the LocalTopographyType codelist
	"Relativeelevation" varchar NULL,	-- 4-03 The relative elevation from the RelativeElevationType codelist
	"Topographiccontext" varchar NULL,	-- 4-03 The topographic context from the TopographicContextType codelist
	"Validperiod" varchar NULL,	-- The time period for which the specified topographyBathymetry is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next topographyBathymetry on record. If only one topographyBathymetry is specified for an observing facility, the time stamp is optional.
	"TopographybathymetryID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Topographybathymetry" ADD CONSTRAINT "PK_Topographybathymetry"
	PRIMARY KEY ("TopographybathymetryID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Topographybathymetry"
	IS 'A TopographyBathymetry is a specification of topography / bathymetry accompanied by a timestamp indicating the time from which that topographyBathymetry specification is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple topographyBathymetry specifications which are valid over different consecutive periods of time. If only a single topographyBathymetry is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Topographybathymetry"."Altitudeordepth"
	IS '4-03 The altitude/depth with respect to mean sea level from the AltitudeOrDepthTypeCodelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Localtopography"
	IS '4-03 The local topography from the LocalTopographyType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Relativeelevation"
	IS '4-03 The relative elevation from the RelativeElevationType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Topographiccontext"
	IS '4-03 The topographic context from the TopographicContextType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Validperiod"
	IS 'The time period for which the specified topographyBathymetry is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next topographyBathymetry on record. If only one topographyBathymetry is specified for an observing facility, the time stamp is optional.'
;