"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/autorollback/autorollback.lambda.ts
var autorollback_lambda_exports = {};
__export(autorollback_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(autorollback_lambda_exports);

// src/common/alarm-state.ts
var import_aws_sdk = require("aws-sdk");
var getCloudwatchAlarms = async (params) => {
  var _a, _b;
  const cloudwatch = new import_aws_sdk.CloudWatch();
  let nextToken;
  let results = [];
  do {
    const result = await cloudwatch.describeAlarms({ AlarmTypes: ["CompositeAlarm", "MetricAlarm"], ...params, NextToken: nextToken }).promise();
    results = result.CompositeAlarms ? results.concat((_a = result.CompositeAlarms) == null ? void 0 : _a.map((alarm) => {
      return {
        alarmArn: alarm.AlarmArn,
        state: alarm.StateValue,
        reason: alarm.StateReason,
        alarmDescription: alarm.AlarmDescription
      };
    })) : results;
    results = result.MetricAlarms ? results.concat((_b = result.MetricAlarms) == null ? void 0 : _b.map((alarm) => {
      return {
        alarmArn: alarm.AlarmArn,
        state: alarm.StateValue,
        reason: alarm.StateReason,
        alarmDescription: alarm.AlarmDescription
      };
    })) : results;
    nextToken = result.NextToken;
  } while (nextToken);
  return results;
};
var getAlarms = async (searchTerms) => {
  const states = [];
  try {
    const alarmsForAccountAndRegion = await getCloudwatchAlarms();
    const alarms = hasAlarmMatching(alarmsForAccountAndRegion, searchTerms).map((alarm) => {
      alarm.reason = `${alarm.alarmArn} in ${alarm.state} due to ${alarm.reason}`;
      return alarm;
    });
    if (alarms.length === 0) {
      alarms.push({
        state: "ALARM" /* ALARM */,
        reason: `No alarms were found for the provided search terms: ${searchTerms.join(", ")}.`
      });
    }
  } catch (e) {
    const message = "Unable to retrieve alarms.";
    states.push({ reason: message, state: "ALARM" /* ALARM */ });
    console.error(message, e);
  }
  return states;
};
var getAggregateAlarmState = async (searchTerms) => {
  var _a;
  const alarmDetails = await getAlarms(searchTerms);
  return {
    alarmDetails,
    state: ((_a = alarmDetails.find((a) => a.state === "ALARM" /* ALARM */)) == null ? void 0 : _a.state) ?? "OK" /* OK */,
    summary: `${alarmDetails.filter((a) => a.state === "ALARM" /* ALARM */).map((a) => a.reason).join(", ")}`
  };
};
var hasAlarmMatching = (alarms, searchTerms) => {
  return alarms.flatMap((alarm) => searchTerms.map((searchTerm) => {
    var _a;
    return ((_a = alarm.alarmDescription) == null ? void 0 : _a.includes(searchTerm)) ? alarm : void 0;
  }).filter((sameAlarm) => sameAlarm)).filter((sameAlarm, index) => alarms.indexOf(sameAlarm) === index);
};

// src/autorollback/autorollback.lambda.ts
var handler = async (event) => {
  console.log("Event: %j", { ...event, ResponseURL: "..." });
  if (event.RequestType === "Create" || event.RequestType === "Update") {
    const searchTags = event.ResourceProperties.SearchTags;
    const timeout = event.ResourceProperties.MonitoringTime;
    const endTime = event.ResourceProperties.EndTime ?? Date.now() + timeout * 1e3;
    if (endTime > Date.now()) {
      if (searchTags.length > 0) {
        const alarms = await getAggregateAlarmState(searchTags);
        if (alarms.state === "ALARM" /* ALARM */) {
          throw new Error(`Rolling back the deployment: [${alarms.summary}]`);
        }
        console.log(`Monitoring until ${new Date(endTime).toLocaleTimeString()}`);
        return { IsComplete: false };
      }
    }
    console.log("The monitoring period completed without alarm.");
    return { IsComplete: true, EndTime: endTime };
  }
  console.log("Skipping checking alarms. This resource only works during Create and Update.");
  return { IsComplete: true };
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
