"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoRollback = void 0;
const crypto_1 = require("crypto");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_sqs_1 = require("aws-cdk-lib/aws-sqs");
const constructs_1 = require("constructs");
const autorollback_function_1 = require("./autorollback-function");
class AutoRollback extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaTimeout = aws_cdk_lib_1.Duration.minutes(15);
        const pollQueue = new aws_sqs_1.Queue(this, 'PollQueue', {
            visibilityTimeout: lambdaTimeout,
        });
        const lambdaFunction = new autorollback_function_1.AutorollbackFunction(this, 'Handler');
        lambdaFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['cloudwatch:DescribeAlarms'],
            resources: ['*'],
            effect: aws_iam_1.Effect.ALLOW,
        }));
        const alarmDescription = `[${props.name ?? ''}-${aws_cdk_lib_1.Names.uniqueResourceName(this, { separator: '-' })}]`;
        new aws_cloudwatch_1.CompositeAlarm(this, 'composite-alarm', {
            compositeAlarmName: props.name,
            alarmRule: props.alarmRule,
            alarmDescription,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: lambdaFunction,
            isCompleteHandler: lambdaFunction,
        });
        new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                monitoringTime: props.monitoringTime,
                searchTerms: alarmDescription,
                queueUrl: pollQueue.queueUrl,
                nonce: crypto_1.randomUUID(),
            },
        });
    }
}
exports.AutoRollback = AutoRollback;
//# sourceMappingURL=data:application/json;base64,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