"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const alarm_state_1 = require("../common/alarm-state");
exports.handler = async (event) => {
    console.log('Event: %j', { ...event, ResponseURL: '...' });
    if (event.RequestType === 'Create' || event.RequestType === 'Update') {
        const searchTags = event.ResourceProperties.SearchTags;
        const timeout = event.ResourceProperties.MonitoringTime;
        const endTime = event.ResourceProperties.EndTime ?? Date.now() + timeout * 1000;
        if (endTime > Date.now()) {
            if (searchTags.length > 0) {
                const alarms = await alarm_state_1.getAggregateAlarmState(searchTags);
                if (alarms.state === alarm_state_1.AlarmState.ALARM) {
                    throw new Error(`Rolling back the deployment: [${alarms.summary}]`);
                }
                console.log(`Monitoring until ${new Date(endTime).toLocaleTimeString()}`);
                return { IsComplete: false };
            }
        }
        console.log('The monitoring period completed without alarm.');
        return { IsComplete: true, EndTime: endTime };
    }
    console.log('Skipping checking alarms. This resource only works during Create and Update.');
    return { IsComplete: true };
};
//# sourceMappingURL=data:application/json;base64,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