"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineWithChangeControl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codebuild_1 = require("aws-cdk-lib/aws-codebuild");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_codepipeline_actions_1 = require("aws-cdk-lib/aws-codepipeline-actions");
const constructs_1 = require("constructs");
const change_controller_1 = require("../time-windows/change-controller/change-controller");
class PipelineWithChangeControl extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const sourceOutput = new aws_codepipeline_1.Artifact('SourceOutput');
        const buildOutput = new aws_codepipeline_1.Artifact('BuildOutput');
        const pipeline = new aws_codepipeline_1.Pipeline(this, 'Pipeline', {
            pipelineName: props.pipelineName,
            role: props.pipelineRole,
        });
        // Source Stage
        const sourceStage = pipeline.addStage({
            stageName: 'Source',
        });
        const sourceAction = new aws_codepipeline_actions_1.CodeCommitSourceAction({
            actionName: 'CodeCommitSource',
            branch: 'main',
            trigger: aws_codepipeline_actions_1.CodeCommitTrigger.EVENTS,
            repository: props.sourceRepository,
            output: sourceOutput,
        });
        sourceStage.addAction(sourceAction);
        // Build stage
        const buildStage = pipeline.addStage({
            stageName: 'Build',
        });
        const buildProject = new aws_codebuild_1.PipelineProject(this, 'BuildStageProject', {
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    install: {
                        'runtime-versions': {
                            nodejs: 16,
                        },
                        // eslint-disable-next-line quote-props
                        commands: ['yarn install'],
                    },
                    build: {
                        commands: ['echo Build started on `date`', 'yarn build'],
                    },
                    post_build: {
                        commands: ['echo Build completed on `date`'],
                    },
                },
                artifacts: {
                    files: ['build/**/*', 'node_modules/**/*', 'src/*'],
                },
            }),
            environment: {
                buildImage: aws_codebuild_1.LinuxBuildImage.AMAZON_LINUX_2_4,
                privileged: true,
                computeType: aws_codebuild_1.ComputeType.SMALL,
            },
        });
        const buildAction = new aws_codepipeline_actions_1.CodeBuildAction({
            actionName: 'BuildAction',
            project: buildProject,
            input: sourceOutput,
            outputs: [buildOutput],
        });
        buildStage.addAction(buildAction);
        // Deploy Stage
        const deployStage = pipeline.addStage({
            stageName: 'Deploy',
        });
        // CodeBuild Deploy Project
        const deployProject = new aws_codebuild_1.PipelineProject(this, 'DeployStageProject', {
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    install: {
                        'runtime-versions': {
                            nodejs: 16,
                        },
                        // eslint-disable-next-line quote-props
                        commands: ['npm install -g aws-cdk'],
                    },
                    build: {
                        commands: ['echo Deploy started on `date`', 'cdk deploy'],
                    },
                    post_build: {
                        commands: ['echo Deploy completed on `date`'],
                    },
                },
            }),
            environment: {
                buildImage: aws_codebuild_1.LinuxBuildImage.AMAZON_LINUX_2_4,
                privileged: true,
                computeType: aws_codebuild_1.ComputeType.SMALL,
            },
        });
        // CodeBuild Deploy Action
        const deployAction = new aws_codepipeline_actions_1.CodeBuildAction({
            actionName: 'DeployAction',
            project: deployProject,
            input: buildOutput,
        });
        // Add Deploy Action to Stage
        deployStage.addAction(deployAction);
        // Add Change Controller
        props.changeControlCalendar._bind(this);
        pipeline.stages.forEach((stage) => {
            new change_controller_1.ChangeController(this, `change-controller-${stage.stageName}`, {
                calendar: props.changeControlCalendar,
                stage,
                schedule: props.changeControlCheckSchedule,
                searchTerms: props.searchTerms,
            });
        });
    }
}
exports.PipelineWithChangeControl = PipelineWithChangeControl;
_a = JSII_RTTI_SYMBOL_1;
PipelineWithChangeControl[_a] = { fqn: "@cdklabs/cdk-codepipeline-extensions.PipelineWithChangeControl", version: "0.0.0" };
;
//# sourceMappingURL=data:application/json;base64,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