"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk");
const calendar_1 = require("./calendar");
exports.handler = async (event) => {
    console.log('Event: %j', { ...event, ResponseURL: '...' });
    const calendarPath = event.ResourceProperties.calendarPath;
    const calendarName = event.ResourceProperties.calendarName;
    let calendar;
    if (event.ResourceProperties.sourceType === calendar_1.CalendarSourceType.PATH) {
        calendar = event.ResourceProperties.calendarBody;
    }
    else {
        const s3 = new aws_sdk_1.S3();
        calendar = (await s3.getObject({
            Bucket: calendarPath,
            Key: calendarName,
        }).promise()).Body.toString();
    }
    const ssm = new aws_sdk_1.SSM();
    if (event.RequestType === 'Create') {
        const createDocumentRepsonse = await ssm.createDocument({
            Name: calendarName,
            Content: calendar,
            DocumentType: 'ChangeCalendar',
            DocumentFormat: 'TEXT',
        }).promise();
        console.log('Create document: %j', createDocumentRepsonse);
    }
    if (event.RequestType === 'Update') {
        const updateDocumentResponse = await ssm.updateDocument({
            Name: calendarName,
            Content: calendar,
            DocumentVersion: '$LATEST',
        }).promise();
        console.log('Update document: %j', updateDocumentResponse);
    }
    if (event.RequestType === 'Delete') {
        const deleteDocumentResponse = await ssm.deleteDocument({
            Name: calendarName,
        }).promise();
        console.log('Delete document: %j', deleteDocumentResponse);
    }
    return {};
};
//# sourceMappingURL=data:application/json;base64,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