"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Calendar = exports.CalendarSourceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const calendar_setup_function_1 = require("./calendar-setup-function");
;
;
var CalendarSourceType;
(function (CalendarSourceType) {
    CalendarSourceType["S3_OBJECT"] = "s3Object";
    CalendarSourceType["PATH"] = "path";
})(CalendarSourceType = exports.CalendarSourceType || (exports.CalendarSourceType = {}));
;
class Calendar {
    constructor() { }
    static path(options) {
        return new class extends Calendar {
            _bind(scope) {
                const localPath = options.calendarPath ? options.calendarPath : __dirname;
                const calendarBody = fs.readFileSync(path.join(localPath, options.calendarName), { encoding: 'utf-8' });
                const calendar = new CustomResourceCalendar(scope, {
                    sourceType: CalendarSourceType.PATH,
                    calendarBody,
                    calendarName: options.calendarName,
                });
                this.calendarArn = calendar.calendarArn;
                this.calendarName = calendar.calendarName;
                return calendar;
            }
        };
    }
    static s3Location(options) {
        return new class extends Calendar {
            _bind(scope) {
                const calendar = new CustomResourceCalendar(scope, {
                    sourceType: CalendarSourceType.S3_OBJECT,
                    bucketName: options.bucket.bucketName,
                    calendarName: options.calendarName,
                    roleArn: options.role?.roleArn,
                });
                this.calendarArn = calendar.calendarArn;
                this.calendarName = calendar.calendarName;
                return calendar;
            }
        };
    }
}
exports.Calendar = Calendar;
_a = JSII_RTTI_SYMBOL_1;
Calendar[_a] = { fqn: "@cdklabs/cdk-codepipeline-extensions.Calendar", version: "0.0.0" };
class CustomResourceCalendar extends Calendar {
    constructor(scope, options) {
        super();
        this.calendarName = options.calendarName;
        this.calendarArn = aws_cdk_lib_1.Arn.format({
            service: 'ssm',
            resource: 'document',
            resourceName: options.calendarName,
        }, aws_cdk_lib_1.Stack.of(scope));
        const onEvent = new calendar_setup_function_1.CalendarSetupFunction(scope, 'OnEventHandler');
        onEvent.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['ssm:CreateDocument', 'ssm:UpdateDocument', 'ssm:DeleteDocument'],
            resources: [this.calendarArn],
        }));
        const provider = new custom_resources_1.Provider(scope, 'Provider', {
            onEventHandler: onEvent,
        });
        new aws_cdk_lib_1.CustomResource(scope, 'SSMCalendarCustomResource', {
            serviceToken: provider.serviceToken,
            properties: {
                sourceType: options.sourceType,
                calendarBody: options.calendarBody,
                calendarPath: options.calendarPath,
                calendarName: options.calendarName,
                roleArn: options.roleArn,
            },
        });
    }
    _bind() { }
}
//# sourceMappingURL=data:application/json;base64,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