"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCalendarState = void 0;
const aws_sdk_1 = require("aws-sdk");
exports.getCalendarState = async (calendarName) => {
    const fallbackNextTransitionTime = '2999-01-01T00:00:00Z';
    const ssm = new aws_sdk_1.SSM();
    try {
        const result = await ssm.getCalendarState({ CalendarNames: [calendarName] }).promise();
        if (!result.State)
            throw new Error('getCalendarState returned an undefined state.');
        return {
            state: result.State,
            nextTransitionTime: result.NextTransitionTime ?? fallbackNextTransitionTime,
            summary: `Calendar is ${result.State} until ${result.NextTransitionTime ?? fallbackNextTransitionTime}.`,
        };
    }
    catch (error) {
        const summary = `Unable to retrieve calendar state for ${calendarName}.`;
        console.error(summary, error);
        return {
            state: 'CLOSED',
            nextTransitionTime: fallbackNextTransitionTime,
            summary,
        };
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FsZW5kYXItc3RhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvdGltZS13aW5kb3dzL2NoYW5nZS1jb250cm9sbGVyL2NhbGVuZGFyLXN0YXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUE4QjtBQVNqQixRQUFBLGdCQUFnQixHQUFHLEtBQUssRUFBRSxZQUFvQixFQUEwQixFQUFFO0lBQ3JGLE1BQU0sMEJBQTBCLEdBQUcsc0JBQXNCLENBQUM7SUFFMUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxhQUFHLEVBQUUsQ0FBQztJQUN0QixJQUFJO1FBQ0YsTUFBTSxNQUFNLEdBQUcsTUFBTSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsRUFBRSxhQUFhLEVBQUUsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDdkYsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLO1lBQUUsTUFBTSxJQUFJLEtBQUssQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO1FBQ3BGLE9BQU87WUFDTCxLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsa0JBQWtCLEVBQUUsTUFBTSxDQUFDLGtCQUFrQixJQUFJLDBCQUEwQjtZQUMzRSxPQUFPLEVBQUUsZUFBZSxNQUFNLENBQUMsS0FBSyxVQUFVLE1BQU0sQ0FBQyxrQkFBa0IsSUFBSSwwQkFBMEIsR0FBRztTQUN6RyxDQUFDO0tBQ0g7SUFBQyxPQUFPLEtBQUssRUFBRTtRQUNkLE1BQU0sT0FBTyxHQUFHLHlDQUF5QyxZQUFZLEdBQUcsQ0FBQztRQUN6RSxPQUFPLENBQUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsQ0FBQztRQUM5QixPQUFPO1lBQ0wsS0FBSyxFQUFFLFFBQVE7WUFDZixrQkFBa0IsRUFBRSwwQkFBMEI7WUFDOUMsT0FBTztTQUNSLENBQUM7S0FDSDtBQUNILENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFNTTSB9IGZyb20gJ2F3cy1zZGsnO1xuXG5leHBvcnQgdHlwZSBDYWxlbmRhclN0YXRlID0ge1xuICBzdGF0ZTogc3RyaW5nO1xuICBuZXh0VHJhbnNpdGlvblRpbWU/OiBzdHJpbmc7XG4gIHN1bW1hcnk6IHN0cmluZztcbn07XG5cblxuZXhwb3J0IGNvbnN0IGdldENhbGVuZGFyU3RhdGUgPSBhc3luYyAoY2FsZW5kYXJOYW1lOiBzdHJpbmcpOiBQcm9taXNlPENhbGVuZGFyU3RhdGU+ID0+IHtcbiAgY29uc3QgZmFsbGJhY2tOZXh0VHJhbnNpdGlvblRpbWUgPSAnMjk5OS0wMS0wMVQwMDowMDowMFonO1xuXG4gIGNvbnN0IHNzbSA9IG5ldyBTU00oKTtcbiAgdHJ5IHtcbiAgICBjb25zdCByZXN1bHQgPSBhd2FpdCBzc20uZ2V0Q2FsZW5kYXJTdGF0ZSh7IENhbGVuZGFyTmFtZXM6IFtjYWxlbmRhck5hbWVdIH0pLnByb21pc2UoKTtcbiAgICBpZiAoIXJlc3VsdC5TdGF0ZSkgdGhyb3cgbmV3IEVycm9yKCdnZXRDYWxlbmRhclN0YXRlIHJldHVybmVkIGFuIHVuZGVmaW5lZCBzdGF0ZS4nKTtcbiAgICByZXR1cm4ge1xuICAgICAgc3RhdGU6IHJlc3VsdC5TdGF0ZSxcbiAgICAgIG5leHRUcmFuc2l0aW9uVGltZTogcmVzdWx0Lk5leHRUcmFuc2l0aW9uVGltZSA/PyBmYWxsYmFja05leHRUcmFuc2l0aW9uVGltZSxcbiAgICAgIHN1bW1hcnk6IGBDYWxlbmRhciBpcyAke3Jlc3VsdC5TdGF0ZX0gdW50aWwgJHtyZXN1bHQuTmV4dFRyYW5zaXRpb25UaW1lID8/IGZhbGxiYWNrTmV4dFRyYW5zaXRpb25UaW1lfS5gLFxuICAgIH07XG4gIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgY29uc3Qgc3VtbWFyeSA9IGBVbmFibGUgdG8gcmV0cmlldmUgY2FsZW5kYXIgc3RhdGUgZm9yICR7Y2FsZW5kYXJOYW1lfS5gO1xuICAgIGNvbnNvbGUuZXJyb3Ioc3VtbWFyeSwgZXJyb3IpO1xuICAgIHJldHVybiB7XG4gICAgICBzdGF0ZTogJ0NMT1NFRCcsXG4gICAgICBuZXh0VHJhbnNpdGlvblRpbWU6IGZhbGxiYWNrTmV4dFRyYW5zaXRpb25UaW1lLFxuICAgICAgc3VtbWFyeSxcbiAgICB9O1xuICB9XG59OyJdfQ==