"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChangeController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const change_controller_function_1 = require("./change-controller-function");
;
class ChangeController extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const fn = new change_controller_function_1.ChangeControllerFunction(this, 'ChangeControllerLambda');
        // Grant permission for stage transitions
        fn.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: [`${props.stage.pipeline.pipelineArn}*`],
            actions: [
                'codepipeline:EnableStageTransition',
                'codepipeline:DisableStageTransition',
                'codepipeline:GetPipelineState',
            ],
            effect: aws_iam_1.Effect.ALLOW,
        }));
        // Grant permission to retrieve calendars
        fn.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: [props.calendar.calendarArn],
            actions: ['ssm:GetCalendarState'],
            effect: aws_iam_1.Effect.ALLOW,
        }));
        // Grant permisssion to check alarm states
        fn.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['cloudwatch:DescribeAlarms'],
            effect: aws_iam_1.Effect.ALLOW,
        }));
        // Any error in the lambda function will close the time window
        fn.metricErrors().with({ statistic: 'sum' }).createAlarm(this, 'change-controller-alarm', {
            alarmName: `ChangeController-${props.stage.pipeline.pipelineName}${props.stage.stageName}`,
            evaluationPeriods: 1,
            threshold: 1,
            comparisonOperator: aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            treatMissingData: aws_cloudwatch_1.TreatMissingData.BREACHING,
        });
        // Create a rule to run the lambda on a schedule defined by the user
        new aws_events_1.Rule(this, 'Scheduler', {
            ruleName: fn.functionName,
            schedule: props.schedule,
            targets: [
                new aws_events_targets_1.LambdaFunction(fn, {
                    event: aws_events_1.RuleTargetInput.fromObject({
                        calendar: props.calendar,
                        searchTerms: props.searchTerms,
                        stageName: props.stage.stageName,
                        pipelineName: props.stage.pipeline.pipelineName,
                    }),
                }),
            ],
        });
    }
}
exports.ChangeController = ChangeController;
_a = JSII_RTTI_SYMBOL_1;
ChangeController[_a] = { fqn: "@cdklabs/cdk-codepipeline-extensions.ChangeController", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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