"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const alarm_state_1 = require("../../common/alarm-state");
const calendar_state_1 = require("./calendar-state");
const pipeline_state_1 = require("./pipeline-state");
;
exports.handler = async (event, context) => {
    const pipelineName = event.pipelineName;
    const stageName = event.stageName;
    const calendarState = await calendar_state_1.getCalendarState(event.calendar.calendarName);
    const stageState = await pipeline_state_1.getStageState(pipelineName, stageName);
    const alarmState = await alarm_state_1.getAggregateAlarmState(event.searchTerms);
    const input = { pipelineName: pipelineName, stageName: stageName, transitionType: 'Inbound' };
    if (calendarState.state === 'OPEN' && alarmState.state === 'OK') {
        console.log(`Enabling transition: ${JSON.stringify(input, null, 2)}`);
        await pipeline_state_1.enableStageTransition(input, context.functionName, stageState);
    }
    else {
        // If in ALARM, use that as the reason instead of the calendar.
        const reason = alarmState.state === 'ALARM' ? alarmState.summary : calendarState.summary;
        const disableInput = { ...input, reason };
        console.log(`Disabling transition: ${JSON.stringify(disableInput, null, 2)}`);
        await pipeline_state_1.disableStageTransition(disableInput, context.functionName, stageState);
    }
};
//# sourceMappingURL=data:application/json;base64,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