"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.enableStageTransition = exports.disableStageTransition = exports.getStageState = void 0;
const aws_sdk_1 = require("aws-sdk");
const codepipeline = new aws_sdk_1.CodePipeline();
exports.getStageState = async (pipelineName, stageName) => {
    const pipelineState = await codepipeline.getPipelineState({ name: pipelineName }).promise();
    return pipelineState.stageStates?.find(stage => stage.stageName === stageName);
};
/**
 * Disables stage transitions. Will only disable if stageState.inboundTransitionState.enabled is false.
 * Strips invalid characters from the reason and truncates to 300 characters.
 */
exports.disableStageTransition = async (params, lastChangedByMustInclude, stageState) => {
    if (stageState?.inboundTransitionState?.enabled === true ||
        (stageState?.inboundTransitionState?.enabled === false &&
            stageState.inboundTransitionState?.lastChangedBy?.includes(lastChangedByMustInclude))) {
        // See documentation https://docs.amazon.com/codepipeline/latest/APIReference/API_DisableStageTransition.html
        params.reason = params.reason.replace(/[^a-zA-Z0-9!@ \(\)\.\*\?\-]/g, '-').slice(0, 300);
        await codepipeline.disableStageTransition(params).promise();
    }
};
/**
 * Enables stage transitions. Will only enable if stageState.inboundTransitionState.enabled is true
 * and if lastChangedBy includes the lastChangedByMustInclude string.
 */
exports.enableStageTransition = async (params, lastChangedByMustInclude, stageState) => {
    if (stageState?.inboundTransitionState?.enabled === false &&
        stageState.inboundTransitionState?.lastChangedBy?.includes(lastChangedByMustInclude)) {
        await codepipeline.enableStageTransition(params).promise();
    }
};
//# sourceMappingURL=data:application/json;base64,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