"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCliLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
/**
 * An AWS Lambda layer that includes the AWS CLI.
 */
class AwsCliLayer extends lambda.LayerVersion {
    constructor(scope, id) {
        super(scope, id, {
            code: lambda.Code.fromAsset(path.join(__dirname, 'layer.zip'), {
                // we hash the layer directory (it contains the tools versions and Dockerfile) because hashing the zip is non-deterministic
                assetHash: core_1.FileSystem.fingerprint(path.join(__dirname, '../layer')),
            }),
            description: '/opt/awscli/aws',
        });
    }
}
exports.AwsCliLayer = AwsCliLayer;
_a = JSII_RTTI_SYMBOL_1;
AwsCliLayer[_a] = { fqn: "@aws-cdk/lambda-layer-awscli.AwsCliLayer", version: "1.195.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2xpLWxheWVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzY2xpLWxheWVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLDhDQUE4QztBQUM5Qyx3Q0FBMkM7QUFHM0M7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxNQUFNLENBQUMsWUFBWTtJQUNsRCxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxXQUFXLENBQUMsRUFBRTtnQkFDN0QsMkhBQTJIO2dCQUMzSCxTQUFTLEVBQUUsaUJBQVUsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsVUFBVSxDQUFDLENBQUM7YUFDcEUsQ0FBQztZQUNGLFdBQVcsRUFBRSxpQkFBaUI7U0FDL0IsQ0FBQyxDQUFDO0tBQ0o7O0FBVEgsa0NBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgRmlsZVN5c3RlbSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogQW4gQVdTIExhbWJkYSBsYXllciB0aGF0IGluY2x1ZGVzIHRoZSBBV1MgQ0xJLlxuICovXG5leHBvcnQgY2xhc3MgQXdzQ2xpTGF5ZXIgZXh0ZW5kcyBsYW1iZGEuTGF5ZXJWZXJzaW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgY29kZTogbGFtYmRhLkNvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYXllci56aXAnKSwge1xuICAgICAgICAvLyB3ZSBoYXNoIHRoZSBsYXllciBkaXJlY3RvcnkgKGl0IGNvbnRhaW5zIHRoZSB0b29scyB2ZXJzaW9ucyBhbmQgRG9ja2VyZmlsZSkgYmVjYXVzZSBoYXNoaW5nIHRoZSB6aXAgaXMgbm9uLWRldGVybWluaXN0aWNcbiAgICAgICAgYXNzZXRIYXNoOiBGaWxlU3lzdGVtLmZpbmdlcnByaW50KHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi9sYXllcicpKSxcbiAgICAgIH0pLFxuICAgICAgZGVzY3JpcHRpb246ICcvb3B0L2F3c2NsaS9hd3MnLFxuICAgIH0pO1xuICB9XG59XG4iXX0=