# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List


class AddCasterComponentRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        component_name: str = None,
        location_id: str = None,
        component_type: str = None,
        effect: str = None,
        component_layer: str = None,
        layer_order: str = None,
        text_layer_content: str = None,
        image_layer_content: str = None,
        caption_layer_content: str = None,
        html_layer_content: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.component_name = component_name
        self.location_id = location_id
        self.component_type = component_type
        self.effect = effect
        self.component_layer = component_layer
        self.layer_order = layer_order
        self.text_layer_content = text_layer_content
        self.image_layer_content = image_layer_content
        self.caption_layer_content = caption_layer_content
        self.html_layer_content = html_layer_content

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.component_layer is not None:
            result['ComponentLayer'] = self.component_layer
        if self.layer_order is not None:
            result['LayerOrder'] = self.layer_order
        if self.text_layer_content is not None:
            result['TextLayerContent'] = self.text_layer_content
        if self.image_layer_content is not None:
            result['ImageLayerContent'] = self.image_layer_content
        if self.caption_layer_content is not None:
            result['CaptionLayerContent'] = self.caption_layer_content
        if self.html_layer_content is not None:
            result['HtmlLayerContent'] = self.html_layer_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('ComponentLayer') is not None:
            self.component_layer = m.get('ComponentLayer')
        if m.get('LayerOrder') is not None:
            self.layer_order = m.get('LayerOrder')
        if m.get('TextLayerContent') is not None:
            self.text_layer_content = m.get('TextLayerContent')
        if m.get('ImageLayerContent') is not None:
            self.image_layer_content = m.get('ImageLayerContent')
        if m.get('CaptionLayerContent') is not None:
            self.caption_layer_content = m.get('CaptionLayerContent')
        if m.get('HtmlLayerContent') is not None:
            self.html_layer_content = m.get('HtmlLayerContent')
        return self


class AddCasterComponentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        component_id: str = None,
    ):
        self.request_id = request_id
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class AddCasterComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCasterComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCasterComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        episode_type: str = None,
        episode_name: str = None,
        resource_id: str = None,
        start_time: str = None,
        end_time: str = None,
        switch_type: str = None,
        component_id: List[str] = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.episode_type = episode_type
        self.episode_name = episode_name
        self.resource_id = resource_id
        self.start_time = start_time
        self.end_time = end_time
        self.switch_type = switch_type
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class AddCasterEpisodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        episode_id: str = None,
    ):
        self.request_id = request_id
        self.episode_id = episode_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        return self


class AddCasterEpisodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCasterEpisodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeGroupRequestItem(TeaModel):
    def __init__(
        self,
        item_name: str = None,
        vod_url: str = None,
    ):
        self.item_name = item_name
        self.vod_url = vod_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        return self


class AddCasterEpisodeGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        client_token: str = None,
        domain_name: str = None,
        start_time: str = None,
        repeat_num: int = None,
        side_output_url: str = None,
        callback_url: str = None,
        item: List[AddCasterEpisodeGroupRequestItem] = None,
    ):
        self.owner_id = owner_id
        self.client_token = client_token
        self.domain_name = domain_name
        self.start_time = start_time
        self.repeat_num = repeat_num
        self.side_output_url = side_output_url
        self.callback_url = callback_url
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.side_output_url is not None:
            result['SideOutputUrl'] = self.side_output_url
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('SideOutputUrl') is not None:
            self.side_output_url = m.get('SideOutputUrl')
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = AddCasterEpisodeGroupRequestItem()
                self.item.append(temp_model.from_map(k))
        return self


class AddCasterEpisodeGroupResponseBodyItemIds(TeaModel):
    def __init__(
        self,
        item_id: List[str] = None,
    ):
        self.item_id = item_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        return self


class AddCasterEpisodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        program_id: str = None,
        item_ids: AddCasterEpisodeGroupResponseBodyItemIds = None,
    ):
        self.request_id = request_id
        self.program_id = program_id
        self.item_ids = item_ids

    def validate(self):
        if self.item_ids:
            self.item_ids.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('ItemIds') is not None:
            temp_model = AddCasterEpisodeGroupResponseBodyItemIds()
            self.item_ids = temp_model.from_map(m['ItemIds'])
        return self


class AddCasterEpisodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCasterEpisodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeGroupContentRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        client_token: str = None,
        content: str = None,
    ):
        self.owner_id = owner_id
        self.client_token = client_token
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class AddCasterEpisodeGroupContentResponseBodyItemIds(TeaModel):
    def __init__(
        self,
        item_id: List[str] = None,
    ):
        self.item_id = item_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        return self


class AddCasterEpisodeGroupContentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        program_id: str = None,
        item_ids: AddCasterEpisodeGroupContentResponseBodyItemIds = None,
    ):
        self.request_id = request_id
        self.program_id = program_id
        self.item_ids = item_ids

    def validate(self):
        if self.item_ids:
            self.item_ids.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('ItemIds') is not None:
            temp_model = AddCasterEpisodeGroupContentResponseBodyItemIds()
            self.item_ids = temp_model.from_map(m['ItemIds'])
        return self


class AddCasterEpisodeGroupContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCasterEpisodeGroupContentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeGroupContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterLayoutRequestVideoLayer(TeaModel):
    def __init__(
        self,
        fixed_delay_duration: int = None,
        height_normalized: float = None,
        fill_mode: str = None,
        position_refer: str = None,
        position_normalized: List[int] = None,
        width_normalized: float = None,
    ):
        self.fixed_delay_duration = fixed_delay_duration
        self.height_normalized = height_normalized
        self.fill_mode = fill_mode
        self.position_refer = position_refer
        self.position_normalized = position_normalized
        self.width_normalized = width_normalized

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.fill_mode is not None:
            result['FillMode'] = self.fill_mode
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.position_normalized is not None:
            result['PositionNormalized'] = self.position_normalized
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('FillMode') is not None:
            self.fill_mode = m.get('FillMode')
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('PositionNormalized') is not None:
            self.position_normalized = m.get('PositionNormalized')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class AddCasterLayoutRequestAudioLayer(TeaModel):
    def __init__(
        self,
        volume_rate: float = None,
        fixed_delay_duration: int = None,
        valid_channel: str = None,
    ):
        self.volume_rate = volume_rate
        self.fixed_delay_duration = fixed_delay_duration
        self.valid_channel = valid_channel

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        return self


class AddCasterLayoutRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        video_layer: List[AddCasterLayoutRequestVideoLayer] = None,
        audio_layer: List[AddCasterLayoutRequestAudioLayer] = None,
        blend_list: List[str] = None,
        mix_list: List[str] = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.video_layer = video_layer
        self.audio_layer = audio_layer
        self.blend_list = blend_list
        self.mix_list = mix_list

    def validate(self):
        if self.video_layer:
            for k in self.video_layer:
                if k:
                    k.validate()
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        result['VideoLayer'] = []
        if self.video_layer is not None:
            for k in self.video_layer:
                result['VideoLayer'].append(k.to_map() if k else None)
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        if self.blend_list is not None:
            result['BlendList'] = self.blend_list
        if self.mix_list is not None:
            result['MixList'] = self.mix_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        self.video_layer = []
        if m.get('VideoLayer') is not None:
            for k in m.get('VideoLayer'):
                temp_model = AddCasterLayoutRequestVideoLayer()
                self.video_layer.append(temp_model.from_map(k))
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = AddCasterLayoutRequestAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        if m.get('BlendList') is not None:
            self.blend_list = m.get('BlendList')
        if m.get('MixList') is not None:
            self.mix_list = m.get('MixList')
        return self


class AddCasterLayoutResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        layout_id: str = None,
    ):
        self.request_id = request_id
        self.layout_id = layout_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        return self


class AddCasterLayoutResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCasterLayoutResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCasterLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterProgramRequestEpisode(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        start_time: str = None,
        episode_name: str = None,
        episode_type: str = None,
        resource_id: str = None,
        component_id: List[str] = None,
        switch_type: str = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.episode_name = episode_name
        self.episode_type = episode_type
        self.resource_id = resource_id
        self.component_id = component_id
        self.switch_type = switch_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        return self


class AddCasterProgramRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        episode: List[AddCasterProgramRequestEpisode] = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.episode = episode

    def validate(self):
        if self.episode:
            for k in self.episode:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        result['Episode'] = []
        if self.episode is not None:
            for k in self.episode:
                result['Episode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        self.episode = []
        if m.get('Episode') is not None:
            for k in m.get('Episode'):
                temp_model = AddCasterProgramRequestEpisode()
                self.episode.append(temp_model.from_map(k))
        return self


class AddCasterProgramResponseBodyEpisodeIdsEpisodeId(TeaModel):
    def __init__(
        self,
        episode_id: str = None,
    ):
        self.episode_id = episode_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        return self


class AddCasterProgramResponseBodyEpisodeIds(TeaModel):
    def __init__(
        self,
        episode_id: List[AddCasterProgramResponseBodyEpisodeIdsEpisodeId] = None,
    ):
        self.episode_id = episode_id

    def validate(self):
        if self.episode_id:
            for k in self.episode_id:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EpisodeId'] = []
        if self.episode_id is not None:
            for k in self.episode_id:
                result['EpisodeId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.episode_id = []
        if m.get('EpisodeId') is not None:
            for k in m.get('EpisodeId'):
                temp_model = AddCasterProgramResponseBodyEpisodeIdsEpisodeId()
                self.episode_id.append(temp_model.from_map(k))
        return self


class AddCasterProgramResponseBody(TeaModel):
    def __init__(
        self,
        episode_ids: AddCasterProgramResponseBodyEpisodeIds = None,
        request_id: str = None,
    ):
        self.episode_ids = episode_ids
        self.request_id = request_id

    def validate(self):
        if self.episode_ids:
            self.episode_ids.validate()

    def to_map(self):
        result = dict()
        if self.episode_ids is not None:
            result['EpisodeIds'] = self.episode_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EpisodeIds') is not None:
            temp_model = AddCasterProgramResponseBodyEpisodeIds()
            self.episode_ids = temp_model.from_map(m['EpisodeIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCasterProgramResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterVideoResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        resource_name: str = None,
        location_id: str = None,
        live_stream_url: str = None,
        stream_id: str = None,
        material_id: str = None,
        vod_url: str = None,
        begin_offset: int = None,
        end_offset: int = None,
        repeat_num: int = None,
        pts_callback_interval: int = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.resource_name = resource_name
        self.location_id = location_id
        self.live_stream_url = live_stream_url
        self.stream_id = stream_id
        self.material_id = material_id
        self.vod_url = vod_url
        self.begin_offset = begin_offset
        self.end_offset = end_offset
        self.repeat_num = repeat_num
        self.pts_callback_interval = pts_callback_interval

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.live_stream_url is not None:
            result['LiveStreamUrl'] = self.live_stream_url
        if self.stream_id is not None:
            result['StreamId'] = self.stream_id
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        if self.begin_offset is not None:
            result['BeginOffset'] = self.begin_offset
        if self.end_offset is not None:
            result['EndOffset'] = self.end_offset
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.pts_callback_interval is not None:
            result['PtsCallbackInterval'] = self.pts_callback_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('LiveStreamUrl') is not None:
            self.live_stream_url = m.get('LiveStreamUrl')
        if m.get('StreamId') is not None:
            self.stream_id = m.get('StreamId')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        if m.get('BeginOffset') is not None:
            self.begin_offset = m.get('BeginOffset')
        if m.get('EndOffset') is not None:
            self.end_offset = m.get('EndOffset')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('PtsCallbackInterval') is not None:
            self.pts_callback_interval = m.get('PtsCallbackInterval')
        return self


class AddCasterVideoResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_id: str = None,
    ):
        self.request_id = request_id
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class AddCasterVideoResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCasterVideoResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCasterVideoResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCustomLiveStreamTranscodeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain: str = None,
        app: str = None,
        template: str = None,
        template_type: str = None,
        height: int = None,
        width: int = None,
        fps: int = None,
        video_bitrate: int = None,
        audio_bitrate: int = None,
        gop: str = None,
        profile: int = None,
        audio_profile: str = None,
        audio_codec: str = None,
        audio_rate: int = None,
        audio_channel_num: int = None,
        lazy: str = None,
    ):
        self.owner_id = owner_id
        self.domain = domain
        self.app = app
        self.template = template
        self.template_type = template_type
        self.height = height
        self.width = width
        self.fps = fps
        self.video_bitrate = video_bitrate
        self.audio_bitrate = audio_bitrate
        self.gop = gop
        self.profile = profile
        self.audio_profile = audio_profile
        self.audio_codec = audio_codec
        self.audio_rate = audio_rate
        self.audio_channel_num = audio_channel_num
        self.lazy = lazy

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.app is not None:
            result['App'] = self.app
        if self.template is not None:
            result['Template'] = self.template
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.height is not None:
            result['Height'] = self.height
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['FPS'] = self.fps
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.audio_bitrate is not None:
            result['AudioBitrate'] = self.audio_bitrate
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.audio_profile is not None:
            result['AudioProfile'] = self.audio_profile
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.audio_rate is not None:
            result['AudioRate'] = self.audio_rate
        if self.audio_channel_num is not None:
            result['AudioChannelNum'] = self.audio_channel_num
        if self.lazy is not None:
            result['Lazy'] = self.lazy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('FPS') is not None:
            self.fps = m.get('FPS')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('AudioBitrate') is not None:
            self.audio_bitrate = m.get('AudioBitrate')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('AudioProfile') is not None:
            self.audio_profile = m.get('AudioProfile')
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('AudioRate') is not None:
            self.audio_rate = m.get('AudioRate')
        if m.get('AudioChannelNum') is not None:
            self.audio_channel_num = m.get('AudioChannelNum')
        if m.get('Lazy') is not None:
            self.lazy = m.get('Lazy')
        return self


class AddCustomLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCustomLiveStreamTranscodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCustomLiveStreamTranscodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCustomLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAppRecordConfigRequestRecordFormat(TeaModel):
    def __init__(
        self,
        slice_oss_object_prefix: str = None,
        cycle_duration: int = None,
        oss_object_prefix: str = None,
        format: str = None,
    ):
        self.slice_oss_object_prefix = slice_oss_object_prefix
        self.cycle_duration = cycle_duration
        self.oss_object_prefix = oss_object_prefix
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class AddLiveAppRecordConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        oss_endpoint: str = None,
        oss_bucket: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
        on_demand: int = None,
        record_format: List[AddLiveAppRecordConfigRequestRecordFormat] = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.oss_endpoint = oss_endpoint
        self.oss_bucket = oss_bucket
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time
        self.on_demand = on_demand
        self.record_format = record_format

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.on_demand is not None:
            result['OnDemand'] = self.on_demand
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OnDemand') is not None:
            self.on_demand = m.get('OnDemand')
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = AddLiveAppRecordConfigRequestRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class AddLiveAppRecordConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAppRecordConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveAppRecordConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveAppRecordConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAppSnapshotConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        time_interval: int = None,
        oss_endpoint: str = None,
        oss_bucket: str = None,
        overwrite_oss_object: str = None,
        sequence_oss_object: str = None,
        callback: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.time_interval = time_interval
        self.oss_endpoint = oss_endpoint
        self.oss_bucket = oss_bucket
        self.overwrite_oss_object = overwrite_oss_object
        self.sequence_oss_object = sequence_oss_object
        self.callback = callback

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.overwrite_oss_object is not None:
            result['OverwriteOssObject'] = self.overwrite_oss_object
        if self.sequence_oss_object is not None:
            result['SequenceOssObject'] = self.sequence_oss_object
        if self.callback is not None:
            result['Callback'] = self.callback
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OverwriteOssObject') is not None:
            self.overwrite_oss_object = m.get('OverwriteOssObject')
        if m.get('SequenceOssObject') is not None:
            self.sequence_oss_object = m.get('SequenceOssObject')
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        return self


class AddLiveAppSnapshotConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAppSnapshotConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveAppSnapshotConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveAppSnapshotConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveASRConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        mns_topic: str = None,
        mns_region: str = None,
        period: int = None,
        http_callback_url: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.mns_topic = mns_topic
        self.mns_region = mns_region
        self.period = period
        self.http_callback_url = http_callback_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.mns_topic is not None:
            result['MnsTopic'] = self.mns_topic
        if self.mns_region is not None:
            result['MnsRegion'] = self.mns_region
        if self.period is not None:
            result['Period'] = self.period
        if self.http_callback_url is not None:
            result['HttpCallbackURL'] = self.http_callback_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('MnsTopic') is not None:
            self.mns_topic = m.get('MnsTopic')
        if m.get('MnsRegion') is not None:
            self.mns_region = m.get('MnsRegion')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('HttpCallbackURL') is not None:
            self.http_callback_url = m.get('HttpCallbackURL')
        return self


class AddLiveASRConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveASRConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveASRConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveASRConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAudioAuditConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
        oss_object: str = None,
        biz_type: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.oss_bucket = oss_bucket
        self.oss_endpoint = oss_endpoint
        self.oss_object = oss_object
        self.biz_type = biz_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        return self


class AddLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAudioAuditConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveAudioAuditConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveAudioAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAudioAuditNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        callback: str = None,
        callback_template: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.callback = callback
        self.callback_template = callback_template

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.callback is not None:
            result['Callback'] = self.callback
        if self.callback_template is not None:
            result['CallbackTemplate'] = self.callback_template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        if m.get('CallbackTemplate') is not None:
            self.callback_template = m.get('CallbackTemplate')
        return self


class AddLiveAudioAuditNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAudioAuditNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveAudioAuditNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveAudioAuditNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDetectNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        notify_url: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.notify_url = notify_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        return self


class AddLiveDetectNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDetectNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveDetectNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveDetectNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        owner_account: str = None,
        security_token: str = None,
        live_domain_type: str = None,
        domain_name: str = None,
        region: str = None,
        check_url: str = None,
        scope: str = None,
        top_level_domain: str = None,
    ):
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.security_token = security_token
        self.live_domain_type = live_domain_type
        self.domain_name = domain_name
        self.region = region
        self.check_url = check_url
        self.scope = scope
        self.top_level_domain = top_level_domain

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.live_domain_type is not None:
            result['LiveDomainType'] = self.live_domain_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.region is not None:
            result['Region'] = self.region
        if self.check_url is not None:
            result['CheckUrl'] = self.check_url
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.top_level_domain is not None:
            result['TopLevelDomain'] = self.top_level_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('LiveDomainType') is not None:
            self.live_domain_type = m.get('LiveDomainType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('CheckUrl') is not None:
            self.check_url = m.get('CheckUrl')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('TopLevelDomain') is not None:
            self.top_level_domain = m.get('TopLevelDomain')
        return self


class AddLiveDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveDomainResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainMappingRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        push_domain: str = None,
        pull_domain: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.push_domain = push_domain
        self.pull_domain = pull_domain

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.push_domain is not None:
            result['PushDomain'] = self.push_domain
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PushDomain') is not None:
            self.push_domain = m.get('PushDomain')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        return self


class AddLiveDomainMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveDomainMappingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveDomainMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainPlayMappingRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        play_domain: str = None,
        pull_domain: str = None,
    ):
        self.owner_id = owner_id
        self.play_domain = play_domain
        self.pull_domain = pull_domain

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.play_domain is not None:
            result['PlayDomain'] = self.play_domain
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlayDomain') is not None:
            self.play_domain = m.get('PlayDomain')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        return self


class AddLiveDomainPlayMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainPlayMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveDomainPlayMappingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveDomainPlayMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLivePullStreamInfoConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        source_url: str = None,
        start_time: str = None,
        end_time: str = None,
        pull_always: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.source_url = source_url
        self.start_time = start_time
        self.end_time = end_time
        self.pull_always = pull_always

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.source_url is not None:
            result['SourceUrl'] = self.source_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.pull_always is not None:
            result['PullAlways'] = self.pull_always
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('SourceUrl') is not None:
            self.source_url = m.get('SourceUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PullAlways') is not None:
            self.pull_always = m.get('PullAlways')
        return self


class AddLivePullStreamInfoConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLivePullStreamInfoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLivePullStreamInfoConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLivePullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveRecordNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        notify_url: str = None,
        need_status_notify: bool = None,
        on_demand_url: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.notify_url = notify_url
        self.need_status_notify = need_status_notify
        self.on_demand_url = on_demand_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.need_status_notify is not None:
            result['NeedStatusNotify'] = self.need_status_notify
        if self.on_demand_url is not None:
            result['OnDemandUrl'] = self.on_demand_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('NeedStatusNotify') is not None:
            self.need_status_notify = m.get('NeedStatusNotify')
        if m.get('OnDemandUrl') is not None:
            self.on_demand_url = m.get('OnDemandUrl')
        return self


class AddLiveRecordNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveRecordNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveRecordNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveRecordNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveRecordVodConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        vod_transcode_group_id: str = None,
        cycle_duration: int = None,
        auto_compose: str = None,
        storage_location: str = None,
        compose_vod_transcode_group_id: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.vod_transcode_group_id = vod_transcode_group_id
        self.cycle_duration = cycle_duration
        self.auto_compose = auto_compose
        self.storage_location = storage_location
        self.compose_vod_transcode_group_id = compose_vod_transcode_group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.vod_transcode_group_id is not None:
            result['VodTranscodeGroupId'] = self.vod_transcode_group_id
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.auto_compose is not None:
            result['AutoCompose'] = self.auto_compose
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.compose_vod_transcode_group_id is not None:
            result['ComposeVodTranscodeGroupId'] = self.compose_vod_transcode_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('VodTranscodeGroupId') is not None:
            self.vod_transcode_group_id = m.get('VodTranscodeGroupId')
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('AutoCompose') is not None:
            self.auto_compose = m.get('AutoCompose')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('ComposeVodTranscodeGroupId') is not None:
            self.compose_vod_transcode_group_id = m.get('ComposeVodTranscodeGroupId')
        return self


class AddLiveRecordVodConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveRecordVodConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveRecordVodConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveRecordVodConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveSnapshotDetectPornConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        oss_endpoint: str = None,
        oss_bucket: str = None,
        oss_object: str = None,
        interval: int = None,
        scene: List[str] = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.oss_endpoint = oss_endpoint
        self.oss_bucket = oss_bucket
        self.oss_object = oss_object
        self.interval = interval
        self.scene = scene

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.scene is not None:
            result['Scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        return self


class AddLiveSnapshotDetectPornConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveSnapshotDetectPornConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveSnapshotDetectPornConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveSnapshotDetectPornConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveStreamTranscodeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain: str = None,
        app: str = None,
        template: str = None,
        encrypt_parameters: str = None,
        lazy: str = None,
        watermark: str = None,
        mix: str = None,
        only_audio: str = None,
        water_pattern: str = None,
    ):
        self.owner_id = owner_id
        self.domain = domain
        self.app = app
        self.template = template
        self.encrypt_parameters = encrypt_parameters
        self.lazy = lazy
        self.watermark = watermark
        self.mix = mix
        self.only_audio = only_audio
        self.water_pattern = water_pattern

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.app is not None:
            result['App'] = self.app
        if self.template is not None:
            result['Template'] = self.template
        if self.encrypt_parameters is not None:
            result['EncryptParameters'] = self.encrypt_parameters
        if self.lazy is not None:
            result['Lazy'] = self.lazy
        if self.watermark is not None:
            result['Watermark'] = self.watermark
        if self.mix is not None:
            result['Mix'] = self.mix
        if self.only_audio is not None:
            result['OnlyAudio'] = self.only_audio
        if self.water_pattern is not None:
            result['WaterPattern'] = self.water_pattern
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('EncryptParameters') is not None:
            self.encrypt_parameters = m.get('EncryptParameters')
        if m.get('Lazy') is not None:
            self.lazy = m.get('Lazy')
        if m.get('Watermark') is not None:
            self.watermark = m.get('Watermark')
        if m.get('Mix') is not None:
            self.mix = m.get('Mix')
        if m.get('OnlyAudio') is not None:
            self.only_audio = m.get('OnlyAudio')
        if m.get('WaterPattern') is not None:
            self.water_pattern = m.get('WaterPattern')
        return self


class AddLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveStreamTranscodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddLiveStreamTranscodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddRtsLiveStreamTranscodeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain: str = None,
        app: str = None,
        template: str = None,
        template_type: str = None,
        height: int = None,
        width: int = None,
        fps: int = None,
        video_bitrate: int = None,
        audio_bitrate: int = None,
        gop: str = None,
        delete_bframes: bool = None,
        opus: bool = None,
        profile: int = None,
        audio_profile: str = None,
        audio_codec: str = None,
        audio_rate: int = None,
        audio_channel_num: int = None,
        lazy: str = None,
    ):
        self.owner_id = owner_id
        self.domain = domain
        self.app = app
        self.template = template
        self.template_type = template_type
        self.height = height
        self.width = width
        self.fps = fps
        self.video_bitrate = video_bitrate
        self.audio_bitrate = audio_bitrate
        self.gop = gop
        self.delete_bframes = delete_bframes
        self.opus = opus
        self.profile = profile
        self.audio_profile = audio_profile
        self.audio_codec = audio_codec
        self.audio_rate = audio_rate
        self.audio_channel_num = audio_channel_num
        self.lazy = lazy

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.app is not None:
            result['App'] = self.app
        if self.template is not None:
            result['Template'] = self.template
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.height is not None:
            result['Height'] = self.height
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['FPS'] = self.fps
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.audio_bitrate is not None:
            result['AudioBitrate'] = self.audio_bitrate
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.delete_bframes is not None:
            result['DeleteBframes'] = self.delete_bframes
        if self.opus is not None:
            result['Opus'] = self.opus
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.audio_profile is not None:
            result['AudioProfile'] = self.audio_profile
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.audio_rate is not None:
            result['AudioRate'] = self.audio_rate
        if self.audio_channel_num is not None:
            result['AudioChannelNum'] = self.audio_channel_num
        if self.lazy is not None:
            result['Lazy'] = self.lazy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('FPS') is not None:
            self.fps = m.get('FPS')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('AudioBitrate') is not None:
            self.audio_bitrate = m.get('AudioBitrate')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('DeleteBframes') is not None:
            self.delete_bframes = m.get('DeleteBframes')
        if m.get('Opus') is not None:
            self.opus = m.get('Opus')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('AudioProfile') is not None:
            self.audio_profile = m.get('AudioProfile')
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('AudioRate') is not None:
            self.audio_rate = m.get('AudioRate')
        if m.get('AudioChannelNum') is not None:
            self.audio_channel_num = m.get('AudioChannelNum')
        if m.get('Lazy') is not None:
            self.lazy = m.get('Lazy')
        return self


class AddRtsLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddRtsLiveStreamTranscodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddRtsLiveStreamTranscodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddRtsLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTrancodeSEIRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        text: str = None,
        pattern: str = None,
        repeat: int = None,
        delay: int = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.text = text
        self.pattern = pattern
        self.repeat = repeat
        self.delay = delay

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.text is not None:
            result['Text'] = self.text
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        if self.repeat is not None:
            result['Repeat'] = self.repeat
        if self.delay is not None:
            result['Delay'] = self.delay
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        if m.get('Repeat') is not None:
            self.repeat = m.get('Repeat')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        return self


class AddTrancodeSEIResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTrancodeSEIResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddTrancodeSEIResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddTrancodeSEIResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllowPushStreamRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class AllowPushStreamResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllowPushStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllowPushStreamResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllowPushStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyBoardTokenRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        app_uid: str = None,
        board_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.app_uid = app_uid
        self.board_id = board_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_uid is not None:
            result['AppUid'] = self.app_uid
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppUid') is not None:
            self.app_uid = m.get('AppUid')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        return self


class ApplyBoardTokenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        token: str = None,
        expired: str = None,
    ):
        self.request_id = request_id
        self.token = token
        self.expired = expired

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.token is not None:
            result['Token'] = self.token
        if self.expired is not None:
            result['Expired'] = self.expired
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        return self


class ApplyBoardTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ApplyBoardTokenResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ApplyBoardTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyRecordTokenRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class ApplyRecordTokenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_token: str = None,
        access_key_secret: str = None,
        access_key_id: str = None,
        expiration: str = None,
    ):
        self.request_id = request_id
        self.security_token = security_token
        self.access_key_secret = access_key_secret
        self.access_key_id = access_key_id
        self.expiration = expiration

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.access_key_secret is not None:
            result['AccessKeySecret'] = self.access_key_secret
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.expiration is not None:
            result['Expiration'] = self.expiration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('AccessKeySecret') is not None:
            self.access_key_secret = m.get('AccessKeySecret')
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('Expiration') is not None:
            self.expiration = m.get('Expiration')
        return self


class ApplyRecordTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ApplyRecordTokenResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ApplyRecordTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteLiveDomainConfigsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        owner_account: str = None,
        security_token: str = None,
        domain_names: str = None,
        function_names: str = None,
    ):
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.security_token = security_token
        self.domain_names = domain_names
        self.function_names = function_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        return self


class BatchDeleteLiveDomainConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchDeleteLiveDomainConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchDeleteLiveDomainConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteLiveDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetLiveDomainConfigsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        owner_account: str = None,
        security_token: str = None,
        domain_names: str = None,
        functions: str = None,
    ):
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.security_token = security_token
        self.domain_names = domain_names
        self.functions = functions

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.functions is not None:
            result['Functions'] = self.functions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('Functions') is not None:
            self.functions = m.get('Functions')
        return self


class BatchSetLiveDomainConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchSetLiveDomainConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchSetLiveDomainConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetLiveDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CompleteBoardRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        board_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.board_id = board_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        return self


class CompleteBoardResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CompleteBoardResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CompleteBoardResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CompleteBoardResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CompleteBoardRecordRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        record_id: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.record_id = record_id
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class CompleteBoardRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        oss_path: str = None,
    ):
        self.request_id = request_id
        self.oss_path = oss_path

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.oss_path is not None:
            result['OssPath'] = self.oss_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OssPath') is not None:
            self.oss_path = m.get('OssPath')
        return self


class CompleteBoardRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CompleteBoardRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CompleteBoardRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ControlHtmlResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        html_resource_id: str = None,
        html_url: str = None,
        caster_id: str = None,
        operate: str = None,
    ):
        self.owner_id = owner_id
        self.html_resource_id = html_resource_id
        self.html_url = html_url
        self.caster_id = caster_id
        self.operate = operate

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.html_resource_id is not None:
            result['HtmlResourceId'] = self.html_resource_id
        if self.html_url is not None:
            result['htmlUrl'] = self.html_url
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.operate is not None:
            result['Operate'] = self.operate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('HtmlResourceId') is not None:
            self.html_resource_id = m.get('HtmlResourceId')
        if m.get('htmlUrl') is not None:
            self.html_url = m.get('htmlUrl')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('Operate') is not None:
            self.operate = m.get('Operate')
        return self


class ControlHtmlResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        stream_id: str = None,
    ):
        self.request_id = request_id
        self.stream_id = stream_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stream_id is not None:
            result['StreamId'] = self.stream_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StreamId') is not None:
            self.stream_id = m.get('StreamId')
        return self


class ControlHtmlResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ControlHtmlResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ControlHtmlResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCasterRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_name: str = None,
        src_caster_id: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.caster_name = caster_name
        self.src_caster_id = src_caster_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.src_caster_id is not None:
            result['SrcCasterId'] = self.src_caster_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('SrcCasterId') is not None:
            self.src_caster_id = m.get('SrcCasterId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CopyCasterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class CopyCasterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopyCasterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCasterSceneConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        from_scene_id: str = None,
        to_scene_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.from_scene_id = from_scene_id
        self.to_scene_id = to_scene_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.from_scene_id is not None:
            result['FromSceneId'] = self.from_scene_id
        if self.to_scene_id is not None:
            result['ToSceneId'] = self.to_scene_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('FromSceneId') is not None:
            self.from_scene_id = m.get('FromSceneId')
        if m.get('ToSceneId') is not None:
            self.to_scene_id = m.get('ToSceneId')
        return self


class CopyCasterSceneConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyCasterSceneConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopyCasterSceneConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyCasterSceneConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBoardRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        app_uid: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.app_uid = app_uid

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_uid is not None:
            result['AppUid'] = self.app_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppUid') is not None:
            self.app_uid = m.get('AppUid')
        return self


class CreateBoardResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        board_id: str = None,
    ):
        self.request_id = request_id
        self.board_id = board_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        return self


class CreateBoardResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBoardResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBoardResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCasterRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_name: str = None,
        client_token: str = None,
        norm_type: int = None,
        charge_type: str = None,
        purchase_time: str = None,
        expire_time: str = None,
        caster_template: str = None,
    ):
        self.owner_id = owner_id
        self.caster_name = caster_name
        self.client_token = client_token
        self.norm_type = norm_type
        self.charge_type = charge_type
        self.purchase_time = purchase_time
        self.expire_time = expire_time
        self.caster_template = caster_template

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.norm_type is not None:
            result['NormType'] = self.norm_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.purchase_time is not None:
            result['PurchaseTime'] = self.purchase_time
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('NormType') is not None:
            self.norm_type = m.get('NormType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('PurchaseTime') is not None:
            self.purchase_time = m.get('PurchaseTime')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        return self


class CreateCasterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class CreateCasterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateCasterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveRealTimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        project: str = None,
        logstore: str = None,
        region: str = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.project = project
        self.logstore = logstore
        self.region = region
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.region is not None:
            result['Region'] = self.region
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class CreateLiveRealTimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveRealTimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLiveRealTimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLiveRealTimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveStreamRecordIndexFilesRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        oss_endpoint: str = None,
        oss_bucket: str = None,
        oss_object: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.oss_endpoint = oss_endpoint
        self.oss_bucket = oss_bucket
        self.oss_object = oss_object
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo(TeaModel):
    def __init__(
        self,
        stream_name: str = None,
        record_url: str = None,
        record_id: str = None,
        create_time: str = None,
        height: int = None,
        oss_bucket: str = None,
        domain_name: str = None,
        end_time: str = None,
        oss_object: str = None,
        start_time: str = None,
        app_name: str = None,
        width: int = None,
        duration: float = None,
        oss_endpoint: str = None,
    ):
        self.stream_name = stream_name
        self.record_url = record_url
        self.record_id = record_id
        self.create_time = create_time
        self.height = height
        self.oss_bucket = oss_bucket
        self.domain_name = domain_name
        self.end_time = end_time
        self.oss_object = oss_object
        self.start_time = start_time
        self.app_name = app_name
        self.width = width
        self.duration = duration
        self.oss_endpoint = oss_endpoint

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.height is not None:
            result['Height'] = self.height
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.width is not None:
            result['Width'] = self.width
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class CreateLiveStreamRecordIndexFilesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        record_info: CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo = None,
    ):
        self.request_id = request_id
        self.record_info = record_info

    def validate(self):
        if self.record_info:
            self.record_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.record_info is not None:
            result['RecordInfo'] = self.record_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RecordInfo') is not None:
            temp_model = CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo()
            self.record_info = temp_model.from_map(m['RecordInfo'])
        return self


class CreateLiveStreamRecordIndexFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLiveStreamRecordIndexFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLiveStreamRecordIndexFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMixStreamRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        layout_id: str = None,
        input_stream_list: str = None,
        output_config: str = None,
        callback_config: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.layout_id = layout_id
        self.input_stream_list = input_stream_list
        self.output_config = output_config
        self.callback_config = callback_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.input_stream_list is not None:
            result['InputStreamList'] = self.input_stream_list
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config
        if self.callback_config is not None:
            result['CallbackConfig'] = self.callback_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('InputStreamList') is not None:
            self.input_stream_list = m.get('InputStreamList')
        if m.get('OutputConfig') is not None:
            self.output_config = m.get('OutputConfig')
        if m.get('CallbackConfig') is not None:
            self.callback_config = m.get('CallbackConfig')
        return self


class CreateMixStreamResponseBody(TeaModel):
    def __init__(
        self,
        mix_stream_id: str = None,
        request_id: str = None,
    ):
        self.mix_stream_id = mix_stream_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMixStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMixStreamResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMixStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRoomRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
        anchor_id: str = None,
        template_ids: str = None,
        use_app_transcode: bool = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id
        self.anchor_id = anchor_id
        self.template_ids = template_ids
        self.use_app_transcode = use_app_transcode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.anchor_id is not None:
            result['AnchorId'] = self.anchor_id
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.use_app_transcode is not None:
            result['UseAppTranscode'] = self.use_app_transcode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('AnchorId') is not None:
            self.anchor_id = m.get('AnchorId')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('UseAppTranscode') is not None:
            self.use_app_transcode = m.get('UseAppTranscode')
        return self


class CreateRoomResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        app_id: str = None,
        anchor_id: str = None,
        room_id: str = None,
    ):
        self.request_id = request_id
        self.app_id = app_id
        self.anchor_id = anchor_id
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.anchor_id is not None:
            result['AnchorId'] = self.anchor_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AnchorId') is not None:
            self.anchor_id = m.get('AnchorId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class CreateRoomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRoomResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBoardRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        board_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.board_id = board_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        return self


class DeleteBoardResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBoardResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBoardResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBoardResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DeleteCasterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DeleteCasterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCasterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterComponentRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        component_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class DeleteCasterComponentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
        component_id: str = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class DeleteCasterComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCasterComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCasterComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterEpisodeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        episode_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.episode_id = episode_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        return self


class DeleteCasterEpisodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        episode_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.episode_id = episode_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DeleteCasterEpisodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCasterEpisodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCasterEpisodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterEpisodeGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        program_id: str = None,
    ):
        self.owner_id = owner_id
        self.program_id = program_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        return self


class DeleteCasterEpisodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterEpisodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCasterEpisodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCasterEpisodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterLayoutRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        layout_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.layout_id = layout_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        return self


class DeleteCasterLayoutResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        layout_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.layout_id = layout_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DeleteCasterLayoutResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCasterLayoutResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCasterLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterProgramRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DeleteCasterProgramResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DeleteCasterProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCasterProgramResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterSceneConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        scene_id: str = None,
        type: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.scene_id = scene_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteCasterSceneConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterSceneConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCasterSceneConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCasterSceneConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterVideoResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        resource_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DeleteCasterVideoResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterVideoResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCasterVideoResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCasterVideoResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHtmlResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        html_resource_id: str = None,
        html_url: str = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.html_resource_id = html_resource_id
        self.html_url = html_url
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.html_resource_id is not None:
            result['HtmlResourceId'] = self.html_resource_id
        if self.html_url is not None:
            result['htmlUrl'] = self.html_url
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('HtmlResourceId') is not None:
            self.html_resource_id = m.get('HtmlResourceId')
        if m.get('htmlUrl') is not None:
            self.html_url = m.get('htmlUrl')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DeleteHtmlResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHtmlResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteHtmlResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteHtmlResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAppRecordConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveAppRecordConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAppRecordConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveAppRecordConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveAppRecordConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAppSnapshotConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        return self


class DeleteLiveAppSnapshotConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAppSnapshotConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveAppSnapshotConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveAppSnapshotConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveASRConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveASRConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveASRConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveASRConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveASRConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAudioAuditConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAudioAuditConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveAudioAuditConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveAudioAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAudioAuditNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DeleteLiveAudioAuditNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAudioAuditNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveAudioAuditNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveAudioAuditNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDetectNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DeleteLiveDetectNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDetectNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveDetectNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveDetectNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        owner_account: str = None,
        security_token: str = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.security_token = security_token
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DeleteLiveDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveDomainResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainMappingRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        push_domain: str = None,
        pull_domain: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.push_domain = push_domain
        self.pull_domain = pull_domain

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.push_domain is not None:
            result['PushDomain'] = self.push_domain
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PushDomain') is not None:
            self.push_domain = m.get('PushDomain')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        return self


class DeleteLiveDomainMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveDomainMappingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainPlayMappingRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        play_domain: str = None,
        pull_domain: str = None,
    ):
        self.owner_id = owner_id
        self.play_domain = play_domain
        self.pull_domain = pull_domain

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.play_domain is not None:
            result['PlayDomain'] = self.play_domain
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlayDomain') is not None:
            self.play_domain = m.get('PlayDomain')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        return self


class DeleteLiveDomainPlayMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainPlayMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveDomainPlayMappingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainPlayMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveLazyPullStreamInfoConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        return self


class DeleteLiveLazyPullStreamInfoConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveLazyPullStreamInfoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveLazyPullStreamInfoConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveLazyPullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePullStreamInfoConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLivePullStreamInfoConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLivePullStreamInfoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLivePullStreamInfoConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLivePullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRealtimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        project: str = None,
        logstore: str = None,
        region: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.project = project
        self.logstore = logstore
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.project is not None:
            result['Project'] = self.project
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DeleteLiveRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRealtimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveRealtimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRealTimeLogLogstoreRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        project: str = None,
        logstore: str = None,
        region: str = None,
    ):
        self.owner_id = owner_id
        self.project = project
        self.logstore = logstore
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DeleteLiveRealTimeLogLogstoreResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRealTimeLogLogstoreResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveRealTimeLogLogstoreResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveRealTimeLogLogstoreResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DeleteLiveRecordNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveRecordNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordVodConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveRecordVodConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordVodConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveRecordVodConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordVodConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotDetectPornConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        return self


class DeleteLiveSnapshotDetectPornConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotDetectPornConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveSnapshotDetectPornConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotDetectPornConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamsNotifyUrlConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DeleteLiveStreamsNotifyUrlConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamsNotifyUrlConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveStreamsNotifyUrlConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamsNotifyUrlConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamTranscodeRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain: str = None,
        app: str = None,
        template: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain = domain
        self.app = app
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.app is not None:
            result['App'] = self.app
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class DeleteLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamTranscodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLiveStreamTranscodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMixStreamRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        mix_stream_id: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.mix_stream_id = mix_stream_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        return self


class DeleteMixStreamResponseBody(TeaModel):
    def __init__(
        self,
        mix_stream_id: str = None,
        request_id: str = None,
    ):
        self.mix_stream_id = mix_stream_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMixStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMixStreamResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMixStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoomRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class DeleteRoomResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRoomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRoomResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBoardEventsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        start_time: str = None,
        end_time: str = None,
        board_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.start_time = start_time
        self.end_time = end_time
        self.board_id = board_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        return self


class DescribeBoardEventsResponseBodyEvents(TeaModel):
    def __init__(
        self,
        event_id: int = None,
        event_type: int = None,
        user_id: int = None,
        data: str = None,
        timestamp: int = None,
    ):
        self.event_id = event_id
        self.event_type = event_type
        self.user_id = user_id
        self.data = data
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.data is not None:
            result['Data'] = self.data
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class DescribeBoardEventsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        events: List[DescribeBoardEventsResponseBodyEvents] = None,
    ):
        self.request_id = request_id
        self.events = events

    def validate(self):
        if self.events:
            for k in self.events:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Events'] = []
        if self.events is not None:
            for k in self.events:
                result['Events'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.events = []
        if m.get('Events') is not None:
            for k in m.get('Events'):
                temp_model = DescribeBoardEventsResponseBodyEvents()
                self.events.append(temp_model.from_map(k))
        return self


class DescribeBoardEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBoardEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBoardEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBoardsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeBoardsResponseBodyBoards(TeaModel):
    def __init__(
        self,
        board_id: str = None,
        topic: str = None,
        state: int = None,
        user_id: str = None,
    ):
        self.board_id = board_id
        self.topic = topic
        self.state = state
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.state is not None:
            result['State'] = self.state
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DescribeBoardsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        boards: List[DescribeBoardsResponseBodyBoards] = None,
    ):
        self.request_id = request_id
        self.boards = boards

    def validate(self):
        if self.boards:
            for k in self.boards:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Boards'] = []
        if self.boards is not None:
            for k in self.boards:
                result['Boards'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.boards = []
        if m.get('Boards') is not None:
            for k in m.get('Boards'):
                temp_model = DescribeBoardsResponseBodyBoards()
                self.boards.append(temp_model.from_map(k))
        return self


class DescribeBoardsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBoardsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBoardsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBoardSnapshotRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        board_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.board_id = board_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        return self


class DescribeBoardSnapshotResponseBodySnapshotBoardPagesElements(TeaModel):
    def __init__(
        self,
        element_index: str = None,
        owner_id: str = None,
        element_type: int = None,
        update_timestamp: int = None,
        data: str = None,
    ):
        self.element_index = element_index
        self.owner_id = owner_id
        self.element_type = element_type
        self.update_timestamp = update_timestamp
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.element_index is not None:
            result['ElementIndex'] = self.element_index
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.element_type is not None:
            result['ElementType'] = self.element_type
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ElementIndex') is not None:
            self.element_index = m.get('ElementIndex')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ElementType') is not None:
            self.element_type = m.get('ElementType')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DescribeBoardSnapshotResponseBodySnapshotBoardPages(TeaModel):
    def __init__(
        self,
        page_index: int = None,
        elements: List[DescribeBoardSnapshotResponseBodySnapshotBoardPagesElements] = None,
    ):
        self.page_index = page_index
        self.elements = elements

    def validate(self):
        if self.elements:
            for k in self.elements:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        result['Elements'] = []
        if self.elements is not None:
            for k in self.elements:
                result['Elements'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        self.elements = []
        if m.get('Elements') is not None:
            for k in m.get('Elements'):
                temp_model = DescribeBoardSnapshotResponseBodySnapshotBoardPagesElements()
                self.elements.append(temp_model.from_map(k))
        return self


class DescribeBoardSnapshotResponseBodySnapshotBoardConfigs(TeaModel):
    def __init__(
        self,
        app_uid: str = None,
        data: str = None,
    ):
        self.app_uid = app_uid
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.app_uid is not None:
            result['AppUid'] = self.app_uid
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppUid') is not None:
            self.app_uid = m.get('AppUid')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DescribeBoardSnapshotResponseBodySnapshotBoard(TeaModel):
    def __init__(
        self,
        board_id: str = None,
        app_uid: str = None,
        event_timestamp: int = None,
        create_timestamp: int = None,
        update_timestamp: int = None,
        pages: List[DescribeBoardSnapshotResponseBodySnapshotBoardPages] = None,
        configs: List[DescribeBoardSnapshotResponseBodySnapshotBoardConfigs] = None,
    ):
        self.board_id = board_id
        self.app_uid = app_uid
        self.event_timestamp = event_timestamp
        self.create_timestamp = create_timestamp
        self.update_timestamp = update_timestamp
        self.pages = pages
        self.configs = configs

    def validate(self):
        if self.pages:
            for k in self.pages:
                if k:
                    k.validate()
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        if self.app_uid is not None:
            result['AppUid'] = self.app_uid
        if self.event_timestamp is not None:
            result['EventTimestamp'] = self.event_timestamp
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        result['Pages'] = []
        if self.pages is not None:
            for k in self.pages:
                result['Pages'].append(k.to_map() if k else None)
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        if m.get('AppUid') is not None:
            self.app_uid = m.get('AppUid')
        if m.get('EventTimestamp') is not None:
            self.event_timestamp = m.get('EventTimestamp')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        self.pages = []
        if m.get('Pages') is not None:
            for k in m.get('Pages'):
                temp_model = DescribeBoardSnapshotResponseBodySnapshotBoardPages()
                self.pages.append(temp_model.from_map(k))
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = DescribeBoardSnapshotResponseBodySnapshotBoardConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class DescribeBoardSnapshotResponseBodySnapshot(TeaModel):
    def __init__(
        self,
        board: DescribeBoardSnapshotResponseBodySnapshotBoard = None,
    ):
        self.board = board

    def validate(self):
        if self.board:
            self.board.validate()

    def to_map(self):
        result = dict()
        if self.board is not None:
            result['Board'] = self.board.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Board') is not None:
            temp_model = DescribeBoardSnapshotResponseBodySnapshotBoard()
            self.board = temp_model.from_map(m['Board'])
        return self


class DescribeBoardSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snapshot: DescribeBoardSnapshotResponseBodySnapshot = None,
    ):
        self.request_id = request_id
        self.snapshot = snapshot

    def validate(self):
        if self.snapshot:
            self.snapshot.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot is not None:
            result['Snapshot'] = self.snapshot.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Snapshot') is not None:
            temp_model = DescribeBoardSnapshotResponseBodySnapshot()
            self.snapshot = temp_model.from_map(m['Snapshot'])
        return self


class DescribeBoardSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBoardSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBoardSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterChannelsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeCasterChannelsResponseBodyChannelsChannel(TeaModel):
    def __init__(
        self,
        rtmp_url: str = None,
        channel_id: str = None,
        resource_id: str = None,
        stream_url: str = None,
    ):
        self.rtmp_url = rtmp_url
        self.channel_id = channel_id
        self.resource_id = resource_id
        self.stream_url = stream_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.rtmp_url is not None:
            result['RtmpUrl'] = self.rtmp_url
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RtmpUrl') is not None:
            self.rtmp_url = m.get('RtmpUrl')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterChannelsResponseBodyChannels(TeaModel):
    def __init__(
        self,
        channel: List[DescribeCasterChannelsResponseBodyChannelsChannel] = None,
    ):
        self.channel = channel

    def validate(self):
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = DescribeCasterChannelsResponseBodyChannelsChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class DescribeCasterChannelsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total: int = None,
        channels: DescribeCasterChannelsResponseBodyChannels = None,
    ):
        self.request_id = request_id
        self.total = total
        self.channels = channels

    def validate(self):
        if self.channels:
            self.channels.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Channels') is not None:
            temp_model = DescribeCasterChannelsResponseBodyChannels()
            self.channels = temp_model.from_map(m['Channels'])
        return self


class DescribeCasterChannelsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterChannelsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterChannelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterComponentsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        component_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent(TeaModel):
    def __init__(
        self,
        color: str = None,
        border_color: str = None,
        border_width_normalized: float = None,
        text: str = None,
        size_normalized: float = None,
        font_name: str = None,
    ):
        self.color = color
        self.border_color = border_color
        self.border_width_normalized = border_width_normalized
        self.text = text
        self.size_normalized = size_normalized
        self.font_name = font_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.color is not None:
            result['Color'] = self.color
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.text is not None:
            result['Text'] = self.text
        if self.size_normalized is not None:
            result['SizeNormalized'] = self.size_normalized
        if self.font_name is not None:
            result['FontName'] = self.font_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Color') is not None:
            self.color = m.get('Color')
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('SizeNormalized') is not None:
            self.size_normalized = m.get('SizeNormalized')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds(TeaModel):
    def __init__(
        self,
        position: List[float] = None,
    ):
        self.position = position

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer(TeaModel):
    def __init__(
        self,
        transparency: int = None,
        position_normalizeds: DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds = None,
        height_normalized: float = None,
        position_refer: str = None,
        width_normalized: float = None,
    ):
        self.transparency = transparency
        self.position_normalizeds = position_normalizeds
        self.height_normalized = height_normalized
        self.position_refer = position_refer
        self.width_normalized = width_normalized

    def validate(self):
        if self.position_normalizeds:
            self.position_normalizeds.validate()

    def to_map(self):
        result = dict()
        if self.transparency is not None:
            result['Transparency'] = self.transparency
        if self.position_normalizeds is not None:
            result['PositionNormalizeds'] = self.position_normalizeds.to_map()
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Transparency') is not None:
            self.transparency = m.get('Transparency')
        if m.get('PositionNormalizeds') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds()
            self.position_normalizeds = temp_model.from_map(m['PositionNormalizeds'])
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent(TeaModel):
    def __init__(
        self,
        material_id: str = None,
    ):
        self.material_id = material_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent(TeaModel):
    def __init__(
        self,
        color: str = None,
        word_space_normalized: float = None,
        border_width_normalized: float = None,
        source_lan: str = None,
        word_count_per_line: int = None,
        target_lan: str = None,
        border_color: str = None,
        location_id: str = None,
        line_space_normalized: float = None,
        size_normalized: float = None,
        show_source_lan: bool = None,
        words_count: int = None,
        font_name: str = None,
        pts_offset: int = None,
    ):
        self.color = color
        self.word_space_normalized = word_space_normalized
        self.border_width_normalized = border_width_normalized
        self.source_lan = source_lan
        self.word_count_per_line = word_count_per_line
        self.target_lan = target_lan
        self.border_color = border_color
        self.location_id = location_id
        self.line_space_normalized = line_space_normalized
        self.size_normalized = size_normalized
        self.show_source_lan = show_source_lan
        self.words_count = words_count
        self.font_name = font_name
        self.pts_offset = pts_offset

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.color is not None:
            result['Color'] = self.color
        if self.word_space_normalized is not None:
            result['WordSpaceNormalized'] = self.word_space_normalized
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.source_lan is not None:
            result['SourceLan'] = self.source_lan
        if self.word_count_per_line is not None:
            result['WordCountPerLine'] = self.word_count_per_line
        if self.target_lan is not None:
            result['TargetLan'] = self.target_lan
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.line_space_normalized is not None:
            result['LineSpaceNormalized'] = self.line_space_normalized
        if self.size_normalized is not None:
            result['SizeNormalized'] = self.size_normalized
        if self.show_source_lan is not None:
            result['ShowSourceLan'] = self.show_source_lan
        if self.words_count is not None:
            result['WordsCount'] = self.words_count
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.pts_offset is not None:
            result['PtsOffset'] = self.pts_offset
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Color') is not None:
            self.color = m.get('Color')
        if m.get('WordSpaceNormalized') is not None:
            self.word_space_normalized = m.get('WordSpaceNormalized')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('SourceLan') is not None:
            self.source_lan = m.get('SourceLan')
        if m.get('WordCountPerLine') is not None:
            self.word_count_per_line = m.get('WordCountPerLine')
        if m.get('TargetLan') is not None:
            self.target_lan = m.get('TargetLan')
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('LineSpaceNormalized') is not None:
            self.line_space_normalized = m.get('LineSpaceNormalized')
        if m.get('SizeNormalized') is not None:
            self.size_normalized = m.get('SizeNormalized')
        if m.get('ShowSourceLan') is not None:
            self.show_source_lan = m.get('ShowSourceLan')
        if m.get('WordsCount') is not None:
            self.words_count = m.get('WordsCount')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('PtsOffset') is not None:
            self.pts_offset = m.get('PtsOffset')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponent(TeaModel):
    def __init__(
        self,
        text_layer_content: DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent = None,
        effect: str = None,
        component_name: str = None,
        component_layer: DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer = None,
        image_layer_content: DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent = None,
        component_type: str = None,
        location_id: str = None,
        caption_layer_content: DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent = None,
        component_id: str = None,
    ):
        self.text_layer_content = text_layer_content
        self.effect = effect
        self.component_name = component_name
        self.component_layer = component_layer
        self.image_layer_content = image_layer_content
        self.component_type = component_type
        self.location_id = location_id
        self.caption_layer_content = caption_layer_content
        self.component_id = component_id

    def validate(self):
        if self.text_layer_content:
            self.text_layer_content.validate()
        if self.component_layer:
            self.component_layer.validate()
        if self.image_layer_content:
            self.image_layer_content.validate()
        if self.caption_layer_content:
            self.caption_layer_content.validate()

    def to_map(self):
        result = dict()
        if self.text_layer_content is not None:
            result['TextLayerContent'] = self.text_layer_content.to_map()
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_layer is not None:
            result['ComponentLayer'] = self.component_layer.to_map()
        if self.image_layer_content is not None:
            result['ImageLayerContent'] = self.image_layer_content.to_map()
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.caption_layer_content is not None:
            result['CaptionLayerContent'] = self.caption_layer_content.to_map()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TextLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent()
            self.text_layer_content = temp_model.from_map(m['TextLayerContent'])
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentLayer') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer()
            self.component_layer = temp_model.from_map(m['ComponentLayer'])
        if m.get('ImageLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent()
            self.image_layer_content = temp_model.from_map(m['ImageLayerContent'])
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('CaptionLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent()
            self.caption_layer_content = temp_model.from_map(m['CaptionLayerContent'])
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class DescribeCasterComponentsResponseBodyComponents(TeaModel):
    def __init__(
        self,
        component: List[DescribeCasterComponentsResponseBodyComponentsComponent] = None,
    ):
        self.component = component

    def validate(self):
        if self.component:
            for k in self.component:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Component'] = []
        if self.component is not None:
            for k in self.component:
                result['Component'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.component = []
        if m.get('Component') is not None:
            for k in m.get('Component'):
                temp_model = DescribeCasterComponentsResponseBodyComponentsComponent()
                self.component.append(temp_model.from_map(k))
        return self


class DescribeCasterComponentsResponseBody(TeaModel):
    def __init__(
        self,
        components: DescribeCasterComponentsResponseBodyComponents = None,
        request_id: str = None,
        total: int = None,
    ):
        self.components = components
        self.request_id = request_id
        self.total = total

    def validate(self):
        if self.components:
            self.components.validate()

    def to_map(self):
        result = dict()
        if self.components is not None:
            result['Components'] = self.components.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Components') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponents()
            self.components = temp_model.from_map(m['Components'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterComponentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterComponentsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterComponentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds(TeaModel):
    def __init__(
        self,
        location_id: List[str] = None,
    ):
        self.location_id = location_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterConfigResponseBodyTranscodeConfig(TeaModel):
    def __init__(
        self,
        caster_template: str = None,
        live_template_ids: DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds = None,
    ):
        self.caster_template = caster_template
        self.live_template_ids = live_template_ids

    def validate(self):
        if self.live_template_ids:
            self.live_template_ids.validate()

    def to_map(self):
        result = dict()
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        if self.live_template_ids is not None:
            result['LiveTemplateIds'] = self.live_template_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        if m.get('LiveTemplateIds') is not None:
            temp_model = DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds()
            self.live_template_ids = temp_model.from_map(m['LiveTemplateIds'])
        return self


class DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat(TeaModel):
    def __init__(
        self,
        cycle_duration: int = None,
        slice_oss_object_prefix: str = None,
        oss_object_prefix: str = None,
        format: str = None,
    ):
        self.cycle_duration = cycle_duration
        self.slice_oss_object_prefix = slice_oss_object_prefix
        self.oss_object_prefix = oss_object_prefix
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class DescribeCasterConfigResponseBodyRecordConfigRecordFormat(TeaModel):
    def __init__(
        self,
        record_format: List[DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat] = None,
    ):
        self.record_format = record_format

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class DescribeCasterConfigResponseBodyRecordConfig(TeaModel):
    def __init__(
        self,
        record_format: DescribeCasterConfigResponseBodyRecordConfigRecordFormat = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
    ):
        self.record_format = record_format
        self.oss_bucket = oss_bucket
        self.oss_endpoint = oss_endpoint

    def validate(self):
        if self.record_format:
            self.record_format.validate()

    def to_map(self):
        result = dict()
        if self.record_format is not None:
            result['RecordFormat'] = self.record_format.to_map()
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordFormat') is not None:
            temp_model = DescribeCasterConfigResponseBodyRecordConfigRecordFormat()
            self.record_format = temp_model.from_map(m['RecordFormat'])
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeCasterConfigResponseBody(TeaModel):
    def __init__(
        self,
        channel_enable: int = None,
        request_id: str = None,
        domain_name: str = None,
        urgent_material_id: str = None,
        transcode_config: DescribeCasterConfigResponseBodyTranscodeConfig = None,
        program_name: str = None,
        delay: float = None,
        callback_url: str = None,
        side_output_url: str = None,
        caster_name: str = None,
        program_effect: int = None,
        caster_id: str = None,
        record_config: DescribeCasterConfigResponseBodyRecordConfig = None,
    ):
        self.channel_enable = channel_enable
        self.request_id = request_id
        self.domain_name = domain_name
        self.urgent_material_id = urgent_material_id
        self.transcode_config = transcode_config
        self.program_name = program_name
        self.delay = delay
        self.callback_url = callback_url
        self.side_output_url = side_output_url
        self.caster_name = caster_name
        self.program_effect = program_effect
        self.caster_id = caster_id
        self.record_config = record_config

    def validate(self):
        if self.transcode_config:
            self.transcode_config.validate()
        if self.record_config:
            self.record_config.validate()

    def to_map(self):
        result = dict()
        if self.channel_enable is not None:
            result['ChannelEnable'] = self.channel_enable
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.urgent_material_id is not None:
            result['UrgentMaterialId'] = self.urgent_material_id
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config.to_map()
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.side_output_url is not None:
            result['SideOutputUrl'] = self.side_output_url
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.program_effect is not None:
            result['ProgramEffect'] = self.program_effect
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.record_config is not None:
            result['RecordConfig'] = self.record_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelEnable') is not None:
            self.channel_enable = m.get('ChannelEnable')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('UrgentMaterialId') is not None:
            self.urgent_material_id = m.get('UrgentMaterialId')
        if m.get('TranscodeConfig') is not None:
            temp_model = DescribeCasterConfigResponseBodyTranscodeConfig()
            self.transcode_config = temp_model.from_map(m['TranscodeConfig'])
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('SideOutputUrl') is not None:
            self.side_output_url = m.get('SideOutputUrl')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('ProgramEffect') is not None:
            self.program_effect = m.get('ProgramEffect')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RecordConfig') is not None:
            temp_model = DescribeCasterConfigResponseBodyRecordConfig()
            self.record_config = temp_model.from_map(m['RecordConfig'])
        return self


class DescribeCasterConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterLayoutsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        layout_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.layout_id = layout_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer(TeaModel):
    def __init__(
        self,
        volume_rate: float = None,
        fixed_delay_duration: int = None,
        valid_channel: str = None,
    ):
        self.volume_rate = volume_rate
        self.fixed_delay_duration = fixed_delay_duration
        self.valid_channel = valid_channel

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers(TeaModel):
    def __init__(
        self,
        audio_layer: List[DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer] = None,
    ):
        self.audio_layer = audio_layer

    def validate(self):
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds(TeaModel):
    def __init__(
        self,
        position: List[float] = None,
    ):
        self.position = position

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer(TeaModel):
    def __init__(
        self,
        fixed_delay_duration: int = None,
        position_normalizeds: DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds = None,
        height_normalized: float = None,
        fill_mode: str = None,
        position_refer: str = None,
        width_normalized: float = None,
    ):
        self.fixed_delay_duration = fixed_delay_duration
        self.position_normalizeds = position_normalizeds
        self.height_normalized = height_normalized
        self.fill_mode = fill_mode
        self.position_refer = position_refer
        self.width_normalized = width_normalized

    def validate(self):
        if self.position_normalizeds:
            self.position_normalizeds.validate()

    def to_map(self):
        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.position_normalizeds is not None:
            result['PositionNormalizeds'] = self.position_normalizeds.to_map()
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.fill_mode is not None:
            result['FillMode'] = self.fill_mode
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('PositionNormalizeds') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds()
            self.position_normalizeds = temp_model.from_map(m['PositionNormalizeds'])
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('FillMode') is not None:
            self.fill_mode = m.get('FillMode')
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers(TeaModel):
    def __init__(
        self,
        video_layer: List[DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer] = None,
    ):
        self.video_layer = video_layer

    def validate(self):
        if self.video_layer:
            for k in self.video_layer:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['VideoLayer'] = []
        if self.video_layer is not None:
            for k in self.video_layer:
                result['VideoLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_layer = []
        if m.get('VideoLayer') is not None:
            for k in m.get('VideoLayer'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer()
                self.video_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList(TeaModel):
    def __init__(
        self,
        location_id: List[str] = None,
    ):
        self.location_id = location_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList(TeaModel):
    def __init__(
        self,
        location_id: List[str] = None,
    ):
        self.location_id = location_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayout(TeaModel):
    def __init__(
        self,
        layout_id: str = None,
        audio_layers: DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers = None,
        video_layers: DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers = None,
        mix_list: DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList = None,
        blend_list: DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList = None,
    ):
        self.layout_id = layout_id
        self.audio_layers = audio_layers
        self.video_layers = video_layers
        self.mix_list = mix_list
        self.blend_list = blend_list

    def validate(self):
        if self.audio_layers:
            self.audio_layers.validate()
        if self.video_layers:
            self.video_layers.validate()
        if self.mix_list:
            self.mix_list.validate()
        if self.blend_list:
            self.blend_list.validate()

    def to_map(self):
        result = dict()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.audio_layers is not None:
            result['AudioLayers'] = self.audio_layers.to_map()
        if self.video_layers is not None:
            result['VideoLayers'] = self.video_layers.to_map()
        if self.mix_list is not None:
            result['MixList'] = self.mix_list.to_map()
        if self.blend_list is not None:
            result['BlendList'] = self.blend_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('AudioLayers') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers()
            self.audio_layers = temp_model.from_map(m['AudioLayers'])
        if m.get('VideoLayers') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers()
            self.video_layers = temp_model.from_map(m['VideoLayers'])
        if m.get('MixList') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList()
            self.mix_list = temp_model.from_map(m['MixList'])
        if m.get('BlendList') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList()
            self.blend_list = temp_model.from_map(m['BlendList'])
        return self


class DescribeCasterLayoutsResponseBodyLayouts(TeaModel):
    def __init__(
        self,
        layout: List[DescribeCasterLayoutsResponseBodyLayoutsLayout] = None,
    ):
        self.layout = layout

    def validate(self):
        if self.layout:
            for k in self.layout:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Layout'] = []
        if self.layout is not None:
            for k in self.layout:
                result['Layout'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.layout = []
        if m.get('Layout') is not None:
            for k in m.get('Layout'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayout()
                self.layout.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        layouts: DescribeCasterLayoutsResponseBodyLayouts = None,
        total: int = None,
    ):
        self.request_id = request_id
        self.layouts = layouts
        self.total = total

    def validate(self):
        if self.layouts:
            self.layouts.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.layouts is not None:
            result['Layouts'] = self.layouts.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Layouts') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayouts()
            self.layouts = temp_model.from_map(m['Layouts'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterLayoutsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterLayoutsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterLayoutsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterProgramRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        episode_id: str = None,
        episode_type: str = None,
        start_time: str = None,
        end_time: str = None,
        page_num: int = None,
        page_size: int = None,
        status: int = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.episode_id = episode_id
        self.episode_type = episode_type
        self.start_time = start_time
        self.end_time = end_time
        self.page_num = page_num
        self.page_size = page_size
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds(TeaModel):
    def __init__(
        self,
        component_id: List[str] = None,
    ):
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class DescribeCasterProgramResponseBodyEpisodesEpisode(TeaModel):
    def __init__(
        self,
        status: int = None,
        end_time: str = None,
        start_time: str = None,
        episode_name: str = None,
        episode_type: str = None,
        episode_id: str = None,
        resource_id: str = None,
        switch_type: str = None,
        component_ids: DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds = None,
    ):
        self.status = status
        self.end_time = end_time
        self.start_time = start_time
        self.episode_name = episode_name
        self.episode_type = episode_type
        self.episode_id = episode_id
        self.resource_id = resource_id
        self.switch_type = switch_type
        self.component_ids = component_ids

    def validate(self):
        if self.component_ids:
            self.component_ids.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        if self.component_ids is not None:
            result['ComponentIds'] = self.component_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        if m.get('ComponentIds') is not None:
            temp_model = DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds()
            self.component_ids = temp_model.from_map(m['ComponentIds'])
        return self


class DescribeCasterProgramResponseBodyEpisodes(TeaModel):
    def __init__(
        self,
        episode: List[DescribeCasterProgramResponseBodyEpisodesEpisode] = None,
    ):
        self.episode = episode

    def validate(self):
        if self.episode:
            for k in self.episode:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Episode'] = []
        if self.episode is not None:
            for k in self.episode:
                result['Episode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.episode = []
        if m.get('Episode') is not None:
            for k in m.get('Episode'):
                temp_model = DescribeCasterProgramResponseBodyEpisodesEpisode()
                self.episode.append(temp_model.from_map(k))
        return self


class DescribeCasterProgramResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        program_effect: int = None,
        total: int = None,
        episodes: DescribeCasterProgramResponseBodyEpisodes = None,
        program_name: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.program_effect = program_effect
        self.total = total
        self.episodes = episodes
        self.program_name = program_name
        self.caster_id = caster_id

    def validate(self):
        if self.episodes:
            self.episodes.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.program_effect is not None:
            result['ProgramEffect'] = self.program_effect
        if self.total is not None:
            result['Total'] = self.total
        if self.episodes is not None:
            result['Episodes'] = self.episodes.to_map()
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ProgramEffect') is not None:
            self.program_effect = m.get('ProgramEffect')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Episodes') is not None:
            temp_model = DescribeCasterProgramResponseBodyEpisodes()
            self.episodes = temp_model.from_map(m['Episodes'])
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeCasterProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterProgramResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterRtcInfoRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeCasterRtcInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
        auth_token: str = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id
        self.auth_token = auth_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.auth_token is not None:
            result['AuthToken'] = self.auth_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('AuthToken') is not None:
            self.auth_token = m.get('AuthToken')
        return self


class DescribeCasterRtcInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterRtcInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterRtcInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCastersRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        caster_name: str = None,
        start_time: str = None,
        end_time: str = None,
        page_num: int = None,
        page_size: int = None,
        status: int = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.caster_name = caster_name
        self.start_time = start_time
        self.end_time = end_time
        self.page_num = page_num
        self.page_size = page_size
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCastersResponseBodyCasterListCaster(TeaModel):
    def __init__(
        self,
        status: int = None,
        start_time: str = None,
        purchase_time: str = None,
        expire_time: str = None,
        create_time: str = None,
        caster_template: str = None,
        charge_type: str = None,
        caster_name: str = None,
        norm_type: int = None,
        caster_id: str = None,
        channel_enable: int = None,
    ):
        self.status = status
        self.start_time = start_time
        self.purchase_time = purchase_time
        self.expire_time = expire_time
        self.create_time = create_time
        self.caster_template = caster_template
        self.charge_type = charge_type
        self.caster_name = caster_name
        self.norm_type = norm_type
        self.caster_id = caster_id
        self.channel_enable = channel_enable

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.purchase_time is not None:
            result['PurchaseTime'] = self.purchase_time
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.norm_type is not None:
            result['NormType'] = self.norm_type
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.channel_enable is not None:
            result['ChannelEnable'] = self.channel_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('PurchaseTime') is not None:
            self.purchase_time = m.get('PurchaseTime')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('NormType') is not None:
            self.norm_type = m.get('NormType')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ChannelEnable') is not None:
            self.channel_enable = m.get('ChannelEnable')
        return self


class DescribeCastersResponseBodyCasterList(TeaModel):
    def __init__(
        self,
        caster: List[DescribeCastersResponseBodyCasterListCaster] = None,
    ):
        self.caster = caster

    def validate(self):
        if self.caster:
            for k in self.caster:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Caster'] = []
        if self.caster is not None:
            for k in self.caster:
                result['Caster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.caster = []
        if m.get('Caster') is not None:
            for k in m.get('Caster'):
                temp_model = DescribeCastersResponseBodyCasterListCaster()
                self.caster.append(temp_model.from_map(k))
        return self


class DescribeCastersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total: int = None,
        caster_list: DescribeCastersResponseBodyCasterList = None,
    ):
        self.request_id = request_id
        self.total = total
        self.caster_list = caster_list

    def validate(self):
        if self.caster_list:
            self.caster_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.caster_list is not None:
            result['CasterList'] = self.caster_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CasterList') is not None:
            temp_model = DescribeCastersResponseBodyCasterList()
            self.caster_list = temp_model.from_map(m['CasterList'])
        return self


class DescribeCastersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCastersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCastersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterSceneAudioRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        scene_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.scene_id = scene_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        return self


class DescribeCasterSceneAudioResponseBodyMixList(TeaModel):
    def __init__(
        self,
        location_id: List[str] = None,
    ):
        self.location_id = location_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer(TeaModel):
    def __init__(
        self,
        volume_rate: float = None,
        fixed_delay_duration: int = None,
        valid_channel: str = None,
    ):
        self.volume_rate = volume_rate
        self.fixed_delay_duration = fixed_delay_duration
        self.valid_channel = valid_channel

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        return self


class DescribeCasterSceneAudioResponseBodyAudioLayers(TeaModel):
    def __init__(
        self,
        audio_layer: List[DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer] = None,
    ):
        self.audio_layer = audio_layer

    def validate(self):
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterSceneAudioResponseBody(TeaModel):
    def __init__(
        self,
        mix_list: DescribeCasterSceneAudioResponseBodyMixList = None,
        request_id: str = None,
        audio_layers: DescribeCasterSceneAudioResponseBodyAudioLayers = None,
        caster_id: str = None,
        follow_enable: int = None,
    ):
        self.mix_list = mix_list
        self.request_id = request_id
        self.audio_layers = audio_layers
        self.caster_id = caster_id
        self.follow_enable = follow_enable

    def validate(self):
        if self.mix_list:
            self.mix_list.validate()
        if self.audio_layers:
            self.audio_layers.validate()

    def to_map(self):
        result = dict()
        if self.mix_list is not None:
            result['MixList'] = self.mix_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.audio_layers is not None:
            result['AudioLayers'] = self.audio_layers.to_map()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.follow_enable is not None:
            result['FollowEnable'] = self.follow_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MixList') is not None:
            temp_model = DescribeCasterSceneAudioResponseBodyMixList()
            self.mix_list = temp_model.from_map(m['MixList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AudioLayers') is not None:
            temp_model = DescribeCasterSceneAudioResponseBodyAudioLayers()
            self.audio_layers = temp_model.from_map(m['AudioLayers'])
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('FollowEnable') is not None:
            self.follow_enable = m.get('FollowEnable')
        return self


class DescribeCasterSceneAudioResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterSceneAudioResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterSceneAudioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterScenesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        scene_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.scene_id = scene_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        return self


class DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo(TeaModel):
    def __init__(
        self,
        video_format: str = None,
        output_stream_url: str = None,
        transcode_config: str = None,
    ):
        self.video_format = video_format
        self.output_stream_url = output_stream_url
        self.transcode_config = transcode_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.video_format is not None:
            result['VideoFormat'] = self.video_format
        if self.output_stream_url is not None:
            result['OutputStreamUrl'] = self.output_stream_url
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoFormat') is not None:
            self.video_format = m.get('VideoFormat')
        if m.get('OutputStreamUrl') is not None:
            self.output_stream_url = m.get('OutputStreamUrl')
        if m.get('TranscodeConfig') is not None:
            self.transcode_config = m.get('TranscodeConfig')
        return self


class DescribeCasterScenesResponseBodySceneListSceneStreamInfos(TeaModel):
    def __init__(
        self,
        stream_info: List[DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo] = None,
    ):
        self.stream_info = stream_info

    def validate(self):
        if self.stream_info:
            for k in self.stream_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['StreamInfo'] = []
        if self.stream_info is not None:
            for k in self.stream_info:
                result['StreamInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_info = []
        if m.get('StreamInfo') is not None:
            for k in m.get('StreamInfo'):
                temp_model = DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo()
                self.stream_info.append(temp_model.from_map(k))
        return self


class DescribeCasterScenesResponseBodySceneListSceneComponentIds(TeaModel):
    def __init__(
        self,
        component_id: List[str] = None,
    ):
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.component_id is not None:
            result['componentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('componentId') is not None:
            self.component_id = m.get('componentId')
        return self


class DescribeCasterScenesResponseBodySceneListScene(TeaModel):
    def __init__(
        self,
        status: int = None,
        layout_id: str = None,
        output_type: str = None,
        stream_infos: DescribeCasterScenesResponseBodySceneListSceneStreamInfos = None,
        scene_id: str = None,
        scene_name: str = None,
        component_ids: DescribeCasterScenesResponseBodySceneListSceneComponentIds = None,
        stream_url: str = None,
    ):
        self.status = status
        self.layout_id = layout_id
        self.output_type = output_type
        self.stream_infos = stream_infos
        self.scene_id = scene_id
        self.scene_name = scene_name
        self.component_ids = component_ids
        self.stream_url = stream_url

    def validate(self):
        if self.stream_infos:
            self.stream_infos.validate()
        if self.component_ids:
            self.component_ids.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.stream_infos is not None:
            result['StreamInfos'] = self.stream_infos.to_map()
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.scene_name is not None:
            result['SceneName'] = self.scene_name
        if self.component_ids is not None:
            result['ComponentIds'] = self.component_ids.to_map()
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('StreamInfos') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneListSceneStreamInfos()
            self.stream_infos = temp_model.from_map(m['StreamInfos'])
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('SceneName') is not None:
            self.scene_name = m.get('SceneName')
        if m.get('ComponentIds') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneListSceneComponentIds()
            self.component_ids = temp_model.from_map(m['ComponentIds'])
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterScenesResponseBodySceneList(TeaModel):
    def __init__(
        self,
        scene: List[DescribeCasterScenesResponseBodySceneListScene] = None,
    ):
        self.scene = scene

    def validate(self):
        if self.scene:
            for k in self.scene:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Scene'] = []
        if self.scene is not None:
            for k in self.scene:
                result['Scene'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.scene = []
        if m.get('Scene') is not None:
            for k in m.get('Scene'):
                temp_model = DescribeCasterScenesResponseBodySceneListScene()
                self.scene.append(temp_model.from_map(k))
        return self


class DescribeCasterScenesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total: int = None,
        scene_list: DescribeCasterScenesResponseBodySceneList = None,
    ):
        self.request_id = request_id
        self.total = total
        self.scene_list = scene_list

    def validate(self):
        if self.scene_list:
            self.scene_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.scene_list is not None:
            result['SceneList'] = self.scene_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('SceneList') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneList()
            self.scene_list = temp_model.from_map(m['SceneList'])
        return self


class DescribeCasterScenesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterScenesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterScenesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterStreamUrlRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo(TeaModel):
    def __init__(
        self,
        video_format: str = None,
        output_stream_url: str = None,
        transcode_config: str = None,
    ):
        self.video_format = video_format
        self.output_stream_url = output_stream_url
        self.transcode_config = transcode_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.video_format is not None:
            result['VideoFormat'] = self.video_format
        if self.output_stream_url is not None:
            result['OutputStreamUrl'] = self.output_stream_url
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoFormat') is not None:
            self.video_format = m.get('VideoFormat')
        if m.get('OutputStreamUrl') is not None:
            self.output_stream_url = m.get('OutputStreamUrl')
        if m.get('TranscodeConfig') is not None:
            self.transcode_config = m.get('TranscodeConfig')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos(TeaModel):
    def __init__(
        self,
        stream_info: List[DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo] = None,
    ):
        self.stream_info = stream_info

    def validate(self):
        if self.stream_info:
            for k in self.stream_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['StreamInfo'] = []
        if self.stream_info is not None:
            for k in self.stream_info:
                result['StreamInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_info = []
        if m.get('StreamInfo') is not None:
            for k in m.get('StreamInfo'):
                temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo()
                self.stream_info.append(temp_model.from_map(k))
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream(TeaModel):
    def __init__(
        self,
        rtmp_url: str = None,
        output_type: int = None,
        stream_infos: DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos = None,
        scene_id: str = None,
        stream_url: str = None,
    ):
        self.rtmp_url = rtmp_url
        self.output_type = output_type
        self.stream_infos = stream_infos
        self.scene_id = scene_id
        self.stream_url = stream_url

    def validate(self):
        if self.stream_infos:
            self.stream_infos.validate()

    def to_map(self):
        result = dict()
        if self.rtmp_url is not None:
            result['RtmpUrl'] = self.rtmp_url
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.stream_infos is not None:
            result['StreamInfos'] = self.stream_infos.to_map()
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RtmpUrl') is not None:
            self.rtmp_url = m.get('RtmpUrl')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('StreamInfos') is not None:
            temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos()
            self.stream_infos = temp_model.from_map(m['StreamInfos'])
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreams(TeaModel):
    def __init__(
        self,
        caster_stream: List[DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream] = None,
    ):
        self.caster_stream = caster_stream

    def validate(self):
        if self.caster_stream:
            for k in self.caster_stream:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CasterStream'] = []
        if self.caster_stream is not None:
            for k in self.caster_stream:
                result['CasterStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.caster_stream = []
        if m.get('CasterStream') is not None:
            for k in m.get('CasterStream'):
                temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream()
                self.caster_stream.append(temp_model.from_map(k))
        return self


class DescribeCasterStreamUrlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total: int = None,
        caster_streams: DescribeCasterStreamUrlResponseBodyCasterStreams = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.total = total
        self.caster_streams = caster_streams
        self.caster_id = caster_id

    def validate(self):
        if self.caster_streams:
            self.caster_streams.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.caster_streams is not None:
            result['CasterStreams'] = self.caster_streams.to_map()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CasterStreams') is not None:
            temp_model = DescribeCasterStreamUrlResponseBodyCasterStreams()
            self.caster_streams = temp_model.from_map(m['CasterStreams'])
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeCasterStreamUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterStreamUrlResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterStreamUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterSyncGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroupResourceIds(TeaModel):
    def __init__(
        self,
        resource_id: List[str] = None,
    ):
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroup(TeaModel):
    def __init__(
        self,
        mode: int = None,
        host_resource_id: str = None,
        resource_ids: DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroupResourceIds = None,
    ):
        self.mode = mode
        self.host_resource_id = host_resource_id
        self.resource_ids = resource_ids

    def validate(self):
        if self.resource_ids:
            self.resource_ids.validate()

    def to_map(self):
        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.host_resource_id is not None:
            result['HostResourceId'] = self.host_resource_id
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('HostResourceId') is not None:
            self.host_resource_id = m.get('HostResourceId')
        if m.get('ResourceIds') is not None:
            temp_model = DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroupResourceIds()
            self.resource_ids = temp_model.from_map(m['ResourceIds'])
        return self


class DescribeCasterSyncGroupResponseBodySyncGroups(TeaModel):
    def __init__(
        self,
        sync_group: List[DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroup] = None,
    ):
        self.sync_group = sync_group

    def validate(self):
        if self.sync_group:
            for k in self.sync_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SyncGroup'] = []
        if self.sync_group is not None:
            for k in self.sync_group:
                result['SyncGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.sync_group = []
        if m.get('SyncGroup') is not None:
            for k in m.get('SyncGroup'):
                temp_model = DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroup()
                self.sync_group.append(temp_model.from_map(k))
        return self


class DescribeCasterSyncGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
        sync_groups: DescribeCasterSyncGroupResponseBodySyncGroups = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id
        self.sync_groups = sync_groups

    def validate(self):
        if self.sync_groups:
            self.sync_groups.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.sync_groups is not None:
            result['SyncGroups'] = self.sync_groups.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('SyncGroups') is not None:
            temp_model = DescribeCasterSyncGroupResponseBodySyncGroups()
            self.sync_groups = temp_model.from_map(m['SyncGroups'])
        return self


class DescribeCasterSyncGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterSyncGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterSyncGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterVideoResourcesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource(TeaModel):
    def __init__(
        self,
        end_offset: int = None,
        begin_offset: int = None,
        pts_callback_interval: int = None,
        material_id: str = None,
        location_id: str = None,
        live_stream_url: str = None,
        vod_url: str = None,
        resource_id: str = None,
        repeat_num: int = None,
        resource_name: str = None,
    ):
        self.end_offset = end_offset
        self.begin_offset = begin_offset
        self.pts_callback_interval = pts_callback_interval
        self.material_id = material_id
        self.location_id = location_id
        self.live_stream_url = live_stream_url
        self.vod_url = vod_url
        self.resource_id = resource_id
        self.repeat_num = repeat_num
        self.resource_name = resource_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_offset is not None:
            result['EndOffset'] = self.end_offset
        if self.begin_offset is not None:
            result['BeginOffset'] = self.begin_offset
        if self.pts_callback_interval is not None:
            result['PtsCallbackInterval'] = self.pts_callback_interval
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.live_stream_url is not None:
            result['LiveStreamUrl'] = self.live_stream_url
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndOffset') is not None:
            self.end_offset = m.get('EndOffset')
        if m.get('BeginOffset') is not None:
            self.begin_offset = m.get('BeginOffset')
        if m.get('PtsCallbackInterval') is not None:
            self.pts_callback_interval = m.get('PtsCallbackInterval')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('LiveStreamUrl') is not None:
            self.live_stream_url = m.get('LiveStreamUrl')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class DescribeCasterVideoResourcesResponseBodyVideoResources(TeaModel):
    def __init__(
        self,
        video_resource: List[DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource] = None,
    ):
        self.video_resource = video_resource

    def validate(self):
        if self.video_resource:
            for k in self.video_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['VideoResource'] = []
        if self.video_resource is not None:
            for k in self.video_resource:
                result['VideoResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_resource = []
        if m.get('VideoResource') is not None:
            for k in m.get('VideoResource'):
                temp_model = DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource()
                self.video_resource.append(temp_model.from_map(k))
        return self


class DescribeCasterVideoResourcesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total: int = None,
        video_resources: DescribeCasterVideoResourcesResponseBodyVideoResources = None,
    ):
        self.request_id = request_id
        self.total = total
        self.video_resources = video_resources

    def validate(self):
        if self.video_resources:
            self.video_resources.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.video_resources is not None:
            result['VideoResources'] = self.video_resources.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('VideoResources') is not None:
            temp_model = DescribeCasterVideoResourcesResponseBodyVideoResources()
            self.video_resources = temp_model.from_map(m['VideoResources'])
        return self


class DescribeCasterVideoResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCasterVideoResourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCasterVideoResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainUsageDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        type: str = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        area: str = None,
        field: str = None,
        interval: str = None,
    ):
        self.owner_id = owner_id
        self.type = type
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.area = area
        self.field = field
        self.interval = interval

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.type is not None:
            result['Type'] = self.type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.area is not None:
            result['Area'] = self.area
        if self.field is not None:
            result['Field'] = self.field
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule(TeaModel):
    def __init__(
        self,
        value: str = None,
        time_stamp: str = None,
    ):
        self.value = value
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDomainUsageDataResponseBodyUsageDataPerInterval(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDomainUsageDataResponseBody(TeaModel):
    def __init__(
        self,
        usage_data_per_interval: DescribeDomainUsageDataResponseBodyUsageDataPerInterval = None,
        field: str = None,
        area: str = None,
        end_time: str = None,
        request_id: str = None,
        domain_name: str = None,
        start_time: str = None,
        data_interval: str = None,
    ):
        self.usage_data_per_interval = usage_data_per_interval
        self.field = field
        self.area = area
        self.end_time = end_time
        self.request_id = request_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.data_interval = data_interval

    def validate(self):
        if self.usage_data_per_interval:
            self.usage_data_per_interval.validate()

    def to_map(self):
        result = dict()
        if self.usage_data_per_interval is not None:
            result['UsageDataPerInterval'] = self.usage_data_per_interval.to_map()
        if self.field is not None:
            result['Field'] = self.field
        if self.area is not None:
            result['Area'] = self.area
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UsageDataPerInterval') is not None:
            temp_model = DescribeDomainUsageDataResponseBodyUsageDataPerInterval()
            self.usage_data_per_interval = temp_model.from_map(m['UsageDataPerInterval'])
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        return self


class DescribeDomainUsageDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDomainUsageDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeForbidPushStreamRoomListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        order: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.order = order
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeForbidPushStreamRoomListResponseBodyRoomList(TeaModel):
    def __init__(
        self,
        op_end_time: str = None,
        anchor_id: str = None,
        op_start_time: str = None,
        room_id: str = None,
    ):
        self.op_end_time = op_end_time
        self.anchor_id = anchor_id
        self.op_start_time = op_start_time
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.op_end_time is not None:
            result['OpEndTime'] = self.op_end_time
        if self.anchor_id is not None:
            result['AnchorId'] = self.anchor_id
        if self.op_start_time is not None:
            result['OpStartTime'] = self.op_start_time
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpEndTime') is not None:
            self.op_end_time = m.get('OpEndTime')
        if m.get('AnchorId') is not None:
            self.anchor_id = m.get('AnchorId')
        if m.get('OpStartTime') is not None:
            self.op_start_time = m.get('OpStartTime')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class DescribeForbidPushStreamRoomListResponseBody(TeaModel):
    def __init__(
        self,
        total_num: int = None,
        total_page: int = None,
        request_id: str = None,
        room_list: List[DescribeForbidPushStreamRoomListResponseBodyRoomList] = None,
    ):
        self.total_num = total_num
        self.total_page = total_page
        self.request_id = request_id
        self.room_list = room_list

    def validate(self):
        if self.room_list:
            for k in self.room_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RoomList'] = []
        if self.room_list is not None:
            for k in self.room_list:
                result['RoomList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.room_list = []
        if m.get('RoomList') is not None:
            for k in m.get('RoomList'):
                temp_model = DescribeForbidPushStreamRoomListResponseBodyRoomList()
                self.room_list.append(temp_model.from_map(k))
        return self


class DescribeForbidPushStreamRoomListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeForbidPushStreamRoomListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeForbidPushStreamRoomListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHlsLiveStreamRealTimeBpsDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos(TeaModel):
    def __init__(
        self,
        down_flow: float = None,
        online: float = None,
        rate: str = None,
    ):
        self.down_flow = down_flow
        self.online = online
        self.rate = rate

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.down_flow is not None:
            result['DownFlow'] = self.down_flow
        if self.online is not None:
            result['Online'] = self.online
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownFlow') is not None:
            self.down_flow = m.get('DownFlow')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos(TeaModel):
    def __init__(
        self,
        stream_name: str = None,
        infos: List[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos] = None,
    ):
        self.stream_name = stream_name
        self.infos = infos

    def validate(self):
        if self.infos:
            for k in self.infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        result['Infos'] = []
        if self.infos is not None:
            for k in self.infos:
                result['Infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        self.infos = []
        if m.get('Infos') is not None:
            for k in m.get('Infos'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos()
                self.infos.append(temp_model.from_map(k))
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData(TeaModel):
    def __init__(
        self,
        stream_infos: List[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos] = None,
        domain_name: str = None,
    ):
        self.stream_infos = stream_infos
        self.domain_name = domain_name

    def validate(self):
        if self.stream_infos:
            for k in self.stream_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['StreamInfos'] = []
        if self.stream_infos is not None:
            for k in self.stream_infos:
                result['StreamInfos'].append(k.to_map() if k else None)
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_infos = []
        if m.get('StreamInfos') is not None:
            for k in m.get('StreamInfos'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos()
                self.stream_infos.append(temp_model.from_map(k))
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        usage_data: List[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData] = None,
        time: str = None,
    ):
        self.request_id = request_id
        self.usage_data = usage_data
        self.time = time

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData()
                self.usage_data.append(temp_model.from_map(k))
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHlsLiveStreamRealTimeBpsDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHtmlResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        html_resource_id: str = None,
        html_url: str = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.html_resource_id = html_resource_id
        self.html_url = html_url
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.html_resource_id is not None:
            result['HtmlResourceId'] = self.html_resource_id
        if self.html_url is not None:
            result['htmlUrl'] = self.html_url
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('HtmlResourceId') is not None:
            self.html_resource_id = m.get('HtmlResourceId')
        if m.get('htmlUrl') is not None:
            self.html_url = m.get('htmlUrl')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class DescribeHtmlResourceResponseBodyHtmlResource(TeaModel):
    def __init__(
        self,
        html_resource_id: str = None,
        html_url: str = None,
        html_content: str = None,
        caster_id: str = None,
        config: str = None,
        stream_id: str = None,
    ):
        self.html_resource_id = html_resource_id
        self.html_url = html_url
        self.html_content = html_content
        self.caster_id = caster_id
        self.config = config
        self.stream_id = stream_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.html_resource_id is not None:
            result['HtmlResourceId'] = self.html_resource_id
        if self.html_url is not None:
            result['HtmlUrl'] = self.html_url
        if self.html_content is not None:
            result['HtmlContent'] = self.html_content
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.config is not None:
            result['Config'] = self.config
        if self.stream_id is not None:
            result['StreamId'] = self.stream_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HtmlResourceId') is not None:
            self.html_resource_id = m.get('HtmlResourceId')
        if m.get('HtmlUrl') is not None:
            self.html_url = m.get('HtmlUrl')
        if m.get('HtmlContent') is not None:
            self.html_content = m.get('HtmlContent')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('StreamId') is not None:
            self.stream_id = m.get('StreamId')
        return self


class DescribeHtmlResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        html_resource: DescribeHtmlResourceResponseBodyHtmlResource = None,
    ):
        self.request_id = request_id
        self.html_resource = html_resource

    def validate(self):
        if self.html_resource:
            self.html_resource.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.html_resource is not None:
            result['HtmlResource'] = self.html_resource.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HtmlResource') is not None:
            temp_model = DescribeHtmlResourceResponseBodyHtmlResource()
            self.html_resource = temp_model.from_map(m['HtmlResource'])
        return self


class DescribeHtmlResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHtmlResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHtmlResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAsrConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveAsrConfigResponseBodyLiveAsrConfigLiveAsrConfigList(TeaModel):
    def __init__(
        self,
        domain_name: int = None,
        app_name: str = None,
        stream_name: str = None,
        period: int = None,
        mns_topic: str = None,
        mns_region: str = None,
        http_callback_url: str = None,
    ):
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.period = period
        self.mns_topic = mns_topic
        self.mns_region = mns_region
        self.http_callback_url = http_callback_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.period is not None:
            result['Period'] = self.period
        if self.mns_topic is not None:
            result['MnsTopic'] = self.mns_topic
        if self.mns_region is not None:
            result['MnsRegion'] = self.mns_region
        if self.http_callback_url is not None:
            result['HttpCallbackURL'] = self.http_callback_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('MnsTopic') is not None:
            self.mns_topic = m.get('MnsTopic')
        if m.get('MnsRegion') is not None:
            self.mns_region = m.get('MnsRegion')
        if m.get('HttpCallbackURL') is not None:
            self.http_callback_url = m.get('HttpCallbackURL')
        return self


class DescribeLiveAsrConfigResponseBodyLiveAsrConfig(TeaModel):
    def __init__(
        self,
        live_asr_config_list: List[DescribeLiveAsrConfigResponseBodyLiveAsrConfigLiveAsrConfigList] = None,
    ):
        self.live_asr_config_list = live_asr_config_list

    def validate(self):
        if self.live_asr_config_list:
            for k in self.live_asr_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveAsrConfigList'] = []
        if self.live_asr_config_list is not None:
            for k in self.live_asr_config_list:
                result['LiveAsrConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_asr_config_list = []
        if m.get('LiveAsrConfigList') is not None:
            for k in m.get('LiveAsrConfigList'):
                temp_model = DescribeLiveAsrConfigResponseBodyLiveAsrConfigLiveAsrConfigList()
                self.live_asr_config_list.append(temp_model.from_map(k))
        return self


class DescribeLiveAsrConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_asr_config: DescribeLiveAsrConfigResponseBodyLiveAsrConfig = None,
    ):
        self.request_id = request_id
        self.live_asr_config = live_asr_config

    def validate(self):
        if self.live_asr_config:
            self.live_asr_config.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_asr_config is not None:
            result['LiveAsrConfig'] = self.live_asr_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveAsrConfig') is not None:
            temp_model = DescribeLiveAsrConfigResponseBodyLiveAsrConfig()
            self.live_asr_config = temp_model.from_map(m['LiveAsrConfig'])
        return self


class DescribeLiveAsrConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveAsrConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveAsrConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAudioAuditConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes(TeaModel):
    def __init__(
        self,
        scene: List[str] = None,
    ):
        self.scene = scene

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        stream_name: str = None,
        scenes: DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes = None,
        domain_name: str = None,
        biz_type: str = None,
    ):
        self.app_name = app_name
        self.stream_name = stream_name
        self.scenes = scenes
        self.domain_name = domain_name
        self.biz_type = biz_type

    def validate(self):
        if self.scenes:
            self.scenes.validate()

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.scenes is not None:
            result['Scenes'] = self.scenes.to_map()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Scenes') is not None:
            temp_model = DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes()
            self.scenes = temp_model.from_map(m['Scenes'])
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList(TeaModel):
    def __init__(
        self,
        live_audio_audit_config: List[DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig] = None,
    ):
        self.live_audio_audit_config = live_audio_audit_config

    def validate(self):
        if self.live_audio_audit_config:
            for k in self.live_audio_audit_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveAudioAuditConfig'] = []
        if self.live_audio_audit_config is not None:
            for k in self.live_audio_audit_config:
                result['LiveAudioAuditConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_audio_audit_config = []
        if m.get('LiveAudioAuditConfig') is not None:
            for k in m.get('LiveAudioAuditConfig'):
                temp_model = DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig()
                self.live_audio_audit_config.append(temp_model.from_map(k))
        return self


class DescribeLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_audio_audit_config_list: DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList = None,
    ):
        self.request_id = request_id
        self.live_audio_audit_config_list = live_audio_audit_config_list

    def validate(self):
        if self.live_audio_audit_config_list:
            self.live_audio_audit_config_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_audio_audit_config_list is not None:
            result['LiveAudioAuditConfigList'] = self.live_audio_audit_config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveAudioAuditConfigList') is not None:
            temp_model = DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList()
            self.live_audio_audit_config_list = temp_model.from_map(m['LiveAudioAuditConfigList'])
        return self


class DescribeLiveAudioAuditConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveAudioAuditConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveAudioAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAudioAuditNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigListLiveAudioAuditNotifyConfig(TeaModel):
    def __init__(
        self,
        callback_template: str = None,
        domain_name: str = None,
        callback: str = None,
    ):
        self.callback_template = callback_template
        self.domain_name = domain_name
        self.callback = callback

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.callback_template is not None:
            result['CallbackTemplate'] = self.callback_template
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.callback is not None:
            result['Callback'] = self.callback
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackTemplate') is not None:
            self.callback_template = m.get('CallbackTemplate')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        return self


class DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigList(TeaModel):
    def __init__(
        self,
        live_audio_audit_notify_config: List[DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigListLiveAudioAuditNotifyConfig] = None,
    ):
        self.live_audio_audit_notify_config = live_audio_audit_notify_config

    def validate(self):
        if self.live_audio_audit_notify_config:
            for k in self.live_audio_audit_notify_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveAudioAuditNotifyConfig'] = []
        if self.live_audio_audit_notify_config is not None:
            for k in self.live_audio_audit_notify_config:
                result['LiveAudioAuditNotifyConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_audio_audit_notify_config = []
        if m.get('LiveAudioAuditNotifyConfig') is not None:
            for k in m.get('LiveAudioAuditNotifyConfig'):
                temp_model = DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigListLiveAudioAuditNotifyConfig()
                self.live_audio_audit_notify_config.append(temp_model.from_map(k))
        return self


class DescribeLiveAudioAuditNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_audio_audit_notify_config_list: DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigList = None,
    ):
        self.request_id = request_id
        self.live_audio_audit_notify_config_list = live_audio_audit_notify_config_list

    def validate(self):
        if self.live_audio_audit_notify_config_list:
            self.live_audio_audit_notify_config_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_audio_audit_notify_config_list is not None:
            result['LiveAudioAuditNotifyConfigList'] = self.live_audio_audit_notify_config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveAudioAuditNotifyConfigList') is not None:
            temp_model = DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigList()
            self.live_audio_audit_notify_config_list = temp_model.from_map(m['LiveAudioAuditNotifyConfigList'])
        return self


class DescribeLiveAudioAuditNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveAudioAuditNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveAudioAuditNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveCertificateDetailRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        security_token: str = None,
        cert_name: str = None,
    ):
        self.owner_id = owner_id
        self.security_token = security_token
        self.cert_name = cert_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        return self


class DescribeLiveCertificateDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cert_id: int = None,
        cert_name: str = None,
        cert: str = None,
    ):
        self.request_id = request_id
        self.cert_id = cert_id
        self.cert_name = cert_name
        self.cert = cert

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert is not None:
            result['Cert'] = self.cert
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Cert') is not None:
            self.cert = m.get('Cert')
        return self


class DescribeLiveCertificateDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveCertificateDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveCertificateDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveCertificateListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        security_token: str = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.security_token = security_token
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveCertificateListResponseBodyCertificateListModelCertListCert(TeaModel):
    def __init__(
        self,
        last_time: int = None,
        fingerprint: str = None,
        cert_name: str = None,
        issuer: str = None,
        cert_id: int = None,
        common: str = None,
    ):
        self.last_time = last_time
        self.fingerprint = fingerprint
        self.cert_name = cert_name
        self.issuer = issuer
        self.cert_id = cert_id
        self.common = common

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.common is not None:
            result['Common'] = self.common
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('Common') is not None:
            self.common = m.get('Common')
        return self


class DescribeLiveCertificateListResponseBodyCertificateListModelCertList(TeaModel):
    def __init__(
        self,
        cert: List[DescribeLiveCertificateListResponseBodyCertificateListModelCertListCert] = None,
    ):
        self.cert = cert

    def validate(self):
        if self.cert:
            for k in self.cert:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Cert'] = []
        if self.cert is not None:
            for k in self.cert:
                result['Cert'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cert = []
        if m.get('Cert') is not None:
            for k in m.get('Cert'):
                temp_model = DescribeLiveCertificateListResponseBodyCertificateListModelCertListCert()
                self.cert.append(temp_model.from_map(k))
        return self


class DescribeLiveCertificateListResponseBodyCertificateListModel(TeaModel):
    def __init__(
        self,
        cert_list: DescribeLiveCertificateListResponseBodyCertificateListModelCertList = None,
        count: int = None,
    ):
        self.cert_list = cert_list
        self.count = count

    def validate(self):
        if self.cert_list:
            self.cert_list.validate()

    def to_map(self):
        result = dict()
        if self.cert_list is not None:
            result['CertList'] = self.cert_list.to_map()
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertList') is not None:
            temp_model = DescribeLiveCertificateListResponseBodyCertificateListModelCertList()
            self.cert_list = temp_model.from_map(m['CertList'])
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeLiveCertificateListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        certificate_list_model: DescribeLiveCertificateListResponseBodyCertificateListModel = None,
    ):
        self.request_id = request_id
        self.certificate_list_model = certificate_list_model

    def validate(self):
        if self.certificate_list_model:
            self.certificate_list_model.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.certificate_list_model is not None:
            result['CertificateListModel'] = self.certificate_list_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CertificateListModel') is not None:
            temp_model = DescribeLiveCertificateListResponseBodyCertificateListModel()
            self.certificate_list_model = temp_model.from_map(m['CertificateListModel'])
        return self


class DescribeLiveCertificateListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveCertificateListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveCertificateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDetectNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveDetectNotifyConfigResponseBodyLiveDetectNotifyConfig(TeaModel):
    def __init__(
        self,
        notify_url: str = None,
        domain_name: str = None,
    ):
        self.notify_url = notify_url
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveDetectNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_detect_notify_config: DescribeLiveDetectNotifyConfigResponseBodyLiveDetectNotifyConfig = None,
    ):
        self.request_id = request_id
        self.live_detect_notify_config = live_detect_notify_config

    def validate(self):
        if self.live_detect_notify_config:
            self.live_detect_notify_config.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_detect_notify_config is not None:
            result['LiveDetectNotifyConfig'] = self.live_detect_notify_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveDetectNotifyConfig') is not None:
            temp_model = DescribeLiveDetectNotifyConfigResponseBodyLiveDetectNotifyConfig()
            self.live_detect_notify_config = temp_model.from_map(m['LiveDetectNotifyConfig'])
        return self


class DescribeLiveDetectNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDetectNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDetectNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDetectPornDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        app: str = None,
        stream: str = None,
        fee: str = None,
        scene: str = None,
        region: str = None,
        split_by: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.app = app
        self.stream = stream
        self.fee = fee
        self.scene = scene
        self.region = region
        self.split_by = split_by

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.app is not None:
            result['App'] = self.app
        if self.stream is not None:
            result['Stream'] = self.stream
        if self.fee is not None:
            result['Fee'] = self.fee
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.region is not None:
            result['Region'] = self.region
        if self.split_by is not None:
            result['SplitBy'] = self.split_by
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        if m.get('Fee') is not None:
            self.fee = m.get('Fee')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SplitBy') is not None:
            self.split_by = m.get('SplitBy')
        return self


class DescribeLiveDetectPornDataResponseBodyDetectPornDataDataModule(TeaModel):
    def __init__(
        self,
        time_stamp: str = None,
        app: str = None,
        domain: str = None,
        stream: str = None,
        fee: str = None,
        scene: str = None,
        region: str = None,
        count: int = None,
    ):
        self.time_stamp = time_stamp
        self.app = app
        self.domain = domain
        self.stream = stream
        self.fee = fee
        self.scene = scene
        self.region = region
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.stream is not None:
            result['Stream'] = self.stream
        if self.fee is not None:
            result['Fee'] = self.fee
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.region is not None:
            result['Region'] = self.region
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        if m.get('Fee') is not None:
            self.fee = m.get('Fee')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeLiveDetectPornDataResponseBodyDetectPornData(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeLiveDetectPornDataResponseBodyDetectPornDataDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDetectPornDataResponseBodyDetectPornDataDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDetectPornDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        detect_porn_data: DescribeLiveDetectPornDataResponseBodyDetectPornData = None,
    ):
        self.request_id = request_id
        self.detect_porn_data = detect_porn_data

    def validate(self):
        if self.detect_porn_data:
            self.detect_porn_data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.detect_porn_data is not None:
            result['DetectPornData'] = self.detect_porn_data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DetectPornData') is not None:
            temp_model = DescribeLiveDetectPornDataResponseBodyDetectPornData()
            self.detect_porn_data = temp_model.from_map(m['DetectPornData'])
        return self


class DescribeLiveDetectPornDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDetectPornDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDetectPornDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainBpsDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        interval: str = None,
        isp_name_en: str = None,
        location_name_en: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.interval = interval
        self.isp_name_en = isp_name_en
        self.location_name_en = location_name_en

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        return self


class DescribeLiveDomainBpsDataResponseBodyBpsDataPerIntervalDataModule(TeaModel):
    def __init__(
        self,
        https_bps_value: str = None,
        bps_value: str = None,
        time_stamp: str = None,
        http_bps_value: str = None,
    ):
        self.https_bps_value = https_bps_value
        self.bps_value = bps_value
        self.time_stamp = time_stamp
        self.http_bps_value = http_bps_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.https_bps_value is not None:
            result['HttpsBpsValue'] = self.https_bps_value
        if self.bps_value is not None:
            result['BpsValue'] = self.bps_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.http_bps_value is not None:
            result['HttpBpsValue'] = self.http_bps_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpsBpsValue') is not None:
            self.https_bps_value = m.get('HttpsBpsValue')
        if m.get('BpsValue') is not None:
            self.bps_value = m.get('BpsValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('HttpBpsValue') is not None:
            self.http_bps_value = m.get('HttpBpsValue')
        return self


class DescribeLiveDomainBpsDataResponseBodyBpsDataPerInterval(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeLiveDomainBpsDataResponseBodyBpsDataPerIntervalDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainBpsDataResponseBodyBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainBpsDataResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        request_id: str = None,
        domain_name: str = None,
        start_time: str = None,
        data_interval: str = None,
        bps_data_per_interval: DescribeLiveDomainBpsDataResponseBodyBpsDataPerInterval = None,
    ):
        self.end_time = end_time
        self.request_id = request_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.data_interval = data_interval
        self.bps_data_per_interval = bps_data_per_interval

    def validate(self):
        if self.bps_data_per_interval:
            self.bps_data_per_interval.validate()

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.bps_data_per_interval is not None:
            result['BpsDataPerInterval'] = self.bps_data_per_interval.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('BpsDataPerInterval') is not None:
            temp_model = DescribeLiveDomainBpsDataResponseBodyBpsDataPerInterval()
            self.bps_data_per_interval = temp_model.from_map(m['BpsDataPerInterval'])
        return self


class DescribeLiveDomainBpsDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainBpsDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainBpsDataByTimeStampRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        time_point: str = None,
        isp_names: str = None,
        location_names: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.time_point = time_point
        self.isp_names = isp_names
        self.location_names = location_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        if self.isp_names is not None:
            result['IspNames'] = self.isp_names
        if self.location_names is not None:
            result['LocationNames'] = self.location_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        if m.get('IspNames') is not None:
            self.isp_names = m.get('IspNames')
        if m.get('LocationNames') is not None:
            self.location_names = m.get('LocationNames')
        return self


class DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataListBpsDataModel(TeaModel):
    def __init__(
        self,
        time_stamp: str = None,
        location_name: str = None,
        isp_name: str = None,
        bps: int = None,
    ):
        self.time_stamp = time_stamp
        self.location_name = location_name
        self.isp_name = isp_name
        self.bps = bps

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.location_name is not None:
            result['LocationName'] = self.location_name
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        if self.bps is not None:
            result['Bps'] = self.bps
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('LocationName') is not None:
            self.location_name = m.get('LocationName')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        return self


class DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataList(TeaModel):
    def __init__(
        self,
        bps_data_model: List[DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataListBpsDataModel] = None,
    ):
        self.bps_data_model = bps_data_model

    def validate(self):
        if self.bps_data_model:
            for k in self.bps_data_model:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['BpsDataModel'] = []
        if self.bps_data_model is not None:
            for k in self.bps_data_model:
                result['BpsDataModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bps_data_model = []
        if m.get('BpsDataModel') is not None:
            for k in m.get('BpsDataModel'):
                temp_model = DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataListBpsDataModel()
                self.bps_data_model.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainBpsDataByTimeStampResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        domain_name: str = None,
        time_stamp: str = None,
        bps_data_list: DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataList = None,
    ):
        self.request_id = request_id
        self.domain_name = domain_name
        self.time_stamp = time_stamp
        self.bps_data_list = bps_data_list

    def validate(self):
        if self.bps_data_list:
            self.bps_data_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.bps_data_list is not None:
            result['BpsDataList'] = self.bps_data_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('BpsDataList') is not None:
            temp_model = DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataList()
            self.bps_data_list = temp_model.from_map(m['BpsDataList'])
        return self


class DescribeLiveDomainBpsDataByTimeStampResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainBpsDataByTimeStampResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainBpsDataByTimeStampResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainCertificateInfoRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveDomainCertificateInfoResponseBodyCertInfosCertInfo(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        cert_name: str = None,
        cert_domain_name: str = None,
        cert_expire_time: str = None,
        cert_life: str = None,
        cert_org: str = None,
        cert_type: str = None,
        sslprotocol: str = None,
        status: str = None,
        sslpub: str = None,
    ):
        self.domain_name = domain_name
        self.cert_name = cert_name
        self.cert_domain_name = cert_domain_name
        self.cert_expire_time = cert_expire_time
        self.cert_life = cert_life
        self.cert_org = cert_org
        self.cert_type = cert_type
        self.sslprotocol = sslprotocol
        self.status = status
        self.sslpub = sslpub

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert_domain_name is not None:
            result['CertDomainName'] = self.cert_domain_name
        if self.cert_expire_time is not None:
            result['CertExpireTime'] = self.cert_expire_time
        if self.cert_life is not None:
            result['CertLife'] = self.cert_life
        if self.cert_org is not None:
            result['CertOrg'] = self.cert_org
        if self.cert_type is not None:
            result['CertType'] = self.cert_type
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.status is not None:
            result['Status'] = self.status
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CertDomainName') is not None:
            self.cert_domain_name = m.get('CertDomainName')
        if m.get('CertExpireTime') is not None:
            self.cert_expire_time = m.get('CertExpireTime')
        if m.get('CertLife') is not None:
            self.cert_life = m.get('CertLife')
        if m.get('CertOrg') is not None:
            self.cert_org = m.get('CertOrg')
        if m.get('CertType') is not None:
            self.cert_type = m.get('CertType')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        return self


class DescribeLiveDomainCertificateInfoResponseBodyCertInfos(TeaModel):
    def __init__(
        self,
        cert_info: List[DescribeLiveDomainCertificateInfoResponseBodyCertInfosCertInfo] = None,
    ):
        self.cert_info = cert_info

    def validate(self):
        if self.cert_info:
            for k in self.cert_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CertInfo'] = []
        if self.cert_info is not None:
            for k in self.cert_info:
                result['CertInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cert_info = []
        if m.get('CertInfo') is not None:
            for k in m.get('CertInfo'):
                temp_model = DescribeLiveDomainCertificateInfoResponseBodyCertInfosCertInfo()
                self.cert_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainCertificateInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cert_infos: DescribeLiveDomainCertificateInfoResponseBodyCertInfos = None,
    ):
        self.request_id = request_id
        self.cert_infos = cert_infos

    def validate(self):
        if self.cert_infos:
            self.cert_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cert_infos is not None:
            result['CertInfos'] = self.cert_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CertInfos') is not None:
            temp_model = DescribeLiveDomainCertificateInfoResponseBodyCertInfos()
            self.cert_infos = temp_model.from_map(m['CertInfos'])
        return self


class DescribeLiveDomainCertificateInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainCertificateInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainCertificateInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainConfigsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        security_token: str = None,
        domain_name: str = None,
        function_names: str = None,
    ):
        self.owner_id = owner_id
        self.security_token = security_token
        self.domain_name = domain_name
        self.function_names = function_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        return self


class DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg(TeaModel):
    def __init__(
        self,
        arg_name: str = None,
        arg_value: str = None,
    ):
        self.arg_name = arg_name
        self.arg_value = arg_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.arg_name is not None:
            result['ArgName'] = self.arg_name
        if self.arg_value is not None:
            result['ArgValue'] = self.arg_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArgName') is not None:
            self.arg_name = m.get('ArgName')
        if m.get('ArgValue') is not None:
            self.arg_value = m.get('ArgValue')
        return self


class DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs(TeaModel):
    def __init__(
        self,
        function_arg: List[DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg] = None,
    ):
        self.function_arg = function_arg

    def validate(self):
        if self.function_arg:
            for k in self.function_arg:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FunctionArg'] = []
        if self.function_arg is not None:
            for k in self.function_arg:
                result['FunctionArg'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.function_arg = []
        if m.get('FunctionArg') is not None:
            for k in m.get('FunctionArg'):
                temp_model = DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg()
                self.function_arg.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfig(TeaModel):
    def __init__(
        self,
        status: str = None,
        config_id: str = None,
        function_name: str = None,
        function_args: DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs = None,
    ):
        self.status = status
        self.config_id = config_id
        self.function_name = function_name
        self.function_args = function_args

    def validate(self):
        if self.function_args:
            self.function_args.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.function_args is not None:
            result['FunctionArgs'] = self.function_args.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('FunctionArgs') is not None:
            temp_model = DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs()
            self.function_args = temp_model.from_map(m['FunctionArgs'])
        return self


class DescribeLiveDomainConfigsResponseBodyDomainConfigs(TeaModel):
    def __init__(
        self,
        domain_config: List[DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfig] = None,
    ):
        self.domain_config = domain_config

    def validate(self):
        if self.domain_config:
            for k in self.domain_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DomainConfig'] = []
        if self.domain_config is not None:
            for k in self.domain_config:
                result['DomainConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_config = []
        if m.get('DomainConfig') is not None:
            for k in m.get('DomainConfig'):
                temp_model = DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfig()
                self.domain_config.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        domain_configs: DescribeLiveDomainConfigsResponseBodyDomainConfigs = None,
    ):
        self.request_id = request_id
        self.domain_configs = domain_configs

    def validate(self):
        if self.domain_configs:
            self.domain_configs.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_configs is not None:
            result['DomainConfigs'] = self.domain_configs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainConfigs') is not None:
            temp_model = DescribeLiveDomainConfigsResponseBodyDomainConfigs()
            self.domain_configs = temp_model.from_map(m['DomainConfigs'])
        return self


class DescribeLiveDomainConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainDetailRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        security_token: str = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.security_token = security_token
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveDomainDetailResponseBodyDomainDetail(TeaModel):
    def __init__(
        self,
        sslpub: str = None,
        gmt_modified: str = None,
        domain_name: str = None,
        gmt_created: str = None,
        live_domain_type: str = None,
        description: str = None,
        sslprotocol: str = None,
        region: str = None,
        cert_name: str = None,
        scope: str = None,
        cname: str = None,
        domain_status: str = None,
    ):
        self.sslpub = sslpub
        self.gmt_modified = gmt_modified
        self.domain_name = domain_name
        self.gmt_created = gmt_created
        self.live_domain_type = live_domain_type
        self.description = description
        self.sslprotocol = sslprotocol
        self.region = region
        self.cert_name = cert_name
        self.scope = scope
        self.cname = cname
        self.domain_status = domain_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.live_domain_type is not None:
            result['LiveDomainType'] = self.live_domain_type
        if self.description is not None:
            result['Description'] = self.description
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.region is not None:
            result['Region'] = self.region
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('LiveDomainType') is not None:
            self.live_domain_type = m.get('LiveDomainType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        return self


class DescribeLiveDomainDetailResponseBody(TeaModel):
    def __init__(
        self,
        domain_detail: DescribeLiveDomainDetailResponseBodyDomainDetail = None,
        request_id: str = None,
    ):
        self.domain_detail = domain_detail
        self.request_id = request_id

    def validate(self):
        if self.domain_detail:
            self.domain_detail.validate()

    def to_map(self):
        result = dict()
        if self.domain_detail is not None:
            result['DomainDetail'] = self.domain_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainDetail') is not None:
            temp_model = DescribeLiveDomainDetailResponseBodyDomainDetail()
            self.domain_detail = temp_model.from_map(m['DomainDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainFrameRateAndBitRateDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        query_time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.query_time = query_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.query_time is not None:
            result['QueryTime'] = self.query_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('QueryTime') is not None:
            self.query_time = m.get('QueryTime')
        return self


class DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo(TeaModel):
    def __init__(
        self,
        audio_frame_rate: float = None,
        video_frame_rate: float = None,
        stream_url: str = None,
        bit_rate: float = None,
    ):
        self.audio_frame_rate = audio_frame_rate
        self.video_frame_rate = video_frame_rate
        self.stream_url = stream_url
        self.bit_rate = bit_rate

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.audio_frame_rate is not None:
            result['AudioFrameRate'] = self.audio_frame_rate
        if self.video_frame_rate is not None:
            result['VideoFrameRate'] = self.video_frame_rate
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioFrameRate') is not None:
            self.audio_frame_rate = m.get('AudioFrameRate')
        if m.get('VideoFrameRate') is not None:
            self.video_frame_rate = m.get('VideoFrameRate')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        return self


class DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos(TeaModel):
    def __init__(
        self,
        frame_rate_and_bit_rate_info: List[DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo] = None,
    ):
        self.frame_rate_and_bit_rate_info = frame_rate_and_bit_rate_info

    def validate(self):
        if self.frame_rate_and_bit_rate_info:
            for k in self.frame_rate_and_bit_rate_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FrameRateAndBitRateInfo'] = []
        if self.frame_rate_and_bit_rate_info is not None:
            for k in self.frame_rate_and_bit_rate_info:
                result['FrameRateAndBitRateInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.frame_rate_and_bit_rate_info = []
        if m.get('FrameRateAndBitRateInfo') is not None:
            for k in m.get('FrameRateAndBitRateInfo'):
                temp_model = DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo()
                self.frame_rate_and_bit_rate_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainFrameRateAndBitRateDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        frame_rate_and_bit_rate_infos: DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos = None,
    ):
        self.request_id = request_id
        self.frame_rate_and_bit_rate_infos = frame_rate_and_bit_rate_infos

    def validate(self):
        if self.frame_rate_and_bit_rate_infos:
            self.frame_rate_and_bit_rate_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.frame_rate_and_bit_rate_infos is not None:
            result['FrameRateAndBitRateInfos'] = self.frame_rate_and_bit_rate_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FrameRateAndBitRateInfos') is not None:
            temp_model = DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos()
            self.frame_rate_and_bit_rate_infos = temp_model.from_map(m['FrameRateAndBitRateInfos'])
        return self


class DescribeLiveDomainFrameRateAndBitRateDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainFrameRateAndBitRateDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainFrameRateAndBitRateDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainLimitRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        liveapi_request_from: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.liveapi_request_from = liveapi_request_from

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.liveapi_request_from is not None:
            result['LiveapiRequestFrom'] = self.liveapi_request_from
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveapiRequestFrom') is not None:
            self.liveapi_request_from = m.get('LiveapiRequestFrom')
        return self


class DescribeLiveDomainLimitResponseBodyLiveDomainLimitListLiveDomainLimit(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        limit_num: int = None,
        limit_transcode_num: int = None,
    ):
        self.domain_name = domain_name
        self.limit_num = limit_num
        self.limit_transcode_num = limit_transcode_num

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.limit_num is not None:
            result['LimitNum'] = self.limit_num
        if self.limit_transcode_num is not None:
            result['LimitTranscodeNum'] = self.limit_transcode_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LimitNum') is not None:
            self.limit_num = m.get('LimitNum')
        if m.get('LimitTranscodeNum') is not None:
            self.limit_transcode_num = m.get('LimitTranscodeNum')
        return self


class DescribeLiveDomainLimitResponseBodyLiveDomainLimitList(TeaModel):
    def __init__(
        self,
        live_domain_limit: List[DescribeLiveDomainLimitResponseBodyLiveDomainLimitListLiveDomainLimit] = None,
    ):
        self.live_domain_limit = live_domain_limit

    def validate(self):
        if self.live_domain_limit:
            for k in self.live_domain_limit:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveDomainLimit'] = []
        if self.live_domain_limit is not None:
            for k in self.live_domain_limit:
                result['LiveDomainLimit'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_domain_limit = []
        if m.get('LiveDomainLimit') is not None:
            for k in m.get('LiveDomainLimit'):
                temp_model = DescribeLiveDomainLimitResponseBodyLiveDomainLimitListLiveDomainLimit()
                self.live_domain_limit.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainLimitResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_domain_limit_list: DescribeLiveDomainLimitResponseBodyLiveDomainLimitList = None,
    ):
        self.request_id = request_id
        self.live_domain_limit_list = live_domain_limit_list

    def validate(self):
        if self.live_domain_limit_list:
            self.live_domain_limit_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_domain_limit_list is not None:
            result['LiveDomainLimitList'] = self.live_domain_limit_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveDomainLimitList') is not None:
            temp_model = DescribeLiveDomainLimitResponseBodyLiveDomainLimitList()
            self.live_domain_limit_list = temp_model.from_map(m['LiveDomainLimitList'])
        return self


class DescribeLiveDomainLimitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainLimitResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainLimitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainMappingRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveDomainMappingResponseBodyLiveDomainModelsLiveDomainModel(TeaModel):
    def __init__(
        self,
        type: str = None,
        domain_name: str = None,
    ):
        self.type = type
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveDomainMappingResponseBodyLiveDomainModels(TeaModel):
    def __init__(
        self,
        live_domain_model: List[DescribeLiveDomainMappingResponseBodyLiveDomainModelsLiveDomainModel] = None,
    ):
        self.live_domain_model = live_domain_model

    def validate(self):
        if self.live_domain_model:
            for k in self.live_domain_model:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveDomainModel'] = []
        if self.live_domain_model is not None:
            for k in self.live_domain_model:
                result['LiveDomainModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_domain_model = []
        if m.get('LiveDomainModel') is not None:
            for k in m.get('LiveDomainModel'):
                temp_model = DescribeLiveDomainMappingResponseBodyLiveDomainModelsLiveDomainModel()
                self.live_domain_model.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_domain_models: DescribeLiveDomainMappingResponseBodyLiveDomainModels = None,
    ):
        self.request_id = request_id
        self.live_domain_models = live_domain_models

    def validate(self):
        if self.live_domain_models:
            self.live_domain_models.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_domain_models is not None:
            result['LiveDomainModels'] = self.live_domain_models.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveDomainModels') is not None:
            temp_model = DescribeLiveDomainMappingResponseBodyLiveDomainModels()
            self.live_domain_models = temp_model.from_map(m['LiveDomainModels'])
        return self


class DescribeLiveDomainMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainMappingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainOnlineUserNumRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        query_time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.query_time = query_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.query_time is not None:
            result['QueryTime'] = self.query_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('QueryTime') is not None:
            self.query_time = m.get('QueryTime')
        return self


class DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfosInfo(TeaModel):
    def __init__(
        self,
        transcode_template: str = None,
        user_number: int = None,
    ):
        self.transcode_template = transcode_template
        self.user_number = user_number

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.transcode_template is not None:
            result['TranscodeTemplate'] = self.transcode_template
        if self.user_number is not None:
            result['UserNumber'] = self.user_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TranscodeTemplate') is not None:
            self.transcode_template = m.get('TranscodeTemplate')
        if m.get('UserNumber') is not None:
            self.user_number = m.get('UserNumber')
        return self


class DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfos(TeaModel):
    def __init__(
        self,
        info: List[DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfosInfo] = None,
    ):
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Info'] = []
        if self.info is not None:
            for k in self.info:
                result['Info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.info = []
        if m.get('Info') is not None:
            for k in m.get('Info'):
                temp_model = DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfosInfo()
                self.info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo(TeaModel):
    def __init__(
        self,
        stream_name: str = None,
        infos: DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfos = None,
    ):
        self.stream_name = stream_name
        self.infos = infos

    def validate(self):
        if self.infos:
            self.infos.validate()

    def to_map(self):
        result = dict()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.infos is not None:
            result['Infos'] = self.infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Infos') is not None:
            temp_model = DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfos()
            self.infos = temp_model.from_map(m['Infos'])
        return self


class DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfo(TeaModel):
    def __init__(
        self,
        live_stream_online_user_num_info: List[DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo] = None,
    ):
        self.live_stream_online_user_num_info = live_stream_online_user_num_info

    def validate(self):
        if self.live_stream_online_user_num_info:
            for k in self.live_stream_online_user_num_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamOnlineUserNumInfo'] = []
        if self.live_stream_online_user_num_info is not None:
            for k in self.live_stream_online_user_num_info:
                result['LiveStreamOnlineUserNumInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_online_user_num_info = []
        if m.get('LiveStreamOnlineUserNumInfo') is not None:
            for k in m.get('LiveStreamOnlineUserNumInfo'):
                temp_model = DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo()
                self.live_stream_online_user_num_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainOnlineUserNumResponseBody(TeaModel):
    def __init__(
        self,
        stream_count: int = None,
        online_user_info: DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfo = None,
        request_id: str = None,
        user_count: int = None,
    ):
        self.stream_count = stream_count
        self.online_user_info = online_user_info
        self.request_id = request_id
        self.user_count = user_count

    def validate(self):
        if self.online_user_info:
            self.online_user_info.validate()

    def to_map(self):
        result = dict()
        if self.stream_count is not None:
            result['StreamCount'] = self.stream_count
        if self.online_user_info is not None:
            result['OnlineUserInfo'] = self.online_user_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StreamCount') is not None:
            self.stream_count = m.get('StreamCount')
        if m.get('OnlineUserInfo') is not None:
            temp_model = DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfo()
            self.online_user_info = temp_model.from_map(m['OnlineUserInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class DescribeLiveDomainOnlineUserNumResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainOnlineUserNumResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainOnlineUserNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainPushBpsDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        interval: str = None,
        isp_name_en: str = None,
        location_name_en: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.interval = interval
        self.isp_name_en = isp_name_en
        self.location_name_en = location_name_en

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        return self


class DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerIntervalDataModule(TeaModel):
    def __init__(
        self,
        time_stamp: str = None,
        bps_value: str = None,
    ):
        self.time_stamp = time_stamp
        self.bps_value = bps_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.bps_value is not None:
            result['BpsValue'] = self.bps_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('BpsValue') is not None:
            self.bps_value = m.get('BpsValue')
        return self


class DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerInterval(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerIntervalDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainPushBpsDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        data_interval: str = None,
        bps_data_per_interval: DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerInterval = None,
    ):
        self.request_id = request_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.data_interval = data_interval
        self.bps_data_per_interval = bps_data_per_interval

    def validate(self):
        if self.bps_data_per_interval:
            self.bps_data_per_interval.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.bps_data_per_interval is not None:
            result['BpsDataPerInterval'] = self.bps_data_per_interval.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('BpsDataPerInterval') is not None:
            temp_model = DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerInterval()
            self.bps_data_per_interval = temp_model.from_map(m['BpsDataPerInterval'])
        return self


class DescribeLiveDomainPushBpsDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainPushBpsDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainPushBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainPushTrafficDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        interval: str = None,
        isp_name_en: str = None,
        location_name_en: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.interval = interval
        self.isp_name_en = isp_name_en
        self.location_name_en = location_name_en

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        return self


class DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(
        self,
        time_stamp: str = None,
        traffic_value: str = None,
    ):
        self.time_stamp = time_stamp
        self.traffic_value = traffic_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.traffic_value is not None:
            result['TrafficValue'] = self.traffic_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TrafficValue') is not None:
            self.traffic_value = m.get('TrafficValue')
        return self


class DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerInterval(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerIntervalDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainPushTrafficDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        data_interval: str = None,
        traffic_data_per_interval: DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerInterval = None,
    ):
        self.request_id = request_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.data_interval = data_interval
        self.traffic_data_per_interval = traffic_data_per_interval

    def validate(self):
        if self.traffic_data_per_interval:
            self.traffic_data_per_interval.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.traffic_data_per_interval is not None:
            result['TrafficDataPerInterval'] = self.traffic_data_per_interval.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('TrafficDataPerInterval') is not None:
            temp_model = DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerInterval()
            self.traffic_data_per_interval = temp_model.from_map(m['TrafficDataPerInterval'])
        return self


class DescribeLiveDomainPushTrafficDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainPushTrafficDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainPushTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainPvUvDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfosPvUvDataInfo(TeaModel):
    def __init__(
        self,
        pv: str = None,
        uv: str = None,
        time_stamp: str = None,
    ):
        self.pv = pv
        self.uv = uv
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.pv is not None:
            result['PV'] = self.pv
        if self.uv is not None:
            result['UV'] = self.uv
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PV') is not None:
            self.pv = m.get('PV')
        if m.get('UV') is not None:
            self.uv = m.get('UV')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfos(TeaModel):
    def __init__(
        self,
        pv_uv_data_info: List[DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfosPvUvDataInfo] = None,
    ):
        self.pv_uv_data_info = pv_uv_data_info

    def validate(self):
        if self.pv_uv_data_info:
            for k in self.pv_uv_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PvUvDataInfo'] = []
        if self.pv_uv_data_info is not None:
            for k in self.pv_uv_data_info:
                result['PvUvDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pv_uv_data_info = []
        if m.get('PvUvDataInfo') is not None:
            for k in m.get('PvUvDataInfo'):
                temp_model = DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfosPvUvDataInfo()
                self.pv_uv_data_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainPvUvDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        data_interval: str = None,
        pv_uv_data_infos: DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfos = None,
    ):
        self.request_id = request_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.data_interval = data_interval
        self.pv_uv_data_infos = pv_uv_data_infos

    def validate(self):
        if self.pv_uv_data_infos:
            self.pv_uv_data_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.pv_uv_data_infos is not None:
            result['PvUvDataInfos'] = self.pv_uv_data_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('PvUvDataInfos') is not None:
            temp_model = DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfos()
            self.pv_uv_data_infos = temp_model.from_map(m['PvUvDataInfos'])
        return self


class DescribeLiveDomainPvUvDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainPvUvDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainPvUvDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRealTimeBpsDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        isp_name_en: str = None,
        location_name_en: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.isp_name_en = isp_name_en
        self.location_name_en = location_name_en
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerIntervalDataModule(TeaModel):
    def __init__(
        self,
        value: str = None,
        time_stamp: str = None,
    ):
        self.value = value
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerInterval(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerIntervalDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRealTimeBpsDataResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        request_id: str = None,
        domain_name: str = None,
        start_time: str = None,
        data_interval: str = None,
        real_time_bps_data_per_interval: DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerInterval = None,
    ):
        self.end_time = end_time
        self.request_id = request_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.data_interval = data_interval
        self.real_time_bps_data_per_interval = real_time_bps_data_per_interval

    def validate(self):
        if self.real_time_bps_data_per_interval:
            self.real_time_bps_data_per_interval.validate()

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.real_time_bps_data_per_interval is not None:
            result['RealTimeBpsDataPerInterval'] = self.real_time_bps_data_per_interval.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('RealTimeBpsDataPerInterval') is not None:
            temp_model = DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerInterval()
            self.real_time_bps_data_per_interval = temp_model.from_map(m['RealTimeBpsDataPerInterval'])
        return self


class DescribeLiveDomainRealTimeBpsDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainRealTimeBpsDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRealTimeBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRealTimeHttpCodeDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        isp_name_en: str = None,
        location_name_en: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.isp_name_en = isp_name_en
        self.location_name_en = location_name_en

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData(TeaModel):
    def __init__(
        self,
        code: str = None,
        proportion: str = None,
        count: str = None,
    ):
        self.code = code
        self.proportion = proportion
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.proportion is not None:
            result['Proportion'] = self.proportion
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Proportion') is not None:
            self.proportion = m.get('Proportion')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue(TeaModel):
    def __init__(
        self,
        real_time_code_proportion_data: List[DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData] = None,
    ):
        self.real_time_code_proportion_data = real_time_code_proportion_data

    def validate(self):
        if self.real_time_code_proportion_data:
            for k in self.real_time_code_proportion_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RealTimeCodeProportionData'] = []
        if self.real_time_code_proportion_data is not None:
            for k in self.real_time_code_proportion_data:
                result['RealTimeCodeProportionData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.real_time_code_proportion_data = []
        if m.get('RealTimeCodeProportionData') is not None:
            for k in m.get('RealTimeCodeProportionData'):
                temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData()
                self.real_time_code_proportion_data.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData(TeaModel):
    def __init__(
        self,
        value: DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue = None,
        time_stamp: str = None,
    ):
        self.value = value
        self.time_stamp = time_stamp

    def validate(self):
        if self.value:
            self.value.validate()

    def to_map(self):
        result = dict()
        if self.value is not None:
            result['Value'] = self.value.to_map()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue()
            self.value = temp_model.from_map(m['Value'])
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData(TeaModel):
    def __init__(
        self,
        usage_data: List[DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData] = None,
    ):
        self.usage_data = usage_data

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData()
                self.usage_data.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        request_id: str = None,
        domain_name: str = None,
        start_time: str = None,
        data_interval: str = None,
        real_time_http_code_data: DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData = None,
    ):
        self.end_time = end_time
        self.request_id = request_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.data_interval = data_interval
        self.real_time_http_code_data = real_time_http_code_data

    def validate(self):
        if self.real_time_http_code_data:
            self.real_time_http_code_data.validate()

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.real_time_http_code_data is not None:
            result['RealTimeHttpCodeData'] = self.real_time_http_code_data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('RealTimeHttpCodeData') is not None:
            temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData()
            self.real_time_http_code_data = temp_model.from_map(m['RealTimeHttpCodeData'])
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainRealTimeHttpCodeDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRealtimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveDomainRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        project: str = None,
        region: str = None,
        logstore: str = None,
        status: str = None,
    ):
        self.request_id = request_id
        self.project = project
        self.region = region
        self.logstore = logstore
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeLiveDomainRealtimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainRealtimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRealTimeTrafficDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        isp_name_en: str = None,
        location_name_en: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.isp_name_en = isp_name_en
        self.location_name_en = location_name_en
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(
        self,
        value: str = None,
        time_stamp: str = None,
    ):
        self.value = value
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRealTimeTrafficDataResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        request_id: str = None,
        domain_name: str = None,
        real_time_traffic_data_per_interval: DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval = None,
        start_time: str = None,
        data_interval: str = None,
    ):
        self.end_time = end_time
        self.request_id = request_id
        self.domain_name = domain_name
        self.real_time_traffic_data_per_interval = real_time_traffic_data_per_interval
        self.start_time = start_time
        self.data_interval = data_interval

    def validate(self):
        if self.real_time_traffic_data_per_interval:
            self.real_time_traffic_data_per_interval.validate()

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.real_time_traffic_data_per_interval is not None:
            result['RealTimeTrafficDataPerInterval'] = self.real_time_traffic_data_per_interval.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RealTimeTrafficDataPerInterval') is not None:
            temp_model = DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval()
            self.real_time_traffic_data_per_interval = temp_model.from_map(m['RealTimeTrafficDataPerInterval'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        return self


class DescribeLiveDomainRealTimeTrafficDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainRealTimeTrafficDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRealTimeTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRecordDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        record_type: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.record_type = record_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        return self


class DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfoDetail(TeaModel):
    def __init__(
        self,
        flv: int = None,
        ts: int = None,
        mp4: int = None,
    ):
        self.flv = flv
        self.ts = ts
        self.mp4 = mp4

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.flv is not None:
            result['FLV'] = self.flv
        if self.ts is not None:
            result['TS'] = self.ts
        if self.mp4 is not None:
            result['MP4'] = self.mp4
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FLV') is not None:
            self.flv = m.get('FLV')
        if m.get('TS') is not None:
            self.ts = m.get('TS')
        if m.get('MP4') is not None:
            self.mp4 = m.get('MP4')
        return self


class DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfo(TeaModel):
    def __init__(
        self,
        date: str = None,
        total: int = None,
        detail: DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfoDetail = None,
    ):
        self.date = date
        self.total = total
        self.detail = detail

    def validate(self):
        if self.detail:
            self.detail.validate()

    def to_map(self):
        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.total is not None:
            result['Total'] = self.total
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Detail') is not None:
            temp_model = DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfoDetail()
            self.detail = temp_model.from_map(m['Detail'])
        return self


class DescribeLiveDomainRecordDataResponseBodyRecordDataInfos(TeaModel):
    def __init__(
        self,
        record_data_info: List[DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfo] = None,
    ):
        self.record_data_info = record_data_info

    def validate(self):
        if self.record_data_info:
            for k in self.record_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RecordDataInfo'] = []
        if self.record_data_info is not None:
            for k in self.record_data_info:
                result['RecordDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_data_info = []
        if m.get('RecordDataInfo') is not None:
            for k in m.get('RecordDataInfo'):
                temp_model = DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfo()
                self.record_data_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRecordDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        record_data_infos: DescribeLiveDomainRecordDataResponseBodyRecordDataInfos = None,
    ):
        self.request_id = request_id
        self.record_data_infos = record_data_infos

    def validate(self):
        if self.record_data_infos:
            self.record_data_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.record_data_infos is not None:
            result['RecordDataInfos'] = self.record_data_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RecordDataInfos') is not None:
            temp_model = DescribeLiveDomainRecordDataResponseBodyRecordDataInfos()
            self.record_data_infos = temp_model.from_map(m['RecordDataInfos'])
        return self


class DescribeLiveDomainRecordDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainRecordDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRecordDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainSnapshotDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfosSnapshotDataInfo(TeaModel):
    def __init__(
        self,
        date: str = None,
        total: int = None,
    ):
        self.date = date
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfos(TeaModel):
    def __init__(
        self,
        snapshot_data_info: List[DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfosSnapshotDataInfo] = None,
    ):
        self.snapshot_data_info = snapshot_data_info

    def validate(self):
        if self.snapshot_data_info:
            for k in self.snapshot_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SnapshotDataInfo'] = []
        if self.snapshot_data_info is not None:
            for k in self.snapshot_data_info:
                result['SnapshotDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.snapshot_data_info = []
        if m.get('SnapshotDataInfo') is not None:
            for k in m.get('SnapshotDataInfo'):
                temp_model = DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfosSnapshotDataInfo()
                self.snapshot_data_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainSnapshotDataResponseBody(TeaModel):
    def __init__(
        self,
        snapshot_data_infos: DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfos = None,
        request_id: str = None,
    ):
        self.snapshot_data_infos = snapshot_data_infos
        self.request_id = request_id

    def validate(self):
        if self.snapshot_data_infos:
            self.snapshot_data_infos.validate()

    def to_map(self):
        result = dict()
        if self.snapshot_data_infos is not None:
            result['SnapshotDataInfos'] = self.snapshot_data_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnapshotDataInfos') is not None:
            temp_model = DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfos()
            self.snapshot_data_infos = temp_model.from_map(m['SnapshotDataInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainSnapshotDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainSnapshotDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainSnapshotDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainTimeShiftDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        interval: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.interval = interval

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftDataDataModule(TeaModel):
    def __init__(
        self,
        time_stamp: str = None,
        size: str = None,
        type: str = None,
    ):
        self.time_stamp = time_stamp
        self.size = size
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.size is not None:
            result['Size'] = self.size
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftData(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftDataDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftDataDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainTimeShiftDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        time_shift_data: DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftData = None,
    ):
        self.request_id = request_id
        self.time_shift_data = time_shift_data

    def validate(self):
        if self.time_shift_data:
            self.time_shift_data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_shift_data is not None:
            result['TimeShiftData'] = self.time_shift_data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeShiftData') is not None:
            temp_model = DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftData()
            self.time_shift_data = temp_model.from_map(m['TimeShiftData'])
        return self


class DescribeLiveDomainTimeShiftDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainTimeShiftDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainTimeShiftDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainTrafficDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
        interval: str = None,
        isp_name_en: str = None,
        location_name_en: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time
        self.interval = interval
        self.isp_name_en = isp_name_en
        self.location_name_en = location_name_en

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        return self


class DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(
        self,
        traffic_value: str = None,
        http_traffic_value: str = None,
        https_traffic_value: str = None,
        time_stamp: str = None,
    ):
        self.traffic_value = traffic_value
        self.http_traffic_value = http_traffic_value
        self.https_traffic_value = https_traffic_value
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.traffic_value is not None:
            result['TrafficValue'] = self.traffic_value
        if self.http_traffic_value is not None:
            result['HttpTrafficValue'] = self.http_traffic_value
        if self.https_traffic_value is not None:
            result['HttpsTrafficValue'] = self.https_traffic_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TrafficValue') is not None:
            self.traffic_value = m.get('TrafficValue')
        if m.get('HttpTrafficValue') is not None:
            self.http_traffic_value = m.get('HttpTrafficValue')
        if m.get('HttpsTrafficValue') is not None:
            self.https_traffic_value = m.get('HttpsTrafficValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerInterval(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainTrafficDataResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        request_id: str = None,
        domain_name: str = None,
        traffic_data_per_interval: DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerInterval = None,
        start_time: str = None,
        data_interval: str = None,
    ):
        self.end_time = end_time
        self.request_id = request_id
        self.domain_name = domain_name
        self.traffic_data_per_interval = traffic_data_per_interval
        self.start_time = start_time
        self.data_interval = data_interval

    def validate(self):
        if self.traffic_data_per_interval:
            self.traffic_data_per_interval.validate()

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.traffic_data_per_interval is not None:
            result['TrafficDataPerInterval'] = self.traffic_data_per_interval.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('TrafficDataPerInterval') is not None:
            temp_model = DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerInterval()
            self.traffic_data_per_interval = temp_model.from_map(m['TrafficDataPerInterval'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        return self


class DescribeLiveDomainTrafficDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainTrafficDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainTranscodeDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfosTranscodeDataInfo(TeaModel):
    def __init__(
        self,
        date: str = None,
        total: int = None,
        detail: str = None,
    ):
        self.date = date
        self.total = total
        self.detail = detail

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.total is not None:
            result['Total'] = self.total
        if self.detail is not None:
            result['Detail'] = self.detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        return self


class DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfos(TeaModel):
    def __init__(
        self,
        transcode_data_info: List[DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfosTranscodeDataInfo] = None,
    ):
        self.transcode_data_info = transcode_data_info

    def validate(self):
        if self.transcode_data_info:
            for k in self.transcode_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['TranscodeDataInfo'] = []
        if self.transcode_data_info is not None:
            for k in self.transcode_data_info:
                result['TranscodeDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.transcode_data_info = []
        if m.get('TranscodeDataInfo') is not None:
            for k in m.get('TranscodeDataInfo'):
                temp_model = DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfosTranscodeDataInfo()
                self.transcode_data_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainTranscodeDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        transcode_data_infos: DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfos = None,
    ):
        self.request_id = request_id
        self.transcode_data_infos = transcode_data_infos

    def validate(self):
        if self.transcode_data_infos:
            self.transcode_data_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_data_infos is not None:
            result['TranscodeDataInfos'] = self.transcode_data_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeDataInfos') is not None:
            temp_model = DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfos()
            self.transcode_data_infos = temp_model.from_map(m['TranscodeDataInfos'])
        return self


class DescribeLiveDomainTranscodeDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveDomainTranscodeDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainTranscodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveLazyPullStreamConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        liveapi_request_from: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.liveapi_request_from = liveapi_request_from

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.liveapi_request_from is not None:
            result['LiveapiRequestFrom'] = self.liveapi_request_from
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('LiveapiRequestFrom') is not None:
            self.liveapi_request_from = m.get('LiveapiRequestFrom')
        return self


class DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigListLiveLazyPullConfig(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        app_name: str = None,
        pull_domain_name: str = None,
        pull_app_name: str = None,
        pull_protocol: str = None,
        pull_auth_type: str = None,
        pull_auth_key: str = None,
        pull_args: str = None,
    ):
        self.domain_name = domain_name
        self.app_name = app_name
        self.pull_domain_name = pull_domain_name
        self.pull_app_name = pull_app_name
        self.pull_protocol = pull_protocol
        self.pull_auth_type = pull_auth_type
        self.pull_auth_key = pull_auth_key
        self.pull_args = pull_args

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.pull_domain_name is not None:
            result['PullDomainName'] = self.pull_domain_name
        if self.pull_app_name is not None:
            result['PullAppName'] = self.pull_app_name
        if self.pull_protocol is not None:
            result['PullProtocol'] = self.pull_protocol
        if self.pull_auth_type is not None:
            result['PullAuthType'] = self.pull_auth_type
        if self.pull_auth_key is not None:
            result['PullAuthKey'] = self.pull_auth_key
        if self.pull_args is not None:
            result['PullArgs'] = self.pull_args
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('PullDomainName') is not None:
            self.pull_domain_name = m.get('PullDomainName')
        if m.get('PullAppName') is not None:
            self.pull_app_name = m.get('PullAppName')
        if m.get('PullProtocol') is not None:
            self.pull_protocol = m.get('PullProtocol')
        if m.get('PullAuthType') is not None:
            self.pull_auth_type = m.get('PullAuthType')
        if m.get('PullAuthKey') is not None:
            self.pull_auth_key = m.get('PullAuthKey')
        if m.get('PullArgs') is not None:
            self.pull_args = m.get('PullArgs')
        return self


class DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigList(TeaModel):
    def __init__(
        self,
        live_lazy_pull_config: List[DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigListLiveLazyPullConfig] = None,
    ):
        self.live_lazy_pull_config = live_lazy_pull_config

    def validate(self):
        if self.live_lazy_pull_config:
            for k in self.live_lazy_pull_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveLazyPullConfig'] = []
        if self.live_lazy_pull_config is not None:
            for k in self.live_lazy_pull_config:
                result['LiveLazyPullConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_lazy_pull_config = []
        if m.get('LiveLazyPullConfig') is not None:
            for k in m.get('LiveLazyPullConfig'):
                temp_model = DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigListLiveLazyPullConfig()
                self.live_lazy_pull_config.append(temp_model.from_map(k))
        return self


class DescribeLiveLazyPullStreamConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_lazy_pull_config_list: DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigList = None,
    ):
        self.request_id = request_id
        self.live_lazy_pull_config_list = live_lazy_pull_config_list

    def validate(self):
        if self.live_lazy_pull_config_list:
            self.live_lazy_pull_config_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_lazy_pull_config_list is not None:
            result['LiveLazyPullConfigList'] = self.live_lazy_pull_config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveLazyPullConfigList') is not None:
            temp_model = DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigList()
            self.live_lazy_pull_config_list = temp_model.from_map(m['LiveLazyPullConfigList'])
        return self


class DescribeLiveLazyPullStreamConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveLazyPullStreamConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveLazyPullStreamConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLivePullStreamConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        liveapi_request_from: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.liveapi_request_from = liveapi_request_from

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.liveapi_request_from is not None:
            result['LiveapiRequestFrom'] = self.liveapi_request_from
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveapiRequestFrom') is not None:
            self.liveapi_request_from = m.get('LiveapiRequestFrom')
        return self


class DescribeLivePullStreamConfigResponseBodyLiveAppRecordListLiveAppRecord(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        app_name: str = None,
        source_url: str = None,
        start_time: str = None,
        stream_name: str = None,
        domain_name: str = None,
    ):
        self.end_time = end_time
        self.app_name = app_name
        self.source_url = source_url
        self.start_time = start_time
        self.stream_name = stream_name
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.source_url is not None:
            result['SourceUrl'] = self.source_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('SourceUrl') is not None:
            self.source_url = m.get('SourceUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLivePullStreamConfigResponseBodyLiveAppRecordList(TeaModel):
    def __init__(
        self,
        live_app_record: List[DescribeLivePullStreamConfigResponseBodyLiveAppRecordListLiveAppRecord] = None,
    ):
        self.live_app_record = live_app_record

    def validate(self):
        if self.live_app_record:
            for k in self.live_app_record:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveAppRecord'] = []
        if self.live_app_record is not None:
            for k in self.live_app_record:
                result['LiveAppRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_app_record = []
        if m.get('LiveAppRecord') is not None:
            for k in m.get('LiveAppRecord'):
                temp_model = DescribeLivePullStreamConfigResponseBodyLiveAppRecordListLiveAppRecord()
                self.live_app_record.append(temp_model.from_map(k))
        return self


class DescribeLivePullStreamConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_app_record_list: DescribeLivePullStreamConfigResponseBodyLiveAppRecordList = None,
    ):
        self.request_id = request_id
        self.live_app_record_list = live_app_record_list

    def validate(self):
        if self.live_app_record_list:
            self.live_app_record_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_app_record_list is not None:
            result['LiveAppRecordList'] = self.live_app_record_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveAppRecordList') is not None:
            temp_model = DescribeLivePullStreamConfigResponseBodyLiveAppRecordList()
            self.live_app_record_list = temp_model.from_map(m['LiveAppRecordList'])
        return self


class DescribeLivePullStreamConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLivePullStreamConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLivePullStreamConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRealtimeDeliveryAccRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        start_time: str = None,
        end_time: str = None,
        interval: str = None,
        project: str = None,
        log_store: str = None,
    ):
        self.owner_id = owner_id
        self.start_time = start_time
        self.end_time = end_time
        self.interval = interval
        self.project = project
        self.log_store = log_store

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.project is not None:
            result['Project'] = self.project
        if self.log_store is not None:
            result['LogStore'] = self.log_store
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('LogStore') is not None:
            self.log_store = m.get('LogStore')
        return self


class DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccDataAccData(TeaModel):
    def __init__(
        self,
        time_stamp: str = None,
        success_num: int = None,
        failed_num: int = None,
    ):
        self.time_stamp = time_stamp
        self.success_num = success_num
        self.failed_num = failed_num

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.success_num is not None:
            result['SuccessNum'] = self.success_num
        if self.failed_num is not None:
            result['FailedNum'] = self.failed_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('SuccessNum') is not None:
            self.success_num = m.get('SuccessNum')
        if m.get('FailedNum') is not None:
            self.failed_num = m.get('FailedNum')
        return self


class DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccData(TeaModel):
    def __init__(
        self,
        acc_data: List[DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccDataAccData] = None,
    ):
        self.acc_data = acc_data

    def validate(self):
        if self.acc_data:
            for k in self.acc_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AccData'] = []
        if self.acc_data is not None:
            for k in self.acc_data:
                result['AccData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acc_data = []
        if m.get('AccData') is not None:
            for k in m.get('AccData'):
                temp_model = DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccDataAccData()
                self.acc_data.append(temp_model.from_map(k))
        return self


class DescribeLiveRealtimeDeliveryAccResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        real_time_delivery_acc_data: DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccData = None,
    ):
        self.request_id = request_id
        self.real_time_delivery_acc_data = real_time_delivery_acc_data

    def validate(self):
        if self.real_time_delivery_acc_data:
            self.real_time_delivery_acc_data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.real_time_delivery_acc_data is not None:
            result['RealTimeDeliveryAccData'] = self.real_time_delivery_acc_data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RealTimeDeliveryAccData') is not None:
            temp_model = DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccData()
            self.real_time_delivery_acc_data = temp_model.from_map(m['RealTimeDeliveryAccData'])
        return self


class DescribeLiveRealtimeDeliveryAccResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveRealtimeDeliveryAccResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveRealtimeDeliveryAccResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRealtimeLogAuthorizedRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        live_openapi_reserve: str = None,
    ):
        self.owner_id = owner_id
        self.live_openapi_reserve = live_openapi_reserve

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.live_openapi_reserve is not None:
            result['LiveOpenapiReserve'] = self.live_openapi_reserve
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('LiveOpenapiReserve') is not None:
            self.live_openapi_reserve = m.get('LiveOpenapiReserve')
        return self


class DescribeLiveRealtimeLogAuthorizedResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        authorized_status: str = None,
    ):
        self.request_id = request_id
        self.authorized_status = authorized_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.authorized_status is not None:
            result['AuthorizedStatus'] = self.authorized_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AuthorizedStatus') is not None:
            self.authorized_status = m.get('AuthorizedStatus')
        return self


class DescribeLiveRealtimeLogAuthorizedResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveRealtimeLogAuthorizedResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveRealtimeLogAuthorizedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRecordConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        page_num: int = None,
        page_size: int = None,
        order: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.page_num = page_num
        self.page_size = page_size
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.order is not None:
            result['Order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatListRecordFormat(TeaModel):
    def __init__(
        self,
        cycle_duration: int = None,
        slice_oss_object_prefix: str = None,
        oss_object_prefix: str = None,
        format: str = None,
    ):
        self.cycle_duration = cycle_duration
        self.slice_oss_object_prefix = slice_oss_object_prefix
        self.oss_object_prefix = oss_object_prefix
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatList(TeaModel):
    def __init__(
        self,
        record_format: List[DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatListRecordFormat] = None,
    ):
        self.record_format = record_format

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatListRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecord(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        start_time: str = None,
        app_name: str = None,
        stream_name: str = None,
        create_time: str = None,
        on_demond: int = None,
        oss_bucket: str = None,
        record_format_list: DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatList = None,
        domain_name: str = None,
        oss_endpoint: str = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.app_name = app_name
        self.stream_name = stream_name
        self.create_time = create_time
        self.on_demond = on_demond
        self.oss_bucket = oss_bucket
        self.record_format_list = record_format_list
        self.domain_name = domain_name
        self.oss_endpoint = oss_endpoint

    def validate(self):
        if self.record_format_list:
            self.record_format_list.validate()

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.on_demond is not None:
            result['OnDemond'] = self.on_demond
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.record_format_list is not None:
            result['RecordFormatList'] = self.record_format_list.to_map()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('OnDemond') is not None:
            self.on_demond = m.get('OnDemond')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('RecordFormatList') is not None:
            temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatList()
            self.record_format_list = temp_model.from_map(m['RecordFormatList'])
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordList(TeaModel):
    def __init__(
        self,
        live_app_record: List[DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecord] = None,
    ):
        self.live_app_record = live_app_record

    def validate(self):
        if self.live_app_record:
            for k in self.live_app_record:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveAppRecord'] = []
        if self.live_app_record is not None:
            for k in self.live_app_record:
                result['LiveAppRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_app_record = []
        if m.get('LiveAppRecord') is not None:
            for k in m.get('LiveAppRecord'):
                temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecord()
                self.live_app_record.append(temp_model.from_map(k))
        return self


class DescribeLiveRecordConfigResponseBody(TeaModel):
    def __init__(
        self,
        order: str = None,
        total_num: int = None,
        page_num: int = None,
        request_id: str = None,
        total_page: int = None,
        page_size: int = None,
        live_app_record_list: DescribeLiveRecordConfigResponseBodyLiveAppRecordList = None,
    ):
        self.order = order
        self.total_num = total_num
        self.page_num = page_num
        self.request_id = request_id
        self.total_page = total_page
        self.page_size = page_size
        self.live_app_record_list = live_app_record_list

    def validate(self):
        if self.live_app_record_list:
            self.live_app_record_list.validate()

    def to_map(self):
        result = dict()
        if self.order is not None:
            result['Order'] = self.order
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.live_app_record_list is not None:
            result['LiveAppRecordList'] = self.live_app_record_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('LiveAppRecordList') is not None:
            temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordList()
            self.live_app_record_list = temp_model.from_map(m['LiveAppRecordList'])
        return self


class DescribeLiveRecordConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveRecordConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveRecordConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRecordNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveRecordNotifyConfigResponseBodyLiveRecordNotifyConfig(TeaModel):
    def __init__(
        self,
        need_status_notify: bool = None,
        on_demand_url: str = None,
        notify_url: str = None,
        domain_name: str = None,
    ):
        self.need_status_notify = need_status_notify
        self.on_demand_url = on_demand_url
        self.notify_url = notify_url
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.need_status_notify is not None:
            result['NeedStatusNotify'] = self.need_status_notify
        if self.on_demand_url is not None:
            result['OnDemandUrl'] = self.on_demand_url
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NeedStatusNotify') is not None:
            self.need_status_notify = m.get('NeedStatusNotify')
        if m.get('OnDemandUrl') is not None:
            self.on_demand_url = m.get('OnDemandUrl')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveRecordNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_record_notify_config: DescribeLiveRecordNotifyConfigResponseBodyLiveRecordNotifyConfig = None,
    ):
        self.request_id = request_id
        self.live_record_notify_config = live_record_notify_config

    def validate(self):
        if self.live_record_notify_config:
            self.live_record_notify_config.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_record_notify_config is not None:
            result['LiveRecordNotifyConfig'] = self.live_record_notify_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveRecordNotifyConfig') is not None:
            temp_model = DescribeLiveRecordNotifyConfigResponseBodyLiveRecordNotifyConfig()
            self.live_record_notify_config = temp_model.from_map(m['LiveRecordNotifyConfig'])
        return self


class DescribeLiveRecordNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveRecordNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveRecordNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRecordVodConfigsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigsLiveRecordVodConfig(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        auto_compose: str = None,
        stream_name: str = None,
        create_time: str = None,
        vod_transcode_group_id: str = None,
        cycle_duration: int = None,
        domain_name: str = None,
        compose_vod_transcode_group_id: str = None,
    ):
        self.app_name = app_name
        self.auto_compose = auto_compose
        self.stream_name = stream_name
        self.create_time = create_time
        self.vod_transcode_group_id = vod_transcode_group_id
        self.cycle_duration = cycle_duration
        self.domain_name = domain_name
        self.compose_vod_transcode_group_id = compose_vod_transcode_group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.auto_compose is not None:
            result['AutoCompose'] = self.auto_compose
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.vod_transcode_group_id is not None:
            result['VodTranscodeGroupId'] = self.vod_transcode_group_id
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.compose_vod_transcode_group_id is not None:
            result['ComposeVodTranscodeGroupId'] = self.compose_vod_transcode_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AutoCompose') is not None:
            self.auto_compose = m.get('AutoCompose')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('VodTranscodeGroupId') is not None:
            self.vod_transcode_group_id = m.get('VodTranscodeGroupId')
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ComposeVodTranscodeGroupId') is not None:
            self.compose_vod_transcode_group_id = m.get('ComposeVodTranscodeGroupId')
        return self


class DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigs(TeaModel):
    def __init__(
        self,
        live_record_vod_config: List[DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigsLiveRecordVodConfig] = None,
    ):
        self.live_record_vod_config = live_record_vod_config

    def validate(self):
        if self.live_record_vod_config:
            for k in self.live_record_vod_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveRecordVodConfig'] = []
        if self.live_record_vod_config is not None:
            for k in self.live_record_vod_config:
                result['LiveRecordVodConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_record_vod_config = []
        if m.get('LiveRecordVodConfig') is not None:
            for k in m.get('LiveRecordVodConfig'):
                temp_model = DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigsLiveRecordVodConfig()
                self.live_record_vod_config.append(temp_model.from_map(k))
        return self


class DescribeLiveRecordVodConfigsResponseBody(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        request_id: str = None,
        page_size: int = None,
        live_record_vod_configs: DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigs = None,
        total: str = None,
    ):
        self.page_num = page_num
        self.request_id = request_id
        self.page_size = page_size
        self.live_record_vod_configs = live_record_vod_configs
        self.total = total

    def validate(self):
        if self.live_record_vod_configs:
            self.live_record_vod_configs.validate()

    def to_map(self):
        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.live_record_vod_configs is not None:
            result['LiveRecordVodConfigs'] = self.live_record_vod_configs.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('LiveRecordVodConfigs') is not None:
            temp_model = DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigs()
            self.live_record_vod_configs = temp_model.from_map(m['LiveRecordVodConfigs'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveRecordVodConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveRecordVodConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveRecordVodConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveSnapshotConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        page_num: int = None,
        page_size: int = None,
        order: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.page_num = page_num
        self.page_size = page_size
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.order is not None:
            result['Order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        return self


class DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigListLiveStreamSnapshotConfig(TeaModel):
    def __init__(
        self,
        overwrite_oss_object: str = None,
        time_interval: int = None,
        app_name: str = None,
        create_time: str = None,
        oss_bucket: str = None,
        domain_name: str = None,
        callback: str = None,
        sequence_oss_object: str = None,
        oss_endpoint: str = None,
    ):
        self.overwrite_oss_object = overwrite_oss_object
        self.time_interval = time_interval
        self.app_name = app_name
        self.create_time = create_time
        self.oss_bucket = oss_bucket
        self.domain_name = domain_name
        self.callback = callback
        self.sequence_oss_object = sequence_oss_object
        self.oss_endpoint = oss_endpoint

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.overwrite_oss_object is not None:
            result['OverwriteOssObject'] = self.overwrite_oss_object
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.callback is not None:
            result['Callback'] = self.callback
        if self.sequence_oss_object is not None:
            result['SequenceOssObject'] = self.sequence_oss_object
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteOssObject') is not None:
            self.overwrite_oss_object = m.get('OverwriteOssObject')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        if m.get('SequenceOssObject') is not None:
            self.sequence_oss_object = m.get('SequenceOssObject')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigList(TeaModel):
    def __init__(
        self,
        live_stream_snapshot_config: List[DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigListLiveStreamSnapshotConfig] = None,
    ):
        self.live_stream_snapshot_config = live_stream_snapshot_config

    def validate(self):
        if self.live_stream_snapshot_config:
            for k in self.live_stream_snapshot_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamSnapshotConfig'] = []
        if self.live_stream_snapshot_config is not None:
            for k in self.live_stream_snapshot_config:
                result['LiveStreamSnapshotConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_snapshot_config = []
        if m.get('LiveStreamSnapshotConfig') is not None:
            for k in m.get('LiveStreamSnapshotConfig'):
                temp_model = DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigListLiveStreamSnapshotConfig()
                self.live_stream_snapshot_config.append(temp_model.from_map(k))
        return self


class DescribeLiveSnapshotConfigResponseBody(TeaModel):
    def __init__(
        self,
        order: str = None,
        total_num: int = None,
        page_num: int = None,
        request_id: str = None,
        total_page: int = None,
        page_size: int = None,
        live_stream_snapshot_config_list: DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigList = None,
    ):
        self.order = order
        self.total_num = total_num
        self.page_num = page_num
        self.request_id = request_id
        self.total_page = total_page
        self.page_size = page_size
        self.live_stream_snapshot_config_list = live_stream_snapshot_config_list

    def validate(self):
        if self.live_stream_snapshot_config_list:
            self.live_stream_snapshot_config_list.validate()

    def to_map(self):
        result = dict()
        if self.order is not None:
            result['Order'] = self.order
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.live_stream_snapshot_config_list is not None:
            result['LiveStreamSnapshotConfigList'] = self.live_stream_snapshot_config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('LiveStreamSnapshotConfigList') is not None:
            temp_model = DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigList()
            self.live_stream_snapshot_config_list = temp_model.from_map(m['LiveStreamSnapshotConfigList'])
        return self


class DescribeLiveSnapshotConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveSnapshotConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveSnapshotConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveSnapshotDetectPornConfigRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        page_num: int = None,
        page_size: int = None,
        order: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.page_num = page_num
        self.page_size = page_size
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.order is not None:
            result['Order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        return self


class DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfigScenes(TeaModel):
    def __init__(
        self,
        scene: List[str] = None,
    ):
        self.scene = scene

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfig(TeaModel):
    def __init__(
        self,
        oss_object: str = None,
        app_name: str = None,
        interval: int = None,
        scenes: DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfigScenes = None,
        oss_bucket: str = None,
        domain_name: str = None,
        oss_endpoint: str = None,
    ):
        self.oss_object = oss_object
        self.app_name = app_name
        self.interval = interval
        self.scenes = scenes
        self.oss_bucket = oss_bucket
        self.domain_name = domain_name
        self.oss_endpoint = oss_endpoint

    def validate(self):
        if self.scenes:
            self.scenes.validate()

    def to_map(self):
        result = dict()
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.scenes is not None:
            result['Scenes'] = self.scenes.to_map()
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Scenes') is not None:
            temp_model = DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfigScenes()
            self.scenes = temp_model.from_map(m['Scenes'])
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigList(TeaModel):
    def __init__(
        self,
        live_snapshot_detect_porn_config: List[DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfig] = None,
    ):
        self.live_snapshot_detect_porn_config = live_snapshot_detect_porn_config

    def validate(self):
        if self.live_snapshot_detect_porn_config:
            for k in self.live_snapshot_detect_porn_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveSnapshotDetectPornConfig'] = []
        if self.live_snapshot_detect_porn_config is not None:
            for k in self.live_snapshot_detect_porn_config:
                result['LiveSnapshotDetectPornConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_snapshot_detect_porn_config = []
        if m.get('LiveSnapshotDetectPornConfig') is not None:
            for k in m.get('LiveSnapshotDetectPornConfig'):
                temp_model = DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfig()
                self.live_snapshot_detect_porn_config.append(temp_model.from_map(k))
        return self


class DescribeLiveSnapshotDetectPornConfigResponseBody(TeaModel):
    def __init__(
        self,
        order: str = None,
        total_num: int = None,
        page_num: int = None,
        request_id: str = None,
        total_page: int = None,
        page_size: int = None,
        live_snapshot_detect_porn_config_list: DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigList = None,
    ):
        self.order = order
        self.total_num = total_num
        self.page_num = page_num
        self.request_id = request_id
        self.total_page = total_page
        self.page_size = page_size
        self.live_snapshot_detect_porn_config_list = live_snapshot_detect_porn_config_list

    def validate(self):
        if self.live_snapshot_detect_porn_config_list:
            self.live_snapshot_detect_porn_config_list.validate()

    def to_map(self):
        result = dict()
        if self.order is not None:
            result['Order'] = self.order
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.live_snapshot_detect_porn_config_list is not None:
            result['LiveSnapshotDetectPornConfigList'] = self.live_snapshot_detect_porn_config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('LiveSnapshotDetectPornConfigList') is not None:
            temp_model = DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigList()
            self.live_snapshot_detect_porn_config_list = temp_model.from_map(m['LiveSnapshotDetectPornConfigList'])
        return self


class DescribeLiveSnapshotDetectPornConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveSnapshotDetectPornConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveSnapshotDetectPornConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamBitRateDataRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        audio_frame_rate: float = None,
        video_frame_rate: float = None,
        stream_url: str = None,
        bit_rate: float = None,
    ):
        self.time = time
        self.audio_frame_rate = audio_frame_rate
        self.video_frame_rate = video_frame_rate
        self.stream_url = stream_url
        self.bit_rate = bit_rate

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.audio_frame_rate is not None:
            result['AudioFrameRate'] = self.audio_frame_rate
        if self.video_frame_rate is not None:
            result['VideoFrameRate'] = self.video_frame_rate
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('AudioFrameRate') is not None:
            self.audio_frame_rate = m.get('AudioFrameRate')
        if m.get('VideoFrameRate') is not None:
            self.video_frame_rate = m.get('VideoFrameRate')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        return self


class DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfos(TeaModel):
    def __init__(
        self,
        frame_rate_and_bit_rate_info: List[DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo] = None,
    ):
        self.frame_rate_and_bit_rate_info = frame_rate_and_bit_rate_info

    def validate(self):
        if self.frame_rate_and_bit_rate_info:
            for k in self.frame_rate_and_bit_rate_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FrameRateAndBitRateInfo'] = []
        if self.frame_rate_and_bit_rate_info is not None:
            for k in self.frame_rate_and_bit_rate_info:
                result['FrameRateAndBitRateInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.frame_rate_and_bit_rate_info = []
        if m.get('FrameRateAndBitRateInfo') is not None:
            for k in m.get('FrameRateAndBitRateInfo'):
                temp_model = DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo()
                self.frame_rate_and_bit_rate_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamBitRateDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        frame_rate_and_bit_rate_infos: DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfos = None,
    ):
        self.request_id = request_id
        self.frame_rate_and_bit_rate_infos = frame_rate_and_bit_rate_infos

    def validate(self):
        if self.frame_rate_and_bit_rate_infos:
            self.frame_rate_and_bit_rate_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.frame_rate_and_bit_rate_infos is not None:
            result['FrameRateAndBitRateInfos'] = self.frame_rate_and_bit_rate_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FrameRateAndBitRateInfos') is not None:
            temp_model = DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfos()
            self.frame_rate_and_bit_rate_infos = temp_model.from_map(m['FrameRateAndBitRateInfos'])
        return self


class DescribeLiveStreamBitRateDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamBitRateDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamBitRateDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamCountRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetailsStreamCountDetail(TeaModel):
    def __init__(
        self,
        video_data_rate: int = None,
        format: str = None,
        count: int = None,
    ):
        self.video_data_rate = video_data_rate
        self.format = format
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.video_data_rate is not None:
            result['VideoDataRate'] = self.video_data_rate
        if self.format is not None:
            result['Format'] = self.format
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoDataRate') is not None:
            self.video_data_rate = m.get('VideoDataRate')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetails(TeaModel):
    def __init__(
        self,
        stream_count_detail: List[DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetailsStreamCountDetail] = None,
    ):
        self.stream_count_detail = stream_count_detail

    def validate(self):
        if self.stream_count_detail:
            for k in self.stream_count_detail:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['StreamCountDetail'] = []
        if self.stream_count_detail is not None:
            for k in self.stream_count_detail:
                result['StreamCountDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_count_detail = []
        if m.get('StreamCountDetail') is not None:
            for k in m.get('StreamCountDetail'):
                temp_model = DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetailsStreamCountDetail()
                self.stream_count_detail.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        stream_count_details: DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetails = None,
        limit: int = None,
        count: int = None,
    ):
        self.type = type
        self.stream_count_details = stream_count_details
        self.limit = limit
        self.count = count

    def validate(self):
        if self.stream_count_details:
            self.stream_count_details.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.stream_count_details is not None:
            result['StreamCountDetails'] = self.stream_count_details.to_map()
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('StreamCountDetails') is not None:
            temp_model = DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetails()
            self.stream_count_details = temp_model.from_map(m['StreamCountDetails'])
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeLiveStreamCountResponseBodyStreamCountInfos(TeaModel):
    def __init__(
        self,
        stream_count_info: List[DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfo] = None,
    ):
        self.stream_count_info = stream_count_info

    def validate(self):
        if self.stream_count_info:
            for k in self.stream_count_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['StreamCountInfo'] = []
        if self.stream_count_info is not None:
            for k in self.stream_count_info:
                result['StreamCountInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_count_info = []
        if m.get('StreamCountInfo') is not None:
            for k in m.get('StreamCountInfo'):
                temp_model = DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfo()
                self.stream_count_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        stream_count_infos: DescribeLiveStreamCountResponseBodyStreamCountInfos = None,
    ):
        self.request_id = request_id
        self.stream_count_infos = stream_count_infos

    def validate(self):
        if self.stream_count_infos:
            self.stream_count_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stream_count_infos is not None:
            result['StreamCountInfos'] = self.stream_count_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StreamCountInfos') is not None:
            temp_model = DescribeLiveStreamCountResponseBodyStreamCountInfos()
            self.stream_count_infos = temp_model.from_map(m['StreamCountInfos'])
        return self


class DescribeLiveStreamCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamDelayConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveStreamDelayConfigResponseBodyLiveStreamHlsDelayConfig(TeaModel):
    def __init__(
        self,
        level: str = None,
        delay: int = None,
    ):
        self.level = level
        self.delay = delay

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.delay is not None:
            result['Delay'] = self.delay
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        return self


class DescribeLiveStreamDelayConfigResponseBodyLiveStreamFlvDelayConfig(TeaModel):
    def __init__(
        self,
        level: str = None,
        delay: int = None,
    ):
        self.level = level
        self.delay = delay

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.delay is not None:
            result['Delay'] = self.delay
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        return self


class DescribeLiveStreamDelayConfigResponseBodyLiveStreamRtmpDelayConfig(TeaModel):
    def __init__(
        self,
        level: str = None,
        delay: int = None,
    ):
        self.level = level
        self.delay = delay

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.delay is not None:
            result['Delay'] = self.delay
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        return self


class DescribeLiveStreamDelayConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_stream_hls_delay_config: DescribeLiveStreamDelayConfigResponseBodyLiveStreamHlsDelayConfig = None,
        live_stream_flv_delay_config: DescribeLiveStreamDelayConfigResponseBodyLiveStreamFlvDelayConfig = None,
        live_stream_rtmp_delay_config: DescribeLiveStreamDelayConfigResponseBodyLiveStreamRtmpDelayConfig = None,
    ):
        self.request_id = request_id
        self.live_stream_hls_delay_config = live_stream_hls_delay_config
        self.live_stream_flv_delay_config = live_stream_flv_delay_config
        self.live_stream_rtmp_delay_config = live_stream_rtmp_delay_config

    def validate(self):
        if self.live_stream_hls_delay_config:
            self.live_stream_hls_delay_config.validate()
        if self.live_stream_flv_delay_config:
            self.live_stream_flv_delay_config.validate()
        if self.live_stream_rtmp_delay_config:
            self.live_stream_rtmp_delay_config.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_stream_hls_delay_config is not None:
            result['LiveStreamHlsDelayConfig'] = self.live_stream_hls_delay_config.to_map()
        if self.live_stream_flv_delay_config is not None:
            result['LiveStreamFlvDelayConfig'] = self.live_stream_flv_delay_config.to_map()
        if self.live_stream_rtmp_delay_config is not None:
            result['LiveStreamRtmpDelayConfig'] = self.live_stream_rtmp_delay_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveStreamHlsDelayConfig') is not None:
            temp_model = DescribeLiveStreamDelayConfigResponseBodyLiveStreamHlsDelayConfig()
            self.live_stream_hls_delay_config = temp_model.from_map(m['LiveStreamHlsDelayConfig'])
        if m.get('LiveStreamFlvDelayConfig') is not None:
            temp_model = DescribeLiveStreamDelayConfigResponseBodyLiveStreamFlvDelayConfig()
            self.live_stream_flv_delay_config = temp_model.from_map(m['LiveStreamFlvDelayConfig'])
        if m.get('LiveStreamRtmpDelayConfig') is not None:
            temp_model = DescribeLiveStreamDelayConfigResponseBodyLiveStreamRtmpDelayConfig()
            self.live_stream_rtmp_delay_config = temp_model.from_map(m['LiveStreamRtmpDelayConfig'])
        return self


class DescribeLiveStreamDelayConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamDelayConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamDelayConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamHistoryUserNumRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfosLiveStreamUserNumInfo(TeaModel):
    def __init__(
        self,
        user_num: str = None,
        stream_time: str = None,
    ):
        self.user_num = user_num
        self.stream_time = stream_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.user_num is not None:
            result['UserNum'] = self.user_num
        if self.stream_time is not None:
            result['StreamTime'] = self.stream_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserNum') is not None:
            self.user_num = m.get('UserNum')
        if m.get('StreamTime') is not None:
            self.stream_time = m.get('StreamTime')
        return self


class DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfos(TeaModel):
    def __init__(
        self,
        live_stream_user_num_info: List[DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfosLiveStreamUserNumInfo] = None,
    ):
        self.live_stream_user_num_info = live_stream_user_num_info

    def validate(self):
        if self.live_stream_user_num_info:
            for k in self.live_stream_user_num_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamUserNumInfo'] = []
        if self.live_stream_user_num_info is not None:
            for k in self.live_stream_user_num_info:
                result['LiveStreamUserNumInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_user_num_info = []
        if m.get('LiveStreamUserNumInfo') is not None:
            for k in m.get('LiveStreamUserNumInfo'):
                temp_model = DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfosLiveStreamUserNumInfo()
                self.live_stream_user_num_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamHistoryUserNumResponseBody(TeaModel):
    def __init__(
        self,
        live_stream_user_num_infos: DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfos = None,
        request_id: str = None,
    ):
        self.live_stream_user_num_infos = live_stream_user_num_infos
        self.request_id = request_id

    def validate(self):
        if self.live_stream_user_num_infos:
            self.live_stream_user_num_infos.validate()

    def to_map(self):
        result = dict()
        if self.live_stream_user_num_infos is not None:
            result['LiveStreamUserNumInfos'] = self.live_stream_user_num_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LiveStreamUserNumInfos') is not None:
            temp_model = DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfos()
            self.live_stream_user_num_infos = temp_model.from_map(m['LiveStreamUserNumInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamHistoryUserNumResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamHistoryUserNumResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamHistoryUserNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamOnlineUserNumRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveStreamOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        user_number: int = None,
        stream_url: str = None,
    ):
        self.time = time
        self.user_number = user_number
        self.stream_url = stream_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.user_number is not None:
            result['UserNumber'] = self.user_number
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('UserNumber') is not None:
            self.user_number = m.get('UserNumber')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeLiveStreamOnlineUserNumResponseBodyOnlineUserInfo(TeaModel):
    def __init__(
        self,
        live_stream_online_user_num_info: List[DescribeLiveStreamOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo] = None,
    ):
        self.live_stream_online_user_num_info = live_stream_online_user_num_info

    def validate(self):
        if self.live_stream_online_user_num_info:
            for k in self.live_stream_online_user_num_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamOnlineUserNumInfo'] = []
        if self.live_stream_online_user_num_info is not None:
            for k in self.live_stream_online_user_num_info:
                result['LiveStreamOnlineUserNumInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_online_user_num_info = []
        if m.get('LiveStreamOnlineUserNumInfo') is not None:
            for k in m.get('LiveStreamOnlineUserNumInfo'):
                temp_model = DescribeLiveStreamOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo()
                self.live_stream_online_user_num_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamOnlineUserNumResponseBody(TeaModel):
    def __init__(
        self,
        online_user_info: DescribeLiveStreamOnlineUserNumResponseBodyOnlineUserInfo = None,
        request_id: str = None,
        total_user_number: int = None,
    ):
        self.online_user_info = online_user_info
        self.request_id = request_id
        self.total_user_number = total_user_number

    def validate(self):
        if self.online_user_info:
            self.online_user_info.validate()

    def to_map(self):
        result = dict()
        if self.online_user_info is not None:
            result['OnlineUserInfo'] = self.online_user_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_user_number is not None:
            result['TotalUserNumber'] = self.total_user_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OnlineUserInfo') is not None:
            temp_model = DescribeLiveStreamOnlineUserNumResponseBodyOnlineUserInfo()
            self.online_user_info = temp_model.from_map(m['OnlineUserInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalUserNumber') is not None:
            self.total_user_number = m.get('TotalUserNumber')
        return self


class DescribeLiveStreamOnlineUserNumResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamOnlineUserNumResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamOnlineUserNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamOptimizedFeatureConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        config_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.config_name = config_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        return self


class DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigListLiveStreamOptimizedFeatureConfig(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        config_name: str = None,
        config_status: str = None,
        config_value: str = None,
    ):
        self.domain_name = domain_name
        self.config_name = config_name
        self.config_status = config_status
        self.config_value = config_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.config_status is not None:
            result['ConfigStatus'] = self.config_status
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ConfigStatus') is not None:
            self.config_status = m.get('ConfigStatus')
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        return self


class DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigList(TeaModel):
    def __init__(
        self,
        live_stream_optimized_feature_config: List[DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigListLiveStreamOptimizedFeatureConfig] = None,
    ):
        self.live_stream_optimized_feature_config = live_stream_optimized_feature_config

    def validate(self):
        if self.live_stream_optimized_feature_config:
            for k in self.live_stream_optimized_feature_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamOptimizedFeatureConfig'] = []
        if self.live_stream_optimized_feature_config is not None:
            for k in self.live_stream_optimized_feature_config:
                result['LiveStreamOptimizedFeatureConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_optimized_feature_config = []
        if m.get('LiveStreamOptimizedFeatureConfig') is not None:
            for k in m.get('LiveStreamOptimizedFeatureConfig'):
                temp_model = DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigListLiveStreamOptimizedFeatureConfig()
                self.live_stream_optimized_feature_config.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamOptimizedFeatureConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_stream_optimized_feature_config_list: DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigList = None,
    ):
        self.request_id = request_id
        self.live_stream_optimized_feature_config_list = live_stream_optimized_feature_config_list

    def validate(self):
        if self.live_stream_optimized_feature_config_list:
            self.live_stream_optimized_feature_config_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_stream_optimized_feature_config_list is not None:
            result['LiveStreamOptimizedFeatureConfigList'] = self.live_stream_optimized_feature_config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveStreamOptimizedFeatureConfigList') is not None:
            temp_model = DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigList()
            self.live_stream_optimized_feature_config_list = temp_model.from_map(m['LiveStreamOptimizedFeatureConfigList'])
        return self


class DescribeLiveStreamOptimizedFeatureConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamOptimizedFeatureConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamOptimizedFeatureConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamRecordContentRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveStreamRecordContentResponseBodyRecordContentInfoListRecordContentInfo(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        start_time: str = None,
        duration: float = None,
        oss_bucket: str = None,
        oss_object_prefix: str = None,
        oss_endpoint: str = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.duration = duration
        self.oss_bucket = oss_bucket
        self.oss_object_prefix = oss_object_prefix
        self.oss_endpoint = oss_endpoint

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeLiveStreamRecordContentResponseBodyRecordContentInfoList(TeaModel):
    def __init__(
        self,
        record_content_info: List[DescribeLiveStreamRecordContentResponseBodyRecordContentInfoListRecordContentInfo] = None,
    ):
        self.record_content_info = record_content_info

    def validate(self):
        if self.record_content_info:
            for k in self.record_content_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RecordContentInfo'] = []
        if self.record_content_info is not None:
            for k in self.record_content_info:
                result['RecordContentInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_content_info = []
        if m.get('RecordContentInfo') is not None:
            for k in m.get('RecordContentInfo'):
                temp_model = DescribeLiveStreamRecordContentResponseBodyRecordContentInfoListRecordContentInfo()
                self.record_content_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamRecordContentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        record_content_info_list: DescribeLiveStreamRecordContentResponseBodyRecordContentInfoList = None,
    ):
        self.request_id = request_id
        self.record_content_info_list = record_content_info_list

    def validate(self):
        if self.record_content_info_list:
            self.record_content_info_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.record_content_info_list is not None:
            result['RecordContentInfoList'] = self.record_content_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RecordContentInfoList') is not None:
            temp_model = DescribeLiveStreamRecordContentResponseBodyRecordContentInfoList()
            self.record_content_info_list = temp_model.from_map(m['RecordContentInfoList'])
        return self


class DescribeLiveStreamRecordContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamRecordContentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamRecordContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamRecordIndexFileRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        record_id: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.record_id = record_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class DescribeLiveStreamRecordIndexFileResponseBodyRecordIndexInfo(TeaModel):
    def __init__(
        self,
        stream_name: str = None,
        record_url: str = None,
        record_id: str = None,
        create_time: str = None,
        height: int = None,
        oss_bucket: str = None,
        domain_name: str = None,
        end_time: str = None,
        oss_object: str = None,
        start_time: str = None,
        app_name: str = None,
        width: int = None,
        duration: float = None,
        oss_endpoint: str = None,
    ):
        self.stream_name = stream_name
        self.record_url = record_url
        self.record_id = record_id
        self.create_time = create_time
        self.height = height
        self.oss_bucket = oss_bucket
        self.domain_name = domain_name
        self.end_time = end_time
        self.oss_object = oss_object
        self.start_time = start_time
        self.app_name = app_name
        self.width = width
        self.duration = duration
        self.oss_endpoint = oss_endpoint

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.height is not None:
            result['Height'] = self.height
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.width is not None:
            result['Width'] = self.width
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeLiveStreamRecordIndexFileResponseBody(TeaModel):
    def __init__(
        self,
        record_index_info: DescribeLiveStreamRecordIndexFileResponseBodyRecordIndexInfo = None,
        request_id: str = None,
    ):
        self.record_index_info = record_index_info
        self.request_id = request_id

    def validate(self):
        if self.record_index_info:
            self.record_index_info.validate()

    def to_map(self):
        result = dict()
        if self.record_index_info is not None:
            result['RecordIndexInfo'] = self.record_index_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordIndexInfo') is not None:
            temp_model = DescribeLiveStreamRecordIndexFileResponseBodyRecordIndexInfo()
            self.record_index_info = temp_model.from_map(m['RecordIndexInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamRecordIndexFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamRecordIndexFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamRecordIndexFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamRecordIndexFilesRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
        page_num: int = None,
        page_size: int = None,
        order: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time
        self.page_num = page_num
        self.page_size = page_size
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.order is not None:
            result['Order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        return self


class DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoListRecordIndexInfo(TeaModel):
    def __init__(
        self,
        stream_name: str = None,
        record_url: str = None,
        record_id: str = None,
        create_time: str = None,
        height: int = None,
        oss_bucket: str = None,
        domain_name: str = None,
        end_time: str = None,
        oss_object: str = None,
        start_time: str = None,
        app_name: str = None,
        width: int = None,
        duration: float = None,
        oss_endpoint: str = None,
    ):
        self.stream_name = stream_name
        self.record_url = record_url
        self.record_id = record_id
        self.create_time = create_time
        self.height = height
        self.oss_bucket = oss_bucket
        self.domain_name = domain_name
        self.end_time = end_time
        self.oss_object = oss_object
        self.start_time = start_time
        self.app_name = app_name
        self.width = width
        self.duration = duration
        self.oss_endpoint = oss_endpoint

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.height is not None:
            result['Height'] = self.height
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.width is not None:
            result['Width'] = self.width
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoList(TeaModel):
    def __init__(
        self,
        record_index_info: List[DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoListRecordIndexInfo] = None,
    ):
        self.record_index_info = record_index_info

    def validate(self):
        if self.record_index_info:
            for k in self.record_index_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RecordIndexInfo'] = []
        if self.record_index_info is not None:
            for k in self.record_index_info:
                result['RecordIndexInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_index_info = []
        if m.get('RecordIndexInfo') is not None:
            for k in m.get('RecordIndexInfo'):
                temp_model = DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoListRecordIndexInfo()
                self.record_index_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamRecordIndexFilesResponseBody(TeaModel):
    def __init__(
        self,
        order: str = None,
        total_num: int = None,
        page_num: int = None,
        request_id: str = None,
        total_page: int = None,
        page_size: int = None,
        record_index_info_list: DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoList = None,
    ):
        self.order = order
        self.total_num = total_num
        self.page_num = page_num
        self.request_id = request_id
        self.total_page = total_page
        self.page_size = page_size
        self.record_index_info_list = record_index_info_list

    def validate(self):
        if self.record_index_info_list:
            self.record_index_info_list.validate()

    def to_map(self):
        result = dict()
        if self.order is not None:
            result['Order'] = self.order
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_index_info_list is not None:
            result['RecordIndexInfoList'] = self.record_index_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordIndexInfoList') is not None:
            temp_model = DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoList()
            self.record_index_info_list = temp_model.from_map(m['RecordIndexInfoList'])
        return self


class DescribeLiveStreamRecordIndexFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamRecordIndexFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamRecordIndexFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamsBlockListRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeLiveStreamsBlockListResponseBodyStreamUrls(TeaModel):
    def __init__(
        self,
        stream_url: List[str] = None,
    ):
        self.stream_url = stream_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeLiveStreamsBlockListResponseBody(TeaModel):
    def __init__(
        self,
        total_num: int = None,
        page_num: int = None,
        request_id: str = None,
        total_page: int = None,
        page_size: int = None,
        domain_name: str = None,
        stream_urls: DescribeLiveStreamsBlockListResponseBodyStreamUrls = None,
    ):
        self.total_num = total_num
        self.page_num = page_num
        self.request_id = request_id
        self.total_page = total_page
        self.page_size = page_size
        self.domain_name = domain_name
        self.stream_urls = stream_urls

    def validate(self):
        if self.stream_urls:
            self.stream_urls.validate()

    def to_map(self):
        result = dict()
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.stream_urls is not None:
            result['StreamUrls'] = self.stream_urls.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StreamUrls') is not None:
            temp_model = DescribeLiveStreamsBlockListResponseBodyStreamUrls()
            self.stream_urls = temp_model.from_map(m['StreamUrls'])
        return self


class DescribeLiveStreamsBlockListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamsBlockListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamsBlockListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamsControlHistoryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        start_time: str = None,
        end_time: str = None,
        page: int = None,
        rows: int = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.start_time = start_time
        self.end_time = end_time
        self.page = page
        self.rows = rows

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page is not None:
            result['Page'] = self.page
        if self.rows is not None:
            result['Rows'] = self.rows
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        return self


class DescribeLiveStreamsControlHistoryResponseBodyControlInfoLiveStreamControlInfo(TeaModel):
    def __init__(
        self,
        action: str = None,
        stream_name: str = None,
        client_ip: str = None,
        time_stamp: str = None,
    ):
        self.action = action
        self.stream_name = stream_name
        self.client_ip = client_ip
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.client_ip is not None:
            result['ClientIP'] = self.client_ip
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('ClientIP') is not None:
            self.client_ip = m.get('ClientIP')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveStreamsControlHistoryResponseBodyControlInfo(TeaModel):
    def __init__(
        self,
        live_stream_control_info: List[DescribeLiveStreamsControlHistoryResponseBodyControlInfoLiveStreamControlInfo] = None,
    ):
        self.live_stream_control_info = live_stream_control_info

    def validate(self):
        if self.live_stream_control_info:
            for k in self.live_stream_control_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamControlInfo'] = []
        if self.live_stream_control_info is not None:
            for k in self.live_stream_control_info:
                result['LiveStreamControlInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_control_info = []
        if m.get('LiveStreamControlInfo') is not None:
            for k in m.get('LiveStreamControlInfo'):
                temp_model = DescribeLiveStreamsControlHistoryResponseBodyControlInfoLiveStreamControlInfo()
                self.live_stream_control_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamsControlHistoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        control_info: DescribeLiveStreamsControlHistoryResponseBodyControlInfo = None,
    ):
        self.request_id = request_id
        self.control_info = control_info

    def validate(self):
        if self.control_info:
            self.control_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.control_info is not None:
            result['ControlInfo'] = self.control_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ControlInfo') is not None:
            temp_model = DescribeLiveStreamsControlHistoryResponseBodyControlInfo()
            self.control_info = temp_model.from_map(m['ControlInfo'])
        return self


class DescribeLiveStreamsControlHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamsControlHistoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamsControlHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamsFrameRateAndBitRateDataRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeLiveStreamsFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        audio_frame_rate: float = None,
        video_frame_rate: float = None,
        stream_url: str = None,
        bit_rate: float = None,
    ):
        self.time = time
        self.audio_frame_rate = audio_frame_rate
        self.video_frame_rate = video_frame_rate
        self.stream_url = stream_url
        self.bit_rate = bit_rate

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.audio_frame_rate is not None:
            result['AudioFrameRate'] = self.audio_frame_rate
        if self.video_frame_rate is not None:
            result['VideoFrameRate'] = self.video_frame_rate
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('AudioFrameRate') is not None:
            self.audio_frame_rate = m.get('AudioFrameRate')
        if m.get('VideoFrameRate') is not None:
            self.video_frame_rate = m.get('VideoFrameRate')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        return self


class DescribeLiveStreamsFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos(TeaModel):
    def __init__(
        self,
        frame_rate_and_bit_rate_info: List[DescribeLiveStreamsFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo] = None,
    ):
        self.frame_rate_and_bit_rate_info = frame_rate_and_bit_rate_info

    def validate(self):
        if self.frame_rate_and_bit_rate_info:
            for k in self.frame_rate_and_bit_rate_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FrameRateAndBitRateInfo'] = []
        if self.frame_rate_and_bit_rate_info is not None:
            for k in self.frame_rate_and_bit_rate_info:
                result['FrameRateAndBitRateInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.frame_rate_and_bit_rate_info = []
        if m.get('FrameRateAndBitRateInfo') is not None:
            for k in m.get('FrameRateAndBitRateInfo'):
                temp_model = DescribeLiveStreamsFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo()
                self.frame_rate_and_bit_rate_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamsFrameRateAndBitRateDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        frame_rate_and_bit_rate_infos: DescribeLiveStreamsFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos = None,
    ):
        self.request_id = request_id
        self.frame_rate_and_bit_rate_infos = frame_rate_and_bit_rate_infos

    def validate(self):
        if self.frame_rate_and_bit_rate_infos:
            self.frame_rate_and_bit_rate_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.frame_rate_and_bit_rate_infos is not None:
            result['FrameRateAndBitRateInfos'] = self.frame_rate_and_bit_rate_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FrameRateAndBitRateInfos') is not None:
            temp_model = DescribeLiveStreamsFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos()
            self.frame_rate_and_bit_rate_infos = temp_model.from_map(m['FrameRateAndBitRateInfos'])
        return self


class DescribeLiveStreamsFrameRateAndBitRateDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamsFrameRateAndBitRateDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamsFrameRateAndBitRateDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamSnapshotInfoRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
        limit: int = None,
        order: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time
        self.limit = limit
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.order is not None:
            result['Order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        return self


class DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoListLiveStreamSnapshotInfo(TeaModel):
    def __init__(
        self,
        oss_object: str = None,
        create_time: str = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
    ):
        self.oss_object = oss_object
        self.create_time = create_time
        self.oss_bucket = oss_bucket
        self.oss_endpoint = oss_endpoint

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoList(TeaModel):
    def __init__(
        self,
        live_stream_snapshot_info: List[DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoListLiveStreamSnapshotInfo] = None,
    ):
        self.live_stream_snapshot_info = live_stream_snapshot_info

    def validate(self):
        if self.live_stream_snapshot_info:
            for k in self.live_stream_snapshot_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamSnapshotInfo'] = []
        if self.live_stream_snapshot_info is not None:
            for k in self.live_stream_snapshot_info:
                result['LiveStreamSnapshotInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_snapshot_info = []
        if m.get('LiveStreamSnapshotInfo') is not None:
            for k in m.get('LiveStreamSnapshotInfo'):
                temp_model = DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoListLiveStreamSnapshotInfo()
                self.live_stream_snapshot_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamSnapshotInfoResponseBody(TeaModel):
    def __init__(
        self,
        live_stream_snapshot_info_list: DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoList = None,
        request_id: str = None,
        next_start_time: str = None,
    ):
        self.live_stream_snapshot_info_list = live_stream_snapshot_info_list
        self.request_id = request_id
        self.next_start_time = next_start_time

    def validate(self):
        if self.live_stream_snapshot_info_list:
            self.live_stream_snapshot_info_list.validate()

    def to_map(self):
        result = dict()
        if self.live_stream_snapshot_info_list is not None:
            result['LiveStreamSnapshotInfoList'] = self.live_stream_snapshot_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_start_time is not None:
            result['NextStartTime'] = self.next_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LiveStreamSnapshotInfoList') is not None:
            temp_model = DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoList()
            self.live_stream_snapshot_info_list = temp_model.from_map(m['LiveStreamSnapshotInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextStartTime') is not None:
            self.next_start_time = m.get('NextStartTime')
        return self


class DescribeLiveStreamSnapshotInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamSnapshotInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamSnapshotInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamsNotifyUrlConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveStreamsNotifyUrlConfigResponseBodyLiveStreamsNotifyConfig(TeaModel):
    def __init__(
        self,
        notify_url: str = None,
        domain_name: str = None,
    ):
        self.notify_url = notify_url
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveStreamsNotifyUrlConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        live_streams_notify_config: DescribeLiveStreamsNotifyUrlConfigResponseBodyLiveStreamsNotifyConfig = None,
    ):
        self.request_id = request_id
        self.live_streams_notify_config = live_streams_notify_config

    def validate(self):
        if self.live_streams_notify_config:
            self.live_streams_notify_config.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.live_streams_notify_config is not None:
            result['LiveStreamsNotifyConfig'] = self.live_streams_notify_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LiveStreamsNotifyConfig') is not None:
            temp_model = DescribeLiveStreamsNotifyUrlConfigResponseBodyLiveStreamsNotifyConfig()
            self.live_streams_notify_config = temp_model.from_map(m['LiveStreamsNotifyConfig'])
        return self


class DescribeLiveStreamsNotifyUrlConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamsNotifyUrlConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamsNotifyUrlConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamsOnlineListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        page_size: int = None,
        page_num: int = None,
        stream_type: str = None,
        start_time: str = None,
        end_time: str = None,
        query_type: str = None,
        order_by: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.page_size = page_size
        self.page_num = page_num
        self.stream_type = stream_type
        self.start_time = start_time
        self.end_time = end_time
        self.query_type = query_type
        self.order_by = order_by

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.stream_type is not None:
            result['StreamType'] = self.stream_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.query_type is not None:
            result['QueryType'] = self.query_type
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('StreamType') is not None:
            self.stream_type = m.get('StreamType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('QueryType') is not None:
            self.query_type = m.get('QueryType')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        return self


class DescribeLiveStreamsOnlineListResponseBodyOnlineInfoLiveStreamOnlineInfo(TeaModel):
    def __init__(
        self,
        publish_url: str = None,
        stream_name: str = None,
        domain_name: str = None,
        publish_domain: str = None,
        app_name: str = None,
        publish_time: str = None,
    ):
        self.publish_url = publish_url
        self.stream_name = stream_name
        self.domain_name = domain_name
        self.publish_domain = publish_domain
        self.app_name = app_name
        self.publish_time = publish_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.publish_url is not None:
            result['PublishUrl'] = self.publish_url
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.publish_domain is not None:
            result['PublishDomain'] = self.publish_domain
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PublishUrl') is not None:
            self.publish_url = m.get('PublishUrl')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('PublishDomain') is not None:
            self.publish_domain = m.get('PublishDomain')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        return self


class DescribeLiveStreamsOnlineListResponseBodyOnlineInfo(TeaModel):
    def __init__(
        self,
        live_stream_online_info: List[DescribeLiveStreamsOnlineListResponseBodyOnlineInfoLiveStreamOnlineInfo] = None,
    ):
        self.live_stream_online_info = live_stream_online_info

    def validate(self):
        if self.live_stream_online_info:
            for k in self.live_stream_online_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamOnlineInfo'] = []
        if self.live_stream_online_info is not None:
            for k in self.live_stream_online_info:
                result['LiveStreamOnlineInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_online_info = []
        if m.get('LiveStreamOnlineInfo') is not None:
            for k in m.get('LiveStreamOnlineInfo'):
                temp_model = DescribeLiveStreamsOnlineListResponseBodyOnlineInfoLiveStreamOnlineInfo()
                self.live_stream_online_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamsOnlineListResponseBody(TeaModel):
    def __init__(
        self,
        total_num: int = None,
        total_page: int = None,
        page_num: int = None,
        page_size: int = None,
        request_id: str = None,
        online_info: DescribeLiveStreamsOnlineListResponseBodyOnlineInfo = None,
    ):
        self.total_num = total_num
        self.total_page = total_page
        self.page_num = page_num
        self.page_size = page_size
        self.request_id = request_id
        self.online_info = online_info

    def validate(self):
        if self.online_info:
            self.online_info.validate()

    def to_map(self):
        result = dict()
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.online_info is not None:
            result['OnlineInfo'] = self.online_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OnlineInfo') is not None:
            temp_model = DescribeLiveStreamsOnlineListResponseBodyOnlineInfo()
            self.online_info = temp_model.from_map(m['OnlineInfo'])
        return self


class DescribeLiveStreamsOnlineListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamsOnlineListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamsOnlineListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamsPublishListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
        stream_type: str = None,
        query_type: str = None,
        order_by: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number
        self.stream_type = stream_type
        self.query_type = query_type
        self.order_by = order_by

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.stream_type is not None:
            result['StreamType'] = self.stream_type
        if self.query_type is not None:
            result['QueryType'] = self.query_type
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('StreamType') is not None:
            self.stream_type = m.get('StreamType')
        if m.get('QueryType') is not None:
            self.query_type = m.get('QueryType')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        return self


class DescribeLiveStreamsPublishListResponseBodyPublishInfoLiveStreamPublishInfo(TeaModel):
    def __init__(
        self,
        edge_node_addr: str = None,
        publish_url: str = None,
        stream_name: str = None,
        stop_time: str = None,
        domain_name: str = None,
        transcode_id: str = None,
        publish_domain: str = None,
        publish_time: str = None,
        app_name: str = None,
        publish_type: str = None,
        transcoded: str = None,
        client_addr: str = None,
        stream_url: str = None,
    ):
        self.edge_node_addr = edge_node_addr
        self.publish_url = publish_url
        self.stream_name = stream_name
        self.stop_time = stop_time
        self.domain_name = domain_name
        self.transcode_id = transcode_id
        self.publish_domain = publish_domain
        self.publish_time = publish_time
        self.app_name = app_name
        self.publish_type = publish_type
        self.transcoded = transcoded
        self.client_addr = client_addr
        self.stream_url = stream_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.edge_node_addr is not None:
            result['EdgeNodeAddr'] = self.edge_node_addr
        if self.publish_url is not None:
            result['PublishUrl'] = self.publish_url
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.transcode_id is not None:
            result['TranscodeId'] = self.transcode_id
        if self.publish_domain is not None:
            result['PublishDomain'] = self.publish_domain
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.publish_type is not None:
            result['PublishType'] = self.publish_type
        if self.transcoded is not None:
            result['Transcoded'] = self.transcoded
        if self.client_addr is not None:
            result['ClientAddr'] = self.client_addr
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EdgeNodeAddr') is not None:
            self.edge_node_addr = m.get('EdgeNodeAddr')
        if m.get('PublishUrl') is not None:
            self.publish_url = m.get('PublishUrl')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('TranscodeId') is not None:
            self.transcode_id = m.get('TranscodeId')
        if m.get('PublishDomain') is not None:
            self.publish_domain = m.get('PublishDomain')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('PublishType') is not None:
            self.publish_type = m.get('PublishType')
        if m.get('Transcoded') is not None:
            self.transcoded = m.get('Transcoded')
        if m.get('ClientAddr') is not None:
            self.client_addr = m.get('ClientAddr')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeLiveStreamsPublishListResponseBodyPublishInfo(TeaModel):
    def __init__(
        self,
        live_stream_publish_info: List[DescribeLiveStreamsPublishListResponseBodyPublishInfoLiveStreamPublishInfo] = None,
    ):
        self.live_stream_publish_info = live_stream_publish_info

    def validate(self):
        if self.live_stream_publish_info:
            for k in self.live_stream_publish_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LiveStreamPublishInfo'] = []
        if self.live_stream_publish_info is not None:
            for k in self.live_stream_publish_info:
                result['LiveStreamPublishInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_stream_publish_info = []
        if m.get('LiveStreamPublishInfo') is not None:
            for k in m.get('LiveStreamPublishInfo'):
                temp_model = DescribeLiveStreamsPublishListResponseBodyPublishInfoLiveStreamPublishInfo()
                self.live_stream_publish_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamsPublishListResponseBody(TeaModel):
    def __init__(
        self,
        total_num: int = None,
        total_page: int = None,
        page_num: int = None,
        page_size: int = None,
        request_id: str = None,
        publish_info: DescribeLiveStreamsPublishListResponseBodyPublishInfo = None,
    ):
        self.total_num = total_num
        self.total_page = total_page
        self.page_num = page_num
        self.page_size = page_size
        self.request_id = request_id
        self.publish_info = publish_info

    def validate(self):
        if self.publish_info:
            self.publish_info.validate()

    def to_map(self):
        result = dict()
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.publish_info is not None:
            result['PublishInfo'] = self.publish_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PublishInfo') is not None:
            temp_model = DescribeLiveStreamsPublishListResponseBodyPublishInfo()
            self.publish_info = temp_model.from_map(m['PublishInfo'])
        return self


class DescribeLiveStreamsPublishListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamsPublishListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamsPublishListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamTranscodeInfoRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_transcode_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_transcode_name = domain_transcode_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_transcode_name is not None:
            result['DomainTranscodeName'] = self.domain_transcode_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainTranscodeName') is not None:
            self.domain_transcode_name = m.get('DomainTranscodeName')
        return self


class DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfoCustomTranscodeParameters(TeaModel):
    def __init__(
        self,
        video_profile: str = None,
        audio_bitrate: int = None,
        height: int = None,
        rts_flag: str = None,
        template_type: str = None,
        bframes: str = None,
        audio_rate: int = None,
        audio_codec: str = None,
        fps: int = None,
        gop: str = None,
        width: int = None,
        video_bitrate: int = None,
        audio_channel_num: int = None,
        audio_profile: str = None,
    ):
        self.video_profile = video_profile
        self.audio_bitrate = audio_bitrate
        self.height = height
        self.rts_flag = rts_flag
        self.template_type = template_type
        self.bframes = bframes
        self.audio_rate = audio_rate
        self.audio_codec = audio_codec
        self.fps = fps
        self.gop = gop
        self.width = width
        self.video_bitrate = video_bitrate
        self.audio_channel_num = audio_channel_num
        self.audio_profile = audio_profile

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.video_profile is not None:
            result['VideoProfile'] = self.video_profile
        if self.audio_bitrate is not None:
            result['AudioBitrate'] = self.audio_bitrate
        if self.height is not None:
            result['Height'] = self.height
        if self.rts_flag is not None:
            result['RtsFlag'] = self.rts_flag
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.bframes is not None:
            result['Bframes'] = self.bframes
        if self.audio_rate is not None:
            result['AudioRate'] = self.audio_rate
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.fps is not None:
            result['FPS'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.audio_channel_num is not None:
            result['AudioChannelNum'] = self.audio_channel_num
        if self.audio_profile is not None:
            result['AudioProfile'] = self.audio_profile
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoProfile') is not None:
            self.video_profile = m.get('VideoProfile')
        if m.get('AudioBitrate') is not None:
            self.audio_bitrate = m.get('AudioBitrate')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('RtsFlag') is not None:
            self.rts_flag = m.get('RtsFlag')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Bframes') is not None:
            self.bframes = m.get('Bframes')
        if m.get('AudioRate') is not None:
            self.audio_rate = m.get('AudioRate')
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('FPS') is not None:
            self.fps = m.get('FPS')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('AudioChannelNum') is not None:
            self.audio_channel_num = m.get('AudioChannelNum')
        if m.get('AudioProfile') is not None:
            self.audio_profile = m.get('AudioProfile')
        return self


class DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfoEncryptParameters(TeaModel):
    def __init__(
        self,
        encrypt_type: str = None,
        kms_key_id: str = None,
        kms_key_expire_interval: str = None,
    ):
        self.encrypt_type = encrypt_type
        self.kms_key_id = kms_key_id
        self.kms_key_expire_interval = kms_key_expire_interval

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.encrypt_type is not None:
            result['EncryptType'] = self.encrypt_type
        if self.kms_key_id is not None:
            result['KmsKeyID'] = self.kms_key_id
        if self.kms_key_expire_interval is not None:
            result['KmsKeyExpireInterval'] = self.kms_key_expire_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EncryptType') is not None:
            self.encrypt_type = m.get('EncryptType')
        if m.get('KmsKeyID') is not None:
            self.kms_key_id = m.get('KmsKeyID')
        if m.get('KmsKeyExpireInterval') is not None:
            self.kms_key_expire_interval = m.get('KmsKeyExpireInterval')
        return self


class DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfo(TeaModel):
    def __init__(
        self,
        custom_transcode_parameters: DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfoCustomTranscodeParameters = None,
        transcode_app: str = None,
        transcode_template: str = None,
        encrypt_parameters: DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfoEncryptParameters = None,
        transcode_name: str = None,
    ):
        self.custom_transcode_parameters = custom_transcode_parameters
        self.transcode_app = transcode_app
        self.transcode_template = transcode_template
        self.encrypt_parameters = encrypt_parameters
        self.transcode_name = transcode_name

    def validate(self):
        if self.custom_transcode_parameters:
            self.custom_transcode_parameters.validate()
        if self.encrypt_parameters:
            self.encrypt_parameters.validate()

    def to_map(self):
        result = dict()
        if self.custom_transcode_parameters is not None:
            result['CustomTranscodeParameters'] = self.custom_transcode_parameters.to_map()
        if self.transcode_app is not None:
            result['TranscodeApp'] = self.transcode_app
        if self.transcode_template is not None:
            result['TranscodeTemplate'] = self.transcode_template
        if self.encrypt_parameters is not None:
            result['EncryptParameters'] = self.encrypt_parameters.to_map()
        if self.transcode_name is not None:
            result['TranscodeName'] = self.transcode_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomTranscodeParameters') is not None:
            temp_model = DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfoCustomTranscodeParameters()
            self.custom_transcode_parameters = temp_model.from_map(m['CustomTranscodeParameters'])
        if m.get('TranscodeApp') is not None:
            self.transcode_app = m.get('TranscodeApp')
        if m.get('TranscodeTemplate') is not None:
            self.transcode_template = m.get('TranscodeTemplate')
        if m.get('EncryptParameters') is not None:
            temp_model = DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfoEncryptParameters()
            self.encrypt_parameters = temp_model.from_map(m['EncryptParameters'])
        if m.get('TranscodeName') is not None:
            self.transcode_name = m.get('TranscodeName')
        return self


class DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeList(TeaModel):
    def __init__(
        self,
        domain_transcode_info: List[DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfo] = None,
    ):
        self.domain_transcode_info = domain_transcode_info

    def validate(self):
        if self.domain_transcode_info:
            for k in self.domain_transcode_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DomainTranscodeInfo'] = []
        if self.domain_transcode_info is not None:
            for k in self.domain_transcode_info:
                result['DomainTranscodeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_transcode_info = []
        if m.get('DomainTranscodeInfo') is not None:
            for k in m.get('DomainTranscodeInfo'):
                temp_model = DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeListDomainTranscodeInfo()
                self.domain_transcode_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamTranscodeInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        domain_transcode_list: DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeList = None,
    ):
        self.request_id = request_id
        self.domain_transcode_list = domain_transcode_list

    def validate(self):
        if self.domain_transcode_list:
            self.domain_transcode_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.domain_transcode_list is not None:
            result['DomainTranscodeList'] = self.domain_transcode_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DomainTranscodeList') is not None:
            temp_model = DescribeLiveStreamTranscodeInfoResponseBodyDomainTranscodeList()
            self.domain_transcode_list = temp_model.from_map(m['DomainTranscodeList'])
        return self


class DescribeLiveStreamTranscodeInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamTranscodeInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamTranscodeInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamTranscodeStreamNumRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveStreamTranscodeStreamNumResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total: int = None,
        transcoded_number: int = None,
        untranscode_number: int = None,
        lazy_transcoded_number: int = None,
    ):
        self.request_id = request_id
        self.total = total
        self.transcoded_number = transcoded_number
        self.untranscode_number = untranscode_number
        self.lazy_transcoded_number = lazy_transcoded_number

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.transcoded_number is not None:
            result['TranscodedNumber'] = self.transcoded_number
        if self.untranscode_number is not None:
            result['UntranscodeNumber'] = self.untranscode_number
        if self.lazy_transcoded_number is not None:
            result['LazyTranscodedNumber'] = self.lazy_transcoded_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('TranscodedNumber') is not None:
            self.transcoded_number = m.get('TranscodedNumber')
        if m.get('UntranscodeNumber') is not None:
            self.untranscode_number = m.get('UntranscodeNumber')
        if m.get('LazyTranscodedNumber') is not None:
            self.lazy_transcoded_number = m.get('LazyTranscodedNumber')
        return self


class DescribeLiveStreamTranscodeStreamNumResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveStreamTranscodeStreamNumResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamTranscodeStreamNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveTagResourcesRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLiveTagResourcesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_id: List[str] = None,
        resource_type: str = None,
        tag: List[DescribeLiveTagResourcesRequestTag] = None,
        scope: str = None,
    ):
        self.owner_id = owner_id
        self.resource_id = resource_id
        self.resource_type = resource_type
        self.tag = tag
        self.scope = scope

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.scope is not None:
            result['Scope'] = self.scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeLiveTagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        return self


class DescribeLiveTagResourcesResponseBodyTagResourcesTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLiveTagResourcesResponseBodyTagResources(TeaModel):
    def __init__(
        self,
        resource_id: str = None,
        tag: List[DescribeLiveTagResourcesResponseBodyTagResourcesTag] = None,
    ):
        self.resource_id = resource_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeLiveTagResourcesResponseBodyTagResourcesTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeLiveTagResourcesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tag_resources: List[DescribeLiveTagResourcesResponseBodyTagResources] = None,
    ):
        self.request_id = request_id
        self.tag_resources = tag_resources

    def validate(self):
        if self.tag_resources:
            for k in self.tag_resources:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TagResources'] = []
        if self.tag_resources is not None:
            for k in self.tag_resources:
                result['TagResources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tag_resources = []
        if m.get('TagResources') is not None:
            for k in m.get('TagResources'):
                temp_model = DescribeLiveTagResourcesResponseBodyTagResources()
                self.tag_resources.append(temp_model.from_map(k))
        return self


class DescribeLiveTagResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveTagResourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveTagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveTopDomainsByFlowRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        start_time: str = None,
        end_time: str = None,
        limit: int = None,
    ):
        self.owner_id = owner_id
        self.start_time = start_time
        self.end_time = end_time
        self.limit = limit

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.limit is not None:
            result['Limit'] = self.limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        return self


class DescribeLiveTopDomainsByFlowResponseBodyTopDomainsTopDomain(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        rank: int = None,
        total_traffic: str = None,
        traffic_percent: str = None,
        max_bps: int = None,
        max_bps_time: str = None,
        total_access: int = None,
    ):
        self.domain_name = domain_name
        self.rank = rank
        self.total_traffic = total_traffic
        self.traffic_percent = traffic_percent
        self.max_bps = max_bps
        self.max_bps_time = max_bps_time
        self.total_access = total_access

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.rank is not None:
            result['Rank'] = self.rank
        if self.total_traffic is not None:
            result['TotalTraffic'] = self.total_traffic
        if self.traffic_percent is not None:
            result['TrafficPercent'] = self.traffic_percent
        if self.max_bps is not None:
            result['MaxBps'] = self.max_bps
        if self.max_bps_time is not None:
            result['MaxBpsTime'] = self.max_bps_time
        if self.total_access is not None:
            result['TotalAccess'] = self.total_access
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Rank') is not None:
            self.rank = m.get('Rank')
        if m.get('TotalTraffic') is not None:
            self.total_traffic = m.get('TotalTraffic')
        if m.get('TrafficPercent') is not None:
            self.traffic_percent = m.get('TrafficPercent')
        if m.get('MaxBps') is not None:
            self.max_bps = m.get('MaxBps')
        if m.get('MaxBpsTime') is not None:
            self.max_bps_time = m.get('MaxBpsTime')
        if m.get('TotalAccess') is not None:
            self.total_access = m.get('TotalAccess')
        return self


class DescribeLiveTopDomainsByFlowResponseBodyTopDomains(TeaModel):
    def __init__(
        self,
        top_domain: List[DescribeLiveTopDomainsByFlowResponseBodyTopDomainsTopDomain] = None,
    ):
        self.top_domain = top_domain

    def validate(self):
        if self.top_domain:
            for k in self.top_domain:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['TopDomain'] = []
        if self.top_domain is not None:
            for k in self.top_domain:
                result['TopDomain'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.top_domain = []
        if m.get('TopDomain') is not None:
            for k in m.get('TopDomain'):
                temp_model = DescribeLiveTopDomainsByFlowResponseBodyTopDomainsTopDomain()
                self.top_domain.append(temp_model.from_map(k))
        return self


class DescribeLiveTopDomainsByFlowResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        start_time: str = None,
        end_time: str = None,
        domain_count: int = None,
        domain_online_count: int = None,
        top_domains: DescribeLiveTopDomainsByFlowResponseBodyTopDomains = None,
    ):
        self.request_id = request_id
        self.start_time = start_time
        self.end_time = end_time
        self.domain_count = domain_count
        self.domain_online_count = domain_online_count
        self.top_domains = top_domains

    def validate(self):
        if self.top_domains:
            self.top_domains.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.domain_count is not None:
            result['DomainCount'] = self.domain_count
        if self.domain_online_count is not None:
            result['DomainOnlineCount'] = self.domain_online_count
        if self.top_domains is not None:
            result['TopDomains'] = self.top_domains.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DomainCount') is not None:
            self.domain_count = m.get('DomainCount')
        if m.get('DomainOnlineCount') is not None:
            self.domain_online_count = m.get('DomainOnlineCount')
        if m.get('TopDomains') is not None:
            temp_model = DescribeLiveTopDomainsByFlowResponseBodyTopDomains()
            self.top_domains = temp_model.from_map(m['TopDomains'])
        return self


class DescribeLiveTopDomainsByFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveTopDomainsByFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveTopDomainsByFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveUserDomainsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLiveUserDomainsRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        live_domain_type: str = None,
        page_size: int = None,
        page_number: int = None,
        domain_name: str = None,
        region_name: str = None,
        domain_search_type: str = None,
        domain_status: str = None,
        tag: List[DescribeLiveUserDomainsRequestTag] = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.live_domain_type = live_domain_type
        self.page_size = page_size
        self.page_number = page_number
        self.domain_name = domain_name
        self.region_name = region_name
        self.domain_search_type = domain_search_type
        self.domain_status = domain_status
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.live_domain_type is not None:
            result['LiveDomainType'] = self.live_domain_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.domain_search_type is not None:
            result['DomainSearchType'] = self.domain_search_type
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('LiveDomainType') is not None:
            self.live_domain_type = m.get('LiveDomainType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('DomainSearchType') is not None:
            self.domain_search_type = m.get('DomainSearchType')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeLiveUserDomainsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeLiveUserDomainsResponseBodyDomainsPageData(TeaModel):
    def __init__(
        self,
        gmt_created: str = None,
        live_domain_type: str = None,
        live_domain_status: str = None,
        region_name: str = None,
        description: str = None,
        cname: str = None,
        gmt_modified: str = None,
        domain_name: str = None,
    ):
        self.gmt_created = gmt_created
        self.live_domain_type = live_domain_type
        self.live_domain_status = live_domain_status
        self.region_name = region_name
        self.description = description
        self.cname = cname
        self.gmt_modified = gmt_modified
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.live_domain_type is not None:
            result['LiveDomainType'] = self.live_domain_type
        if self.live_domain_status is not None:
            result['LiveDomainStatus'] = self.live_domain_status
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.description is not None:
            result['Description'] = self.description
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('LiveDomainType') is not None:
            self.live_domain_type = m.get('LiveDomainType')
        if m.get('LiveDomainStatus') is not None:
            self.live_domain_status = m.get('LiveDomainStatus')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveUserDomainsResponseBodyDomains(TeaModel):
    def __init__(
        self,
        page_data: List[DescribeLiveUserDomainsResponseBodyDomainsPageData] = None,
    ):
        self.page_data = page_data

    def validate(self):
        if self.page_data:
            for k in self.page_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PageData'] = []
        if self.page_data is not None:
            for k in self.page_data:
                result['PageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.page_data = []
        if m.get('PageData') is not None:
            for k in m.get('PageData'):
                temp_model = DescribeLiveUserDomainsResponseBodyDomainsPageData()
                self.page_data.append(temp_model.from_map(k))
        return self


class DescribeLiveUserDomainsResponseBody(TeaModel):
    def __init__(
        self,
        domains: DescribeLiveUserDomainsResponseBodyDomains = None,
        total_count: int = None,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.domains = domains
        self.total_count = total_count
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        if self.domains:
            self.domains.validate()

    def to_map(self):
        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domains') is not None:
            temp_model = DescribeLiveUserDomainsResponseBodyDomains()
            self.domains = temp_model.from_map(m['Domains'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeLiveUserDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveUserDomainsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveUserDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveUserTagsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
    ):
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveUserTagsResponseBodyTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[str] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLiveUserTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tags: List[DescribeLiveUserTagsResponseBodyTags] = None,
    ):
        self.request_id = request_id
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeLiveUserTagsResponseBodyTags()
                self.tags.append(temp_model.from_map(k))
        return self


class DescribeLiveUserTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveUserTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveUserTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveVerifyContentRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveVerifyContentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        content: str = None,
    ):
        self.request_id = request_id
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DescribeLiveVerifyContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLiveVerifyContentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLiveVerifyContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMixStreamListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        mix_stream_id: str = None,
        start_time: str = None,
        end_time: str = None,
        page_no: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.mix_stream_id = mix_stream_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_no = page_no
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeMixStreamListResponseBodyMixStreamList(TeaModel):
    def __init__(
        self,
        mix_stream_template: str = None,
        app_name: str = None,
        layout_id: str = None,
        stream_name: str = None,
        gmt_create: str = None,
        mixstream_id: str = None,
        gmt_modified: str = None,
        input_stream_number: int = None,
        domain_name: str = None,
    ):
        self.mix_stream_template = mix_stream_template
        self.app_name = app_name
        self.layout_id = layout_id
        self.stream_name = stream_name
        self.gmt_create = gmt_create
        self.mixstream_id = mixstream_id
        self.gmt_modified = gmt_modified
        self.input_stream_number = input_stream_number
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.mix_stream_template is not None:
            result['MixStreamTemplate'] = self.mix_stream_template
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.mixstream_id is not None:
            result['MixstreamId'] = self.mixstream_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.input_stream_number is not None:
            result['InputStreamNumber'] = self.input_stream_number
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MixStreamTemplate') is not None:
            self.mix_stream_template = m.get('MixStreamTemplate')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('MixstreamId') is not None:
            self.mixstream_id = m.get('MixstreamId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('InputStreamNumber') is not None:
            self.input_stream_number = m.get('InputStreamNumber')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeMixStreamListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total: int = None,
        mix_stream_list: List[DescribeMixStreamListResponseBodyMixStreamList] = None,
    ):
        self.request_id = request_id
        self.total = total
        self.mix_stream_list = mix_stream_list

    def validate(self):
        if self.mix_stream_list:
            for k in self.mix_stream_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        result['MixStreamList'] = []
        if self.mix_stream_list is not None:
            for k in self.mix_stream_list:
                result['MixStreamList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        self.mix_stream_list = []
        if m.get('MixStreamList') is not None:
            for k in m.get('MixStreamList'):
                temp_model = DescribeMixStreamListResponseBodyMixStreamList()
                self.mix_stream_list.append(temp_model.from_map(k))
        return self


class DescribeMixStreamListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeMixStreamListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMixStreamListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecordRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        record_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.record_id = record_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class DescribeRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        record_id: str = None,
        app_id: str = None,
        board_id: int = None,
        record_start_time: int = None,
        start_time: int = None,
        end_time: int = None,
        state: int = None,
        oss_path: str = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
    ):
        self.request_id = request_id
        self.record_id = record_id
        self.app_id = app_id
        self.board_id = board_id
        self.record_start_time = record_start_time
        self.start_time = start_time
        self.end_time = end_time
        self.state = state
        self.oss_path = oss_path
        self.oss_bucket = oss_bucket
        self.oss_endpoint = oss_endpoint

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        if self.record_start_time is not None:
            result['RecordStartTime'] = self.record_start_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.state is not None:
            result['State'] = self.state
        if self.oss_path is not None:
            result['OssPath'] = self.oss_path
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        if m.get('RecordStartTime') is not None:
            self.record_start_time = m.get('RecordStartTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('OssPath') is not None:
            self.oss_path = m.get('OssPath')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecordsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        page_num: int = None,
        page_size: int = None,
        record_state: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.page_num = page_num
        self.page_size = page_size
        self.record_state = record_state

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_state is not None:
            result['RecordState'] = self.record_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordState') is not None:
            self.record_state = m.get('RecordState')
        return self


class DescribeRecordsResponseBodyRecords(TeaModel):
    def __init__(
        self,
        record_id: str = None,
        app_id: str = None,
        board_id: int = None,
        record_start_time: int = None,
        start_time: int = None,
        end_time: int = None,
        state: int = None,
        oss_path: str = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
    ):
        self.record_id = record_id
        self.app_id = app_id
        self.board_id = board_id
        self.record_start_time = record_start_time
        self.start_time = start_time
        self.end_time = end_time
        self.state = state
        self.oss_path = oss_path
        self.oss_bucket = oss_bucket
        self.oss_endpoint = oss_endpoint

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        if self.record_start_time is not None:
            result['RecordStartTime'] = self.record_start_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.state is not None:
            result['State'] = self.state
        if self.oss_path is not None:
            result['OssPath'] = self.oss_path
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        if m.get('RecordStartTime') is not None:
            self.record_start_time = m.get('RecordStartTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('OssPath') is not None:
            self.oss_path = m.get('OssPath')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        return self


class DescribeRecordsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        records: List[DescribeRecordsResponseBodyRecords] = None,
    ):
        self.request_id = request_id
        self.records = records

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeRecordsResponseBodyRecords()
                self.records.append(temp_model.from_map(k))
        return self


class DescribeRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRecordsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRoomKickoutUserListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
        order: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id
        self.order = order
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeRoomKickoutUserListResponseBodyUserList(TeaModel):
    def __init__(
        self,
        op_end_time: str = None,
        app_uid: str = None,
        op_start_time: str = None,
    ):
        self.op_end_time = op_end_time
        self.app_uid = app_uid
        self.op_start_time = op_start_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.op_end_time is not None:
            result['OpEndTime'] = self.op_end_time
        if self.app_uid is not None:
            result['AppUid'] = self.app_uid
        if self.op_start_time is not None:
            result['OpStartTime'] = self.op_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpEndTime') is not None:
            self.op_end_time = m.get('OpEndTime')
        if m.get('AppUid') is not None:
            self.app_uid = m.get('AppUid')
        if m.get('OpStartTime') is not None:
            self.op_start_time = m.get('OpStartTime')
        return self


class DescribeRoomKickoutUserListResponseBody(TeaModel):
    def __init__(
        self,
        total_num: int = None,
        total_page: int = None,
        request_id: str = None,
        user_list: List[DescribeRoomKickoutUserListResponseBodyUserList] = None,
    ):
        self.total_num = total_num
        self.total_page = total_page
        self.request_id = request_id
        self.user_list = user_list

    def validate(self):
        if self.user_list:
            for k in self.user_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UserList'] = []
        if self.user_list is not None:
            for k in self.user_list:
                result['UserList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.user_list = []
        if m.get('UserList') is not None:
            for k in m.get('UserList'):
                temp_model = DescribeRoomKickoutUserListResponseBodyUserList()
                self.user_list.append(temp_model.from_map(k))
        return self


class DescribeRoomKickoutUserListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRoomKickoutUserListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRoomKickoutUserListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRoomListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
        anchor_id: str = None,
        room_status: int = None,
        start_time: str = None,
        end_time: str = None,
        order: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id
        self.anchor_id = anchor_id
        self.room_status = room_status
        self.start_time = start_time
        self.end_time = end_time
        self.order = order
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.anchor_id is not None:
            result['AnchorId'] = self.anchor_id
        if self.room_status is not None:
            result['RoomStatus'] = self.room_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('AnchorId') is not None:
            self.anchor_id = m.get('AnchorId')
        if m.get('RoomStatus') is not None:
            self.room_status = m.get('RoomStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeRoomListResponseBodyRoomList(TeaModel):
    def __init__(
        self,
        anchor_id: str = None,
        create_time: str = None,
        forbid_stream: str = None,
        room_id: str = None,
        room_status: int = None,
    ):
        self.anchor_id = anchor_id
        self.create_time = create_time
        self.forbid_stream = forbid_stream
        self.room_id = room_id
        self.room_status = room_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.anchor_id is not None:
            result['AnchorId'] = self.anchor_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.forbid_stream is not None:
            result['ForbidStream'] = self.forbid_stream
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.room_status is not None:
            result['RoomStatus'] = self.room_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnchorId') is not None:
            self.anchor_id = m.get('AnchorId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ForbidStream') is not None:
            self.forbid_stream = m.get('ForbidStream')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('RoomStatus') is not None:
            self.room_status = m.get('RoomStatus')
        return self


class DescribeRoomListResponseBody(TeaModel):
    def __init__(
        self,
        total_num: int = None,
        total_page: int = None,
        request_id: str = None,
        room_list: List[DescribeRoomListResponseBodyRoomList] = None,
    ):
        self.total_num = total_num
        self.total_page = total_page
        self.request_id = request_id
        self.room_list = room_list

    def validate(self):
        if self.room_list:
            for k in self.room_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RoomList'] = []
        if self.room_list is not None:
            for k in self.room_list:
                result['RoomList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.room_list = []
        if m.get('RoomList') is not None:
            for k in m.get('RoomList'):
                temp_model = DescribeRoomListResponseBodyRoomList()
                self.room_list.append(temp_model.from_map(k))
        return self


class DescribeRoomListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRoomListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRoomListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRoomStatusRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class DescribeRoomStatusResponseBody(TeaModel):
    def __init__(
        self,
        room_status: int = None,
        request_id: str = None,
    ):
        self.room_status = room_status
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.room_status is not None:
            result['RoomStatus'] = self.room_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoomStatus') is not None:
            self.room_status = m.get('RoomStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRoomStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRoomStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRoomStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUpBpsPeakDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        start_time: str = None,
        end_time: str = None,
        domain_switch: str = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.start_time = start_time
        self.end_time = end_time
        self.domain_switch = domain_switch
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.domain_switch is not None:
            result['DomainSwitch'] = self.domain_switch
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DomainSwitch') is not None:
            self.domain_switch = m.get('DomainSwitch')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeUpBpsPeakDataResponseBodyDescribeUpPeakTrafficsDescribeUpPeakTraffic(TeaModel):
    def __init__(
        self,
        peak_time: str = None,
        query_time: str = None,
        stat_name: str = None,
        band_width: str = None,
    ):
        self.peak_time = peak_time
        self.query_time = query_time
        self.stat_name = stat_name
        self.band_width = band_width

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.peak_time is not None:
            result['PeakTime'] = self.peak_time
        if self.query_time is not None:
            result['QueryTime'] = self.query_time
        if self.stat_name is not None:
            result['StatName'] = self.stat_name
        if self.band_width is not None:
            result['BandWidth'] = self.band_width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PeakTime') is not None:
            self.peak_time = m.get('PeakTime')
        if m.get('QueryTime') is not None:
            self.query_time = m.get('QueryTime')
        if m.get('StatName') is not None:
            self.stat_name = m.get('StatName')
        if m.get('BandWidth') is not None:
            self.band_width = m.get('BandWidth')
        return self


class DescribeUpBpsPeakDataResponseBodyDescribeUpPeakTraffics(TeaModel):
    def __init__(
        self,
        describe_up_peak_traffic: List[DescribeUpBpsPeakDataResponseBodyDescribeUpPeakTrafficsDescribeUpPeakTraffic] = None,
    ):
        self.describe_up_peak_traffic = describe_up_peak_traffic

    def validate(self):
        if self.describe_up_peak_traffic:
            for k in self.describe_up_peak_traffic:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DescribeUpPeakTraffic'] = []
        if self.describe_up_peak_traffic is not None:
            for k in self.describe_up_peak_traffic:
                result['DescribeUpPeakTraffic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.describe_up_peak_traffic = []
        if m.get('DescribeUpPeakTraffic') is not None:
            for k in m.get('DescribeUpPeakTraffic'):
                temp_model = DescribeUpBpsPeakDataResponseBodyDescribeUpPeakTrafficsDescribeUpPeakTraffic()
                self.describe_up_peak_traffic.append(temp_model.from_map(k))
        return self


class DescribeUpBpsPeakDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        describe_up_peak_traffics: DescribeUpBpsPeakDataResponseBodyDescribeUpPeakTraffics = None,
    ):
        self.request_id = request_id
        self.describe_up_peak_traffics = describe_up_peak_traffics

    def validate(self):
        if self.describe_up_peak_traffics:
            self.describe_up_peak_traffics.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.describe_up_peak_traffics is not None:
            result['DescribeUpPeakTraffics'] = self.describe_up_peak_traffics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DescribeUpPeakTraffics') is not None:
            temp_model = DescribeUpBpsPeakDataResponseBodyDescribeUpPeakTraffics()
            self.describe_up_peak_traffics = temp_model.from_map(m['DescribeUpPeakTraffics'])
        return self


class DescribeUpBpsPeakDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUpBpsPeakDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUpBpsPeakDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUpBpsPeakOfLineRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        start_time: str = None,
        end_time: str = None,
        line: str = None,
        domain_switch: str = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.start_time = start_time
        self.end_time = end_time
        self.line = line
        self.domain_switch = domain_switch
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.line is not None:
            result['Line'] = self.line
        if self.domain_switch is not None:
            result['DomainSwitch'] = self.domain_switch
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('DomainSwitch') is not None:
            self.domain_switch = m.get('DomainSwitch')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeUpBpsPeakOfLineResponseBodyDescribeUpBpsPeakOfLinesDescribeUpBpsPeakOfLine(TeaModel):
    def __init__(
        self,
        band_width: float = None,
        peak_time: str = None,
        query_time: str = None,
        stat_name: str = None,
    ):
        self.band_width = band_width
        self.peak_time = peak_time
        self.query_time = query_time
        self.stat_name = stat_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.band_width is not None:
            result['BandWidth'] = self.band_width
        if self.peak_time is not None:
            result['PeakTime'] = self.peak_time
        if self.query_time is not None:
            result['QueryTime'] = self.query_time
        if self.stat_name is not None:
            result['StatName'] = self.stat_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandWidth') is not None:
            self.band_width = m.get('BandWidth')
        if m.get('PeakTime') is not None:
            self.peak_time = m.get('PeakTime')
        if m.get('QueryTime') is not None:
            self.query_time = m.get('QueryTime')
        if m.get('StatName') is not None:
            self.stat_name = m.get('StatName')
        return self


class DescribeUpBpsPeakOfLineResponseBodyDescribeUpBpsPeakOfLines(TeaModel):
    def __init__(
        self,
        describe_up_bps_peak_of_line: List[DescribeUpBpsPeakOfLineResponseBodyDescribeUpBpsPeakOfLinesDescribeUpBpsPeakOfLine] = None,
    ):
        self.describe_up_bps_peak_of_line = describe_up_bps_peak_of_line

    def validate(self):
        if self.describe_up_bps_peak_of_line:
            for k in self.describe_up_bps_peak_of_line:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DescribeUpBpsPeakOfLine'] = []
        if self.describe_up_bps_peak_of_line is not None:
            for k in self.describe_up_bps_peak_of_line:
                result['DescribeUpBpsPeakOfLine'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.describe_up_bps_peak_of_line = []
        if m.get('DescribeUpBpsPeakOfLine') is not None:
            for k in m.get('DescribeUpBpsPeakOfLine'):
                temp_model = DescribeUpBpsPeakOfLineResponseBodyDescribeUpBpsPeakOfLinesDescribeUpBpsPeakOfLine()
                self.describe_up_bps_peak_of_line.append(temp_model.from_map(k))
        return self


class DescribeUpBpsPeakOfLineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        describe_up_bps_peak_of_lines: DescribeUpBpsPeakOfLineResponseBodyDescribeUpBpsPeakOfLines = None,
    ):
        self.request_id = request_id
        self.describe_up_bps_peak_of_lines = describe_up_bps_peak_of_lines

    def validate(self):
        if self.describe_up_bps_peak_of_lines:
            self.describe_up_bps_peak_of_lines.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.describe_up_bps_peak_of_lines is not None:
            result['DescribeUpBpsPeakOfLines'] = self.describe_up_bps_peak_of_lines.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DescribeUpBpsPeakOfLines') is not None:
            temp_model = DescribeUpBpsPeakOfLineResponseBodyDescribeUpBpsPeakOfLines()
            self.describe_up_bps_peak_of_lines = temp_model.from_map(m['DescribeUpBpsPeakOfLines'])
        return self


class DescribeUpBpsPeakOfLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUpBpsPeakOfLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUpBpsPeakOfLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUpPeakPublishStreamDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        start_time: str = None,
        end_time: str = None,
        domain_switch: str = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.start_time = start_time
        self.end_time = end_time
        self.domain_switch = domain_switch
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.domain_switch is not None:
            result['DomainSwitch'] = self.domain_switch
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DomainSwitch') is not None:
            self.domain_switch = m.get('DomainSwitch')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeUpPeakPublishStreamDataResponseBodyDescribeUpPeakPublishStreamDatasDescribeUpPeakPublishStreamData(TeaModel):
    def __init__(
        self,
        publish_stream_num: int = None,
        peak_time: str = None,
        query_time: str = None,
        stat_name: str = None,
        band_width: str = None,
    ):
        self.publish_stream_num = publish_stream_num
        self.peak_time = peak_time
        self.query_time = query_time
        self.stat_name = stat_name
        self.band_width = band_width

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.publish_stream_num is not None:
            result['PublishStreamNum'] = self.publish_stream_num
        if self.peak_time is not None:
            result['PeakTime'] = self.peak_time
        if self.query_time is not None:
            result['QueryTime'] = self.query_time
        if self.stat_name is not None:
            result['StatName'] = self.stat_name
        if self.band_width is not None:
            result['BandWidth'] = self.band_width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PublishStreamNum') is not None:
            self.publish_stream_num = m.get('PublishStreamNum')
        if m.get('PeakTime') is not None:
            self.peak_time = m.get('PeakTime')
        if m.get('QueryTime') is not None:
            self.query_time = m.get('QueryTime')
        if m.get('StatName') is not None:
            self.stat_name = m.get('StatName')
        if m.get('BandWidth') is not None:
            self.band_width = m.get('BandWidth')
        return self


class DescribeUpPeakPublishStreamDataResponseBodyDescribeUpPeakPublishStreamDatas(TeaModel):
    def __init__(
        self,
        describe_up_peak_publish_stream_data: List[DescribeUpPeakPublishStreamDataResponseBodyDescribeUpPeakPublishStreamDatasDescribeUpPeakPublishStreamData] = None,
    ):
        self.describe_up_peak_publish_stream_data = describe_up_peak_publish_stream_data

    def validate(self):
        if self.describe_up_peak_publish_stream_data:
            for k in self.describe_up_peak_publish_stream_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DescribeUpPeakPublishStreamData'] = []
        if self.describe_up_peak_publish_stream_data is not None:
            for k in self.describe_up_peak_publish_stream_data:
                result['DescribeUpPeakPublishStreamData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.describe_up_peak_publish_stream_data = []
        if m.get('DescribeUpPeakPublishStreamData') is not None:
            for k in m.get('DescribeUpPeakPublishStreamData'):
                temp_model = DescribeUpPeakPublishStreamDataResponseBodyDescribeUpPeakPublishStreamDatasDescribeUpPeakPublishStreamData()
                self.describe_up_peak_publish_stream_data.append(temp_model.from_map(k))
        return self


class DescribeUpPeakPublishStreamDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        describe_up_peak_publish_stream_datas: DescribeUpPeakPublishStreamDataResponseBodyDescribeUpPeakPublishStreamDatas = None,
    ):
        self.request_id = request_id
        self.describe_up_peak_publish_stream_datas = describe_up_peak_publish_stream_datas

    def validate(self):
        if self.describe_up_peak_publish_stream_datas:
            self.describe_up_peak_publish_stream_datas.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.describe_up_peak_publish_stream_datas is not None:
            result['DescribeUpPeakPublishStreamDatas'] = self.describe_up_peak_publish_stream_datas.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DescribeUpPeakPublishStreamDatas') is not None:
            temp_model = DescribeUpPeakPublishStreamDataResponseBodyDescribeUpPeakPublishStreamDatas()
            self.describe_up_peak_publish_stream_datas = temp_model.from_map(m['DescribeUpPeakPublishStreamDatas'])
        return self


class DescribeUpPeakPublishStreamDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUpPeakPublishStreamDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUpPeakPublishStreamDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableLiveRealtimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DisableLiveRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableLiveRealtimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableLiveRealtimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableLiveRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditHtmlResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        html_resource_id: str = None,
        caster_id: str = None,
        html_url: str = None,
        html_content: str = None,
        config: str = None,
    ):
        self.owner_id = owner_id
        self.html_resource_id = html_resource_id
        self.caster_id = caster_id
        self.html_url = html_url
        self.html_content = html_content
        self.config = config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.html_resource_id is not None:
            result['HtmlResourceId'] = self.html_resource_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.html_url is not None:
            result['HtmlUrl'] = self.html_url
        if self.html_content is not None:
            result['htmlContent'] = self.html_content
        if self.config is not None:
            result['Config'] = self.config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('HtmlResourceId') is not None:
            self.html_resource_id = m.get('HtmlResourceId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('HtmlUrl') is not None:
            self.html_url = m.get('HtmlUrl')
        if m.get('htmlContent') is not None:
            self.html_content = m.get('htmlContent')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        return self


class EditHtmlResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        html_resource_id: str = None,
    ):
        self.request_id = request_id
        self.html_resource_id = html_resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.html_resource_id is not None:
            result['HtmlResourceId'] = self.html_resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HtmlResourceId') is not None:
            self.html_resource_id = m.get('HtmlResourceId')
        return self


class EditHtmlResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EditHtmlResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EditHtmlResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EffectCasterUrgentRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        scene_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.scene_id = scene_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        return self


class EffectCasterUrgentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EffectCasterUrgentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EffectCasterUrgentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EffectCasterUrgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EffectCasterVideoResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        scene_id: str = None,
        resource_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.scene_id = scene_id
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class EffectCasterVideoResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EffectCasterVideoResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EffectCasterVideoResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EffectCasterVideoResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableLiveRealtimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class EnableLiveRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableLiveRealtimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableLiveRealtimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableLiveRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ForbidLiveStreamRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        live_stream_type: str = None,
        oneshot: str = None,
        control_stream_action: str = None,
        resume_time: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.live_stream_type = live_stream_type
        self.oneshot = oneshot
        self.control_stream_action = control_stream_action
        self.resume_time = resume_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.live_stream_type is not None:
            result['LiveStreamType'] = self.live_stream_type
        if self.oneshot is not None:
            result['Oneshot'] = self.oneshot
        if self.control_stream_action is not None:
            result['ControlStreamAction'] = self.control_stream_action
        if self.resume_time is not None:
            result['ResumeTime'] = self.resume_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('LiveStreamType') is not None:
            self.live_stream_type = m.get('LiveStreamType')
        if m.get('Oneshot') is not None:
            self.oneshot = m.get('Oneshot')
        if m.get('ControlStreamAction') is not None:
            self.control_stream_action = m.get('ControlStreamAction')
        if m.get('ResumeTime') is not None:
            self.resume_time = m.get('ResumeTime')
        return self


class ForbidLiveStreamResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ForbidLiveStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ForbidLiveStreamResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ForbidLiveStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ForbidPushStreamRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
        user_data: str = None,
        end_time: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id
        self.user_data = user_data
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class ForbidPushStreamResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ForbidPushStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ForbidPushStreamResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ForbidPushStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class JoinBoardRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        app_uid: str = None,
        board_id: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.app_uid = app_uid
        self.board_id = board_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_uid is not None:
            result['AppUid'] = self.app_uid
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppUid') is not None:
            self.app_uid = m.get('AppUid')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        return self


class JoinBoardResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        token: str = None,
        board_id: str = None,
        topic_id: str = None,
        keepalive_topic: str = None,
        keepalive_interval: int = None,
    ):
        self.request_id = request_id
        self.token = token
        self.board_id = board_id
        self.topic_id = topic_id
        self.keepalive_topic = keepalive_topic
        self.keepalive_interval = keepalive_interval

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.token is not None:
            result['Token'] = self.token
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.keepalive_topic is not None:
            result['KeepaliveTopic'] = self.keepalive_topic
        if self.keepalive_interval is not None:
            result['KeepaliveInterval'] = self.keepalive_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('KeepaliveTopic') is not None:
            self.keepalive_topic = m.get('KeepaliveTopic')
        if m.get('KeepaliveInterval') is not None:
            self.keepalive_interval = m.get('KeepaliveInterval')
        return self


class JoinBoardResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: JoinBoardResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = JoinBoardResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveRealtimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        live_openapi_reserve: str = None,
    ):
        self.owner_id = owner_id
        self.live_openapi_reserve = live_openapi_reserve

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.live_openapi_reserve is not None:
            result['LiveOpenapiReserve'] = self.live_openapi_reserve
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('LiveOpenapiReserve') is not None:
            self.live_openapi_reserve = m.get('LiveOpenapiReserve')
        return self


class ListLiveRealtimeLogDeliveryResponseBodyContentRealtimeLogDeliveryInfo(TeaModel):
    def __init__(
        self,
        project: str = None,
        logstore: str = None,
        region: str = None,
        domain_name: str = None,
        dm_id: int = None,
        status: str = None,
    ):
        self.project = project
        self.logstore = logstore
        self.region = region
        self.domain_name = domain_name
        self.dm_id = dm_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.project is not None:
            result['Project'] = self.project
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.region is not None:
            result['Region'] = self.region
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.dm_id is not None:
            result['DmId'] = self.dm_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DmId') is not None:
            self.dm_id = m.get('DmId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListLiveRealtimeLogDeliveryResponseBodyContent(TeaModel):
    def __init__(
        self,
        realtime_log_delivery_info: List[ListLiveRealtimeLogDeliveryResponseBodyContentRealtimeLogDeliveryInfo] = None,
    ):
        self.realtime_log_delivery_info = realtime_log_delivery_info

    def validate(self):
        if self.realtime_log_delivery_info:
            for k in self.realtime_log_delivery_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RealtimeLogDeliveryInfo'] = []
        if self.realtime_log_delivery_info is not None:
            for k in self.realtime_log_delivery_info:
                result['RealtimeLogDeliveryInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.realtime_log_delivery_info = []
        if m.get('RealtimeLogDeliveryInfo') is not None:
            for k in m.get('RealtimeLogDeliveryInfo'):
                temp_model = ListLiveRealtimeLogDeliveryResponseBodyContentRealtimeLogDeliveryInfo()
                self.realtime_log_delivery_info.append(temp_model.from_map(k))
        return self


class ListLiveRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        content: ListLiveRealtimeLogDeliveryResponseBodyContent = None,
    ):
        self.request_id = request_id
        self.content = content

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.content is not None:
            result['Content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Content') is not None:
            temp_model = ListLiveRealtimeLogDeliveryResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        return self


class ListLiveRealtimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListLiveRealtimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLiveRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveRealtimeLogDeliveryDomainsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        project: str = None,
        logstore: str = None,
        region: str = None,
    ):
        self.owner_id = owner_id
        self.project = project
        self.logstore = logstore
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class ListLiveRealtimeLogDeliveryDomainsResponseBodyContentDomains(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        status: str = None,
    ):
        self.domain_name = domain_name
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListLiveRealtimeLogDeliveryDomainsResponseBodyContent(TeaModel):
    def __init__(
        self,
        domains: List[ListLiveRealtimeLogDeliveryDomainsResponseBodyContentDomains] = None,
    ):
        self.domains = domains

    def validate(self):
        if self.domains:
            for k in self.domains:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Domains'] = []
        if self.domains is not None:
            for k in self.domains:
                result['Domains'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domains = []
        if m.get('Domains') is not None:
            for k in m.get('Domains'):
                temp_model = ListLiveRealtimeLogDeliveryDomainsResponseBodyContentDomains()
                self.domains.append(temp_model.from_map(k))
        return self


class ListLiveRealtimeLogDeliveryDomainsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        content: ListLiveRealtimeLogDeliveryDomainsResponseBodyContent = None,
    ):
        self.request_id = request_id
        self.content = content

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.content is not None:
            result['Content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Content') is not None:
            temp_model = ListLiveRealtimeLogDeliveryDomainsResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        return self


class ListLiveRealtimeLogDeliveryDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListLiveRealtimeLogDeliveryDomainsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLiveRealtimeLogDeliveryDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveRealtimeLogDeliveryInfosRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        live_openapi_reserve: str = None,
    ):
        self.owner_id = owner_id
        self.live_openapi_reserve = live_openapi_reserve

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.live_openapi_reserve is not None:
            result['LiveOpenapiReserve'] = self.live_openapi_reserve
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('LiveOpenapiReserve') is not None:
            self.live_openapi_reserve = m.get('LiveOpenapiReserve')
        return self


class ListLiveRealtimeLogDeliveryInfosResponseBodyContentRealtimeLogDeliveryInfos(TeaModel):
    def __init__(
        self,
        project: str = None,
        logstore: str = None,
        region: str = None,
    ):
        self.project = project
        self.logstore = logstore
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.project is not None:
            result['Project'] = self.project
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class ListLiveRealtimeLogDeliveryInfosResponseBodyContent(TeaModel):
    def __init__(
        self,
        realtime_log_delivery_infos: List[ListLiveRealtimeLogDeliveryInfosResponseBodyContentRealtimeLogDeliveryInfos] = None,
    ):
        self.realtime_log_delivery_infos = realtime_log_delivery_infos

    def validate(self):
        if self.realtime_log_delivery_infos:
            for k in self.realtime_log_delivery_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RealtimeLogDeliveryInfos'] = []
        if self.realtime_log_delivery_infos is not None:
            for k in self.realtime_log_delivery_infos:
                result['RealtimeLogDeliveryInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.realtime_log_delivery_infos = []
        if m.get('RealtimeLogDeliveryInfos') is not None:
            for k in m.get('RealtimeLogDeliveryInfos'):
                temp_model = ListLiveRealtimeLogDeliveryInfosResponseBodyContentRealtimeLogDeliveryInfos()
                self.realtime_log_delivery_infos.append(temp_model.from_map(k))
        return self


class ListLiveRealtimeLogDeliveryInfosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        content: ListLiveRealtimeLogDeliveryInfosResponseBodyContent = None,
    ):
        self.request_id = request_id
        self.content = content

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.content is not None:
            result['Content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Content') is not None:
            temp_model = ListLiveRealtimeLogDeliveryInfosResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        return self


class ListLiveRealtimeLogDeliveryInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListLiveRealtimeLogDeliveryInfosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLiveRealtimeLogDeliveryInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCasterComponentRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        component_id: str = None,
        component_name: str = None,
        component_type: str = None,
        effect: str = None,
        component_layer: str = None,
        text_layer_content: str = None,
        image_layer_content: str = None,
        caption_layer_content: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.component_id = component_id
        self.component_name = component_name
        self.component_type = component_type
        self.effect = effect
        self.component_layer = component_layer
        self.text_layer_content = text_layer_content
        self.image_layer_content = image_layer_content
        self.caption_layer_content = caption_layer_content

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.component_layer is not None:
            result['ComponentLayer'] = self.component_layer
        if self.text_layer_content is not None:
            result['TextLayerContent'] = self.text_layer_content
        if self.image_layer_content is not None:
            result['ImageLayerContent'] = self.image_layer_content
        if self.caption_layer_content is not None:
            result['CaptionLayerContent'] = self.caption_layer_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('ComponentLayer') is not None:
            self.component_layer = m.get('ComponentLayer')
        if m.get('TextLayerContent') is not None:
            self.text_layer_content = m.get('TextLayerContent')
        if m.get('ImageLayerContent') is not None:
            self.image_layer_content = m.get('ImageLayerContent')
        if m.get('CaptionLayerContent') is not None:
            self.caption_layer_content = m.get('CaptionLayerContent')
        return self


class ModifyCasterComponentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        component_id: str = None,
    ):
        self.request_id = request_id
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class ModifyCasterComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyCasterComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyCasterComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCasterEpisodeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        episode_id: str = None,
        episode_name: str = None,
        resource_id: str = None,
        start_time: str = None,
        end_time: str = None,
        switch_type: str = None,
        component_id: List[str] = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.episode_id = episode_id
        self.episode_name = episode_name
        self.resource_id = resource_id
        self.start_time = start_time
        self.end_time = end_time
        self.switch_type = switch_type
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class ModifyCasterEpisodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        episode_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.episode_id = episode_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class ModifyCasterEpisodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyCasterEpisodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyCasterEpisodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCasterLayoutRequestVideoLayer(TeaModel):
    def __init__(
        self,
        fixed_delay_duration: int = None,
        height_normalized: float = None,
        fill_mode: str = None,
        position_refer: str = None,
        position_normalized: List[int] = None,
        width_normalized: float = None,
    ):
        self.fixed_delay_duration = fixed_delay_duration
        self.height_normalized = height_normalized
        self.fill_mode = fill_mode
        self.position_refer = position_refer
        self.position_normalized = position_normalized
        self.width_normalized = width_normalized

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.fill_mode is not None:
            result['FillMode'] = self.fill_mode
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.position_normalized is not None:
            result['PositionNormalized'] = self.position_normalized
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('FillMode') is not None:
            self.fill_mode = m.get('FillMode')
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('PositionNormalized') is not None:
            self.position_normalized = m.get('PositionNormalized')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class ModifyCasterLayoutRequestAudioLayer(TeaModel):
    def __init__(
        self,
        volume_rate: float = None,
        fixed_delay_duration: int = None,
        valid_channel: str = None,
    ):
        self.volume_rate = volume_rate
        self.fixed_delay_duration = fixed_delay_duration
        self.valid_channel = valid_channel

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        return self


class ModifyCasterLayoutRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        layout_id: str = None,
        video_layer: List[ModifyCasterLayoutRequestVideoLayer] = None,
        audio_layer: List[ModifyCasterLayoutRequestAudioLayer] = None,
        blend_list: List[str] = None,
        mix_list: List[str] = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.layout_id = layout_id
        self.video_layer = video_layer
        self.audio_layer = audio_layer
        self.blend_list = blend_list
        self.mix_list = mix_list

    def validate(self):
        if self.video_layer:
            for k in self.video_layer:
                if k:
                    k.validate()
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        result['VideoLayer'] = []
        if self.video_layer is not None:
            for k in self.video_layer:
                result['VideoLayer'].append(k.to_map() if k else None)
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        if self.blend_list is not None:
            result['BlendList'] = self.blend_list
        if self.mix_list is not None:
            result['MixList'] = self.mix_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        self.video_layer = []
        if m.get('VideoLayer') is not None:
            for k in m.get('VideoLayer'):
                temp_model = ModifyCasterLayoutRequestVideoLayer()
                self.video_layer.append(temp_model.from_map(k))
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = ModifyCasterLayoutRequestAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        if m.get('BlendList') is not None:
            self.blend_list = m.get('BlendList')
        if m.get('MixList') is not None:
            self.mix_list = m.get('MixList')
        return self


class ModifyCasterLayoutResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        layout_id: str = None,
    ):
        self.request_id = request_id
        self.layout_id = layout_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        return self


class ModifyCasterLayoutResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyCasterLayoutResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyCasterLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCasterProgramRequestEpisode(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        start_time: str = None,
        episode_name: str = None,
        episode_type: str = None,
        episode_id: str = None,
        resource_id: str = None,
        component_id: List[str] = None,
        switch_type: str = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.episode_name = episode_name
        self.episode_type = episode_type
        self.episode_id = episode_id
        self.resource_id = resource_id
        self.component_id = component_id
        self.switch_type = switch_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        return self


class ModifyCasterProgramRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        episode: List[ModifyCasterProgramRequestEpisode] = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.episode = episode

    def validate(self):
        if self.episode:
            for k in self.episode:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        result['Episode'] = []
        if self.episode is not None:
            for k in self.episode:
                result['Episode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        self.episode = []
        if m.get('Episode') is not None:
            for k in m.get('Episode'):
                temp_model = ModifyCasterProgramRequestEpisode()
                self.episode.append(temp_model.from_map(k))
        return self


class ModifyCasterProgramResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class ModifyCasterProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyCasterProgramResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCasterVideoResourceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        resource_id: str = None,
        resource_name: str = None,
        live_stream_url: str = None,
        material_id: str = None,
        vod_url: str = None,
        begin_offset: int = None,
        end_offset: int = None,
        repeat_num: int = None,
        pts_callback_interval: int = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.resource_id = resource_id
        self.resource_name = resource_name
        self.live_stream_url = live_stream_url
        self.material_id = material_id
        self.vod_url = vod_url
        self.begin_offset = begin_offset
        self.end_offset = end_offset
        self.repeat_num = repeat_num
        self.pts_callback_interval = pts_callback_interval

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.live_stream_url is not None:
            result['LiveStreamUrl'] = self.live_stream_url
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        if self.begin_offset is not None:
            result['BeginOffset'] = self.begin_offset
        if self.end_offset is not None:
            result['EndOffset'] = self.end_offset
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.pts_callback_interval is not None:
            result['PtsCallbackInterval'] = self.pts_callback_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('LiveStreamUrl') is not None:
            self.live_stream_url = m.get('LiveStreamUrl')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        if m.get('BeginOffset') is not None:
            self.begin_offset = m.get('BeginOffset')
        if m.get('EndOffset') is not None:
            self.end_offset = m.get('EndOffset')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('PtsCallbackInterval') is not None:
            self.pts_callback_interval = m.get('PtsCallbackInterval')
        return self


class ModifyCasterVideoResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.resource_id = resource_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class ModifyCasterVideoResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyCasterVideoResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyCasterVideoResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyLiveDomainSchdmByPropertyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        property: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.property = property

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.property is not None:
            result['Property'] = self.property
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        return self


class ModifyLiveDomainSchdmByPropertyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyLiveDomainSchdmByPropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyLiveDomainSchdmByPropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyLiveDomainSchdmByPropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyLiveRealtimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        project: str = None,
        logstore: str = None,
        region: str = None,
        domain_name: str = None,
    ):
        self.owner_id = owner_id
        self.project = project
        self.logstore = logstore
        self.region = region
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.region is not None:
            result['Region'] = self.region
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class ModifyLiveRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyLiveRealtimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyLiveRealtimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyLiveRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RealTimeRecordCommandRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        command: str = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.owner_id = owner_id
        self.command = command
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.command is not None:
            result['Command'] = self.command
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class RealTimeRecordCommandResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RealTimeRecordCommandResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RealTimeRecordCommandResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RealTimeRecordCommandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RealTimeSnapshotCommandRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        command: str = None,
        domain_name: str = None,
        app_name: str = None,
        stream_name: str = None,
        mode: int = None,
        interval: int = None,
    ):
        self.owner_id = owner_id
        self.command = command
        self.domain_name = domain_name
        self.app_name = app_name
        self.stream_name = stream_name
        self.mode = mode
        self.interval = interval

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.command is not None:
            result['Command'] = self.command
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class RealTimeSnapshotCommandResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RealTimeSnapshotCommandResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RealTimeSnapshotCommandResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RealTimeSnapshotCommandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResumeLiveStreamRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        domain_name: str = None,
        live_stream_type: str = None,
        app_name: str = None,
        stream_name: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.live_stream_type = live_stream_type
        self.app_name = app_name
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_stream_type is not None:
            result['LiveStreamType'] = self.live_stream_type
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveStreamType') is not None:
            self.live_stream_type = m.get('LiveStreamType')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class ResumeLiveStreamResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ResumeLiveStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ResumeLiveStreamResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResumeLiveStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendRoomNotificationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
        app_uid: str = None,
        data: str = None,
        priority: int = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id
        self.app_uid = app_uid
        self.data = data
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.app_uid is not None:
            result['AppUid'] = self.app_uid
        if self.data is not None:
            result['Data'] = self.data
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('AppUid') is not None:
            self.app_uid = m.get('AppUid')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class SendRoomNotificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        message_id: str = None,
    ):
        self.request_id = request_id
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class SendRoomNotificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SendRoomNotificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SendRoomNotificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendRoomUserNotificationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        room_id: str = None,
        app_uid: str = None,
        to_app_uid: str = None,
        data: str = None,
        priority: int = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.room_id = room_id
        self.app_uid = app_uid
        self.to_app_uid = to_app_uid
        self.data = data
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.app_uid is not None:
            result['AppUid'] = self.app_uid
        if self.to_app_uid is not None:
            result['ToAppUid'] = self.to_app_uid
        if self.data is not None:
            result['Data'] = self.data
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('AppUid') is not None:
            self.app_uid = m.get('AppUid')
        if m.get('ToAppUid') is not None:
            self.to_app_uid = m.get('ToAppUid')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class SendRoomUserNotificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        message_id: str = None,
    ):
        self.request_id = request_id
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class SendRoomUserNotificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SendRoomUserNotificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SendRoomUserNotificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetBoardCallbackRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        auth_key: str = None,
        auth_switch: str = None,
        callback_enable: int = None,
        callback_uri: str = None,
        callback_events: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.auth_key = auth_key
        self.auth_switch = auth_switch
        self.callback_enable = callback_enable
        self.callback_uri = callback_uri
        self.callback_events = callback_events

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        if self.auth_switch is not None:
            result['AuthSwitch'] = self.auth_switch
        if self.callback_enable is not None:
            result['CallbackEnable'] = self.callback_enable
        if self.callback_uri is not None:
            result['CallbackUri'] = self.callback_uri
        if self.callback_events is not None:
            result['CallbackEvents'] = self.callback_events
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        if m.get('AuthSwitch') is not None:
            self.auth_switch = m.get('AuthSwitch')
        if m.get('CallbackEnable') is not None:
            self.callback_enable = m.get('CallbackEnable')
        if m.get('CallbackUri') is not None:
            self.callback_uri = m.get('CallbackUri')
        if m.get('CallbackEvents') is not None:
            self.callback_events = m.get('CallbackEvents')
        return self


class SetBoardCallbackResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetBoardCallbackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetBoardCallbackResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetBoardCallbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetCasterChannelRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        channel_id: str = None,
        resource_id: str = None,
        seek_offset: int = None,
        play_status: int = None,
        reload_flag: int = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.channel_id = channel_id
        self.resource_id = resource_id
        self.seek_offset = seek_offset
        self.play_status = play_status
        self.reload_flag = reload_flag

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.seek_offset is not None:
            result['SeekOffset'] = self.seek_offset
        if self.play_status is not None:
            result['PlayStatus'] = self.play_status
        if self.reload_flag is not None:
            result['ReloadFlag'] = self.reload_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('SeekOffset') is not None:
            self.seek_offset = m.get('SeekOffset')
        if m.get('PlayStatus') is not None:
            self.play_status = m.get('PlayStatus')
        if m.get('ReloadFlag') is not None:
            self.reload_flag = m.get('ReloadFlag')
        return self


class SetCasterChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetCasterChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetCasterChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetCasterChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetCasterConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        caster_name: str = None,
        domain_name: str = None,
        transcode_config: str = None,
        record_config: str = None,
        delay: float = None,
        urgent_material_id: str = None,
        side_output_url: str = None,
        callback_url: str = None,
        program_effect: int = None,
        program_name: str = None,
        channel_enable: int = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.caster_name = caster_name
        self.domain_name = domain_name
        self.transcode_config = transcode_config
        self.record_config = record_config
        self.delay = delay
        self.urgent_material_id = urgent_material_id
        self.side_output_url = side_output_url
        self.callback_url = callback_url
        self.program_effect = program_effect
        self.program_name = program_name
        self.channel_enable = channel_enable

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config
        if self.record_config is not None:
            result['RecordConfig'] = self.record_config
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.urgent_material_id is not None:
            result['UrgentMaterialId'] = self.urgent_material_id
        if self.side_output_url is not None:
            result['SideOutputUrl'] = self.side_output_url
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.program_effect is not None:
            result['ProgramEffect'] = self.program_effect
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.channel_enable is not None:
            result['ChannelEnable'] = self.channel_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('TranscodeConfig') is not None:
            self.transcode_config = m.get('TranscodeConfig')
        if m.get('RecordConfig') is not None:
            self.record_config = m.get('RecordConfig')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('UrgentMaterialId') is not None:
            self.urgent_material_id = m.get('UrgentMaterialId')
        if m.get('SideOutputUrl') is not None:
            self.side_output_url = m.get('SideOutputUrl')
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('ProgramEffect') is not None:
            self.program_effect = m.get('ProgramEffect')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('ChannelEnable') is not None:
            self.channel_enable = m.get('ChannelEnable')
        return self


class SetCasterConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        caster_id: str = None,
    ):
        self.request_id = request_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class SetCasterConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetCasterConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetCasterConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetCasterSceneConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        scene_id: str = None,
        layout_id: str = None,
        component_id: List[str] = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.scene_id = scene_id
        self.layout_id = layout_id
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class SetCasterSceneConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetCasterSceneConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetCasterSceneConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetCasterSceneConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetCasterSyncGroupRequestSyncGroup(TeaModel):
    def __init__(
        self,
        mode: int = None,
        sync_delay_threshold: int = None,
        host_resource_id: str = None,
        resource_ids: List[str] = None,
    ):
        self.mode = mode
        self.sync_delay_threshold = sync_delay_threshold
        self.host_resource_id = host_resource_id
        self.resource_ids = resource_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.sync_delay_threshold is not None:
            result['SyncDelayThreshold'] = self.sync_delay_threshold
        if self.host_resource_id is not None:
            result['HostResourceId'] = self.host_resource_id
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('SyncDelayThreshold') is not None:
            self.sync_delay_threshold = m.get('SyncDelayThreshold')
        if m.get('HostResourceId') is not None:
            self.host_resource_id = m.get('HostResourceId')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        return self


class SetCasterSyncGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
        sync_group: List[SetCasterSyncGroupRequestSyncGroup] = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id
        self.sync_group = sync_group

    def validate(self):
        if self.sync_group:
            for k in self.sync_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        result['SyncGroup'] = []
        if self.sync_group is not None:
            for k in self.sync_group:
                result['SyncGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        self.sync_group = []
        if m.get('SyncGroup') is not None:
            for k in m.get('SyncGroup'):
                temp_model = SetCasterSyncGroupRequestSyncGroup()
                self.sync_group.append(temp_model.from_map(k))
        return self


class SetCasterSyncGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetCasterSyncGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetCasterSyncGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetCasterSyncGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetLiveDomainCertificateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        security_token: str = None,
        domain_name: str = None,
        cert_name: str = None,
        cert_type: str = None,
        sslprotocol: str = None,
        sslpub: str = None,
        sslpri: str = None,
        force_set: str = None,
    ):
        self.owner_id = owner_id
        self.security_token = security_token
        self.domain_name = domain_name
        self.cert_name = cert_name
        self.cert_type = cert_type
        self.sslprotocol = sslprotocol
        self.sslpub = sslpub
        self.sslpri = sslpri
        self.force_set = force_set

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert_type is not None:
            result['CertType'] = self.cert_type
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.sslpri is not None:
            result['SSLPri'] = self.sslpri
        if self.force_set is not None:
            result['ForceSet'] = self.force_set
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CertType') is not None:
            self.cert_type = m.get('CertType')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('SSLPri') is not None:
            self.sslpri = m.get('SSLPri')
        if m.get('ForceSet') is not None:
            self.force_set = m.get('ForceSet')
        return self


class SetLiveDomainCertificateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetLiveDomainCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetLiveDomainCertificateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetLiveDomainCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetLiveLazyPullStreamInfoConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        app_name: str = None,
        pull_domain_name: str = None,
        pull_app_name: str = None,
        pull_protocol: str = None,
        pull_auth_type: str = None,
        pull_auth_key: str = None,
        pull_args: str = None,
        liveapi_request_from: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.app_name = app_name
        self.pull_domain_name = pull_domain_name
        self.pull_app_name = pull_app_name
        self.pull_protocol = pull_protocol
        self.pull_auth_type = pull_auth_type
        self.pull_auth_key = pull_auth_key
        self.pull_args = pull_args
        self.liveapi_request_from = liveapi_request_from

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.pull_domain_name is not None:
            result['PullDomainName'] = self.pull_domain_name
        if self.pull_app_name is not None:
            result['PullAppName'] = self.pull_app_name
        if self.pull_protocol is not None:
            result['PullProtocol'] = self.pull_protocol
        if self.pull_auth_type is not None:
            result['PullAuthType'] = self.pull_auth_type
        if self.pull_auth_key is not None:
            result['PullAuthKey'] = self.pull_auth_key
        if self.pull_args is not None:
            result['PullArgs'] = self.pull_args
        if self.liveapi_request_from is not None:
            result['LiveapiRequestFrom'] = self.liveapi_request_from
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('PullDomainName') is not None:
            self.pull_domain_name = m.get('PullDomainName')
        if m.get('PullAppName') is not None:
            self.pull_app_name = m.get('PullAppName')
        if m.get('PullProtocol') is not None:
            self.pull_protocol = m.get('PullProtocol')
        if m.get('PullAuthType') is not None:
            self.pull_auth_type = m.get('PullAuthType')
        if m.get('PullAuthKey') is not None:
            self.pull_auth_key = m.get('PullAuthKey')
        if m.get('PullArgs') is not None:
            self.pull_args = m.get('PullArgs')
        if m.get('LiveapiRequestFrom') is not None:
            self.liveapi_request_from = m.get('LiveapiRequestFrom')
        return self


class SetLiveLazyPullStreamInfoConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetLiveLazyPullStreamInfoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetLiveLazyPullStreamInfoConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetLiveLazyPullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetLiveStreamDelayConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        hls_delay: int = None,
        hls_level: str = None,
        flv_delay: int = None,
        flv_level: str = None,
        rtmp_delay: int = None,
        rtmp_level: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.hls_delay = hls_delay
        self.hls_level = hls_level
        self.flv_delay = flv_delay
        self.flv_level = flv_level
        self.rtmp_delay = rtmp_delay
        self.rtmp_level = rtmp_level

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.hls_delay is not None:
            result['HlsDelay'] = self.hls_delay
        if self.hls_level is not None:
            result['HlsLevel'] = self.hls_level
        if self.flv_delay is not None:
            result['FlvDelay'] = self.flv_delay
        if self.flv_level is not None:
            result['FlvLevel'] = self.flv_level
        if self.rtmp_delay is not None:
            result['RtmpDelay'] = self.rtmp_delay
        if self.rtmp_level is not None:
            result['RtmpLevel'] = self.rtmp_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('HlsDelay') is not None:
            self.hls_delay = m.get('HlsDelay')
        if m.get('HlsLevel') is not None:
            self.hls_level = m.get('HlsLevel')
        if m.get('FlvDelay') is not None:
            self.flv_delay = m.get('FlvDelay')
        if m.get('FlvLevel') is not None:
            self.flv_level = m.get('FlvLevel')
        if m.get('RtmpDelay') is not None:
            self.rtmp_delay = m.get('RtmpDelay')
        if m.get('RtmpLevel') is not None:
            self.rtmp_level = m.get('RtmpLevel')
        return self


class SetLiveStreamDelayConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetLiveStreamDelayConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetLiveStreamDelayConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetLiveStreamDelayConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetLiveStreamOptimizedFeatureConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        config_name: str = None,
        config_status: str = None,
        config_value: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.config_name = config_name
        self.config_status = config_status
        self.config_value = config_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.config_status is not None:
            result['ConfigStatus'] = self.config_status
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ConfigStatus') is not None:
            self.config_status = m.get('ConfigStatus')
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        return self


class SetLiveStreamOptimizedFeatureConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetLiveStreamOptimizedFeatureConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetLiveStreamOptimizedFeatureConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetLiveStreamOptimizedFeatureConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetLiveStreamsNotifyUrlConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        domain_name: str = None,
        notify_url: str = None,
        notify_type: str = None,
        auth_type: str = None,
        auth_key: str = None,
    ):
        self.owner_id = owner_id
        self.domain_name = domain_name
        self.notify_url = notify_url
        self.notify_type = notify_type
        self.auth_type = auth_type
        self.auth_key = auth_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        return self


class SetLiveStreamsNotifyUrlConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetLiveStreamsNotifyUrlConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SetLiveStreamsNotifyUrlConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetLiveStreamsNotifyUrlConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartBoardRecordRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        app_id: str = None,
        board_id: str = None,
        start_time: str = None,
    ):
        self.owner_id = owner_id
        self.app_id = app_id
        self.board_id = board_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.board_id is not None:
            result['BoardId'] = self.board_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BoardId') is not None:
            self.board_id = m.get('BoardId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class StartBoardRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        record_id: str = None,
    ):
        self.request_id = request_id
        self.record_id = record_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class StartBoardRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StartBoardRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StartBoardRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartCasterRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        caster_id: str = None,
    ):
        self.owner_id = owner_id
        self.caster_id = caster_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        return self


class StartCasterResponseBodyPvwSceneInfosSceneInfo(TeaModel):
    def __init__(
        self,
        scene_id: str = None,
        stream_url: str = None,
    ):
        self.scene_id = scene_id
        self.stream_url = stream_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class StartCasterResponseBodyPvwSceneInfos(TeaModel):
    def __init__(
        self,
        scene_info: List[StartCasterResponseBodyPvwSceneInfosSceneInfo] = None,
    ):
        self.scene_info = scene_info

    def validate(self):
        if self.scene_info:
            for k in self.scene_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SceneInfo'] = []
        if self.scene_info is not None:
            for k in self.scene_info:
                result['SceneInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.scene_info = []
        if m.get('SceneInfo') is not None:
            for k in m.get('SceneInfo'):
                temp_model = StartCasterResponseBodyPvwSceneInfosSceneInfo()
                self.scene_info.append(temp_model.from_map(k))
        return self


class StartCasterResponseBodyPgmSceneInfosSceneInfoStreamInfosStreamInfo(TeaModel):
    def __init__(
        self,
        video_format: str = None,
        output_stream_url: str = None,
        transcode_config: str = None,
    ):
        self.video_format = video_format
        self.output_stream_url = output_stream_url
        self.transcode_config = transcode_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.video_format is not None:
            result['VideoFormat'] = self.video_format
        if self.output_stream_url is not None:
            result['OutputStreamUrl'] = self.output_stream_url
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoFormat') is not None:
            self.video_format = m.get('VideoFormat')
        if m.get('OutputStreamUrl') is not None:
            self.output_stream_url = m.get('OutputStreamUrl')
        if m.get('TranscodeConfig') is not None:
            self.transcode_config = m.get('TranscodeConfig')
        return self


class StartCasterResponseBodyPgmSceneInfosSceneInfoStreamInfos(TeaModel):
    def __init__(
        self,
        stream_info: List[StartCasterResponseBodyPgmSceneInfosSceneInfoStreamInfosStreamInfo] = None,
    ):
        self.stream_info = stream_info

    def validate(self):
        if self.stream_info:
            for k in self.stream_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['StreamInfo'] = []
        if self.stream_info is not None:
            for k in self.stream_info:
                result['StreamInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_info = []
        if m.get('StreamInfo') is not None:
            for k in m.get('StreamInfo'):
                temp_model = StartCasterResponseBodyPgmSceneInfosSceneInfoStreamInfosStreamInfo()
                self.stream_info.append(temp_model.from_map(k))
        return self


class StartCasterResponseBodyPgmSceneInfosSceneInfo(TeaModel):
    def __init__(
        self,
        stream_infos: StartCasterResponseBodyPgmSceneInfosSceneInfoStreamInfos = None,
        scene_id: str = None,
        stream_url: str = None,
    ):
        self.stream_infos = stream_infos
        self.scene_id = scene_id
        self.stream_url = stream_url

    def validate(self):
        if self.stream_infos:
            self.stream_infos.validate()

    def to_map(self):
        result = dict()
        if self.stream_infos is not None:
            result['StreamInfos'] = self.stream_infos.to_map()
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StreamInfos') is not None:
            temp_model = StartCasterResponseBodyPgmSceneInfosSceneInfoStreamInfos()
            self.stream_infos = temp_model.from_map(m['StreamInfos'])
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class StartCasterResponseBodyPgmSceneInfos(TeaModel):
    def __init__(
        self,
        scene_info: List[StartCasterResponseBodyPgmSceneInfosSceneInfo] = None,
    ):
        self.scene_info = scene_info

    def validate(self):
        if self.scene_info:
            for k in self.scene_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SceneInfo'] = []
        if self.scene_info is not None:
            for k in self.scene_info:
                result['SceneInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.scene_info = []
        if m.get('SceneInfo') is not None:
            for k in m.get('SceneInfo'):
                temp_model = StartCasterResponseBodyPgmSceneInfosSceneInfo()
                self.scene_info.append(temp_model.from_map(k))
        return self


class StartCasterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        pvw_scene_infos: StartCasterResponseBodyPvwSceneInfos = None,
        pgm_scene_infos: StartCasterResponseBodyPgmSceneInfos = Non