"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptClientSourceCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const fs_extra_1 = require("fs-extra");
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const utils_1 = require("./utils");
const languages_1 = require("../../languages");
const logger = log4js_1.getLogger();
/**
 * Generates the typescript client using OpenAPI Generator
 */
class GeneratedTypescriptClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            // Generate the typescript client
            logger.debug("Generating typescript client...");
            utils_1.invokeOpenApiGenerator({
                generator: "typescript-fetch",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.TYPESCRIPT,
                additionalProperties: {
                    npmName: this.project.package.packageName,
                    typescriptThreePlus: "true",
                    useSingleParameter: "true",
                    supportsES6: "true",
                },
            });
            // Write an index.ts which exposes the additional generated file OperationConfig.ts, which contains handler wrappers
            // and other generated code used by the construct.
            fs_extra_1.writeFileSync(path.join(this.project.outdir, "src", "index.ts"), [
                "/* tslint:disable */",
                "/* eslint-disable */",
                "export * from './runtime';",
                "export * from './apis';",
                "export * from './models';",
                "export * from './apis/DefaultApi/OperationConfig';",
            ].join("\n"));
        }
    }
}
exports.GeneratedTypescriptClientSourceCode = GeneratedTypescriptClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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