"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyApiGatewayTsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const open_api_gateway_ts_project_1 = require("./open-api-gateway-ts-project");
const setup_smithy_build_1 = require("./smithy/setup-smithy-build");
/**
 * Synthesizes a Typescript Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-ts
 */
class SmithyApiGatewayTsProject extends open_api_gateway_ts_project_1.OpenApiGatewayTsProject {
    constructor(options) {
        super(options);
        /**
         * The directory in which the smithy model files reside
         */
        this.modelDir = "model";
    }
    preConstruct(options) {
        const { modelDir, generatedSpecFilePath } = setup_smithy_build_1.setupSmithyBuild(this, 
        // Options are the same as those in the constructor, so it is safe to cast to SmithyApiGatewayProjectOptions
        options);
        // @ts-ignore this method is called by the constructor
        this.modelDir = modelDir;
        return {
            ...options,
            specFile: generatedSpecFilePath,
        };
    }
}
exports.SmithyApiGatewayTsProject = SmithyApiGatewayTsProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyApiGatewayTsProject[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject", version: "0.12.2" };
//# sourceMappingURL=data:application/json;base64,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