import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
/**
 * Properties for a GolangFunction
 */
export interface GolangFunctionProps extends lambda.FunctionOptions {
    /**
     * Path to the entry Golang source file.
     *
     * @default - Derived from the name of the defining file and the construct's id.
     * If the `GolangFunction` is defined in `stack.ts` with `my-handler` as id
     * (`new GolangFunction(this, 'my-handler')`), the construct will look at `stack/my-handler/main.go`
     */
    readonly entry?: string;
    /**
     * The name of the exported handler in the entry file.
     *
     * @default main
     */
    readonly handler?: string;
    /**
     * The build directory
     *
     * @default - `.build` in the entry file directory
     */
    readonly buildDir?: string;
    /**
     * The build command
     *
     * @default - `go build -ldflags="-s -w"`
     */
    readonly buildCmd?: string;
    /**
     * Additional environment variables
     *
     * @default - `{ GOOS: 'linux' }`
     */
    readonly extraEnv?: any;
}
/**
 * A Node.js Lambda function bundled using Parcel
 */
export declare class GolangFunction extends lambda.Function {
    constructor(scope: cdk.Construct, id: string, props?: GolangFunctionProps);
}
