"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-cdk/core");
const tasks = require("@aws-cdk/aws-stepfunctions-tasks");
const lambda = require("@aws-cdk/aws-lambda");
const core_3 = require("@aws-solutions-constructs/core");
const stepfunctions = require("@aws-cdk/aws-stepfunctions");
const core_4 = require("@aws-solutions-constructs/core");
const aws_events_1 = require("@aws-cdk/aws-events");
const app = new core_1.App();
const stack = new core_1.Stack(app, core_4.generateIntegStackName(__filename));
const submitLambda = core_3.deployLambdaFunction(stack, {
    runtime: lambda.Runtime.NODEJS_12_X,
    code: lambda.Code.fromAsset(`${__dirname}/lambda`),
    handler: 'index.handler'
});
const submitJob = new tasks.LambdaInvoke(stack, 'LambdaTask', {
    lambdaFunction: submitLambda
});
const startState = new stepfunctions.Pass(stack, 'StartState');
startState.next(submitJob);
const existingEventBus = new aws_events_1.EventBus(stack, `existing-event-bus`, {});
const props = {
    stateMachineProps: {
        definition: startState,
        timeout: core_2.Duration.minutes(5)
    },
    eventRuleProps: {
        eventPattern: {
            source: ['solutionsconstructs']
        }
    },
    existingEventBusInterface: existingEventBus,
    logGroupProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY
    },
};
new lib_1.EventsRuleToStepFunction(stack, 'test-eventsrule-stepfunctions-new-eventbus-construct', props);
app.synth();
//# sourceMappingURL=data:application/json;base64,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