# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProcessorDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'group': 'str',
        'artifact': 'str',
        'version': 'str',
        'type': 'str',
        'type_description': 'str',
        'build_info': 'BuildInfo',
        'provided_api_implementations': 'list[DefinedType]',
        'tags': 'list[str]',
        'deprecated': 'bool',
        'deprecation_reason': 'str',
        'restricted': 'bool',
        'restricted_explanation': 'str',
        'explicit_restrictions': 'list[Restriction]',
        'property_descriptors': 'dict(str, PropertyDescriptor)',
        'supports_dynamic_properties': 'bool',
        'input_requirement': 'str',
        'supported_relationships': 'list[Relationship]',
        'supports_dynamic_relationships': 'bool',
        'trigger_serially': 'bool',
        'trigger_when_empty': 'bool',
        'trigger_when_any_destination_available': 'bool',
        'supports_batching': 'bool',
        'supports_event_driven': 'bool',
        'primary_node_only': 'bool',
        'side_effect_free': 'bool',
        'supported_scheduling_strategies': 'list[str]',
        'default_scheduling_strategy': 'str',
        'default_concurrent_tasks_by_scheduling_strategy': 'dict(str, int)',
        'default_scheduling_period_by_scheduling_strategy': 'dict(str, str)',
        'default_penalty_duration': 'str',
        'default_yield_duration': 'str',
        'default_bulletin_level': 'str'
    }

    attribute_map = {
        'group': 'group',
        'artifact': 'artifact',
        'version': 'version',
        'type': 'type',
        'type_description': 'typeDescription',
        'build_info': 'buildInfo',
        'provided_api_implementations': 'providedApiImplementations',
        'tags': 'tags',
        'deprecated': 'deprecated',
        'deprecation_reason': 'deprecationReason',
        'restricted': 'restricted',
        'restricted_explanation': 'restrictedExplanation',
        'explicit_restrictions': 'explicitRestrictions',
        'property_descriptors': 'propertyDescriptors',
        'supports_dynamic_properties': 'supportsDynamicProperties',
        'input_requirement': 'inputRequirement',
        'supported_relationships': 'supportedRelationships',
        'supports_dynamic_relationships': 'supportsDynamicRelationships',
        'trigger_serially': 'triggerSerially',
        'trigger_when_empty': 'triggerWhenEmpty',
        'trigger_when_any_destination_available': 'triggerWhenAnyDestinationAvailable',
        'supports_batching': 'supportsBatching',
        'supports_event_driven': 'supportsEventDriven',
        'primary_node_only': 'primaryNodeOnly',
        'side_effect_free': 'sideEffectFree',
        'supported_scheduling_strategies': 'supportedSchedulingStrategies',
        'default_scheduling_strategy': 'defaultSchedulingStrategy',
        'default_concurrent_tasks_by_scheduling_strategy': 'defaultConcurrentTasksBySchedulingStrategy',
        'default_scheduling_period_by_scheduling_strategy': 'defaultSchedulingPeriodBySchedulingStrategy',
        'default_penalty_duration': 'defaultPenaltyDuration',
        'default_yield_duration': 'defaultYieldDuration',
        'default_bulletin_level': 'defaultBulletinLevel'
    }

    def __init__(self, group=None, artifact=None, version=None, type=None, type_description=None, build_info=None, provided_api_implementations=None, tags=None, deprecated=None, deprecation_reason=None, restricted=None, restricted_explanation=None, explicit_restrictions=None, property_descriptors=None, supports_dynamic_properties=None, input_requirement=None, supported_relationships=None, supports_dynamic_relationships=None, trigger_serially=None, trigger_when_empty=None, trigger_when_any_destination_available=None, supports_batching=None, supports_event_driven=None, primary_node_only=None, side_effect_free=None, supported_scheduling_strategies=None, default_scheduling_strategy=None, default_concurrent_tasks_by_scheduling_strategy=None, default_scheduling_period_by_scheduling_strategy=None, default_penalty_duration=None, default_yield_duration=None, default_bulletin_level=None):
        """
        ProcessorDefinition - a model defined in Swagger
        """

        self._group = None
        self._artifact = None
        self._version = None
        self._type = None
        self._type_description = None
        self._build_info = None
        self._provided_api_implementations = None
        self._tags = None
        self._deprecated = None
        self._deprecation_reason = None
        self._restricted = None
        self._restricted_explanation = None
        self._explicit_restrictions = None
        self._property_descriptors = None
        self._supports_dynamic_properties = None
        self._input_requirement = None
        self._supported_relationships = None
        self._supports_dynamic_relationships = None
        self._trigger_serially = None
        self._trigger_when_empty = None
        self._trigger_when_any_destination_available = None
        self._supports_batching = None
        self._supports_event_driven = None
        self._primary_node_only = None
        self._side_effect_free = None
        self._supported_scheduling_strategies = None
        self._default_scheduling_strategy = None
        self._default_concurrent_tasks_by_scheduling_strategy = None
        self._default_scheduling_period_by_scheduling_strategy = None
        self._default_penalty_duration = None
        self._default_yield_duration = None
        self._default_bulletin_level = None

        if group is not None:
          self.group = group
        if artifact is not None:
          self.artifact = artifact
        if version is not None:
          self.version = version
        self.type = type
        if type_description is not None:
          self.type_description = type_description
        if build_info is not None:
          self.build_info = build_info
        if provided_api_implementations is not None:
          self.provided_api_implementations = provided_api_implementations
        if tags is not None:
          self.tags = tags
        if deprecated is not None:
          self.deprecated = deprecated
        if deprecation_reason is not None:
          self.deprecation_reason = deprecation_reason
        if restricted is not None:
          self.restricted = restricted
        if restricted_explanation is not None:
          self.restricted_explanation = restricted_explanation
        if explicit_restrictions is not None:
          self.explicit_restrictions = explicit_restrictions
        if property_descriptors is not None:
          self.property_descriptors = property_descriptors
        if supports_dynamic_properties is not None:
          self.supports_dynamic_properties = supports_dynamic_properties
        if input_requirement is not None:
          self.input_requirement = input_requirement
        if supported_relationships is not None:
          self.supported_relationships = supported_relationships
        if supports_dynamic_relationships is not None:
          self.supports_dynamic_relationships = supports_dynamic_relationships
        if trigger_serially is not None:
          self.trigger_serially = trigger_serially
        if trigger_when_empty is not None:
          self.trigger_when_empty = trigger_when_empty
        if trigger_when_any_destination_available is not None:
          self.trigger_when_any_destination_available = trigger_when_any_destination_available
        if supports_batching is not None:
          self.supports_batching = supports_batching
        if supports_event_driven is not None:
          self.supports_event_driven = supports_event_driven
        if primary_node_only is not None:
          self.primary_node_only = primary_node_only
        if side_effect_free is not None:
          self.side_effect_free = side_effect_free
        if supported_scheduling_strategies is not None:
          self.supported_scheduling_strategies = supported_scheduling_strategies
        if default_scheduling_strategy is not None:
          self.default_scheduling_strategy = default_scheduling_strategy
        if default_concurrent_tasks_by_scheduling_strategy is not None:
          self.default_concurrent_tasks_by_scheduling_strategy = default_concurrent_tasks_by_scheduling_strategy
        if default_scheduling_period_by_scheduling_strategy is not None:
          self.default_scheduling_period_by_scheduling_strategy = default_scheduling_period_by_scheduling_strategy
        if default_penalty_duration is not None:
          self.default_penalty_duration = default_penalty_duration
        if default_yield_duration is not None:
          self.default_yield_duration = default_yield_duration
        if default_bulletin_level is not None:
          self.default_bulletin_level = default_bulletin_level

    @property
    def group(self):
        """
        Gets the group of this ProcessorDefinition.
        The group name of the bundle that provides the referenced type.

        :return: The group of this ProcessorDefinition.
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """
        Sets the group of this ProcessorDefinition.
        The group name of the bundle that provides the referenced type.

        :param group: The group of this ProcessorDefinition.
        :type: str
        """

        self._group = group

    @property
    def artifact(self):
        """
        Gets the artifact of this ProcessorDefinition.
        The artifact name of the bundle that provides the referenced type.

        :return: The artifact of this ProcessorDefinition.
        :rtype: str
        """
        return self._artifact

    @artifact.setter
    def artifact(self, artifact):
        """
        Sets the artifact of this ProcessorDefinition.
        The artifact name of the bundle that provides the referenced type.

        :param artifact: The artifact of this ProcessorDefinition.
        :type: str
        """

        self._artifact = artifact

    @property
    def version(self):
        """
        Gets the version of this ProcessorDefinition.
        The version of the bundle that provides the referenced type.

        :return: The version of this ProcessorDefinition.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ProcessorDefinition.
        The version of the bundle that provides the referenced type.

        :param version: The version of this ProcessorDefinition.
        :type: str
        """

        self._version = version

    @property
    def type(self):
        """
        Gets the type of this ProcessorDefinition.
        The fully-qualified class type

        :return: The type of this ProcessorDefinition.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ProcessorDefinition.
        The fully-qualified class type

        :param type: The type of this ProcessorDefinition.
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")

        self._type = type

    @property
    def type_description(self):
        """
        Gets the type_description of this ProcessorDefinition.
        The description of the type.

        :return: The type_description of this ProcessorDefinition.
        :rtype: str
        """
        return self._type_description

    @type_description.setter
    def type_description(self, type_description):
        """
        Sets the type_description of this ProcessorDefinition.
        The description of the type.

        :param type_description: The type_description of this ProcessorDefinition.
        :type: str
        """

        self._type_description = type_description

    @property
    def build_info(self):
        """
        Gets the build_info of this ProcessorDefinition.
        The build metadata for this component

        :return: The build_info of this ProcessorDefinition.
        :rtype: BuildInfo
        """
        return self._build_info

    @build_info.setter
    def build_info(self, build_info):
        """
        Sets the build_info of this ProcessorDefinition.
        The build metadata for this component

        :param build_info: The build_info of this ProcessorDefinition.
        :type: BuildInfo
        """

        self._build_info = build_info

    @property
    def provided_api_implementations(self):
        """
        Gets the provided_api_implementations of this ProcessorDefinition.
        If this type represents a provider for an interface, this lists the APIs it implements

        :return: The provided_api_implementations of this ProcessorDefinition.
        :rtype: list[DefinedType]
        """
        return self._provided_api_implementations

    @provided_api_implementations.setter
    def provided_api_implementations(self, provided_api_implementations):
        """
        Sets the provided_api_implementations of this ProcessorDefinition.
        If this type represents a provider for an interface, this lists the APIs it implements

        :param provided_api_implementations: The provided_api_implementations of this ProcessorDefinition.
        :type: list[DefinedType]
        """

        self._provided_api_implementations = provided_api_implementations

    @property
    def tags(self):
        """
        Gets the tags of this ProcessorDefinition.
        The tags associated with this type

        :return: The tags of this ProcessorDefinition.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ProcessorDefinition.
        The tags associated with this type

        :param tags: The tags of this ProcessorDefinition.
        :type: list[str]
        """

        self._tags = tags

    @property
    def deprecated(self):
        """
        Gets the deprecated of this ProcessorDefinition.
        Whether or not the component has been deprecated

        :return: The deprecated of this ProcessorDefinition.
        :rtype: bool
        """
        return self._deprecated

    @deprecated.setter
    def deprecated(self, deprecated):
        """
        Sets the deprecated of this ProcessorDefinition.
        Whether or not the component has been deprecated

        :param deprecated: The deprecated of this ProcessorDefinition.
        :type: bool
        """

        self._deprecated = deprecated

    @property
    def deprecation_reason(self):
        """
        Gets the deprecation_reason of this ProcessorDefinition.
        If this component has been deprecated, this optional field can be used to provide an explanation

        :return: The deprecation_reason of this ProcessorDefinition.
        :rtype: str
        """
        return self._deprecation_reason

    @deprecation_reason.setter
    def deprecation_reason(self, deprecation_reason):
        """
        Sets the deprecation_reason of this ProcessorDefinition.
        If this component has been deprecated, this optional field can be used to provide an explanation

        :param deprecation_reason: The deprecation_reason of this ProcessorDefinition.
        :type: str
        """

        self._deprecation_reason = deprecation_reason

    @property
    def restricted(self):
        """
        Gets the restricted of this ProcessorDefinition.
        Whether or not the component has a general restriction

        :return: The restricted of this ProcessorDefinition.
        :rtype: bool
        """
        return self._restricted

    @restricted.setter
    def restricted(self, restricted):
        """
        Sets the restricted of this ProcessorDefinition.
        Whether or not the component has a general restriction

        :param restricted: The restricted of this ProcessorDefinition.
        :type: bool
        """

        self._restricted = restricted

    @property
    def restricted_explanation(self):
        """
        Gets the restricted_explanation of this ProcessorDefinition.
        An optional description of the general restriction

        :return: The restricted_explanation of this ProcessorDefinition.
        :rtype: str
        """
        return self._restricted_explanation

    @restricted_explanation.setter
    def restricted_explanation(self, restricted_explanation):
        """
        Sets the restricted_explanation of this ProcessorDefinition.
        An optional description of the general restriction

        :param restricted_explanation: The restricted_explanation of this ProcessorDefinition.
        :type: str
        """

        self._restricted_explanation = restricted_explanation

    @property
    def explicit_restrictions(self):
        """
        Gets the explicit_restrictions of this ProcessorDefinition.
        Explicit restrictions that indicate a require permission to use the component

        :return: The explicit_restrictions of this ProcessorDefinition.
        :rtype: list[Restriction]
        """
        return self._explicit_restrictions

    @explicit_restrictions.setter
    def explicit_restrictions(self, explicit_restrictions):
        """
        Sets the explicit_restrictions of this ProcessorDefinition.
        Explicit restrictions that indicate a require permission to use the component

        :param explicit_restrictions: The explicit_restrictions of this ProcessorDefinition.
        :type: list[Restriction]
        """

        self._explicit_restrictions = explicit_restrictions

    @property
    def property_descriptors(self):
        """
        Gets the property_descriptors of this ProcessorDefinition.
        Descriptions of configuration properties applicable to this component.

        :return: The property_descriptors of this ProcessorDefinition.
        :rtype: dict(str, PropertyDescriptor)
        """
        return self._property_descriptors

    @property_descriptors.setter
    def property_descriptors(self, property_descriptors):
        """
        Sets the property_descriptors of this ProcessorDefinition.
        Descriptions of configuration properties applicable to this component.

        :param property_descriptors: The property_descriptors of this ProcessorDefinition.
        :type: dict(str, PropertyDescriptor)
        """

        self._property_descriptors = property_descriptors

    @property
    def supports_dynamic_properties(self):
        """
        Gets the supports_dynamic_properties of this ProcessorDefinition.
        Whether or not this component makes use of dynamic (user-set) properties.

        :return: The supports_dynamic_properties of this ProcessorDefinition.
        :rtype: bool
        """
        return self._supports_dynamic_properties

    @supports_dynamic_properties.setter
    def supports_dynamic_properties(self, supports_dynamic_properties):
        """
        Sets the supports_dynamic_properties of this ProcessorDefinition.
        Whether or not this component makes use of dynamic (user-set) properties.

        :param supports_dynamic_properties: The supports_dynamic_properties of this ProcessorDefinition.
        :type: bool
        """

        self._supports_dynamic_properties = supports_dynamic_properties

    @property
    def input_requirement(self):
        """
        Gets the input_requirement of this ProcessorDefinition.
        Any input requirements this processor has.

        :return: The input_requirement of this ProcessorDefinition.
        :rtype: str
        """
        return self._input_requirement

    @input_requirement.setter
    def input_requirement(self, input_requirement):
        """
        Sets the input_requirement of this ProcessorDefinition.
        Any input requirements this processor has.

        :param input_requirement: The input_requirement of this ProcessorDefinition.
        :type: str
        """
        allowed_values = ["INPUT_REQUIRED", "INPUT_ALLOWED", "INPUT_FORBIDDEN"]
        if input_requirement not in allowed_values:
            raise ValueError(
                "Invalid value for `input_requirement` ({0}), must be one of {1}"
                .format(input_requirement, allowed_values)
            )

        self._input_requirement = input_requirement

    @property
    def supported_relationships(self):
        """
        Gets the supported_relationships of this ProcessorDefinition.
        The supported relationships for this processor.

        :return: The supported_relationships of this ProcessorDefinition.
        :rtype: list[Relationship]
        """
        return self._supported_relationships

    @supported_relationships.setter
    def supported_relationships(self, supported_relationships):
        """
        Sets the supported_relationships of this ProcessorDefinition.
        The supported relationships for this processor.

        :param supported_relationships: The supported_relationships of this ProcessorDefinition.
        :type: list[Relationship]
        """

        self._supported_relationships = supported_relationships

    @property
    def supports_dynamic_relationships(self):
        """
        Gets the supports_dynamic_relationships of this ProcessorDefinition.
        Whether or not this processor supports dynamic relationships.

        :return: The supports_dynamic_relationships of this ProcessorDefinition.
        :rtype: bool
        """
        return self._supports_dynamic_relationships

    @supports_dynamic_relationships.setter
    def supports_dynamic_relationships(self, supports_dynamic_relationships):
        """
        Sets the supports_dynamic_relationships of this ProcessorDefinition.
        Whether or not this processor supports dynamic relationships.

        :param supports_dynamic_relationships: The supports_dynamic_relationships of this ProcessorDefinition.
        :type: bool
        """

        self._supports_dynamic_relationships = supports_dynamic_relationships

    @property
    def trigger_serially(self):
        """
        Gets the trigger_serially of this ProcessorDefinition.
        Whether or not this processor should be triggered serially (i.e. no concurrent execution).

        :return: The trigger_serially of this ProcessorDefinition.
        :rtype: bool
        """
        return self._trigger_serially

    @trigger_serially.setter
    def trigger_serially(self, trigger_serially):
        """
        Sets the trigger_serially of this ProcessorDefinition.
        Whether or not this processor should be triggered serially (i.e. no concurrent execution).

        :param trigger_serially: The trigger_serially of this ProcessorDefinition.
        :type: bool
        """

        self._trigger_serially = trigger_serially

    @property
    def trigger_when_empty(self):
        """
        Gets the trigger_when_empty of this ProcessorDefinition.
        Whether or not this processor should be triggered when incoming queues are empty.

        :return: The trigger_when_empty of this ProcessorDefinition.
        :rtype: bool
        """
        return self._trigger_when_empty

    @trigger_when_empty.setter
    def trigger_when_empty(self, trigger_when_empty):
        """
        Sets the trigger_when_empty of this ProcessorDefinition.
        Whether or not this processor should be triggered when incoming queues are empty.

        :param trigger_when_empty: The trigger_when_empty of this ProcessorDefinition.
        :type: bool
        """

        self._trigger_when_empty = trigger_when_empty

    @property
    def trigger_when_any_destination_available(self):
        """
        Gets the trigger_when_any_destination_available of this ProcessorDefinition.
        Whether or not this processor should be triggered when any destination queue has room.

        :return: The trigger_when_any_destination_available of this ProcessorDefinition.
        :rtype: bool
        """
        return self._trigger_when_any_destination_available

    @trigger_when_any_destination_available.setter
    def trigger_when_any_destination_available(self, trigger_when_any_destination_available):
        """
        Sets the trigger_when_any_destination_available of this ProcessorDefinition.
        Whether or not this processor should be triggered when any destination queue has room.

        :param trigger_when_any_destination_available: The trigger_when_any_destination_available of this ProcessorDefinition.
        :type: bool
        """

        self._trigger_when_any_destination_available = trigger_when_any_destination_available

    @property
    def supports_batching(self):
        """
        Gets the supports_batching of this ProcessorDefinition.
        Whether or not this processor supports batching. If a Processor uses this annotation, it allows the Framework to batch calls to session commits, as well as allowing the Framework to return the same session multiple times.

        :return: The supports_batching of this ProcessorDefinition.
        :rtype: bool
        """
        return self._supports_batching

    @supports_batching.setter
    def supports_batching(self, supports_batching):
        """
        Sets the supports_batching of this ProcessorDefinition.
        Whether or not this processor supports batching. If a Processor uses this annotation, it allows the Framework to batch calls to session commits, as well as allowing the Framework to return the same session multiple times.

        :param supports_batching: The supports_batching of this ProcessorDefinition.
        :type: bool
        """

        self._supports_batching = supports_batching

    @property
    def supports_event_driven(self):
        """
        Gets the supports_event_driven of this ProcessorDefinition.
        Whether or not this processor supports event driven scheduling. Indicates to the framework that the Processor is eligible to be scheduled to run based on the occurrence of an \"Event\" (e.g., when a FlowFile is enqueued in an incoming Connection), rather than being triggered periodically.

        :return: The supports_event_driven of this ProcessorDefinition.
        :rtype: bool
        """
        return self._supports_event_driven

    @supports_event_driven.setter
    def supports_event_driven(self, supports_event_driven):
        """
        Sets the supports_event_driven of this ProcessorDefinition.
        Whether or not this processor supports event driven scheduling. Indicates to the framework that the Processor is eligible to be scheduled to run based on the occurrence of an \"Event\" (e.g., when a FlowFile is enqueued in an incoming Connection), rather than being triggered periodically.

        :param supports_event_driven: The supports_event_driven of this ProcessorDefinition.
        :type: bool
        """

        self._supports_event_driven = supports_event_driven

    @property
    def primary_node_only(self):
        """
        Gets the primary_node_only of this ProcessorDefinition.
        Whether or not this processor should be scheduled only on the primary node in a cluster.

        :return: The primary_node_only of this ProcessorDefinition.
        :rtype: bool
        """
        return self._primary_node_only

    @primary_node_only.setter
    def primary_node_only(self, primary_node_only):
        """
        Sets the primary_node_only of this ProcessorDefinition.
        Whether or not this processor should be scheduled only on the primary node in a cluster.

        :param primary_node_only: The primary_node_only of this ProcessorDefinition.
        :type: bool
        """

        self._primary_node_only = primary_node_only

    @property
    def side_effect_free(self):
        """
        Gets the side_effect_free of this ProcessorDefinition.
        Whether or not this processor is considered side-effect free. Side-effect free indicate that the processor's operations on FlowFiles can be safely repeated across process sessions.

        :return: The side_effect_free of this ProcessorDefinition.
        :rtype: bool
        """
        return self._side_effect_free

    @side_effect_free.setter
    def side_effect_free(self, side_effect_free):
        """
        Sets the side_effect_free of this ProcessorDefinition.
        Whether or not this processor is considered side-effect free. Side-effect free indicate that the processor's operations on FlowFiles can be safely repeated across process sessions.

        :param side_effect_free: The side_effect_free of this ProcessorDefinition.
        :type: bool
        """

        self._side_effect_free = side_effect_free

    @property
    def supported_scheduling_strategies(self):
        """
        Gets the supported_scheduling_strategies of this ProcessorDefinition.
        The supported scheduling strategies, such as TIME_DRIVER, CRON, or EVENT_DRIVEN.

        :return: The supported_scheduling_strategies of this ProcessorDefinition.
        :rtype: list[str]
        """
        return self._supported_scheduling_strategies

    @supported_scheduling_strategies.setter
    def supported_scheduling_strategies(self, supported_scheduling_strategies):
        """
        Sets the supported_scheduling_strategies of this ProcessorDefinition.
        The supported scheduling strategies, such as TIME_DRIVER, CRON, or EVENT_DRIVEN.

        :param supported_scheduling_strategies: The supported_scheduling_strategies of this ProcessorDefinition.
        :type: list[str]
        """

        self._supported_scheduling_strategies = supported_scheduling_strategies

    @property
    def default_scheduling_strategy(self):
        """
        Gets the default_scheduling_strategy of this ProcessorDefinition.
        The default scheduling strategy for the processor.

        :return: The default_scheduling_strategy of this ProcessorDefinition.
        :rtype: str
        """
        return self._default_scheduling_strategy

    @default_scheduling_strategy.setter
    def default_scheduling_strategy(self, default_scheduling_strategy):
        """
        Sets the default_scheduling_strategy of this ProcessorDefinition.
        The default scheduling strategy for the processor.

        :param default_scheduling_strategy: The default_scheduling_strategy of this ProcessorDefinition.
        :type: str
        """

        self._default_scheduling_strategy = default_scheduling_strategy

    @property
    def default_concurrent_tasks_by_scheduling_strategy(self):
        """
        Gets the default_concurrent_tasks_by_scheduling_strategy of this ProcessorDefinition.
        The default concurrent tasks for each scheduling strategy.

        :return: The default_concurrent_tasks_by_scheduling_strategy of this ProcessorDefinition.
        :rtype: dict(str, int)
        """
        return self._default_concurrent_tasks_by_scheduling_strategy

    @default_concurrent_tasks_by_scheduling_strategy.setter
    def default_concurrent_tasks_by_scheduling_strategy(self, default_concurrent_tasks_by_scheduling_strategy):
        """
        Sets the default_concurrent_tasks_by_scheduling_strategy of this ProcessorDefinition.
        The default concurrent tasks for each scheduling strategy.

        :param default_concurrent_tasks_by_scheduling_strategy: The default_concurrent_tasks_by_scheduling_strategy of this ProcessorDefinition.
        :type: dict(str, int)
        """

        self._default_concurrent_tasks_by_scheduling_strategy = default_concurrent_tasks_by_scheduling_strategy

    @property
    def default_scheduling_period_by_scheduling_strategy(self):
        """
        Gets the default_scheduling_period_by_scheduling_strategy of this ProcessorDefinition.
        The default scheduling period for each scheduling strategy. The scheduling period is expected to be a time period, such as \"30 sec\".

        :return: The default_scheduling_period_by_scheduling_strategy of this ProcessorDefinition.
        :rtype: dict(str, str)
        """
        return self._default_scheduling_period_by_scheduling_strategy

    @default_scheduling_period_by_scheduling_strategy.setter
    def default_scheduling_period_by_scheduling_strategy(self, default_scheduling_period_by_scheduling_strategy):
        """
        Sets the default_scheduling_period_by_scheduling_strategy of this ProcessorDefinition.
        The default scheduling period for each scheduling strategy. The scheduling period is expected to be a time period, such as \"30 sec\".

        :param default_scheduling_period_by_scheduling_strategy: The default_scheduling_period_by_scheduling_strategy of this ProcessorDefinition.
        :type: dict(str, str)
        """

        self._default_scheduling_period_by_scheduling_strategy = default_scheduling_period_by_scheduling_strategy

    @property
    def default_penalty_duration(self):
        """
        Gets the default_penalty_duration of this ProcessorDefinition.
        The default penalty duration as a time period, such as \"30 sec\".

        :return: The default_penalty_duration of this ProcessorDefinition.
        :rtype: str
        """
        return self._default_penalty_duration

    @default_penalty_duration.setter
    def default_penalty_duration(self, default_penalty_duration):
        """
        Sets the default_penalty_duration of this ProcessorDefinition.
        The default penalty duration as a time period, such as \"30 sec\".

        :param default_penalty_duration: The default_penalty_duration of this ProcessorDefinition.
        :type: str
        """

        self._default_penalty_duration = default_penalty_duration

    @property
    def default_yield_duration(self):
        """
        Gets the default_yield_duration of this ProcessorDefinition.
        The default yield duration as a time period, such as \"1 sec\".

        :return: The default_yield_duration of this ProcessorDefinition.
        :rtype: str
        """
        return self._default_yield_duration

    @default_yield_duration.setter
    def default_yield_duration(self, default_yield_duration):
        """
        Sets the default_yield_duration of this ProcessorDefinition.
        The default yield duration as a time period, such as \"1 sec\".

        :param default_yield_duration: The default_yield_duration of this ProcessorDefinition.
        :type: str
        """

        self._default_yield_duration = default_yield_duration

    @property
    def default_bulletin_level(self):
        """
        Gets the default_bulletin_level of this ProcessorDefinition.
        The default bulletin level, such as WARN, INFO, DEBUG, etc.

        :return: The default_bulletin_level of this ProcessorDefinition.
        :rtype: str
        """
        return self._default_bulletin_level

    @default_bulletin_level.setter
    def default_bulletin_level(self, default_bulletin_level):
        """
        Sets the default_bulletin_level of this ProcessorDefinition.
        The default bulletin level, such as WARN, INFO, DEBUG, etc.

        :param default_bulletin_level: The default_bulletin_level of this ProcessorDefinition.
        :type: str
        """

        self._default_bulletin_level = default_bulletin_level

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProcessorDefinition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
