# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProcessorDiagnosticsDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'processor': 'ProcessorDTO',
        'processor_status': 'ProcessorStatusDTO',
        'referenced_controller_services': 'list[ControllerServiceDiagnosticsDTO]',
        'incoming_connections': 'list[ConnectionDiagnosticsDTO]',
        'outgoing_connections': 'list[ConnectionDiagnosticsDTO]',
        'jvm_diagnostics': 'JVMDiagnosticsDTO',
        'thread_dumps': 'list[ThreadDumpDTO]',
        'class_loader_diagnostics': 'ClassLoaderDiagnosticsDTO'
    }

    attribute_map = {
        'processor': 'processor',
        'processor_status': 'processorStatus',
        'referenced_controller_services': 'referencedControllerServices',
        'incoming_connections': 'incomingConnections',
        'outgoing_connections': 'outgoingConnections',
        'jvm_diagnostics': 'jvmDiagnostics',
        'thread_dumps': 'threadDumps',
        'class_loader_diagnostics': 'classLoaderDiagnostics'
    }

    def __init__(self, processor=None, processor_status=None, referenced_controller_services=None, incoming_connections=None, outgoing_connections=None, jvm_diagnostics=None, thread_dumps=None, class_loader_diagnostics=None):
        """
        ProcessorDiagnosticsDTO - a model defined in Swagger
        """

        self._processor = None
        self._processor_status = None
        self._referenced_controller_services = None
        self._incoming_connections = None
        self._outgoing_connections = None
        self._jvm_diagnostics = None
        self._thread_dumps = None
        self._class_loader_diagnostics = None

        if processor is not None:
          self.processor = processor
        if processor_status is not None:
          self.processor_status = processor_status
        if referenced_controller_services is not None:
          self.referenced_controller_services = referenced_controller_services
        if incoming_connections is not None:
          self.incoming_connections = incoming_connections
        if outgoing_connections is not None:
          self.outgoing_connections = outgoing_connections
        if jvm_diagnostics is not None:
          self.jvm_diagnostics = jvm_diagnostics
        if thread_dumps is not None:
          self.thread_dumps = thread_dumps
        if class_loader_diagnostics is not None:
          self.class_loader_diagnostics = class_loader_diagnostics

    @property
    def processor(self):
        """
        Gets the processor of this ProcessorDiagnosticsDTO.
        Information about the Processor for which the Diagnostic Report is generated

        :return: The processor of this ProcessorDiagnosticsDTO.
        :rtype: ProcessorDTO
        """
        return self._processor

    @processor.setter
    def processor(self, processor):
        """
        Sets the processor of this ProcessorDiagnosticsDTO.
        Information about the Processor for which the Diagnostic Report is generated

        :param processor: The processor of this ProcessorDiagnosticsDTO.
        :type: ProcessorDTO
        """

        self._processor = processor

    @property
    def processor_status(self):
        """
        Gets the processor_status of this ProcessorDiagnosticsDTO.
        The Status for the Processor for which the Diagnostic Report is generated

        :return: The processor_status of this ProcessorDiagnosticsDTO.
        :rtype: ProcessorStatusDTO
        """
        return self._processor_status

    @processor_status.setter
    def processor_status(self, processor_status):
        """
        Sets the processor_status of this ProcessorDiagnosticsDTO.
        The Status for the Processor for which the Diagnostic Report is generated

        :param processor_status: The processor_status of this ProcessorDiagnosticsDTO.
        :type: ProcessorStatusDTO
        """

        self._processor_status = processor_status

    @property
    def referenced_controller_services(self):
        """
        Gets the referenced_controller_services of this ProcessorDiagnosticsDTO.
        Diagnostic Information about all Controller Services that the Processor is referencing

        :return: The referenced_controller_services of this ProcessorDiagnosticsDTO.
        :rtype: list[ControllerServiceDiagnosticsDTO]
        """
        return self._referenced_controller_services

    @referenced_controller_services.setter
    def referenced_controller_services(self, referenced_controller_services):
        """
        Sets the referenced_controller_services of this ProcessorDiagnosticsDTO.
        Diagnostic Information about all Controller Services that the Processor is referencing

        :param referenced_controller_services: The referenced_controller_services of this ProcessorDiagnosticsDTO.
        :type: list[ControllerServiceDiagnosticsDTO]
        """

        self._referenced_controller_services = referenced_controller_services

    @property
    def incoming_connections(self):
        """
        Gets the incoming_connections of this ProcessorDiagnosticsDTO.
        Diagnostic Information about all incoming Connections

        :return: The incoming_connections of this ProcessorDiagnosticsDTO.
        :rtype: list[ConnectionDiagnosticsDTO]
        """
        return self._incoming_connections

    @incoming_connections.setter
    def incoming_connections(self, incoming_connections):
        """
        Sets the incoming_connections of this ProcessorDiagnosticsDTO.
        Diagnostic Information about all incoming Connections

        :param incoming_connections: The incoming_connections of this ProcessorDiagnosticsDTO.
        :type: list[ConnectionDiagnosticsDTO]
        """

        self._incoming_connections = incoming_connections

    @property
    def outgoing_connections(self):
        """
        Gets the outgoing_connections of this ProcessorDiagnosticsDTO.
        Diagnostic Information about all outgoing Connections

        :return: The outgoing_connections of this ProcessorDiagnosticsDTO.
        :rtype: list[ConnectionDiagnosticsDTO]
        """
        return self._outgoing_connections

    @outgoing_connections.setter
    def outgoing_connections(self, outgoing_connections):
        """
        Sets the outgoing_connections of this ProcessorDiagnosticsDTO.
        Diagnostic Information about all outgoing Connections

        :param outgoing_connections: The outgoing_connections of this ProcessorDiagnosticsDTO.
        :type: list[ConnectionDiagnosticsDTO]
        """

        self._outgoing_connections = outgoing_connections

    @property
    def jvm_diagnostics(self):
        """
        Gets the jvm_diagnostics of this ProcessorDiagnosticsDTO.
        Diagnostic Information about the JVM and system-level diagnostics

        :return: The jvm_diagnostics of this ProcessorDiagnosticsDTO.
        :rtype: JVMDiagnosticsDTO
        """
        return self._jvm_diagnostics

    @jvm_diagnostics.setter
    def jvm_diagnostics(self, jvm_diagnostics):
        """
        Sets the jvm_diagnostics of this ProcessorDiagnosticsDTO.
        Diagnostic Information about the JVM and system-level diagnostics

        :param jvm_diagnostics: The jvm_diagnostics of this ProcessorDiagnosticsDTO.
        :type: JVMDiagnosticsDTO
        """

        self._jvm_diagnostics = jvm_diagnostics

    @property
    def thread_dumps(self):
        """
        Gets the thread_dumps of this ProcessorDiagnosticsDTO.
        Thread Dumps that were taken of the threads that are active in the Processor

        :return: The thread_dumps of this ProcessorDiagnosticsDTO.
        :rtype: list[ThreadDumpDTO]
        """
        return self._thread_dumps

    @thread_dumps.setter
    def thread_dumps(self, thread_dumps):
        """
        Sets the thread_dumps of this ProcessorDiagnosticsDTO.
        Thread Dumps that were taken of the threads that are active in the Processor

        :param thread_dumps: The thread_dumps of this ProcessorDiagnosticsDTO.
        :type: list[ThreadDumpDTO]
        """

        self._thread_dumps = thread_dumps

    @property
    def class_loader_diagnostics(self):
        """
        Gets the class_loader_diagnostics of this ProcessorDiagnosticsDTO.
        Information about the Controller Service's Class Loader

        :return: The class_loader_diagnostics of this ProcessorDiagnosticsDTO.
        :rtype: ClassLoaderDiagnosticsDTO
        """
        return self._class_loader_diagnostics

    @class_loader_diagnostics.setter
    def class_loader_diagnostics(self, class_loader_diagnostics):
        """
        Sets the class_loader_diagnostics of this ProcessorDiagnosticsDTO.
        Information about the Controller Service's Class Loader

        :param class_loader_diagnostics: The class_loader_diagnostics of this ProcessorDiagnosticsDTO.
        :type: ClassLoaderDiagnosticsDTO
        """

        self._class_loader_diagnostics = class_loader_diagnostics

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProcessorDiagnosticsDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
