# ![NullTek Documentation](https://raw.githubusercontent.com/CreatingNull/NullTek-Assets/main/img/logo/NullTekDocumentationLogo.png) Arduino Hooks

[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/arduino-hooks?style=flat-square&logo=python&logoColor=white)](https://pypi.org/project/arduino-hooks/)
[![PyPI - Release Version](https://img.shields.io/pypi/v/arduino-hooks?style=flat-square&logo=pypi&logoColor=white)](https://pypi.org/project/arduino-hooks/)
[![Format](https://img.shields.io/github/workflow/status/CreatingNull/arduino-hooks/pre-commit?logo=pre-commit&style=flat-square&label=format)](https://github.com/CreatingNull/arduino-hooks/actions/workflows/run-pre-commit.yaml)
[![Tests](https://img.shields.io/github/workflow/status/CreatingNull/arduino-hooks/tests?logo=GitHub&style=flat-square&label=tests)](https://github.com/CreatingNull/arduino-hooks/actions/workflows/run-tests.yaml)
[![License](https://img.shields.io/github/license/CreatingNull/arduino-hooks?style=flat-square)](https://github.com/CreatingNull/arduino-hooks/blob/master/LICENSE.md)
[![Code Style](https://img.shields.io/badge/style-black-000000.svg?style=flat-square)](https://github.com/psf/black)

This project provides [pre-commit](https://github.com/pre-commit/pre-commit) hooks for [arduino](https://github.com/arduino) command line tooling.
This is an un-official project.

Currently, this includes:

* [arduino-lint](https://github.com/arduino/arduino-lint) - Linter for checking arduino projects for problems and conformance to conventions.
* [arduino-cli](https://github.com/arduino/arduino-cli) - Limited to `compile` calls for verifying arduino code can be compiled.

This project uses [CliPy-Hooks](https://github.com/CreatingNull/clipy-hooks), to handle most of the cross-platform, sub-process nastiness.

---

## Getting Started

To configure pre-commit see [their official docs](https://pre-commit.com/) for instructions.

To use any of the arduino hooks below you must have the respective executables installed and **on path**.
If you are running in an environment where putting this on path is difficult, you may pass an `--install-dir` argument to define the absolute path to the arduino-lint executable.

The hooked tools do not work with individual source files as is done with most pre-commit hooks, as these tools work against complete arduino projects.
By default, the hooks will treat the root directory as the project root, as is typical in arduino repositories.
In cases where this is not true, you can pass a `--project-dir` argument with the project root path to the hook.

Due to limitations in `clipy-hooks` it is **highly** suggested that you pass all arguments with values using `--key=value` rather than `--key value`.

### Arduino Lint

Sample `.pre-commit-config.yaml`:

```yaml
-   repo: https://github.com/creatingnull/arduino-hooks
    rev: v0.2.0
    hooks:
    -   id: arduino-lint
```

You can find instructions on how to install `arduino-lint` and pre-compiled binaries in the [official docs](https://arduino.github.io/arduino-lint/latest/installation/).

For convenience this hook recognises the following arguments:

 * `--fail-on-warn` flag that will fail on any warning returned by arduino lint.
   Similar result to `compliance=strict` but even stricter.

You also may pass in supported `arduino-cli` [arguments](https://arduino.github.io/arduino-lint/latest/commands/arduino-lint/) which will be handed through to the executable.

```yaml
-   repo: https://github.com/creatingnull/arduino-hooks
    rev: v0.2.0
    hooks:
    -   id: arduino-lint
    -   args: ["--install-dir=/opt/arduino/", "--fail-on-warn", "--project-dir=src/"]
```

### Arduino CLI

Must provide the full qualified board name for the target microcontroller.
You'll also need to have previously installed the [core](https://arduino.github.io/arduino-cli/latest/getting-started/#install-the-core-for-your-board) for this target and any [libs](https://arduino.github.io/arduino-cli/latest/getting-started/#add-libraries) required by your project.

Sample `.pre-commit-config.yaml`:

```yaml
-   repo: https://github.com/creatingnull/arduino-hooks
    rev: v0.2.0
    hooks:
    -   id: arduino-cli
        args: ["--fqbn=arduino:avr:nano"]
```

You can find instructions on how to install `arduino-cli` and pre-compiled binaries in the [official docs](https://arduino.github.io/arduino-cli/latest/installation/)

---

## Donations

I just do this stuff for fun in my spare time, but feel free to:

[![Support via buymeacoffee](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://www.buymeacoffee.com/nulltek)

---

## License

The source of this repo uses the MIT open-source license, for details on the current licensing see [LICENSE](https://github.com/CreatingNull/arduino-hooks/blob/master/LICENSE.md) or click the badge above.
