"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCalendarState = void 0;
const aws_sdk_1 = require("aws-sdk");
exports.getCalendarState = async (calendarName) => {
    const fallbackNextTransitionTime = '2999-01-01T00:00:00Z';
    const ssm = new aws_sdk_1.SSM();
    try {
        const result = await ssm
            .getCalendarState({ CalendarNames: [calendarName] })
            .promise();
        if (!result.State)
            throw new Error('getCalendarState returned an undefined state.');
        return {
            state: result.State,
            nextTransitionTime: result.NextTransitionTime ?? fallbackNextTransitionTime,
            summary: `Calendar is ${result.State} until ${result.NextTransitionTime ?? fallbackNextTransitionTime}.`,
        };
    }
    catch (error) {
        const summary = `Unable to retrieve calendar state for ${calendarName}.`;
        console.error(summary, error);
        return {
            state: 'CLOSED',
            nextTransitionTime: fallbackNextTransitionTime,
            summary,
        };
    }
};
//# sourceMappingURL=data:application/json;base64,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