/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util;

import com.datapps.linkoopdb.jdbc.util.JDBCTypes;
import com.datapps.linkoopdb.jdbc.util.Traceable;
import com.datapps.linkoopdb.jdbc.util.TransferDb;
import com.datapps.linkoopdb.jdbc.util.TransferTable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

class TransferHelper {
    protected TransferDb db;
    protected Traceable tracer;
    protected String sSchema;
    protected JDBCTypes JDBCT;
    private String quote;

    TransferHelper() {
        this.db = null;
        this.tracer = null;
        this.quote = "'";
        this.JDBCT = new JDBCTypes();
    }

    TransferHelper(TransferDb database, Traceable t, String q) {
        this.db = database;
        this.tracer = t;
        this.quote = q;
        this.JDBCT = new JDBCTypes();
    }

    void set(TransferDb database, Traceable t, String q) {
        this.db = database;
        this.tracer = t;
        this.quote = q;
    }

    String formatIdentifier(String id) {
        if (id == null) {
            return id;
        }
        if (id.equals("")) {
            return id;
        }
        if (!id.toUpperCase().equals(id)) {
            return this.quote + id + this.quote;
        }
        if (!Character.isLetter(id.charAt(0)) || id.indexOf(32) != -1) {
            return this.quote + id + this.quote;
        }
        return id;
    }

    void setSchema(String _Schema) {
        this.sSchema = _Schema;
    }

    String formatName(String t) {
        String Name2 = "";
        if (this.sSchema != null && this.sSchema.length() > 0) {
            Name2 = this.sSchema + ".";
        }
        Name2 = Name2 + this.formatIdentifier(t);
        return Name2;
    }

    int convertFromType(int type) {
        return type;
    }

    int convertToType(int type) {
        return type;
    }

    Hashtable getSupportedTypes() {
        Hashtable hTypes = new Hashtable();
        if (this.db != null) {
            try {
                ResultSet result = this.db.meta.getTypeInfo();
                while (result.next()) {
                    Integer intobj = new Integer(result.getShort(2));
                    if (hTypes.get(intobj) != null) continue;
                    try {
                        short typeNumber = result.getShort(2);
                        hTypes.put(intobj, this.JDBCT.toString(typeNumber));
                    }
                    catch (Exception exception) {}
                }
                result.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (hTypes.isEmpty()) {
            hTypes = this.JDBCT.getHashtable();
        }
        return hTypes;
    }

    String fixupColumnDefRead(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        return columnType;
    }

    String fixupColumnDefWrite(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        return columnType;
    }

    boolean needTransferTransaction() {
        return false;
    }

    Object convertColumnValue(Object value, int column, int type) {
        if (value == null) {
            return value;
        }
        try {
            if (value instanceof Clob) {
                return ((Clob)value).getSubString(1L, (int)((Clob)value).length());
            }
            if (value instanceof Blob) {
                return ((Blob)value).getBytes(1L, (int)((Blob)value).length());
            }
        }
        catch (SQLException e) {
            return null;
        }
        return value;
    }

    void beginDataTransfer() {
    }

    void endDataTransfer() {
    }

    String fixupColumnDefRead(String aTableName, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        return columnType;
    }

    String fixupColumnDefWrite(String aTableName, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        return columnType;
    }
}

