/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERTag;

class DERLength {
    private static final int SHORT_FORM_MAX_LENGTH = 127;
    private static final int SHORT_FORM_MASK = 127;
    private static final int LONG_FORM_BIT = 128;
    private static final int LONG_FORM_MASK = 255;
    private int length;
    private byte[] octets;

    DERLength(int n) {
        if (0 > n) {
            throw new DERException("Negative Length is not valid.");
        }
        this.length = n;
        this.octets = this.calcOctets();
    }

    DERLength(byte[] byArray) {
        this.parse(byArray);
    }

    DERLength(byte[] byArray, int n) {
        this.parse(byArray, n);
    }

    private void parse(byte[] byArray) {
        DERTag dERTag = new DERTag(byArray);
        this.parse(byArray, dERTag.getTagOctets().length);
    }

    private void parse(byte[] byArray, int n) {
        int n2;
        int n3;
        boolean bl = false;
        try {
            n3 = n;
            bl = (byArray[n3] & 0x80) != 0;
            n2 = bl ? n3 + (byArray[n3] & 0x7F) : n3;
            this.octets = new byte[n2 - n3 + 1];
            System.arraycopy(byArray, n3, this.octets, 0, this.octets.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DERException("Buffer contains invalid length octets.");
        }
        n3 = n;
        if (bl) {
            n2 = n3 + (byArray[n3] & 0x7F);
            this.length = 0;
            for (int i = n3 + 1; i <= n2; ++i) {
                this.length <<= 8;
                this.length |= byArray[i] & 0xFF;
            }
        } else {
            this.length = byArray[n3] & 0x7F;
        }
    }

    private byte[] calcOctets() {
        byte[] byArray;
        if (this.length <= 127) {
            byArray = new byte[]{(byte)(this.length & 0x7F)};
        } else {
            int n = 0;
            for (int i = this.length; i > 0; i >>= 1) {
                ++n;
            }
            int n2 = (n + 8 - 1) / 8;
            byArray = new byte[n2 + 1];
            byArray[0] = (byte)(0x80 | n2 & 0x7F);
            int n3 = this.length;
            for (int i = n2; i > 0; --i) {
                byArray[i] = (byte)(n3 & 0xFF);
                n3 >>= 8;
            }
        }
        return byArray;
    }

    int getLength() {
        return this.length;
    }

    byte[] getLengthOctets() {
        return this.octets;
    }

    int size() {
        return this.octets.length;
    }
}

