"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
export class Hello {
  public sayHello() {
    return 'hello, world!';
  }
}
*/
const path = require("path");
//import { AssetCode, LayerVersion, Runtime, LayerVersionProps } from 'aws-cdk-lib/aws-lambda';
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * Create a Lambda layer with the PowerTools and other required modules.
 */
class ToolsLayer extends constructs_1.Construct {
    /**
       * @param {Construct} scope
       * @param {string} id
    */
    constructor(scope, id, props) {
        super(scope, id);
        this.layerVersion = new aws_lambda_1.LayerVersion(this, `${props?.layerVersionName}-ToolsLayer`, {
            compatibleRuntimes: [aws_lambda_1.Runtime.NODEJS_16_X],
            code: aws_lambda_1.AssetCode.fromAsset(path.join(__dirname, './powertools')),
            description: `${props?.layerVersionName} Tools Shared Layer`,
            layerVersionName: `${props?.layerVersionName}-tools`,
        });
    }
}
exports.ToolsLayer = ToolsLayer;
_a = JSII_RTTI_SYMBOL_1;
ToolsLayer[_a] = { fqn: "vaughntech-nodejs-powertools-lambdalayer.ToolsLayer", version: "0.0.6" };
//# sourceMappingURL=data:application/json;base64,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