# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from properly_model_python.models.base_model_ import Model
from properly_model_python import util


class SimpleListing(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id: str=None, list_price: int=None, predicted_price: float=None, image_url: str=None, image_medium_url: str=None, image_thumbnail_url: str=None, address: str=None, bedrooms: int=None, bathrooms: int=None, bathrooms_half: int=None, square_feet: int=None, parking: int=None, brokerage: str=None, community: str=None, city: str=None, neighbourhood_name: str=None, start_date: float=None, mls_id: str=None, listing_brokerage: List[str]=None, property_sub_type: str=None, properly_city_code: str=None):  # noqa: E501
        """SimpleListing - a model defined in Swagger

        :param id: The id of this SimpleListing.  # noqa: E501
        :type id: str
        :param list_price: The list_price of this SimpleListing.  # noqa: E501
        :type list_price: int
        :param predicted_price: The predicted_price of this SimpleListing.  # noqa: E501
        :type predicted_price: float
        :param image_url: The image_url of this SimpleListing.  # noqa: E501
        :type image_url: str
        :param image_medium_url: The image_medium_url of this SimpleListing.  # noqa: E501
        :type image_medium_url: str
        :param image_thumbnail_url: The image_thumbnail_url of this SimpleListing.  # noqa: E501
        :type image_thumbnail_url: str
        :param address: The address of this SimpleListing.  # noqa: E501
        :type address: str
        :param bedrooms: The bedrooms of this SimpleListing.  # noqa: E501
        :type bedrooms: int
        :param bathrooms: The bathrooms of this SimpleListing.  # noqa: E501
        :type bathrooms: int
        :param bathrooms_half: The bathrooms_half of this SimpleListing.  # noqa: E501
        :type bathrooms_half: int
        :param square_feet: The square_feet of this SimpleListing.  # noqa: E501
        :type square_feet: int
        :param parking: The parking of this SimpleListing.  # noqa: E501
        :type parking: int
        :param brokerage: The brokerage of this SimpleListing.  # noqa: E501
        :type brokerage: str
        :param community: The community of this SimpleListing.  # noqa: E501
        :type community: str
        :param neighbourhood_name: The neighbourhood_name of this SimpleListing.  # noqa: E501
        :type neighbourhood_name: str
        :param city: The city of this SimpleListing.  # noqa: E501
        :type city: str
        :param start_date: The start_date of this SimpleListing.  # noqa: E501
        :type start_date: float
        :param mls_id: The mls_id of this SimpleListing.  # noqa: E501
        :type mls_id: str
        :param listing_brokerage: The listing_brokerage of this SimpleListing.  # noqa: E501
        :type listing_brokerage: List[str]
        :param property_sub_type: The property_sub_type of this SimpleListing.  # noqa: E501
        :type property_sub_type: str
        :param properly_city_code: The properly_city_code of this SimpleListing.  # noqa: E501
        :type properly_city_code: str
        """
        self.swagger_types = {
            'id': str,
            'list_price': int,
            'predicted_price': float,
            'image_url': str,
            'image_medium_url': str,
            'image_thumbnail_url': str,
            'address': str,
            'bedrooms': int,
            'bathrooms': int,
            'bathrooms_half': int,
            'square_feet': int,
            'parking': int,
            'brokerage': str,
            'community': str,
            'neighbourhood_name': str,
            'city': str,
            'start_date': float,
            'mls_id': str,
            'listing_brokerage': List[str],
            'property_sub_type': str,
            'properly_city_code': str
        }

        self.attribute_map = {
            'id': 'id',
            'list_price': 'listPrice',
            'predicted_price': 'predictedPrice',
            'image_url': 'imageUrl',
            'image_medium_url': 'imageMediumUrl',
            'image_thumbnail_url': 'imageThumbnailUrl',
            'address': 'address',
            'bedrooms': 'bedrooms',
            'bathrooms': 'bathrooms',
            'bathrooms_half': 'bathroomsHalf',
            'square_feet': 'squareFeet',
            'parking': 'parking',
            'brokerage': 'brokerage',
            'community': 'community',
            'neighbourhood_name': 'neighbourhoodName',
            'city': 'city',
            'start_date': 'startDate',
            'mls_id': 'mlsId',
            'listing_brokerage': 'listingBrokerage',
            'property_sub_type': 'propertySubType',
            'properly_city_code': 'properlyCityCode'
        }

        self._id = id
        self._list_price = list_price
        self._predicted_price = predicted_price
        self._image_url = image_url
        self._image_medium_url = image_medium_url
        self._image_thumbnail_url = image_thumbnail_url
        self._address = address
        self._bedrooms = bedrooms
        self._bathrooms = bathrooms
        self._bathrooms_half = bathrooms_half
        self._square_feet = square_feet
        self._parking = parking
        self._brokerage = brokerage
        self._community = community
        self._neighbourhood_name = neighbourhood_name
        self._city = city
        self._start_date = start_date
        self._mls_id = mls_id
        self._listing_brokerage = listing_brokerage
        self._property_sub_type = property_sub_type
        self._properly_city_code = properly_city_code

    @classmethod
    def from_dict(cls, dikt) -> 'SimpleListing':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The SimpleListing of this SimpleListing.  # noqa: E501
        :rtype: SimpleListing
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this SimpleListing.

        property identifier for this home  # noqa: E501

        :return: The id of this SimpleListing.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this SimpleListing.

        property identifier for this home  # noqa: E501

        :param id: The id of this SimpleListing.
        :type id: str
        """

        self._id = id

    @property
    def list_price(self) -> int:
        """Gets the list_price of this SimpleListing.

        listing price  # noqa: E501

        :return: The list_price of this SimpleListing.
        :rtype: int
        """
        return self._list_price

    @list_price.setter
    def list_price(self, list_price: int):
        """Sets the list_price of this SimpleListing.

        listing price  # noqa: E501

        :param list_price: The list_price of this SimpleListing.
        :type list_price: int
        """

        self._list_price = list_price

    @property
    def predicted_price(self) -> float:
        """Gets the predicted_price of this SimpleListing.

        estimated selling price  # noqa: E501

        :return: The predicted_price of this SimpleListing.
        :rtype: float
        """
        return self._predicted_price

    @predicted_price.setter
    def predicted_price(self, predicted_price: float):
        """Sets the predicted_price of this SimpleListing.

        estimated selling price  # noqa: E501

        :param predicted_price: The predicted_price of this SimpleListing.
        :type predicted_price: float
        """

        self._predicted_price = predicted_price

    @property
    def image_url(self) -> str:
        """Gets the image_url of this SimpleListing.

        Large size of the first image in image list for this property, made available for preview  # noqa: E501

        :return: The image_url of this SimpleListing.
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url: str):
        """Sets the image_url of this SimpleListing.

        Large size of the first image in image list for this property, made available for preview  # noqa: E501

        :param image_url: The image_url of this SimpleListing.
        :type image_url: str
        """

        self._image_url = image_url

    @property
    def image_medium_url(self) -> str:
        """Gets the image_medium_url of this SimpleListing.

        Medium size of the first image in image list for this property, made available for preview  # noqa: E501

        :return: The image_medium_url of this SimpleListing.
        :rtype: str
        """
        return self._image_medium_url

    @image_medium_url.setter
    def image_medium_url(self, image_medium_url: str):
        """Sets the image_medium_url of this SimpleListing.

        Medium size of the first image in image list for this property, made available for preview  # noqa: E501

        :param image_medium_url: The image_medium_url of this SimpleListing.
        :type image_medium_url: str
        """

        self._image_medium_url = image_medium_url

    @property
    def image_thumbnail_url(self) -> str:
        """Gets the image_thumbnail_url of this SimpleListing.

        Thumbnail size of the first image in image list for this property, made available for preview  # noqa: E501

        :return: The image_thumbnail_url of this SimpleListing.
        :rtype: str
        """
        return self._image_thumbnail_url

    @image_thumbnail_url.setter
    def image_thumbnail_url(self, image_thumbnail_url: str):
        """Sets the image_thumbnail_url of this SimpleListing.

        Thumbnail size of the first image in image list for this property, made available for preview  # noqa: E501

        :param image_thumbnail_url: The image_thumbnail_url of this SimpleListing.
        :type image_thumbnail_url: str
        """

        self._image_thumbnail_url = image_thumbnail_url

    @property
    def address(self) -> str:
        """Gets the address of this SimpleListing.

        Specific addresses  # noqa: E501

        :return: The address of this SimpleListing.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str):
        """Sets the address of this SimpleListing.

        Specific addresses  # noqa: E501

        :param address: The address of this SimpleListing.
        :type address: str
        """

        self._address = address

    @property
    def bedrooms(self) -> int:
        """Gets the bedrooms of this SimpleListing.

        Number of bedrooms  # noqa: E501

        :return: The bedrooms of this SimpleListing.
        :rtype: int
        """
        return self._bedrooms

    @bedrooms.setter
    def bedrooms(self, bedrooms: int):
        """Sets the bedrooms of this SimpleListing.

        Number of bedrooms  # noqa: E501

        :param bedrooms: The bedrooms of this SimpleListing.
        :type bedrooms: int
        """

        self._bedrooms = bedrooms

    @property
    def bathrooms(self) -> int:
        """Gets the bathrooms of this SimpleListing.

        Number of full bathrooms  # noqa: E501

        :return: The bathrooms of this SimpleListing.
        :rtype: int
        """
        return self._bathrooms

    @bathrooms.setter
    def bathrooms(self, bathrooms: int):
        """Sets the bathrooms of this SimpleListing.

        Number of full bathrooms  # noqa: E501

        :param bathrooms: The bathrooms of this SimpleListing.
        :type bathrooms: int
        """

        self._bathrooms = bathrooms

    @property
    def bathrooms_half(self) -> int:
        """Gets the bathrooms_half of this SimpleListing.

        Number of half bathrooms  # noqa: E501

        :return: The bathrooms_half of this SimpleListing.
        :rtype: int
        """
        return self._bathrooms_half

    @bathrooms_half.setter
    def bathrooms_half(self, bathrooms_half: int):
        """Sets the bathrooms_half of this SimpleListing.

        Number of half bathrooms  # noqa: E501

        :param bathrooms_half: The bathrooms_half of this SimpleListing.
        :type bathrooms_half: int
        """

        self._bathrooms_half = bathrooms_half

    @property
    def square_feet(self) -> int:
        """Gets the square_feet of this SimpleListing.

        Size of the listing in square feet  # noqa: E501

        :return: The square_feet of this SimpleListing.
        :rtype: int
        """
        return self._square_feet

    @square_feet.setter
    def square_feet(self, square_feet: int):
        """Sets the square_feet of this SimpleListing.

        Size of the listing in square feet  # noqa: E501

        :param square_feet: The square_feet of this SimpleListing.
        :type square_feet: int
        """

        self._square_feet = square_feet

    @property
    def parking(self) -> int:
        """Gets the parking of this SimpleListing.

        Number of parking spaces  # noqa: E501

        :return: The parking of this SimpleListing.
        :rtype: int
        """
        return self._parking

    @parking.setter
    def parking(self, parking: int):
        """Sets the parking of this SimpleListing.

        Number of parking spaces  # noqa: E501

        :param parking: The parking of this SimpleListing.
        :type parking: int
        """

        self._parking = parking

    @property
    def brokerage(self) -> str:
        """Gets the brokerage of this SimpleListing.

        The name of the brokerage listing the property  # noqa: E501

        :return: The brokerage of this SimpleListing.
        :rtype: str
        """
        return self._brokerage

    @brokerage.setter
    def brokerage(self, brokerage: str):
        """Sets the brokerage of this SimpleListing.

        The name of the brokerage listing the property  # noqa: E501

        :param brokerage: The brokerage of this SimpleListing.
        :type brokerage: str
        """

        self._brokerage = brokerage

    @property
    def community(self) -> str:
        """Gets the community of this SimpleListing.

        The community of the listing  # noqa: E501

        :return: The community of this SimpleListing.
        :rtype: str
        """
        return self._community

    @community.setter
    def community(self, community: str):
        """Sets the community of this SimpleListing.

        The community of the listing  # noqa: E501

        :param community: The community of this SimpleListing.
        :type community: str
        """

        self._community = community

    @property
    def neighbourhood_name(self) -> str:
        """Gets the neighbourhood_name of this SimpleListing.

        The neighbourhood of the listing  # noqa: E501

        :return: The neighbourhood_name of this SimpleListing.
        :rtype: str
        """
        return self._neighbourhood_name

    @neighbourhood_name.setter
    def neighbourhood_name(self, neighbourhood_name: str):
        """Sets the neighbourhood_name of this SimpleListing.

        The neighbourhood of the listing  # noqa: E501

        :param neighbourhood_name: The neighbourhood_name of this SimpleListing.
        :type neighbourhood_name: str
        """

        self._neighbourhood_name = neighbourhood_name

    @property
    def city(self) -> str:
        """Gets the city of this SimpleListing.

        The city of the listing (this could be a city, town, etc)  # noqa: E501

        :return: The city of this SimpleListing.
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city: str):
        """Sets the city of this SimpleListing.

        The city of the listing (this could be a city, town, etc)  # noqa: E501

        :param city: The city of this SimpleListing.
        :type city: str
        """

        self._city = city

    @property
    def start_date(self) -> float:
        """Gets the start_date of this SimpleListing.

        The start date of the listing  # noqa: E501

        :return: The start_date of this SimpleListing.
        :rtype: float
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: float):
        """Sets the start_date of this SimpleListing.

        The start date of the listing  # noqa: E501

        :param start_date: The start_date of this SimpleListing.
        :type start_date: float
        """

        self._start_date = start_date

    @property
    def mls_id(self) -> str:
        """Gets the mls_id of this SimpleListing.

        Unique identifier for the MLS listing  # noqa: E501

        :return: The mls_id of this SimpleListing.
        :rtype: str
        """
        return self._mls_id

    @mls_id.setter
    def mls_id(self, mls_id: str):
        """Sets the mls_id of this SimpleListing.

        Unique identifier for the MLS listing  # noqa: E501

        :param mls_id: The mls_id of this SimpleListing.
        :type mls_id: str
        """

        self._mls_id = mls_id

    @property
    def listing_brokerage(self) -> List[str]:
        """Gets the listing_brokerage of this SimpleListing.

        List of brokerages associated with a listing  # noqa: E501

        :return: The listing_brokerage of this SimpleListing.
        :rtype: List[str]
        """
        return self._listing_brokerage

    @listing_brokerage.setter
    def listing_brokerage(self, listing_brokerage: List[str]):
        """Sets the listing_brokerage of this SimpleListing.

        List of brokerages associated with a listing  # noqa: E501

        :param listing_brokerage: The listing_brokerage of this SimpleListing.
        :type listing_brokerage: List[str]
        """

        self._listing_brokerage = listing_brokerage

    @property
    def property_sub_type(self) -> str:
        """Gets the property_sub_type of this SimpleListing.

        Home types associated with a listing  # noqa: E501

        :return: The property_sub_type of this SimpleListing.
        :rtype: str
        """
        return self._property_sub_type

    @property_sub_type.setter
    def property_sub_type(self, property_sub_type: str):
        """Sets the property_sub_type of this SimpleListing.

        Home types associated with a listing  # noqa: E501

        :param property_sub_type: The property_sub_type of this SimpleListing.
        :type property_sub_type: str
        """

        self._property_sub_type = property_sub_type

    @property
    def properly_city_code(self) -> str:
        """Gets the properly_city_code of this SimpleListing.

        City code associated with a listing  # noqa: E501

        :return: The properly_city_code of this SimpleListing.
        :rtype: str
        """
        return self._properly_city_code

    @properly_city_code.setter
    def properly_city_code(self, properly_city_code: str):
        """Sets the properly_city_code of this SimpleListing.

        City code associated with a listing  # noqa: E501

        :param properly_city_code: The properly_city_code of this SimpleListing.
        :type properly_city_code: str
        """

        self._properly_city_code = properly_city_code
