/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Clause;
import ida.ilp.basic.Constant;
import ida.ilp.basic.Function;
import ida.ilp.basic.Literal;
import ida.ilp.basic.PrologList;
import ida.ilp.basic.Term;
import ida.ilp.basic.Variable;
import ida.utils.Sugar;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LGG {
    private TermLGG termLGG = new BasicTermLGG();
    private LiteralFilter literalFilter;

    public Clause lgg(Clause ... clauses) {
        Clause c = clauses[0];
        for (int i = 1; i < clauses.length; ++i) {
            c = this.lgg(c, clauses[i]);
        }
        return c;
    }

    public Clause lgg(Clause a, Clause b) {
        return new Lgg().lgg(a, b);
    }

    public void setLiteralFilter(LiteralFilter literalFilter) {
        this.literalFilter = literalFilter;
    }

    public static class BasicTermLGG
    implements TermLGG {
        private int variableIndex = 0;
        private Map<Pair<Term, Term>, Variable> usedVariables = new HashMap<Pair<Term, Term>, Variable>();
        private Set<Term> terms;

        public BasicTermLGG() {
        }

        public BasicTermLGG(Set<Term> terms) {
            this.terms = terms;
        }

        @Override
        public Term termLGG(Term a, Term b) {
            if (a instanceof Function && b instanceof Function) {
                return this.functionLGG((Function)a, (Function)b);
            }
            if (a instanceof PrologList && b instanceof PrologList) {
                throw new UnsupportedOperationException("Lists not supported yet");
            }
            return this.otherLGG(a, b);
        }

        private Term functionLGG(Function a, Function b) {
            if (a.name().equals(b.name()) && a.arity() == b.arity()) {
                Function c = new Function(a.name(), a.arity());
                for (int i = 0; i < c.arity(); ++i) {
                    c.set(this.termLGG(a.get(i), b.get(i)), i);
                }
                return c;
            }
            return this.newVariable(a, b);
        }

        private Term otherLGG(Term a, Term b) {
            if (a instanceof Constant && b instanceof Constant && a.equals(b)) {
                return a;
            }
            return this.newVariable(a, b);
        }

        private Variable newVariable(Term a, Term b) {
            Pair<Term, Term> pa = new Pair<Term, Term>(a, b);
            if (this.usedVariables.containsKey(pa)) {
                return this.usedVariables.get(pa);
            }
            do {
                ++this.variableIndex;
            } while (this.terms.contains(Variable.construct("V" + this.variableIndex)));
            Variable newVariable = Variable.construct("V" + this.variableIndex);
            this.usedVariables.put(new Pair<Term, Term>(a, b), newVariable);
            this.terms.add(newVariable);
            return newVariable;
        }

        @Override
        public TermLGG constructNew(Set<Term> termsUsedInClauses) {
            return new BasicTermLGG(termsUsedInClauses);
        }
    }

    public static interface TermLGG {
        public TermLGG constructNew(Set<Term> var1);

        public Term termLGG(Term var1, Term var2);
    }

    public static interface LiteralFilter {
        public boolean filter(Literal var1);
    }

    private class Lgg {
        private Lgg() {
        }

        public Clause lgg(Clause a, Clause b) {
            ArrayList<Literal> literals = new ArrayList<Literal>();
            TermLGG tlgg = LGG.this.termLGG.constructNew(Sugar.setFromCollections(a.terms(), b.terms()));
            for (Literal litA : a.literals()) {
                for (Literal litB : b.literals()) {
                    if (!litA.predicate().equals(litB.predicate()) || litA.arity() != litB.arity()) continue;
                    Literal c = new Literal(litA.predicate(), litA.arity());
                    for (int i = 0; i < c.arity(); ++i) {
                        Term ta = litA.get(i);
                        Term tb = litB.get(i);
                        if (!(ta instanceof Term) || !(tb instanceof Term)) continue;
                        c.set(tlgg.termLGG(ta, tb), i);
                    }
                    if (LGG.this.literalFilter != null && !LGG.this.literalFilter.filter(c)) continue;
                    literals.add(c);
                }
            }
            return new Clause(literals);
        }
    }
}

