/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Constant;
import ida.ilp.basic.Function;
import ida.ilp.basic.PrologList;
import ida.ilp.basic.Term;
import ida.ilp.basic.Variable;
import ida.utils.tuples.Pair;
import java.util.Map;

public class ParserUtils {
    public static Pair<Term, Integer> parseTerm(char[] c, int start, char endCharacter, Map<String, Variable> variables, Map<String, Constant> constants) {
        int index;
        StringBuilder term = new StringBuilder();
        int roundBrackets = 0;
        int rectBrackets = 0;
        boolean CONSTANT = true;
        int FUNCTION = 2;
        int LIST = 3;
        int type = 1;
        boolean ignoreNext = false;
        boolean inQuotes = false;
        boolean inDoubleQuotes = false;
        Term retVal = null;
        for (index = start; index < c.length && c[index] == ' '; ++index) {
        }
        int tStart = index;
        while (index < c.length) {
            if (c[index] == '\\' && !ignoreNext) {
                ignoreNext = true;
            } else {
                if (!(inQuotes || inDoubleQuotes || c[index] != '\'' || ignoreNext)) {
                    term.append(c[index]);
                    inQuotes = true;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != '\"' || ignoreNext)) {
                    term.append(c[index]);
                    inDoubleQuotes = true;
                } else if (inQuotes && c[index] == '\'' && !ignoreNext) {
                    term.append(c[index]);
                    inQuotes = false;
                } else if (inDoubleQuotes && c[index] == '\"' && !ignoreNext) {
                    term.append(c[index]);
                    inDoubleQuotes = false;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != '[' || ignoreNext)) {
                    if (type == 1 && index == tStart) {
                        type = 3;
                    }
                    term.append(c[index]);
                    ++rectBrackets;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != ']' || rectBrackets <= 0 || ignoreNext)) {
                    term.append(c[index]);
                    --rectBrackets;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != '(' || ignoreNext)) {
                    if (type == 1) {
                        type = 2;
                    }
                    term.append(c[index]);
                    ++roundBrackets;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != ')' || roundBrackets <= 0 || ignoreNext)) {
                    term.append(c[index]);
                    --roundBrackets;
                } else {
                    if (!inQuotes && !inDoubleQuotes && roundBrackets == 0 && rectBrackets == 0 && (c[index] == endCharacter && index == c.length - 1 || c[index] == ',' || c[index] == ' ')) break;
                    term.append(c[index]);
                }
                ignoreNext = false;
            }
            ++index;
        }
        String termString = term.toString().trim();
        switch (type) {
            case 1: {
                if (termString.length() == 0) {
                    retVal = Constant.construct("");
                    break;
                }
                if (Character.isUpperCase(termString.charAt(0)) || termString.charAt(0) == '_') {
                    if (variables.containsKey(termString)) {
                        retVal = variables.get(termString);
                        break;
                    }
                    Variable var = Variable.construct(termString);
                    variables.put(termString, var);
                    retVal = var;
                    break;
                }
                if (constants.containsKey(termString)) {
                    retVal = constants.get(termString);
                    break;
                }
                Constant constant = Constant.construct(termString);
                constants.put(termString, constant);
                retVal = constant;
                break;
            }
            case 3: {
                PrologList list = PrologList.parseList(termString, variables, constants);
                retVal = list;
                break;
            }
            case 2: {
                Function f = Function.parseFunction(termString, variables, constants);
                retVal = f;
            }
        }
        return new Pair<Term, Integer>(retVal, index);
    }
}

