/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker.impl;

import ida.ilp.treeLiker.Block;
import ida.ilp.treeLiker.Domain;
import ida.ilp.treeLiker.Join;
import ida.ilp.treeLiker.JoinAndInt;
import ida.ilp.treeLiker.Settings;
import ida.ilp.treeLiker.impl.IrrelevancyFiltering;
import ida.utils.Sugar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class Pruning {
    private boolean[] mask;
    private boolean[] negMask;
    private int minFrequencyOnCoveredClass;

    public Pruning(boolean[] mask, boolean[] negMask, int minFrequencyOnCoveredClass) {
        this.mask = mask;
        this.negMask = negMask;
        this.minFrequencyOnCoveredClass = minFrequencyOnCoveredClass;
    }

    public Collection<Block> filterRedundantBlocksInParallel(Collection<Block> candidates, Map<Integer, Domain[]> domains) {
        if (Settings.USE_REDUNDANCY_FILTERING) {
            int processorCount = Runtime.getRuntime().availableProcessors();
            List<Collection<Block>> lists = Sugar.splitCollection(candidates, processorCount);
            List<Block> flattened = Collections.synchronizedList(new ArrayList());
            ArrayList<BlockRedundancyFiltering> tasks = new ArrayList<BlockRedundancyFiltering>();
            for (Collection<Block> list : lists) {
                tasks.add(new BlockRedundancyFiltering(list, domains, flattened));
            }
            Sugar.runInParallel(tasks);
            Collection<Block> retVal = this.filterRedundantBlocks(flattened, domains);
            return retVal;
        }
        return Sugar.listFromCollections(candidates);
    }

    public Collection<Block> filterRedundantBlocks(Collection<Block> candidates, Map<Integer, Domain[]> domains) {
        if (Settings.USE_REDUNDANCY_FILTERING) {
            ConcurrentHashMap<List<Domain>, Block> retVal = new ConcurrentHashMap<List<Domain>, Block>();
            int index = 0;
            for (Block block : candidates) {
                Domain[] dom = domains.get(block.id());
                List<Domain> domainsInList = Arrays.asList(dom);
                Block equivalent = (Block)retVal.get(domainsInList);
                if (Domain.countNonEmpty(dom, this.getMask()) >= this.minFrequencyOnCoveredClass() && (equivalent == null || block.size() < equivalent.size())) {
                    retVal.put(domainsInList, block);
                }
                ++index;
            }
            return retVal.values();
        }
        return Sugar.listFromCollections(candidates);
    }

    public Collection<JoinAndInt> filterRedundantCombinationsOfBlocksInParallel(Collection<JoinAndInt> candidates, Map<Integer, Domain[]> domains) {
        if (Settings.USE_REDUNDANCY_FILTERING) {
            int processorCount = Settings.PROCESSORS;
            List<Collection<JoinAndInt>> lists = Sugar.splitCollection(candidates, processorCount);
            Vector<JoinAndInt> flattened = new Vector<JoinAndInt>();
            ArrayList<JoinRedundancyFiltering> tasks = new ArrayList<JoinRedundancyFiltering>();
            for (Collection<JoinAndInt> list : lists) {
                tasks.add(new JoinRedundancyFiltering(list, domains, flattened));
            }
            Sugar.runInParallel(tasks);
            Collection<JoinAndInt> retVal = this.filterRedundantCombinationsOfBlocks(flattened, domains);
            return retVal;
        }
        return Sugar.listFromCollections(candidates);
    }

    public Collection<JoinAndInt> filterRedundantCombinationsOfBlocks(Collection<JoinAndInt> candidates, Map<Integer, Domain[]> domains) {
        if (Settings.USE_REDUNDANCY_FILTERING) {
            ConcurrentHashMap<List<Domain>, JoinAndInt> retVal = new ConcurrentHashMap<List<Domain>, JoinAndInt>();
            for (JoinAndInt pair : candidates) {
                Join candidate = (Join)pair.r;
                Domain[] dom = domains.get(candidate.id());
                List<Domain> domainsInList = Arrays.asList(dom);
                JoinAndInt equivalent = (JoinAndInt)retVal.get(domainsInList);
                if (Domain.countNonEmpty(dom, this.getMask()) < this.minFrequencyOnCoveredClass() || equivalent != null && candidate.numLiterals() >= ((Join)equivalent.r).numLiterals()) continue;
                retVal.put(domainsInList, new JoinAndInt(candidate, (Integer)pair.s));
            }
            return retVal.values();
        }
        return Sugar.listFromCollections(candidates);
    }

    public Collection<Block> filterIrrelevantBlocksInParallel(Collection<Block> candidates, Map<Integer, Domain[]> computedDomains) {
        if (Settings.USE_REDUNDANCY_FILTERING) {
            candidates = Sugar.listFromCollections(candidates);
            ConcurrentHashMap<Integer, Domain[]> domainsOfCombinations = new ConcurrentHashMap<Integer, Domain[]>();
            ArrayList<Integer> candidateIDs = new ArrayList<Integer>();
            for (Block block : candidates) {
                domainsOfCombinations.put(block.id(), computedDomains.get(block.id()));
                candidateIDs.add(block.id());
            }
            Set filteredIDs = Sugar.setFromCollections(new IrrelevancyFiltering(candidateIDs, domainsOfCombinations, this.getMask(), this.getNegMask()).filter());
            ArrayList<Block> retVal = new ArrayList<Block>();
            for (Block block : candidates) {
                if (!filteredIDs.contains(block.id())) continue;
                retVal.add(block);
            }
            return retVal;
        }
        return Sugar.listFromCollections(candidates);
    }

    public Collection<JoinAndInt> filterIrrelevantCombinationsOfBlocksInParallel(Collection<JoinAndInt> candidates, Map<Integer, Domain[]> domains) {
        if (Settings.USE_REDUNDANCY_FILTERING) {
            candidates = Sugar.listFromCollections(candidates);
            ConcurrentHashMap<Integer, Domain[]> domainsOfCombinations = new ConcurrentHashMap<Integer, Domain[]>();
            ArrayList<Integer> candidateIDs = new ArrayList<Integer>();
            for (JoinAndInt pair : candidates) {
                domainsOfCombinations.put(((Join)pair.r).id(), domains.get(((Join)pair.r).id()));
                candidateIDs.add(((Join)pair.r).id());
            }
            Set filteredIDs = Sugar.setFromCollections(new IrrelevancyFiltering(candidateIDs, domainsOfCombinations, this.getMask(), this.getNegMask()).filter());
            ArrayList<JoinAndInt> retVal = new ArrayList<JoinAndInt>();
            for (JoinAndInt pair : candidates) {
                if (!filteredIDs.contains(((Join)pair.r).id())) continue;
                retVal.add(pair);
            }
            return retVal;
        }
        return Sugar.listFromCollections(candidates);
    }

    public int minFrequencyOnCoveredClass() {
        return this.minFrequencyOnCoveredClass;
    }

    public void setMinFrequencyOnCoveredClass(int minFrequencyOnCoveredClass) {
        this.minFrequencyOnCoveredClass = minFrequencyOnCoveredClass;
    }

    public boolean[] getMask() {
        return this.mask;
    }

    public boolean[] getNegMask() {
        return this.negMask;
    }

    private class BlockRedundancyFiltering
    implements Runnable {
        private Collection<Block> posFeatures;
        private List<Block> output;
        private Map<Integer, Domain[]> domains;

        public BlockRedundancyFiltering(Collection<Block> combinations, Map<Integer, Domain[]> domains, List<Block> output) {
            this.posFeatures = combinations;
            this.domains = domains;
            this.output = output;
        }

        @Override
        public void run() {
            Collection<Block> result = Pruning.this.filterRedundantBlocks(this.posFeatures, this.domains);
            for (Block posFeat : result) {
                this.output.add(posFeat);
            }
        }
    }

    private class JoinRedundancyFiltering
    implements Runnable {
        private Collection<JoinAndInt> combinations;
        private Vector<JoinAndInt> output;
        private Map<Integer, Domain[]> domains;

        public JoinRedundancyFiltering(Collection<JoinAndInt> combinations, Map<Integer, Domain[]> domains, Vector<JoinAndInt> output) {
            this.combinations = combinations;
            this.domains = domains;
            this.output = output;
        }

        @Override
        public void run() {
            Collection<JoinAndInt> result = Pruning.this.filterRedundantCombinationsOfBlocks(this.combinations, this.domains);
            for (JoinAndInt pair : result) {
                this.output.add(pair);
            }
        }
    }
}

