/*
 * Decompiled with CFR 0.152.
 */
package ida.utils;

import Jama.Matrix;
import ida.utils.MatrixUtils;
import ida.utils.VectorUtils;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Statistics {
    public static double[] mean(double[][] data) {
        int i;
        double[] mean = new double[data[0].length];
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < mean.length; ++j) {
                int n = j;
                mean[n] = mean[n] + data[i][j];
            }
        }
        i = 0;
        while (i < mean.length) {
            int n = i++;
            mean[n] = mean[n] / (double)data.length;
        }
        return mean;
    }

    public static double[] mean(double[][] data, double[] weights) {
        int i;
        double weightSum = VectorUtils.sum(weights);
        double[] mean = new double[data[0].length];
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < mean.length; ++j) {
                int n = j;
                mean[n] = mean[n] + weights[i] * data[i][j];
            }
        }
        i = 0;
        while (i < mean.length) {
            int n = i++;
            mean[n] = mean[n] / weightSum;
        }
        return mean;
    }

    public static double[][] covariance(double[][] data, double[] weights) {
        double weightSum = VectorUtils.sum(weights);
        double[] mean = Statistics.mean(data, weights);
        double[][] cov = new double[data[0].length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                for (int k = 0; k < data[0].length; ++k) {
                    double[] dArray = cov[j];
                    int n = k;
                    dArray[n] = dArray[n] + weights[i] * (data[i][j] - mean[j]) * (data[i][k] - mean[k]);
                }
            }
        }
        MatrixUtils.multiply(cov, 1.0 / weightSum);
        return cov;
    }

    public static double[][] covariance(double[][] data) {
        double[] mean = Statistics.mean(data);
        double[][] cov = new double[data[0].length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                for (int k = 0; k < data[0].length; ++k) {
                    double[] dArray = cov[j];
                    int n = k;
                    dArray[n] = dArray[n] + (data[i][j] - mean[j]) * (data[i][k] - mean[k]);
                }
            }
        }
        if (data.length > 1) {
            MatrixUtils.multiply(cov, 1.0 / (double)(data.length - 1));
        } else {
            MatrixUtils.multiply(cov, 1.0 / (double)data.length);
        }
        return cov;
    }

    public static double[] variance(double[][] data) {
        double[] mean = Statistics.mean(data);
        double[] var = new double[data[0].length];
        for (double[] sample : data) {
            for (int j = 0; j < sample.length; ++j) {
                int n = j;
                var[n] = var[n] + (sample[j] - mean[j]) * (sample[j] - mean[j]);
            }
        }
        int i = 0;
        while (i < var.length) {
            int n = i++;
            var[n] = var[n] / (double)(data.length - 1);
        }
        return var;
    }

    public static double spearmanCorrelation(double[] dataX, double[] dataY) {
        int j;
        double average;
        int count;
        int i;
        ArrayList<Pair<Double, Integer>> pairsX = new ArrayList<Pair<Double, Integer>>();
        ArrayList<Pair<Double, Integer>> pairsY = new ArrayList<Pair<Double, Integer>>();
        for (i = 0; i < dataX.length; ++i) {
            pairsX.add(new Pair<Double, Integer>(dataX[i], i));
            pairsY.add(new Pair<Double, Integer>(dataY[i], i));
        }
        Collections.sort(pairsX, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Double)o1.r - (Double)o2.r);
            }
        });
        Collections.sort(pairsY, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Double)o1.r - (Double)o2.r);
            }
        });
        for (i = 0; i < pairsX.size(); ++i) {
            count = 0;
            for (int j2 = i + 1; j2 < pairsX.size() && ((Double)((Pair)pairsX.get((int)i)).r).equals(((Pair)pairsX.get((int)j2)).r); ++j2) {
                count = j2 - i;
            }
            average = (double)i + (double)count / 2.0;
            for (j = 0; j <= count; ++j) {
                ((Pair)pairsX.get((int)(i + j))).r = average;
            }
            i += count;
        }
        for (i = 0; i < pairsY.size(); ++i) {
            count = 0;
            for (int j3 = i + 1; j3 < pairsY.size() && ((Double)((Pair)pairsY.get((int)i)).r).equals(((Pair)pairsY.get((int)j3)).r); ++j3) {
                count = j3 - i;
            }
            average = (double)i + (double)count / 2.0;
            for (j = 0; j <= count; ++j) {
                ((Pair)pairsY.get((int)(i + j))).r = average;
            }
            i += count;
        }
        Collections.sort(pairsX, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Integer)o1.s - (Integer)o2.s);
            }
        });
        Collections.sort(pairsY, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Integer)o1.s - (Integer)o2.s);
            }
        });
        double avgRank = (double)(pairsX.size() - 1) / 2.0;
        double sumNumerator = 0.0;
        double sumVarX = 0.0;
        double sumVarY = 0.0;
        for (int i2 = 0; i2 < pairsX.size(); ++i2) {
            sumNumerator += ((Double)((Pair)pairsX.get((int)i2)).r - avgRank) * ((Double)((Pair)pairsY.get((int)i2)).r - avgRank);
            sumVarX += ((Double)((Pair)pairsX.get((int)i2)).r - avgRank) * ((Double)((Pair)pairsX.get((int)i2)).r - avgRank);
            sumVarY += ((Double)((Pair)pairsY.get((int)i2)).r - avgRank) * ((Double)((Pair)pairsY.get((int)i2)).r - avgRank);
        }
        return sumNumerator / Math.sqrt(sumVarX * sumVarY);
    }

    public static double[] spearmanCorrelation(double[][] data) {
        double[] dataY = new double[data.length];
        double[] dataX = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            dataY[i] = data[i][data[0].length - 1];
        }
        double[] correlationCoeficients = new double[data[0].length];
        for (int i = 0; i < data[0].length - 1; ++i) {
            for (int j = 0; j < data.length; ++j) {
                dataX[j] = data[j][i];
            }
            correlationCoeficients[i] = Statistics.spearmanCorrelation(dataX, dataY);
        }
        correlationCoeficients[data[0].length - 1] = 1.0;
        return correlationCoeficients;
    }

    public static double[][] standardizeDataMatrix(double[][] data) {
        int i;
        double[][] standardizedData = new double[data.length][data[0].length];
        double[] mean = Statistics.mean(data);
        double[] dev = Statistics.variance(data);
        for (i = 0; i < dev.length; ++i) {
            dev[i] = Math.sqrt(dev[i]);
        }
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                standardizedData[i][j] = dev[j] != 0.0 ? (data[i][j] - mean[j]) / dev[j] : data[i][j] - mean[j];
            }
        }
        return standardizedData;
    }

    public static double[][] logDataMatrix(double[][] data) {
        double[][] standardizedData = new double[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                standardizedData[i][j] = Math.log(1.0 + data[i][j]);
            }
        }
        return standardizedData;
    }

    public static double[][] sigmoidDataMatrix(double[][] data) {
        double[][] standardizedData = new double[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                standardizedData[i][j] = 1.0 / (1.0 + Math.exp(-data[i][j]));
            }
        }
        return standardizedData;
    }

    public static double klDivergence(double[] mean1, double[][] cov1, double[] mean2, double[][] cov2) {
        double[][] meanArray1 = new double[mean1.length][1];
        double[][] meanArray2 = new double[mean2.length][1];
        for (int i = 0; i < mean1.length; ++i) {
            meanArray1[i][0] = mean1[i];
            meanArray2[i][0] = mean2[i];
        }
        Matrix meanDifference = new Matrix(meanArray2).minus(new Matrix(meanArray1));
        return 0.5 * (Math.log(new Matrix(cov2).det() / new Matrix(cov1).det()) + new Matrix(cov2).inverse().times(new Matrix(cov1)).trace() + meanDifference.transpose().times(new Matrix(cov2).inverse()).times(meanDifference).trace() - (double)mean1.length);
    }
}

