/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class VectorSet {
    private static Random random = new Random();
    private int startTwoPow = 5;
    private int capacity = BigInteger.probablePrime(this.startTwoPow, random).intValue();
    private int size;
    private int[][] data = new int[this.capacity][];
    private List<int[]>[] collisions = new List[this.capacity];

    public final void add(int[] vector) {
        int hash = this.hash(vector);
        if (this.data[hash] == null) {
            this.data[hash] = vector;
            ++this.size;
        } else {
            if (this.collisions[hash] == null) {
                this.collisions[hash] = new ArrayList<int[]>(1);
            }
            for (int[] array : this.collisions[hash]) {
                if (!Arrays.equals(array, vector)) continue;
                return;
            }
            this.collisions[hash].add(vector);
            ++this.size;
        }
        if ((double)this.size >= (double)this.capacity / 1.5 + 1.0) {
            this.resize();
        }
    }

    private void resize() {
        ++this.startTwoPow;
        this.capacity = BigInteger.probablePrime(this.startTwoPow, random).intValue();
        int[][] oldData = this.data;
        List<int[]>[] oldCollisions = this.collisions;
        this.data = new int[this.capacity][];
        this.collisions = new List[this.capacity];
        for (int i = 0; i < oldData.length; ++i) {
            if (oldData[i] == null) continue;
            this.add(oldData[i]);
        }
        for (List<int[]> list : oldCollisions) {
            if (list == null) continue;
            for (int[] array : list) {
                this.add(array);
            }
        }
    }

    public final boolean contains(int[] vector) {
        int hash = this.hash(vector);
        int[] array0 = this.data[hash];
        if (array0 != null) {
            if (array0.length == vector.length) {
                boolean equal = true;
                for (int i = 0; i < vector.length; ++i) {
                    if (array0[i] == vector[i]) continue;
                    equal = false;
                    break;
                }
                if (equal) {
                    return true;
                }
            }
            if (this.collisions[hash] != null) {
                block1: for (int[] array : this.collisions[hash]) {
                    if (array.length != vector.length) continue;
                    for (int i = 0; i < array.length; ++i) {
                        if (array[i] != vector[i]) continue block1;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private int hash(int[] vector) {
        int ret = 0;
        int cap = this.capacity;
        for (int i = 0; i < vector.length; ++i) {
            ret = (ret + 1) * (vector[i] + 1 + i * i * i) % cap;
        }
        if (ret < 0) {
            ret = (cap - ret) % cap;
        }
        return ret;
    }
}

